<!DOCTYPE html>
<html class="" lang="fr">

  <head>
    <link rel="icon" data-savepage-href="https://www.monabanq.com/fr/images/favicon/favicon-32x32.png" href="data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAACAAAAAgCAMAAABEpIrGAAABUFBMVEX///+61ga51QK61gW51gO51QO61gS51gS61gfX52292BC81w79/vn///641QDW52zQ41Xj7pnL4EX8/fX+//3+//zB2iHe64e92BHi7pb7/fLG3TL8/fTW52vM4Ufm8KT6/O7J3zz5++jW523u9cTw9sri7pjy99DX527m8KP3+uPS5Fv6/Ozq87PP41TI3jjV5mfd64XA2h3a6Xvf7I3+/vzw9snj75v6/O38/fPN4UvI3zrM4UbB2h7h7ZTV5mbI3jnU5WPx98zG3TDP41Px983g7I7b6n3w9svs87rZ6HXr87XU5WS61gjI3jfz+NTO4k/g7Y/a6Xjr87i+2Rb9/vjs9LnT5WLN4UzR5Fjs9Lvw9sfp8rDz+NO+2BT8/fb2+t+/2Rq81w/1+dre7InK3z78/fLd64T1+dvQ41e81wzs9Lrz+NK/2Rnd64O+2BXtYF7RAAAA+ElEQVR4XuXS1XLDQAyG0ZWWDGFOmZmZmZmZmfv+3FUmtd1XSHX1zT/nUqz0Lhws/9KLq2fvL+zpYm22p3cuzdj1/t7GdH9n2S9I7rg59/nj1UFEkdk9vD++MiWdruYiqKhCrmOPqDgA6NzDiVTcJMdEmwcA3jh8H2zSfmdp59ZVYC4fAOrz63xlqY8EnB5dro+ZwvaQD6xsirFUVALorRszDk0qEN0dHlCZbco4AIhlqtEJCaK8zgNiZoSy2gLgeapQDP+C2hoPxP8rSERkZLwAWjVKbCqABTPOG0A9VWlHB5KUjS22Xd9ANThsxmzxZ8J0fgbHUrkfUgkmBbEViY0AAAAASUVORK5CYII=">
    <title>Authentification | Monabanq - Banque en ligne</title>
    <meta name="description" content="Connectez-vous à votre espace client Monabanq pour consulter les informations sur vos comptes bancaires, comptes courants, livrets, crédits, ou assurances.">

    <meta charset="utf-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge,chrome=1">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <style data-savepage-href="https://cdnii.e-i.com/INGR/sd/monabanq_2017/4.101.19/fr/css/ei_base_vitrine.css" type="text/css">
      .e_invisible {
        position: absolute;
        top: 0;
        left: -9000px;
        width: 1px;
        height: 1px;
        overflow: hidden;
        margin: 0;
        padding: 0
      }

      #ei_tpl_contener,
      #ei_tpl_content,
      #ei_tpl_footer,
      #ei_tpl_header {
        font-size: 1em
      }

      ul#e_raccourci {
        position: absolute;
        left: 10px;
        top: 0;
        z-index: 2500
      }

      ul#e_raccourci li {
        float: left;
        list-style: none
      }

      ul#e_raccourci li a {
        display: inline-block;
        text-align: center;
        text-decoration: none;
        font-size: 14px;
        font-weight: 700;
        position: absolute;
        top: -9000px;
        width: 200px;
        color: #fff;
        background-color: #595959;
        padding: 5px
      }

      ul#e_raccourci li a:focus,
      ul#e_raccourci li a:hover {
        top: 10px
      }

      ul.ei_quicklink {
        position: absolute;
        top: 0;
        left: 10px;
        z-index: 2500
      }

      ul.ei_quicklink li {
        float: left;
        list-style: none
      }

      ul.ei_quicklink li a {
        display: inline-block;
        text-align: center;
        text-decoration: none;
        font-size: 14px;
        font-weight: 600;
        position: absolute;
        top: -9000px;
        width: 200px;
        color: #fff;
        background-color: #595959;
        padding: 5px
      }

      ul.ei_quicklink li a:focus,
      ul.ei_quicklink li a:hover {
        top: 10px
      }

      [id^=ei_quicklink_] {
        position: absolute;
        overflow: hidden;
        padding: 0;
        border: 0;
        clip: rect(0, 0, 0, 0);
        -webkit-clip-path: circle(0);
        clip-path: circle(0);
        width: 1px;
        height: 1px;
        margin: -1px;
        white-space: nowrap
      }

      body {
        font-family: "Helvetica Neue", Helvetica, Arial, sans-serif;
        font-size: 14px;
        font-weight: 400;
        color: #333
      }

      @supports (font-variation-settings:normal) {
        body {
          font-family: "Helvetica Neue", Helvetica, Arial, sans-serif
        }
      }

      /*! normalize.css v3.0.0 */
      html {
        font-family: sans-serif;
        -ms-text-size-adjust: 100%;
        -webkit-text-size-adjust: 100%
      }

      body {
        margin: 0
      }

      article,
      aside,
      details,
      figcaption,
      figure,
      footer,
      header,
      hgroup,
      main,
      nav,
      section,
      summary {
        display: block
      }

      audio,
      canvas,
      progress,
      video {
        display: inline-block;
        vertical-align: baseline
      }

      audio:not([controls]) {
        display: none;
        height: 0
      }

      [hidden],
      template {
        display: none
      }

      a {
        background: 0 0
      }

      a:active,
      a:hover {
        outline: 0
      }

      abbr[title] {
        border-bottom: 1px dotted
      }

      b,
      strong {
        font-weight: 700
      }

      dfn {
        font-style: italic
      }

      h1 {
        font-size: 2em;
        margin: .67em 0
      }

      mark {
        background: #ff0;
        color: #000
      }

      small {
        font-size: 80%
      }

      sub,
      sup {
        font-size: 75%;
        line-height: 0;
        position: relative;
        vertical-align: baseline
      }

      sup {
        top: -.5em
      }

      sub {
        bottom: -.25em
      }

      img {
        border: 0
      }

      svg:not(:root) {
        overflow: hidden
      }

      figure {
        margin: 1em 40px
      }

      hr {
        box-sizing: content-box;
        height: 0
      }

      pre {
        overflow: auto
      }

      code,
      kbd,
      pre,
      samp {
        font-family: monospace, monospace;
        font-size: 1em
      }

      button,
      input,
      optgroup,
      select,
      textarea {
        color: inherit;
        font: inherit;
        margin: 0
      }

      button {
        overflow: visible
      }

      button,
      select {
        text-transform: none
      }

      button,
      html input[type=button],
      input[type=reset],
      input[type=submit] {
        -webkit-appearance: button;
        cursor: pointer
      }

      button[disabled],
      html input[disabled] {
        cursor: default
      }

      button::-moz-focus-inner,
      input::-moz-focus-inner {
        border: 0;
        padding: 0
      }

      input {
        line-height: normal
      }

      input[type=checkbox],
      input[type=radio] {
        box-sizing: border-box;
        padding: 0
      }

      input[type=number]::-webkit-inner-spin-button,
      input[type=number]::-webkit-outer-spin-button {
        height: auto
      }

      input[type=search] {
        -webkit-appearance: textfield;
        box-sizing: content-box
      }

      input[type=search]::-webkit-search-cancel-button,
      input[type=search]::-webkit-search-decoration {
        -webkit-appearance: none
      }

      fieldset {
        border: 1px solid silver;
        margin: 0 2px;
        padding: .35em .625em .75em
      }

      legend {
        border: 0;
        padding: 0
      }

      textarea {
        overflow: auto
      }

      optgroup {
        font-weight: 700
      }

      table {
        border-collapse: collapse;
        border-spacing: 0
      }

      td,
      th {
        padding: 0
      }

      a {
        color: #333
      }

      a:focus,
      a:hover {
        text-decoration: none;
        color: #8fa405
      }

      .g {
        text-align: left !important
      }

      .c {
        text-align: center !important
      }

      .d,
      .mtt,
      .tx {
        text-align: right !important
      }

      .mtt,
      .tx {
        white-space: nowrap
      }

      .vc,
      td.vc {
        vertical-align: middle !important
      }

      .j {
        text-align: justify
      }

      .adroite {
        margin-left: auto
      }

      .agauche {
        margin-right: auto
      }

      .aucentre {
        margin-left: auto;
        margin-right: auto
      }

      .h,
      td.h {
        vertical-align: top
      }

      .b,
      td.b {
        vertical-align: bottom !important
      }

      .ei_sronly {
        position: absolute;
        overflow: hidden;
        padding: 0;
        border: 0;
        clip: rect(0, 0, 0, 0);
        -webkit-clip-path: circle(0);
        clip-path: circle(0);
        width: 1px;
        height: 1px;
        margin: -1px;
        white-space: nowrap
      }

      .ei_sronly_focusable:active,
      .ei_sronly_focusable:focus {
        clip: auto;
        -webkit-clip-path: none;
        clip-path: none;
        height: auto;
        margin: auto;
        overflow: visible;
        width: auto;
        white-space: normal
      }

      @media screen and (max-width:991px) {
        .eir_invisiblesm {
          position: absolute;
          top: -9000px;
          left: -9000px
        }
      }

      @media screen and (max-width:991px) {
        .eir_invisiblexs {
          position: absolute;
          top: -9000px;
          left: -9000px
        }
      }

      .ei_fnblock-hasInvisibleTitle>.ei_titlelabel,
      .ei_gpblock-hasInvisibleTitle>.ei_titlelabel,
      .ei_mainblocfctl-hasInvisibleTitle>.ei_titlelabel {
        position: absolute;
        top: 0;
        left: -9000px;
        overflow: hidden;
        opacity: 0
      }

      .ei_fnblock-hasInvisibleTitle>.ei_fnblock_header .ei_titlelabel,
      .ei_gpblock-hasInvisibleTitle>.ei_gpblock_header .ei_titlelabel,
      .ei_mainblocfctl-hasInvisibleTitle>.ei_mainblocfctl_title .ei_titlelabel {
        position: absolute;
        top: 0;
        left: -9000px;
        overflow: hidden;
        opacity: 0
      }

      .e_invisible:not(fieldset),
      .invisible:not(fieldset) {
        position: absolute;
        top: 0;
        left: -9000px;
        overflow: hidden;
        opacity: 0
      }

      fieldset.invisible {
        position: relative;
        left: 0;
        border: 0;
        clip: initial;
        -webkit-clip-path: initial;
        clip-path: initial;
        width: inherit;
        height: inherit;
        margin-bottom: 5px;
        padding-left: 0;
        padding-right: 0
      }

      abbr.invisible,
      acronym.invisible {
        position: relative;
        left: 0;
        border-bottom: 0;
        cursor: auto
      }

      .masque {
        display: none
      }

      .ei_bigpic .ei_richlink_title span.masque {
        display: none
      }

      table.saisie .ei-saisie__th label.masque,
      table.saisie .ei_saisie__th label.masque,
      table.saisie td label.masque,
      table.saisie th label.masque {
        display: none
      }

      .ei_noscroll,
      html.ei_noscroll,
      html.ei_noscroll body {
        overflow: hidden
      }

      .ei_scroll,
      html.ei_scroll,
      html.ei_scroll body {
        overflow: auto
      }

      .nof {
        clear: both
      }

      .fg,
      .float-left {
        float: left
      }

      .fd,
      .float-right {
        float: right
      }

      .ei_newlb.ei_blocmodal_env .ei_blocmodal .ei_lb_btnskip {
        display: block
      }

      .ei_newlb.ei_blocmodal_env .ei_blocmodal .ei_lb_btnskip_icon {
        position: relative;
        margin-right: 11px
      }

      .ei_newlb.ei_blocmodal_env .ei_blocmodal .ei_lb_btnskip_icon:after {
        content: "\F0329";
        font-family: fts_picto;
        speak: none;
        font-style: normal;
        font-weight: 400;
        font-variant: normal;
        text-transform: none;
        line-height: 1;
        -webkit-font-smoothing: antialiased;
        -moz-osx-font-smoothing: grayscale;
        vertical-align: middle;
        font-size: 1.4em;
        position: absolute;
        top: 0
      }

      @media screen and (max-width:991px) {
        .ei_newlb.ei_blocmodal_env .ei_blocmodal .ei_lb_btnskip {
          padding-bottom: 12px
        }
      }

      .blocmsg,
      .bloctxt {
        overflow: hidden;
        margin-bottom: 10px;
        padding: 15px 0 15px 27px;
        border: 0
      }

      .blocmsg:empty,
      .bloctxt:empty {
        display: none
      }

      .ERREUR,
      .alerte,
      .ei_promote,
      .err,
      .info,
      .succes {
        padding-left: 27px
      }

      .ERREUR .ei_paraghtitle,
      .alerte .ei_paraghtitle,
      .ei_promote .ei_paraghtitle,
      .err .ei_paraghtitle,
      .info .ei_paraghtitle,
      .succes .ei_paraghtitle {
        font-size: 2em;
        font-weight: 700;
        margin-top: 0
      }

      .ERREUR .ei_intro,
      .alerte .ei_intro,
      .ei_promote .ei_intro,
      .err .ei_intro,
      .info .ei_intro,
      .succes .ei_intro {
        margin: 10px 0;
        font-style: italic
      }

      .alerte {
        background: #fff none;
        color: #a66152;
        border: 1px solid #ffa200
      }

      .alerte .ei_paraghtitle,
      .alerte a,
      .alerte p,
      .alerte ul li {
        color: #a66152
      }

      .alerte .ei_paraghtitle a,
      .alerte a a,
      .alerte p a,
      .alerte ul li a {
        color: #a66152
      }

      .alerte .ei_paraghtitle:before,
      .alerte a:before,
      .alerte p:before,
      .alerte ul li:before {
        color: #a66152 !important
      }

      .ERREUR,
      div.err {
        color: red;
        position: relative;
        background: #fff none;
        border: 1px solid red
      }

      .ERREUR .ei_paraghtitle,
      .ERREUR a,
      .ERREUR li,
      .ERREUR p,
      div.err .ei_paraghtitle,
      div.err a,
      div.err li,
      div.err p {
        color: red
      }

      .ERREUR .ei_paraghtitle a,
      .ERREUR a a,
      .ERREUR li a,
      .ERREUR p a,
      div.err .ei_paraghtitle a,
      div.err a a,
      div.err li a,
      div.err p a {
        color: red
      }

      .ERREUR .ei_paraghtitle:before,
      .ERREUR a:before,
      .ERREUR li:before,
      .ERREUR p:before,
      div.err .ei_paraghtitle:before,
      div.err a:before,
      div.err li:before,
      div.err p:before {
        color: red !important
      }

      .ei_err,
      ul.err {
        border: 1px solid red !important;
        background-color: #fff
      }

      p.err {
        color: red;
        margin-top: 2px;
        margin-bottom: 2px
      }

      p.err strong {
        font-weight: 400
      }

      .info {
        color: #494949;
        background: #fff none;
        border: 2px solid #e2e2e2
      }

      .info .ei_paraghtitle,
      .info a,
      .info p,
      .info ul li {
        color: #494949
      }

      .info .ei_paraghtitle a,
      .info a a,
      .info p a,
      .info ul li a {
        color: #494949
      }

      .info .ei_paraghtitle:before,
      .info a:before,
      .info p:before,
      .info ul li:before {
        color: #494949 !important
      }

      .succes {
        color: #6d7d04;
        background: #fff none;
        border: 1px solid #bad606
      }

      .succes .ei_paraghtitle,
      .succes a,
      .succes p,
      .succes ul li {
        color: #6d7d04
      }

      .succes .ei_paraghtitle a,
      .succes a a,
      .succes p a,
      .succes ul li a {
        color: #6d7d04
      }

      .succes .ei_paraghtitle a:hover,
      .succes a a:hover,
      .succes p a:hover,
      .succes ul li a:hover {
        color: #6d7d04
      }

      .succes .ei_paraghtitle:before,
      .succes a:before,
      .succes p:before,
      .succes ul li:before {
        color: #6d7d04 !important
      }

      div.ei_promote {
        color: #fff;
        background: #bad606;
        border: 1px solid #fff
      }

      div.ei_promote .ei_paraghtitle,
      div.ei_promote a,
      div.ei_promote p,
      div.ei_promote ul li {
        color: #fff
      }

      div.ei_promote .ei_paraghtitle:focus,
      div.ei_promote .ei_paraghtitle:hover,
      div.ei_promote a:focus,
      div.ei_promote a:hover,
      div.ei_promote p:focus,
      div.ei_promote p:hover,
      div.ei_promote ul li:focus,
      div.ei_promote ul li:hover {
        color: #fff
      }

      div.ei_promote .ei_paraghtitle a,
      div.ei_promote a a,
      div.ei_promote p a,
      div.ei_promote ul li a {
        color: #fff
      }

      div.ei_promote .ei_paraghtitle a:focus,
      div.ei_promote .ei_paraghtitle a:hover,
      div.ei_promote a a:focus,
      div.ei_promote a a:hover,
      div.ei_promote p a:focus,
      div.ei_promote p a:hover,
      div.ei_promote ul li a:focus,
      div.ei_promote ul li a:hover {
        color: #fff
      }

      div.ei_promote .ei_paraghtitle:before,
      div.ei_promote a:before,
      div.ei_promote p:before,
      div.ei_promote ul li:before {
        color: #fff !important
      }

      div.ei_promote big big {
        font-size: 1.25em
      }

      div.ei_promote small {
        font-size: .875em
      }

      div.alerte.ei_custicon:after,
      div.alerte.ei_custicon:before,
      div.ei_promote.ei_custicon:after,
      div.ei_promote.ei_custicon:before,
      div.err.ei_custicon:after,
      div.err.ei_custicon:before,
      div.info.ei_custicon:after,
      div.info.ei_custicon:before,
      div.succes.ei_custicon:after,
      div.succes.ei_custicon:before {
        display: none !important
      }

      div.alerte.ei_custicon span[class*=ei_gly_]:before,
      div.ei_promote.ei_custicon span[class*=ei_gly_]:before,
      div.err.ei_custicon span[class*=ei_gly_]:before,
      div.info.ei_custicon span[class*=ei_gly_]:before,
      div.succes.ei_custicon span[class*=ei_gly_]:before {
        position: absolute;
        top: 10px;
        left: 10px;
        font-size: 20px
      }

      .blocmsg,
      .bloctxt {
        position: relative
      }

      div.alerte,
      div.ei_promote,
      div.err,
      div.info,
      div.succes {
        padding-left: 40px
      }

      div.alerte:before,
      div.ei_promote:before,
      div.err:before,
      div.info:before,
      div.succes:before {
        font-family: fts_picto;
        left: 5px;
        line-height: 1;
        position: absolute;
        text-transform: none;
        font-size: 20px;
        top: 5px
      }

      div.alerte:before {
        content: "\F001C"
      }

      div.info:before {
        content: "\F0518"
      }

      div.err:before {
        content: "\F011D"
      }

      div.succes:before {
        content: "\F071D"
      }

      div.ei_promote:before {
        content: "\F0410";
        font-size: 25px;
        left: 8px;
        top: 6px
      }

      a:active,
      a:focus,
      a:hover,
      a:visited,
      button:active,
      button:focus,
      button:hover,
      button:visited,
      li:active,
      li:focus,
      li:hover,
      li:visited {
        outline-color: #bad606;
        outline: 0
      }

      ::-moz-focus-inner {
        border: 0
      }

      * {
        box-sizing: border-box
      }

      body:not(.ei_nobackground) {
        background-color: #f0f1f3
      }

      body.ei_nobackground {
        background-color: #f0f1f3
      }

      html.noscroll {
        overflow: hidden;
        position: relative;
        height: 100%
      }

      html.noscroll body {
        overflow: hidden
      }

      html.noscroll #ei_tpl_fullsite {
        position: initial
      }

      #ei_tpl_coleft {
        background-color: #131313;
        position: fixed;
        left: 0;
        top: 0;
        bottom: 0;
        z-index: 1202;
        display: inline-flex;
        width: 16.66666667%;
        max-width: 16.66666667%
      }

      #ei_tpl_coleft ul li a {
        text-decoration: none
      }

      body.menuOpen #ei_tpl_coleft {
        width: auto
      }

      #ei_tpl_colright {
        margin-left: 16.66666667%
      }

      #ei_tpl_content {
        padding-top: 60px;
        max-width: 100%
      }

      .ei_tpl_transac #ei_tpl_content {
        margin: 0 auto;
        padding-left: 30px;
        padding-right: 30px;
        padding-bottom: 10px;
        margin-left: auto;
        margin-right: auto;
        max-width: 1600px;
        background-color: #fff;
        box-shadow: 0 0 3px 0 #969696
      }

      .ei_tpl_transac.ei_nobackground #ei_tpl_content {
        background-color: transparent;
        box-shadow: 0 0 0 0 #969696
      }

      #ei_tpl_logo {
        margin-top: 0;
        max-width: 100%
      }

      #ei_tpl_logo a {
        display: block;
        padding: 35px 22px
      }

      #ei_tpl_logo a img {
        display: block;
        max-width: 180px;
        border: 1px dashed #131313;
        transition: border-color .2s linear
      }

      #ei_tpl_logo a:focus img {
        border-color: #797979
      }

      #ei_tpl_logo_m {
        display: none;
        align-items: center;
        padding-top: 5px
      }

      #ei_tpl_logo_m a {
        padding: 0 5px;
        font-size: 18px;
        text-align: center
      }

      #ei_tpl_logo_m a img {
        display: inline-block;
        width: auto;
        height: auto;
        margin: 0 auto;
        max-height: calc(50px - 10px)
      }

      .main_header {
        display: flex;
        margin: 5px
      }

      #ei_tpl_ariane {
        flex: 1 0 auto;
        padding-top: 10px
      }

      #ei_tpl_ariane a,
      #ei_tpl_ariane span {
        display: inline-block;
        text-decoration: none !important;
        float: left
      }

      #ei_tpl_ariane>a {
        border-bottom: 1px dotted #494949;
        text-decoration: none;
        color: #494949;
        transition: border-color .2s linear
      }

      #ei_tpl_ariane>a:focus,
      #ei_tpl_ariane>a:hover {
        border-color: #f0f1f3;
        color: #8fa405
      }

      #ei_tpl_ariane span {
        color: #000
      }

      #ei_tpl_ariane span.e_ariane_img {
        color: #494949;
        padding: 0 5px
      }

      #ei_tpl_ariane span.e_ariane_img:before {
        content: ">"
      }

      #ei_tpl_ariane>a:first-child {
        overflow: hidden;
        line-height: 200px;
        width: 25px;
        height: 20px;
        position: relative;
        border: 0
      }

      #ei_tpl_ariane>a:first-child:before {
        position: absolute;
        left: 0;
        top: 0;
        content: "\F0559";
        font-family: fts_picto;
        speak: none;
        font-style: normal;
        font-weight: 400;
        font-variant: normal;
        text-transform: none;
        line-height: 1;
        -webkit-font-smoothing: antialiased;
        -moz-osx-font-smoothing: grayscale;
        font-size: 16px
      }

      .ei_tpl_conseiller2 #ei_tpl_monabanq_bloc_conseiller,
      .ei_tpl_conseiller2 .c {
        background-color: #e2e2e2;
        border-radius: 5px;
        padding: 10px;
        border: 1px solid #fff;
        border-top: 0;
        border-left: 0
      }

      .ei_tpl_conseiller2 #ei_tpl_monabanq_bloc_conseiller p,
      .ei_tpl_conseiller2 .c p {
        margin: 0
      }

      .ei_tpl_conseiller2 #ei_tpl_monabanq_bloc_conseiller p.ei_tpl_cons_title,
      .ei_tpl_conseiller2 .c p.ei_tpl_cons_title {
        font-weight: 700
      }

      .ei_tpl_conseiller2 #ei_tpl_monabanq_bloc_conseiller a,
      .ei_tpl_conseiller2 .c a {
        border-bottom: 1px dotted #494949
      }

      .ei_tpl_conseiller2 #ei_tpl_monabanq_bloc_conseiller a.ei_tpl_tel,
      .ei_tpl_conseiller2 .c a.ei_tpl_tel {
        position: relative;
        display: inline-block;
        padding-left: 20px
      }

      .ei_tpl_conseiller2 #ei_tpl_monabanq_bloc_conseiller a.ei_tpl_tel:before,
      .ei_tpl_conseiller2 .c a.ei_tpl_tel:before {
        content: "\F08D8";
        font-family: fts_picto;
        speak: none;
        font-style: normal;
        font-weight: 400;
        font-variant: normal;
        text-transform: none;
        line-height: 1;
        -webkit-font-smoothing: antialiased;
        -moz-osx-font-smoothing: grayscale;
        position: absolute;
        left: 0;
        top: 3px
      }

      header.ei_tpl_header {
        display: flex;
        position: fixed;
        left: 16.66666667%;
        top: 0;
        right: 0;
        background-color: #fff;
        margin-bottom: 0;
        box-sizing: border-box;
        padding: 0 0;
        z-index: 1150;
        border-bottom: 1px solid #e2e2e2;
        height: 60px
      }

      header.ei_tpl_header>div {
        border-left: 1px solid #e2e2e2
      }

      header.ei_tpl_header>div:first-child {
        border: 0
      }

      header.ei_tpl_header div.headerpictos {
        display: block !important
      }

      header.ei_tpl_header a.bt_connexion {
        font-weight: 700;
        text-decoration: none;
        display: inline-block;
        height: 100%;
        padding: 0;
        text-align: center;
        position: relative;
        top: 50%;
        -webkit-transform: translateY(-50%);
        transform: translateY(-50%)
      }

      header.ei_tpl_header a.bt_connexion:focus,
      header.ei_tpl_header a.bt_connexion:hover {
        color: #333
      }

      header.ei_tpl_header a.bt_connexion div.verticalcenter {
        height: auto !important;
        position: relative;
        text-align: center;
        top: 50%;
        -webkit-transform: translateY(-50%);
        transform: translateY(-50%)
      }

      header.ei_tpl_header a.bt_connexion div.ei_gly_lock {
        display: inline-block;
        vertical-align: top
      }

      [class*=ei_gly_]:before,
      [class^=ei_gly_]:before {
        line-height: 1
      }

      #ei_tpl_search {
        flex: 1 1 auto;
        background-color: #f2f2f2;
        position: relative
      }

      #ei_tpl_search #input-search {
        width: calc(100% - 35px);
        display: inline-block;
        vertical-align: bottom
      }

      #ei_tpl_search #input-question {
        width: 100%;
        height: 47px;
        border: none;
        margin: 6px 0 auto 20px;
        border-bottom: 2px solid #fff;
        box-sizing: border-box;
        padding-left: 10px
      }

      #ei_tpl_search #input-question:focus {
        border-bottom: 2px solid #bad606
      }

      #ei_tpl_search button#search-head {
        width: 40px;
        height: 46px;
        display: inline-block;
        box-sizing: border-box;
        border: 0;
        border-radius: 0 4px 4px 0;
        background-color: #fff;
        position: absolute;
        top: 7px;
        right: 15px
      }

      #ei_tpl_search button#search-head #search-head-picto:before {
        font-size: 25px
      }

      #ei_tpl_search button#search-head.grey {
        background-color: #bcbcbc
      }

      #ei_tpl_search button#search-head:focus,
      #ei_tpl_search button#search-head:hover {
        background-color: #bcbcbc
      }

      div#search {
        background-color: #f8f8f8
      }

      div#search form {
        height: 59px
      }

      div#search form div.search-block {
        width: calc(100% - 60px)
      }

      div#search form div.search-block input {
        border: none;
        box-shadow: none;
        background-color: #f8f8f8;
        padding-left: 20px;
        width: 100%;
        border: 0
      }

      div#search form button {
        padding: 14px 16px;
        background-color: #f8f8f8;
        height: 100%;
        border: none
      }

      div#search form button:hover {
        background-color: #e2e2e2
      }

      div#search form button div:before {
        font-size: 24px;
        color: #333
      }

      .ei_btheader {
        width: 60px;
        min-width: 60px;
        height: auto;
        cursor: pointer
      }

      .ei_btheader a {
        height: 59px;
        display: block;
        text-decoration: none;
        position: relative;
        transition: background-color .2s linear
      }

      .ei_btheader a:before {
        font-family: fts_picto;
        speak: none;
        font-style: normal;
        font-weight: 400;
        font-variant: normal;
        text-transform: none;
        line-height: 1;
        -webkit-font-smoothing: antialiased;
        -moz-osx-font-smoothing: grayscale;
        position: absolute;
        left: calc(50% - 15px);
        top: calc(50% - 15px)
      }

      .ei_btheader a:focus,
      .ei_btheader a:hover {
        color: #333;
        background-color: #e2e2e2
      }

      .ei_btheader a:focus div.headerpictos,
      .ei_btheader a:hover div.headerpictos {
        color: #333
      }

      .ei_btheader a div.headerpictos {
        text-align: center;
        position: relative;
        top: 50%;
        -webkit-transform: translateY(-50%);
        transform: translateY(-50%)
      }

      .ei_btheader a div.headerpictos:before {
        font-size: 25px
      }

      #ei_tpl_menu_m {
        display: none
      }

      #ei_tpl_menu_m a:before {
        content: "\F0382";
        font-size: 28px
      }

      #ei_tpl_menu_m a div {
        position: absolute;
        right: 5px;
        top: 5px;
        background-color: #bad606;
        display: block;
        padding: 3px;
        color: #000;
        min-width: 20px;
        border-radius: 40px;
        text-align: center;
        box-sizing: border-box
      }

      #ei_tpl_menu_m a div.invisible {
        top: -9999px;
        width: 1px;
        height: 1px
      }

      #ei_tpl_search_m {
        display: none
      }

      #ei_tpl_search_m a:before {
        content: "\F08DE";
        font-size: 28px
      }

      #ei_tpl_search_m a div {
        position: absolute;
        right: 5px;
        top: 5px;
        background-color: #bad606;
        display: block;
        padding: 3px;
        color: #000;
        min-width: 20px;
        border-radius: 40px;
        text-align: center;
        box-sizing: border-box
      }

      #ei_tpl_search_m a div.invisible {
        top: -9999px;
        width: 1px;
        height: 1px
      }

      #ei_tpl_search_m a:before {
        font-size: 19px;
        top: 15px
      }

      #ei_tpl_mailbt a:before {
        content: "\F08CD";
        font-size: 28px
      }

      #ei_tpl_mailbt a div {
        position: absolute;
        right: 5px;
        top: 5px;
        background-color: #bad606;
        display: block;
        padding: 3px;
        color: #000;
        min-width: 20px;
        border-radius: 40px;
        text-align: center;
        box-sizing: border-box
      }

      #ei_tpl_mailbt a div.invisible {
        top: -9999px;
        width: 1px;
        height: 1px
      }

      #ei_tpl_mailbt:before {
        position: relative;
        left: calc(50% - 14px);
        top: calc(50% - 14px)
      }

      #ei_tpl_mailbt a div {
        right: 10px;
        top: 11px;
        line-height: 15px;
        font-size: 11px;
        padding: 0;
        min-width: 15px
      }

      #ei_tpl_rdvbt2 a:before {
        content: "\F06E0";
        font-size: 28px
      }

      #ei_tpl_rdvbt2 a div {
        position: absolute;
        right: 5px;
        top: 5px;
        background-color: #bad606;
        display: block;
        padding: 3px;
        color: #000;
        min-width: 20px;
        border-radius: 40px;
        text-align: center;
        box-sizing: border-box
      }

      #ei_tpl_rdvbt2 a div.invisible {
        top: -9999px;
        width: 1px;
        height: 1px
      }

      #ei_tpl_rdvbt2:before {
        position: relative;
        left: calc(50% - 14px);
        top: calc(50% - 14px)
      }

      #ei_tpl_rdvbt2 a div {
        right: 10px;
        top: 11px;
        line-height: 15px;
        font-size: 11px;
        padding: 0;
        min-width: 15px
      }

      #ei_tpl_blocident {
        max-width: 180px;
        width: 180px;
        border-left: 1px solid #c8c8c8;
        background-color: #e2e2e2;
        text-align: center
      }

      #ei_tpl_blocident #ei_tpl_ident_ok {
        text-align: right
      }

      #ei_tpl_blocident #ei_tpl_ident_ok span {
        display: none
      }

      #ei_tpl_blocident a {
        display: block;
        position: relative;
        height: 59px;
        text-align: left;
        padding: 0;
        background-color: #e2e2e2;
        transition: background-color .2s linear
      }

      #ei_tpl_blocident a:focus,
      #ei_tpl_blocident a:hover {
        background-color: #bcbcbc !important
      }

      #ei_tpl_blocident div.ei_gly_lock {
        display: inline-block !important
      }

      #ei_tpl_blocident #ei_tpl_login a:before {
        content: "Connexion";
        font-family: "Helvetica Neue", Helvetica, Arial, sans-serif;
        font-weight: 700;
        font-size: 1.15em
      }

      #ei_tpl_blocident #ei_tpl_login a:after {
        position: absolute;
        right: 49px;
        top: 18px;
        font-family: fts_picto;
        speak: none;
        font-style: normal;
        font-weight: 400;
        font-variant: normal;
        text-transform: none;
        line-height: 1;
        -webkit-font-smoothing: antialiased;
        -moz-osx-font-smoothing: grayscale;
        font-size: 22px;
        content: "\F036E"
      }

      a#ei_tpl_ident_logout {
        position: relative;
        text-decoration: none
      }

      a#ei_tpl_ident_logout:before {
        content: "Déconnexion";
        font-family: "Helvetica Neue", Helvetica, Arial, sans-serif;
        font-weight: 700;
        font-size: 1.15em;
        line-height: 60px;
        left: 30px;
        position: relative
      }

      a#ei_tpl_ident_logout:after {
        content: "\F03FD";
        position: absolute;
        right: 15px;
        top: 50%;
        -webkit-transform: translateY(-50%);
        transform: translateY(-50%);
        font-size: 22px;
        font-family: fts_picto;
        speak: none;
        font-style: normal;
        font-weight: 400;
        font-variant: normal;
        text-transform: none;
        line-height: 1;
        -webkit-font-smoothing: antialiased;
        -moz-osx-font-smoothing: grayscale
      }

      a#ei_tpl_ident_logout:focus,
      a#ei_tpl_ident_logout:hover {
        color: #333
      }

      .ei_tpl_profil_bt {
        position: absolute;
        left: 0;
        top: 0;
        right: 0;
        bottom: 0;
        z-index: 150;
        background-color: transparent
      }

      .ei_tpl_profil_bt:after {
        content: "\F0098";
        position: absolute;
        right: 4px;
        top: 10px;
        bottom: 10px;
        font-family: fts_picto;
        speak: none;
        font-style: normal;
        font-weight: 400;
        font-variant: normal;
        text-transform: none;
        line-height: 1;
        -webkit-font-smoothing: antialiased;
        -moz-osx-font-smoothing: grayscale;
        font-size: 13px;
        transition: line-height .2s linear;
        border-left: 1px solid #e2e2e2;
        line-height: 37px;
        padding-left: 6px
      }

      .ei_tpl_profil_bt:focus:after,
      .ei_tpl_profil_bt:hover:after {
        color: #000;
        border-left-color: #bcbcbc;
        line-height: 42px
      }

      .ei_tpl_profil_bt:focus {
        border: 2px solid #bad606
      }

      #ei_tpl_profil {
        max-width: 310px;
        flex: 1 1 auto;
        position: relative;
        cursor: pointer;
        height: 59px;
        transition: background-color .2s linear
      }

      #ei_tpl_profil #ei_tpl_ident {
        position: relative;
        padding-left: 50px
      }

      #ei_tpl_profil #ei_tpl_ident:before {
        content: "\F08DA";
        font-family: fts_picto;
        speak: none;
        font-style: normal;
        font-weight: 400;
        font-variant: normal;
        text-transform: none;
        line-height: 1;
        -webkit-font-smoothing: antialiased;
        -moz-osx-font-smoothing: grayscale;
        font-size: 28px;
        position: absolute;
        left: 10px;
        top: 14px
      }

      #ei_tpl_profil #ei_tpl_ident_ok {
        padding-top: 12px
      }

      #ei_tpl_profil a#ei_tpl_profilink {
        position: absolute;
        left: 0;
        right: 0;
        top: 0;
        bottom: 0;
        z-index: 100
      }

      #ei_tpl_profil a#ei_tpl_profilink:after {
        content: "\F0098";
        position: absolute;
        right: 8px;
        top: 15px;
        font-family: fts_picto;
        speak: none;
        font-style: normal;
        font-weight: 400;
        font-variant: normal;
        text-transform: none;
        line-height: 1;
        -webkit-font-smoothing: antialiased;
        -moz-osx-font-smoothing: grayscale;
        font-size: 14px;
        color: #949494
      }

      #ei_tpl_profil span {
        display: block
      }

      #ei_tpl_profil span.ei_tpl_appl_info_presentation_name {
        font-family: "Helvetica Neue", Helvetica, Arial, sans-serif;
        font-weight: 700;
        font-size: 1em;
        padding-right: 21px;
        line-height: 14px
      }

      #ei_tpl_profil span#ei_tpl_ident_infos {
        color: #949494;
        font-size: .85em;
        white-space: nowrap
      }

      #ei_tpl_profil #ei_tpl_appl_info_presentation,
      #ei_tpl_profil #ei_tpl_ident_logout {
        display: none
      }

      .ei_tpl_profilook #ei_tpl_ident {
        position: relative;
        padding-left: 40px;
        padding-right: 40px
      }

      .ei_tpl_profilook #ei_tpl_ident:before {
        content: "\F08DA";
        position: absolute;
        left: 0;
        top: 0;
        font-family: fts_picto;
        speak: none;
        font-style: normal;
        font-weight: 400;
        font-variant: normal;
        text-transform: none;
        line-height: 1;
        -webkit-font-smoothing: antialiased;
        -moz-osx-font-smoothing: grayscale;
        font-size: 30px;
        color: #949494
      }

      .ei_tpl_profilook a#ei_tpl_ident_logout {
        display: none
      }

      .ei_tpl_profilook #ei_tpl_ident_ok span {
        display: block;
        white-space: nowrap
      }

      .ei_tpl_profilook #ei_tpl_ident_ok span#ei_tpl_appl_info_presentation {
        display: none
      }

      .ei_tpl_profilook #ei_tpl_ident_ok span#ei_tpl_ident_infos {
        color: #949494
      }

      .profilMenu_open #ei_tpl_profilmenu {
        left: 0;
        width: 100%
      }

      .profilMenu_open #ei_tpl_profil #ei_tpl_ident {
        display: block
      }

      #ei_tpl_profilmenu {
        position: absolute;
        left: -4000px;
        width: 0;
        top: calc(59px - 1px);
        background-color: #fff;
        padding: 5px 0;
        box-sizing: border-box;
        z-index: 150;
        box-shadow: 0 6px 5px 0 #858585
      }

      #ei_tpl_profilmenu ul {
        margin: 0
      }

      #ei_tpl_profilmenu ul li {
        border-top: 1px solid #d8d8d8
      }

      #ei_tpl_profilmenu ul li p {
        padding: 0;
        margin: 0
      }

      #ei_tpl_profilmenu ul li a {
        display: block;
        position: relative;
        padding: 10px;
        padding-left: 33px;
        text-decoration: none;
        color: #333;
        transition: background-color .2s linear
      }

      #ei_tpl_profilmenu ul li a:before {
        content: "\F05CD";
        font-family: fts_picto;
        speak: none;
        font-style: normal;
        font-weight: 400;
        font-variant: normal;
        text-transform: none;
        line-height: 1;
        -webkit-font-smoothing: antialiased;
        -moz-osx-font-smoothing: grayscale;
        position: absolute;
        left: 5px;
        top: calc(50% - 7px);
        font-size: 14px;
        transition: left .2s linear
      }

      #ei_tpl_profilmenu ul li a:focus,
      #ei_tpl_profilmenu ul li a:hover {
        background-color: #e2e2e2
      }

      #ei_tpl_profilmenu ul li a:focus:before,
      #ei_tpl_profilmenu ul li a:hover:before {
        left: 10px
      }

      #ei_tpl_profilmenu ul li a strong {
        font-weight: 400
      }

      #ei_tpl_profilmenu ul li#LIPreferenceAffichage a:before {
        content: "\F025D"
      }

      #ei_tpl_profilmenu ul li#LIChangMotDePasse a:before {
        content: "\F01B0"
      }

      #ei_tpl_profilmenu ul li#LICoordPersonnelle a:before {
        content: "\F036C"
      }

      #ei_tpl_profilmenu ul li#LIMonContactPrefere a:before {
        content: "\F08B7"
      }

      #ei_tpl_profilmenu ul li#LINewsletters a:before {
        content: "\F08CF"
      }

      #ei_tpl_profilmenu ul li#LIParrainage a:before {
        content: "\F08D5"
      }

      #ei_tpl_profilmenu ul li.e_picto_phone a:before {
        content: "\F03E1"
      }

      #ei_tpl_profilmenu ul li.e_picto_centreinteret a:before {
        content: "\F00E9"
      }

      #ei_tpl_profilmenu ul li.e_profinvestisseur a:before {
        content: "\F0479"
      }

      #ei_tpl_profilmenu ul li.e_picto_rgdp a:before {
        content: "\F01C3"
      }

      #ei_tpl_profilmenu ul li:first-child {
        border: 0
      }

      #fondpopup {
        background-color: #000;
        opacity: .4;
        position: fixed;
        left: 0;
        top: 0;
        right: 0;
        bottom: 0
      }

      #ei_lstcpt_menu_content {
        display: none
      }

      .e_level2_listecompte ul li {
        border-bottom: 1px dotted #949494;
        margin-left: 0 !important
      }

      .e_level2_listecompte ul li a:before {
        height: 0;
        transition: height .2s linear
      }

      .e_level2_listecompte ul li a:focus {
        background-color: #4d4d4d
      }

      .e_level2_listecompte ul li:hover a:before {
        height: 22px
      }

      .e_level2_listecompte ul li span {
        display: block;
        color: #fff
      }

      .e_level2_listecompte ul li span.ei_lstcpt_menu_acc_amount {
        text-align: right
      }

      .e_level2_listecompte ul li span.ei_lstcpt_menu_acc_amount.pos {
        color: #bad606
      }

      .e_level2_listecompte ul li span.ei_lstcpt_menu_acc_amount.neg {
        color: red
      }

      .e_level2_listecompte ul li span.ei_lstcpt_menu_acc_holder,
      .e_level2_listecompte ul li span.ei_lstcpt_menu_acc_number {
        font-family: "Helvetica Neue", Helvetica, Arial, sans-serif;
        font-weight: 500;
        font-size: .85em;
        color: #b3b3b3;
        padding: 0
      }

      #ei_tpl_level0,
      #ei_tpl_level1 {
        overflow: hidden;
        position: fixed;
        top: 0;
        left: 0;
        bottom: 0;
        width: 100%;
        max-width: 250px
      }

      #ei_tpl_level0.show,
      #ei_tpl_level1.show {
        display: block
      }

      #ei_tpl_level0 .menu_h1,
      #ei_tpl_level1 .menu_h1 {
        display: none;
        font-family: "Helvetica Neue", Helvetica, Arial, sans-serif;
        font-weight: 700;
        font-size: 1.3em;
        color: #fff;
        margin-top: 20px;
        margin-bottom: 30px
      }

      #ei_tpl_level0 .mCS-ei-theme.mCSB_scrollTools .mCSB_draggerRail,
      #ei_tpl_level1 .mCS-ei-theme.mCSB_scrollTools .mCSB_draggerRail {
        background-color: #fff;
        opacity: .4
      }

      #ei_tpl_level0 .mCS-ei-theme.mCSB_scrollTools .mCSB_dragger .mCSB_dragger_bar,
      #ei_tpl_level1 .mCS-ei-theme.mCSB_scrollTools .mCSB_dragger .mCSB_dragger_bar {
        width: 3px;
        background-color: #fff;
        opacity: .8
      }

      #ei_tpl_level0.customScrollbar_overflowy,
      #ei_tpl_level1.customScrollbar_overflowy {
        overflow-y: auto
      }

      #ei_tpl_level0 .btRetour,
      #ei_tpl_level1 .btRetour {
        display: none;
        position: fixed;
        left: 0;
        right: 0;
        bottom: 0;
        background-color: #282828
      }

      #ei_tpl_level0 .btRetour a,
      #ei_tpl_level1 .btRetour a {
        position: relative;
        display: block;
        padding: 13px 0 13px 65px;
        color: #fff;
        box-sizing: border-box
      }

      #ei_tpl_level0 .btRetour a:before,
      #ei_tpl_level1 .btRetour a:before {
        content: "\F058E";
        font-size: 20px;
        font-family: fts_picto;
        speak: none;
        font-style: normal;
        font-weight: 400;
        font-variant: normal;
        text-transform: none;
        line-height: 1;
        -webkit-font-smoothing: antialiased;
        -moz-osx-font-smoothing: grayscale;
        position: absolute;
        top: 12px;
        left: 30px;
        -webkit-transform: rotate(180deg);
        transform: rotate(180deg)
      }

      #ei_tpl_level0 ul li,
      #ei_tpl_level1 ul li {
        position: relative;
        margin-bottom: 0
      }

      #ei_tpl_level0 ul li.menu_title,
      #ei_tpl_level1 ul li.menu_title {
        border: 0
      }

      #ei_tpl_level0 ul li.menu_title a,
      #ei_tpl_level1 ul li.menu_title a {
        font-weight: 400;
        font-size: 1em;
        color: #949494;
        pointer-events: none;
        cursor: default;
        text-decoration: none
      }

      #ei_tpl_level0 ul li.menu_title a:before,
      #ei_tpl_level1 ul li.menu_title a:before {
        height: 0
      }

      #ei_tpl_level0 ul li.menu_title+.menuderoulant,
      #ei_tpl_level1 ul li.menu_title+.menuderoulant {
        border: 0
      }

      #ei_tpl_level0 ul li [class*=ei_gly_]:before,
      #ei_tpl_level0 ul li [class^=ei_gly_]:before,
      #ei_tpl_level1 ul li [class*=ei_gly_]:before,
      #ei_tpl_level1 ul li [class^=ei_gly_]:before {
        position: absolute;
        left: 0;
        top: 6px;
        color: #fff;
        opacity: .6
      }

      #ei_tpl_level0 ul li [class*=ei_gly_]:hover:before,
      #ei_tpl_level0 ul li [class^=ei_gly_]:hover:before,
      #ei_tpl_level1 ul li [class*=ei_gly_]:hover:before,
      #ei_tpl_level1 ul li [class^=ei_gly_]:hover:before {
        opacity: 1
      }

      #ei_tpl_level0 ul li [class*=ei_gly_]>a,
      #ei_tpl_level0 ul li [class^=ei_gly_]>a,
      #ei_tpl_level1 ul li [class*=ei_gly_]>a,
      #ei_tpl_level1 ul li [class^=ei_gly_]>a {
        padding-left: 25px !important
      }

      #ei_tpl_level0 ul li a,
      #ei_tpl_level1 ul li a {
        cursor: pointer;
        display: block;
        color: #fff;
        font-family: "Helvetica Neue", Helvetica, Arial, sans-serif;
        font-weight: 700;
        font-size: 1em
      }

      #ei_tpl_level0 ul li a:before,
      #ei_tpl_level1 ul li a:before {
        position: absolute;
        content: "";
        left: 0;
        top: 7px;
        height: 0;
        width: 2px;
        background-color: #bad606;
        transition: height .1s linear
      }

      #ei_tpl_level0 ul li a:focus,
      #ei_tpl_level0 ul li a:hover,
      #ei_tpl_level1 ul li a:focus,
      #ei_tpl_level1 ul li a:hover {
        color: #bad606 !important
      }

      #ei_tpl_level0 ul li a:focus:before,
      #ei_tpl_level0 ul li a:hover:before,
      #ei_tpl_level1 ul li a:focus:before,
      #ei_tpl_level1 ul li a:hover:before {
        height: 22px
      }

      #ei_tpl_level0 ul li.menuderoulant,
      #ei_tpl_level1 ul li.menuderoulant {
        position: relative
      }

      #ei_tpl_level0 ul li.menuderoulant>a,
      #ei_tpl_level1 ul li.menuderoulant>a {
        padding-right: 15px
      }

      #ei_tpl_level0 ul li.menuderoulant>a:after,
      #ei_tpl_level1 ul li.menuderoulant>a:after {
        position: absolute;
        right: 0;
        top: calc(50% - .5em);
        font-family: fts_picto;
        speak: none;
        font-style: normal;
        font-weight: 400;
        font-variant: normal;
        text-transform: none;
        line-height: 1;
        -webkit-font-smoothing: antialiased;
        -moz-osx-font-smoothing: grayscale;
        font-size: 13.2px;
        opacity: 1
      }

      #ei_tpl_level0 ul li.itemClick>a,
      #ei_tpl_level1 ul li.itemClick>a {
        opacity: 1 !important;
        color: #bad606
      }

      #ei_tpl_level0 ul li.itemClick>a:before,
      #ei_tpl_level1 ul li.itemClick>a:before {
        height: 22px
      }

      #ei_tpl_level0 ul li.itemClick>a:after,
      #ei_tpl_level1 ul li.itemClick>a:after {
        color: #bad606
      }

      #ei_tpl_level0 ul li.e_select>a,
      #ei_tpl_level1 ul li.e_select>a {
        color: #bad606
      }

      #ei_tpl_level0 {
        z-index: 1250;
        background-color: #131313;
        box-shadow: 0 0 5px #000
      }

      #ei_tpl_level0 ul li.menuderoulant>a:after {
        content: "\F009A"
      }

      #ei_tpl_level0 ul li a::before {
        left: -10px
      }

      #ei_tpl_level0 li.e_focus {
        background-color: #333
      }

      #ei_tpl_level0 li.e_focus.menuderoulant>a:after {
        -webkit-transform: rotate(90deg);
        transform: rotate(90deg);
        top: 20px
      }

      #ei_tpl_level0 li.e_focus .e_smenu {
        position: static;
        width: 100%;
        height: initial
      }

      #ei_tpl_level0 li.e_focus .e_smenu ul li a:focus {
        background-color: #4d4d4d
      }

      #ei_tpl_level0 li.e_focus .e_smenu ul li.menu_title a {
        border-bottom: 1px solid #ccc;
        padding: 10px 0
      }

      #ei_tpl_level0 li.e_focus .e_smenu ul li.menuderoulant a:after {
        display: none
      }

      .ei_tpl_transac #ei_tpl_level0 nav ul li a {
        white-space: nowrap;
        overflow: hidden;
        text-overflow: ellipsis
      }

      #ei_tpl_level1 {
        padding: 90px 16px 20px 20px;
        background-color: #252525;
        z-index: 1248;
        transition: left .3s linear
      }

      #ei_tpl_level1 .ei_scrollContent {
        padding: 0 16px 20px 20px
      }

      #ei_tpl_level1 .e_smenu {
        display: none
      }

      #ei_tpl_level1 ul li a {
        padding: 10px 10px
      }

      #ei_tpl_level1 ul li.menu_new a:after {
        content: "Nouveau";
        position: absolute;
        left: 10px;
        text-align: 0;
        bottom: -2px;
        background-color: #fff600;
        color: #000;
        font-size: 10px;
        padding: 0 4px
      }

      #ei_tpl_level1 ul li+.menu_title {
        margin-top: 20px
      }

      #ei_tpl_level1 ul li.menuderoulant {
        border-top: 1px dotted #949494
      }

      #ei_tpl_level1 ul li.menuderoulant:first-child {
        border: 0
      }

      #ei_tpl_level1 ul li.menuderoulant>a {
        position: relative;
        font-size: 1.2em
      }

      #ei_tpl_level1 ul li.menuderoulant>a:after {
        content: "\F0098"
      }

      #ei_tpl_level1 ul li.menuderoulant.itemClick>a:after {
        content: "\F009D"
      }

      #ei_tpl_level1 ul li.menuderoulant.itemClick .e_smenu {
        display: block;
        padding-bottom: 30px
      }

      .menu_bg {
        position: fixed;
        top: 0;
        bottom: 0;
        left: 0;
        right: 0;
        background-color: #000;
        opacity: .4;
        z-index: 1200
      }

      .ei_tpl_redac #ei_tpl_menuPrincipal>nav {
        padding-bottom: 100px
      }

      #ei_tpl_menuPrincipal {
        transition: opacity .3s linear
      }

      #ei_tpl_menuPrincipal>nav>ul>li {
        padding: 0 0 5px 22px !important;
        margin-right: 22px
      }

      #ei_tpl_menuPrincipal>nav>ul>li>a {
        color: #fff;
        padding: 10px 15px 10px 0;
        font-family: "Helvetica Neue", Helvetica, Arial, sans-serif;
        font-weight: 700;
        font-size: 1.143em
      }

      #ei_tpl_menuPrincipal>nav>ul>li>.e_smenu {
        position: absolute;
        left: -1000px;
        top: -1000px;
        width: 0;
        height: 0;
        overflow: hidden
      }

      #ei_tpl_menuPrincipal>nav>ul>li>.e_smenu>ul>li {
        margin-bottom: 5px
      }

      #ei_tpl_menuPrincipal>nav>ul>li>.e_smenu>ul>li>a {
        color: #fff;
        padding: 5px 0
      }

      #ei_tpl_menuPrincipal>nav>ul>li>.e_smenu>ul>li>a:after {
        font-size: 10px;
        top: 11px
      }

      #ei_tpl_menuPrincipal>nav>ul>li>.e_smenu>ul>li.e_select:before {
        opacity: 1 !important
      }

      #ei_tpl_menuPrincipal>nav>ul>li>.e_smenu>ul>li.e_select>a {
        color: #bad606;
        opacity: 1 !important
      }

      #ei_tpl_menuPrincipal>nav>ul>li.menuProduit>a {
        position: relative
      }

      #ei_tpl_menuPrincipal>nav>ul>li.menuProduit>a:after {
        content: ""
      }

      #ei_tpl_menuPrincipal>nav>ul>li.menuProduit>.e_smenu {
        position: static;
        width: 100%;
        height: auto;
        overflow: auto;
        margin-top: 10px
      }

      #ei_tpl_menuPrincipal>nav>ul>li.menuProduit>.e_smenu>ul>li>a {
        font-family: "Helvetica Neue", Helvetica, Arial, sans-serif;
        font-weight: 400;
        font-size: 1em;
        opacity: .6;
        padding-right: 15px
      }

      #ei_tpl_menuPrincipal>nav>ul>li.menuProduit>.e_smenu>ul>li>a:before {
        display: none
      }

      #ei_tpl_menuPrincipal>nav>ul>li.menuProduit>.e_smenu>ul>li>a:focus,
      #ei_tpl_menuPrincipal>nav>ul>li.menuProduit>.e_smenu>ul>li>a:hover {
        color: #fff;
        opacity: 1
      }

      #ei_tpl_menuPrincipal>nav>ul>li.menuProduit>.e_smenu>ul>li>a:focus:after,
      #ei_tpl_menuPrincipal>nav>ul>li.menuProduit>.e_smenu>ul>li>a:hover:after {
        opacity: 1
      }

      #ei_tpl_menuPrincipal>nav>ul>li.menuProduit>.e_smenu .e_smenu {
        position: absolute;
        left: -1000px;
        top: -1000px;
        width: 0
      }

      @-webkit-keyframes bgcolor-level2_1 {
        0% {
          background: #131313
        }

        1% {
          background: #131313
        }

        100% {
          background: #3a3a3a
        }
      }

      @keyframes bgcolor-level2_1 {
        0% {
          background: #131313
        }

        1% {
          background: #131313
        }

        100% {
          background: #3a3a3a
        }
      }

      .menu_animation {
        -webkit-animation: bgcolor-level2_1 1s;
        animation: bgcolor-level2_1 1s
      }

      @-webkit-keyframes bgcolor-level2_2 {
        0% {
          background: #131313
        }

        1% {
          background: #131313
        }

        100% {
          background: #3a3a3a
        }
      }

      @keyframes bgcolor-level2_2 {
        0% {
          background: #131313
        }

        1% {
          background: #131313
        }

        100% {
          background: #3a3a3a
        }
      }

      .menu_animation2 {
        -webkit-animation: bgcolor-level2_2 1s;
        animation: bgcolor-level2_2 1s
      }

      .mCustomScrollbar {
        touch-action: pinch-zoom
      }

      .mCustomScrollbar.mCS_no_scrollbar,
      .mCustomScrollbar.mCS_touch_action {
        touch-action: auto
      }

      .mCustomScrollBox {
        position: relative;
        overflow: hidden;
        height: 100%;
        max-width: 100%;
        outline: 0;
        direction: ltr
      }

      .menuCSB_container {
        overflow: hidden;
        width: auto;
        height: auto
      }

      .menuCSB_inside>.menuCSB_container {
        margin-right: 15px
      }

      .menuCSB_container.mCS_no_scrollbar_y.mCS_y_hidden {
        margin-right: 0
      }

      .mCS-dir-rtl>.menuCSB_inside>.menuCSB_container {
        margin-right: 0;
        margin-left: 30px
      }

      .mCS-dir-rtl>.menuCSB_inside>.menuCSB_container.mCS_no_scrollbar_y.mCS_y_hidden {
        margin-left: 0
      }

      .menuCSB_scrollTools {
        position: absolute;
        width: 16px;
        height: auto;
        left: auto;
        top: 0;
        right: 0;
        bottom: 0
      }

      .menuCSB_outside+.menuCSB_scrollTools {
        right: -26px
      }

      .mCS-dir-rtl>.menuCSB_inside>.menuCSB_scrollTools,
      .mCS-dir-rtl>.menuCSB_outside+.menuCSB_scrollTools {
        right: auto;
        left: 0
      }

      .mCS-dir-rtl>.menuCSB_outside+.menuCSB_scrollTools {
        left: -26px
      }

      .menuCSB_scrollTools .menuCSB_draggerContainer {
        position: absolute;
        top: 0;
        left: 0;
        bottom: 0;
        right: 0;
        height: auto
      }

      .menuCSB_scrollTools a+.menuCSB_draggerContainer {
        margin: 20px 0
      }

      .menuCSB_scrollTools .menuCSB_draggerRail {
        width: 2px;
        height: 100%;
        margin: 0 auto;
        border-radius: 16px
      }

      .menuCSB_scrollTools .menuCSB_dragger {
        cursor: pointer;
        width: 100%;
        height: 30px;
        z-index: 1
      }

      .menuCSB_scrollTools .menuCSB_dragger .menuCSB_dragger_bar {
        position: relative;
        width: 4px;
        height: 100%;
        margin: 0 auto;
        border-radius: 16px;
        text-align: center
      }

      .menuCSB_scrollTools_vertical.menuCSB_scrollTools_onDrag_expand .menuCSB_dragger.menuCSB_dragger_onDrag_expanded .menuCSB_dragger_bar,
      .menuCSB_scrollTools_vertical.menuCSB_scrollTools_onDrag_expand .menuCSB_draggerContainer:hover .menuCSB_dragger .menuCSB_dragger_bar {
        width: 12px
      }

      .menuCSB_scrollTools_vertical.menuCSB_scrollTools_onDrag_expand .menuCSB_dragger.menuCSB_dragger_onDrag_expanded+.menuCSB_draggerRail,
      .menuCSB_scrollTools_vertical.menuCSB_scrollTools_onDrag_expand .menuCSB_draggerContainer:hover .menuCSB_draggerRail {
        width: 8px
      }

      .menuCSB_scrollTools .menuCSB_buttonDown,
      .menuCSB_scrollTools .menuCSB_buttonUp {
        display: block;
        position: absolute;
        height: 20px;
        width: 100%;
        overflow: hidden;
        margin: 0 auto;
        cursor: pointer
      }

      .menuCSB_scrollTools .menuCSB_buttonDown {
        bottom: 0
      }

      .menuCSB_horizontal.menuCSB_inside>.menuCSB_container {
        margin-right: 0;
        margin-bottom: 30px
      }

      .menuCSB_horizontal.menuCSB_outside>.menuCSB_container {
        min-height: 100%
      }

      .menuCSB_horizontal>.menuCSB_container.mCS_no_scrollbar_x.mCS_x_hidden {
        margin-bottom: 0
      }

      .menuCSB_scrollTools.menuCSB_scrollTools_horizontal {
        width: auto;
        height: 16px;
        top: auto;
        right: 0;
        bottom: 0;
        left: 0
      }

      .mCustomScrollBox+.menuCSB_scrollTools+.menuCSB_scrollTools.menuCSB_scrollTools_horizontal,
      .mCustomScrollBox+.menuCSB_scrollTools.menuCSB_scrollTools_horizontal {
        bottom: -26px
      }

      .menuCSB_scrollTools.menuCSB_scrollTools_horizontal a+.menuCSB_draggerContainer {
        margin: 0 20px
      }

      .menuCSB_scrollTools.menuCSB_scrollTools_horizontal .menuCSB_draggerRail {
        width: 100%;
        height: 2px;
        margin: 7px 0
      }

      .menuCSB_scrollTools.menuCSB_scrollTools_horizontal .menuCSB_dragger {
        width: 30px;
        height: 100%;
        left: 0
      }

      .menuCSB_scrollTools.menuCSB_scrollTools_horizontal .menuCSB_dragger .menuCSB_dragger_bar {
        width: 100%;
        height: 4px;
        margin: 6px auto
      }

      .menuCSB_scrollTools_horizontal.menuCSB_scrollTools_onDrag_expand .menuCSB_dragger.menuCSB_dragger_onDrag_expanded .menuCSB_dragger_bar,
      .menuCSB_scrollTools_horizontal.menuCSB_scrollTools_onDrag_expand .menuCSB_draggerContainer:hover .menuCSB_dragger .menuCSB_dragger_bar {
        height: 12px;
        margin: 2px auto
      }

      .menuCSB_scrollTools_horizontal.menuCSB_scrollTools_onDrag_expand .menuCSB_dragger.menuCSB_dragger_onDrag_expanded+.menuCSB_draggerRail,
      .menuCSB_scrollTools_horizontal.menuCSB_scrollTools_onDrag_expand .menuCSB_draggerContainer:hover .menuCSB_draggerRail {
        height: 8px;
        margin: 4px 0
      }

      .menuCSB_scrollTools.menuCSB_scrollTools_horizontal .menuCSB_buttonLeft,
      .menuCSB_scrollTools.menuCSB_scrollTools_horizontal .menuCSB_buttonRight {
        display: block;
        position: absolute;
        width: 20px;
        height: 100%;
        overflow: hidden;
        margin: 0 auto;
        cursor: pointer
      }

      .menuCSB_scrollTools.menuCSB_scrollTools_horizontal .menuCSB_buttonLeft {
        left: 0
      }

      .menuCSB_scrollTools.menuCSB_scrollTools_horizontal .menuCSB_buttonRight {
        right: 0
      }

      .menuCSB_container_wrapper {
        position: absolute;
        height: auto;
        width: auto;
        overflow: hidden;
        top: 0;
        left: 0;
        right: 0;
        bottom: 0;
        margin-right: 30px;
        margin-bottom: 30px
      }

      .menuCSB_container_wrapper>.menuCSB_container {
        padding-right: 30px;
        padding-bottom: 30px;
        box-sizing: border-box
      }

      .menuCSB_vertical_horizontal>.menuCSB_scrollTools.menuCSB_scrollTools_vertical {
        bottom: 20px
      }

      .menuCSB_vertical_horizontal>.menuCSB_scrollTools.menuCSB_scrollTools_horizontal {
        right: 20px
      }

      .menuCSB_container_wrapper.mCS_no_scrollbar_x.mCS_x_hidden+.menuCSB_scrollTools.menuCSB_scrollTools_vertical {
        bottom: 0
      }

      .mCS-dir-rtl>.mCustomScrollBox.menuCSB_vertical_horizontal.menuCSB_inside>.menuCSB_scrollTools.menuCSB_scrollTools_horizontal,
      .menuCSB_container_wrapper.mCS_no_scrollbar_y.mCS_y_hidden+.menuCSB_scrollTools~.menuCSB_scrollTools.menuCSB_scrollTools_horizontal {
        right: 0
      }

      .mCS-dir-rtl>.mCustomScrollBox.menuCSB_vertical_horizontal.menuCSB_inside>.menuCSB_scrollTools.menuCSB_scrollTools_horizontal {
        left: 20px
      }

      .mCS-dir-rtl>.mCustomScrollBox.menuCSB_vertical_horizontal.menuCSB_inside>.menuCSB_container_wrapper.mCS_no_scrollbar_y.mCS_y_hidden+.menuCSB_scrollTools~.menuCSB_scrollTools.menuCSB_scrollTools_horizontal {
        left: 0
      }

      .mCS-dir-rtl>.menuCSB_inside>.menuCSB_container_wrapper {
        margin-right: 0;
        margin-left: 30px
      }

      .menuCSB_container_wrapper.mCS_no_scrollbar_y.mCS_y_hidden>.menuCSB_container {
        padding-right: 0
      }

      .menuCSB_container_wrapper.mCS_no_scrollbar_x.mCS_x_hidden>.menuCSB_container {
        padding-bottom: 0
      }

      .mCustomScrollBox.menuCSB_vertical_horizontal.menuCSB_inside>.menuCSB_container_wrapper.mCS_no_scrollbar_y.mCS_y_hidden {
        margin-right: 0;
        margin-left: 0
      }

      .mCustomScrollBox.menuCSB_vertical_horizontal.menuCSB_inside>.menuCSB_container_wrapper.mCS_no_scrollbar_x.mCS_x_hidden {
        margin-bottom: 0
      }

      .menuCSB_scrollTools,
      .menuCSB_scrollTools .menuCSB_buttonDown,
      .menuCSB_scrollTools .menuCSB_buttonLeft,
      .menuCSB_scrollTools .menuCSB_buttonRight,
      .menuCSB_scrollTools .menuCSB_buttonUp,
      .menuCSB_scrollTools .menuCSB_dragger .menuCSB_dragger_bar {
        transition: opacity .2s ease-in-out, background-color .2s ease-in-out
      }

      .menuCSB_scrollTools_horizontal.menuCSB_scrollTools_onDrag_expand .menuCSB_draggerRail,
      .menuCSB_scrollTools_horizontal.menuCSB_scrollTools_onDrag_expand .menuCSB_dragger_bar,
      .menuCSB_scrollTools_vertical.menuCSB_scrollTools_onDrag_expand .menuCSB_draggerRail,
      .menuCSB_scrollTools_vertical.menuCSB_scrollTools_onDrag_expand .menuCSB_dragger_bar {
        transition: width .2s ease-out .2s, height .2s ease-out .2s, margin-left .2s ease-out .2s, margin-right .2s ease-out .2s, margin-top .2s ease-out .2s, margin-bottom .2s ease-out .2s, opacity .2s ease-in-out, background-color .2s ease-in-out
      }

      .menuCSB_scrollTools {
        opacity: .75;
        filter: "alpha(opacity=75)";
        -ms-filter: "alpha(opacity=75)"
      }

      .mCS-autoHide>.mCustomScrollBox>.menuCSB_scrollTools,
      .mCS-autoHide>.mCustomScrollBox~.menuCSB_scrollTools {
        opacity: 0;
        filter: "alpha(opacity=0)";
        -ms-filter: "alpha(opacity=0)"
      }

      .mCS-autoHide:hover>.mCustomScrollBox>.menuCSB_scrollTools,
      .mCS-autoHide:hover>.mCustomScrollBox~.menuCSB_scrollTools,
      .mCustomScrollBox:hover>.menuCSB_scrollTools,
      .mCustomScrollBox:hover~.menuCSB_scrollTools,
      .mCustomScrollbar>.mCustomScrollBox>.menuCSB_scrollTools.menuCSB_scrollTools_onDrag,
      .mCustomScrollbar>.mCustomScrollBox~.menuCSB_scrollTools.menuCSB_scrollTools_onDrag {
        opacity: 1;
        filter: "alpha(opacity=100)";
        -ms-filter: "alpha(opacity=100)"
      }

      .menuCSB_scrollTools .menuCSB_draggerRail {
        background-color: #000;
        background-color: rgba(0, 0, 0, .4);
        filter: "alpha(opacity=40)";
        -ms-filter: "alpha(opacity=40)"
      }

      .menuCSB_scrollTools .menuCSB_dragger .menuCSB_dragger_bar {
        background-color: #fff;
        background-color: rgba(255, 255, 255, .75);
        filter: "alpha(opacity=75)";
        -ms-filter: "alpha(opacity=75)"
      }

      .menuCSB_scrollTools .menuCSB_dragger:hover .menuCSB_dragger_bar {
        background-color: #fff;
        background-color: rgba(255, 255, 255, .85);
        filter: "alpha(opacity=85)";
        -ms-filter: "alpha(opacity=85)"
      }

      .menuCSB_scrollTools .menuCSB_dragger.menuCSB_dragger_onDrag .menuCSB_dragger_bar,
      .menuCSB_scrollTools .menuCSB_dragger:active .menuCSB_dragger_bar {
        background-color: #fff;
        background-color: rgba(255, 255, 255, .9);
        filter: "alpha(opacity=90)";
        -ms-filter: "alpha(opacity=90)"
      }

      .mCS-ei-theme.menuCSB_scrollTools .menuCSB_dragger .menuCSB_dragger_bar {
        width: 2px;
        background-color: #fff;
        opacity: .75
      }

      .mCS-ei-theme.menuCSB_scrollTools .menuCSB_dragger:hover .menuCSB_dragger_bar {
        opacity: .85
      }

      .mCS-ei-theme.menuCSB_scrollTools .menuCSB_dragger.menuCSB_dragger_onDrag .menuCSB_dragger_bar,
      .mCS-ei-theme.menuCSB_scrollTools .menuCSB_draggeractive .menuCSB_dragger_bar {
        opacity: .9
      }

      .mCS-ei-theme.menuCSB_scrollTools_horizontal .menuCSB_draggerRail {
        width: 100%;
        height: 2px
      }

      .mCS-ei-theme.menuCSB_scrollTools_horizontal .menuCSB_dragger .menuCSB_dragger_bar {
        width: 100%;
        height: 2px;
        margin: 7px auto
      }

      .mCS-ei-theme.menuCSB_scrollTools .menuCSB_draggerRail {
        width: 2px;
        background-color: #fff;
        opacity: .15
      }

      .mCS-ei-theme.menuCSB_scrollTools .menuCSB_buttonDown,
      .mCS-ei-theme.menuCSB_scrollTools .menuCSB_buttonLeft,
      .mCS-ei-theme.menuCSB_scrollTools .menuCSB_buttonRight,
      .mCS-ei-theme.menuCSB_scrollTools .menuCSB_buttonUp {
        text-decoration: none;
        opacity: .4;
        filter: "alpha(opacity=40)";
        -ms-filter: "alpha(opacity=40)"
      }

      .mCS-ei-theme.menuCSB_scrollTools .menuCSB_buttonDown:before,
      .mCS-ei-theme.menuCSB_scrollTools .menuCSB_buttonLeft:before,
      .mCS-ei-theme.menuCSB_scrollTools .menuCSB_buttonRight:before,
      .mCS-ei-theme.menuCSB_scrollTools .menuCSB_buttonUp:before {
        color: #fff;
        margin: 1px
      }

      .mCS-ei-theme.menuCSB_scrollTools .menuCSB_buttonDown:hover,
      .mCS-ei-theme.menuCSB_scrollTools .menuCSB_buttonLeft:hover,
      .mCS-ei-theme.menuCSB_scrollTools .menuCSB_buttonRight:hover,
      .mCS-ei-theme.menuCSB_scrollTools .menuCSB_buttonUp:hover {
        opacity: .75;
        filter: "alpha(opacity=75)";
        -ms-filter: "alpha(opacity=75)"
      }

      .mCS-ei-theme.menuCSB_scrollTools .menuCSB_buttonDown:active,
      .mCS-ei-theme.menuCSB_scrollTools .menuCSB_buttonLeft:active,
      .mCS-ei-theme.menuCSB_scrollTools .menuCSB_buttonRight:active,
      .mCS-ei-theme.menuCSB_scrollTools .menuCSB_buttonUp:active {
        opacity: .9;
        filter: "alpha(opacity=90)";
        -ms-filter: "alpha(opacity=90)"
      }

      .mCS-ei-theme.menuCSB_scrollTools .menuCSB_buttonUp:before {
        content: "\25b2"
      }

      .mCS-ei-theme.menuCSB_scrollTools .menuCSB_buttonDown:before {
        content: "\25bc"
      }

      .mCS-ei-theme.menuCSB_scrollTools .menuCSB_buttonLeft:before {
        content: "\25c4"
      }

      .mCS-ei-theme.menuCSB_scrollTools .menuCSB_buttonRight:before {
        content: "\25ba"
      }

      #ei_tpl_level0 li#ei_m_favoris {
        background-color: #1a191f;
        margin: 0 !important;
        padding: 10px 10px 25px 22px;
        margin-bottom: 20px !important
      }

      #ei_tpl_level0 li#ei_m_favoris .e_smenu {
        position: static;
        width: 100%;
        overflow: visible;
        height: auto
      }

      #ei_tpl_level0 li#ei_m_favoris .e_smenu .e_smenu {
        overflow: hidden;
        height: auto;
        max-height: 108px;
        transition: height .3s linear
      }

      #ei_tpl_level0 li#ei_m_favoris a#ei_fav_next {
        display: none;
        cursor: pointer;
        background-color: #1a191f;
        position: absolute;
        left: 0;
        bottom: 0;
        right: 0;
        width: 100%;
        box-sizing: border-box;
        height: 10px;
        padding: 0;
        border-bottom: 1px solid #b3b3b3;
        transition: border-color .2s linear;
        overflow: visible
      }

      #ei_tpl_level0 li#ei_m_favoris a#ei_fav_next:after {
        content: "\F01B4" !important;
        font-family: fts_picto;
        speak: none;
        font-style: normal;
        font-weight: 400;
        font-variant: normal;
        text-transform: none;
        line-height: 1;
        -webkit-font-smoothing: antialiased;
        -moz-osx-font-smoothing: grayscale;
        color: #1a191f;
        position: absolute;
        bottom: -17px;
        left: calc(50% - 17px);
        background-color: #b3b3b3;
        font-size: 30px;
        border-radius: 20px;
        height: 34px;
        width: 34px;
        border: 2px solid #1a191f;
        text-align: center;
        line-height: 32px;
        box-sizing: border-box
      }

      #ei_tpl_level0 li#ei_m_favoris a#ei_fav_next:focus,
      #ei_tpl_level0 li#ei_m_favoris a#ei_fav_next:hover {
        border-color: #bad606
      }

      #ei_tpl_level0 li#ei_m_favoris a#ei_fav_next:focus:after,
      #ei_tpl_level0 li#ei_m_favoris a#ei_fav_next:hover:after {
        background-color: #bad606
      }

      #ei_tpl_level0 li#ei_m_favoris.ei_fav_more.open .e_smenu .e_smenu {
        overflow: visible;
        max-height: none
      }

      #ei_tpl_level0 li#ei_m_favoris.ei_fav_more.open a#ei_fav_next:after {
        content: "\F01B8" !important
      }

      #ei_tpl_level0 li#ei_m_favoris.ei_fav_more a#ei_fav_next {
        display: block
      }

      #ei_tpl_level0 li#ei_m_favoris .e_smenu_content {
        position: relative
      }

      #ei_tpl_level0 li#ei_m_favoris li#BOOKMARK_HANDLE>a {
        display: none
      }

      #ei_tpl_level0 li#ei_m_favoris>a {
        cursor: default
      }

      #ei_tpl_level0 li#ei_m_favoris>a:before {
        display: none
      }

      #ei_tpl_level0 li#ei_m_favoris>a:after {
        content: "" !important
      }

      #ei_tpl_level0 li#ei_m_favoris ul li:before {
        position: absolute;
        left: 0;
        top: 7px;
        font-family: fts_picto;
        speak: none;
        font-style: normal;
        font-weight: 400;
        font-variant: normal;
        text-transform: none;
        line-height: 1;
        -webkit-font-smoothing: antialiased;
        -moz-osx-font-smoothing: grayscale;
        font-size: 20px;
        color: #fff;
        opacity: .6
      }

      #ei_tpl_level0 li#ei_m_favoris ul li a {
        color: #fff;
        font-family: "Helvetica Neue", Helvetica, Arial, sans-serif;
        font-weight: 400;
        font-size: 1.2em;
        padding: 5px 0 5px 25px;
        opacity: .8;
        white-space: nowrap;
        text-overflow: ellipsis;
        display: block;
        overflow: hidden
      }

      #ei_tpl_level0 li#ei_m_favoris ul li a:before {
        display: none
      }

      #ei_tpl_level0 li#ei_m_favoris ul li a:focus,
      #ei_tpl_level0 li#ei_m_favoris ul li a:hover {
        color: #bad606;
        opacity: 1
      }

      #ei_tpl_level0 li#ei_m_favoris li.ei_act_new,
      #ei_tpl_level0 li#ei_m_favoris li.ei_act_param,
      #ei_tpl_level0 li#ei_m_favoris li.ei_act_sup {
        position: absolute;
        top: -37px;
        width: 25px;
        height: 25px;
        background-color: #1a191f
      }

      #ei_tpl_level0 li#ei_m_favoris li.ei_act_new:before,
      #ei_tpl_level0 li#ei_m_favoris li.ei_act_param:before,
      #ei_tpl_level0 li#ei_m_favoris li.ei_act_sup:before {
        display: none
      }

      #ei_tpl_level0 li#ei_m_favoris li.ei_act_new a,
      #ei_tpl_level0 li#ei_m_favoris li.ei_act_param a,
      #ei_tpl_level0 li#ei_m_favoris li.ei_act_sup a {
        height: 25px;
        width: 25px;
        display: block;
        overflow: hidden;
        line-height: 70px;
        padding: 0;
        box-sizing: border-box;
        color: #fff
      }

      #ei_tpl_level0 li#ei_m_favoris li.ei_act_new a:before,
      #ei_tpl_level0 li#ei_m_favoris li.ei_act_param a:before,
      #ei_tpl_level0 li#ei_m_favoris li.ei_act_sup a:before {
        display: block;
        font-family: fts_picto;
        speak: none;
        font-style: normal;
        font-weight: 400;
        font-variant: normal;
        text-transform: none;
        line-height: 1;
        -webkit-font-smoothing: antialiased;
        -moz-osx-font-smoothing: grayscale;
        position: absolute;
        left: 0;
        top: 0;
        height: 0
      }

      #ei_tpl_level0 li#ei_m_favoris li.ei_act_param {
        right: 10px
      }

      #ei_tpl_level0 li#ei_m_favoris li.ei_act_param a:before {
        content: "\F08C7" !important;
        font-size: 26px
      }

      #ei_tpl_level0 li#ei_m_favoris li.ei_act_new,
      #ei_tpl_level0 li#ei_m_favoris li.ei_act_sup {
        right: 50px
      }

      #ei_tpl_level0 li#ei_m_favoris li.ei_act_new.ina,
      #ei_tpl_level0 li#ei_m_favoris li.ei_act_sup.ina {
        display: none
      }

      #ei_tpl_level0 li#ei_m_favoris li.ei_act_new a:before {
        content: "\F000A" !important;
        font-size: 25px
      }

      #ei_tpl_level0 li#ei_m_favoris li.ei_act_sup a:before {
        content: "\F022B" !important;
        font-size: 27px
      }

      #ei_tpl_level0 li#ei_m_favoris li.e_smenu_compte>a:before {
        content: "\F06B8"
      }

      #ei_tpl_level0 li#ei_m_favoris li.e_menu_vir_entrecompte>a:before {
        content: "\F06BD"
      }

      #ei_tpl_level0 li#ei_m_favoris li.e_menu_virement>a:before {
        content: "\F08E5"
      }

      #ei_tpl_level0 li#ei_m_favoris li.e_menu_virementext>a:before {
        content: "\F08E5"
      }

      #ei_tpl_level0 li#ei_m_favoris li.e_menu_ibanrib>a:before {
        content: "\F06F9"
      }

      #ei_tpl_level0 li#ei_m_favoris li.e_menu_msg>a:before {
        content: "\F08CD"
      }

      #ei_tpl_level0 li#ei_m_favoris li.e_menu_doc>a:before {
        content: "\F00F7"
      }

      #ei_tpl_level0 li#ei_m_favoris li.e_menu_favallope>a:before {
        content: "\F013E"
      }

      #ei_tpl_level0 li#ei_m_favoris li.e_menu_favparam>a:before {
        content: "\F08AE"
      }

      #ei_tpl_level0 li#ei_m_favoris li.e_menu_cb>a:before {
        content: "\F08AE"
      }

      #ei_tpl_level0 li#ei_m_favoris li.e_menu_rdv>a:before {
        content: "\F0026"
      }

      #ei_tpl_level0 li#ei_m_favoris li.ei_prise_de_rdv>a:before {
        content: "\F0026"
      }

      #ei_tpl_level0 li#ei_m_favoris li.e_menu_bourse>a:before {
        content: "\F016F"
      }

      #ei_tpl_level0 li#ei_m_favoris li.ei_act_new>a:before {
        content: "\F0129"
      }

      #ei_tpl_level0 li#ei_m_favoris li.e_menu_budg:before,
      #ei_tpl_level0 li#ei_m_favoris li.e_smenu_compte:before {
        content: "\F06B8";
        font-size: 15px
      }

      #ei_tpl_level0 li#ei_m_favoris li.e_menu_vir_entrecompte:before,
      #ei_tpl_level0 li#ei_m_favoris li.e_menu_vir_ponctuel:before {
        content: "\F08E5"
      }

      #ei_tpl_level0 li#ei_m_favoris li.e_menu_vir_permanent:before,
      #ei_tpl_level0 li#ei_m_favoris li.e_menu_virement:before,
      #ei_tpl_level0 li#ei_m_favoris li.e_menu_virementext:before {
        content: "\F08E5"
      }

      #ei_tpl_level0 li#ei_m_favoris li.e_menu_vir_permanent:before,
      #ei_tpl_level0 li#ei_m_favoris li.e_menu_virementext:before {
        content: "\F08C8"
      }

      #ei_tpl_level0 li#ei_m_favoris li.e_menu_ibanrib:before {
        content: "\F06F9";
        font-size: 15px
      }

      #ei_tpl_level0 li#ei_m_favoris li.e_menu_msg:before {
        content: "\F08CD"
      }

      #ei_tpl_level0 li#ei_m_favoris li.e_menu_doc:before {
        content: "\F0020"
      }

      #ei_tpl_level0 li#ei_m_favoris li.e_menu_favallope:before {
        content: "\F08A8"
      }

      #ei_tpl_level0 li#ei_m_favoris li.e_menu_cb:before,
      #ei_tpl_level0 li#ei_m_favoris li.e_menu_favparam:before {
        content: "\F08AE"
      }

      #ei_tpl_level0 li#ei_m_favoris li.e_menu_rdv:before,
      #ei_tpl_level0 li#ei_m_favoris li.ei_prise_de_rdv:before {
        content: "\F0026"
      }

      #ei_tpl_level0 li#ei_m_favoris li.e_menu_bourse:before {
        content: "\F016F"
      }

      #ei_tpl_level0 li#ei_m_favoris li.ei_act_new:before {
        content: "\F08A3"
      }

      #ei_tpl_level0 li#ei_m_favoris li.e_menu_rem_cheques:before {
        content: "\F08B4"
      }

      #ei_tpl_level0 li#ei_m_favoris li.e_menu_financement:before {
        content: "\F08B9"
      }

      #ei_tpl_level0 li#ei_m_favoris li.e_menu_augment_credit:before {
        content: "\F04C4"
      }

      #ei_tpl_level0 li#ei_m_favoris li.e_menu_partner:before {
        content: "\F08D5"
      }

      #mb_validate_div {
        padding: 10px;
        text-align: center
      }

      button.ei_m_favori_modalBox_validate {
        background-color: #bad606;
        border: 0;
        text-transform: uppercase;
        color: #000;
        padding: 5px 10px;
        font-weight: 700
      }

      #ei_m_favori_modalBox_bg {
        z-index: 1248;
        position: fixed;
        top: 0;
        bottom: 0;
        left: 0;
        right: 0;
        box-sizing: border-box;
        background-color: #000;
        opacity: .6
      }

      #empty_full_bookmarks_list,
      #empty_user_bookmarks_list {
        text-align: center;
        padding: 10px
      }

      #ei_m_favori_modalBox {
        background-color: #f8f8f8;
        border: 1px solid #333;
        max-width: 500px;
        width: 100%;
        box-sizing: border-box;
        position: fixed;
        left: calc(50% - 250px);
        top: 50px;
        z-index: 1250
      }

      #ei_m_favori_modalBox #ei_m_favori_modalBox_header {
        background-color: #333;
        padding: 10px;
        color: #fff;
        height: 50px
      }

      #ei_m_favori_modalBox #ei_m_favori_modalBox_header h3 {
        padding: 0;
        margin: 0;
        box-sizing: border-box;
        padding-top: 6px;
        font-size: 1.5rem
      }

      #ei_m_favori_modalBox .e_smenu_mb {
        padding: 0;
        overflow-y: scroll
      }

      #ei_m_favori_modalBox ul {
        margin: 0;
        padding: 0 10px
      }

      #ei_m_favori_modalBox ul li {
        display: flex;
        border-top: 1px solid #e9e6e1;
        transition: background-color .2s linear;
        position: relative;
        padding-right: 15px;
        padding-left: 30px
      }

      #ei_m_favori_modalBox ul li:before {
        font-family: fts_picto;
        speak: none;
        font-style: normal;
        font-weight: 400;
        font-variant: normal;
        text-transform: none;
        line-height: 1;
        -webkit-font-smoothing: antialiased;
        -moz-osx-font-smoothing: grayscale;
        position: absolute;
        top: 10px;
        left: 3px;
        font-size: 20px
      }

      #ei_m_favori_modalBox ul li:first-child {
        padding-top: 10px;
        border-top: 1px solid #949494
      }

      #ei_m_favori_modalBox ul li:first-child:before {
        top: 20px
      }

      #ei_m_favori_modalBox ul li:last-child {
        padding-bottom: 10px;
        border-bottom: 1px solid #949494
      }

      #ei_m_favori_modalBox ul li:hover {
        background-color: #f0f0f0
      }

      #ei_m_favori_modalBox ul li a {
        display: block;
        padding: 8px 0;
        text-decoration: none;
        box-sizing: border-box
      }

      #ei_m_favori_modalBox ul li a:first-child {
        width: 300px
      }

      #ei_m_favori_modalBox ul li a:first-child:before {
        content: "" !important
      }

      #ei_m_favori_modalBox ul li a.ei_fav_add,
      #ei_m_favori_modalBox ul li a.ei_fav_down,
      #ei_m_favori_modalBox ul li a.ei_fav_remove,
      #ei_m_favori_modalBox ul li a.ei_fav_up {
        width: 20px;
        height: 25px;
        margin-left: 20px;
        position: relative
      }

      #ei_m_favori_modalBox ul li a.ei_fav_add:before,
      #ei_m_favori_modalBox ul li a.ei_fav_down:before,
      #ei_m_favori_modalBox ul li a.ei_fav_remove:before,
      #ei_m_favori_modalBox ul li a.ei_fav_up:before {
        font-family: fts_picto;
        speak: none;
        font-style: normal;
        font-weight: 400;
        font-variant: normal;
        text-transform: none;
        line-height: 1;
        -webkit-font-smoothing: antialiased;
        -moz-osx-font-smoothing: grayscale;
        position: absolute;
        left: 0;
        top: 5px;
        font-size: 20px
      }

      #ei_m_favori_modalBox ul li a.ei_fav_add:focus,
      #ei_m_favori_modalBox ul li a.ei_fav_add:hover,
      #ei_m_favori_modalBox ul li a.ei_fav_down:focus,
      #ei_m_favori_modalBox ul li a.ei_fav_down:hover,
      #ei_m_favori_modalBox ul li a.ei_fav_remove:focus,
      #ei_m_favori_modalBox ul li a.ei_fav_remove:hover,
      #ei_m_favori_modalBox ul li a.ei_fav_up:focus,
      #ei_m_favori_modalBox ul li a.ei_fav_up:hover {
        color: #bad606
      }

      #ei_m_favori_modalBox ul li a.ei_fav_up:before {
        content: "\F05D1"
      }

      #ei_m_favori_modalBox ul li a.ei_fav_down:before {
        content: "\F05CB"
      }

      #ei_m_favori_modalBox ul li a.ei_fav_remove:before {
        content: "\F0255"
      }

      #ei_m_favori_modalBox ul li a.ei_fav_add:before {
        content: "\F0192"
      }

      #ei_m_favori_modalBox ul li:first-child {
        border: 0
      }

      #ei_m_favori_modalBox li.e_smenu_compte>a:before {
        content: "\F06B8"
      }

      #ei_m_favori_modalBox li.e_menu_vir_entrecompte>a:before {
        content: "\F06BD"
      }

      #ei_m_favori_modalBox li.e_menu_virement>a:before {
        content: "\F08E5"
      }

      #ei_m_favori_modalBox li.e_menu_virementext>a:before {
        content: "\F08E5"
      }

      #ei_m_favori_modalBox li.e_menu_ibanrib>a:before {
        content: "\F06F9"
      }

      #ei_m_favori_modalBox li.e_menu_msg>a:before {
        content: "\F08CD"
      }

      #ei_m_favori_modalBox li.e_menu_doc>a:before {
        content: "\F00F7"
      }

      #ei_m_favori_modalBox li.e_menu_favallope>a:before {
        content: "\F013E"
      }

      #ei_m_favori_modalBox li.e_menu_favparam>a:before {
        content: "\F08AE"
      }

      #ei_m_favori_modalBox li.e_menu_cb>a:before {
        content: "\F08AE"
      }

      #ei_m_favori_modalBox li.e_menu_rdv>a:before {
        content: "\F0026"
      }

      #ei_m_favori_modalBox li.ei_prise_de_rdv>a:before {
        content: "\F0026"
      }

      #ei_m_favori_modalBox li.e_menu_bourse>a:before {
        content: "\F016F"
      }

      #ei_m_favori_modalBox li.ei_act_new>a:before {
        content: "\F0129"
      }

      #ei_m_favori_modalBox li.e_menu_budg:before,
      #ei_m_favori_modalBox li.e_smenu_compte:before {
        content: "\F06B8";
        font-size: 15px
      }

      #ei_m_favori_modalBox li.e_menu_vir_entrecompte:before,
      #ei_m_favori_modalBox li.e_menu_vir_ponctuel:before {
        content: "\F08E5"
      }

      #ei_m_favori_modalBox li.e_menu_vir_permanent:before,
      #ei_m_favori_modalBox li.e_menu_virement:before,
      #ei_m_favori_modalBox li.e_menu_virementext:before {
        content: "\F08E5"
      }

      #ei_m_favori_modalBox li.e_menu_vir_permanent:before,
      #ei_m_favori_modalBox li.e_menu_virementext:before {
        content: "\F08C8"
      }

      #ei_m_favori_modalBox li.e_menu_ibanrib:before {
        content: "\F06F9";
        font-size: 15px
      }

      #ei_m_favori_modalBox li.e_menu_msg:before {
        content: "\F08CD"
      }

      #ei_m_favori_modalBox li.e_menu_doc:before {
        content: "\F0020"
      }

      #ei_m_favori_modalBox li.e_menu_favallope:before {
        content: "\F08A8"
      }

      #ei_m_favori_modalBox li.e_menu_cb:before,
      #ei_m_favori_modalBox li.e_menu_favparam:before {
        content: "\F08AE"
      }

      #ei_m_favori_modalBox li.e_menu_rdv:before,
      #ei_m_favori_modalBox li.ei_prise_de_rdv:before {
        content: "\F0026"
      }

      #ei_m_favori_modalBox li.e_menu_bourse:before {
        content: "\F016F"
      }

      #ei_m_favori_modalBox li.ei_act_new:before {
        content: "\F08A3"
      }

      #ei_m_favori_modalBox li.e_menu_rem_cheques:before {
        content: "\F08B4"
      }

      #ei_m_favori_modalBox li.e_menu_financement:before {
        content: "\F08B9"
      }

      #ei_m_favori_modalBox li.e_menu_augment_credit:before {
        content: "\F04C4"
      }

      #ei_m_favori_modalBox li.e_menu_partner:before {
        content: "\F08D5"
      }

      #ei_m_favori_modalBox #ei_act_close_mb {
        position: absolute;
        right: 10px;
        top: 10px;
        width: 40px;
        height: 40px;
        overflow: hidden;
        background-color: #333;
        line-height: 150px;
        border: 0
      }

      #ei_m_favori_modalBox #ei_act_close_mb:before {
        content: "\F0228";
        font-family: fts_picto;
        speak: none;
        font-style: normal;
        font-weight: 400;
        font-variant: normal;
        text-transform: none;
        line-height: 1;
        -webkit-font-smoothing: antialiased;
        -moz-osx-font-smoothing: grayscale;
        font-size: 25px;
        color: #fff;
        position: absolute;
        left: 0;
        top: 0
      }

      #ei_m_favori_modalBox #ei_act_close_mb:focus:before,
      #ei_m_favori_modalBox #ei_act_close_mb:hover:before {
        color: #bad606
      }

      @media screen and (max-width:550px) {
        #ei_m_favori_modalBox {
          left: 5px;
          right: 5px
        }

        #ei_m_favori_modalBox ul li a:first-child {
          width: 200px
        }
      }

      #ei_tpl_menuPrincipal>nav>ul>li.menuBazooka>a {
        font-size: 1em;
        padding-top: 8px;
        padding-bottom: 4px
      }

      #ei_tpl_menuPrincipal>nav>ul>li.menuBazooka>a:before {
        position: absolute;
        content: "";
        left: 0;
        top: 7px;
        height: 0;
        width: 2px;
        background-color: #bad606;
        transition: height .1s linear
      }

      #ei_tpl_menuPrincipal>nav>ul>li.menuBazooka>a:focus,
      #ei_tpl_menuPrincipal>nav>ul>li.menuBazooka>a:hover {
        color: #bad606
      }

      #ei_tpl_menuPrincipal>nav>ul>li.menuBazooka.e_select {
        background-color: #424242
      }

      #ei_tpl_menuPrincipal>nav>ul>li.menuBazooka.e_select a:before {
        height: 22px
      }

      #ei_tpl_menuPrincipal>nav>ul>li.menuBazooka.apropos {
        padding-top: 0
      }

      #ei_tpl_menuPrincipal>nav>ul>li.menuBazooka .noteavis {
        color: #fff600;
        font-weight: 700;
        font-size: 1.25em
      }

      #ei_tpl_menuPrincipal>nav>ul>li.menuBazooka.menuCc>a {
        font-weight: 400;
        padding-left: 40px
      }

      #ei_tpl_menuPrincipal>nav>ul>li.menuBazooka.menuCc>a:hover {
        font-weight: 700
      }

      #ei_tpl_menuPrincipal>nav>ul>li.menuBazooka.menuCc>a:after {
        position: absolute;
        left: 0;
        top: 7px;
        font-family: fts_picto;
        speak: none;
        font-style: normal;
        font-weight: 400;
        font-variant: normal;
        text-transform: none;
        line-height: 1;
        -webkit-font-smoothing: antialiased;
        -moz-osx-font-smoothing: grayscale;
        font-size: 20px;
        content: "\F08AE";
        background-repeat: no-repeat;
        background-position: left top
      }

      #ei_tpl_menuPrincipal>nav>ul>li.menuBazooka.menuEp>a {
        font-weight: 400;
        padding-left: 40px
      }

      #ei_tpl_menuPrincipal>nav>ul>li.menuBazooka.menuEp>a:hover {
        font-weight: 700
      }

      #ei_tpl_menuPrincipal>nav>ul>li.menuBazooka.menuEp>a:after {
        position: absolute;
        left: 0;
        top: 7px;
        font-family: fts_picto;
        speak: none;
        font-style: normal;
        font-weight: 400;
        font-variant: normal;
        text-transform: none;
        line-height: 1;
        -webkit-font-smoothing: antialiased;
        -moz-osx-font-smoothing: grayscale;
        font-size: 20px;
        content: "\F08C2";
        background-repeat: no-repeat;
        background-position: left top
      }

      #ei_tpl_menuPrincipal>nav>ul>li.menuBazooka.menuAss>a {
        font-weight: 400;
        padding-left: 40px
      }

      #ei_tpl_menuPrincipal>nav>ul>li.menuBazooka.menuAss>a:hover {
        font-weight: 700
      }

      #ei_tpl_menuPrincipal>nav>ul>li.menuBazooka.menuAss>a:after {
        position: absolute;
        left: 0;
        top: 7px;
        font-family: fts_picto;
        speak: none;
        font-style: normal;
        font-weight: 400;
        font-variant: normal;
        text-transform: none;
        line-height: 1;
        -webkit-font-smoothing: antialiased;
        -moz-osx-font-smoothing: grayscale;
        font-size: 20px;
        content: "\F08A8";
        background-repeat: no-repeat;
        background-position: left top
      }

      #ei_tpl_menuPrincipal>nav>ul>li.menuBazooka.menuCr>a {
        font-weight: 400;
        padding-left: 40px
      }

      #ei_tpl_menuPrincipal>nav>ul>li.menuBazooka.menuCr>a:hover {
        font-weight: 700
      }

      #ei_tpl_menuPrincipal>nav>ul>li.menuBazooka.menuCr>a:after {
        position: absolute;
        left: 0;
        top: 7px;
        font-family: fts_picto;
        speak: none;
        font-style: normal;
        font-weight: 400;
        font-variant: normal;
        text-transform: none;
        line-height: 1;
        -webkit-font-smoothing: antialiased;
        -moz-osx-font-smoothing: grayscale;
        font-size: 20px;
        content: "\F08B9";
        background-repeat: no-repeat;
        background-position: left top
      }

      #ei_tpl_menuPrincipal>nav>ul>li.menuBazooka.menuPla>a {
        font-weight: 400;
        padding-left: 40px
      }

      #ei_tpl_menuPrincipal>nav>ul>li.menuBazooka.menuPla>a:hover {
        font-weight: 700
      }

      #ei_tpl_menuPrincipal>nav>ul>li.menuBazooka.menuPla>a:after {
        position: absolute;
        left: 0;
        top: 7px;
        font-family: fts_picto;
        speak: none;
        font-style: normal;
        font-weight: 400;
        font-variant: normal;
        text-transform: none;
        line-height: 1;
        -webkit-font-smoothing: antialiased;
        -moz-osx-font-smoothing: grayscale;
        font-size: 20px;
        content: "\F04C4";
        background-repeat: no-repeat;
        background-position: left top
      }

      #ei_tpl_menuPrincipal>nav>ul>li.menuBazooka.menuJeunes>a {
        font-weight: 400;
        padding-left: 40px
      }

      #ei_tpl_menuPrincipal>nav>ul>li.menuBazooka.menuJeunes>a:hover {
        font-weight: 700
      }

      #ei_tpl_menuPrincipal>nav>ul>li.menuBazooka.menuJeunes>a:after {
        position: absolute;
        left: 0;
        top: 7px;
        font-family: fts_picto;
        speak: none;
        font-style: normal;
        font-weight: 400;
        font-variant: normal;
        text-transform: none;
        line-height: 1;
        -webkit-font-smoothing: antialiased;
        -moz-osx-font-smoothing: grayscale;
        font-size: 20px;
        content: '';
        background-repeat: no-repeat;
        background-position: left top
      }

      #ei_tpl_menuPrincipal>nav>ul>li.menuBazooka.menuJeunes>a:after {
        background-repeat: no-repeat;
        background-position: left -2px;
        background-image:
          /*savepage-url=../images/css/menu/jeunes.svg*/
          var(--savepage-url-30);
        width: 27px;
        height: 27px
      }

      #ei_tpl_menuPrincipal>nav>ul>li.menuBazooka.menuAe>a {
        font-weight: 400;
        padding-left: 40px
      }

      #ei_tpl_menuPrincipal>nav>ul>li.menuBazooka.menuAe>a:hover {
        font-weight: 700
      }

      #ei_tpl_menuPrincipal>nav>ul>li.menuBazooka.menuAe>a:after {
        position: absolute;
        left: 0;
        top: 7px;
        font-family: fts_picto;
        speak: none;
        font-style: normal;
        font-weight: 400;
        font-variant: normal;
        text-transform: none;
        line-height: 1;
        -webkit-font-smoothing: antialiased;
        -moz-osx-font-smoothing: grayscale;
        font-size: 20px;
        content: '';
        background-repeat: no-repeat;
        background-position: left top
      }

      #ei_tpl_menuPrincipal>nav>ul>li.menuBazooka.menuAe>a:after {
        background-repeat: no-repeat;
        background-position: left -2px;
        background-image:
          /*savepage-url=../images/css/menu/autoEntrepreneur.svg*/
          var(--savepage-url-31);
        width: 27px;
        height: 27px
      }

      #ei_tpl_nav_m {
        display: none;
        background-color: #fff;
        top: 59px;
        right: 0;
        bottom: 0;
        left: 0;
        position: fixed
      }

      body.modeMobil.mobilmenu_open #ei_tpl_coleft {
        position: fixed;
        top: 50px;
        right: 0;
        left: 0;
        width: 100%;
        max-width: none
      }

      body.modeMobil.mobilmenu_open #ei_tpl_menu_m a:before {
        content: "\F00D5";
        font-size: 16px;
        top: 16px;
        left: 11px
      }

      body.modeMobil #ei_tpl_logo {
        display: none
      }

      body.modeMobil #ei_tpl_menuPrincipal>nav>ul>li.menuProduit>.e_smenu {
        margin-top: 5px
      }

      body.modeMobil #ei_tpl_level0,
      body.modeMobil #ei_tpl_level1,
      body.modeMobil #ei_tpl_level2 {
        position: absolute;
        width: 0%;
        max-width: none;
        padding-left: 0;
        padding-right: 0;
        background-color: #000;
        left: 0;
        transition: width .3s linear
      }

      body.modeMobil #ei_tpl_level0.focus,
      body.modeMobil #ei_tpl_level1.focus,
      body.modeMobil #ei_tpl_level2.focus {
        width: 100% !important;
        max-width: none !important;
        display: block
      }

      body.modeMobil #ei_tpl_level0 ul li a,
      body.modeMobil #ei_tpl_level1 ul li a,
      body.modeMobil #ei_tpl_level2 ul li a {
        color: #fff
      }

      body.modeMobil #ei_tpl_level0 ul li.menu_title>a,
      body.modeMobil #ei_tpl_level1 ul li.menu_title>a,
      body.modeMobil #ei_tpl_level2 ul li.menu_title>a {
        color: #949494
      }

      body.modeMobil #ei_tpl_level0 ul li.e_select>a,
      body.modeMobil #ei_tpl_level1 ul li.e_select>a,
      body.modeMobil #ei_tpl_level2 ul li.e_select>a {
        color: #bad606
      }

      body.modeMobil #ei_tpl_level0.focus {
        padding-left: 0;
        padding-right: 0
      }

      body.modeMobil.mobilmenu_open.mlevel1 .btRetour,
      body.modeMobil.mobilmenu_open.mlevel2 .btRetour {
        display: block !important
      }

      body.modeMobil #ei_tpl_level1,
      body.modeMobil #ei_tpl_level2 {
        padding: 0
      }

      body.modeMobil #ei_tpl_level1 .ei_scrollContent,
      body.modeMobil #ei_tpl_level2 .ei_scrollContent {
        padding-top: 0
      }

      body.modeMobil #ei_tpl_level1 .menu_h1,
      body.modeMobil #ei_tpl_level2 .menu_h1 {
        display: block
      }

      body.modeMobil .ei_tpl_transac #ei_tpl_level0,
      body.modeMobil .ei_tpl_transac #ei_tpl_level1,
      body.modeMobil .ei_tpl_transac #ei_tpl_level2 {
        background-color: #282828
      }

      body.modeMobil #ei_tpl_menuPrincipal {
        margin-top: 0
      }

      body.modeMobil .e_level2_listecompte ul li a {
        color: #000 !important
      }

      @media screen and (max-width:1400px) {
        #ei_tpl_coleft {
          width: 20%;
          max-width: 20%
        }

        #ei_tpl_colright {
          margin-left: 20%
        }

        header.ei_tpl_header {
          left: 20%
        }
      }

      @media screen and (max-width:1220px) {
        #ei_tpl_profil span {
          white-space: normal
        }

        #ei_tpl_profil span#ei_tpl_ident_infos {
          font-size: .8em;
          line-height: 10px
        }

        #ei_tpl_blocident {
          width: 70px;
          border: 0
        }

        #ei_tpl_blocident a:before {
          content: "" !important
        }

        #ei_tpl_blocident a:after {
          right: calc(50% - 11px) !important
        }

        header.ei_tpl_header #ei_tpl_deconnexion {
          width: 40px;
          max-width: 40px
        }

        header.ei_tpl_header #ei_tpl_deconnexion img {
          display: none
        }

        header.ei_tpl_header #ei_tpl_deconnexion:before {
          content: ""
        }
      }

      @media screen and (max-width:991px) {
        #ei_tpl_content {
          padding-top: 50px
        }

        #ei_tpl_level0,
        #ei_tpl_level1 {
          position: absolute;
          left: -1000px;
          width: 0
        }

        #ei_tpl_coleft {
          position: fixed;
          left: -1000px;
          width: 0
        }

        #ei_tpl_colright {
          margin-left: 0
        }

        #ei_tpl_logo_m.ei_tpl_logo_m {
          flex: 1 1 auto;
          display: block
        }

        #ei_tpl_logo_m.ei_tpl_logo_m a {
          display: none
        }

        .ei_btheader {
          height: 50px
        }

        .ei_btheader a {
          height: 50px
        }

        .ei_btheader a:active,
        .ei_btheader a:focus,
        .ei_btheader a:hover {
          background-color: transparent
        }

        header.ei_tpl_header {
          left: 0;
          padding: 0;
          height: 50px;
          background-color: #000;
          align-items: center
        }

        header.ei_tpl_header>div {
          border: 0
        }

        header.ei_tpl_header a,
        header.ei_tpl_header div,
        header.ei_tpl_header p {
          color: #fff
        }

        header.ei_tpl_header a:before,
        header.ei_tpl_header div:before,
        header.ei_tpl_header p:before {
          color: #fff
        }

        header.ei_tpl_header #ei_tpl_profilmenu a:before {
          color: #000
        }

        header.ei_tpl_header #ei_tpl_search_m {
          display: block
        }

        header.ei_tpl_header #ei_tpl_search_m a#search-head:before {
          left: calc(50% - 10px)
        }

        header.ei_tpl_header #ei_tpl_search_m a.clicable:before {
          content: ''
        }

        header.ei_tpl_header #ei_tpl_search_m a span {
          background-color: transparent;
          right: inherit;
          top: inherit
        }

        header.ei_tpl_header #ei_tpl_search {
          display: none
        }

        header.ei_tpl_header #ei_tpl_profil {
          height: 50px
        }

        header.ei_tpl_header .profilMenu_open .ei_tpl_profil_bt:before {
          top: 16px
        }

        header.ei_tpl_header .ei_tpl_profil_bt:focus {
          border: 0
        }

        header.ei_tpl_header a.bt_connexion {
          top: initial;
          -webkit-transform: initial;
          transform: initial
        }

        header.ei_tpl_header a.bt_connexion div.verticalcenter {
          top: initial;
          -webkit-transform: initial;
          transform: initial
        }

        #ei_tpl_logo_m {
          flex: 1 1 auto;
          display: block;
          padding-bottom: 5px
        }

        #ei_tpl_logo_m a {
          display: block !important
        }

        #ei_tpl_mailbt a span {
          left: auto;
          top: 9px;
          right: 1px
        }

        .ei_tpl_transac header.ei_tpl_header {
          background-color: #282828
        }

        .ei_tpl_transac #ei_tpl_content {
          padding-left: 4px;
          padding-right: 2px
        }

        #ei_tpl_menu_m {
          display: block
        }

        #ei_tpl_mail2bt,
        #ei_tpl_tel2bt,
        #ei_tpl_telbt {
          display: none
        }

        .ei_btheader {
          width: 40px;
          min-width: 40px
        }

        .ei_btheader div,
        .ei_btheader p {
          color: #333
        }

        .ei_btheader p.title-header {
          color: #bad606
        }

        .ei_tpl_profil_bt {
          display: block;
          position: relative
        }

        .ei_tpl_profil_bt:before {
          position: absolute;
          content: "\F08DA";
          font-family: fts_picto;
          speak: none;
          font-style: normal;
          font-weight: 400;
          font-variant: normal;
          text-transform: none;
          line-height: 1;
          -webkit-font-smoothing: antialiased;
          -moz-osx-font-smoothing: grayscale;
          font-size: 25px;
          left: 7px;
          top: 10px
        }

        .ei_tpl_profil_bt:after {
          display: none
        }

        #ei_tpl_profil {
          flex: 0 1 auto;
          position: static;
          width: 40px
        }

        #ei_tpl_profil:hover {
          background-color: transparent
        }

        #ei_tpl_profil #ei_tpl_ident {
          position: fixed;
          display: none;
          top: 50px;
          left: 0;
          right: 0;
          min-height: 50px;
          background-color: #949494
        }

        #ei_tpl_profil #ei_tpl_ident:before {
          top: 9px;
          left: 6px
        }

        #ei_tpl_profil #ei_tpl_ident #ei_tpl_ident_logout {
          display: none
        }

        #ei_tpl_profil #ei_tpl_ident span#ei_tpl_ident_infos {
          color: #fff
        }

        #ei_tpl_profil #ei_tpl_profilmenu {
          top: calc(50px + 50px)
        }

        #ei_tpl_profil #ei_tpl_profilmenu .e_popup_content *,
        #ei_tpl_profil #ei_tpl_profilmenu .e_popup_content a,
        #ei_tpl_profil #ei_tpl_profilmenu .e_popup_content p {
          color: #000
        }

        .profilMenu_open .ei_tpl_profil_bt:before {
          content: "\F00D5";
          font-size: 16px;
          left: 11px;
          top: 14px
        }

        .profilMenu_open .ei_tpl_profil_bt:focus {
          border: 0
        }

        #ei_tpl_blocident {
          display: block;
          position: relative;
          width: 40px;
          top: -1px;
          background-color: #000
        }

        #ei_tpl_blocident a {
          background-color: #000;
          height: 49px
        }

        #ei_tpl_blocident a:after {
          position: absolute;
          left: 9px;
          top: 23px
        }

        #ei_tpl_blocident a:hover:after {
          color: #bad606
        }

        #ei_tpl_blocident a div.verticalcenter div.ei_gly_lock:before {
          line-height: 2
        }
      }

      @media screen and (max-width:991px) {
        .main_header {
          display: block
        }

        #ei_tpl_ariane {
          display: none
        }
      }

      @media screen and (max-width:330px) {
        #ei_tpl_logo_m {
          padding-top: 8px
        }
      }

      @media screen and (max-width:767px) {
        #ei_tpl_menuPrincipal>nav>ul>li>a {
          font-size: 1.071em
        }

        #ei_tpl_menuPrincipal>nav>ul>li>.e_smenu>ul>li:before {
          font-size: 13.125px
        }

        #ei_tpl_menuPrincipal>nav>ul>li.menuProduit>.e_smenu>ul>li>a {
          font-size: 1.071em
        }

        #ei_tpl_menuPrincipal>nav>ul li#ei_m_favoris>a {
          font-size: 1.071em
        }

        #ei_tpl_menuPrincipal>nav>ul li#ei_m_favoris ul li:before {
          font-size: 13.125px
        }

        #ei_tpl_menuPrincipal>nav>ul li#ei_m_favoris ul li a {
          font-size: 1.071em
        }

        #ei_tpl_level1 ul li a {
          font-size: .938em
        }

        #ei_tpl_level1 ul li.menu_title a {
          font-size: .804em
        }

        .modeMobil #ei_tpl_level1 ul li a {
          font-size: 1.071em
        }

        .modeMobil #ei_tpl_level1 .btRetour a {
          font-size: 1.071em
        }
      }

      @media screen and (min-width:1400px) {
        #ei_tpl_menuPrincipal>nav>ul>li>a {
          font-size: 1.1em
        }

        #ei_tpl_menuPrincipal>nav>ul>li>.e_smenu>ul>li:before {
          font-size: 14px
        }

        #ei_tpl_menuPrincipal>nav>ul>li.menuProduit>.e_smenu>ul>li>a {
          font-size: 1.1em
        }

        #ei_tpl_menuPrincipal>nav>ul li#ei_m_favoris>a {
          font-size: 1em
        }

        #ei_tpl_menuPrincipal>nav>ul li#ei_m_favoris ul li:before {
          font-size: 14px
        }

        #ei_tpl_menuPrincipal>nav>ul li#ei_m_favoris ul li a {
          font-size: 1em
        }

        #ei_tpl_level1 ul li a {
          font-size: 1em
        }

        #ei_tpl_level1 ul li.menu_title a {
          font-size: .857em
        }

        .modeMobil #ei_tpl_level1 ul li a {
          font-size: 1.1em
        }

        .modeMobil #ei_tpl_level1 .btRetour a {
          font-size: 1.1em
        }
      }

      @media screen and (min-width:1600px) {
        #ei_tpl_menuPrincipal>nav>ul>li>a {
          font-size: 1.1em
        }

        #ei_tpl_menuPrincipal>nav>ul>li>.e_smenu>ul>li:before {
          font-size: 15.4px
        }

        #ei_tpl_menuPrincipal>nav>ul>li.menuProduit>.e_smenu>ul>li>a {
          font-size: 1.1em
        }

        #ei_tpl_menuPrincipal>nav>ul li#ei_m_favoris>a {
          font-size: 1em
        }

        #ei_tpl_menuPrincipal>nav>ul li#ei_m_favoris ul li:before {
          font-size: 15.4px
        }

        #ei_tpl_menuPrincipal>nav>ul li#ei_m_favoris ul li a {
          font-size: 1em
        }

        #ei_tpl_level1 ul li a {
          font-size: 1em
        }

        #ei_tpl_level1 ul li.menu_title a {
          font-size: .943em
        }

        .modeMobil #ei_tpl_level1 ul li a {
          font-size: 1.1em
        }

        .modeMobil #ei_tpl_level1 .btRetour a {
          font-size: 1.1em
        }
      }

      @media screen and (min-width:1710px) {
        #ei_tpl_menuPrincipal>nav>ul>li>a {
          font-size: 1.2em
        }

        #ei_tpl_menuPrincipal>nav>ul>li>.e_smenu>ul>li:before {
          font-size: 16.8px
        }

        #ei_tpl_menuPrincipal>nav>ul>li.menuProduit>.e_smenu>ul>li>a {
          font-size: 1.2em
        }

        #ei_tpl_menuPrincipal>nav>ul li#ei_m_favoris>a {
          font-size: 1em
        }

        #ei_tpl_menuPrincipal>nav>ul li#ei_m_favoris ul li:before {
          font-size: 16.8px
        }

        #ei_tpl_menuPrincipal>nav>ul li#ei_m_favoris ul li a {
          font-size: 1em
        }

        #ei_tpl_level1 ul li a {
          font-size: 1em
        }

        #ei_tpl_level1 ul li.menu_title a {
          font-size: 1.029em
        }

        .modeMobil #ei_tpl_level1 ul li a {
          font-size: 1.2em
        }

        .modeMobil #ei_tpl_level1 .btRetour a {
          font-size: 1.2em
        }
      }

      @media screen and (min-width:1820px) {
        #ei_tpl_menuPrincipal>nav>ul>li>a {
          font-size: 1.2em
        }

        #ei_tpl_menuPrincipal>nav>ul>li>.e_smenu>ul>li:before {
          font-size: 18.2px
        }

        #ei_tpl_menuPrincipal>nav>ul>li.menuProduit>.e_smenu>ul>li>a {
          font-size: 1.2em
        }

        #ei_tpl_menuPrincipal>nav>ul li#ei_m_favoris>a {
          font-size: 1em
        }

        #ei_tpl_menuPrincipal>nav>ul li#ei_m_favoris ul li:before {
          font-size: 18.2px
        }

        #ei_tpl_menuPrincipal>nav>ul li#ei_m_favoris ul li a {
          font-size: 1em
        }

        #ei_tpl_level1 ul li a {
          font-size: 1em
        }

        #ei_tpl_level1 ul li.menu_title a {
          font-size: 1.114em
        }

        .modeMobil #ei_tpl_level1 ul li a {
          font-size: 1.2em
        }

        .modeMobil #ei_tpl_level1 .btRetour a {
          font-size: 1.2em
        }
      }

      .ei_button {
        border: 0
      }

      .ei_btn {
        display: inline-block;
        border: 0;
        position: relative;
        margin: 0 0 0 10px;
        text-decoration: none;
        text-transform: initial;
        font-weight: 700;
        padding: 12px 20px;
        background-color: #bad606;
        border-radius: 0;
        transition: all .2s linear
      }

      .ei_btn:hover {
        background-color: #758704;
        color: #fff
      }

      .ei_btn:hover .ei_btn_label {
        text-decoration: none
      }

      .ei_btn:hover:after,
      .ei_btn:hover:before {
        color: #fff
      }

      .ei_btn:focus {
        background-color: #758704;
        color: #fff
      }

      .ei_btn:focus .ei_btn_label {
        text-decoration: none
      }

      .ei_btn.ei_btn_disabled {
        cursor: default
      }

      .ei_btn.ei_btn_disabled:focus,
      .ei_btn.ei_btn_disabled:hover {
        background-color: #bad606
      }

      .ei_btn_body {
        display: inline-block
      }

      .ei_btn .ei_btn_body {
        color: #000;
        position: relative;
        text-align: center;
        zoom: 1
      }

      .ei_btn:after,
      .ei_btn:before {
        color: #000;
        position: absolute;
        top: 50% !important;
        bottom: auto;
        -webkit-transform: translateY(-50%);
        transform: translateY(-50%)
      }

      .ei_btn:before {
        padding-left: 2px
      }

      .ei_btn:after {
        padding-right: 2px
      }

      .ei_btn_disabled a.ei_btn,
      a.ei_btn_disabled {
        cursor: default;
        pointer-events: none;
        opacity: .5
      }

      .ei_btn_disabled a.ei_btn .ei_btn_label,
      a.ei_btn_disabled .ei_btn_label {
        text-decoration: none
      }

      .ei_btn_disabled a.ei_btn .ei_btn_blcorn,
      .ei_btn_disabled a.ei_btn .ei_btn_body,
      .ei_btn_disabled a.ei_btn .ei_btn_footer,
      .ei_btn_disabled a.ei_btn .ei_btn_tlcorn,
      a.ei_btn_disabled .ei_btn_blcorn,
      a.ei_btn_disabled .ei_btn_body,
      a.ei_btn_disabled .ei_btn_footer,
      a.ei_btn_disabled .ei_btn_tlcorn {
        opacity: .7
      }

      .ei_buttonbar {
        display: inline-flex;
        flex-wrap: wrap
      }

      .ei_buttonbar>input[type=image] {
        align-self: flex-start
      }

      .ei_buttonbar .ei_mainbutton,
      .ei_buttonbar .ei_mainbuttons {
        order: 1;
        float: none
      }

      .ei_buttonbar .ei_button .ei_btn {
        display: inline-flex !important;
        height: 100%;
        box-sizing: border-box;
        justify-content: center
      }

      .ei_buttonbar .ei_button .ei_btn .ei_btn_body {
        align-self: center
      }

      .ei_buttonbar .ei_button .ei_btn .ei_btn_body .ei_btn_pic:not(empty) {
        display: none
      }

      .ei_newlb .ei_buttonbar .ei_mainbuttons {
        height: 100%
      }

      .ei_newlb .ei_buttonbar img {
        height: 100%
      }

      .ei_buttonbar>a {
        line-height: 2.2
      }

      .ei_imgbtn img {
        display: none
      }

      .ei_imgbtn:hover {
        text-decoration: none
      }

      .ei_imgbtn:after {
        font-family: fts_picto;
        font-size: 20px
      }

      .ei_imgbtn.ei_btn_typ_first-page:after {
        content: "\F02BA"
      }

      .ei_imgbtn.ei_btn_typ_previous-page:after {
        content: "\F0328"
      }

      .ei_imgbtn.ei_btn_typ_next-page:after {
        content: "\F0329"
      }

      .ei_imgbtn.ei_btn_typ_last-page:after {
        content: "\F0339"
      }

      .ei_imgbtn.ei_btn_typ_previous-item:after {
        content: "\F01B6"
      }

      .ei_imgbtn.ei_btn_typ_next-item:after {
        content: "\F01B7"
      }

      .ei_imgbtn.ei_btn_typ_remove-item-horizontal:after {
        content: "\F0328"
      }

      .ei_imgbtn.ei_btn_typ_add-item-horizontal:after {
        content: "\F0329"
      }

      .ei_imgbtn.ei_btn_typ_add-all-items-horizontal,
      .ei_imgbtn.ei_btn_typ_add-all-items-vertical,
      .ei_imgbtn.ei_btn_typ_add-item-horizontal,
      .ei_imgbtn.ei_btn_typ_add-item-vertical,
      .ei_imgbtn.ei_btn_typ_remove-all-items-horizontal,
      .ei_imgbtn.ei_btn_typ_remove-all-items-vertical,
      .ei_imgbtn.ei_btn_typ_remove-item-horizontal,
      .ei_imgbtn.ei_btn_typ_remove-item-vertical {
        background-color: #4170a9;
        color: #fff;
        display: inline-block;
        height: 25px;
        line-height: 25px;
        text-align: center;
        width: 25px
      }

      .ei_imgbtn.ei_btn_typ_add-all-items-horizontal:hover,
      .ei_imgbtn.ei_btn_typ_add-all-items-vertical:hover,
      .ei_imgbtn.ei_btn_typ_add-item-horizontal:hover,
      .ei_imgbtn.ei_btn_typ_add-item-vertical:hover,
      .ei_imgbtn.ei_btn_typ_remove-all-items-horizontal:hover,
      .ei_imgbtn.ei_btn_typ_remove-all-items-vertical:hover,
      .ei_imgbtn.ei_btn_typ_remove-item-horizontal:hover,
      .ei_imgbtn.ei_btn_typ_remove-item-vertical:hover {
        background-color: #01638c
      }

      .ei_imgbtn .ei_btn_typ_search-icon:after {
        content: "\F08DE"
      }

      .ei_btn {
        font-size: .88em !important;
        font-weight: 400;
        min-height: 30px;
        margin: 0 5px;
        min-width: auto;
        padding: 12px 20px;
        text-align: center;
        vertical-align: top;
        letter-spacing: .02em;
        box-sizing: border-box;
        cursor: pointer
      }

      .ei_btn .ei_iblock {
        display: none
      }

      .ei_btn span {
        font-size: 13px;
        font-family: "Helvetica Neue", Helvetica, Arial, sans-serif;
        font-weight: 400;
        font-size: 1.05em
      }

      .ei_editableoutput .ei_btn {
        vertical-align: middle
      }

      a.ei_btn {
        text-decoration: none !important
      }

      .ei_btn_fn_backward,
      .ei_btn_typ_back,
      .ei_btn_typ_cancel,
      .ei_btn_typ_change,
      .ei_btn_typ_del,
      .ei_btn_typ_no,
      .ei_btn_typ_prev,
      .ei_btn_typ_quit,
      .ei_btn_typ_reset {
        background-color: #000;
        border: 0;
        color: #fff
      }

      div.a_blocappli .ei_btn_fn_backward,
      div.a_blocappli .ei_btn_typ_back,
      div.a_blocappli .ei_btn_typ_cancel,
      div.a_blocappli .ei_btn_typ_change,
      div.a_blocappli .ei_btn_typ_del,
      div.a_blocappli .ei_btn_typ_no,
      div.a_blocappli .ei_btn_typ_prev,
      div.a_blocappli .ei_btn_typ_quit,
      div.a_blocappli .ei_btn_typ_reset {
        color: #fff
      }

      .ei_btn_fn_backward span,
      .ei_btn_typ_back span,
      .ei_btn_typ_cancel span,
      .ei_btn_typ_change span,
      .ei_btn_typ_del span,
      .ei_btn_typ_no span,
      .ei_btn_typ_prev span,
      .ei_btn_typ_quit span,
      .ei_btn_typ_reset span {
        font-weight: 600
      }

      .ei_btn_fn_backward .ei_btn_body,
      .ei_btn_typ_back .ei_btn_body,
      .ei_btn_typ_cancel .ei_btn_body,
      .ei_btn_typ_change .ei_btn_body,
      .ei_btn_typ_del .ei_btn_body,
      .ei_btn_typ_no .ei_btn_body,
      .ei_btn_typ_prev .ei_btn_body,
      .ei_btn_typ_quit .ei_btn_body,
      .ei_btn_typ_reset .ei_btn_body {
        color: #fff;
        font-family: "Helvetica Neue", Helvetica, Arial, sans-serif;
        font-weight: 700;
        font-size: 1em
      }

      .ei_btn_fn_backward:focus,
      .ei_btn_fn_backward:hover,
      .ei_btn_typ_back:focus,
      .ei_btn_typ_back:hover,
      .ei_btn_typ_cancel:focus,
      .ei_btn_typ_cancel:hover,
      .ei_btn_typ_change:focus,
      .ei_btn_typ_change:hover,
      .ei_btn_typ_del:focus,
      .ei_btn_typ_del:hover,
      .ei_btn_typ_no:focus,
      .ei_btn_typ_no:hover,
      .ei_btn_typ_prev:focus,
      .ei_btn_typ_prev:hover,
      .ei_btn_typ_quit:focus,
      .ei_btn_typ_quit:hover,
      .ei_btn_typ_reset:focus,
      .ei_btn_typ_reset:hover {
        background-color: #000
      }

      .ei_btn_typ_reset .ei_btn_body {
        position: relative;
        text-align: center;
        padding-left: 20px
      }

      .ei_btn_typ_reset .ei_btn_body:before {
        position: absolute;
        left: 0;
        top: calc(50% - .55em);
        font-family: fts_picto;
        content: "\F041B";
        font-size: 1.5em
      }

      .ei_incrementer .ei_button .ei_btn {
        min-height: auto
      }

      .ei_loadmorebtn {
        position: relative;
        display: block !important;
        padding: 5px 13px 13px 13px;
        transition: all .2s linear
      }

      .ei_loadmorebtn:focus,
      .ei_loadmorebtn:hover {
        text-decoration: none
      }

      .ei_loadmorebtn span {
        font-size: 12px
      }

      .ei_loadmorebtn span:after {
        font-family: fts_picto;
        content: "\F0327";
        font-size: 10px;
        font-weight: 400;
        position: absolute;
        top: 26px;
        left: calc(50% - 3px);
        padding: 0;
        margin-left: -4px
      }

      .ei_btn span,
      .ei_btn span.ei_btn_body {
        padding: 7px 10px;
        font-weight: 700;
        font-size: 1.1em
      }

      .blocAuthent #login-submit .ei_btn span {
        padding: 0
      }

      .blocAuthent #login-submit .ei_btn .ei_btn_body {
        position: relative;
        z-index: 1
      }

      .blocAuthent #login-submit .ei_btn::after {
        background-color: #fff;
        opacity: .5;
        content: '';
        display: block;
        width: 0%;
        transition: width .4s;
        position: absolute;
        left: -1px;
        top: 0;
        height: 100%
      }

      .blocAuthent #login-submit .ei_btn:not(.ei_btn_typ_cancel):not(.ei_btn_typ_prev):not(.ei_btn_typ_reset):not(.ei_btn_typ_back):not(.ei_btn_typ_del):not(.ei_btn_typ_no):not(.ei_btn_typ_change):not(.ei_btn_typ_quit):not(.ei_btn_fn_backward):hover {
        background-color: #bad606
      }

      .blocAuthent #login-submit .ei_btn:not(.ei_btn_typ_cancel):not(.ei_btn_typ_prev):not(.ei_btn_typ_reset):not(.ei_btn_typ_back):not(.ei_btn_typ_del):not(.ei_btn_typ_no):not(.ei_btn_typ_change):not(.ei_btn_typ_quit):not(.ei_btn_fn_backward):hover::after {
        width: 101%
      }

      .blocAuthent #login-submit .ei_btn:focus {
        background-color: #bad606
      }

      #bg_modal_name {
        display: none;
        position: fixed;
        left: 0;
        top: 0;
        width: 100%;
        height: 100%;
        z-index: 9994
      }

      .blocfondmodal {
        background-color: #000;
        opacity: .7
      }

      .ei_blocmodal_env {
        position: fixed;
        top: 50%;
        left: 50%;
        z-index: 99999
      }

      .ei_blocmodal_env .a_blocappli {
        background-color: transparent
      }

      .blocmodal {
        display: none;
        z-index: 99999;
        float: left;
        position: fixed;
        top: 50%;
        left: 50%
      }

      .blocmodal,
      .ei_blocmodal {
        background: #fff;
        border: 0;
        width: 400px;
        box-shadow: 0 11px 15px -7px rgba(0, 0, 0, .2), 0 24px 38px 3px rgba(0, 0, 0, .14), 0 9px 46px 8px rgba(0, 0, 0, .12);
        border-radius: 0
      }

      .blocmodal .a_blocfctltitre,
      .blocmodal .ei_titleblock,
      .ei_blocmodal .a_blocfctltitre,
      .ei_blocmodal .ei_titleblock {
        background-color: #fff;
        height: 25px;
        padding: 0;
        padding-bottom: 5px;
        border-radius: 0;
        border: 0;
        margin: 0
      }

      .blocmodal .a_blocfctltitre p,
      .blocmodal .ei_titleblock p,
      .ei_blocmodal .a_blocfctltitre p,
      .ei_blocmodal .ei_titleblock p {
        margin: 0
      }

      .blocmodal .a_blocfctltitre p.a_options,
      .blocmodal .ei_titleblock p.a_options,
      .ei_blocmodal .a_blocfctltitre p.a_options,
      .ei_blocmodal .ei_titleblock p.a_options {
        float: right;
        margin-right: 10px;
        margin-top: 10px;
        padding: 0;
        background-color: transparent
      }

      .blocmodal .a_blocfctltitre p.a_titre2,
      .blocmodal .ei_titleblock p.a_titre2,
      .ei_blocmodal .a_blocfctltitre p.a_titre2,
      .ei_blocmodal .ei_titleblock p.a_titre2 {
        float: left;
        background: transparent none;
        border: 0;
        padding: 5px 0 0 0;
        color: #494949;
        font-size: 1.2em;
        font-weight: 400
      }

      .blocmodal .a_blocfctl,
      .blocmodal .ei_mainblocfctl,
      .ei_blocmodal .a_blocfctl,
      .ei_blocmodal .ei_mainblocfctl {
        background-color: transparent;
        border: 0;
        margin: 0;
        margin-top: 20px;
        padding: 0;
        padding-bottom: 5px
      }

      .blocmodal .a_blocfctl:focus,
      .blocmodal .ei_mainblocfctl:focus,
      .ei_blocmodal .a_blocfctl:focus,
      .ei_blocmodal .ei_mainblocfctl:focus {
        border: 0;
        outline: 0
      }

      .blocmodal .a_blocfctl p,
      .blocmodal .ei_mainblocfctl p,
      .ei_blocmodal .a_blocfctl p,
      .ei_blocmodal .ei_mainblocfctl p {
        margin: 5px
      }

      .blocmodal .blocboutons,
      .ei_blocmodal .blocboutons {
        background: 0 0;
        padding: 5px;
        margin: 20px 5px 5px 5px;
        border: 0;
        text-align: center
      }

      .blocmodal .blocboutons .blocdecision,
      .ei_blocmodal .blocboutons .blocdecision {
        padding-bottom: 5px
      }

      .blocmodal .blocboutons .blocdecision input,
      .ei_blocmodal .blocboutons .blocdecision input {
        margin: 0 5px
      }

      .blocmodal .blocboutons .blocdecision p,
      .ei_blocmodal .blocboutons .blocdecision p {
        color: #3a3b3b
      }

      .ei_newlb.ei_blocmodal_env {
        position: fixed;
        top: 0;
        left: 0;
        z-index: 9995;
        width: 100% !important;
        height: 100% !important;
        margin: 0 !important;
        background: 0 0 !important;
        max-width: 100% !important;
        -webkit-overflow-scrolling: touch;
        overflow-x: hidden;
        overflow-y: auto
      }

      .ei_newlb.ei_blocmodal_env .ei_blocmodal {
        position: relative;
        margin: 15px auto !important;
        padding: 10px;
        box-sizing: content-box !important;
        height: auto !important;
        max-width: 80%;
        overflow-x: auto;
        top: 36%;
        border-left: 10px solid #494949
      }

      .ei_newlb.ei_blocmodal_env .ei_blocmodal .a_blocfctltitre,
      .ei_newlb.ei_blocmodal_env .ei_blocmodal .ei_titleblock {
        height: auto;
        position: relative;
        min-height: 25px;
        padding-bottom: 15px;
        padding-top: 10px;
        border-bottom: 1px solid #ccc
      }

      .ei_newlb.ei_blocmodal_env .ei_blocmodal .a_blocfctltitre p.a_titre2,
      .ei_newlb.ei_blocmodal_env .ei_blocmodal .ei_titleblock p.a_titre2 {
        float: none;
        display: block;
        font-size: 1.5em
      }

      .ei_newlb.ei_blocmodal_env .ei_blocmodal.ei_lbmax {
        width: 80% !important
      }

      .ei_newlb.ei_blocmodal_env .ei_blocmodal.ei_lbmaxfix {
        width: 90% !important;
        height: 90% !important;
        top: 3%;
        display: flex;
        flex-direction: column
      }

      .ei_newlb.ei_blocmodal_env .ei_blocmodal.ei_lbmaxfix>.a_blocfctl {
        flex: 1;
        display: flex;
        flex-direction: column
      }

      .ei_newlb.ei_blocmodal_env .ei_blocmodal.ei_lbmaxfix>.a_blocfctl>:not(.blocboutons) {
        flex: 1;
        display: flex;
        flex-direction: column;
        overflow: auto
      }

      .ei_newlb.ei_blocmodal_env .ei_blocmodal.ei_lbmaxfix>.a_blocfctl .ei_lbwrap {
        flex: 1;
        display: flex;
        flex-direction: column
      }

      .ei_newlb.ei_blocmodal_env .ei_blocmodal.ei_lbmaxfix>.a_blocfctl .ei_lbwrap>.ei_lbctn {
        flex: 1;
        overflow: auto
      }

      .ei_newlb.ei_blocmodal_env .ei_blocmodal .ei_lb_btnskip {
        display: block
      }

      .ei_newlb.ei_blocmodal_env .ei_blocmodal .ei_lb_btnskip_icon {
        position: relative;
        margin-right: 11px
      }

      .ei_newlb.ei_blocmodal_env .ei_blocmodal .ei_lb_btnskip_icon:after {
        content: "\F0329";
        font-family: fts_picto;
        speak: none;
        font-style: normal;
        font-weight: 400;
        font-variant: normal;
        text-transform: none;
        line-height: 1;
        -webkit-font-smoothing: antialiased;
        -moz-osx-font-smoothing: grayscale;
        vertical-align: middle;
        font-size: 1.4em;
        position: absolute;
        top: 0
      }

      @media screen and (max-width:991px) {
        .ei_newlb.ei_blocmodal_env .ei_blocmodal .ei_lb_btnskip {
          padding-bottom: 12px
        }
      }

      .ei_newlb.ei_blocmodal_env .ei_blocmodal .oblig {
        color: #d4041c
      }

      .ei_newlb.ei_blocmodal_env .lightbox_padding {
        padding-left: 55px
      }

      .ei_newlb.ei_blocmodal_env .ei_blocmodal.ei_lb_err {
        border-left: 10px solid red
      }

      .ei_newlb.ei_blocmodal_env .ei_blocmodal.ei_lb_err .a_blocfctltitre {
        padding-left: 55px;
        background-color: transparent
      }

      .ei_newlb.ei_blocmodal_env .ei_blocmodal.ei_lb_err .a_blocfctltitre:before {
        font-family: fts_picto;
        speak: none;
        font-style: normal;
        font-weight: 400;
        font-variant: normal;
        text-transform: none;
        line-height: 1;
        -webkit-font-smoothing: antialiased;
        -moz-osx-font-smoothing: grayscale;
        content: "\F011D";
        display: block;
        font-size: 40px;
        width: 41px;
        height: 41px;
        border-radius: 100%;
        position: absolute;
        text-align: center;
        color: red;
        padding-bottom: 5px;
        left: 0;
        top: 50%;
        -webkit-transform: translateY(-50%);
        transform: translateY(-50%)
      }

      .ei_newlb.ei_blocmodal_env .ei_blocmodal.ei_lb_err .a_blocfctltitre p.a_titre2 {
        color: #000
      }

      .ei_newlb.ei_blocmodal_env .ei_blocmodal.ei_lb_alerte {
        border-left: 10px solid #ffa200
      }

      .ei_newlb.ei_blocmodal_env .ei_blocmodal.ei_lb_alerte .a_blocfctltitre {
        padding-left: 55px;
        background-color: transparent
      }

      .ei_newlb.ei_blocmodal_env .ei_blocmodal.ei_lb_alerte .a_blocfctltitre:before {
        font-family: fts_picto;
        speak: none;
        font-style: normal;
        font-weight: 400;
        font-variant: normal;
        text-transform: none;
        line-height: 1;
        -webkit-font-smoothing: antialiased;
        -moz-osx-font-smoothing: grayscale;
        content: "\F001C";
        display: block;
        font-size: 40px;
        width: 41px;
        height: 41px;
        border-radius: 100%;
        position: absolute;
        text-align: center;
        color: #ffa200;
        padding-bottom: 5px;
        left: 0;
        top: 50%;
        -webkit-transform: translateY(-50%);
        transform: translateY(-50%)
      }

      .ei_newlb.ei_blocmodal_env .ei_blocmodal.ei_lb_alerte .a_blocfctltitre p.a_titre2 {
        color: #000
      }

      .ei_newlb.ei_blocmodal_env .ei_blocmodal.ei_lb_info {
        border-left: 10px solid #333
      }

      .ei_newlb.ei_blocmodal_env .ei_blocmodal.ei_lb_info .a_blocfctltitre {
        padding-left: 55px;
        background-color: transparent
      }

      .ei_newlb.ei_blocmodal_env .ei_blocmodal.ei_lb_info .a_blocfctltitre:before {
        font-family: fts_picto;
        speak: none;
        font-style: normal;
        font-weight: 400;
        font-variant: normal;
        text-transform: none;
        line-height: 1;
        -webkit-font-smoothing: antialiased;
        -moz-osx-font-smoothing: grayscale;
        content: "\F0518";
        display: block;
        font-size: 40px;
        width: 41px;
        height: 41px;
        border-radius: 100%;
        position: absolute;
        text-align: center;
        color: #333;
        padding-bottom: 5px;
        left: 0;
        top: 50%;
        -webkit-transform: translateY(-50%);
        transform: translateY(-50%)
      }

      .ei_newlb.ei_blocmodal_env .ei_blocmodal.ei_lb_info .a_blocfctltitre p.a_titre2 {
        color: #000
      }

      .ei_newlb.ei_blocmodal_env .ei_blocmodal.ei_lb_succes {
        border-left: 10px solid #bad606
      }

      .ei_newlb.ei_blocmodal_env .ei_blocmodal.ei_lb_succes .a_blocfctltitre {
        padding-left: 55px;
        background-color: transparent
      }

      .ei_newlb.ei_blocmodal_env .ei_blocmodal.ei_lb_succes .a_blocfctltitre:before {
        font-family: fts_picto;
        speak: none;
        font-style: normal;
        font-weight: 400;
        font-variant: normal;
        text-transform: none;
        line-height: 1;
        -webkit-font-smoothing: antialiased;
        -moz-osx-font-smoothing: grayscale;
        content: "\F071D";
        display: block;
        font-size: 40px;
        width: 41px;
        height: 41px;
        border-radius: 100%;
        position: absolute;
        text-align: center;
        color: #bad606;
        padding-bottom: 5px;
        left: 0;
        top: 50%;
        -webkit-transform: translateY(-50%);
        transform: translateY(-50%)
      }

      .ei_newlb.ei_blocmodal_env .ei_blocmodal.ei_lb_succes .a_blocfctltitre p.a_titre2 {
        color: #000
      }

      .ei_with_lb_bginit~div .ei_blocmodal {
        background-color: #fff;
        color: #333 !important
      }

      .ei_with_lb_bginit~div .ei_blocmodal .a_blocfctl {
        background-color: #fff;
        color: #333
      }

      .ei_blocmodal_env,
      .ei_blocmodal_env.a_blocappli {
        background-color: #fff;
        padding: 0
      }

      .blocmodal,
      .ei_blocmodal {
        padding: 10px
      }

      .a_blocfctl .blocmodal,
      .a_blocfctl .ei_blocmodal,
      .blocmodal,
      .ei_blocmodal,
      .ei_mainblocfctl .blocmodal,
      .ei_mainblocfctl .ei_blocmodal {
        box-shadow: none;
        background-color: #fff
      }

      .a_blocfctl .blocmodal .a_blocfctltitre,
      .a_blocfctl .blocmodal .ei_titleblock,
      .a_blocfctl .ei_blocmodal .a_blocfctltitre,
      .a_blocfctl .ei_blocmodal .ei_titleblock,
      .blocmodal .a_blocfctltitre,
      .blocmodal .ei_titleblock,
      .ei_blocmodal .a_blocfctltitre,
      .ei_blocmodal .ei_titleblock,
      .ei_mainblocfctl .blocmodal .a_blocfctltitre,
      .ei_mainblocfctl .blocmodal .ei_titleblock,
      .ei_mainblocfctl .ei_blocmodal .a_blocfctltitre,
      .ei_mainblocfctl .ei_blocmodal .ei_titleblock {
        border-radius: 0;
        padding: 10px 0;
        font-weight: 700;
        background-color: #fff
      }

      .a_blocfctl .blocmodal .a_blocfctltitre .a_titre2,
      .a_blocfctl .blocmodal .a_blocfctltitre .titre2,
      .a_blocfctl .blocmodal .a_blocfctltitre h2,
      .a_blocfctl .blocmodal .ei_titleblock .a_titre2,
      .a_blocfctl .blocmodal .ei_titleblock .titre2,
      .a_blocfctl .blocmodal .ei_titleblock h2,
      .a_blocfctl .ei_blocmodal .a_blocfctltitre .a_titre2,
      .a_blocfctl .ei_blocmodal .a_blocfctltitre .titre2,
      .a_blocfctl .ei_blocmodal .a_blocfctltitre h2,
      .a_blocfctl .ei_blocmodal .ei_titleblock .a_titre2,
      .a_blocfctl .ei_blocmodal .ei_titleblock .titre2,
      .a_blocfctl .ei_blocmodal .ei_titleblock h2,
      .blocmodal .a_blocfctltitre .a_titre2,
      .blocmodal .a_blocfctltitre .titre2,
      .blocmodal .a_blocfctltitre h2,
      .blocmodal .ei_titleblock .a_titre2,
      .blocmodal .ei_titleblock .titre2,
      .blocmodal .ei_titleblock h2,
      .ei_blocmodal .a_blocfctltitre .a_titre2,
      .ei_blocmodal .a_blocfctltitre .titre2,
      .ei_blocmodal .a_blocfctltitre h2,
      .ei_blocmodal .ei_titleblock .a_titre2,
      .ei_blocmodal .ei_titleblock .titre2,
      .ei_blocmodal .ei_titleblock h2,
      .ei_mainblocfctl .blocmodal .a_blocfctltitre .a_titre2,
      .ei_mainblocfctl .blocmodal .a_blocfctltitre .titre2,
      .ei_mainblocfctl .blocmodal .a_blocfctltitre h2,
      .ei_mainblocfctl .blocmodal .ei_titleblock .a_titre2,
      .ei_mainblocfctl .blocmodal .ei_titleblock .titre2,
      .ei_mainblocfctl .blocmodal .ei_titleblock h2,
      .ei_mainblocfctl .ei_blocmodal .a_blocfctltitre .a_titre2,
      .ei_mainblocfctl .ei_blocmodal .a_blocfctltitre .titre2,
      .ei_mainblocfctl .ei_blocmodal .a_blocfctltitre h2,
      .ei_mainblocfctl .ei_blocmodal .ei_titleblock .a_titre2,
      .ei_mainblocfctl .ei_blocmodal .ei_titleblock .titre2,
      .ei_mainblocfctl .ei_blocmodal .ei_titleblock h2 {
        background-color: transparent;
        font-size: 1em;
        font-family: "Helvetica Neue", Helvetica, Arial, sans-serif;
        font-weight: 400;
        font-size: 1.05em;
        padding: 0 !important;
        font-size: 1.143em;
        color: #494949
      }

      .a_blocfctl .blocmodal .a_blocfctltitre .a_titre2:after,
      .a_blocfctl .blocmodal .a_blocfctltitre .titre2:after,
      .a_blocfctl .blocmodal .a_blocfctltitre h2:after,
      .a_blocfctl .blocmodal .ei_titleblock .a_titre2:after,
      .a_blocfctl .blocmodal .ei_titleblock .titre2:after,
      .a_blocfctl .blocmodal .ei_titleblock h2:after,
      .a_blocfctl .ei_blocmodal .a_blocfctltitre .a_titre2:after,
      .a_blocfctl .ei_blocmodal .a_blocfctltitre .titre2:after,
      .a_blocfctl .ei_blocmodal .a_blocfctltitre h2:after,
      .a_blocfctl .ei_blocmodal .ei_titleblock .a_titre2:after,
      .a_blocfctl .ei_blocmodal .ei_titleblock .titre2:after,
      .a_blocfctl .ei_blocmodal .ei_titleblock h2:after,
      .blocmodal .a_blocfctltitre .a_titre2:after,
      .blocmodal .a_blocfctltitre .titre2:after,
      .blocmodal .a_blocfctltitre h2:after,
      .blocmodal .ei_titleblock .a_titre2:after,
      .blocmodal .ei_titleblock .titre2:after,
      .blocmodal .ei_titleblock h2:after,
      .ei_blocmodal .a_blocfctltitre .a_titre2:after,
      .ei_blocmodal .a_blocfctltitre .titre2:after,
      .ei_blocmodal .a_blocfctltitre h2:after,
      .ei_blocmodal .ei_titleblock .a_titre2:after,
      .ei_blocmodal .ei_titleblock .titre2:after,
      .ei_blocmodal .ei_titleblock h2:after,
      .ei_mainblocfctl .blocmodal .a_blocfctltitre .a_titre2:after,
      .ei_mainblocfctl .blocmodal .a_blocfctltitre .titre2:after,
      .ei_mainblocfctl .blocmodal .a_blocfctltitre h2:after,
      .ei_mainblocfctl .blocmodal .ei_titleblock .a_titre2:after,
      .ei_mainblocfctl .blocmodal .ei_titleblock .titre2:after,
      .ei_mainblocfctl .blocmodal .ei_titleblock h2:after,
      .ei_mainblocfctl .ei_blocmodal .a_blocfctltitre .a_titre2:after,
      .ei_mainblocfctl .ei_blocmodal .a_blocfctltitre .titre2:after,
      .ei_mainblocfctl .ei_blocmodal .a_blocfctltitre h2:after,
      .ei_mainblocfctl .ei_blocmodal .ei_titleblock .a_titre2:after,
      .ei_mainblocfctl .ei_blocmodal .ei_titleblock .titre2:after,
      .ei_mainblocfctl .ei_blocmodal .ei_titleblock h2:after {
        content: ""
      }

      .a_blocfctl .blocmodal .a_blocfctltitre p.a_options,
      .a_blocfctl .blocmodal .ei_titleblock p.a_options,
      .a_blocfctl .ei_blocmodal .a_blocfctltitre p.a_options,
      .a_blocfctl .ei_blocmodal .ei_titleblock p.a_options,
      .blocmodal .a_blocfctltitre p.a_options,
      .blocmodal .ei_titleblock p.a_options,
      .ei_blocmodal .a_blocfctltitre p.a_options,
      .ei_blocmodal .ei_titleblock p.a_options,
      .ei_mainblocfctl .blocmodal .a_blocfctltitre p.a_options,
      .ei_mainblocfctl .blocmodal .ei_titleblock p.a_options,
      .ei_mainblocfctl .ei_blocmodal .a_blocfctltitre p.a_options,
      .ei_mainblocfctl .ei_blocmodal .ei_titleblock p.a_options {
        margin-top: 0
      }

      .a_blocfctl .blocmodal .a_blocfctltitre .btnclose,
      .a_blocfctl .blocmodal .ei_titleblock .btnclose,
      .a_blocfctl .ei_blocmodal .a_blocfctltitre .btnclose,
      .a_blocfctl .ei_blocmodal .ei_titleblock .btnclose,
      .blocmodal .a_blocfctltitre .btnclose,
      .blocmodal .ei_titleblock .btnclose,
      .ei_blocmodal .a_blocfctltitre .btnclose,
      .ei_blocmodal .ei_titleblock .btnclose,
      .ei_mainblocfctl .blocmodal .a_blocfctltitre .btnclose,
      .ei_mainblocfctl .blocmodal .ei_titleblock .btnclose,
      .ei_mainblocfctl .ei_blocmodal .a_blocfctltitre .btnclose,
      .ei_mainblocfctl .ei_blocmodal .ei_titleblock .btnclose {
        text-decoration: none
      }

      .a_blocfctl .blocmodal .a_blocfctltitre .btnclose img,
      .a_blocfctl .blocmodal .ei_titleblock .btnclose img,
      .a_blocfctl .ei_blocmodal .a_blocfctltitre .btnclose img,
      .a_blocfctl .ei_blocmodal .ei_titleblock .btnclose img,
      .blocmodal .a_blocfctltitre .btnclose img,
      .blocmodal .ei_titleblock .btnclose img,
      .ei_blocmodal .a_blocfctltitre .btnclose img,
      .ei_blocmodal .ei_titleblock .btnclose img,
      .ei_mainblocfctl .blocmodal .a_blocfctltitre .btnclose img,
      .ei_mainblocfctl .blocmodal .ei_titleblock .btnclose img,
      .ei_mainblocfctl .ei_blocmodal .a_blocfctltitre .btnclose img,
      .ei_mainblocfctl .ei_blocmodal .ei_titleblock .btnclose img {
        opacity: 0;
        font-size: 0
      }

      .a_blocfctl .blocmodal .a_blocfctltitre .btnclose:after,
      .a_blocfctl .blocmodal .ei_titleblock .btnclose:after,
      .a_blocfctl .ei_blocmodal .a_blocfctltitre .btnclose:after,
      .a_blocfctl .ei_blocmodal .ei_titleblock .btnclose:after,
      .blocmodal .a_blocfctltitre .btnclose:after,
      .blocmodal .ei_titleblock .btnclose:after,
      .ei_blocmodal .a_blocfctltitre .btnclose:after,
      .ei_blocmodal .ei_titleblock .btnclose:after,
      .ei_mainblocfctl .blocmodal .a_blocfctltitre .btnclose:after,
      .ei_mainblocfctl .blocmodal .ei_titleblock .btnclose:after,
      .ei_mainblocfctl .ei_blocmodal .a_blocfctltitre .btnclose:after,
      .ei_mainblocfctl .ei_blocmodal .ei_titleblock .btnclose:after {
        content: "\F00D5";
        font-family: fts_picto;
        font-size: 14px;
        display: inline-block;
        font-weight: 400;
        position: relative;
        top: 3px;
        color: #474747
      }

      .a_blocfctl .blocmodal .a_blocfctl,
      .a_blocfctl .blocmodal .ei_mainblocfctl,
      .a_blocfctl .ei_blocmodal .a_blocfctl,
      .a_blocfctl .ei_blocmodal .ei_mainblocfctl,
      .blocmodal .a_blocfctl,
      .blocmodal .ei_mainblocfctl,
      .ei_blocmodal .a_blocfctl,
      .ei_blocmodal .ei_mainblocfctl,
      .ei_mainblocfctl .blocmodal .a_blocfctl,
      .ei_mainblocfctl .blocmodal .ei_mainblocfctl,
      .ei_mainblocfctl .ei_blocmodal .a_blocfctl,
      .ei_mainblocfctl .ei_blocmodal .ei_mainblocfctl {
        padding: 0;
        margin: 0;
        border: 0
      }

      .a_blocfctl .blocmodal .a_blocfctl table.saisie .ei-saisie__th,
      .a_blocfctl .blocmodal .a_blocfctl table.saisie .ei_saisie__th,
      .a_blocfctl .blocmodal .a_blocfctl table.saisie td,
      .a_blocfctl .blocmodal .a_blocfctl table.saisie th,
      .a_blocfctl .blocmodal .ei_mainblocfctl table.saisie .ei-saisie__th,
      .a_blocfctl .blocmodal .ei_mainblocfctl table.saisie .ei_saisie__th,
      .a_blocfctl .blocmodal .ei_mainblocfctl table.saisie td,
      .a_blocfctl .blocmodal .ei_mainblocfctl table.saisie th,
      .a_blocfctl .ei_blocmodal .a_blocfctl table.saisie .ei-saisie__th,
      .a_blocfctl .ei_blocmodal .a_blocfctl table.saisie .ei_saisie__th,
      .a_blocfctl .ei_blocmodal .a_blocfctl table.saisie td,
      .a_blocfctl .ei_blocmodal .a_blocfctl table.saisie th,
      .a_blocfctl .ei_blocmodal .ei_mainblocfctl table.saisie .ei-saisie__th,
      .a_blocfctl .ei_blocmodal .ei_mainblocfctl table.saisie .ei_saisie__th,
      .a_blocfctl .ei_blocmodal .ei_mainblocfctl table.saisie td,
      .a_blocfctl .ei_blocmodal .ei_mainblocfctl table.saisie th,
      .blocmodal .a_blocfctl table.saisie .ei-saisie__th,
      .blocmodal .a_blocfctl table.saisie .ei_saisie__th,
      .blocmodal .a_blocfctl table.saisie td,
      .blocmodal .a_blocfctl table.saisie th,
      .blocmodal .ei_mainblocfctl table.saisie .ei-saisie__th,
      .blocmodal .ei_mainblocfctl table.saisie .ei_saisie__th,
      .blocmodal .ei_mainblocfctl table.saisie td,
      .blocmodal .ei_mainblocfctl table.saisie th,
      .ei_blocmodal .a_blocfctl table.saisie .ei-saisie__th,
      .ei_blocmodal .a_blocfctl table.saisie .ei_saisie__th,
      .ei_blocmodal .a_blocfctl table.saisie td,
      .ei_blocmodal .a_blocfctl table.saisie th,
      .ei_blocmodal .ei_mainblocfctl table.saisie .ei-saisie__th,
      .ei_blocmodal .ei_mainblocfctl table.saisie .ei_saisie__th,
      .ei_blocmodal .ei_mainblocfctl table.saisie td,
      .ei_blocmodal .ei_mainblocfctl table.saisie th,
      .ei_mainblocfctl .blocmodal .a_blocfctl table.saisie .ei-saisie__th,
      .ei_mainblocfctl .blocmodal .a_blocfctl table.saisie .ei_saisie__th,
      .ei_mainblocfctl .blocmodal .a_blocfctl table.saisie td,
      .ei_mainblocfctl .blocmodal .a_blocfctl table.saisie th,
      .ei_mainblocfctl .blocmodal .ei_mainblocfctl table.saisie .ei-saisie__th,
      .ei_mainblocfctl .blocmodal .ei_mainblocfctl table.saisie .ei_saisie__th,
      .ei_mainblocfctl .blocmodal .ei_mainblocfctl table.saisie td,
      .ei_mainblocfctl .blocmodal .ei_mainblocfctl table.saisie th,
      .ei_mainblocfctl .ei_blocmodal .a_blocfctl table.saisie .ei-saisie__th,
      .ei_mainblocfctl .ei_blocmodal .a_blocfctl table.saisie .ei_saisie__th,
      .ei_mainblocfctl .ei_blocmodal .a_blocfctl table.saisie td,
      .ei_mainblocfctl .ei_blocmodal .a_blocfctl table.saisie th,
      .ei_mainblocfctl .ei_blocmodal .ei_mainblocfctl table.saisie .ei-saisie__th,
      .ei_mainblocfctl .ei_blocmodal .ei_mainblocfctl table.saisie .ei_saisie__th,
      .ei_mainblocfctl .ei_blocmodal .ei_mainblocfctl table.saisie td,
      .ei_mainblocfctl .ei_blocmodal .ei_mainblocfctl table.saisie th {
        padding: 5px 10px
      }

      .a_blocfctl .blocmodal .a_blocfctl .ei_richckbgroup,
      .a_blocfctl .blocmodal .a_blocfctl .ei_richrbgroup,
      .a_blocfctl .blocmodal .a_blocfctl button,
      .a_blocfctl .blocmodal .a_blocfctl input,
      .a_blocfctl .blocmodal .a_blocfctl select,
      .a_blocfctl .blocmodal .a_blocfctl textarea,
      .a_blocfctl .blocmodal .ei_mainblocfctl .ei_richckbgroup,
      .a_blocfctl .blocmodal .ei_mainblocfctl .ei_richrbgroup,
      .a_blocfctl .blocmodal .ei_mainblocfctl button,
      .a_blocfctl .blocmodal .ei_mainblocfctl input,
      .a_blocfctl .blocmodal .ei_mainblocfctl select,
      .a_blocfctl .blocmodal .ei_mainblocfctl textarea,
      .a_blocfctl .ei_blocmodal .a_blocfctl .ei_richckbgroup,
      .a_blocfctl .ei_blocmodal .a_blocfctl .ei_richrbgroup,
      .a_blocfctl .ei_blocmodal .a_blocfctl button,
      .a_blocfctl .ei_blocmodal .a_blocfctl input,
      .a_blocfctl .ei_blocmodal .a_blocfctl select,
      .a_blocfctl .ei_blocmodal .a_blocfctl textarea,
      .a_blocfctl .ei_blocmodal .ei_mainblocfctl .ei_richckbgroup,
      .a_blocfctl .ei_blocmodal .ei_mainblocfctl .ei_richrbgroup,
      .a_blocfctl .ei_blocmodal .ei_mainblocfctl button,
      .a_blocfctl .ei_blocmodal .ei_mainblocfctl input,
      .a_blocfctl .ei_blocmodal .ei_mainblocfctl select,
      .a_blocfctl .ei_blocmodal .ei_mainblocfctl textarea,
      .blocmodal .a_blocfctl .ei_richckbgroup,
      .blocmodal .a_blocfctl .ei_richrbgroup,
      .blocmodal .a_blocfctl button,
      .blocmodal .a_blocfctl input,
      .blocmodal .a_blocfctl select,
      .blocmodal .a_blocfctl textarea,
      .blocmodal .ei_mainblocfctl .ei_richckbgroup,
      .blocmodal .ei_mainblocfctl .ei_richrbgroup,
      .blocmodal .ei_mainblocfctl button,
      .blocmodal .ei_mainblocfctl input,
      .blocmodal .ei_mainblocfctl select,
      .blocmodal .ei_mainblocfctl textarea,
      .ei_blocmodal .a_blocfctl .ei_richckbgroup,
      .ei_blocmodal .a_blocfctl .ei_richrbgroup,
      .ei_blocmodal .a_blocfctl button,
      .ei_blocmodal .a_blocfctl input,
      .ei_blocmodal .a_blocfctl select,
      .ei_blocmodal .a_blocfctl textarea,
      .ei_blocmodal .ei_mainblocfctl .ei_richckbgroup,
      .ei_blocmodal .ei_mainblocfctl .ei_richrbgroup,
      .ei_blocmodal .ei_mainblocfctl button,
      .ei_blocmodal .ei_mainblocfctl input,
      .ei_blocmodal .ei_mainblocfctl select,
      .ei_blocmodal .ei_mainblocfctl textarea,
      .ei_mainblocfctl .blocmodal .a_blocfctl .ei_richckbgroup,
      .ei_mainblocfctl .blocmodal .a_blocfctl .ei_richrbgroup,
      .ei_mainblocfctl .blocmodal .a_blocfctl button,
      .ei_mainblocfctl .blocmodal .a_blocfctl input,
      .ei_mainblocfctl .blocmodal .a_blocfctl select,
      .ei_mainblocfctl .blocmodal .a_blocfctl textarea,
      .ei_mainblocfctl .blocmodal .ei_mainblocfctl .ei_richckbgroup,
      .ei_mainblocfctl .blocmodal .ei_mainblocfctl .ei_richrbgroup,
      .ei_mainblocfctl .blocmodal .ei_mainblocfctl button,
      .ei_mainblocfctl .blocmodal .ei_mainblocfctl input,
      .ei_mainblocfctl .blocmodal .ei_mainblocfctl select,
      .ei_mainblocfctl .blocmodal .ei_mainblocfctl textarea,
      .ei_mainblocfctl .ei_blocmodal .a_blocfctl .ei_richckbgroup,
      .ei_mainblocfctl .ei_blocmodal .a_blocfctl .ei_richrbgroup,
      .ei_mainblocfctl .ei_blocmodal .a_blocfctl button,
      .ei_mainblocfctl .ei_blocmodal .a_blocfctl input,
      .ei_mainblocfctl .ei_blocmodal .a_blocfctl select,
      .ei_mainblocfctl .ei_blocmodal .a_blocfctl textarea,
      .ei_mainblocfctl .ei_blocmodal .ei_mainblocfctl .ei_richckbgroup,
      .ei_mainblocfctl .ei_blocmodal .ei_mainblocfctl .ei_richrbgroup,
      .ei_mainblocfctl .ei_blocmodal .ei_mainblocfctl button,
      .ei_mainblocfctl .ei_blocmodal .ei_mainblocfctl input,
      .ei_mainblocfctl .ei_blocmodal .ei_mainblocfctl select,
      .ei_mainblocfctl .ei_blocmodal .ei_mainblocfctl textarea {
        margin: 5px 2px 5px 5px
      }

      .a_blocfctl .blocmodal .a_blocfctl .a_blocfctltitre,
      .a_blocfctl .blocmodal .a_blocfctl .ei_fnblock_header,
      .a_blocfctl .blocmodal .ei_mainblocfctl .a_blocfctltitre,
      .a_blocfctl .blocmodal .ei_mainblocfctl .ei_fnblock_header,
      .a_blocfctl .ei_blocmodal .a_blocfctl .a_blocfctltitre,
      .a_blocfctl .ei_blocmodal .a_blocfctl .ei_fnblock_header,
      .a_blocfctl .ei_blocmodal .ei_mainblocfctl .a_blocfctltitre,
      .a_blocfctl .ei_blocmodal .ei_mainblocfctl .ei_fnblock_header,
      .blocmodal .a_blocfctl .a_blocfctltitre,
      .blocmodal .a_blocfctl .ei_fnblock_header,
      .blocmodal .ei_mainblocfctl .a_blocfctltitre,
      .blocmodal .ei_mainblocfctl .ei_fnblock_header,
      .ei_blocmodal .a_blocfctl .a_blocfctltitre,
      .ei_blocmodal .a_blocfctl .ei_fnblock_header,
      .ei_blocmodal .ei_mainblocfctl .a_blocfctltitre,
      .ei_blocmodal .ei_mainblocfctl .ei_fnblock_header,
      .ei_mainblocfctl .blocmodal .a_blocfctl .a_blocfctltitre,
      .ei_mainblocfctl .blocmodal .a_blocfctl .ei_fnblock_header,
      .ei_mainblocfctl .blocmodal .ei_mainblocfctl .a_blocfctltitre,
      .ei_mainblocfctl .blocmodal .ei_mainblocfctl .ei_fnblock_header,
      .ei_mainblocfctl .ei_blocmodal .a_blocfctl .a_blocfctltitre,
      .ei_mainblocfctl .ei_blocmodal .a_blocfctl .ei_fnblock_header,
      .ei_mainblocfctl .ei_blocmodal .ei_mainblocfctl .a_blocfctltitre,
      .ei_mainblocfctl .ei_blocmodal .ei_mainblocfctl .ei_fnblock_header {
        border-radius: 0
      }

      .a_blocfctl .blocmodal .a_blocfctl .a_blocfctltitre .a_titre2,
      .a_blocfctl .blocmodal .a_blocfctl .a_blocfctltitre .titre2,
      .a_blocfctl .blocmodal .a_blocfctl .a_blocfctltitre h2,
      .a_blocfctl .blocmodal .a_blocfctl .ei_fnblock_header .a_titre2,
      .a_blocfctl .blocmodal .a_blocfctl .ei_fnblock_header .titre2,
      .a_blocfctl .blocmodal .a_blocfctl .ei_fnblock_header h2,
      .a_blocfctl .blocmodal .ei_mainblocfctl .a_blocfctltitre .a_titre2,
      .a_blocfctl .blocmodal .ei_mainblocfctl .a_blocfctltitre .titre2,
      .a_blocfctl .blocmodal .ei_mainblocfctl .a_blocfctltitre h2,
      .a_blocfctl .blocmodal .ei_mainblocfctl .ei_fnblock_header .a_titre2,
      .a_blocfctl .blocmodal .ei_mainblocfctl .ei_fnblock_header .titre2,
      .a_blocfctl .blocmodal .ei_mainblocfctl .ei_fnblock_header h2,
      .a_blocfctl .ei_blocmodal .a_blocfctl .a_blocfctltitre .a_titre2,
      .a_blocfctl .ei_blocmodal .a_blocfctl .a_blocfctltitre .titre2,
      .a_blocfctl .ei_blocmodal .a_blocfctl .a_blocfctltitre h2,
      .a_blocfctl .ei_blocmodal .a_blocfctl .ei_fnblock_header .a_titre2,
      .a_blocfctl .ei_blocmodal .a_blocfctl .ei_fnblock_header .titre2,
      .a_blocfctl .ei_blocmodal .a_blocfctl .ei_fnblock_header h2,
      .a_blocfctl .ei_blocmodal .ei_mainblocfctl .a_blocfctltitre .a_titre2,
      .a_blocfctl .ei_blocmodal .ei_mainblocfctl .a_blocfctltitre .titre2,
      .a_blocfctl .ei_blocmodal .ei_mainblocfctl .a_blocfctltitre h2,
      .a_blocfctl .ei_blocmodal .ei_mainblocfctl .ei_fnblock_header .a_titre2,
      .a_blocfctl .ei_blocmodal .ei_mainblocfctl .ei_fnblock_header .titre2,
      .a_blocfctl .ei_blocmodal .ei_mainblocfctl .ei_fnblock_header h2,
      .blocmodal .a_blocfctl .a_blocfctltitre .a_titre2,
      .blocmodal .a_blocfctl .a_blocfctltitre .titre2,
      .blocmodal .a_blocfctl .a_blocfctltitre h2,
      .blocmodal .a_blocfctl .ei_fnblock_header .a_titre2,
      .blocmodal .a_blocfctl .ei_fnblock_header .titre2,
      .blocmodal .a_blocfctl .ei_fnblock_header h2,
      .blocmodal .ei_mainblocfctl .a_blocfctltitre .a_titre2,
      .blocmodal .ei_mainblocfctl .a_blocfctltitre .titre2,
      .blocmodal .ei_mainblocfctl .a_blocfctltitre h2,
      .blocmodal .ei_mainblocfctl .ei_fnblock_header .a_titre2,
      .blocmodal .ei_mainblocfctl .ei_fnblock_header .titre2,
      .blocmodal .ei_mainblocfctl .ei_fnblock_header h2,
      .ei_blocmodal .a_blocfctl .a_blocfctltitre .a_titre2,
      .ei_blocmodal .a_blocfctl .a_blocfctltitre .titre2,
      .ei_blocmodal .a_blocfctl .a_blocfctltitre h2,
      .ei_blocmodal .a_blocfctl .ei_fnblock_header .a_titre2,
      .ei_blocmodal .a_blocfctl .ei_fnblock_header .titre2,
      .ei_blocmodal .a_blocfctl .ei_fnblock_header h2,
      .ei_blocmodal .ei_mainblocfctl .a_blocfctltitre .a_titre2,
      .ei_blocmodal .ei_mainblocfctl .a_blocfctltitre .titre2,
      .ei_blocmodal .ei_mainblocfctl .a_blocfctltitre h2,
      .ei_blocmodal .ei_mainblocfctl .ei_fnblock_header .a_titre2,
      .ei_blocmodal .ei_mainblocfctl .ei_fnblock_header .titre2,
      .ei_blocmodal .ei_mainblocfctl .ei_fnblock_header h2,
      .ei_mainblocfctl .blocmodal .a_blocfctl .a_blocfctltitre .a_titre2,
      .ei_mainblocfctl .blocmodal .a_blocfctl .a_blocfctltitre .titre2,
      .ei_mainblocfctl .blocmodal .a_blocfctl .a_blocfctltitre h2,
      .ei_mainblocfctl .blocmodal .a_blocfctl .ei_fnblock_header .a_titre2,
      .ei_mainblocfctl .blocmodal .a_blocfctl .ei_fnblock_header .titre2,
      .ei_mainblocfctl .blocmodal .a_blocfctl .ei_fnblock_header h2,
      .ei_mainblocfctl .blocmodal .ei_mainblocfctl .a_blocfctltitre .a_titre2,
      .ei_mainblocfctl .blocmodal .ei_mainblocfctl .a_blocfctltitre .titre2,
      .ei_mainblocfctl .blocmodal .ei_mainblocfctl .a_blocfctltitre h2,
      .ei_mainblocfctl .blocmodal .ei_mainblocfctl .ei_fnblock_header .a_titre2,
      .ei_mainblocfctl .blocmodal .ei_mainblocfctl .ei_fnblock_header .titre2,
      .ei_mainblocfctl .blocmodal .ei_mainblocfctl .ei_fnblock_header h2,
      .ei_mainblocfctl .ei_blocmodal .a_blocfctl .a_blocfctltitre .a_titre2,
      .ei_mainblocfctl .ei_blocmodal .a_blocfctl .a_blocfctltitre .titre2,
      .ei_mainblocfctl .ei_blocmodal .a_blocfctl .a_blocfctltitre h2,
      .ei_mainblocfctl .ei_blocmodal .a_blocfctl .ei_fnblock_header .a_titre2,
      .ei_mainblocfctl .ei_blocmodal .a_blocfctl .ei_fnblock_header .titre2,
      .ei_mainblocfctl .ei_blocmodal .a_blocfctl .ei_fnblock_header h2,
      .ei_mainblocfctl .ei_blocmodal .ei_mainblocfctl .a_blocfctltitre .a_titre2,
      .ei_mainblocfctl .ei_blocmodal .ei_mainblocfctl .a_blocfctltitre .titre2,
      .ei_mainblocfctl .ei_blocmodal .ei_mainblocfctl .a_blocfctltitre h2,
      .ei_mainblocfctl .ei_blocmodal .ei_mainblocfctl .ei_fnblock_header .a_titre2,
      .ei_mainblocfctl .ei_blocmodal .ei_mainblocfctl .ei_fnblock_header .titre2,
      .ei_mainblocfctl .ei_blocmodal .ei_mainblocfctl .ei_fnblock_header h2 {
        padding: 0;
        font-size: .875em
      }

      .a_blocfctl .blocmodal .blocBoutons,
      .a_blocfctl .blocmodal .blocboutons,
      .a_blocfctl .ei_blocmodal .blocBoutons,
      .a_blocfctl .ei_blocmodal .blocboutons,
      .blocmodal .blocBoutons,
      .blocmodal .blocboutons,
      .ei_blocmodal .blocBoutons,
      .ei_blocmodal .blocboutons,
      .ei_mainblocfctl .blocmodal .blocBoutons,
      .ei_mainblocfctl .blocmodal .blocboutons,
      .ei_mainblocfctl .ei_blocmodal .blocBoutons,
      .ei_mainblocfctl .ei_blocmodal .blocboutons {
        padding: 5px 0 10px;
        margin: 0
      }

      .a_blocfctl .blocmodal .blocBoutons .ei_btn,
      .a_blocfctl .blocmodal .blocboutons .ei_btn,
      .a_blocfctl .ei_blocmodal .blocBoutons .ei_btn,
      .a_blocfctl .ei_blocmodal .blocboutons .ei_btn,
      .blocmodal .blocBoutons .ei_btn,
      .blocmodal .blocboutons .ei_btn,
      .ei_blocmodal .blocBoutons .ei_btn,
      .ei_blocmodal .blocboutons .ei_btn,
      .ei_mainblocfctl .blocmodal .blocBoutons .ei_btn,
      .ei_mainblocfctl .blocmodal .blocboutons .ei_btn,
      .ei_mainblocfctl .ei_blocmodal .blocBoutons .ei_btn,
      .ei_mainblocfctl .ei_blocmodal .blocboutons .ei_btn {
        margin: 2px 5px
      }

      .a_blocappli .blocmodal .a_blocfctltitre,
      .a_blocappli .ei_blocmodal .a_blocfctltitre {
        min-height: auto
      }

      #ModalLightBoxSessionExtensionContent {
        padding: 0 10px;
        box-sizing: border-box
      }

      #ModalLightBoxSessionExtensionContent .attn {
        padding-left: 32px;
        font-style: normal
      }

      #ModalLightBoxSessionExtensionContent .attn:before {
        top: 3px
      }

      [class*=ei_gly_]:before,
      [class^=ei_gly_]:before {
        font-family: fts_picto;
        speak: none;
        font-display: block;
        font-style: normal;
        font-variant: normal;
        font-weight: 400;
        text-transform: none;
        line-height: 1;
        -webkit-font-smoothing: antialiased;
        -moz-osx-font-smoothing: grayscale;
        display: inline-block;
        vertical-align: middle
      }

      .ei_gly_ic_phone:before {
        content: "\F08D8"
      }

      .ei_gly_mbq-mail-small:before {
        content: "\F08CF"
      }

      .ei_gly_mbq-deafi:before {
        content: "\F08BB"
      }

      .ei_gly_lock:before {
        content: "\F036E"
      }

      .ei_gly_ic_search:before {
        content: "\F08DE"
      }

      .ei_gly_info:before {
        content: "\F0518"
      }

      .ei_gly_chevron_droit:before {
        content: "\F009A"
      }

      .ei_gly_ic_settings:before {
        content: "\F08C7"
      }

      .ei_gly_ic_clear:before {
        content: "\F0228"
      }

      .ei_gly_ic_remove:before {
        content: "\F0413"
      }

      .ei_gly_ic_chevron_right:before {
        content: "\F0329"
      }

      .ei_gly_ic_chevron_up:before {
        content: "\F032A"
      }

      .ei_gly_ic_chevron_down:before {
        content: "\F0327"
      }

      .ei_gly_ic_insert_emoticon:before {
        content: "\F038D"
      }

      .ei_gly_ic_tag_faces:before {
        content: "\F038D"
      }

      .ei_gly_ic_mood:before {
        content: "\F038D"
      }

      .ei_gly_ic_mood_bad:before {
        content: "\F038E"
      }

      .ei_gly_ic_sentiment_satisfied:before {
        content: "\F0443"
      }

      .ei_gly_ic_sentiment_dissatisfied:before {
        content: "\F0441"
      }

      .ei_gly_ic_sentiment_very_satisfied:before {
        content: "\F0445"
      }

      .ei_gly_ic_sentiment_very_dissatisfied:before {
        content: "\F0444"
      }

      .ei_gly_ic_sentiment_neutral:before {
        content: "\F0442"
      }

      .ei_gly_telephone-conseiller-mbq:before {
        content: "\F0C36"
      }

      .ei_gly_conseiller-calendar-mbq:before {
        content: "\F0C4A"
      }

      .ei_gly_conseiller-mail-mbq:before {
        content: "\F0C4B"
      }

      .ei_gly_dislike-conseiller:before {
        content: "\F0C32"
      }

      .ei_gly_like-conseiller:before {
        content: "\F0C33"
      }

      .ei_gly_mbq-ajouter-favoris:before {
        content: "\F08A3"
      }

      .ei_gly_mbq-annulation_voyage:before {
        content: "\F08A4"
      }

      .ei_gly_mbq-arrow_back:before {
        content: "\F08A5"
      }

      .ei_gly_mbq-assistance:before {
        content: "\F08A6"
      }

      .ei_gly_mbq-assistance-small:before {
        content: "\F08A7"
      }

      .ei_gly_mbq-assurance:before {
        content: "\F08A8"
      }

      .ei_gly_mbq-banque:before {
        content: "\F08A9"
      }

      .ei_gly_mbq-billets:before {
        content: "\F08AA"
      }

      .ei_gly_mbq-bulle_euro:before {
        content: "\F08AB"
      }

      .ei_gly_mbq-calc:before {
        content: "\F08AC"
      }

      .ei_gly_mbq-carte_qui_epargne:before {
        content: "\F08AD"
      }

      .ei_gly_mbq-cb:before {
        content: "\F08AE"
      }

      .ei_gly_mbq-cb_deux:before {
        content: "\F08AF"
      }

      .ei_gly_mbq-cb_opposition:before {
        content: "\F08B0"
      }

      .ei_gly_mbq-cb-small:before {
        content: "\F08B1"
      }

      .ei_gly_mbq-cheque:before {
        content: "\F08B2"
      }

      .ei_gly_mbq-cheque_emission:before {
        content: "\F08B3"
      }

      .ei_gly_mbq-cheque_reception:before {
        content: "\F08B4"
      }

      .ei_gly_mbq-cle:before {
        content: "\F08B5"
      }

      .ei_gly_mbq-compte-jeune:before {
        content: "\F08B6"
      }

      .ei_gly_mbq-contact-bulle:before {
        content: "\F08B7"
      }

      .ei_gly_mbq-credit:before {
        content: "\F08B9"
      }

      .ei_gly_mbq-dab:before {
        content: "\F08BA"
      }

      .ei_gly_mbq-deafi:before {
        content: "\F08BB"
      }

      .ei_gly_mbq-distributeur:before {
        content: "\F08BC"
      }

      .ei_gly_mbq-document:before {
        content: "\F08BD"
      }

      .ei_gly_mbq-dossier_ok:before {
        content: "\F08BE"
      }

      .ei_gly_mbq-drapeau:before {
        content: "\F08BF"
      }

      .ei_gly_mbq-edition_carte:before {
        content: "\F08C0"
      }

      .ei_gly_mbq-enregistrer:before {
        content: "\F08C1"
      }

      .ei_gly_mbq-epargne:before {
        content: "\F08C2"
      }

      .ei_gly_mbq-euro:before {
        content: "\F08C3"
      }

      .ei_gly_mbq-euro-small:before {
        content: "\F08C4"
      }

      .ei_gly_mbq-faq:before {
        content: "\F08C5"
      }

      .ei_gly_mbq-fiche_info:before {
        content: "\F08C6"
      }

      .ei_gly_mbq-filtres:before {
        content: "\F08C7"
      }

      .ei_gly_mbq-fleches:before {
        content: "\F08C8"
      }

      .ei_gly_mbq-hand:before {
        content: "\F08C9"
      }

      .ei_gly_mbq-imprimer:before {
        content: "\F08CA"
      }

      .ei_gly_mbq-invalidite:before {
        content: "\F08CB"
      }

      .ei_gly_mbq-lieu:before {
        content: "\F08CC"
      }

      .ei_gly_mbq-mail:before {
        content: "\F08CD"
      }

      .ei_gly_mbq-mail_traite:before {
        content: "\F08CE"
      }

      .ei_gly_mbq-mail-small:before {
        content: "\F08CF"
      }

      .ei_gly_mbq-mbonline:before {
        content: "\F08D0"
      }

      .ei_gly_mbq-money:before {
        content: "\F08D1"
      }

      .ei_gly_mbq-money-small:before {
        content: "\F08D2"
      }

      .ei_gly_mbq-neige_montagne:before {
        content: "\F08D3"
      }

      .ei_gly_mbq-no-document:before {
        content: "\F08D4"
      }

      .ei_gly_mbq-offre:before {
        content: "\F08D5"
      }

      .ei_gly_mbq-offre-small:before {
        content: "\F08D6"
      }

      .ei_gly_mbq-perte_bagages:before {
        content: "\F08D7"
      }

      .ei_gly_mbq-phone:before {
        content: "\F08D8"
      }

      .ei_gly_mbq-plafond:before {
        content: "\F08D9"
      }

      .ei_gly_mbq-responsabilite_civile:before {
        content: "\F08DA"
      }

      .ei_gly_mbq-retard_avion:before {
        content: "\F08DB"
      }

      .ei_gly_mbq-retard_bagages:before {
        content: "\F08DC"
      }

      .ei_gly_mbq-sablier:before {
        content: "\F08DD"
      }

      .ei_gly_mbq-search:before {
        content: "\F08DE"
      }

      .ei_gly_mbq-securite:before {
        content: "\F08DF"
      }

      .ei_gly_mbq-smartphone_contact:before {
        content: "\F08E0"
      }

      .ei_gly_mbq-smartphone_picture:before {
        content: "\F08E1"
      }

      .ei_gly_mbq-smiley:before {
        content: "\F08E2"
      }

      .ei_gly_mbq-time:before {
        content: "\F08E3"
      }

      .ei_gly_mbq-viadeo:before {
        content: "\F08E4"
      }

      .ei_gly_mbq-virement:before {
        content: "\F08E5"
      }

      .ei_gly_mbq-webcallback:before {
        content: "\F08E6"
      }

      .ei_gly_mbq-world:before {
        content: "\F08E7"
      }

      .ei_gly_ic_ei_coin:before {
        content: "\F0C74"
      }

      .ei_gly_ic_ei_contract:before {
        content: "\F0C75"
      }

      .ei_gly_ic_ei_flag:before {
        content: "\F0C76"
      }

      .ei_gly_ic_ei_pin:before {
        content: "\F0C77"
      }

      .ei_gly_ic_ei_rank:before {
        content: "\F0C78"
      }

      .ei_gly_ic_ei_school:before {
        content: "\F0C79"
      }

      .ei_gly_ic_ei_work:before {
        content: "\F0C7A"
      }

      .ei_gly_ic_ei_bookmark:before {
        content: "\F0DBE"
      }

      .ei_gly_ic_ei_label:before {
        content: "\F0DBF"
      }

      .ei_gly_ic_ei_start_flag:before {
        content: "\F0DC0"
      }

      .ei_gly_ic_ei_today:before {
        content: "\F0DEE"
      }

      /*!!body*/
      /*!!hover sur boutons*/
      @font-face {
        font-family: fts_picto;
        src:
          /*savepage-url=../../commun/fonts/fts_picto.woff2*/
          url(data:font/woff2;base64,d09GMgABAAAAAhfMAAsAAAAEnIQAAhd3AAEAAAAAAAAAAAAAAAAAAAAAAAAAAAAAHFQGVgCBgV4KjuZIi/4pATYCJAOpZAupaAAEIAWEIgeB9QZbttKTSE/3jOZBUO3f7pwbAsDP46um6pKXI4qOdYBRHt029tgemznKdEHZfSQJnAcdB/y1pOz///////+NySRk85L2L/n2P5RSwBZQZCpDp1O3DTQ4cu76UkUOrlSKQbEW1uqobqYstjJ27Xnr+0m9m/Sc3ExkZVmaezL5cDwVnHBfx4cDzlge1+IiJizqZq1F1btR2ZroxA/spcunY7LPszZOF70kd3jhWdm1kPWrYMtF9XUbi0b7qR1bC3mTxCsVkhpB7U3+urXbm7btTVASfS+rS5ds9N5OkSE/8JtaWNOQHFq94irYZEdh1Ag2oZl6pthns/zksGyfXyac4Gyqsa3ybaoXmCDFiiBn9NmNxKsJI7g3mMpisOo0FzRBd1kdnlE6mbEcRIcQxKrrK7MbOgoXNDeX5jSFRndprFSqyPChTtcbHjqKMQ/CKvGu3rrL5iQyMlZnMcC1jLVmpnKe37QeX1p4ppIRltrL3f00j+IzvS+Vf0oppQyo6X2rEREREajp/VXjIyIiAjW9f2qMERERqOmVnRYWsu8xppObWMMtnvX/lsgb2MbQrPuRwOCCNFQN8SFeclt+IO1PAchRzr7MEPqPUUmVmz5lik7CDc/Prbftr+JvDRsskt5GxZqKMWglBypKpAoqIAI2BgLamHB6GAXaZ4PRp2DlGX3qnVLQrRsEyXYtmP8GeCiIWQAPPP8hx9t9J6C6DKkfWSuU/RbVLsAxl+hDTBJDgAAYl+FK69OLnjVIl7UHICcoB+GFVMCm4hRgKiCZ6c7JAfB//1NtZpdn4gI6MYaENgsMkoySie7MPIFjWZIj17xVzrHb9yMlf+8lf4vwW0pT4LWLIRiIgAb4//IZAxkAQBAPA/zc+reG3hhsDMa6WRSLYmNR1AaMGiAoLa2iIhiFiR135unJhXGed18v1Iuy4vT0Tg+vv1JsTu/pppAHgwHA2DRod56nYs+27LvPAA4ztGqwdJspqiElQ9No0kMAtoktpM7NxUC777P7mEwOor6gSugIV4f7f1XtZwjBOmcGYDmHItOqy5ZenC24gCy5kJIspdhWYidRVvi58zvzPkFAIi06RcVlt6dWZ1/pKgkwAH5sv5fJAalNQlttC20puckXA396179T03GZZEdvQ07RjuLGBXblm1oFqYROiV4zUUkuOWWS2zu58HwAbJVUUtKjryIoSf0O5BL89629kXu3ajosVIxMfCzVVABpuf23a+OWhKHjAWVgiNfNP1RcKBAgQMJMXsZkJGGpJCFz3UsCBAighKlMCbYJLlytWsFRMA5iFRS7nL81ttrhBBRr7db6HRuwFWwJVU63JFPqhOKTjQe/z7YFrt97LNmgu+e+mxC4AF75vbm+vl+tKwhJIYdBstPpJHiARa+Au/8Q8WI7uzl73u8GGYxpMTrPNH6+I8kl935tNyYMFoXQDGw39o7E4LyQRxwEPF9z/57c2V/YLQB7Blu5KRCqTsyp8EmZjWT//vx/a/b/tWFyZRckmbVKkMgIeGTEooz4GUkmW0g4ggWOev9U/Vb9bilBElLSgiVY01hUz7Q8mf//Tfvf+3ef93zLESDSI0gCFSBiI9W002vI2JrptPd6r1nzA7/wewRCpJKgkVraKEmTkVr8yP/ltKo6zXu/ZvmDZM+wseG2xIfrSnISpzfUyEm6LtJVupKhYcB2DDOcNKczALBZZv7/6/cqjvJKtl9KU2VpHY8vXq4oNInuhgcEuADYo1m/z9SsfjdGd1fVjZFz6bnMRs7GS10bALMkzAAcrUAnQnrYUyfodCaV8zY6S/L+v6l990r2g6puaXKOIfCAwg/BsAgNt27J0uwIaBKFNp4XzaZ/pF/plwzBjVFK2A4awiC1BrbbOxKbY/Sf/8TqTqjOtAlLaGr8Ij0cntfN/+MGFwZEWWHcG0bCUIZAEAKShBsgN8A9h6GwK0tciZrEmotjUlwg2ErUJrbcW+PrWgS1fUJfDbbcdGxrl7sSf0na5ua3IoMxC3SdGwRRsGqp4ySA1M+RlMhlDWRbqeUnCi65tv+/pdqXAtTavct/WZZI/kFky38L/8ykEwV4970q8L1XVWAtIFVVIOnCIqkAklIVAEoFUBJQgNgASKmpxX1ouRdJdiDLs0hu/x65/WeOChAtEZIXkl5a9mzumT2cIHK3/rJs2UTJn2zORBOFk08QJBOkgxE7hQfAslnRCQeGxQw1wyK5yAySEAtP4QZgzbKvFskkF5EkE///rVnlgiJYstTr5rXXaZbhBKi7ZzEt4r/7gxTvBTT8DyrxAziZEcqlgqyaUqDsBWoKshzQbEizKXN2b8xl93oKzezewPtjofiJKT0h7PEIlBCix1GKr67/N/U74Sbc5r9Ura5VlOUBKVsDyp6xOquzvNHaeJ0Q4n03Hy7//wLI+lUAiV8gQRRAUihAklGgZKMAUkaRkkyRFE2Rbi+Dup+C3TFqpA7qiVWAKFWBklwFUjZAyb0A5UDKE0i7541kb5iU83Ged/JRxz3udS83a2M67vm2t+tcDguPtbdZmJ1TyEiEMvcn+Zm98mgthFZlcbUIdQdOMgiL89h/y8zH5+YdOqQndAwFgg4xhe5qhy1/pzR2BtC8VdsKv2bWIa/OEVATgPw2Xvo3bq1urD9CIkJEREREIh2ilmXSHxMEyEnq3iJoKuPMMDl17CASSnieJwQpUoqDQ1zrvyHb7k1DKHLNcJeKnEdtb/efhIRj8jp1SyLQek51CDerQ0ttLe0GC8Sc6JhEoL37P0S3/1feHKiAi1XGrkpLR5Jm3CV3jf5/hJv1FOvZW+/qVAnW4gESX5OZ3fIT23wfuAq+MmSCBxKCMVfhECTk4t2xX7vZ/38vWjTvt5v9WQyDiEiQIEFCCEHkFN1y7/25egmwBUH/9lrKDCClJjQBaVn3fvylWuE0a2yT/LXdZkACE8Mt+eZ+OpGSfxkFGBUvz5hz0Cyg03DulT10rbw8vYA/82u4tLyO9rUeqDG/4IIIBrhvo9NHFzBqz6AkD349/P57AAYF3QhefuoxFyVL6Bs4iXLa4D+S28PQAIMDrOGTbhFoH2D+0DWLEyDvClcGRQkw0Nv/xSuAmsJL5ZgA9n7yLBu6mKCO5hMo1EATGBRq0EALRqoAwAEgAOznCwwPNbSH3gObGRlq6OrB1mBGhxr+jAk1zjM21AhnXKgRz/hQIzHSCFJCTig9cmYycTFTiLuZSnwWoz8zncSZGSTezCRJZhZJMbNJ+jLMZOaSLDOPFC5bu1nELCTFy3miOcksYZaSycu8illO6pb/NGYlaVgVZzCrSbOsIXOqaBtZRxbKerJENpDlspF0ySbSI5vJStlCVlf7tWQb2SLbydbmcRvZlfTJbuRP2Z0MyR7kuOxJzspeZET2JjdkHzIm+5IHsh95KPuTx3IAeSIHkqdyEHkmB5Pncgh5IYeSl3IYeS2HkzdyBHknR5L3reJP8hs5hvwnx5L/W9G/yPHkt5xAIQmcSKEKnEShCZxMoQucQmELnErhCpxGEZvTKXJzBkVhzqSozFkUjTmbYjHnUBzmXIrLnEfxm/OpJ+YC6pm5kHplLqLemIupt+YS6r25lPpkLqM+m8upb+YK6ru5kvphrqJ+maup3+YaStjsoETMTkrUXEuJmesocXM9JWFuoCTNjZSUuYlSNDdTGuYWStvcSumY2ygDcztlaO6gTMydlLm5q3KWuyuXQs6eh8FTua/yKvdX3uWBymd6+Br8DP6GAEOQIdgQYgg1hCmPVuHTL9IQZYg2xBhiDYnKM1XSHCXFkGpIM6QbMpRnq8zyXJVVnq+yZ5wcQ67yUpU3o+UbCgyFhiJDsaHEUGooM5QbKgyVhipDtaHGUGuoNzQYGg1NhmZDi6HV0G7oMHQaupSXq+6JocfQa+gz9BsGDIOGIeWVangiGTGMGSYMk4Ypw7xhwbBoWDKsGvYM+4ZTw5nyanU+8Vwor1eXE9WV4dpwI1Lerm7lnepO3q3u5b3qQd4PyAdBEPgwiAIfBUng4yALfBIUgU+DKvBZ0AQ+D7rAF8EQ+DKYAl8FS+Dr4Ah8E1yBb4Mn8F3wzfchND+EyPwYsfkpEvNzpOaXyMyvkZvfojC/R2n+iMr8GbX5K5prSKzSMn9HZ/6J3vwbg/kvZvN/LGbAeKxWwHhsWcFhZxVQcViAisvsmhMeF7wu+FzwuxBwIehCSOZ8fvOI1RKonlitgOqp1RqonlltgOq51RaoXljtgOql1Z5XVgdeWx15Y3XirdWZd1YX3ltd+WB145PVnc9WD75aPflm9eK71ZufVh9+WX35zXzN0h8Xf1380xrI/9YghK8ZE3Eh6kLMhbgLCReSWoORuuZNWnlsDUHGGoqsNQw5azjy1ggUrZEoWaNQtkajYo1B1RqLmjUOdWs8GtYENK2JaFmT0LYmo2NNQdeaip41DX1rOobWDBjlPBsTNuT/mFozYWbNgrk1GxbWHFhZc2FtzYONNR921gLYWwvhYC2Co1oMJ7UEzmopXNQyuKrlcFMr4K5WwkOtgqdaDR+1Br5qLfzUOvir9QhQGxCoNiJIbUKw2owQtQWhaivC1DaEq+2IUDsQqXYiSu1CtNqNGLUHsWov4tU+JKj9SFQHkKQOIlkdQoo6jFTVgDR1BOnqKDLUMWSq48hSJ5CtTiJHnUKuOo08dQb56iwK1DkUqvMoUhdQoi6iVF1CmbqMcnUFFeoqKtU1VKnrqVY3UqNuplbdSp26nXp1Jw3qbhrVvTSp+2lWD9KiHqZDPUqnepwu9STd6mkG1LMMqecZVi8yol5mUr3KtHqdGfUmy+ptVtS7rKr3WVMfsq4+ZkN9yqb6nC31Jdvqa3bVt+yr7zlSP3Kifsqp+jln6pecq19zoX7Lpfo9V+qPXKs/c6v+yp36O/fqnzyof4s2AHMGpHNgXYDoElRXYAqAKwihkASFJSoiWVEpiklVXJoS0v0FUkkopaCVlqmMLGVhlZOtPJwKclSUqxK8yvJUQVAVVTU01dHVwFATUy0stbHVwVEXVz089fE1INCQUCNijUk0IdWUTDP5mpNrQaElpVZUWlNrQ6MtrXZ02jPowKgjk07MumbVDZtu2XXHoXuFeuDUI5eeFOmZRy+8euXTG7/eBfUhpE9hfSnWt1L9KPsr3nL6FdGfqP5VqJzkd+S1f6Kg/RtF7b8oa/9HQwIcmhII0ZIgEG0BoiNCdCUoRE+CQfQlOMRAQkAMJSTESEJBjCU0xETCQEwlLMRMwkHMJTzEQiLESiLGWiLFRiLHVqLETqLGXqLFUaLHSWLEWWLGRfPjKrHiJrHjLnHiIXHjKfHiJfHjIwniKwnjJ4niL4kTIEkSKEkTJMkSLMkTIikSKikTJqkSLqkTIWkSKWkTJekSLekTIxkSKxmTIJmSKJmTJFmSLFmTItmSKtmTJjmSLjmTIbmSKbmTJXmSI3mTK/mSJ/mTLwVSIAVTKIVSLIVTIkVSKkVT9s+5lpNiqZDiqZQSqcpdeVSTkqmRUqmV0qmTMmmQsmmUcmmS8mmWCmmRimnNHXe0kUppl8rpkCrplKrpkmrplurplRrpk5rpl1oZkNoZlDoZkroZlnoZkfoZlQYZk4YZ17xMSKNMSuNMSZNMS9PMSLPMSvPMSYvMS8sspI1F0ipL0jor0iar0jZr0i7r0j4b0iGb0jFb0inb0jk70iW70jX70i0H0j2H0iNH0jPH0isn0jun0idn0jeX0i9X0j/XMiA3MjB3Mij3MjgPMqTgGFoEGVZEGV6UXNknGhlRdBlZDBlVTBldLBlTbBlbHBlXXBlfPJlQfJlYAplUQplcIplSYplakiNuScn0ksuMUsjMUsqsUsnsUsuc0sjc0sq80sn80suCMsjCMsmiMudqMlnJ4rLJknLI0nLJsnLL8vLIivLKyvLJqvLL6grKmgrJ2j6SdX0s6/tENvSpbOwz2dTnsrkvZEtfyta+km19Ldv7Rnb0rezsO9nV97K7H2RPP8refpJ9/Sz7+0UO9Ksc7Dc51O9yuD/lSH/J0f6WY/0jx/tPTvS/nKywnKqInK6onKmYnK24nKuEnK+kXKiUXKy0XKqMXK6sXKmcXK28XKuCXK+i3KiS3KxyvttThdyqqtyumtyputythtyrptyvljyotjysjjyqrjyunjypvjytgTyroTyvkbyocX5dTRPysqbyqmbyuubyphbytlbyrtbyvjbyobbysXbyqfbyuQ7ypY7ytU7yrc7yvS7yo67ys+7yqx7yu57yp17yt97yrz7yv74qwOmnAqH+Kgg0QAENVEKDVFBosAoGDVHBoaEqBDRMhYSGq1DQCBUaGqnCQKNUWGi0CgeNUeGhsSpC41TExqtITVCRm6iiNElFbYqK1jQVvekqRjP+SjWTitms3PlmNhWrOSp2c1Wc5qu4LVDxWqjit0glaLFK2BKVqKUqcctUkparpK1QyVqlkrdapWiNStlalap1KnXrVZo2qLRtVOnarNK3RWVoq8rYNpWpnbk+zi4qc7tVlvaorO1V2dqnsrdf5eiAytlBlatDKneHVZ6OqLwdVfk6pvJ3XBXohCrYSVWoU6pwp1WRzqiinVXFOqeKd16V6IIq2UVVqkuqdJdVma6osl1V5bqmynddVeiGqthNValbqnK3VZXuqKrdVdW6p6p3X9XogarZQ1WrR6p2j1Wdnqi6PVX1eqbq90I16KVq2CvVqNeqcW9Uk96qpr1TzXqvmvdBASANGJkQyoZULpTyQSqEVjGMSpFUjq5KHFXjqpZA9ZzUSKxmUrVyUTs3dXJXN616eaufrwb5aZi/RgVpXIgm6WWaQWaZZV6ELIqUZVGyKkbWxckmq2xLll0psi9dDmXIsUw5lSXnsuVSrlybILcq5F6lPKqRZzPk1Ux5N1s+tcm3dvm1UP5FrMXSKiyVNmH5Q7sgHcIG6RQ2Hvv2k25h4HjVA6RXOCx9whHpF47KgHBMBoVTMiScO0b0AhkRRmRUuCRjwhUZF64fkXqDTAp3ZUp4KNPCc5kR3sis8FbmhM9mXvhhFqTAWJSiJZakBIll6VZZke6TVekBWZMelHXpoGxID7WWzeawbHFUtjkhO5yUXf6SPf6Wfe7IAXflkAeaCk/kiOdyzCs54Y2c8t6c8dmc89Vc8N1c8ssBcyUD41qGS9zIiIlbGSlxJ6Mk7mVw8CBjBo8yTvAk4/INnnEQvOAoeEUgeEMqeEcu+EAh+MRF8IW74BtPwQ9awS/egj98Bf+ECjKYJEuE5IiUPFFSIF6KJEmJVCmTJhXSRZAhkjxR2EUzSQxTxFImjkrxrAUkwIODEO9tBL6xkfimRuGbG41vaQy+tbH4tsbhfVdr4+mXGekPGbbbROywifnTJmHAJmWnDbLLOsOPCNgzgvYdIVOEDURME1U8XswMcbMkzJE0ImWetAUyFskak7NE3ioKJhStpmQNZWupWEfVMjUr1K2nYQNNm9GykbbN6dhE1xb0bEnfVgxszdA2jGzL2HZMbM/UDszsyNxOLOzM0i5Y2SVru2Jj12zthp3dsrc7DnbP0cnfcLIHru2RG0ukvaDAMppGlrE0s4ynWWWC5oSYtDaCJG2PKEk7IpGknZFK0q7IJGl35JK05+OioFeU9AmlXxgDAqhwmKjAiyqCqDEm6shEA1E0eS1avBFt3ooO70SX96LHB9HnoxjwSQz5LEZ8EWO+AmOS/R/TDMUsk4t5Jh+LTCGWmWKsMvVYZxqxyTRjm2nFLtOmGXt0xAE9cURfnDAQZwzFBSNxxVjcMBF3TMUDM/HEXLywEG8sxQcr8cVa/LARf2wlADsJxF6CcJBgHCUEJwnFWcJwkXBcJQKpRIIlCjeJxl1i8JBYfCQOP4nHXxIIkEQCJYkgSSZMUgiXVCIkjUhJJ1oyiJdMEiSLRMkmU3LIkVzyJY8CyadQCiiSQoqliEopplZKqJNShqSMYSlnRCoYlUqoVMGkGl5qEKSWMalDJvWI0sBrLyeNMSvn6zCbNMccaYm50hrzpC0WS3sskY5YKp0BpCuWSXeskJ5YKb2xSvpijfTHWhmIdTIY62UoNshwbJSR2CSTYrNMji0yJbbK1JDKtHCT6eEuM8JTZoaXzApvmR0+Mid8ZW4EyLwIlPkRJAsiWBYGJ4siVBZHmCyJcFkaEbIsImV5RMmKiL7nI6cYs4pYkVm8INGsJVnklyJIFaQJ0gUZZjOZZgtZohY5glwBEeQJ8s0uCkRFCgVlggpBpaBKUC2oEdQK6sx+6kVdGsxBGkV1msxhmkWNWgStgjZBu6BT0C3oFfSZY/SLSg0IBgW8YEwgCt4I3joo5/IpOZ9PzYV8US7mi3MpX5LL+ZpcyTfnar6veuf7q09+aO86ujkurnFCXOekuMEpcZPT4hYXxG0uiTtctv7ju/yq1K+5JvXnhrjLY3GPJ+I+L8QDXoqH/OZwtN/FY/4QT/hbPEVePENRPEdJvEBZvERVvEJNvEZdvEFDvEVTvENLvEfb5EOVnPi4yRWfIOIzg+ILMl98NUa9hLtCX7Sz9lE273BP3UUvw9pPrDiuQEDq+LL98K5ziyoP01DgCNALm2Q5vUz2uqHrmEiMk9UdlfPhzKKQFYYDQ7FHXTmIecDd4CJaFqL2xlW9bqmduatHLr7uuFoK2C1iFHdrbHWUpa6ZP7F08MAEIAQl5oejjKgDvS6iRC/dUkinzamFMWC4hbX1DxxiUTUMJZ0Wuxw2P5CJmUvgsWPUaaHawIAVyJ8wKUv5qR5YAaDJ+Er1gweKtPX6E4kX7lB0XJX/phjxRwoJ9TiDf7DtTpJIY1fBZTZc42d2oXLg2gJZiKmHgpDqOPQPcJbj9vKrtbcl0OnxEcttKC4i93HPnS4nfGAvF8JMzkUzu5JFlQuqh/bY/1IWzkXhqq2DULSoCZ4t9jjy+4hkeWrDx+9iPYIlw97lTrFr89qCGNlmcwEp6F6hQofKyqjhrDHGH4UjONRxMV28wcyl+8DYRfUk+rZdhVG8+SpB7WKCsyESTbe837anI/JgGIopbiMuO9ENJNQSh+Hj+i89suuWFHgY3EYgZIdRdgwd+A3CpnU5JGTzhVLOKwXgeyaGHHuxDvn8kZadHpdfYdPbq/e3wynCLPHd9YCZk36o2yksPq9hyxYlhW6XZfD9eps+QqPe1poIuskKvzxl2hQMwKdtAPMmapbq4yOkkwth4DN9U+NfQsZM30pXgdG/nlM6Zd4lJU+IoDELlHH4cXvNKFKdqzrkcRAElCvICUvB2w7U5s1aV3CvIi1F72aVHzLPsZzI5DIZf3fu+E9qFbWMbqLUCqo8x9EgMmvcxUO7m+y5bJ8Ot9gxMTVxkd/6gszGKUsGlzEBtNBEymgBc82nU/6pCNf3VArLgkHmX/SRrdqhZYJUKk1waqgqV5LFUAqZCqoi/8pJNC8gKi2bBvBlu/bkecsxyE8ucgm/1bZdk2fD8PJXnDHOGfLReWNlez6d9sZ58fwgTPVT461zIOtyeDFGMkbXvI4x7YtcEdE3elv+sK0/X3dEoCMbQFAy/WzzbZIfrmL8UBHtLADyFH6xEQ75StFK4xeThCJ13X6XDqt71huJEShC6gFgvveZ53NZD0+/kTz5xl5IWD8P88/XvE6UvRxBdGwBMTk31Gmbtv3ygY8Lj1zHYEcalc1mvX1crXOW8wNHZM5ElrhdlIBs96WuptUYI2dNvaSSmoSIJ5H1JKJJPK6woS41nJvk/svWUjQhgXnO1rrY342slm2dmw+XInsIEFkKaUCJkBbLZZ3m84mRfbXY7QR/8t4YqukCQCgQfc6do1+7361SqP5TukuiyxaA1L9bNZSZvv5e6J9RH8p0PvcB1Kc3v/kTiohYjj9NRHYeqyzoxl//XCUD6DW2zVViG+KO89Snt1t7j+Oypch8+wCYKZHVZ6mrwymdqrTiePIMOH6uRWvoDBO1uw9L+QjgdD07fTlvvLyrolxTpKWbKj2ChFNxzagjirFlNiVKLJHqPI+RaOqwDbFzYPYciSdKU5BBDSAQAJMzkHMs6BmijilMSgGfFP3lyDwyD0DCYp3OgkgVZUYEQLQxguIBtmdKBaDiLTknpnWPzx/brqU78lUcbQd0puswQwixNkkpQJmC0iSkiA5Bgz4T7SHISpxwEhaXUuuZ+B4YPfMCnLMIpBFtG+fL/ZFAIZAlAWlHmixIkoXQhEW4xGz1NKIQeaLWxGSiTW0icDbJK5UApKTFQLLJnSE6n41bHWahiAByiWMZRjPaJftxNGZB+FtYAtC3tsMEwAgnwJIbQCiRYEfkdfEutjmXfNNEAagmWhYINJsQqgXApN4AGOCdjw7gj5IAVTBAqePQTcYkFiQhwZI5FgPvJRLzwFzO+jj0MRFh9KD1nMBcbwIySaRUVebJ6xoQdN43IdQAulBn5/CP/hg5sGb58c4QBpgBcQAISwR4GiT6gihQsGfEVMfcPRGVmaI7L6aFABJlbIu3lfjYQCJ8FgsLTQJ6sk+CLKAZeYGAGhJ0IIElW5eANJghXm0pncd1awFVzgKcYN73acFdX2aH4ScNJg9QAQZgnSJjn2UIqqZBQ6nxtXOVEnAFHS0iAGtrOdme9Hj+w9N5vf6hAwyBrr+jaQCg1nvjHe0iAAYiqqCawSsFrd/rwNoxMVWFdQWUK0QPZpKe64ubvQcR4Um4YELOW4kdHIA7E6gHgK5jaaNzEeLyaQtO0XvB3EvMAErGYAWIaUfK1FKQqPDmCvxYMvutKtCzqq61zUY7/bAz5HKeAWTQktHQyaTkQEjWiJhOTX7RAMC+oGNPHYO+v1tMPdTSrwURHSBJJiLYzhfwK453IIlOiLhNg6+j1QnRUHQpevIjgdaU+rgIi/OWh27OUx69py1o9MgzCVteGkgnRnLsM4ChoSyLaDUAbbhHKMymGZo4GF4lncpzIaEu1kQ5E1nWYwozK568/385q4mMcdFBWySCIWuOWw2ltFFkWFYhb4JNVqKdzZxbi6BNU57OZIxSlTeGqsHF+DkHI4xgXo02JpWissX7Em2JbNsOqg2DpWmaAUt9L7pkN3HpmhooF9IWc8V9jIkSneOQEn9PWJQQGr3XAUgVx8qnVLUpzanpQOCcP3ZAUmpv9/vKd4T94MIeeyCo9i0NojV33DonmiR6D8eyQxCdyyaaQsi657NkK0AEAANARfMHf0ClppwoCQacqBZYAYFQeAGg7qNp2XHJsSEFICW2SYkrijsihP57FKDkDggMR7RoV6sri6z+EFr4IZjgPIpPy72BQWcmyZkdCsCnMJ0KmpYkSUzUidEWSUnGCoqLrIJBBicC6QJonVhyDI/m3PG/E1HOjAgAxUTOMToHerrv2csP/hrhFwMgR95hcp5FOtZEYgtYgVIEwB4A1hAfm16ABhhuO6i1eRiVpyUBDtYqDWBvb2NbXPA+HUsIUFoxAZBiqQaBA5rxvRXDHCOcsw/09hHonRCzySk8VJNqgVPmhnMKuQmoqtCaMkG6xDw7mEImBNCe2p18RJBF5KqSmKI/ehov1nY+1m5bM0oHQRAQyQB63WBPm2VBB3SEaKrsHJzyMAZzYLrjLJb8Epiyfcrdh6cBqIMDjXZJmcuSHJy/eusLWRFAWw9raeop2AA4JHcWvQGqK/MgxsKu3VnqN6SLAhLVOZFIJClXH8SANFnxUjvmThqb3ILZGmMrUcY2HQ3unknT4itDAYWzUWuHCo07z2hNiTK956BvNrWpmNQMzs8OI4B8tqSZkGWKdBbZ3OWBKmX6QjkL/fIPUmwmBiHiGNnO/pql2e3le/0OM5JaQDM269liKgMvv4cCsH9DWKrXy1ZfMP9E3yUAPctu6DdduZ8bw6/OjouQtIaBkPlxkzYDz3mIfU+ZvdZZu2k+uIHyMbzzi9WnnK84kV+kbS2lmWTua9HnKpjm60OfADy/+825v1v380jqCaAB/yrnWqYYNW6/TybnbPi/aYzGwn4r/9CXvqm4+8lKxa5Eh+9rAxGV2+jaWHcay9pHAO9UxbmVphoT+fd4OJ5SGlcdWTa2uGR+kl9i7htgalFPsYw1SN5M/8qWo/bTxkFZWGOn0wnjxFBbsjmyZdoeBL/zuiLyk1I3AXLQgeiGu67+k5WsHviBLJUJLdhOJaW+fl5y+74BAfk4G5o8Y41gs0/zr65unl8Cu0daAhd3+kOdo4U4J2QiU0osnBv+BDJ9/OnBdBYEa6d8COcdb5jKr9RFKvn519pqL4vMYVXnegfy/x+lTay8z/nX73YXnx930jwJvaZ3z1aLM/MUPlSe+mGkJYVg/3jzszSj11kUiLagiXYeDVWv+1nH2VsORPr7VX51N0Q/63GQ8Obtz0z2qIUAcDJAhx1wukteUrowl8k/hEo/BtFvRg9KVDjTXa510NaWhHMOapY2yV96rV9YJ6h1Nu3D0VyNV5kC38qC1iDMAEtBAFRMTz8tMXVekpvHOSO1yaPeOU4MTKloWlVl34RDuO7uF1STVrhTB3f1CfeAHakFp8gcbd7WdbnxJLKvYyw+c01KrQj48r1YggfcMYrjkM+UiGOsGENMpgoUiQrOEwAp0YSeXo50Xahgj7Zubo90++6Yz5lclRId6r+K0eyO3eCppgsyOQCPgvfIvYZScF5nQlcup1MR7Hq9P3xalctlNgByFTxff1PLiBExTgsTqAGKs/22e4AGIvjbtWPqaNJE5vR6JI0xKhEYI04AmN8WP3XFv33+ye6nYiaqmou2R80zq2YdeewHegyr4HcMlLRvLpRNgPCZvtGM8I6y6Yhw2jVYXPJCGW9mcb5IKTpvuqfdlKtc0uJpj/XqjngtNsPOXjD/QiJpge+WOz9QhmSuwJBxYGRtftqRTdDSPZjVfySzRYqcw4M/kMkh3f4r/3VbpAr5VITer6LDhoky2xrmKvG6i92GgPUc1Y6SEgzeA9ByD6CL1cqHTJ5S38fUN4IkVV+WFMQQu0QvaEr898w+Zm9uU2lp2H142klVffT+dKnnWdLCS4oPr9dWw9obj+gMhVpOcyzSgq3Kt5tc1iKKtgrifYiL3jJKzGwIZSiKjZn39G//DjNmU+sFw4CGVFtpD7gqRTHYApiXAoBWF9dKUbvxzPdWe7axp/ObtKFcpJ6LqZNtaktV8y+nS/VGI6a7Yaya8PM/yfSVv3B6gdpKKM9yfvbd/acO2qd0AJ5t3X67X2ltNJt3mynn/5jbL/7pJ5ptwR1XEcgPV3l511W4H+a3oFPUqe9vcEoYtus8E8DLWlQMrEzZS0RQLnqiSBs7uWxpymHu3e1iPPsNE69vusSrv/6pXKAP0MScNEPlyvjdJ8GJV1tFBBzATedp8+sV/Xz+dgnBFrgWSt1b2bni1P96fVsrPVJM0q+Ow3y+kqNcwRxfzOTL8bSv21n7ivPs3Mf0WL9YfMjiJGtfTYT6491Wfbm5PdeS3AkcY9pez6ssb1K+DSA582UYhtjlQnRhxlfusN61q7+k1/W7pycQvXmNu/fPXPvgx3rwwTUNTuROqhzOKqs4XVFz1nhVQU4RMkJbudqyqpRrTE1ry1lFNAvkFaexbbxeuhC0gRLbv1k/cURID77FKBcWPl4YO4o9PNuz6FsENgzbdoRjlmf25d8nwYhHDIQ31G6yNJ4H0V56UVo05BKEf4+ddrSX7IYPV5al7u9WlWPRhHv4Xe3bh8794+rJAwZ11ek3oDYTrLuZuqlSHLh1V95dq0zr4lDa11Bl2z2tPUWHvg4fr1oo3TUSLEWqK7erYg0xl4FYhtGxomlZBTLSzcEczff7QHyIIYWfKaFI05Ih8tIrOdI5RKzs0I01oS/ZqanmOkRpxmMFFVKDh4++oF4imsLDemK5a6eYu3GyuaunfeS3Tz5e1pBk28vzO4tvSpZqbqI91tb6NobefxS9F1Uli1ogaDd0eFtejt+eBJiREamlfVRqa4mVAT3Gt5lqpoQVJR1JcjV5d7wtkpeDWrS0vnzxTwxHarJeEqLRmSpxw/UFzLAXa69WHNUwQ7yhhREGRisxGtAgQNCt1yeZYo/H+yahbcRCyfNIKuJZjMWaiphh2CkVeCb4oZzS7rNgKAa2JZxXsZQ45keRMXRXPTcSK3T6fCDKpQhnp15ETnQcRcoKn0ZBezh6fDLs4PRT83VmxMmBnP9IeXgJoLuRSCrJEJj5VZ0yzIpxIMR7M6ah3R8PxAMiBnrwyzfTfejM+fXWViMIFyJK+JLSbhjTAV1MNbZdolfLF8XHKq5F7frakGmIzEz3Knju3H2+rC6NTaQScef6Ziruu9x1O3Ule6BWtgfvpB4lff4hRPJMAKivjaAv9COkyZkzd4rZ4Pxo6rDmg7gX2x4PxTv9k5ksipNSMlAlf3typy/OrCnLw9q0z+a6qE9pXhGlA0C3+5rnB/C6mqYkiwfuhiS/ceV+LEgvdpbCC2M+6qviUjWZCqWC5gmbPQHPicfbytzApa6HHVPpp3zuWu13F0REiCucaSdUmPsYpJ1xQe8In7C/WrZ0tK4Z4yq1b9O8SnqwOk2D8Pblu4TOwvGmDfgK84S6BsAKgti9w0LVP3vQHk7Uh4TQLsUh/mU8MM6GIiSH7d5d8SFAoVqxaHqNA46MOceVKZ73lYvpsXOYzyciZ5kI1XDwNxdElQEtSgQizLF6ut24U8iW0uhaUQ511cPMV7sjDR5ytHT1KMXCHxo+7Rb14KfZTDz+KT7Sg/PUz0SObuGnr8On93wmpAv5VV2tulF1zdZRVLivZSOZqKdfeDwbZlhjv7Mqa/V4qmW5LCMFMDOD0gTFns/DDOmSLjGmG130cuLfonl7gIz3ksX/p7jCZHi7itkt/rvdilEIn0TIadNSmXBs90xQGGUQT3B4Lp6ohyeuvTFBfILseIm8K+9LxXCtGL12H4OZhK/eO2Z/3KBmVJj4RlZEqc9BSgR+E6hac8Svu5lGM8IUvP3zMBDHV/xR/CSLGSO6ZbLZ03BZ3WlhcoK0vxjMNizsiLB7FMbWhjAvziK+4CrcoNyT8I0GwwAQv+vXvnskXnbXFL4OzQqSUVpWNM0Og0RUMaq76HXS044TnXPzWxr96WWnM6PmYWuzLzT4+8Ktc1J75j6pPgYPKRUz0hdK5yTHGTRqFSfXUWMyQpgjiKVuQpOZMpWWTilZk5kVv7fZUdaMkXZKf5eMWcElp7iCVZuns75wKiT0lyKexuf9egixyRfCygK26pWzr3qdDiVKSBI+LWZmPSGFnPxRM9czmuwIcsy8EGoEgUN72CpftxlC3BQwHflEFrMMP2SYSiNLEVWEn3xx2vipFVQcwp7QfMiyVrQJaqaqReeZbf+WU5UZ5/EPVXWTonlDO/l/brv25tVifFk17hYGVBM/3zE99qOQK8SdwQpio4e0ip4/12Qkl00q12Rkg6UHnHY9Ec++aAEz7vTqZYEoqzoAQ/sKhAHBvFhETNSXEhXWzI2twu6mlTj1M2IavY7o8InzeinqrQ2wV2/u3fXy4yrQvOFdNDvyEnWaiIL4crawN+rSy2ra0mHFZEV3U3kDNODc93lz87VeKkrLsDVU4+tL5y7Wcy3C+AzEyW/Hx87ggXFLqTUKFvLyYploOKGCXif6Ud5tqZnBDc4GuvsJBCL50SV4wJE1XBM02vXsM9f6cHRxGdFatAbl3HcZBr1p8n/+alKQqEDas5iiztvAtmsG/1HwXPVEVaVvlBWmkYwXnkVvPfrMue37a/b+i7sf/hQcl/lplSGPWdDCDz/4t4ALOJp9bcN7B1j9r/okl+z1kosTfKPSzFt6UpqnG63CRJhAqkdrLi/yGtB6IgbsGZ6/Kdiz3nC2ZDNB0LGOK9FiA4135jjWsk3ws7ziY0D20dbCj8CrHn3aMQWFi42A/i0s3nCRCXjS7QfD+ga640SCMGtU5JjR6pNFgIBBivZguj/wlFehPFtMQS0R5uk5rz5W7X5V4WYa46XihtdiP92X0EyEyj/sZGusEue9c+d2L3UsfIrd18ePziD6gmxIz7vakbIVOjjiGUievIQaAld2Qmmuus7ZhiveEQz5kSiMT5mhS36LUWyNHzZx4itC0Tx7Kah+U1BgCTyXZX94F9iRAmfHiBhhvgPBxoi4SkKhAnaGvyuWXE4yd19zTK5GhCrQ4f2QcyMbbIvQZknJazyXqs64AflHApo5/GYKCoZFbGmP2RzIEY5hlVDFQqswO9yRW31wOP7D1xjIagqmSFvlOUQMB+iQOq/HuQ6SIiCyQoduBeF6qREOsP4AJbd7xT888Xp3fakMrGk1KPzteafU1l51HZhV3XpNucRJEm6j9HjVwxqCM1H4/TvlEOUifNeiFuC5O7fKxU/4+7XpsEtWlJW0znW4yT+fCnAR+q33qPPYQalIpkxYyAJOS+bhsuykQXLX6c3uQl3XX9OBy/B4XZr8loAsP3iDBZpBZ94jjHKgHXkf4fcVu0innu3oM+wpxEF/l0LUDbwaMxStjzCstMZfXbn0iPLOtk6OYzDskkGh7g+zydQliyHSVTjHvAyFeFwXfnLgN9fCMybLg6xEzTg29uNmTjgbkRUeYya/JqzT/WbQq1zHwfcPdO5/v/md/W0H3sHHD3UcPd567Gj7oWOUNiPcRjszewEbbb0Ncx9pnkdjFC/KnPWOPBV0y2MtaCrGbr/hqzwZ6cYl6STeqC5vD1LhOq7NTllFwORiz2ZKYbwSCbWL/IeCjcdCzn+lXErP83mhNZD1N6KADE8ABW70pPdkGooobtnZ24QScGyXZn5lQzr6av/jSSGlYy5H1FQgVOYmeI0VmBgqplws2em+cpwi6b6/gsaLEImtQBipmQE3supvsSFMREyn80TwVEB7AGJlEwwugRc3/7Jh5U6fVnTgzsR45UVulqMV9zT1eLCUMRyadz2rSEv9GqDWq4O6no67bKmdXLyNgKDfS0PfR9tPC9YL9Fv+bZaP2dzdcteYl1AgLGs3ocVvb1omSTj5TONQ/UxMsQyImkmap4YXTyb+fpnL9pCsSvjBsLFS0YHRkqQGNzc9eQ7RMD5QHqulquX/Z8ybPwYX8vvySF9f0N40C5wBe7I/Pqkwcgqx+a5TCgLU4G6ViWjWCq+za17SIxT++DZucIoDOdnsvBNkif1tiUXp5u56GsUiPFTNzFR7VFexkBpCFXh3NjmGAtcXWrt8atCoAzPw5pV/3jPdO28dcYTK+n6orTD8M4bV5LeYEIoItbPa5xx8ep/sQscCFJcDxhybgopRVZkXW5ob8Pcnvm5vBrWtUbYN25bCb9pRgi7+Q4miHTmfqRrvwaref4K5Q4nI7yVNTAvF3bCBomh2epT58kqfLBKmH3uf4jmbLzRGx6Ifhs2LueJ+MH4jb7On0VHmbrL/ne5zYef+oh/0UTAdXN3S1jMdN+meIwPR+2Rz9tfgY4PF5ZmYT7CxizLBPgO8NCLgGaCyRm9JLu6erWam2zjKcKCDnEBejlu32i5Hc0WT2juoEkxBbWOYULdvlgYTKpBejDDjKwb5LhEP9Hpm5ivoo+Y6Ee9qKEkmuT/OkR2OAdNW1kPEuIjaBULu26dUwUTUEYz5UdlcOKZHyHuWHFh+A8BNjMMSq7yEZJmUhxPtzQHZo2yvENOXT/DoE1z6W2P1L94M2JXwhweqXa1q/suHugNWFBuZtSeVAyPkiMqksugYsIuv800hoP83iteB1dR4vDRd6VcUCW2/DvgYN5AhpccRK+QsLDnxtTD9DxDTgdSU1790QXbGT45zFTiuos90Pv48QtLX+A72fXojmP31wGiFYV+/j2AygW1fp77yx39ZMPXLrwKbJ6g8S+Mrl2KuJBI392OTX81OSgsiHZNw6Adhz8ya0steJfW0ixcXzGhhL2c3LXjbdWSs56Gn5IZuy67rMmhO9oTpOcI57h6I31ENjE8oAaBEHXSXj1zzOkHhMOpydo0PrIte0K+5STsetZ9sdV0+O27t3HbuyrI977l3TgDq+w9Yqv3uPty3XXYsPf3qkh0rUsnpIp14OeZe3xi6Qws9xhyipVdGUfesXduwLnlNio9o7AZFBtVLmeApLu9qTOTpgtc8c/7azdYKYCrFLjKNGOjLQ6EVyu9NVURtAfNauE5/QFROMkrh6UZkyu7GR5RR9QwjbxKBQfHishuoJZfIOUr6/swKU80+T/w0fZyPO85gyW2Y7suLweydnWocyvXOddXGFoY2+tLvPv9HI9u/FoofvNF4FF1T4ukxLFZSIShGIgUt/ZbL8YJRPMJRStBluDroogiJf5qnpDf0vNPVQrZy9lf5acrRMVEYh3RxlOUmiYxfVDTMJtOgtkQ4lGef09je3ET4o5DysTEYQ4kwvNoK+CivQ8JDVaBb9Pk1d7s8ML37MFfVru2dCcfBaTPkf+wp16jw4Q0yxeFK7pxx90+qx/dVGnxOd8NslMzbvqpK20+sa6bnaUJ5+hkhPFff/rmsOvpPFfyTTykDqatxliJBsAXLUArEHPZrMr9oA3IyHv1Ig665PLZWNPVt0kvOOxdsey9mpXj7Rcvmv8AJ0vFhB1J/yN9PT6pHUnq8i7Qc3N/cfYB0GLJVJgxYJtB1+BvlywipWaa6z9//vtCCD5EO0Jvh6aWa4Sw4N7Zx9dNMDh8ykPpN6mLyxZ4mYrQ26+0tr2W2pyKfb4gA7fAHyoPoDfXtu9XD96j0LgMH8AAz08Pmy3p1hwCaYKRgnoBrxuKlPutgUYWPDdDw4Vff16OP899/9e8mzimH58gYb+ZxNydhxxWI0nxC8Sk4piJq3Dwj2GH3IzA1qDlaVpK94m3bJ29HKG2gjlbp3P4AZd1kCeWUv7cVDpur7prKo42NXQwx8kR9ZbQBGnk53il2VODGv3qIlelB5BNX+87EYvycdo3N3Zum9HzLPULHrsb5A/BbXhMqoVBDFHDIHdbQCuFqyEIBR3fx0GpatGwIsBxd5ERN2bjMr9tw80Vp1aPCXsRSIwQ2sFb80U//w5k2cTiI1ktBVjIgSUxyxP+U+caZvEJgw6JE/Gt63gG+pYXw0b9ArMD5t0Tlblm0Xed+I0Ko4SBf7omC7IiZupNqhqIlwo6w1+O4wnjOsol3IeoOCNnB2uOPGsILW8gkFeK17hmI96Uz2tx0EzjfXuesbguCX91l2hq1w3DAw2VRfsu0bFuH0t7Q4E30VIVUs7QmWk/ntNcpLXotO51Js+g6JeSi9iZy1/amYXf3Q9jKDfNp0pyjvyjg6XhWr3UwOktlL3NRN8o6ID3PCdJuOmDnnEeYZhI7MrKGFPMvWbLAoc/bEOj4ryCWXHYcdJl2VRe07Dl2GWnvq7Oa6Gq4c3bkVfviv6nfSMMf/vEnpH66dCjNeCuyCQslhaQDHVCN32l+nSj80K9VYwCkD1H7nx2UJExz1XadOnvc820B1iOKKtm8XZqm6oF7bgsPeUBv5NYBZNasG6zMRnZ4VVzLS17SBoOq9ExZQMT4yWnMLuZEdQ0LsAF8ykp4JEGPB5HPBvkiInRXfcx1UU0RkYFANxMfSoQ4W4VR3HzD2O2ZJTMQPwKEW4vBpyXL86DHWFrEalEQmGGDNv+1Gdznj4ZesEpe3YUqHy/2B+K10QpfOe72hTLgCoN4APBAVBiAfR5KS6fjm2c9vjRag61rZcdjapa6x+7H/iOK7Qz5wtWRKls9GUl9sJogVa7CLgN7zOMXjyZ2LoTS+khZbI/XREbBcsUQJmrF5CBwEmSnS4inutFhOA7pQFfQ+CfZgKXkXZWuAJ0TBTluZcMJ3xkyTdWsKmtVzT+RDAyP8aiRnY/K8Dytf29nKyM35p4kK5QPzMyjoZ0LS2emu6dSlz7YvHpfjpf53YFSdDswdYGpN1PO+PyZG91zwmT3seOZVTYGx6g9LJrMzAfcU/BigZHOmcxGyJJyiXa9dUOgbRP/I68KRAU+g8/l/VDwhVPIr02KwjJsbFpa8ibuhStTK4KumkPU6ko2fU9Uhb6qLvvvNk95UUmDZ1971wbKf9edK2tO+41WZlCFTdohllFsYibhJbPIdPWshKuDOueMqwzc5+aD+jX/5eH6IdKYLNr9/1w6vKg6kwxsuh2YiZnU5TpfCJIP+d3Q7VDEvzFuQ4b1xWq8UZ4OBOvxXYdhZBG/ZWv1tKUFsW6wnxtxIElLUsFiqguHNB936oH69DubN3bv7EWPVoTf4PVXP/x/VjKz0HqoKiZxVMestxFTzncxixmxboGBNCEVWDFpJRn5PBM6q+gvIHJibCSPdBX7vUXTsNiAbE49BL1VIvz7CVNpUMaKdU4O0auspj3t2mo85xTIeCzF1hodPaBfGWR3Kbk6whH9y1hUcYUs0nWJ/SikxYwcK39ghVyLJdktiZfdYUhpKQvLLIphsyluBAL/4MM27JTYwRoDczSuKit5Hh9Ejb8Vf0NpyfOZI3A/p3vfTCXfXmA6cbS1odZ3h32O/zSCclDekqfx/xdYiFs3ZJQXG5W0MWYaLi87XNhY2+fF0WUwBaXVcAu8ds0sSBa6gbVEvOVyQx6JdLhyNHC+dFQ/qZY2HCu3ou5mZHtmenv+wxoJhpl8zeULkFVUFfr81kvj1XH/SbMMy3FWp8v+qwmeuMG0cv2UFWr1+7kVzq5MnA+viR0Pi5iyVHI3ytJcHUQFbRlLK3F8iXq3T3trEsqfBjnOtFjhBAvmWtpIDnxWclSfGuTGMZOxsjwR+ZkKyzcJEWVAjFsYJvNIe9BgVMeJEdw/EfIVuibFsflPpBC4QAtBtnBXTjKhqUSxr2DESoSHuxZRDjtBj/OoSLLWPhVc1eYHHxJNgat8T9B0XuN+zEgscP/Yo0+TRYpDM1UwhUKw+EGEMVBgC90zqZYwQxymUItzLTnjNGcxL4Tlmq9+RjkqiBRC1SI7MgM9fiXLEGe0NIUsXaqKFg6fphwTJQuPnOY+WisV8fsYEh+Omcb8rOeSBt5rkXwK8eOllpilEDdaFlrIVBxKmlSL1yco9kEwVPx40vHGPZ/eX4RpAmdnVJep0zmU6kHkKnHAGY1raLjMfcXDeCOWDCBnlYWb3Hbh75uBj8vpgd9dEFWY/2FUeWDZbhj+AH6IOW3v1SmTMLucnhcMobzaFS9aO863Q5PK2rwD5cg+ZRUAjvvgJM1vmc7dD/kvtO1605H/bgqZA6OsATmhQ9+l+wvq+IREetTY4IFuzhEmtZtk4U3gmWfznMfVJ2lSgtAZY6lgFQvp/D5BuoW9Doa7xnVOgqqVg8FSOD5rB3cOnF0e9v1KaFQL+6kJ4gUJTAWq83DrFCplmKDSr9MDjW8kW/r2u+UNDfcndxM3aCQzAXS/l1l8gfoZV313q2y18Sfv/PvVexbq+C1BxtWhmJsQU1aLOG1vyJcnDYKxnBOnjWV1jIHhkrEQChUm6Ny4cyPPeM+cRiKsRFJEVSNRjaLzWEppLfmTLchUikk7jbSY+GIzreg5oIpBvhwWP/XngAtrASTof9I1gjBk5/NsqG8DM3vWqqcvjQm+U++lsyNrubUgFm3VoQtewg1jtVkpLtq8vz5dY+kMTswtZDacnAOZofe0r1p30M+GikEFp48bbjVxJFAR7h9bWu1q/nz8BNEvC53Ox8rECP+IW3iyZH8NSI4RX09D/OmSfL9XpFU+Erwl9vv6poEbbVPx58JPfyj3VDtsmGzzdtnm6bD/hsZmKErUVAxsa3MvONOWB44yXrckhFs6vW3c1bOJfx3ff8JL/zJPM9AXf4t+oOfwmYwNsVNW+d8OZlP0q1mVJwWPVeyXY3tylEAkpF6/sR5advq7irWwNz05Mep6qgGXXJSWCSZEHrEaLn02lv2ynnw/EcyWC1mTOMGTmhM2Y2RGhTkzTxVFRxvH4Bb012LrkXUWxMxdvOZ/S8ugNdQEXwfUZlvHiWUjrNiEEURhwAbWbYhRRRsOOIybgqgaZ7YAYKyhWJBMDPhk3IYV/JWVSQaR2D+GglCq0lai6u4sHANJ92GgQYGAMMiBKsCJEcJHkf2TMuM/UBS6l3NjYsyKNQJa1E5DfmmkUQmjFceECll5ei1pTJW9hlLOtB6lG3q6YMfX4WMmn5XFl17nUyU9BNkG85Ia0LwRCXFVDah8v21+PMHTx7/o5kI6J9AZGoR2ZHXTkQbYkKuWDoxJAcdZlZw5a6XO/LYsDSPyArQxwwQHqSome5sNQVybUVkOHdgX123MGbwlISMZpfnf6qHHHO1fQ4QRQadovxocTpDCQTJfx8Hx6fq0psBItwDUSEgIe52xGoBB8CLGyC92BLHY1y9V60hSb6N18+wi8MOrn9CSWzODZuv05EQdrkXbhx8N/o2m5p1/aiFMkRGnZyAz3rLso7EVH+OJoJBg1wUo+rv3hoDigF91AwL0bnf6PzajuAzlYY9DYwyz4BJXZZOHdFLLXBlo9aJUQXUHwPjswZSCkilWGI2GaJ21gjIY+1iFek8qSZ1q3tPkFyc7yZ3Z61omeyOWtX5fM+E18fa4o4pUhk2zDWUJb74/YJvPusr6Wv4toRrbu//f0ihPPWtqvK0fqHmFjit+4xUgNwOOwpLXhugowMejJFNrkdCjgHA2Iz1KAO9qKSlEq/fbgB6DSQWjTKVjdsOzIVu3wwGKLS/IczuIekyFQN4ljI+uvYBT9mz9edmLyhV7Tq9lWuLcGTLceRj9lbmZ3YQoSKIekX57got8SkuIlm1A/yCsNnP1mUcitpX0xO9ZR+t8U1SpPHTvyjM3+aT/Ttg2Hjjo8rAdQbcrmbejZ4fuXY8Qe3Ed//3ZDql262D0Gx5TL51JPUKvO/l8CvL567dmEyi4z3lAYjuyQqQPiS6of9KsR1BylM3Qi/kLZC5Diiu9cs794+KELB4hBc/LmhF8l/L/2aUrxI7Vgw110GU5ty5x59CTrk+UTPR+fh4FXHJ7MoFiA0ywyx60/2JzrDfmxrHvpoT5MkmO5D2Dyk71xC0Zq2NMYe8WyoxNqa9PTEeMERBDNb+7jFqY1ryhXGz2qWZf6w5Vn9fJhXTpRNxn6EVRu7KdYoAtGtjOUUci5g3joP3o+oZ/+1je/Lp7z1ZHOLnqqLeTzvWeT/Linvnw4dPTHqjyPR41+4YymtVlrfOBrLXc78wDdSzfMFq3OQrD846iNkJ4EX4yIb9MPR3QjbsDPLCy00SnHfPe9VqThlXHig5woAlAQ9vVgOLrUnypE/7xRBZKRgUqvtgFfnCL5DGtuSFmRJIM0rsnqip2vACsS8WEttg8MoN97L0sE+eT5jxcikizQDSXB8jw7E9wVIr3tEVHHGUngeI3ulcsnVuj4BDtzKTeOjO9jy/tCsizdkfykTZlvyoWw2/ZI/b46H3SQpBjffbVArn6tk1iPAFnr5OdP9pFPjPprCkH5AvisX7UOG2IcZUtKAEd78stB+emOAI4IzpVbJ+y0C29Jq3buwYZ2o2Muv/VcsnXAB1JOy/IQ9x+RzsHz9RI0o6OWf+57ARQ/xZsksqhCaI3wv5H7kPn7o9bs67oGdHjvrVm68RMTBlSKI0BK6RgAq/JDM/M4+IyndvhM127U6mohbNMp1Hg5yLtNRtNzW4eIN44KoXaHXRyfAGtqFr+0BjB27IToKhfuFGAiUmHi7jSklaIrg6qJdyj/1xDffTxuDmaG9HJZF1tdohfmSCrYGULxOjoXtpcKyqQyjN5FhmzsdeJ2RwQ7d2cZ8Dims4/9SDu+0qfYF6vzNLKUV7/obvbixErXOjNhYoywcMAe45GcFROTSlXcTt2HlN4SrDBQsjFwaGBvF0GiCZvSqAdgTacQvy/fEOglgUFJtV8Sn6OOq9dytskoiCe8Xmh0pqZqBi4EwddE36E3CkCOElbvKNZkTR1QmHJ4MR70Uv/Ic6HtEvj46MblyXT99ga8JP1dFfgXSe4VNjXCkA3vp4WQCqdgfnmxh0wMqh9UomZxovSmkJLMwXwoybIiUBMQuFF4G10BjwC2s7DUqQWZMdyr8PYvntqXQN5OJIk2si/gtFBlaV+Aieq+wGC8iSSQN1JAdLV3AMhOERTUqFPEl2o7YlMXOpIwy2tHNYusa08X0/7pCDyY1aGlpuBOLs6LwSO5FE9PEyY3ULbaajQWrjHsaXzs0uuxLatRAbEWv2iyHlsvE0VpEzb+iCnJt2sFWUflZSgp1QBn9Qz/qi1KEOckAuB+mBpcWcyvbgsx70UdxOtqAFVIwV6Dy/qKKkJJRutaNKpGBVx8bJSA0XKyrrci9yU9JN0Jf9ztrpVwOStQqaT0R8lu3N3UAVlE9u5uk72593jiTmt+m3qKwtAki+YT651RpwgZILqldFsyVBu6Fo5A7ZqZ9yB/lqWMaQlBwU0QwLPiJjQ4KDCoecUMgO6cerp5SSx9tk124a7yEEncfI6Zm2nLBLMYNYz5Sd/VchPrcJLc4ayuw8rjmhNST7vivGHyjrbncrkhTrJeuD1QXaUAm6Atuj2WRDcC+irWoVP+pmvsjEEPwArT8/i6Aruj5vI9fTyhisnSemrtop/UEIKj7HrYY/HRnpt6De22w+dYWIqSNO7LDymaoNlr23rpy4YmnU5QctCI41rov4wtAAI4ITaHWaHU7wGjp/OJ6eykhRC+Ew7bnXpRpeDB9+May4Aejooey74trKomcjAcXpsZMnWgc8Dr0k7ONJagXdR+zYLS6iKGQqMDNPyh7YpK/r47a5i3KwNdmfC56DN+FiDzI1XTQ+6HSpUUqLe6eezs2WFKYb4LgynMPR2Wmi7N05JEj638wHRh662oqJUNijBo49HGiVY5OOLEmhDuJznZF6zFiYBiJekYUoK1zt0ZV8I5TJ2s8Ta7MSI53uIJI3hJ9HD+W70PXSQfjPRVSyGg9Vaep2FaBoISk0C7CqGeRasgNM2uz0MW7/JvKnyYOvyzcJvH/tug8C97vClwMNuGbt8Mv69nRugmFsAlbX+tclsh8NqQqhJJrZASXIHN0thWAmQIvJMIz9SuZgpIOnCC2YjwQits9QV3lbc76Rzg3fGERcAyp4hfzaPBD3D5aLjqAPkG71jZpW89xZe31kJ0cPZeOxniUqizXPZ82QOxMXTwsDBpEPuGNUC4eq/UHDl3b2boOIb7cWQZTa0/HILyzd7YJJNOaCQCSchlmvmQq6/rFVCMq7l9fWLQ8fWjS0wIw3sdwNLLjPCnpyikAgjfqfYLpJjRe3pYYTvPeNG/OW302yt9/nse1ixG1lbNB+g2F16M9WVDoKfxC0PKvRUjxgPgn3ucqCGVIXDOnI29mih57I3I5f8Ta5O1Odeyy7X6wVsDtde3fRwPwDhu6/eZkCs83j+r2lwFviFPqKYe3fSJIMRp94N9WEFA0xoX4BcHQuj71YvWImCWiBZxiVNRUPkZTLn0Q6AyQa3alz1gjYO7mhBj1O1mQQv1XmbXjoo3lN8Pct+peT7lgv2vck96vBySEKdpKzBAbaZYNoKufcStWHN/bJmR1EaSXSq2yvRbrt8+b4IYXrtuF9qDoX3vRHauccqBLRlZwSNXZev0sx/pfPklXcJ9pksfVQcICKB8PZaQnyPexzzQPRCgI9m5Ta3U5PPCudV93CljsLxDGDqx8mw6idpY+8ggDBJ+KA7dpYI5XFJOi0i9ll68mWsUZPUwTfWom6LXSjcIvn9a3EEvbrrnjuT//4Fb5AUPJjzQlQuhtFfh5BqcswECzk/tX3lVvF3T/yYa7u+FNYb7Xv2jR308unlWajOmqNdHykeHrfOvABnEceISLH2UnbQ+59TqQaNorwUaOQLcz6bdFdsD4AM+f9OYSkm8ewiKS0WSZEUmZlttbGbX54W5f5HdfuR9vXxB4jqfH1H2bqp93dAqTQ3B083W2ck8oQRoJ1BnqzOHpbirtlZpHK+FercBnGX95eOKZ4f36CUbnOqPUpjf6XE9YpeEHVPbrNPS6XZRw6spZJI/KIGSiszEXdovVAtdC9PX8xWM6giTMyDedt5LOpoZVuaSEPbytSmZ2GmZoUmRxLyWPosAStpjCzOH99ou6RWkTB5x+v7k8+3gYgG5tuoLbgEl8bSTOkypnpTcwi/pxESV9zzFpz4DCnmEoEVkrQlI5NNahIHkupososm216l9QAJTAfpGZQq64QjlDNZw6QmqOzTjM1I7vgDhUPmwJMMrCC2RBLm6aA93DmSKiMe4pGlOs3mNswwhsWCsT8HLMiSFSC0WQk8DiNbKFNPMy55IAJaXEmHidXBTwulS3sFeEHmXrFPaQFbhOO1tnbuWe0p2Tn0hrVSZitTVsCdspOnTjmn4mE65RpjljCjs5CQTJM1xr0X49mlx18J1Chd9cny3nWHonUDcx1AE/XS5faSQMfAPrviDnQctaGHiS7b/RNJBQfYDd0buzRw5+/u2Ho5J9Xs5K5/6+S4px1zhJiYKw3GWK2KVVurh9VBT/LNHt3IPHXGO7E1cIxBwKwVm9FwXHl1qwqEPrfeC3yPI2z6WMlR9Jxw3KR5aUw8dYmhY1WiYk1pOb55K/CDSnHG70Z1erdvsRIgRrSirh1xqUgytZnPJnUwnCUTfk7wOVZPbkKwNlvrfpOIHk+eTkpjE7lZ5mUVbNtGzR6cL9wYy07kLIjc5vU5bM+OPHs1uFwaxLvvtRfxzMb567+ojL9M5NfPXVMPHT4U8o/0zqY9m/1GiNR9TEQ9bXPxuBSfltAIYojvS4fsXUw3Ep5bfa1H/Zp4ZNbxNHtx8UMpSzwdLeBRW24HgwSDb4cv53/RTpu7RGngDig1FShaYnc07g0uTZSXdqUScwvEODtLpZNUOr7X3ugI5j4nyWcCNq2eJ3RSOdLuqM1CCxDt8T3O/rs+00Ug4Q2S1g4r6JhWYws6VlNjwedR82hzGzy/wNm4DZK0cWYqwuzdr7gcYebU5EzJZxNODH7LPJZJAOJerYZyMiaAtjW2DCM0t4NmhxmdpsysQj4grKXHw8lqId0m/5PaTYnK2RecBGKHwDiEsf1srsdU3MstUKGyhmlcs59lq81zXhvk1Axa0o0CWEPtH/6kB4vJ0uiJDtoVmxgg71QjUOp9MAWi8BVG8kW1C9S+shzMaKMVrkeGiVh6Ugzf9TpIhu5st3h7aB0XjgVoJyOuuL13618yc0Qe+6v6KR/erWe0bnFKpqWlB/ao8kvvMDqXXFtbYf+BoOTO43D2qmTfOVnSGNm7e/LtKkRbfnh5oTJ38ZygPrg0X128ckHeTyThC40k8Q4Tg+BuB8yGG4LZd2CX38MQbbSSryEF922PkXpwlnpGrPO06zuNT+4t0ilT1engxJwGa0eeLvvBPdiIb4o3EKTsPXgVO/Z9MgQ0yz4w2+2trF1X5waGkIkyGmqqHa9sRu83tIGVkrwS7nQebUd64pDXvSp04GRjB6VNYEi3JVoI6BmnpfrA0QByCOVdrQMIjtT/SXYyhhAcvl0iqZeRxtl0bUZjpYVCTyhCMpnWilttXxDyDIgnh01rG7RRvEiIggYhuxkchKlZs7f6MZQH40vgc/kWU5wcFxJcXuoaNRO1e8uobFBY6RSxWAStBZ4+zJeylwBbdUKsZxT8E+Mc3Wk+xgTnpcrLqcSsn5AWDU+wZRR5rl4l/sva94h6zHK2/05jP58yg1gbSol/6ls4tS99nL3h9sPLrigyLQUkQe4MFEKkGlVgo49rBSm0k5BszT/AXW+JRnn1y53LBUwjrUKte/Zo0qmpMLCW5RqPuzp1RZFxbRuCAmlsuERCZyhbI3hXFBwxGe133HXklzJm94obbko8MMrkXSSs7p6zZrdiD+AxJ+76xckKqLh3wd7e9M5DJy9+mSHn/jqsO0l5yj01hJqyZ0Y81bNMDqG4848lUkjoUzn7VVCmEuGLn/pfLUjNA+zZlP0bx+SJWbDdQZFLSB6kAtMlEfKY1MDT/GB42KJm23X8SMUE2WVvPJag6inbuCXgZfvLeYoUQvbWs38Qn8s49GENF1k170sVsrl5ubN3HbMnHMIsL6UjRgp17DOH5sV8FE3iVPGjG4SL8ZieC/khvzNrzs2S+8irpdPPH0RJo5tilHLoXT2JVsLsDa3mNskJMph3UOT6IGd2c7xmuEyiX0Elggf0rdx+eJow52AmxbNb5lBxch2VY8e6Eq9P28oe46yYmzDQ4aI2eqLFm1q6/S5tUazkHWUT/9zYzd5XmlydsNmZQHAKiGqgQh5gRI9hvHxNgarIjUJl0JZroZCVs/kiHatTRWgcHhvaEM1vXLi8S0d1IOh/E9dIJvnm/UTl1ITS/0BHF5c9lcX5iFFjgEgb7tAF+qI9kXbfntXQcq+gsc9ZWvHoc1YV23vLPDE9Czxy4btAuKcFZmmtyIRjqQ5Gacx2PhGC1b6ejAEBsohzdCY86sdWzRSxEYaRd4ezsykdXNDaoh7EZPn6fY7R9LgTiU3EoRrQHQDvih7ujHDSvyB4gApSIJmMw+sghEw1vo3VFUbJhL/JJVD9VFnfn5tBhdg7UE3R1I0KcpGRRkPJUsx/maIu7T7rgF8hoy/xHl5WDbXso+hlfAZCCDWuQz3C1wzYkudYhQZ4HBV0wVsfyAStYh35HsYsmSpstlbTKrOeQDoIHYPEyJm3LEGpiDfWczXGSUTM1RtCvHNkBhEroWwU2LlgbWNwtaUZB7q4H59oTgynM3t6Tu3pq2Mk3WhWldsFIOPI/vR07rhSc3tITgfTYhgw+3/DBA2x/5bhhRBZ2BtTqCHjsNZtYWoaIMAjsRXf4TqCVVc6xzG+PQfniHWQDFpLCIeJ2lwTDxYaiKgECKwIEU2yMf9VnSSlFVS8XHhUNNXH+FJver8DnQo2ySinopEERbybm6eTURX0pOihWKSqqIAkNiJBPz4LtUzImxgg6MFhY6GjobdbcKWyWXlvxFnSMvl8VJ10iA8A92taAYSa4jZ+j+dPGtpR/3WzJEIKyeMAQzlVb8rsY4v2E9W699swohjQof30xNXFndxy8LXjfm6661yKAlJdtr4MaeUH1eF5BO6T1jmG6m6+LFQuPu67zcfyHAbvXn5qhpDOg1mIQyUVGyGNruzUukkpHsNiSy4awDQekRTE5IPZLZ0bIaEPy8gVW4LFuLcQZ6nrNVv/BpC92SpbEctXN2grgKzdfV0795JW2661KRdYrBjIsJaAB+5wlWao4y5CSkJJx/qkTyXVajJKOV5hIwS++p5abpBQAuScIL1UzsC/32mGqJArNFR4Hp0gX/dohS6ILTfQGpR3aSv6sMFXSmOPvmXr0MjywOBylIRrTv9qYS7jzc6W8/7ls5fcj7oGiZkBSMuwTXpyLY744/kz8rP9bjvPj6MsYnzFPE4jeGzOYJcOjJXng6K0kwXJNqGtSyP3RNOldk3YK7lh5FJhTBPqFJI0kfZtriK4IgGiNBWSJi5ZaXe6CI242CDDHjCi+0pbH/Ts5EAZoD01We+CaRXKUGPM7lHOcXqBOnjUlA6q86j0gP67Gw21ZnbsgK2XHf/g8vTWrbjjisvHd/W3QtL6e4KS0A7McoNgr1CHfn0JDIJxjpe96i8OuJ3acAmcI/Vr2KveJKbQuj0kz+wIvZrMxQZ6zScXOrrG4UbrK9V0Dn7g0V4zFu8F0vViUxbvf4li233BsTsVISjwiknzaKmkDr3nyDKgClzDqkWqtLKAx2qEchPZUsUcrFMwqC0HJpw2LFg2gl1EDRojsVXxVR9sshZGbuPPgZZhXwBWEAcpIrus300Wk+gQkb6o1XvosO7SDADq3npvfRI99+yo62vUzBB7+oRFnVl+2nlD5Ka+/DbjnKUgbd3wevxlrcr4FTuIqV9wa2gdkUwvTAlJh5ecb1/KYSBzJrHFXgp3sn/P1k51h4uOonjBvU4LsESuF4rjanjJWspWbbEwfceibWPuZjaSWJ8HSwpRAZo2jaXdKRwcOzAlQ1aK6+ZrhwGx6WHAfPgjqrBfsS8qUjqyJZdEMjjlL1Shy+Cs1O+7aTyV+67CE/ZSZ+ENb6az6nP8PzBMjj6dm+gJfNUWZ2EOyNLf8RSAcGc2ekQM3BUNhsSiE+r0FlzRsJgyLb31OJ2wRxSnUHGEjc8r02IUmi4VExuqUyqb14k05zLefzv/wZxT2bJAoky2lTq8MCpQ+mEUoRzjdJIHOGzsO+MXoumXIBIift77Y8DsjSlranWvtcOyyT7bZorvMmAddueETc8AULOPinwLu1BjLWwgVUdtIPXEPGT6wZyYMP6vsQCK+B9X/Pp1BTZtZ19vfbJVUlF5Xw8zB9eMCFfgJZnB6f0eo6IWzwbJKYDQEv+C+dibMDUYIRgZ4bq/q9w2V8o1aI5Q5xjU9LLEl08I2Clw3XM7HMfSmWDFhX2lmm2FOz6NzWb0ISx4Rtyn9B4yKueXbhKovfIphVFMYKdSTucR3ESiDlvkcpGo9A+zvSNQkH3aKp2f40iHnRJwa/RTdVvm8Ex4+9al8AC3oNuuh2rinlPCD5rnnNnDVr+N5Tm3ZCt/8o63sunpp1rG3sv2hHGPrJvz/md6C223vSP+ZUBV39jZWDuyf+9y6JL/kj5iJhsK4bp9RPIYv2wHSUcG3B3W1de4m7K861ncwx6M6eCwXtya+zzqHeWri3M7RQkWxWIp4wIjEt8iWlewp4H4o0Xz1lDUvrpm2THPjA7EqsLeeSL4Zs8Mtl3LMVW3oU+T6va5i0WLSZpAGAzTVLCCFYtnGD9yqiE0Bjnn2kIwMMc9gYVtgoAeQ69zcaelnI4A8qnobZs6YrdkxqqCdI1esfWzHKJWIQpPrt7sr8UOHIsnXz50H1SL/VTawmskcN+3CORRjnZ0eJIAw+2i2EbO+EXLcb9KijIooV6pj3zpm9pSY8l3yl9X3c/adtc6+5FA8DFZ5kZPbJTBxJmY/NV1IFSHF0IfVy0MkLXVF6PmBg61NvKUfbK4vx3bjJn/2rRZNqlWyX3plrtN+LMKxFwGatPB2VVyqwvOzqSimyovkyqW0NC64Xzapm3XjYo+pOUx6iWH+ogIU3FCg1IlXH6hfn92aRPIgVcekRfpot0xSsVz51pLgCxkGEJuXJ42q+U2C4h+OC02fx7Nm2ZWemxegO/CvrXjgShkT7vfBagl9PluCT1HqYXAg7jJa7dQ2lmlfXDrsFsZ3Lu/zZ2LoaLdlwOJlJymvVoi8UHiUy2clFhD1cgoQH2FKCG/nUU2P9dB7xkkLTA4ZXSk1QSAWDgjBSML/BBtQdN1C91kOLzLAkO264q1f7MTr0n8BqXKwPEz8RzsF0tnL9qO7rgOmYmUXA7PMPYIL8RHxKz8aFW+nHqFV0uw6bF7vAyvweXAaxiWvUbH6DZKr30zI0M3HeaVDpgYZtlOaztCCF8nNrrxdOiyedowh1uXO+aDMI9tXpFCP+4W6wWftO+R9/Y6rv8Ncvj274RII9GnOKhUB29ZYuLFyhB62F9EyEEZWCcANSypFL4oaHhm7Ba/kuVYUYzeP2sTVU8YJ2p5li1XJPBTGp9e+9j7APmaHCpxU9wSdaAsZVldpdjjhtHQhE9XnHO1VqgEdAnEVE26lrRKUzibGoEIkBxV6/Ae7ANsVj8iohkiiwOMvF9KojXG4Zj51QBw40VJhiEkQ5imBAxAxVJoXUY8fh/f7QAU5bTRY4YGztZaUT0krqnxdkgQbsVUIVcR9X3SOcKYWjgIaYuAVYsJ36ZK/sDkjRiJAXYE97yQKaPueS3Vg4MGiUCCl8qNfxL58RCbBRabFsz+VyoRRCjKmUpbefjHonkCSlIYL5KBMFW/F+oL3eDUH3Eko8xfC3UBaODHLFUGPiLuoC7ucmPUKVMTCt6fYpaBkCKX4lEN12LqlLFa1LkkxOyTGnOrK5BwPywi+wyyMUpL2QHRdbUSh3MgC4ZN3Kuds8OLzyBLWbC8AWn8rCgxjkO0S1TRBtsQEMPV1cJXd7RJtR6DfkDJ01W6Tezv3TVWIYohPPilX11I62IhSqessuXMcJSpEBV/jqDUm97wL3FHQgdNNVhwV7HN8x5BgH5jRbq8YqI8D02UeZDxHOUPnO+A/Y6IoW5J6YzNxKDUVV7g/Zf+SlqQMJZF7hflkZTndGQw+KqrBw8vxPPijE6FB14pD5tYJNRz1/BftKiA06Rpg4TLMGbjylTZuYiHe1/uTSf3e8fE2gTGLd9UXzUuLBLIxKiYb5XNQ7Ltpxn7w3fZ56oLvDGulm/Tphed4LerBIMXw+rUYVn2DEO6hDBYxgBKgfXFhcKQz/3r0IGBA7nsYH7W0jDfgeeznmatlVaK/u4mXsU6EbR4YXnXA+fLHI6xHiegMXfpM+8WhDs1emmXRGW0gJVN7T8Cwm3Odmz0oDika6FICNECdNnaXJjGZVF5wLhEtUJF0g0739/NxW4hQOw2itVOkD6tzPHmuPhSCXZReGbQm1OQnG0Z4Jno7UKcX9Dqsi6kqgmqyhZbO5rrWT5dnxMM5D8aNaj4pzsO6g5qi+5Py3g3scLjytg2tTzA9LmJ4Fqr71aBswhyqtp7484TgbsXYlfGmNYLwbbC//W8EiHoEjpBofsokZRDLWPs1QLJM6SzAgHKVzkzeBlpqRJpuxs4Yh7vmTaanqVv2/n395AH7OEb8TaQc5tcR6ppFDjfzhkyGEGXp1kSTbWLhcdX7UAUHhA8uSEquHOdN/jBYndVdax3g9XZw/RCNaV0fclgJfXb73Susu/+zsRD+sP3e9f4937vkyQHlPJVpx0aeluAGexVblhxO9wZfbOI00BbCiy4G712nEKCyfSfUIOa4/FQjtq1br92nbpHmS1632v6kQU372b8ulbuOqoQKVeM1zZpL87f1u99CgbyYXT+h7O6j87tWNigjcDK26v8I+MUjvvzr1cnCdmz7b1t8bXCTKpbSIxxIbFrB6W0Eu6io6NDNzZXCUvlw+jF8JTKrqoEvzbvtyXdN+2ljHisKDiT53h1VOsmeS7DzkFlPKep89BIGtJwQb8gnWVyfVjtYqc7Qs5s1a9lOpgtcoa3izaApYo0xkEPs2OgboW1CccqEJmVVdjys8rXPIqR4lfkGMkrd6vWyYOBiH/FrXjsNMKYpObsFILY4bnBdrGmGR0F5yTD87xjNvZW2X4Ryuiweu2J6sLn+d7EK1o1YT2GS7TSv0l53CMhHQwlMWhT1W5AdqAE0Pj9wn7a5ZYy9lFWxHDfzJdujTobSXQCSgHdlWE1sNZhpp7yl/o3kKhrzb4elS69SubZrUi74860xejMqGcUSHTpMP4a/9QfHpli31Rh1yyImjVQu4cUj44Inu7Es6YXuUo85XSnnAcMjZe2EPo5fhjViAnb6Opwp+342kPgKRd2w6cTbdjLOsqPKW2OlW+t4wU7a+27mWZF4sxlXSakX8x5eI+Bwqluk33hqDhC9n3KImjBDZlxIutvUk1IUey/FvPyDxW8WL/1HxZoBf5BTf63yqesGLsTfPnhf54nP6xVsR83tX+tfhL0Lsa2AWn+VtszO2xL1gAWKJrNGuye2Wr86YRDnNjz2AHrgx1ZSz1whV5xo9Ro1qEFkDZGhvyehda/GcCaBM5KpbJBksMTBAfsIgIsgb9JwQxB9SGtKt+fD0jfuw75jPHexDdOmwlbBOw92wqcfW5d94xB101mTJAdI/pOl4fwImj/P1OHcLhbdNl6aP+V2KPeXkiFp9xynlrC0IX0NY3ZP6mgz7NuxrgtYqQxryUExA7DyHcK2OkrOnpRIU6jc05Ltheq5P1Xs9RyRDytpASOZ6PIQL1bUBsqVB1ZmMNzD4UP+5Awx0boYjw/uVjcWQ8SgWoZeJ8i9b8xh3UvdTBzVHJQbmP8JaGOEx9Vk5QvKkqjckUgzvRTEwKexlGza1eKNon2kqdxv+vlldngqtn34ZuM7Uonx2igdEyvOeuaKF1WHmwl7wAQX3kmfCzCd6xNVVDpEKgByoKg4rhGpd50d3lWzrGgv1BMrW2XT92T6leVtxtlN6I9WjoMkbA1Zw6RKKSOUAS2LmQCTF3JUI25qEFePy3P5Zei+Jzl/h5ZHSRkdogjP4Pc/Am4h7Coq32ngoAmz179p0nxJhMTZhV4GoFnoU0Jii4EY5I9QbkbCLIrT0pnMF+QGXTG/XZwBTJd668ZyCCYmYhE3WXr84xyBrZFSBeifcvJplnsDPS6GdNEXJkNV93m2n9/yTfPOYe8PinO81zMBCBh/sFEFkig6wwdSZgkcs+yupT7KW16WqgPSgKRXFGbgJxQddu3Z1/rrbAdonPtzS1AIuHDGo6YWOP6Iw8IylPPzPh4ZZSpSfyVth3e4FmaG5bNSIy5/QNLwbjk9sXHJOMY/cgVMRGtj5ImT9rIbHTMX3F2KRyj56Idart6QzrpWERK4c/ardrCoH+3MUzHK6a8JkPPln4c4WC8v62Vs7dNwms8BKYGHEkLHqNunRXQi1+k4buWozXmQz2VWZ89C5v6s5hzSrv7HwC6+nfhwykdyWccmOovyHlWds7ZjG9XhPSjE23DBbwZg/OSUYcId7Q0q/5dN44KB1C/4xms2QckrvG99upt22Bywrzi9uDyPr10Z9oIsBW8AALTqQqSw6OOsrlXAGLiaquejgHOjSZEyJukI81uInzKfb3tdACfSMEJczfSPpNaIv7UbfuqY9yz5ywt/Co3pWvGTIg1n1vrXRHxJJy1rP3OmECwaucBCEEkrpMvENnB3Y7JzKrsaoKCKCFI4wS03tFNz1Xo+9b0jbZvBdP9VEYLPiZS6fzvzGPdaHOYKdSnR76ltNydQ/jKDLm/iuGNOHnrGFEX9mj54dUsNt72L6kjUGM7HqIuGIRTT99By4PU3cLGXQ7idmiz1No1b1ZwKPDlR9Th0CF/ZOnQ+NTgET51jCJmf6yPibW0nPRPkoGdrbgFlLniwXBiojrC2ZH0BaBmTisl/EMkbZHKMbmaMxocd72O0RI0brRZEeIx9WcVSowF1yItBlrXNfdlcvns5lpSd0SkZGsP91Z6Qp7wFS6idjTlgsIKrn5H9GJO1uK1ofFuzx8UwUfaHFJCHtJZ7+PbwNz8v1x8D0GD2kO0Rz9jWJRGfvqRREE+uSJ5c8wV8YptT0WwSnWnmDUZo+zCltjNBLnfZCRF72Tk8KGitWiRgm7reMUGfMVzY43OlZHU4NIltZ7PUXXz82dwL3A3p19RrhHwom0pe3JkbGQ0YuP22Hjimo+N/QtEFRvMU002wjJrUHUCptWou66Kptn8dtZJTau7ybgekyv9OqE0L1lWyffxnQQxfqsLJGn2nkptO9l6N1Zzhn2ekDOFIb0kd8VKh34/gqpqG+hq1Wzkh/+MK3JuxhqkttZ1DXLdmQ9xcwPxXo36XyV85FhqRJfWAg5sZaw3MMzkD7kuV8WnS40p/GRboUI/VCkHCGP10olMuJoQuozPWlh5RcwDOuxyJQuKJICPJMF0tLwv0A/Cmx5hdKmYpVdh/rrv7GHw5G5FkimWM1s0vZYKPlK/SQhHlDMz/EFZnufFdLkNfDuH0m1nLoIzE4/BnMoWHHH48D2FXuQRRUnwBVWLwJRP25uCJgQvA1bFpqw3yjfmPAtOG0w9woMOwygnjS61ZGS3PVf53eawXFRSnUX703FgsPw4abg6HX7cJaUDC1ZsR/hSh/sP+9O7whjIg728gAp+3aFS6U8180Ppdc6QM4skiQ01bIZ2Y8namwG56lbt+ttDUrjkjm8yQ9IgOPUmg8UIkhFdUNofwa/X7+H+OjpT2BrJTotMTBthlG0BezpSJEOUmsC6xxZVtchiTRYeD3+lt86uhalpRdZGpryT0ZmCf180fWUXSQ4sUgg3wFf05MVwUZUz3ax6+/rrr7d4mR6u52UzYe/a5y7xqgo/uCHL7Jl0bRpq/Ot/k0ZZZuaTNuU1VkICspXTsha53hkvOcOVvYdn4darITOkV9yH1HVybioOaH+4oseoOCaDy0CM5dyCDkTdl6J+qt3gmSox71NpUpxRpKinc1kTnxd1xvnjsgb5wj3xv3jrhVX7meTNJpBvbR2yC9iFlm+zu5pw9B2M+kURxUlLri5GZ1oORSsEemwtfRZghU66qRa+87LvLzbrtYruWeW4RhtZh/rWNj7vsnQHegszniVOl/Wg2k+TjQNs/cYFfm41cauvh+zkRctKuuCp+tYtnCbN9MtbfQUHYVqBMGijHL8PWu7LWfQ5m949bscY5vMhLy3Z72Khxa3t5ZTtqgIz8YX/7E6XMvx+b4joFe7AeYwYmJKZcFPyHW/tOLOFrTUyHaLIlFAvz2OnVS2MvoU/HAykqB51q40mPLUKAu6MS6pgTH323UBfn1m1pjKJECG2yGv4JpOkaHH5pEW1khgIfmjDeyu0Yost8jOHpB3RD5FaHjwEPWXVUIaQE4DRszHxlkj6zSbRXWKfrlzAtjOG7Gvmc80sli80qvWh/Ia7PZN/9Ohtg0yg3A1EhPsX4bDsk//wThlo6axA++Kx2v0hb56sr7/4gXbeo1vd5NdQ/tegm3rivY0h7WmZWYY+zexOWMOOpRefHVcY4WLfuowKtjK19Iy3tKccNgpRNriT+mrCQEOg3SbKoEwNIxoIHTZctOrAMWcPkNT2GPMAOKuUFZOjkhiWRU2y5iW5UZ/JjkTpsrDs5vg5gr8D3QTnAH8YrKrAOmdfUR465cFrLUIDKd2p0L0Qnz254CxF0itHrlx/elCa9dAb5Yb2ml1VzKM96J1Nr6YT7gNZx2UYlK1Q2TdFZuyyYM+gXZ2pAKDwpdlFN4feNFm6CPIC9KC5CxHNhMoHus40psyKrazRhiW5wafgi/FHlaBLmvb98zmiEaKRSx8sHwdwvuDQGQ2i1AX5Zr+9eJvQKdKIPz7Sd7M1LH7NmdZPHA3CF1a/7Pz10VgagWtvdgPBzXeBjgMvJmWkwfAiRrgYbJ9ng0TlCohev+CeaGg8ljowBF9iycfteq09UuhHZglom2N7CQWKg+DdJxjAGuntFnF5pszlopY+X21ZEglTBKqIpiZ0NNf1PUsdTet2VnSvHMIkujPfNLI6/dvEWwlp9viEYSZIdsd0GXhj+P4qUTBDjyMYYEWQvpomsq4UZ5qpjNiRS9U8QPrhDGlk8iLgkf+3M+ag++k1YGg034Y1FSNq/mfDflxswhweyyy5p7B4YgLLF8aTH6FjKr4V1drBTSqTRlvf6hAWJGCDj5BRvkW7uOESmnmjjJ8xreWsKx2Rlqo6KCYHM9O1B5iB1eAGOsAU009zEN7bNpBsWKzdy2HL/hG2K8hXS/78R/aXlIGTPjSz/tKz4KwRGQdHw6HlfNkvndvVw/47O+cdud9nFdrqwsx2KC2SNtIfyrJqrmW88WOJqM7JHffedwYju1C6f3GusnD5/yXqo7ZdtcvnxZVGc9diK/4afqs2/b76QJRcaS9it8VQRDrh+cjKMt10XmpVv9KLSDxfijyTPLCMZ21YdIRTJZei9ZGrn6gYXTKz6CJNGbpu5VT2TGU7JJ8p4/+zMYLyPk0bd6pCm/RTL2KCpKrMqnkBuvyhSY0VoxtJsMAST9yZdd1AjHWisS21eISW8yTkRKOZX3ESTYHhVLIbM6j6PE2SRdMmOJdmsz0jBPMK+WQnrOVoALic070JuBkmiEhgiWAuOjnj24BvDGaSh0u1cZJXIucDnp+YmVLlICRjgsQPqTiOSfV2vn5hInok1ovHunznK9FeMGde8t+gNMTPcj1YfjysPhyELnaFbViD2GRWSkdS4Ei6T/8gLd/1ZF9LUEjWid2x0i65zb0IH7JWOZc4y+KF/i92GzcErRyYJ1kJMBKOniw4yTRv55qdSkNJD9ayKxDpVig7HQG2Ig7mdcAGgr6FLxRjX3O/yIaMmZFJgCWdEG/IjmfEj5FQjJVNsyddXGF9KTzvtPexgBMifqnlmtFsQVCoGM8sK0UZF3cSAzXmAGLnO7dAA4c5qflkc1TmE6KglsikwBSPx/iyCKkh9cy1fg6lNI4AAz4djAj32y00ccr6jBJtZc8VPjiP24SBMm2FGj7jZtBvSk9qAqh0KZjKGdw+LHC8YZeYArnrGTtyKBtjr+jDaMaCy54Ut5mFqeH+86iRUaIJ/wjyTR4bIGXfjwdXCAz5zqNpkFAN+kbUvDC12RX9EKR7XdodPUKEBjzK1ebjcIcmjIJZTY7dPlEvXtsOC8M/5F0lyqthJo9e4Yf7MkBOy0jofkigtx8ZqFmh4tsSV9pHqdZqU3SLm9He17KLnxBVqZ42QbVgCeztTIet9SIhHQu0MG0pvarzUj+0PWZlqVQOug4Ooqvu3j3ssjsQuOftCXy/K1zTyf0DIppZidCjufij1E21FPQ8Qb92UTx95A4qiqeVkiuzTAqjKt9iClbQpUNErvjWzLDLW92rDD5Q9+l0bFySdnTaxi4Pu98fB63q+lUiZOz2mX2a4DonhXhlBhXTQtsGuRNeypHq5zX3GaB40MQtB73V6soZf14b7vX6f2iOzPgudfBkLcdhT49e1VIo8hiORqKwlj+HoTc6kse2ISaxOtZ9SJFtdkgOxVEuppn+u/cZKy8ECngoVUGXmv1SMnVyRU9o5fqio1wfsBKCdNqugBfFhFCNOAGWE30RMc1B7vpyRspCXqUeqhxOIDULSt0w3JNJUPCffQha5GK0n6bRMjXYvzDo2ubzq9aUuhdVzLPr5LT/fLO7xDXGRinX+Z9v4tngq87uIocqAauPqBrNV0VFHCdZTmI3/d5p4g1XcvqUYd2lzmxm7aoyyAaw5If2z7QGg7riiw3pnJI83z/RR+9MpjeLlClyizfFnmjOPuz7nkXwKpgfQSwSEJQ1eZHyFbj6L4U2Pfta555sW1pt0rKzzg4OinA7/uB7/P4abDOI2VqccP5zrJ6JrhOgUYK/uNt967NvhnsnCsCQE3YMcAkUD0mIJZ1JJCY7E5YH1Jxmphktw22YhJhSSrZ7dwtrnDFdgDVhirFr/WCnwRxWnXcPRu3zerwPZoO72fZfHbHf4GR3zkx/DdwezYePI05yodyIWJIzPHu1tvwbfS1aOWv5JlY/6yizyx/eTeQDU1CyS9m+BWnBvemmchP9Eeq8HA5gxaiaFLnMdJniDX46Fs+Z5zLvDS6C6HcDp6kyrD7es3vYD+rUer29DRcJYU6vnCvVjjYUuT43oiALalnsYamxINiP0oiMmAUGXEKjY/PF+87klBXnE0ZtQSIBqVSDVvlM7s2hVSQqR8FpA/KMazn9Ub9TMJ9SXzoECiJl1wyBdWVlFMu0VYZhSS3ZoeTihZpyKAnO4DFDMaXn+kWyo6wmFy/qJxrNUSi8rQdQ52ociGcYoYTgeYTWEAs+u/J9YZ6UlwPj8RoLVKMipEZ9cbGeihcQE0glm0H/XQw/TR+99tFn/371Q04iwQ/5JBeh0gzyQfbY8RTKLR44pHqtViKRjgvlTD7owpYEp2Lw1EdCJ5yLyGflcGIs91Lnn169pNTAp6uOEZicND17gxHsdV8sfe3/lmXTPF/1BL8ApM1rwJmKl5ByFZ2EVPyMwb4Z2nXXqOxHBzvIJknHTONZekNhKeIP0cENr9aawdHYnS3KP4EyL+PyJQE+jaOsYGfG80kwZusi2u+pJraR4uWerM/zUSWvNG50FRCCvsibsohk+vq1CrtDTVvzOm+Jg7V+zQcw4NpygbVy22ycIU3CKi+FBRUdIIT4yRsHeqj7WOs0k6nu/JPhl/0WyXE8UNpXFC5MpiZYA+7yfs9NEh1t3gP1NqxtO7el4KfTv3zOhTV4JY5NZkzedC2NwaLEJnvCE7ZRxxdPfH5FhZbY8/UGDCKFmu0HP7ya/oU/fZTN/fvL7eKJKfpLjcIO68B/GXpG7ZMn7CoICkScCueRnp0FF3zJ43vSplL/rKoNuyplAttKkQJCGlDF7Ke1QjfKr+qYJ2MmwzcQpbj9kUrOhhN1O1ZWI6yDZGApf+1uKIV9Q87p837DWGyghhNIjI0C+GiVHTnVd6snDjVrTfekDwjUBK0FI+RrkgPDkGQecOtDbyoBkWNSy68YpKorkVz08wSLKKbEven2ZP82cZKR0H9l54mDR18yZP/jUD4qoJ9wifiXzVhMcvpvmwoKtkAgYgLc/8znkACwLtAylkoSrr7Cz4B5a2/9yz0berCGkSDa3lSWJxgE7lhhIloiMy6Xp2pwWtqZexYFqgyUNppts5lqnXcUOwaWGGycFnCTzshaXp9VRCWGRKAQDHbF+rEFwt/RWIo7S1PiF9iY/1IL833VAjYHAsmpIoh+odr26/sqLHOOTeJOAu3xyF+GOmNxKiYLRf3VQHbjtm/7rN/3N8/2Z+3I3Uqq24+HVl0wQLo386x3ZeBBt6Yl5AuN0IwVWvLjSakwNfJdhui8SUBw/fsLiTNrN/lbwJWGRpTvsBccPLw1u0PxA8cT+aC3ws0s0ucYU/H8NgvIL0Tnk3fl+Bv+VHk3MqGWKtwgLgAoGbAtR3zLcl0cManJ224oFlQXjnfT+ncsGxe7LvduOTPpXgv0XkdWo/Ne58K/7c+0AzksqZZ59GaUfvQhtyb4ax8HzWbi3LPXOJj+FF0dfUv/RY76rOMMmnvPhASz6vsPdw9jBmUVdNNiYBYHvdoj50ieXE7v9yeF1m5ZiYteodgs5PdlC8cGgb8gguYDgTjtdmRl/eRpU1CN3TI8+p1e1zDHRpGHMrZpq/gNNRErKyEUaXedRQs9vZbPC57uA93eUL9jh0/+UAR/6OO+Uyf10Z9MPY1BnMYJPap9xNtdPenF7r9IGTx1sifs7O4S/l7qWJEWYfPURwk96RFLY6d6eLrae7tZn7DJKO1grZSUTErmZIilBdqMLyNHVHC4Yp9yBTobv+pNyh8QKQtrcG2toGbkJKTeWjlg6jS1yAma4SBAcqgooD3HF37yGA5m4CXZK1ewa4nMoxeRVn2nbSLRKFPl88Yipu4S74pPN1t2axZIv5KKCZBAadAcb3XhfhnJSx8iT8uAc8Xva5l8q6F+0yzBwgr2MIZTVFvaQFR+jwFG/3aPz/WlXQEVqKl15yWfcC4vkiJHPj+uqmvmxMwL1PJF/pWZmuzAtFJveipSiC8SPC4ChQDJvBbnHOnL3sJEA103Zi/pg9Q8XvUvpMScyDD6h4pc3LSJqqOEjFcpSNXUEgjjP67U0lF9c4AVSlQWuw5icPWa7zZQBkagY5YlI5ywoHYtGstzv3CQqrCQLZu8/+MQqRuYh89nC2M7kQUpJ/i+8hi5cqeF8M7Ztaxbu6+3TApjoxZJg96z0bV0UFW0NJcF9gVTZAhjrxBljtZhejeT91E/EVSyQoBKEqJQpjZxb0iLFxAwRXE/YQ0U9cx2TnTuAwp8iv0SmOnC6HyKYejQHuRzo9x9AQNDtUcZohLeJZZIwyI15svFUmleBEYy1bCmPy02c5xpE6mqu3I81pRawVl1W5HjR2qwOsfDlazibhBarUtcepparRImQA1qdNETZKc/n2CRsU1pS0ash2rBMcAnuytE0BUxLBb+usVxUXbD2JikGapfftheVoFUwCB1yGAlwUbq6FAsHM1QoA5FTKoiGsfHfsFBoQpgI/e1MMSSEIqZl1oCVYwfLzS3MFhSH0ZWkc5VluX7rZZv0ge1cYSr1RHWk8OuohrG9dpdTlwOXkapwHJffrPeUYPCAanpI4JcB7RpC999/e+HH33zv0P3fiyPK2iVF9P2YH17VKoaITmrX6975lzQujN0K3Kywh4JtSI4LncGNcLQLmiVrusQNW/OPG4u6lWHK5bjYXTqLB2r7ubyzr//nPpsdOO0pR4N42wd9Dq8Gvu0fM3DYVm1eDlqWXDT5wGJml5VaaVgzKZSCMHcbklQQ2NyVi52TvinI+EvnHCe7ian3pnQAUekkAxF49pHNweeghbFoResdq5ajg/kKWha4yd8Nxii1ZHrl+6ICpSjoenV7A3jwdTKQDyiS02+ez3lsuyfVsN8uShxm3rw36M1PiUip+7yBkGnbkEzK6et8GL2vuD0/zSKAAkWlOS/YE3Mn4zdYF6GQJh0LsL2xXgrGn9h/UJlt4o9qTJCsxycUHqsTahre+trGZ7w5QNXQLSiX2SAsiO0nNYDX/zDzbPlBBenu/L+x4LdI41Or9PzLB4sLBDhHmp851/+4yEFgq0etszv1ZAC/csZ+1Zb5XqhVOecMfwYmc4pJubGcSUIlgT/Dv0snDSL1OrW0wT2m9hKm5b5JQLJ6nDiP3TOI/9KrxNQkyuhDuDmDzNYqiaPn3x9/Njbx1uP/XNXAxIEvfYJdqjQLnDTvZUU5bUpUmWZwl+c+tWYzxd9JnCdzOvJIMlNOsvBjw4dR2ucyKiOnirtow2q87jONn81otu/m9QdojF+4lxl4xSvSV/vRSh7M2dHWYGbhfGinls3vCs2MlU2/Qotx9vk2zt9a5fidDsH4IROofv7P+pSrEFos3UZ9oopdpkU4QX5MtVlYcnY3+leancBkl2JydowOz6D2DXUwss8W0Vi7+2xCDblcs3tu+e9d1OQyQ2sINP472SNkCOZAdYWq3c8HGLgJR+b49XM546uan0SuYN+VCj1/E6SwVGRt/YkRMBJqigX1CoEsVX0Bas1WfOFA/WfmdLv/vtcX9RBXez3dh2351r+Z2PvBS+D5BY3UnbPlkrXkq8M8bIpigZaoRUWKmvIHBaTS6jz1qwYbFhEzr4OqQCfhvVzCFh2jxFexqls7h3Xlj84aVkH6cF/v4vOR4uFRz8HS4PeJihNnj69ih7Y2LnAkLZLxf65kkofpIOzPeuv6r3XdcGY/73s/+c4NNm7Udz9wbc+EG4bI/GTJ1a4I+M9L6Un524MzaNODQwsxEq7DeGGbnY6dV1ijY25YzNezIk17riPYZfty468bGNN6BNM0+6pB5tnXJ3Ovg9FiI962jzlffcomgaeNE3a24ApDXVxlGew9KPL6X4bbipC1WFwT6jE87Z+bwr/Shk75detV5INmU8/yznoJFcHy78eatOOjmWiJncAYepRZGHITJmMHQ3JA86UGEjCui3DpmyllI3euZAeEzdOvT/r5aDH7LaXamILqD6KrvUJWrXVdBUCG3yam5yO7L99z2s0H3pCcfVRtiz9nQQUvupATGJhDrzkveCI+ax7RWH8SAoTOsOnctSuqnl8UKsa/527UuUNwiAGAsfgZtUTfY9nwWGYYkppOkwIiw5DXFTfPjWNmDICfsSr/9NfJ3DAVptpdxUPNaCEOz/v8IIjUpJBvRKL6rXR6U01XX7UPUp+xPfl8sD/3ecXueBPm5Bu/C6d7U1T/j/j7Hi15gzE2Wk4c+Klq0/MqhNLk7B8e2WBwFF0uuRG5GdBJE1jMLtmn06H5BiDQ2rKvzcn788+27C/aVhTmCWbZ2hEOqSmDsNlQteH3qV+DFYdOPWqnqMg+at/gOv5BM9yzQUxLE2h/xd4etP/oUTBwpV/qeAy1fX/hck/1p2mWLq3l4W4e78tUSKmKtSya5qpAuuvJuDlx42KQhzMPL3enjs0vRc0pzmYf/qUMV2JAfEq2WPxp/9xFp9nltJGJc4qO7wX599Dd2haVuv3j9mzQgvOE+lDWfdpxj41iNzWeywDRMxccl4wyXvP1P6m7Md550QHacF7onyIPT/lrtA3TQfe1YpuR8vaHZ98uW5N4Zw0E5yrlrY6Wt7tFPn0scoQhRfgbdcPPGnye7xhLaumQn73DZo72oay8uGc4PPp06tt3nGQYhLq8hT8fFp63OKAtjp/SRupwXF03h0oJcs+rVV7HysRI1V+MDsZJvMqnIF7rNIpSWD/Qiyp00gEne5SmowfHmlCRff5VOYvXv38xFxN/rMz/+s1czIvHZVXtIZbW18mIl3dnDQLzEp0uCiE0mxKX7qEw0sA4FkodE/zGi+ZWrgdHlYv/L66ZmjHqaT7k++18p60ROMqSTaC45uEEobut/1vKzRmLNCTzL6OsFCZn632epu5PY7Je8I0pwOjPdwnuQB1huJ2Zk7+OLRwQJiYt9LmHDSrriWt0gQaMtVlB8HA/TCtDMP6QQkde4Xd9XOX8I3+zaF85IjkuLIwxHfVkfBcy7mxPtAjFSn4AMaKBmI+POOd3fIDHswJSh1vH0UK30GjP9rnFt8s4MyDwTBMavyYjvYJdvGOnGc2sti16j3mcmnC9IFwMa/7uOB7eUbDjRNp3X0k4ob/ZSXy/bgm+4hruqu9avcFKzAHc+cLuJHrgRpL+byKe/r2JKWgnDAnDGv0gOThnOI7KAlkdQl0htM2h3+GOVTAv4zVBKgMxWDC4DSTf2urDrluy4oXj5Cv7lBjvJFsidIRBXyOmCwD7J+OKD+6Sx50U1NfVX5gEiz5B7dTSsGgOBO45qM5c6dYdq8cQoFqbItgB5HFbvwcPshCaDPxDLhE136qBk1KW821Y9hod4bi6opbmmzSHHhy5pt27uxPjX9IgIQPJj+mZpxwSq6tApciDJMMJvGFOCMXJX7LcNaFito+Vm1bpxfotvjtW/KvBuC2a5zju6QN5OacUtzviNKPhVVk9BHXU9/R2sLaXRG3HPqDyBcJndXs9KBg7YXsjmNGcs7JQjxjooOi0DLY7YOJDKCqzPDodqea9ba5jemaz+3feMsrVMKZSJcWF9u4W/ecTBVuXwDMzAuR2j1q6UryTnRtaL4zy/Iygnd3Kdv3dvaVPhej0kp960lOCz3NqDvHuaOadWxFoyj4dBVDp5lPEpv7nEzVl4mSEkMv/COVLjL83X0mz/o8uPh7C2kYjwq2lZ89hmPa5LomL3UbemLUYqPi4OvEwZZD0byh8YK00FGSKED02ocktabwgz/HW5ih8mYEz5cK8r1OqG8PcweKIOdUJYfOR4AXhcqRM/sklKqyMzbSD4CJ6/rnRcIJaLtVsbey6ZrIdbnVfMVVTMJzCaH5yejT5i+oqTNUKgxzzEL6bMt0b9Uc00dbYCOUG+naoGP2nnutt1C5Oa1AYPFByAgnHLR71d8Hn5w+1fVaxkaEAjtolHD9joMOq67biuFvoSh1qE1BHiJBBtjcpgLrn642Sw1/++WWvaZhlOsWiEpNR+mwwX+54Tv35D68GiqKwemHjZyge/Ys2pP3gfWnrNwqv7AY8mKEXJlcx/K3apeLmdkdcpVplC9BjxIGQqtkxeKnWOD48coy+hWJkMubDmdj8F8SIbKFfMKBmPEMR+hSiRS3Fe1IVY8CUTyqM5ZsZn6ru/3A0Af35rpFBxLo8UDAXpsArdA52L4s6I+Q/zTGGcN+s1dW2BigIugMY1g+qiagECYCFDRzSM6ACJUNqNDlbMDgeoTCyGuJedSUM5mD7zlqYHSfsE0VHTdDzs2cpzhekT45s4/03sVo8PKsPZB/+vLe57dJ2I5NiFNRiDrp/GUChAYLxh+BkYLP8YbjmhbVZQIIGqiuFN2SPsFN4CzwSWFV81zRLme6uxj8q67cV24GN/Yw+h3+yhMDLWwTiemYPEuVfx23cV9yZc/MzC/kR+v5dFvvh1yg0BVbrNjwmfBPdpPpA8FsENoengy73bA9sflJCFlzoNW8ccAr2rP2xuwW1KohoM8HgzjPe1FRbN1paH8+T1QVt322KPC2Hkm0LGYhZu2q8vPc/1TyedcEexu9/2KT68egygwzUAuMkL9oeDSCWD5NON7s5SPnaTN0wkIMoMCsa9pclkl2vHmMNIU7AcFIywoiPJ+nqgM0rVP9ii898hIEkteAo5ZWmckf1zUtFDjMpt9jetkj5dlNPkuIuc72PAoZ6pqHFh2tngL0QjjRcUuWe+rDtptv6aOySY08o4jHLdAebFWHHKOShXIuIVa6CSuwgGn5WcwANmCCP5kAOta5gfcYA1GGHJ0HJSTMvu4Fi0kBkpWbcgAgGVERXk8B1ZyzkZXCJF+Doj5UscjSqqN14/Gwrku2mevtufIjhXDscMgi9+GlbfjJMFV/Sys2BGyTjUgKuoN2Xl9PeqhEFqFjpeOBDGtQoHPOkdJusSlo0TFxwhOUbmsIikDwhp4awHVTSeMA5fGJCtvvN+7MLMnyPTV8OFmOPQf1lqIx3JJWtbawcSXlkJMiN2FG+WF1z2ZsjE0P+e94c5KaiXnzJnjoTTMmLnbnYNS85Ng+EkIJUPBJeB9Ok8GSHOfUuyCmKSI9JcOQSZrCVzZuVdtBpi5C77wpaZY3HwXRU3g0ALU/K2hKq5CxAzVPS0LbWB4NVwzNyyqWYaAmljRVEuMcQqq3cRvKMGz0P13Ohw1RHXTohXQln6yyslzmFGdIESlV8L6sl+azVyKFKzVRY3cuxq/O+gp/KaaskW7sof7QgxZLqBlBRPX029vRa91VM6hnbaX8b+PxoIqTZZn3fJf8Vy+tOHT9aGDcRtxqDXac/jeHyHb0yKo1YjZPehzJIERdQu5Fvq7q8XZrKBGdkc5jejvZuG/tvWrn2Ci/y8J4aTya9mdD77iZA3N6MyqonZcDhxrCnM22MmxidZ89H+XSK4vUnRKheswaTia2xr6pWdNnU+OUW0RFOqUBaNB7pEaRYdcuO+E5MAqfxRvtshWSuG0HqFkKOCd4khEnt1pwagAGuQg3ZYSDix3dqt5gD5CW110kMTp1Un1ZIWh8WLKw458DI8MX+CDZ8uGn47DAv9SQlVKnZr+Rv7bhdrVmvB4r68IgN52DmkxmqeJ+R63SA00maFu2lrWKtqlLuiCKQoXuwaUE+aK1IY9nwsqmpasGenpU0+fCnXDc5eeS3LPbVOmuLL1gtZUfxVJ2OjNK+k7RUxki1rkw3tT+ioUy45kGaULSA9bH8cYQoWzP76kJUs52ewXyn/f65iU4ma038fBxgXSY8R1myArvqClHW6qObzP1Xb8zxI/gv/bJt78cPzpHWvP1FJZf8r2DzuJng5h0ogLG25zoW5xF0hbT9aelUFqC8tHbcw7yV6A7kp9ViGjSoDpszDcEnWPUdZrTytffPSBcPusJi0GMJolqifiU72Uc/aXWYKq3IlDWTj884kpMKnM6Nah9tSZrEx1MVBFViQPZ7/tVlxVkgH3y4+RhYB7KbJmihQ6UrlgxuaB3ClpZKA00MQtpkIPGNx2Ix0I8x0DPZvwPVmr2hr2kwnazRG7r3SYfkCKYOzkwFQ7e5sULIKt68jctBBcmyEBzz+QqXcsUXpVwymFzHtien0JcP08rlHvSp34K3MtZujr3x/5/M0zozUpNsmGx4OHV/1jJX0QT5CardJCKT02SCS2taZFhK5SzV6uHtsjPOlVoo57UYVPJtg+1+GUeEbgKSjgDsK8RQF+vQEK0l5d08sze/4ZvuGBCAWwQ4NzjJEpZPIKh4zdd2KsLBLy7hA3enP9RnG4F6O/67Gxw1MtJaBsqIxMSYWbdhk+tN0xjq1X+Bdjca240nG7Mso0rt5uBRTiQ0BJU+6YabfPeUV0ol0uSWBn6qUmmGnGoGHzqUfxGL85q3IkP/zLsEPEYJihrPg/0M+4M4mUQ8fMfMoZdEvffW4iHckYKN1PvOQEiuVcUXPVAJ3YUyVjIJLfDYUJq6vPLtxJe7rdGXdMG+xByoutp0fPa6kEAre5jJPUv3qCWrLcNju4oXV61Hzdedq0Rp8qSK++CEqLV3YwleduHjIeBp3o0f96gBS/wrO6knvVN8GXVdHqS3fGutS6i9xU8ezpAFa4V9L1k7vqk2o6g5O5s0gf2rTV2ZuVWVcJU2KHDKsISzID2gI7tVQf0r1W+u/IKiZsSZSScBuq/E/58yloTY1TNjqP96HUbcO2dNaaTjhExhI4aQLesdjH35tiNiN7ysnZgTLvPG34PUu3FXHEjVLIwTGqsopC8djHn7DlJDE35x48IUhJN/FkUBp3CaKPlYSJ/kZWoZ4tX749HrmcVCuFK17empRvbEclqRIWmvN+Mqp5wtrHiV5IVb3p9w3u9oEUkETCjI3SQStMD+XCfg3JyNMB9GqMdhmAj0iv4OxlFFoTO4kCpnoRXvE4gyRBfVA0Qt1ddY1Sdzu86/nszizfMdma067OtUgygOjDPOcs67rlNuXZXY3yNs7YJu9MxAjhOnU/jF4285W8CW7ZmRvOSjB9FRHXwpbL4rO/XTx7CnEOBKl0neiz2Jo6Q9XZ5mVKYJHsRehimug26NEtG+sno8ChYCthje+Ixm+q7sHxifRfupp1PeK+v/uAb3CdWXaTymIHaBLrxutfcS6DLgwDFgZMqgnqCeYvhBrSGsXVxkX4gzStr2VRQiqVA3xaXbd20FFvI9xAecug7hY9nKFxE0PPru4a/UfFXM9+iV+i3gCDwc+3Z5aoDLBTlBoGPsji5GgK8auQBNsSSnlHHzkerDzQfE2p1o0GmX83yzvLIQ6wWvsqkqgqX6MvGnMVCiI0RiWVlNREnb9BTDzaQmhJma3/T441Jr5pMc8ygTzH7T991UG5mfHH3zcZ+l7RLFgYbcLeQ0yPhvhbvVTZX7NUsVA9xXeyD3inMDtcuWLeYK47FUpwjOLgnScZg03FG+wH8OgiQlNJEmihSrH2CPT8cLDXWIrtJJ1mFTcANtR16p4BKqhIch0uo8fEki2SNB2m2bgh3TDPz+icw8qZcrKZZ4VGJTKEe1M+A6Sfq/fmvgylhpfpfZu2bVkImbmllW28beau1pIm/+T3zoIn/lRPAfZ4cIcVMTcar3LhZTyuykOOqvuHjOdS6GI/2Gw9tDei8KH2SM3LBvFYaUfWTJNqpy9oRXXfBu6TNaC/CmWl4mtWLXtoov11UHa3y/feickyu8pFKYSpQFVc6Uu3JUoUNl9lkF1K1KdUsWmGgxnK7NU5RavjK9X2fGkcpbQU0f8ghu3SS/I0acaj3MdD0yiWATzeXN3WSs1Fs3mHYU7BxrEZkyfQ7W1+/Al9cd2bsVu8SlBAFG3jGwkXNiJY2AtQLIspFzGF1dH68dDlBhf+H67vfdh15bm6keY74hSgM2Ja6+BEiZ8+CjJaPssBj59IuYYWG4QYNQbfFeSjZv0TA3YrVlYEKwmOlIGgI5KcUOkQlzQlLBgCY2uf9e3R2PZfS3Eu/GpTwG5gJ+e/l/CopnZDVUxukCeAlQNYJGaYU5KFwb+pLNZO4AuVIAM5UoiDV2zewP4ITOdqEGBdsdhfLYUXId1QE26KYev9XDN9ZQ8DOt5l1smbQpGli79QwA0vMUANugxTPYWVJu18PJoKsy4IJ/fUECp6Owr5rtqrD4oQintU6jlj84DmU4UO9OI9GnOdkH/B3a6Ll2F8TmlYCK0Cst6V6Jtiu16q4ZjywjuVZy9Z4FSL/RsLz0Zv63ExgSgqt3eZc71Xn7FQ6h/d4kX9qSxmssn7YMrkNOhDzJUJ71FgDbnyvbQl+09XZcnsXETwN+xebx1shG0W0G0PFDfxDXGKPvyckzLUaY8pDsjTn0SFhEqnEIeGYCHdK4NCHIgZwGotFF0J5yzbvDHrbrpgd2pSuwMBxalG5f/keDpBU4ZNokZYV3aeZObVB02FkE2kw8x2xTU+oQXXecjF/OhiPj6FjzI8QGV6Yud0oLJ0WQOSCVvSBSJNJeFt4emz7Fn9n3TbuU6D8uHhxEn7oefER2xe1QAYNGVseU2qSBd2DWRVMC7xtpCUqugp6eV50GrM7r/HO1uEviDAytl9LSzOkJVN4E3N/iIoc3GnM4kI+V6LGwSMUB+gpOivd3hFHCUiINs6cAwpeugJQqY/dbAhCG26ixi4Ea1jyDRpzRRJDw3Rrt/p/FWjweV3e3kkIACvOkjNBlC8tTwbl+oytgfH+/KOlUCsEaFHCWoxirYQ0lEI8M3Xfg7mK24GS75fY13jFM/2D88R9q+XwxR55GlSLGNqdeTXoLMlz/9ybATQVGWn6/fNDeiGVETQFRVLAtYuf/A7ryb0NazG6QTZA1eCK2BhgcRDDQcs4F9T19M0VRa3DM6OGcEiEJMzNTK/6y9ssACEtxQMpaX8WkC0TiG+4YsI4MpGQGht2oDT8VNLanghNh6E7uYMcmsm9+qdyXoQSjsByIIQogxRKI/LVRvp7DhwcERk9Qnk1pkYTAbjTJJzDLeMfeBO4o1EOrHi2umlI51Y1HR2OqsIb+ox3j3NQsdt49V6B9b12rVYf8KdU75dA1BOeSa6GRhbWSaKDTdmVY5/GvfkIT2/t/NunuqcfnJoP7RxZeJFU/tO5IBUgkxEkk3DQ9sbdwhVYsByEKRxD2aClxcCXNVK52hM0lPzpSEsmCM6Q5AHi+Hgth1HmP0DLF+cqmFGYNwRtaTJMqAFxn4KzGXxhSG4LZboG2kovuemN+ASNLakuyzAapGEu8iuNHVERZAH+oALjLKh9f3vTnLZUj1HaHJFLMd/y3TycXPXYM+MlqGRtV6KYf9mRwMZRSZlH9KRhKMcJRiNtJyy0rG2355nR63FCQ92E4Obb4Ws2suu846/7p891T18LXRKWO7Zj9swFaba4bfpfTTit3OCJtS/MZm/MdFTbXiWH5iYRsJ1l2fXDMy6oN32s2qRi2L10tcNjHix1Dsc6zXtG9OjctC0UQfZa/hPUU3sx8x74aR1bs5vyxPcIxXrM84bg+Tac1uLRMp+DJTv43nfmzEx7V29h88oih919IRzJtxz/2TtbYpUEtcKc4fVN0B3gNIJD6zFLkt5ci/SCQNEMiBs/M+9Fz1ATfbGGTqrKKad96i10QMrznpzombnY6fafeEJRNIzsiTVAv0BHFYJYzjajQA1cUpZaQLN3iORjPP3frSzqB/XG4DOw5NIj7+2qSCYr8ecuKtBXIdL+4x3zjL+Fwdb4zVvVS6sDxr2+Z4eOYLryjxgLPo1fTE3XiLYG7/7n4y1MZFCVWtyarROtKEjJ6O+RwN44DmuVemhwZKjlykJGR9K7VI1BcuFL+7Tb2D08mm6n1Eo80GbsWsM83ns0TOBXbTl996O/A8K2v7RlOHRSYprUyW0YhV0GJS8M5/ze/vr84C/uujffyvz3419yVHQxMnZ7onkk95tLZUz90EtpXMikrDc86olBEUsq9EgPBEP1YY8khqem0syAQfLGxF7ljyrT6hOPVXjlKr//gCHYahi9KS3FQ8qYEwrH+KL2LNrs69VMdsMdM6il2TcwH9oLE6fFH9Lgy2l/uSVK+fenkaeeBdrg9kkX7dGMnmYhdBZ97sNrQP4Me32sJ3q7IoaU6QObI2JyhfJVBHvU1rH7JNB9xUWdPFSMkSKT3v0usX9oOJ8YG9+wJ7bkYxvRdFxy+tTM4tDYWnKbIGPaqCK9MF2hAUPL1WNzCLF717DPbG8PVnDtdwqh8vWCiP9ECsRGVYWZAiTAHxyfkc5uyLVa6+TtI9XG1lJ9V2VpR7mluauxspWfQOjtUazPdWpvgpFhrce3jmo97Js6Qj6bEndCvV22MnhzlLrTnDPdZzpqX9EvVHcXBrhhDl0fvTKFLfCgaa2npIt2qgVqwa4503Gh44Y3U41fsM53zudV0KhBIIGBNVTQ+mUfNDaJCECef7b0OB2g5CLt1MMPCOvhGrleqHKuBjhSombjKDpE34RbZzgOviI3RO0Td9dBpn3tq6VUDTx9dVHGin/1oKme6ftDs3V2u4fdyJ1z10CcpnwHHkMwX7gxtJmqvhtzad3JLy7OnOjQChkOxXpje0d1esK45anNpxKUTnoVew8HB+ccd3CzO4p5qBowksN1DP1MpC29dhj8sAvKYbMEhwRVlPQUldHJ0MLRtWmkqmvistN9aE9QRR2nrSr0Ue05ZPrAB8CPRWsLZvMlLncrg/F5DOyddImtBZ86dFO9mUksDxQb4tTKQB+mIL0eq9PvWs221IUvzC3AQhPFn6Lnrlns0vh8pppwDrbYXzL1GRBDJhW9FyXXQrxo/tFgXZlYdRCtVemurlyUSOmkkd6Xa491wI0rpPKuhHUsJ01KWH4A5YvZ2C+0yvJ58Jav4UNMPPV4z/tJ6CwY+rvFZ9df3v7g9PQbb1I5HwM6MNpUkLw2dP6HINPfq9c+/Zdx/q+BNQcv1P0e22C2bgyql4F9f5OOg8EDP3bZ4f1jaqVvEni1zwv0NbaREyZsK+1SMC7NbUqwq4uLyY4JT/ccmLq56QL/fNTOpvQl+k3vTOC2YS1X+AAjtiUpUOXuR+v9tfCu8UelfQds7unwWm50/VL10OAcfQjV0HJuz5KtJb4PKa40vHYxil4OyhzoAA6dZg+FrlqrOlfldX3N7M9Kmw6+RNbhJt6lu+xSiAES5AY3OAvxsvKBwrT/LZBFWxzYvMTtSH+kcypfSaH6DHauML/KhkUBB6N4+4YN8aLQ4CuMyM9IvcuY82FG1TyPe4cp1N0AFYahAoBLwIu2XM/Ky3EIUugmAX02dXqhg0LEoSjET16gC4GE3TRwZHNXK0+oPajVNH1SHrNsXrlH+7a5PNqMWIav7BlqSqzwMrI5Fs6a5EYyjbTBsvPMEy+dqQ80cjDmoONDbx8hjnTUysLbruuI4GYPLddYqXKe0XzhoTMvts6ahe+6bvfVJZBsgNrQlCUQJ4xeONW/aKz2WNGZg5+y3CswGTHBoVNK0dL+oX+COpzf+2EgbetAtk3DtlRQ8vL7Rmv+Q9ebtuwka8ntPAfYfPjojnipxwfrjpocvHYV59j7VyIVKIyBHxifLC5OmeQmEbsh+tlFRy6JCiFnBpjuYw8vTg2aJFZeG1YfJO9M7D81f/s3wpRqLitnMP2XsAYdSm6KFApmYkvZ9Ls7JzcHsDVbBt61Fapyjq3Vm/rg//izXmnJPc0q9dp4GcZ63Fau463nGmZALMIFPqCXF8HP8NO6qx/CTao5I5VlYuUEDRMxlbTpF718p9q87pecXyg6U/m2XHWRygKiC7tltzQxkQi1QnipM8BKO0286JWt0pEJyLa4ERXVMyQA8zA0bH3wpOHS/asqMBoLzDFSbtmlGGd6lmWv2CJVNlBli5ZRjT05UQMqEK2Ut6AhpjdcuVqg1nveN5aSoaa5iRizPoFuyq5k9ZUX3Oxjd9KerecVz7TY0Xu4EdbF8+NUMdDvBAo1TEhP7n9klev8naAsv/iHn3pWn7nw2/OAX9oKFZaYay5mIb15QcZowDNlPavsplajAdwr/R7zy8ZM/xtZtk2GCu/U7BImUHbdOKkIR8g4EJBZOg4hlIAqmCofJ+nbR1nsyJx+1zB4rrpkv7RnYQGxP5vWX4Ax9LABZw4S2KvYSh8T4h+89p/++qcpIQFM0Sw1e6VdhFpawTAsC4Sk8fGTLofnkWMYuiHmCYTEmVtgqUYA9WLwB66ruN/4w7EPhkUjjytxEX8Y5PAk6ZNF6kUruNFMY5a/PZJZBUfmq7YeisvIwzwJoPQGZwZhAhVTzaVXIoWMlsDlczFE4U84DBRPwjLlLPBGHYX/Lq5Kpqk1+LHWob0rENwPCXgsxWHUBzm66slZxEg/9u3D0hVMfy+p/L1A737ye8xSHMgAUFEn/J3gofyIsMBAsFplqarvDFVxG/+PEdc1dqIFTO1FVdcyFuqVM10vMxVOUJIGze2xi4+LVE3V2DADcoUVDDGN2oURkiL7SAxNCTwTB+CY8t5rcQn5/Bpsl4BtekynV4+vfmsfvG7T01+47Ohhzv3YnWhpG322dvcJua5X5tjuvMTnN8B2IXMO6flmMSUIG4SrBYygj3XIc/3NnJ2r5/4WUE8HQOkdeFitCcGRQD1aqWO0QJd/p4CqLgcE9YBNt0HLrw7a9qqrycMqm7b/ahZ0VOcSlKXPiBTbOIv09TsxidFilRDbIYHaY9RbPNr20v3T1muSf2jNXFioawLecSPFlI5UBiHPVRyPluuERn1no+EztKmFuI/Q39BGl7RrCPdWfIhd50tHehtoROTFTKChl9teKoccg3eTxSuD0Pfbl/F0/qlvLEOpIxz3rXki/M3WJcpk5eNOYsPjl3NPfk8jpfjCbrdRM8WdELKZvgofRlixhrEEv496jMhW5HNRhwrNh1d4c2YhQQRNZ2ggI8B/0YaO7boBYJciFlPC+LvgGz0Kwgc2y6S52bOLIF5KywMzuW81ghr2+WvRfMy5XNkBq/LaPyMmaAyFVhJN9w6Y6akO6O9uCmHYwKa2p5YfrJzqU1aJ4BgoGE+B0tt0y1hq+kdJG9J6nx3hwmHSV+xwZr+wNac8r0Uze376z7WARg3YO3qg+/UTD5prfTUhDcezZ5lOWwl3bOPCArzt+TtrLTFovJuiAUQGtjtp1uJyl4EjcVyDQs2Lg/QhyT3ywNUPseOsITMabGhzD1mZiJDDGHiCgcIc85qXvtXTR7qYHPdMF9AhHcH/fRz5jVeAcfpa+hglAyJ8BOHf4gpEOg/DBUnfdgN1BQ+jYmrMcFkK7G6djC0SUWUHf8NUEb6fhWOU4lGCejCZYeTxrExnu7LAkM4N8qaJz9c54Susped+QHAD6sZwb5mSyRZYBVj9flESNmh4Vylw1F8vftp8mT57sr+tb7Npjel8Wk7yWQ78/HGTr+SUVJMCs/t5Gkx6EZGNT/z0h5OY30/qTHrxAoqUqBpiGYJ+EnyfzX/r01SVitK3YxVW3zbQJzck/QadFoMGSWRH7mKYHmFKQSvMcq1T/pNuaeDZ61m3idkXj4BBwnueF9W15Kh+J7nSZx7mhuEBkxSYB+a8LYrq4FgIGEHYMBdmeR5bXZ9mVDnsPK8q4GvXtaJdjB85BkVB8/nvDa8Pv6FIptY58zpNtTKlKz66Oaugdbp5zJZpvTfcw7105TLPgsXUIKzQF0oTFN9OyXB4dHwDEjmwKBdf8YJDbq3fm05C/jyUjaAZxRMsFfhBjVL2NV/IPqJ2Sf9bK2fSDvWLiv1VXHHRlmQeGSyZRgT0FS2sXpmgVZpAUn38EO4zLJSqGfUgTjRin9NwiSYR3qZE0GI79tNBn2p4AtGdEkmTjRw/7F/59qiKFdURYWRmhH3UsdgW7UaSrzdtdZaB0D/O4cOoymcgjFho6lqj2xM5igCYXFQPqkM5LQ0r/Sx2ngbfIJ4YPBlwTEEW08duxqPBZLSk5oul0tVif4QtzeP2Ug4MyOSKQsRqZCuV7XibTib0MusIZTHfHzA0KVRuh4o92+erWFjNiCxy2JVJMILFjLMa7iavR1PhxXmvJnvR/UsWdtS1uhvjkjIIXTs7Qgp4gUU+GGdpZmBYIGYzEDNH63Ycm20S2NA00wGiInMZQTlyHkRARqqLXGOIR2hwulsBiaII2czGfvvuW4SeQn+h0uTvZJ6/l5QIjJIkgTzwfaiISfxb9k1vFaPcs9xHNrRUIKzPjzsPdU9Iiz8uncjCEftAXa2I8HsCf8jIMYKw/gGbyY+c4ORVq0Lfv8OOcWG5Pe3ogfIQfRB/Q1Kng33vmo4cQnrGrfv4T/TZULbc85ULDT7tEX4V+tH1ZRhjQduBkkV128vCAsf7h5ewDz+ZwRj1o4jsJjRDMXXSC3tJmb+l3h/bUjPrFvJxw1XKlkQdVuDVLmjcOswKOyKJy7cZXOt08H1AESC2JirxDlqZtlnDKgwIc91FaF47dDZ+lSqAji+68liAVeWIF8VL6tboL2QRnO257ivGncHSwEIVenE0/9FNhMsmNWcsjBmusK8+P8kp3lfWB7PvI4g9xgqedbTa05OyUcWVV7ENOTMWrOkody+TpMfuvbR0bPQntdcpwdTtgA3LzPBFSuyMcfIrlhs9UMvp3CVhMwOOvHJorK121E2w9nMDowiU7xCBohVggeU2YOSoKFawdzIXHUzRpYw6G3oj7pzOhUPU+9aiEeQYHYqRwidS8k0AD/f6gxJPRsATHs0kZykBKvt3ZIfI81GictJAlbBKtEFxQ7V1Jp3uf0d+nw3Y9MQ09tBgK5bclE3qQeT+jd/I+1imIyw1ZBPEXMAhFDnAL6HFA6di/S23cxA+9XgSHGMNtbHlFigg6eQBHyaqOChZc4vqWuZIdyNV59M3ltY/4UR3CVB6Ks18Nlgz/n9lmiSrDkRyG/tNE2eZebOBNWJogDWQKzClsraekUzLx1yNfkSfaA8zXotJyLCN5qKBoCuwQ3Q3Sj77Eaegpu8to1cbKnjuQEyeMFQPBwdLcepSGupDkx1JHfhksFZibNkYYxG8LhoNMOrtMobXahJVGcVzPB2mNoy/HO8htdCIIjmFfXPqt/5VI1ean4MBcLtd15AS5iiJSvFBsMJIBJx1de2YpsPO7mmzTfvYMTU9PchnxDKodbXTNVSRJnza6wDW0j/QTbm3ZX7ltwwGs+/3bVuTr8ND0oZysr4l4BQJjjibCx6hI6a0CnTsDAVMozkWOgO1KrSfOg1HdFlEV+3bVBgDRts0NtQ6FW6Khbcc2Glz0pIgMHLc/PsrckoTYHzAGwaNKLeogJxZmoSp+mJyVNMzTcvL3DWQrIATWrYSA3tKga6MZIZxiLn/qbo8HI6Zk5N63DF/cvNAwJgaNkOJyOUNbPqcf9EgJbxGfY5wzXo+li4wVzbZuR1X9Nyr035Z7Q3+2kfpIpWYCQHLhrrroMvZAYYU2hohSMVgfUhD73SsLvZRLM9RYOVkek3KDz8hC2g4VdT6BdzOrhcLXhkh9R4dH7PecjuE1G7FVWyE8YYkoigsMk4dUb9aSZwB2MtwEJMGjUdzhOK0PKiosUqHGXJeIADllg3y/7RryVcY7qK9bRCvSa7H5H9vOGpf3iVWUPKGSrkmp0d195v0/ysSaYsaOVPLTh9S1nOZfsEzeI9Yzimf9cMffi4FnLv0KTwjTOgpaGscnxoDf1xzxSxM7MgQ8P9GU4rT0lxmkK4GmnkI5ODngNJxrZBv6/rm4i8Yfm7oZIBReTGHZ7alI+dkRS5XX+e1IMZMICcrMaR5Y57l83K58nq1oZiKCQU20PcMKxHg84YHjWUx6GDeDWFexiYvlctWmUyoGVBv5/6XhykRM1BN+1m+Cl/4bgtd1xwlusb0Xne1teLq5rNEg2DTKVvym0eNp8PomVvOnGiSXH5Z/vYtSbdXaW0J4BnOVjypz5E33YGjNWJN/HF35DRVhQdTm6dJzX51/eTRlr7PZk2yBMNgVR+TlzLp/IGsG40TMF6LN3IiNiahfAptgsCt5afbXcda6OsdvXCr9tQA7+g2qjtf5x/1usyZfaYxuSjMZ4QuSj5RcVAoRKyb6wwTTod3wuqcmuKKLlirs7TMJhyEKtxoQedpySQ7mdFa1GZh7TaYdn3jcqA8y5v3knIRQMWivuAWRDKaVm4exYZto16S4T27mXfSJ1Wsa2BWT11/ySEXvebpc8sfDnbZ3v09MfwoeKNDLHn36sCcz4f8jomHw8VUuvqyfVbyZnp5Fce/jVDJHcG5s+F+iQhednXk9wemQ6F7P2jZC6I//TwzMbN86862On5yKlV1ne/qthfilqnlfB8X0ehZ74mMBvLkk7JkZfeisFpvtiX+hKnF2ZhkSArB6e9yYg5XpEMM7QTifvW6WWyEL4ua2f6pniU89YWxN+I2dfiu8wpmxxflQ0XZK0gXscN8/SPVdMl1tMJvJdDoyAH1w7QQERLkA+nO+4xACJ+WotO8x5SNgItyoLhwAaCOD/+Ke7ruWAYaYpyCW6wCk7R0A8vA4JQ8T6YzQBiB1Bq/vHsJhu7BxwdbGM7DAW2l4IIXPlpW3FizFkgVy5+W7iDeE1dRZ0HQI8NLnVZgt/tgHkuvepgS2EUImnsa/9fqkXFG7yPdf0b+S+S/xTw19drjnvF9BqbpB8exe3OaWCnWSvPsYU7PPNrPmshNl/nkW8Flx4k+QZixsthzNgsLlWN2CjfdzTqA16BXPm7zKJlkO68qHKgEgo+GkHa3iD4FzBA6AvEE2Q+FUYIr+oA95Z4eH9OBPHQaSAqvy2FacBEK3Ai5Xj75OIms58uOb4jUvYTp2Ofn8mu9wFl+iNw9PxHU+xzIqjwDR4VehULjaBAV9WexqIFBRKJ8ZWC99wYint2xEMaUzM3bCbat8vJgihO9MzkoU3/K2Jw+fLNebEde5N8qzGOWVj3RCArdx+dWSahWcOUV50kTpaTP2mZl2X2qzTNWqWRlsoF8TjJlocm2mA/Ph0uOMAh9x8PmdON05I4EPoKT6KYKM8G7k2X3VZgarO1c+K1XloEikimX0K4cvo4MfHNvcrUJH4q6+fuQxsdOvoUMe+fBYQNi6eoMYlQwipgpb2Ne9NXxdAdW5Ku3nD98TTe+kAa+QSXhGFHJVYZ10Mvh/EyZRN/f1sOy/bxIhyU7ri+hgQLSn0MPHJx+9/xvQAB+0NKhKPARho/pXMdsBnMDvWnKaT0C4qhVBy5ptsPiRYVRIkwJZzgvd3PwtF4BDm2xsEnrtk8SvNswstSQXZUwSmgrqE88wb2xlMiR/a1xMNhgwCU+baRyOsAVzUxJaaMgV5EvjgaOZ4cO977FcT53IcXaZ7yhaFv4EDs2QWtytF6CrF5xdNhulkasBuThPE5Vvut7YUtQW5GoyUfExKVDDCMtBbkjLV1zuTrJTQ3ISJVHXm8xiUBAohW2rOENY0tjP1Ke86723nijaFgRnOqDoN8iSYf1qO2RhLVqaLD/VUxPNt70TBm/L0OE+h+KOqWp99WkoWoA16LNJwvmJFzbRFUNWLHQVpjrqqBX7un3TwqLJaxQ5yYYFxiQdcMMGq1wsFyPC4v8HTkMgKnuqolHrHF2rXIF1fJQrjfnNAFFdwj2SCmHEboQFTHUyRk7UhtMxFl/uQBExTiPBCMPZTViKRxOqf9K7QJTGz7vDYGCpj5Sc4AHYJyB5+wYeAwM3dT6HL4zQTSH/gRLRlA3NcjlEc29IMY7Z4iHSbszfsk6OyXXXdQ6TJhsOLRDUMhwl9Maaq8Wwx/mI4SC1PO8yi6OKA5TbB8aDdxoqIP4tH2QZLOT6lRUGTGsYZMwjGmCUGWsVgQlYjD7YMdV1nmvDh5EvMYMAtwSIL1xHB2Hz3N2yRtMids6sP94uY4KKQ2ZtXHRbgNMh4Jm4Glmn/TTjJnoBcGP6EKjizL+PFF2NL0bP1/XnhvGMvzUWgwGPeGGnAgMdROSAphWLWncNVqqNTib7kuF0kAkbbbBYW32Z0Zc1ccJL3cGYfrPf+1T3QYCixXoACiVgF3ganL+a0EJi+hD3QOnSuXEWnwc5U4pD+PuK9obf3evYQOghUk8CkRWd+E1+sTOrYrawUrPDxGgLUdyoe3hQeGNd7KiF7y3d/z7SDCtuBz9c7EPGYI5c9xDvq0l9XD6Jfl/pXpJ/Bz3QZ7xHntg/A0PLDIM1qmDk4F/mWT1q2o60QQGKtSHp3JWy0pV9F1E+2+2mO4dGrycpITBZvw3XfK8PRn8TomYTscmkgqKmUtYOJ7I/XCQruadp8AROa924pdpQlxcQooRzbydQXmpV99+4sY7J17s0V5Kmrh6GT0tw98QeHI7b8Ljy5M2kpSw4FHk0CBY8saSCLVm7d0TIe0WLwkrJnuKwdHd4eC7LM/hpXAu1F+0LdmJpLMlEryo6A2DvI4jTP38GAy7ApMMy8VMZnpkSazf8wbyHlSxyzzBdYB/yq0wf6VusZQVT95bc4Mmu/xGXY1b5bCUZYCJDKVYaefcoCU0nDnvmGyifRNNTsIC0QPtosywcS0jaCZVjEhNVoKJLU1yT56etupSltTejVXpaUGHysxKbIZJS7gd1tD3p/Nu+943OZlLL89QViLfx8rUnVM4mHMdPjVTVaP7ZmVWwn0er8FqFoC7BOLBMJPg416lzSHr8cNPCOvbbz58+e29zynam69v8k+w6gL67hr/bO5gLrHCjdSqJfjCUPqNHbVXU0bApqxXV3n0CM3OLyx8URchhk/qohmIIfQtR8E0VNRkKTpfZRm4xjGQysXcX2KuWuc3bSP/1wTdRSTWe+dyB2b7lxXMyrR0gvTdwDJHj6FPymBHMKUJ/OzGnWtNW42CPl8ts1VIytGKDZCjzYMqa0PpG5cFSgCNd1yyEpNSXA3E/UVyg1A+a3ZqLPDu9d1y2DmN3wXecGS7fvmP0gxYvbRVljbj9JUGhSeobGNaCbeUB6eaziRLHzxAkoKQr+gqBZkZF4otwaiKjR140SYpPXiJxAcZJKOuNP5QbyOoDR4KXf/SF6hfsZaSqB/CC88kajsVoLUAiy373XeDiDclerGhDLcDnembbfHuRvhu8uZd6Fz1fzjqvWWroXlHq7F2aDPbE02zURQzNiOlVwf84b/DI4R52HXuNxrieVK8eH4NMQExTVPsU5Qeup+sn/MBhDLXC8KCGuldCWNAZKEQLmZcwdlekAQ3Db8FXYn6wOgSQJDm9LCuukfBfZt5H1S5emOE1RuEUB5q3gDilQFzGvFTg7bth7gSPG3Dff4g/gTwb8kDPlDDB05sfwEPRJnZHaaqb+Se0KAx/gzI9s+u+hqRes8Aqg3Iq8or4QoeHwFDhIwRqUJ2Vfs5B4S9YFXKM7CnJHhnaoGXopZDAZGQVbdfn0b2HJi8E87n94/0Z3GX9CZM+9dWFlIxKaZ8SXhcFiehtaUi14nFoUEoLUlUqeWdxrEcwimZFZV1i7JkH4rwnujAAyFQGBKrjxhN936wJ9onG7ytI6tqknX+cPjcUgrZtY+d7fIfqfzeLQEx+9RAOhkv6/Z5qT+zPoni4JXUciYfMEqBMKFIt6aTJpMhZbz7w+LPZavuhnQduKzXlFBofh1efG9nJAWdmY39sLvxflPA3pPh5Az4bhUM+bPUBtcG9nenTtoJAiVCfw+Vt0/Bn/nbx6eRlASxSmxRCE0yvTkiA+NZOsa0eM25aHQTjkTvHKTdfT0v+bceDuD9zpbrSPSEDrIPKn5MaJ/D/0q3k7AoxdRdFvw7/Vj1C2Vn1crSQrtuf1nPAxST9KLBiFVzzq7X5UjlWeNDi5znRlLIABbHo9IMHJ25Rh0BKrOBmiEO8msFcdJJZesAuyNJcfxJAa+ELexolY28GgVhIaFy/CALA6uEWtbnh/yq0JdFjV9350nPJazDJwoKY17JZsCu/Bd/Pw+8JTiMOqvmkZ0lFSYqqEnTJQ8QriaBFp+HSeJuiEXk3H4FxMOeofi04Eb2PFny4ksYc2QwSHKbExyubaliVHXmQrbCAM1khcVdIkwmdMtJUvUukpJo1QplF62C3DOdOANfqTQsdBwUgaD4HUS3541IS+Mvz/SCL+gkiAB2MkV/15SVgxm36PB7vCBa7LEQsvPDfYZdEBHz73NwFpFzgxXBXjS83gNRN5/hXcGjDUExf8qq166869RjKXJNlwn6ReZwIddAV6Jern8jt+ZiJI+gm6h1SGj/eaG/z8SieoaM9ONd+K9psPXm4jwGNQESXHEweetRZOKKbRowjzRnKPjJWn0SKwllinMDzhQfPrSyKYMIKe1Qbs5HJdYR9+YHjceB5STgr5hbpdgnT0ZuoD5gZaL6FmelUPy26mPPvaRd2hVu11UgLVEDmoyxvNN5i6ngVnaDRgAfAOuQb39b/8ux/Ldf/ad5Udc5x1MMjJnrRLzSkt+EDy9VrPrc33YQOjQmnr8SPA/jhIl01aVkoBfLtczVq3EX6WPJc2d0LBmnA/vw7wwYH82ck88rqwglYlIh6aMYD/YywrysWNsEXs1ZgMvayKHLUEKzqD9iPBVh5gYbMU2oQUAMc46CCI787SzAwHCasGoKFCIrOBjfpodVWGN+mYLxGHai+gZYY22m3m56u2MQFoIRxgZxhAfeuLnAFbJq02uuYFmeVL527CovfYu+m6gdneAJ3ajkHvgWb6tVhQDSqxEGNxM6iaIRlWYbbtVF1dF6Ag7e6pOPOlaNV9Hlm82CHgb07v30wKk1xXdp9Zxd7LzUaX0zgtcXmtVYqXpUsxA51oTbu+aeorIzmw5j4fcvCt79qsZwJZ4j7++zQlu9RqrSDb//ukCYvotwTgj2jXljnccbDJYyImlcWCu+bSwEOii5SoUoGJCS/I1V/DEqfV2BJCI6GFIzYdaImtK6qCLEQAW260iEogieCpOKJ5Xh/lS6XSn3FXmvcwIseLlFVnmsuzZ0C+qRQ+n199MPKi0yYEqtSIFRPszu9ub7hDMHwdn70IazAONgTdkNSZMn2pOpSvxQYX+xf0pjC24wWUvcwLIWP5PwswCFGsA5saJ3cjk9+g8XJAMr7LXSxn0S2DPSYmp1EgX7JUzxqABNnCfj5Qv336O+oiCPTkF/i9vZzCpNJtKQEIsUPk6wcVYOHsiovIF6msAQq7DyHJWrEv5qsDUoQDiHbNRKFh5hBpNWygeMxXxklEObqTIDQTJ65dGLERxv9c45Z/Mu/UJI+zsq6rmx7QlSzzjXU7iWQMvtIDDgBdiTBdjfDM73lXM1CqYbDprAyf6irvU5tln/8jNK1iB3rcfLibraUpp/EjQwa+Kyc6k2OgdkhW0vVP42A33ZwI8TFK9XiiWnyQfpDR2G6B1aTVvL0BBt7ahqLD/D+WK+QCLyTEloKW+v+iT28lkf3McKjPAXJzvGIiCLyoWuepAEY73Ssnug7oj4yR+a5EOUyxerkp0pdXvRRj+bi9P+z9xL2pndjKSEEj+1hNOS0nYD6woJVgWRRtSRtYjEGSEz7I0dU5bBL3TqanrZQK+3dmBGZ6KP3VqXpVWRDib1Fwc2sQK576tvPVMFBWaFEautZJSMK9iWDLAElBWNYszumxy1D9WsDwQt3EuMEpM9/pIl7dNvMGhW7ML4ZdgAX19CUMILrxCHl5kCdKqfzta3OgMYK3UxRptf7zHD9pn82QK6lssQkPToq8c5E8R0UFgWWJwFAp8nHJ/xmTbXAlMnR5oa6aabRfKEEEb95z/7Wet7Rylt5224PEVHP3/3kOZI+0zt0/ebMsl2nPv2/mffJQO9rWnwaw51YQicHKMqUvLknE3Ugz4ecZ8ki4MfKkuWoo5xJrZ6/mRozyh39NfVeiPOhgoRyYBIqH3fVqmugGttU5ffNeCKpALVfuTj5lDMOq78g31IG2udPtv0DeG8mtznqbqG8zDcWjONXjWLCb14hOy9H3MrKevRrWRSxkQ0eiygB67Edor/+N2xeTg8IJQ1MN1jJwUpdqqour5PuQiyLSakqAXjkwNHR/R2QZ8nXdJMSq3hfoxO/4whPB8zsJ68Fb2ouj+7IVTlw7Yl1ux85u44UmTL67UOxSvGPEFN+18weKnR5b2UKu+WLywXcBsZPlg7P7TSUJsilQieKdidx6a0u76LOBtShOBuB1OQeqreeBtHHYDxWis1WRnGtHs50oOebOkgLAUAhJFfuEOddJXJWCZIDFmKGSENNWokZ+TthCb55iM4y1sFygt0HakBHZmW720/HjSanQONBufnxWvCJpq2H5bBGM+eNf7eneyCZHZ+BO0tAtGdJhGDa5frLlV5FredcNARZg8uicJSXddsz2aw63kbhEj2oW9/EPMrn0KqeTPPBnPnFEptxyuCgKSDrU+H4MmYHjY9Y3CEw9MrY70IfW/2OgF/JyCRppsz2XtNOicdRODgCiJDMBgvzbyLIux8gnKAsy6dESdSahOV52RAF5LhOLbfH8MaYkaSGc522HgIh3+16pXdDkQIpCLF4RN6xTpEbbLjoLOqAsFbu/IfnevC4z2jZdyReW3+TCP01tW34oAwUhfzT91MX+Ilyy2jq7lM9AWUQPfdTGVjr3z5FeDMoaOH2mDnpyD4yS9R00eLPd+6lcqL5g3MvJ78uymZMvPbHUSTLZ2wmVCVQQP5yU3A8lYhBnzjV9FmEHn3laoOGE+ywCdNidJ7+ppDOx//8GBN0htI1bKicfjrnKoJaDAcJioHayvcnLntpiO3h9BgORlOeTd6URKmCQ8LWc0LMLJVZCGSN9VrMqFAmEBVtCo5Wo2R4S5EDuku04zhJHV/UNoI9s4u3grCqVZg64nr9azfEH+15piQDooz2bOzZyFigOjWT2tgK03AGV2TheiD3s2YKsmPiaKbQpxFnZLasJIaaXQlIjWz4BfvoSdWBujDyF2yC+XhXHmodQh6QKKriIz4jepmKE9bGvzzCpmnFM5H8wEisv1ZnvYlBLyMHEq+J7r2sBb8F8EDrbvlVLu84Oxwuc1LQZEk83bDWDhm/hgM82/te+pIsC7/CiLnTVG37a2rDihN8DehGjm4mwh6PhuFrYk/79R8UlLwtSjcBqFU44GC1JzoGorHDl7WUVPPnok/+RU4QxPsyAeqsOnxCWTeBS8+bNdTbXPzpcpRe04NaAlei3ocRr4kpFdO0fW63ZR0YXdv0/sEwr2kEaMltVI+UTGlAUXPSJihMgEFyi5g1+uxXsnv6sT7/mNEYG1QkJaGOVeJ14TNzFaZnxuDh5rDpNSDOhQxzAi2wDPBLBSbrMw0MN0QL9szbnkaYz+2RVZEybBUWMtRNBDiGbSCXZr+Ds2UqknmNAOtHd0BHZALUL2uxGAU9p1M+Cv50dL90wS68bh21liOz76rPEIRxtlpizmoSRGaEltDnRWpj+1KgR1BORKyRwoDsv4KXSIDjWFNW2dMBKhZ6A9fqFKWsl1NwjT7Jo/yGltRAD1oVGMdP4kKGdYx3iK/c1JASbLO96s4o7xS4NhCHbPGRR6xwo8jsKZM8cZWMgA8wH5Tn4PebsfM/+9EzpvTPD6L9OrJGEaLzTUhjE6zgt5W+xVgDYTYBtFtZktXQQLSDV9Jjjk0In2EgnclzPV29ZHayPNWtd0OpTjHWU16e7rYXDzisT3frZf4kCi2vOBbVfq39S4Zz0w/A4vp2PsFIYELaLpYcfM+DH2QUfCG+WI5OmZb/+5OiHwFAyazLWWHuaSTOLipOVMirSNSS1zq6gCC5IF8TPyqeHQzhOElG2N8S4SBwVkjcpyzEPDToIGFmUdqwk6qhCX7h3O1w3EQZa0hJJqv5C5VqGUBW3pI74Dapb+NO7hJUCOrV2XtisuB90MnszbXM4DvsAqfapbXhbZyMlPLNxgoaPh7kNqVuZEyWfrUx+QdZNmUXGiahODnMMpJY1SHR7O6BWFkh7OBN5JDqSsDZmGLeWc8odAayF1aKf7pXnADUiHfB/p3b/raOIH+SuVltlOBCshjYCPVzxRf/vkc/yWi+O1DdAGVUW39GRE0cB4fQRSTzA+7VKcPOMe7zkogTuK3nzZ2V5VSpN/x1SMxRun0qWO5KnTAv6XOIxHElsthPuFKYX5fcAIkw26KL5j1TYXzW4Q8K/JezvU3WbOr8VLZfEKJjPBF1YK4xiFPVIhFHK1kIYjOxnFIOjt7zbZD1xYUgPasqRb6CTnw8tXFPInw2I3xSazIJHCJbvhA76h5GYY8/0ZP8Sz3G57om6Pwdh8rcJXf5LYlGyxlMjB13Jsa20jx/WHGT/gudVW6KwHJRT1IrnD8yrtg4dEaepcO9ecEbWDVXl9MTiZpBj5eRq6vnwiFMuHRqH/kbrg/bPwndsO4wCPqguponS0lwcaBjDf9qlZCcW6Y9PX+eoqUPeEicuOYWiSV7MlLq4OnhCntB/WmEVoDivEyXErrPgHaHZpwTy1dCl0J1M7fvuxQOzQtJ1xUWGHj4LQYDOaTpoOGg7WsnOVZJ1G2WWP+43Bz3XcQGSGDp/+TqA489GXTN9hWqF8FR+NpxC5wHDHruJr4C2wVYHrPU5Ff7QqeWZBU3EBPHCUl0+hYclM3LeYR39qX6PLeni8hquvIGCtg6Ys8el76xlx5WI/Cl7k5Xxur1ew0g3LpAoTpMtJkh7JvVUh5X346WsUYwx5cF6WezkjoRMTFxhrmhlaISOqa1pfArwCfT7YkfHiSiwfGXtC3N6DWcFgfyTZTW8OQhrchkICBGsxK/ILCpsv+y7KzrPssbWgvmFyBL7IR27lwa0ZB8dPrfVm5ysftV2xWVTyWJo8ftz8RhScDe3iVgU6dRYmuxq81KVMYLf95jJYAGj5j6DcGgW8YIqXfndmBuCF1/REy810Sn9j26LaS1l047xxlCuMrXostqfIIgPCi3RgfefClrSehwpc3f680X24/ZbR6tO2HQf/no0tv2o5OCMzIluOaIZlnu/D/xn/H7Jf8s23VvWedadATvKKpRE1YHPfKSDX6X8PeX6veQxA414KZCOqylUTkrs9aCiabYTGpRWiDlWzvHIpWG8nl5jscPW1ngw2oLObEFXkQvlihmj9U/BOdb0QXNcFpX/lVKUlcyLL0zgZ8sUicR3A+/gNNdupUTXVQSFLJeUYPiBfbd8c1IS1cSb+7mHvyg28iGHESfVeNNJCI55FKziRBacpi2bQVSSGTmV2r20FmPU9NJzCqlDNczDomk5HAWaK6aHqGdfxvUQPalJCi0nTI2+GbZ+YD10Tb0t2KO49bGDmDJDbIs3maqCUzi4+bqOrToqtg1WgsN/DQ9HWTWq6iq+YrqwrJ0kelP8QMkyPIiozaWUZ6+RYoPhqfphZb+NpqMIW4AKLg85qV9KRlwodepEcVsKtg12P4qAN2rZL69UqTh7PLC2AD+P1cwvlZTshFY5MtoH88jj9X/Lrzbm9oJOyr5amAkr2jVIUDlwoCKS9o8j0ciL/YyXD2vntVZFOuvyg051xy2v0+sS3UZn190HIlIyeBStFmqguQt4AwiOS/6aF0u3ukvSvFXaO6MiymvLkR57tn7sCAAzNW2h3eMi5nOnX+yjKJby2aPS/lG2ckKzwq/XYKgWDpfV14xe0I1mvJ3LijRo2X0sVEucoFC0OWu1es89DRO7fw7DtJ9WSmKrn1ra+JpWxYm1Cu67JxNrZ8zFDw8mTv9FChkS+rccg/B64Kk7z3yIssLng/Pft4r64+vnwG1g+v9KVDG62SiBrzNKBJf7rPcUh5RUEviIqtJ5OlntGO869XxFnfRLqyfgHkhGXzqzQigzApg8LS9P4hfaF80EAg6Qq8Kjm+ybFtHYfNC94ndPSDz6uIzO7t5+Prbp03nWjUPfFtCSJlKdWHM9PR6W58VrdFLMNI0irAhrXj+1x80TUYFWpje568EcnhQvpWUSvZ+AXDI2Zpzta15bmqCrk8W1V9Z3CRQOAG+/B3XiLt7Paga4WC/0BAWtqpMDBJeZ0mhpdlXBTjYmC+G8sILOu5dcbb1SXCweGe5k7nKr1jK78R+jK/O9GWO8kfuzySzMJJYMHz+v5XIU/HJ61YVCM/8dJbBNdlNOJCkjCOA8S7sgQOw3Ni1Tfo/JbxQhC5nzBGyCKMEMxufM4GZ0mne4kfszYTmp34vhavlCT65k2dY30uaAtgyvTAXVCnQO/38IgVAtJdD6W7XSN4xyJOuEVwL8xnXuPElw4CBrWhSi2Nx14X1JNmRz+PmWfYT1fT9xuiF1/MnkkaFItY0pMWLJ2P2BUcoTkOcrVOqr7kfpXj3T8dT6vaN4w+JooxyFiTs0bbl4ZpxT7EtmHS0od99P+CnfX1xdwx/AILy+qBJPzKciKmoxE2Gox1aHaYQIBBTGdAMdA8OprvHtbSJ8aIbCBUFsEjIOG15gGJSRQEssMhjCEGxOhnrHfAD4P/nB+MMQflQ4yxa8x+2SHGtZvMQUU/4+ZDZr98iIl1bqsytRmNbZaudAL52oz78OkvVhIqV1XmqaoUivGqmgf+ecqqSgXwQz5JqRinqnlIUVFVRRp0AuNPx6dkBFFDxn8MP+pyFUSFM9rF29avv6xKIg8vNQWfbVgIDtzrwDbaalLxeP/o3WfZcPmR3K7A5GAt3Y5FS2fv82uLSHnnRFPh1/UP/bR7yq+Nl8pxhIz9xuIz2HMPF0+zTPSEfbwdNJVQ/kyey21rE2dUJnSWSohIEb35+5qYeNyJg01auFfaSJd88kyadVHaSJPM7a2ooKNmKVchykJeSWllgtEsd6Be0mRyGxE1X11vXTNq1sDm0XujHx2pzNbnNl3bYF1jdFurATCXLytZtGyBBZ2wbPCgfk1mVIXeAsbNPn9QvWNWgFSWJbBAsLMx78v8y926lVX2w5n+E8f3gNF1fz277XoRcZbDKKgainyf1dngEcT8ph18S2h9OfAr6XgMELYe0K/NiIrqTWk9CM49zI3WnCzKVOs/qb46/vBB4OMjzdnuuZV31xufRMHkl89zW8HY1kyOeI0QE121aMM8fxiJ42LzJx56uP//Ks1Lv7KdiNfE3Sl1TQBTuuj2tPPPZ1eH8aLA8Ktq9wJfYQpeY1QbUcXoUnwxxlzZOBwQIRfdm66RbLn9c//8VOTPY+5FndBN01y4kdLebYMTI1GBP80+o2cda293pdUdfFWfucd53YbEqtXotCPP57oCkHNo8MHu448Frmn+kmjaXOmGd/7Ew32TlKuWRA74tNp8dp1onOxwwGaZ8/FY+SzKrOay+WkT0qG98XSANg0ACUFBXyKCYS1D6JF+4SWxaTSAOG1rMHqu/Huxd8LR8Fe7C+pO6aWJeVuOx8dFXMOV+sg2tRkLO08hsm2VtonJmxwD51gkPeUPavTV3fyUv8K4hgGEJtG+4emReK80V6dP+oSps6/x3SKur44JslcXDVvwm3oGgKhVpTCaFAkEszFRXJRcJf0i6sk5oYZEd6CTFEU074Ol7UjJSa9WipgCFbrm+0dFTJ8eHmmdk+EU2eMFS113he9ylcLxIv49BMJt7fW4SQ0mRLeL5BG0clGUb6aPT+bkCWbjZKLjb8DTahhtoPcaNk+Fi8S18AZaLt0SuFZcoxbxO0kEbmpoWljkUSZqHSFi4voOTblUh6ZsvTx+aYSK3Xk7Z0HNwTX0HMrW+tUxgcHrkETXtMpdwaajTIRu3bg5q3NoUUEePFSOIBfXQ+nBfVZwqZi56vCTRRnb7DuJ/bL8Yt/L4RwFim2YwM59irouaA7kh6Omr8J2Y48gt1vcK4HASnqkUrt/bvfmzSUMgLP1aWulsVSvLzVWUgjmGy/VVxopisch+iSS4i5w5FLVv7nEzKxN7w+XtadOl6AZnkhvu/yQoxD/6GiBqM6eGU5ij3H59y4vLn61lcoeYEoUlihXtXuETK5XIkDIgyJHSeqUDehXg/aO127p7pkTb24fLw6fSXd/R89kPHBHzORFM/sUfUwNl+TygjXqOhaL3OUNoORP9Pqs2/9+3Krg9/uFn3Z89e6T+6fZhyf+MKKvNvct6tggQxZhG8y8SOJanpkQOduN//NSwKX/Av47mnX0J7goCp+LIowx7xE0p8O5CsflTew3rPKNTj3OGwWsS3NJmDL17+IJhDfMt4SZ9R5z7Ih6L+Et8w1hL/6itRxeSG+nLyBcoNs2bLDTh70qIkz0kKDQHL+kz3mdju4V+h3TuHqZj3fGwRdP+TLSzqfTkpP7nJKdt33T8eflvbB7JfgmeNlf5M/jixu5Ju4s4JvdwMbQvPkrhz+n2pPluwpbh7YBcKivtXAXchoSsYc1zEQyR5gIc91kW4VXBY4P8ilTpyDMWrmGWYg9iOl/3uPCXkzgGUdUA0ql1GVb4rZkWK6Tj46xKPv/1q92v/Io9AhrZpz2R5fvvKQdceH8m9giE2khsUmQnCVmRcdR8JWYBzmSZIYThE2lMvNKFjyDibvfYd6nx8yg4HJ9GWkY22K56mDiQauTS4M6AR7MHyXEamsonJTQK4/cV+v/3k9hHXPHxAWx1LEMLzSt2cMPRcWmMlBQHaNdiKSvoENTcTxiE2mh3ThOlHcBWRfvtB61VhhKdbpSQwV5sjq8cl2FgayoUGvwlj/+9XHuwuDDaxv5mDaP+twpXO/nyFQGpsujISeHmbwW0+C4y1GfO93Rb9WflnQGpZ3F1Mo2mSk9VPPe4pBhkHvAuSGngB0SvnpizP85o1t9zv9u9YhE+EmVa2fh1p+MpBHlmSzHT8mSqoAHL4qlA+fZOm6UhypbMuWkV8o4z5Q7UfBuasZkau2GgecUX5eZRTNddDECr/cZob6ND2nLQYnBvSmzbJ9hoqCSlZIMVa1Cq8axr9osqNCLaC7XNdu1f+o+1/RBuikwxT/564LnxrwNWdZTWbMnbWi0J0dGRkfTI3LHzQsWIgsCoyRTJAB1ado0O2uMad/YW0NEIwACKRdv3GBnKkqYOu3iEn6sMzZOhP8ZeRT4Xrv8mv/6CP8V/ygPAh8V04+89k1mDiuBYjbzkPKQCmZSGERBvqAqv9uTA7u6ursCFyHSHbiiC2oQaLykhtZpCeWLCikIx5bn5XKpBR/RGGQhxcFLvekYwZPE0CK4x58eP5a9/sH68xe+I2FAunnr4PJY98EDDOv69VYG2Cywfn7ytC8yKjKyb2wGlwkHDmo+uRw8AHybKJipAZ6GdMUAyT6UfSRS5+tKtIxDh4eWHZ3vZ5w/i4nUXV/nwP737HkjZqUpQVnsYk5vssqSVBnZ6NVtOxazb6yHxtMM8VmHvCqT3ZM0qgzXbPQMTL3neHV+itrqez9BbXOVp7tmoStOaFziSv5Q4Ce2F/5JvbaH5z9hMiEcvB8g/rsWYFIjmUqh/l4SZXBOf4sSM0RJv9bsb3OkO7SvWVM4TT9tdKtuayGFarx5s3VygyY3953LPde3H361GwJVyLbjiA324jj8zs2tfQl8lq7vXcfBVzk2O1bhOet6KQbKOIqRcg5aGEcxoK0K4gMXzmTOOdw35TnO2dPlAaY8Gj+Mh8DJ8QCunDE5orqavqRsDg2DxmnWGc4MB2GAk8Q6UpAsOjNWuwJHQmDR2NU8+Vd7nAJqLBln2Ov+xQGDRkBoQM6bsjFBg8NjDcCwcZSMhKTon0oscLj+J4pOTy4RYeAqmk4fv7FPTEdlo+jiPjoWhGpmTyDnutXfP1hJnUKZTHlU5uA9t4Zc8mM+JZJ3Fy+IiBUpHM3diGK4iJpBK4JdvrnARbR00XJhn4MZLR6f5oy/yyNHur0q+VBAHE8cR4Tph4tMBGMy44O0MEl0MfSiAYabPZx5AG0Q1IsB4FadcZzdp5ZAxdfdxG8M0LNwW3GsfM5G/BIA/tXuZ2xl9N8u1caHDjgP1LkiNfO6o7u7o4Kjg/+NWhm9ElzNdrKF2IJrAmr/oaY4FTql0D6Y/WnKy2mnT9drqkVkggVzKLtSuyIw5jDclusimCE0FykldDGpnCQRGbQiEg+fLI6i+xHQJChZhET4BdubHFIfG9FfDk6vYsT7EG8gFrPep4KvSL1X1lcvJ5R/oJMYBDU2EKnx0qNQudaq8AwYqTurtuqUbNCvdJQJBz6yWti7J8BCfD7afykP7x2zFa0WP0CweVtxtS9vBkSTeCgmAzjnP5lTYSzV6bM6HZKhUj9lir7SQMr8/kK9boqxkmQswOhfW8WoWlNivTLPPbl93JZKQr5dDiwhOdCAxs8XJGeGZIZanaZftSYH4ImqmtvLqhlVJ1uOb6kMY7C2SDRqOG8a1Y8mwHNlbdJUzyXTxEOWPolIeaXwHs23oZugOFTTXqColvO29XDJnmTxySaYlOLtFsPhkSGrGOG5+Hng8z2dsl2Y7nC9Ku3G8fL3uqvujx6OQ242nZ/k+K+LDzuQJECai9Cv1DkJV//CtF+gQ6FVtQkrWuD3enSqTlsIy5GbDIiyJsVyS6Cv2hKMDkddJsqOYDBvJTJr7gkTGvgFumkgARCRtXQM8NpAnTv3Gm/uVl4rb2sPz+un78CgE8NDgd4PpmLu/Gu8nm0G1DYj4Nor9UnnpHEZ3IgMziTG/bkMnp8EnzyNDB6dEHFvknzBzH3Pn0Dn+Wdw5vJBC/yaw6K1MXfePxJLc8ei4is3NklhSZ46OuN6dTTrp4GJiMVb2HZIR/f8jOrOu+jpk8GO4NG5EelcN1wiQOnvzMVSMi2qJYvr75PBCecx8JH3JyosOZoUZsf9IzE0Nw0xgsvwrOSJ8t9UtO1PRsqfTNtaZoqvrwRZhzxs37nB1ZdpU+xlqs+NLZxtavt4dMmG9Y7f/L1mQ/eQ4V4h4foq9D0oPIG2s2tey9wuMwd7NjO8q7KrvXf5VOPh8PEejaenxtENx58ppj0HftZLCGYfM4vRrxhiuPe6MQcVfcxMZh/d6skaZnoxh1meTH5Qn0HdYxZkJnEbA2s4ZDI0YybWiEkBGtzGxBleAS9f3n35B1TiZoLvyhB7UJB9KoEap4ppQbnSXa7hJW7I6e9MgZJO6d7f/LLh568Pffxo6Wc8vPe7hzkJPm48fWImSv88+zE84eOCyLD7HAT7Pit0/sd0+PG4J4A5K4ceLOJim9IkzTkRQqDFGCcG9rqpd8Rvw2inuZCF3MkOxVrSvTVKa5wqWeOTtuZx239dkRavNrc7wjkcJliW0DCbmeVhEHZf/z9ssXsKb+nAAKoUSN/9WNJDmqt93HuWMiGwjpe84bN4Lnmu+PMGfHIdohq9qBdTi6FAN2+2sxK9LLFHnRDJCmHNzu2mKoPus3VEqHdJsxhB6o5Ifa8kixkIFhQ494cd1PULoW5HWq2olZGrEwOhRYnQdjnig4HMFG2SyQUqllbG3drNAapgsmXxyPIiotpQusCsHeRZmK7repnckYwWl+nzO5b7zbpA94VEOujhgEj9MaV3A+Nq/tJ6Bi0SgeAEoZFX/CtyMQf/F0FrqpJUbFxtqvNKnce1n/vwiDCtXj6CfUF6L1QzGBtBkGRVni4Lmf2M7MhTAI/94JdOqvq95wlwonNJD2OQmevjHgMKKDNd2b/df7vBCQaDxfGqzhLPeufx+6Aa7HkymTnIGPNjoT0S0w/lx2FgO/G7QRKMs5bOBPqFTXtJwp424FWHK8qV0e/xT0zXHWcYZza7MoaOd4A5pf+nrrrv4wiH1cy5s9/Jy0uwZPJro/uj0JLZp8qjKeNjGNn3cc0IdxA1GZ/zVSal0pRIoMZEMU/R8jpyaZBTVlAOyUbKWSpLyXWqPtVJ6BHxGgfkpgqjsbzNWHHgVpGqoMq/NjFNrqdqBd4Ck8BYfCh4sWVuS891immcW1rmPnCJ3gaHpZP+G8ahu4JBaL4DCw2vMR+CExLOOedQfK8hm8oLmF1YZ9TPtIxMiX+IzHlZc4LuJkG3ZFWYNb2FQWi5KYZRDMjkthgzsbDJIPNxZ7KqLGCye9KB6PorqM1eC4u84/LbSb7hu81ap8wnz50L/GKhKaEpp3+qqpMz5kWJy1TJQLPhf7D4MkvrGD20jhabtJX0dcw+P+oHKtyH+JX8Rv7/ipVYGhcu4xTJpQHZtZIb1+/cWbmqpqa9DSBqR+sn6Bq0Grt+2l8EAjfYh//7RRtxTZjtFRTx+LEC7xkC+Yp4NvwkeWa7j3B/V1S8cQdCUBgxOQRECE9w7wkVOFsXl45r+AfllTeImvz7r5TfIDO7KCxlMtKyr6/U4Z5wuq2i8+VfG81WMxWEJO0BIrB0oQMkwWrwzj5gLiqUnn9DEzgCq7zAKci+ggj8zHiHeFGkmrbvbQX691ULF0T3A0DNAVRUdzl2gMroic7S8t1iivgChYnSAlj8QFkxEyOKUZMPsGkMdu4L7XNGJGDC+zKdgDo0/dLxn9qLvrfzjwTNsighOILnua1X5oFLvuAHExriSSVRZAbvFE/KiEYxeBjCKyIjkT3uyGfhYsZtGKVv25OiU19d7zz5gWhZvk2fiYddWfOEBk1Z4qsNcHLvRgZi4C9pcwN5uvv8k2v625EwDZm7ju00oE/7YMUWMZJJxKBgIRLkYtNROpQzxgeCEtDI2MRZu/pQS3ZhyEgtEiOp2bD60S0U5gAKi5KV7eMX6Sp2pRPx7T9QJlKIXJf+wbyYxi/S1uvqtU1P4GSShVyHumo5W4qfhW8Mb/Twy5espcqfSsKpD+SSqjkqK2gytUz6aSH5nv6eAZBkb1ArtdA+ujnexlp95PPESKzFldczneqgreBsvs/DT4DP6MrTPht94zrK4DRyLVuf+FyxrgzFbcMisNtwoSutV6Y7Bb9X4J4YAZek/I7V40yOz/W8ODKi58E2DBTFqNHLI5LQGqRRKMa3MHxja74en6+b+AxBR2K6sUjsSoxmXABCiPDRWSu/tsa2fGU1kND51yeFXu73uWpdFYbtcwUAYIMBjV9AVWOBQ/G3LuJMBAEjKi1A9OCAsVFYqRFKCPfVWWe0BvQt94RMlgHgerBhU4L3SkKCrTMC/OyFSHQUZtuDHqxmfM31+pBa90Xazi9MhtR6IjoRQlgTuupfBxEtzhYj5uGO7j3BoiMZtbqWe3koo7Dmq6y4movj8vnAFGitMnZPV1U2dHZYP93clWakzIH2KVfeNT/5ZvsUPxGXK9YoKn7yG0eVq+Rq3NRaFHqoc1wpgd62zR7L8fG/HQKtUSBSxO/vFf69IV2ZG05bUpWn/i2NuMQxhhJzVKpcJX59tW9BZcsZCu3gpESTOhLQ+xwVzHpSKGtP3q2gzZ42eagsbDY0BwAAoWmIGw3RiLiYW8GEFbYAz19aDFkjO+07YcxUWLOagOI8lhcKpIm4ZiHdBPCyyYhSQytCz31jGoZKpGt/032L5XTqnLUr1VcsoGr+7pRpDKFWO6mQdIhApYZaTSJB6nZMZgEHo87SK1IKyXZiqBU4nteQpqUgIGmg8lGyFntmbzmSQvo3vvnPHEL6eAHMihmfM+HUDVAgmvXX/hlQDXfmWbZZgA4UaO1d2DBff+sGE7T6VchOLHWDOdUXfEVriyyqfZeBij23ZW9vcra8Nbn996L9EVEBEaG2TU7dka4EFTx93BTEfp+aYuGpT7K1XJWTpeXll6jpCjZbxpdDLapAW8YWJU3Ftka07IquxSXq/BGx844dAW+arpqc3zqXuEKWdzHKDXESiIYlj4Yq3yU2ZWJaaM6M8HVzn1TbWhtJ5RnTG5tEbVoX7HQQO8RQJhCiZq3R6PLld9mPhtbkvjeDMwsnM7/dFLZgokEYhA2oPd69tad/fPdbEhsO+T2b1rrcxEjTVHXK37u0oeP1APvX+dovLxXcSckT4rFZLVc+Epj/Gv7tRFLTGkfgZMglq+Pl+yWIv3Tzw0Dgpw1DA9Q+6oDEPZ5BITi4ceV3F7imp7MzA+A8/rlTg0q4xKQzokGg01VBXGd88C6n33mfHtBgTOIUKPldykHDnEePRgJ1JzTSad1S9okUNfh4ZhvhWQd3J+GPdOQllPvJGMZNXSI0I91IMwlN37nhiRLQQppH+TCZkS5kGakMCZyNy4VCjpGlVleSdezFMpU3+x1H+7sKuVtVtO7vQqPIAeYzXjLHq0j7OAm0bJiASVaaWAw3p7TISq6gKUoZowuLCHUZnp/6WKUyMaEA8EO4+lutV+KDSue7nge8XCk3N38FEu419XL//1BrkFtFdF+uCh7mDXNe8F7sZorON5z/NH6+1rvn3UHGu65luvUA4301SG/2HnDw/Wat24Avx3KAqqOQmnUuO3AnY8/hv4Izh8PlGs4AxVvgTeEIYwQnNkDROoEW0ZytucD7NI3CcGDw6Q70aWQKg7e8jkf/OsAjqfeyL/C7mNsWWw6ewUyIWZZZI7YY3MnpY2sIrgld1FKDbXtk1ZURXNqD8R8jQZTERJP3zkEIy8Mi56JLeGlSfirOzOeGU21SWg7KPt6ftm8Zg00TNRWRaV1NZewHWcEoAfWWO5vtNd07/4t3Xtgv+pTQRtmNY3uiXUOnlBTO78IMXeD6y4R/RQj+G5wHYerTqAgHXmA2g7qVR9TtjNfL9jbk7aIOJsd1YBwQOppZSyv1mZQ4ySfg+Qlfjg14GeQzvQgnb8NXRo8jE5ozgkiQrmj7jzGvIz/mPVvq99eLOL+JzbKTXbkN4ZuW++EPoKtR82b9y8mntwflC/jZmz5MWpiIQPxcbNaSNNcRK+1ywhVMLbEVE75aUvKeuw/aYNEVXUdsQwNvq1MtXWDnC4VfxunHfZE+3y6g19K76WfhPngD9eCdQ3TlzuNQ2RVoKv1x9e4Srz1eJXvmq5R34RphDXyXNkdUTdt9F64WSfAfmsAgsNYiLpwwoxZPrEaboWoCsRZpI1fl+ihCtPJp1ZCZ8gFPrECboL+eyq9l8K9Fj9M5+IxndzHO0Lc5uhjOFbnze3IqsBTWtep5e6iW3Hlef/+KaoZkt6yXTUgjAWNLb501NTPTRsSl9dmZKbm3AygdktxMxjiOCY9JSZ8zqy4za3G7rjrDNkLOtDPsfVhbWoBv1vQ+DLCq0fD2Po0/xxRjMFzdeDOuhuERxRgYU4zm5g1+ICAGtYiGFaCtGACy+LwVbiBlTejdPYPbokvavR1XDHiXLyKYdOxNewZ/JjpXylqXyICPPqmabHJoAkvsnu9SggtmokkrtrrOXUkjdQKH4l1exfjU8El91+HSBJpqrAtWlp1fMnmFZ5FnL3mTtTX7RTwz+pRg5TxUss6dBYScK27HJ0VqtFiAMZ296E3SGk07InIBew62EKjj4zOlRpOWDEZFfNBl/zhloZXi36fl+B89HXelyMqKjU4KFXvpreNfg8v1VeCv/xRaCm0p9FNgXkYACs1OgekmTM4szq/mz3SmCNoFE1MncVoUQbdg0iQHk8MPx7km08Hk+MM6ojcgMyxz/rFyyBuVB2mhcpQRykOZDpUPKL/aiEoo1lWgTIIfVaEKdXmIfF+onPb+AN5uXDdo3ete4YjL9AaUaW85j1G29CWnvT+At4soBPzRIe7AmfAdpkaeidsIPHPauw02MPqZ7T0Hkrdx2onowp8vqYVXFqzku5xnDo4a/VsaAPAQONAg/fweY97LIBcHcDd20odqpw7V1Q5L21D2iIg39kUxwGguLU3Wg48W2e9FRAQ5MoZq64am1g7JapOn37iekXH9BtCebFwpAZK3mzdFiI9iP0vA32YEIsMJACRU04lCAARNF4ikh/H1MAKBPKQwNPKhEeVBIzASZRgqaEMCBFWLhOZghOmnRyHFoaJAHwqyA79A5ydxziud4544fxZ1gsb3sMfYG6dNT97gzzD9rAQAg8DinL7FhEAiF9D1SOSBrUjf5AJ0fcNTBABGvuWVWIxGVQ1rznYhkQgKHu8ZwupVDbAXUH1dFrZzez+uiced7q804zWaBpkOvAnXARRNqWOKkaubOemknwHosdoRxXAtgvAh/JNCe2bCO9x2nD+dMTSEYjAyo6lzcdPHGP1A37SnZ9d6CrchrnC/XfjM9qcpt6nsyB+MQQYaMYRiSncuo59x7v2oYriy8n94qn7G2fLyK4pRL7RHjh+r7YUQNAAHCNaGj6cleoTenMcULXU/RUvhbVD2U7Ve+1ZXrB6IRUlcd0lzupVYAtWBJIqWr6WQOMRyQd9yypti7+at5Q2wakWakyPjoYhh8bL9SoXRzPSZmDoya793WHzJifscE/3acLs4LpfhfpIdI84p3TvJKybG8LZo/IVjorjNcaIbwLvSbja/FX6Ua1pbw3ccBdpJtoD8fwdBpY5Vzu/8BCaCfWLqILKQW+rK80Pw3+P3H7mzTzwO94GEc7fpzg4z3wVeg+OkggoPrkxE1a/BqiCnxEUIgP+7Eo008bfcWXL3oWj/nR37EqKMTVXfRjvGQFMGUXFO9jyLAe7C2vxY5JKfk7nTise6fUfPOroae3fJues7OiGrcdw0erXNr0PRKJPjW+ea7j6Ez5z9c58u0tBYecmpa8ClB++LFeiKQYVflCXjhnf+cyYV24ZFYtux+fw0ZOGulKx7OZqloiuzCgCy8KMFYaHlz0FwlhhSgh8JsV1Gim6sA8nZEQWhlSr9Fu5zouIKYCC0yTSXg9rS5StTxOm1ASCAwHrHksAlzrg0JVUaHeMT18SycBLmE/R/N19fcimTlQ9bwCLHLmjJt4F/3EmPekNmOT5ZuJU1lfshB5HCIp3/+Y7XkCbgxnqFe0cbPCO94/AwIzMx8LVPtKhKXn8ahC6RMwflsTO35hgCSDw3MvoVfYxrGZleIwrHGGT4CxEJEP+/hsYP17WKFiCRurJm0ZKOzZvtBWVly5bgC9jRF+93/x4Bp79/8jKbtl4jooQ0cVkpkDqUNoFp3jjGCm6GL3cV3oiVP9hSUSdLuqq3os6Rn8BIJP1uge0CBpMY5CXGfBSOivQffmL3wv6eOv8cTNwk7rWv8Wo1HThtnRMnsUL/SehqHROvm+punlheSLV7L09qTsvgdNk+q+mQ+CYLyRCJ1AgxZ2DEbRVvxTqGZYY0tkeMCRWJQii/n8NgsZNwYhyT9JuuWEd6SNJhvREe4puMjNBXr6C599zy45CNe1M8+pZXpaYCAEElfNhq8DPMajZi3bBGDrmdhMLCCtueFmY6A4tl4EQ4crWDI5qEG8zJZeNnsbBY1CqmiHFaw3Y+cYMjotDfAxE8HMBFeNIoHwnK9R0s3o6cuprih2w8RuuhozVoKk7ERQUkKi7ueNtPQWvRNrwIQ8aI8BdckWgC2uEC8y6Bw8HfZV7goQng+z5/2I+Q74f4YeV7Q2iD5krdZ8LX+JXLjQ50LVmGJe0a9aHp1J31WEhoqs/u6jY9MZZmX19u+uAPAq+slWBqIVKKxqI2RStilanG5/oN0tOz5swdj4PNYdikXp8kvAWqxbijumRzhNwrSIQGY8GHl2/VYuuIY8RgeDIL7lxluNPaCCcaTl2As2hUqgGrfQtHMavRGirViTokNpHrMEgEwpJUbvZGY/cNSdEomj2ZeVgi1ozuXerRKuLM+cd5KJTJ1BxGIMS2cgTNMQKTa7UWRYIG31Euzz72M+DngMDfTcxrWH9of/QvNjVjSkeCKkmVZbwBL7x99s98ivEtW+e0NDCVaBZSKrP75U7fuuJCZtRUcH5zgrnvOF4m7jLKXpx33GDFva89woxQMLoZTswuVBSVqkFXM+Got96YhsNbU6CGkF43rw13qjxHUXXmW8vD8RaMBoG8whXOkXWh3MOyZILFJ2mpFRsKW7Cl05aXnZb26p8bU2OV0Qq1SWMhpSx6SqhU1P+r89g+h/6lPj/alYbC+HFAKH16wWOfgULawyHvl/s9DL3nnYzNtwzN+UkGzlUX4ZM4XdwTIXer7tiVPp2etdvlXWSS2sHmIbosFYhOauI2alyMSi7ZuDboMWkC7iz7ZsNLb7/5LYnS8+4QTkrd6zneR7x6zqkjx7ktJ33cT361Bha6BdgRzRxv013stBPLL9JqxU/9C3ZKhZMPlp4tPESNFiNoAGsTw+OnVj5ru5I6PPVL3TY0ZUw2JHtTT4tjsgsC1UC/4cYIgKqhX50HenEhMqhrrJIkr3ojk4mSat7jZep9YevBoX2uUIHsI496Uyd+Vf+mwQXm/IY17pRjQ0MmtHdddsgv6tv4SmjcUHw9fBuM17fC2zYWWQnKF5cnL+PMvjK5ERc/k44uxE/K/lxDJKaNtCimkXB9tEF4kNY36F+f4uabFG4ExW0FjrCRh4mSN+xVxnc6To1T+0tFBM0Hkhfk/HcDyguJErXMEkN1I7k5ICc74FnS9azwhAQu0oCUophIrkFbRdMh1iEgWhUL06ionAGlETZKteF0SPiDpoPDdRgeQkPT0iQInt5YINQhFsOQsJqJ6VhgrabUwfQOt1gOAk0XJ9ShUHoRPZIuMhiZkHADCgmhvJh0UYsQKYXpul6iLkihHoXUCJHpdJFaBENI4QYhkoVCSZCiZSI6g07XC1EqlCU2EQVZ1ZIShtqqEbEh3TUviIX2kjE0p9UMHwk9VweFoPQJKChfxChhaJKMaRRGYQE41ac1DjHDGBUCAV92cvfwI8HPY/zHgkv/CS7N/y4JHvOP/fzz7sTKT8I5cSsWgL0ECH5cArdPLxuCa1XqAm1lxWT2l9+/VOEGG8al0SgNhwAqaSV9iP4cLsANUwlycMhPeP+yzNA2b8nB4fhx04emAwr9SPZ7WRDb4yjtAHzUiT+fV5xX8OAMvZsuW9glouht9HEZ6+n7nWd7XpcIkaVimNPKMyp0jvq6cDPR5XJSwsc77P86zewXubTWjInGv8Tvze8lv2N+J6LEv03MGrvdgrZAqjUFiBiZNO1Uaz586nTPFQOCq+5B7leDOIUSI3U9GT6tmgGVgG9t5P88ir857hRfNAuXPIdyZtxN/tGfezBF8t1Krmo/FxJMcbL9MvsybuIO+NXnce4p6TudgHg3X9Wf3GedjK31hZ/wmuFO3EsUBJ5Z1Q9ITIJ7INsCZvRPzfYxZwYzklruYyI5FhQ9JqnYZ8qJX6fsVcGK4T25jP3Yatx+tnaDoh9DwZ5h36OQaSQECSYNkQdJgIQkwUTy2/elR8FPVUm/ml3ARE+icCIdynYGYARvXP07/LixGuXSwNV6Mdn4+nB5olUIpACeJ4mtDXrDTQUKAxNUb3EeuCGSkW9KBbghHH6IbOJLBNuKeRIuqgLwiPCu6pcIhCNxIODPnwqHo4SjPwFys3UEnQI9hVLQI5Cdt2H3IlmzVcU91DQxuYOLtqG7Sc8YCIoFkxyrCFo9etduiWLn7omTpqkArf6ResU024JvFeNAoH0/FJeYi/Z0bACTf6y/T6AONdKXujaviz8UKrualCkL8uipiWhRpjSoo5XAt+QWoWIDvFEMqoi+lKg5mBX8ab6XyCnBtJiUwEKfTJkY6p0g2iTkwi9McutVJs9ngOyLW2O2XlS3MX0cGNZ5lZhVFIJpdaO0EFt6gjNlgfOT3IKA1s4sXMZzvwMAr44qd6AneZLn03kXtwLn1ovzk8KTgnA0XvMFa6bMr6OXwBZif94pP32X9fU/rIBik3LRHq5TwJRX628QKP2NQLFnct+L384buok4M28AT2DnwfOxwvUx8+F56MIzUOHF8K1o+1H10HzMMeJ59HkY+2n/PIzwF8yD639afNODIO/sfG3IhMTLBRBcnmJodrERuAX8mNU1A3hMZeQoxZNM3LR5kIpfP7uPStjZ0u2+gnWDSAAtSPE+xLHq24GvOtm4aaLnwinJb4s3fdmUO4MQ3lirdCfKRfdEOyEUVdmqUCpalWG4gHWL5U7mjW2KUMIM0v3iTZ83506Bt2Hcn9AU9C8emDZv5DclWUwOi3lZlESyCoZQnmRx35vsMpQ8ZINTTl7g4byP6pRJSN/n7PF52EWFt62cmwDRAez+qIQLajKI58hBEXszdnJ88yp7S6F906oUoG/eC0C4kGjPEf/3COqBH/Ejh8p+j2zRB5OlFtxL0YT/fgTYa/nTNxKKcpoaTBxH5lNPk6V6+WPoOdI56ay0MeDIpz5F6ZUwp0V8kGjFq5P2oQPk7YSLutB3h6j+OWftr3vsV8M+1xdoa0NgxW3WRxLNGeVnSkxI6Dx+wIuiSXcEVSgUcc/TDBtkAivtpq0WO9yYH0nnoiTH6GdtMkDSPqYBZjPuDg47b251d48pBhXDQ0PDypGhwRHFUJPWKCTv3zCHSTkWKWXvHrqWXlnFWqBo3D0mG2PQq0wpMoYYVegMuX0wJh/LyQGAYSogY7+ZQCznR+UYcLJmaofpjDq8px1iVGc85Z7sXq7+ISoGYAEmxwRU5DxT6/zDec9esdbkGrj1RVog71hR9/LlG/kb8CH7+19gAzqVAFCTUpSKj443sjfPntu8DfmgGAh336SbahDZciOgy7X52+XoXQR6OtoJpglOlIpiCAMmx9AGN2DLlpZelFE7pT1iqovz1ku1UdJCaIPWnKHkxLC8rCIO69d64nDYBeZbkeFEJUV6UmKkXpCKK1gqn0wliyQleMltPqgtM8Sqc5Ys+01Rf28LCDTSkbq2u3kPCP/67PlEUPxmnzsn/y13+vQX9ILwniakvYaESJoN+RK3utLgP0UUXeEBAH1FRDyI1MxejfuXcDGs7iGMfyL2QX99/qeWlnMDfkfDFTFRzyb+ChvB0jRHnn/FYJeaIzZGrgTf7dp1sWD/Zv1K/eRDf1xMm9ZRJGIp23DrTfx//SBIOFnR2anQWhMe+MUOW1SQu8cm9gOkHPetz/Pn9itXwq5OWXg6IX73jNOl5Iz0n45Xl75dNvmLgsm5c4AwO3Z6GbwQF3HBvH2duIk+xpAPwuAKV0RW/e29IYegarq/jzGGB4Lx+u3knAD87k7z4fkJ9l83zFrib8Q9SnK32bjuYqoddluzyD+mmCvzn4NUrJLjIm7kWrJvyyO46hy1xD3Zo0zAWuK7zz1yig0OhhgY/BLKgaHg0B5ZNDgUGBrOHfjSWeoXrOyeX6uJ+GsrmXWvcq/PLFqPrbNAILMVKaAna/Ysazz4ACs8tGqjJfhLFquPd9OCDBrQ6zuDkm/GWddVgPb3AUJwoq1nQ1PFwPCg96H+y/rLKFz8m9e1LarHnAwqtIDVfiziZQoclNVgvTkkttjhJCqZdjG/ODMJQWTaRrWVZgxKf72V50QjwQ40IvAvjouMUXNVUmVY0gxTk6WhWdOmG8ZexqxZC98iy0dzCX5s+qlM94FLEJuUciLs6V7PXXkEzsN9mR7RU78z/Yg55+UEXjuHmHfXjyJ0FVJs/8wm885Hf+VVk2vcVdTuhREylCST2pp7uiQOy/igcn/pe/g1zukJioo81QRUeYS35rRuO348OTmTelrn7LDuKE+PtHbbnNYBG6A2+/A3yoGBIHPqg8BHoUnoQ1F+6AJhTUWqxspBmGKj38u/dAdsTPxxIeavYQdV3IB3sMc4va2/lb3BjRUk0yJpqRiNLdRU3SvNYZg5WRlFRdlZHDNzgXorONspZEX0cqg89b1rp0vSIn69mQ7nx2WuMuD/xS/GAQiAeJwsFoHJcC9pHf4tLIPL40m4kmJsHC6BZpd+jIVuk58MVUS3y/tCDLXxo1Wu7tpuLhQvGT8uDV1TdmFGRmFm8X0eekZhYVZx5n3FpgYQ5cybKXDbYsAQUS56dW7OrQk/OWPxp85bc1Z/kou0wBLL48SUnJxYMXW/ARlTcihiA0tM5lVZAu32f/f/W6pAi6XD9y8hYf78t76mZwUGpPlpoLA18K6e4Hm4hkeTbqARTUOac3q99AaRxnSgs51Dre+hhEU/G9FX1ECnPbveJdrJ0lwX5X2r/G+eKvs75bU8kNiJNy8sIP2fTMuzGxeXT0VGlGWUxcaP/D5edqN4uqY6aZTFvfYC8JUBb2xjON5UprMsBIMTbmOGHBb2Yg0ofQkkGEJeYY8jk1Sstag9lSRCfnzWKQXyDS4P8SrKtPUtJb2r1lu2sNO/qlNSRIXJWpwoTsfXXxgqzm/RHqBr/XLAxFAqMm68NoaLIN8ds6FgMHp4loAkzohyfGTBVdSpG3vMcATBwdVZZR3LYncON/xljg34UzWuC6IOoNxASeTEAnZHB5ww6nZxk5Duht1OD1J82/VDlohaIi5K+kPlHErmujDBb0zWsFhqXsrR6xSTV6udLo3xScKUkPryZ4DQ+W3Bkr9Azu9pOw/ktC9tD9bvflWqCLH4hSYHVx8iFaPyCG2qN/KLgLeWOaLR9WvmDKbMzhluLZwNcJO4Z3iDUyyLWxXsJUU6EvQO8ilJanUSuPzszQXyWvkCJ1FU3F+I+7jxSdKFNcZnEDzdnGPITeZS5vx9VWzr/uH5mrV+RaGtkoyrpFWiAMul1qzXvQopO36faQoEpWbVpSWpwbEWAzRIb6OVMieRz9VKERs+++zE0JcfF4Rl5ScuTYnIEvr8ErABTAf1JRayGvu8vQ+w+GFYBmAR36UsOpAAR7omJ71mSLbfpmSCdnHcOh/yPVNTihMnLpIaAygJWbfLzcGdCcWBpz9u3MuDJDlace6sOSGGW6U46Y89IvqvMO0JxSqGClkn4sVuKLk8MU8yJ1gq2d8OUzzB1EexejGrYpjwz/RftTRefX6ZpaGKb9wdxfeP639lmpeubqtKQ1NTUY5lIK06FUVXWrgD1nRBBWWlq7qkWjlLdpenGgHJvojasD9GN+xPWaKg2e46m8MrhwTuXCJdh15byFeT/y0QDehUWXLaOh1U5ZCWNrt6OMxk7EjAdYLnx779iaLtK9tXgtc3nVC2UQqHtCDkEqMI3/pq8ZYGLE3v8VeSPoNY9Fr63dFkW0j9adlwDF8Lbf61umZ0/37ea09syeMLLampljICNZaJLakPsmUrbtlmvSG3ZIY9z/BUni49XXK71K2CLmu+TK4gDDd1/DmjLj+dFEcRku3axjKkLOy7f1f2xCRkn3fkLnKsIBCXjfWGJ58HCyNL55H7d55lFCVlHxF4Pi9kGNYNM8O7naVByjBVWMu1tUHqsC0AuHZWOlVhSnVZpm+bsCnOamXZRoMA7eB+D+B4BYcFko4kInbA/ljL8haWKJVWT0eYGE96xhJujPioxOzJdGVloE9Qebt4e/HNSoGo6fgjszN7PC+rEgsZTobo7BSAh11m/DEObMKo8IJJe+BiyEMrRBAQjZ28l6CZBigQrxfwFpG2YCsBO1FVAVIpJW5cGLdpjp+T96xdm9D85PbtfkuwfxaGG+sEPIqfvHfPRqpJ0rZy+EAGN37x3l0fVMGkidfSEDfJXXR4aiUSjDfwWznQu2nGdfNENGI7stUxom4j9JJM75JaDQJT+jVQw0JCkmwGxftmACyDw/QJBiCDLeHHFrpVDTJFYZ7OeTJ/kZsmySgHCX364xAQN5/g4q5iV457KK+M/VPxz9gr+a5iYOMWYgsClRgoF0GSK0yJFYFdRQ4DwpVYXNWfNTH8tCfH/QUwMNPxdhgi6Ft4mOAKs2dXXYr3uBmam3d5kmYCFccWR7N4UWk8HZOcYWxdXYFhfRR3Wk8RIgIg9ECAAYMDFELAf+PkJc2lS1VNagALBh/bPyUnadRJNk0SU8Oek3fuodR3Vfj2lZwetjn/qPCqTw6LrrgmyaZOUkbSHH12ZUWumwALwb8LHnIKTEsC8uWq9dMtWcvnaEdt9Lp/Wl/KUVT/Vr9MHvp7GRYr/vXpv9/JrJsuPLejYJGe8ZoFsDOv/M4HINvJ78jOrnBPMP2C0wVx0JakAWEvbp9F/U4hqSCr3Mdj5NSV1HdSSpksja0YNUzanA/ccs3+BZFcM4djdhAoCzfZyORoCmf2b06PMf33FWxh6IrB3dka041nx2VKsVYrV4QqtlvTzDDD0OtQ0vKbgAmCsDwJ0pLRC8uV/g0J/yxWJGSfFOWKOBNDOqHw0S8/28LDAize1G4ET356vjnVwhmwZs1N1n4FzAOUfr1gA3YYh21uQaB4okAQKKnRSdp+qviJGhDroneWt+vZlg0MDtgGB1lw4wHpGQPfItkiearuSY5QnVuaomBR1T+1KnJqhIpCna5QEXmfjW6Z6dwCa3aEM574uEmfPki4JFIiFilDpqJXRoGWvqiXy3dHh4yER9c9cUKjpO96biMmOwfyOhC1vKPmsvKyrPd//EQUYHZ3OARNjCa8oEZhCYsYA9hG+8KFvjSfXl9evimiKibMl8YYDRVhff7PR5zLLDNELItRMYhdaijXG54o1vrbHCuAl7ZgvPuylAZ749RUU5N2xTI28MauEvhLDLRtzg0KMd2fFkiwoC0CBxdOTlIGq1f3gWvJ3x9J8r6+Yrs7ffdsy5cneY2//qYADJ5BUrM8k88BoBQF467AJTOxar3vUsCmB9gaDVlYaKPpR48kn5mo1Tf6BIHoGrmS4280NNpwwZ4xYzAs3dQUtTj+3XcVCbpjCWUYgcO544ecR85fe+/uPeXw8BtvLgFiJhgkl2sxKeiUPu3BAMRxgHizFvINsj2vIht0kGus+OP9QzQRXR788bMK015fx62L9NZ8fCUuD1uG+GZQG68uEkzBr4bZbLGcPRsR7sPtzc3sMcorzOaVvyjus/erdjulrJ+LmoE3AInq0v96RR5g/N2Y0qle+N3Jnp5nejjwAMDPALhLesbARFDruNpwUA9fDcCjlSjdvuKVWrlc25MEG3vEmNySUpoJwATeaCPkJMBzVdZH6rFnQjX1PHDkUR4FTro/FR3kcjF0q4m+mqK2qB22XjAIAdCb5Wr8zWMtQRfzkwqDRTTsKrUYesgQrpEdO3S6VNpxQLaLcmuS/txiLrD5TMM/VDI+cz4BV9NJ01gjGgEeeXZ86JLLbevWfSX9qizb5HLXhztg9aoIOkShJDzNiu7wazD2UOm3PLl6VThDwyGOgBUCEbIIWgPdu9x0myIUCXuPHOmMr50RdfKt7u4R186uVVS+s3kuShXrck/gl5qbR3Dwci8XyiFTxIpjRZ7KjIusMhT2+3T7vpKa9oMHXwV0jL3gkqvM05D2IsBBU33sXWcpIglJ8QQhsivQRTECjp+4FCIST+hZixRVEIs/xmjkJc4jFvE4QCuIgA1+J+8a8/AwnRn/5bKagYo0u+3l6DGgUF1ZnI9t6TYZZjL5AjCAWp4o2kXsenM5Bq7pN26cKd+xR5ZO+qo4tvIbwRGBGXb7UJkcl0bOuJHy6WB7Q2NyiG8VhhpaalO2rSVLM8ifEHIIuNWgaS4rd8vR6iSbzbj+BWKZNqwF0zGFV3fb/qzutO++W9WdsfakXaX0Cw4HkpHyBbINgGrX1wrXLLy28UrKCGZvb4sJyU11u1JXcqMIRIoL5FDFEmZPvvLitYVNWcLFoGVpNAy/d89mX8hB0AuMvbZjx2z/6Pvv//yTzetd0DFoB4VNLixc/eTJVajRoA9wvLkZqBsNegw5j2o08IN793NzAQ+zTKPvRdDIjhU2Nhr0Nr1BEd7K88fhXxvLhfYfvr/Kz6mLdoHDvo+s3yWVSEJyomo6/XyR4flrn1kb8+G8s6rsH2qyY2RxSoMklX4gZLuVPnFjdhJdn1V80vYdu9iSClgIhzhoordmKMQh7FVs13lMWvHHmAp5ifPfGXEV8eU1yvpOdOeY+nvye7W7M5rc3xyuCDkw7XUGHlwiBAfgKYNjNrISBkOGMaweTIzUW4TIk0QoRMMOCFAU0+qEQep+8WQWuhD2Akxp3QaAs0QASScDh6GTxQE6S5zE5UFm2sybAY9G3bAiq5DdOAATeOI8eSRVgKMOoRmi+Wjo2Af7bTMKvFReO07GOfFinoRnaVyvPUzBZdrxPntdGuph7hNErLuo20Qh7SJEKOlF9vdroOn6eDiGge3eqVmoPl5MEdX0bOh6YFtVOpqaCjlWB6JlVYtuYHyzqvjA42B/1e/DCcnT8V+8F7/r+SPc5AQXEPcPzLiH0u9JiQjagwMgiCEYsbrIy7wEkKa868BScPYAQ3KJZgePL19lwNAX/W2s+fb1Q/JGl+5sGEce0qRBGmZYrDvPjVW6/SgODwkKCqrMl046KExysQaVPyLeWAjh4xVBwzuCud9dju/qJ7kzg4O5ubuxdzXWjqqHKWWGPO2dgrqn09YRCNyedS8qMW325NDFPburHwqQ74u8zbwNRmbeHApexmEWaWnJFmFMXKtAPhCt/Cji7r/H/r4b8cKPjQP5RKtWdZQiKAzdQvhRHaXQ2uM3u3j/dtMfBfiHSPl747b3ts4O85FBI/5ybYGCnnNjANyNXRpNbbKGqVYlatkfyxeQyjPtVNiB6hPM9NxcjC4xfJ9fMi3dKN9R3VrxLJqISpmbEjunTl8RfKGAor6CpaJ8Ui+crEMkI2lfuTCAXCmcw0WUFjojnUUKuWkr23nulvDwPQ5cRvcAZxKQgF4VVDEkxF0GlGlBfPHzRtIQVQ3f1bWx60wXUX1mY/WZrsGqvA9OVpXwES3YtunT6eKCn9YW5bAbZhhbT3ppZV/1eaXwRfb12ap+6eUdZTNBPjTU/Jkm6U5Ear565QAjm1+jm0IQwSe2hyoW/Nl/NKWG+5rrzys67ZqZS435deudynYfQsX775/wkuTpZt8KTf5g+WBviSLS1BHjrwtL10m4Ao8No9vBev7y1atXRngvzwfmnOAnN7RE9cYR2mpo2+AknL/TFHil88eycbSpKjTRylY1p7eB0uE0uOF/aTXcd4MY8L/8uoKtsXdfWZnNtm3bRx+lz2Z7pu/bO4qVJOrpGAjIohI8k5UEIdQzt5Ae5BFD2FfUXDOUXRhZEA2icW6S1+s5xEUur1EzjTHosZDctG39m6K3EuCz/E42A70m4UjgUyXhfZhBGDdbzSAQUbCa5DHGbwkyiCFIVFInyAwvhijsgBCmIgj8v3kkA6GQbWNwebXBzYdnqVi7Nq+IdRsc3R7JMFGW47eevhVPDml4TY120ExU4nmTUmYywfPSyhvvw/edOZVbKSgzSb9FgIenHmgWv3maGz00VT9CfMeCRXEOLZP+p82aH10xXqEQPR3R3YFTXHXjAIVQldsEHXhACwhnKo6JhFB2O1QO0Pfuz3iHB9OVAKMOQeJnSe3VEom0QfC20v2tkf+XNmNIK8NTpmlEYsdfxf6TMJPFH3/f64UQRxidLl1fufZvxb/XXikDeAS+VxvNlxsZkZshbaUh0LThFCtEgjlJzpKq8XxFaH1FpDRR7iUQuMHeM1+Ns6RJ8viBCOtMQbmAfAoYvj8Ko05f+Bwn51DF+7kbucOCUSyjPJEGVyraZ0pPuBe5pApzZHEpSWikoui+rStIQbQw4cqJhEhifYGfmnzK0zi/+GpU2//vDSoxiVpIRVeAIRSMCYs9a6/Ag8ija+0fDCDB4zMzZmQGhgI1+BSi67DFYu4lw1ap4GW3aHCzrqowvpwqSTR4lkw+LSEhVC9082+K8oqwEkV7EGmE7+hM0W6vaNb1TzTDvUQ5FfJKbMhKWIF/QPsTiQoKqdoqv3a//REDz30bGhLlKI8DyCBerXYjCIlJqSDCbRR0ShcedW8Y5IRxVwKTqbFqXImNWLwCXGK+aG3e3t1adW/8ODUCktHalVaQkotKLVnb3i3vtCpctfhNZ7nSv7XI3xKAZqXkcgqqdNnF6YVFJYmTOdammFlZuur8NWdvAD1ba3OxEUovRh2TkBOflbpTUxMibpkggMMNNn8FqUdo6uhx9vRDlYw2h62mprrGRqm62lbNQbbphgVHggCLFyRoFcGAoeB3My3DMwAoYXWY6DNsTzf0AFHstCYNI7jnU0kZC4lICLc1mW7f/g1kpnYNLGYAlG1ySbSM8ojkb8hRl9VlRCA8hgCEAA0+oj7kExqG9EPN1Jf3LSAQaYAItpnWHWED1G8rhSiLilC51U7WyVsYmuFNTs7JJzA8A5r0x3oRZPEnSDcIoszChuNX6Grbfo5lOZu0S8N6K4RM1CmMgYDYLujCAToLaRVtTd1r4Ica2MCEvC/QilSpvlfEAhXDHQdMk5C18GxptD3dTlD1lqSS7Smm3XlSxue9voAuqpWWkPDRrLiVv4XVsIByJeMW51FqNoIjrqwIt/wZRm94AlZyTmM7nZ2q3NsV7wrUN9txO+scxUftT+Dkik62G7KBBsyNir4+kF8yAwEDmCAM7WqwJ79l6+jqmXeJoYxS2j2eaUNLnAH8FHR5X/NT/3Z0JQnQJE38gEFj/mFJbG6D9khh7/7tHJw9YbbVng8+UwvwWW4mGlupzjhF7Uo0golCVFWeoKUeG0AGFhQ+hjOTf1432z3z68ZhxT2n7czKmR6W4e1s43EMoKjbB8iX8qthztuyF+Z6dnkr+ApAxHB7qgrTgmFgNgqiH+KgDF4ajRiv8iNt2aJn1x5Uov60ss/RsENliYbCSRmnQ5rwOD0gVRqh5kb0R8wNpPytMdvGGJfY164pYCoiDccqHXHi9Wz7BKOARBIOKY02gvUETx2sSDtV5F3VQmrh+iJy+vLkyOAezgPwQjbx5M95kCntF3+6hvKh1WZziKtjh1SMZgc9HYkvbEfLQ149rhlDvaoIoW4ibomhPbwvIu/wbDiI4Y+66Nl8kAGp9uiCzgmnj/rNcYxQupO374ilW3TqGhX5ogI8p0MhEpWEiNtUaKepWUwVWzuBKaFO0rBOF0f1CgRa8rs7DkIZXH/3j5fvBoJ8R4oXfyJj9swfqA96DpkzX0oKn3v9miW18NqezZCszqqXSjYpvA4Y/sqy7hhOmahl2zJNBO9nn4UFkrURWdtApk3vuMBgYfa336bFteRo64Nf0RxjHMJi3apWbNumWt0gnEljo6K1C+aZTED0aCG59KaILBs1UbVlJRkJWis5sk4reG/b/KOVqfmcglsEAjfYM1a/3FYRQRJuMTb2tPTM77v9y/MuXGhp9199u0up7HQd3mvA1mq54N8+81halxKYsxOtO/M4hWy9ECiGGdfaXtbX/V+ZZE5N/gtlaSauYw7zF9IM46HEE2w+PeeD0/NvcTk7QwQCkmeZEt/yx84fwiojvVUAXZ2r+armevV1kIEaXvihqsBAJ5VI0OSAzEbkmPZ2XR4LqK33nrvxidm8FG8Xd5SqB29ijNE2S27u+8/Yb96w31As4qGZAqY0Ccoci8HXNx0ElFFwuSus36AEBg7LOOMAcUGCo9Opmkk1UZ2w5l7fdxYNO22aYCdiR6PsvvjEVETauk3C1fqm7KKM9Hjpys37ial3QN04IQv4pmZ3GZbzF1pIIVPmhT5ga/aiNan5RL5SmfQkJ1RmJKKl8RX1ofLtaA+eiKxCp0KJca6VkfJEo2xN6BNWsVKWTwSFu+wzhnrs1dXfo+i468+Fy2hsjJO4QTCKB1AYJKR47wZxq1R2I3Zy2DFPxLFEvx2HEJPtRL1iwRAZmk7wHWBQzsmJhyAJERQjL3EwcIqbLUgbljsI8Elbu2OipsZ+4EA9IUbqF1FA2rMYg1Z6GDv7YlwNNyEbghVaKz8DRkid9IogCZDRZ6yVat68leumu8dMbJvOSnYPKphjE22T3GDVdhu6TsFT8yzhZVMvsXI71V8J1H/a6eyH8Fu+z+oD7pigvlhb3FDs0FJQmkEl2f6/8vz5SmwEGGAi6IIQxOs9jRQ3sYR2R3nIbxV6hoYAYaEOYgj0mcTy75QLwba++u7tuaLu/BQglK9+QGOJcLc/7A9IR+n1lfFR4X/I94bPn0T54XLl9q/4FY7UbX+YHAO6R7IN6bbn/TescdbuekDVGX57iJiXaTfmJS1qGJ9cde9YWL4GNc1wVsG6W4IoyzdPtP9+FW0pMOujrRdfp9659ZiV3lxaQj9kHKGP+PfSa1n/M06pRoIrqMCngiCoipFewU0+ODt6MTIL+/gJSff09wQJfLAaB5I1goRvKfyke0TBvgqbV9CFomh+GzzCHWbaRh5ECnfsyvzg3kVCw5Skus44lcpQkpQvLBc+u5lsS2Lam73NfLPX4GnhwVVvF+s1Nvs9YGzKeMCcqVLUTBHxNE7hoorGRUJ5qYAalb504dN8UYVBxdIwRCGzdP0KwESVaH90UdTxLp52oLjXY+niwbqXGjKTJlTRySITmZ4C5XNjCdA3hb59FZFF7CyaUKlzv+w1UHSRLWgLZPrVfpX6FqRlags/1jfE9uIr7dc0yIF5dDgEPztlUhW2N4Yb0zHZz2Wc8/EV/8joW2MKfkRFhv3PWGsBEYrQAp1+64MaiPPaypUdvElZuaWmXZdVCCryoZwI9/pYnHu8B9uL7yjMDd7oiv6M/hWjGeCmDzHQgmwP/gSxQeNRcRgXj6Kyyf7ljGm33yjL9qfZKWUAD71UqIrhziR3BlBBqzVY2t13q4tDC1ZZCaRhlQvqCyNzEsVdANCrrwd8Zd1YnJjyfT+TZnPLqy1AEX08g+FeQs8wSUACHOyu217Roj3leNUCzRhAcWhu9PGq3pDYFKIg5spBTlMZqtvW6X9eObzQykCITyANxJkTMBYWIgyAjIRQeuGOJPlLO+I5zMAUtCuJIGV4CZ4BnMAUcJQpjcGAi9gdsM85ZBADedZrCdyuuiJBHCBnXwXkedbxgRxSE+l+clnCrKbDj7/mBEH09fmGISEPWYb0pHdIYPQrKMDxdkDM965B7BHdRXsEL7Tm9jE6SAg+qQDyoa4OA4MD8EC5gN6KdqsequoWM+jNGjsDYXRoNgQRf6r77dT4fIOptSJE48d7XQJ+bBwt5G6T1louX/yKstHZSaUmpYZvTO0yFqLbr/Ng7zDjXrb+fUU8P9LMqtH+vpN9dgp6rB5gKQ6/huIW5EJafBx6whhWaR/EfHRra8qjPlXWezPvlKXcQtfOV/i5b6P6lLpltiyVTGXbnFJXiObnET5W7n12f8zk4faYTRP6E7EuOlME6PLrg78zs/61FmwHfXccAIn/F6WFScS6PScztyKIF/fEexCs6rdm2wUExZrthScOzliuzAhdKUi/M9srtk2FuDnri1+9fFtIWnj5F++lyUJ6SH318xUECKNhXH95gGlLShMGKjp5vhIZNiQtVLz8oELrL00+n1NqTox1HfFXJZ+4JYsklYlCVc6bD1Ue6UxalGyNU129fhOklCYHGo9sCue7q3IaZ7Tqtm3P3yA3Rt5tLMvKL/5u7hlhUba1cGUp5ynLVpicbZFF/zrN4q+Dkjz2rdxkMzNDb/X+5W8Znk5IZ2rL8wSO6tzVA0gze84k3e6fykXzVlYC4J+i1AKKhBB4rbsVfMCR6qduZTRlzL4M2/2SGLq8y7JguPrb6HPaUxurZofGyaiYvpStfAK1W2mJlycrEohaWg5VKI6VUUx5g7W4ek2hOlxFrQ18pIw0oKUOcfWR9tb6siQtg61MUudZsZKkSCKm0YqlP/xq1x6XvQT+zbjq/JVhAiOHG3ogKErQdvvAwPr1CVbSpbVrL9lHihrxDZx6e92pgUvTBKPtJZRzHIqehSRJvQBYP+TXftfRpfwOQh7emiGKtkg1NeY6vIb8KAWBG2EF22E0GI0td3poA/6KZQw8PGAoi4DrhFD/Y++KZ6N0UGtpCeI4M20cBO9/oKC6WIa01jY1gSb9d03QRnxMvg14B/8Xh1pusvd+Hmq5Ud5n+xC0W6EIxxSdXHlzwaHrH549eHO11lkenH8tK87++TcGhXMxv1VcP3QzJzLIx/w4cTK9QnCua+SN9w+endXSZ9vtnoDYpSsg2gMxAO3AY1MD/e5Oi6QE92DbkEqm2H3yi1DcXl3+8NXCEnMn8TQR/V5X3bGFWasz9x1fcM0GbMr9wh6VzFSrE5MCHXKGjEGTM5NTNJgL7q6wVLy73dtP97+dDHxWun27raXlq68EGZiHD1nxOe5/dI9XZOb/HH9QGTo0ktra/Ox42s/KSVIVndJLCrYnm1RNZa/OEO+Qt7ZuEDnOf5CUJNnUk9m5Qa7TFipWoInzpk9WgiRuZsSbG28TDSmuQLJF545H9U/NK8UCxtcOEsBNdNi04F4NH8nlKqhiYZSHKtjVi1p5ZHegEdNbesFjO1lC77VO8EGEaYlMHQkcnIYM7x20l6EpAfbYyKPIGAkRIhM9jE7iu16DSTpeS9XDWAMNgA6xaick+yEQs1uhSs2eIpCKqWZr86FCnlWzh6co1x0WJbmc5WooAba2rFPRuJ9Ih81C1bmdA3pgAuwV0mY7Y2Xgd3mtn0Sfz/aCneEw9y7bgXw6/oRww3T4TuoXA6ylstBMgPBG5yJxcA1NgcJy0UoKiw3REFp0IhIPV8McFAYHgQV7GaQWDYciZgMtJheJESfSvJFIBlKCC1a0aFoSvXbRPm1wdrNi6GKFSEIXqjX6pxCFGCSbRVvIZ0ppumqh99B9YAkWhuk0NezsGYoTgdSf4lcH6XQoBu+NE+ylWiPdrC6g408K108PLCVqDWlLOQD/hkmAkmBWwJZ5AyCAAMYcwTItAAIvbWi3f9jdBiH+KGPPJKQXCMJ9EDBSjRAKkXhCTYQkjeVFdUWx0iRpu1AE7C6vnGpNSyAUhZXia20MuNqIRXKQOCadYRaKYCIuEUm3CyQADzUea0quwfsHt/ik8So4ClMsSMOhovYTCXTIyaIUDt3Tr5dN+016EAKcuAlzJq/GCm+RhyKY/onucPGEqj/LQ4uatXoigD++47tDm+yyzVNNtMwXNI3Y02ei72kCsToG3a9t2rGDJHdsD2xsevBw+46HNN7BbwJplr+F03D1X+QLLqh6Rh6bJCI3RG4kkMWoCJN9ecdOQENnbDLF3v8uKaQR24Q9wKWpiAWBSEVidFPE8gjc4P4FuShgI4jrnc05UPTSOwHP1IqP6TaWIycuKPBpm2wwOLv6bL34eK/+3SVFh5Uvma/H+ILmOzGNYxExFEsgQxISgvGmyeqTP4X16ogmarJZ7R4mYESo6MwTQKdLAlK6ljPHW9w/mDAdCzGKamplORFOH59xxYgNBMkGgzvQAxkzlEPSjVjkJqWGwwyLWNDshijPZDrJsid7aB6pBU0HcADlFHyG9Y7WEIkJyjMhpQg8fCPPm5lNzPStB9GTbd4ebhN1Iu/GSJjeZFMLG4UBzKyF/iVtQBT682A59eS0JQFb7afArxIvxUrXKIO/GhRmbpj6Ucyqte0KRKOkzxfUM5Lco50/xqExFHen0rWpFTZ86JBw2jgv5dpjeoVbCPZevIWvnQd8q6CVRCggW6OyIxhNT91Pbi6xQwn0iQXDermufmSvOJbsu/2bAEGgm98JO/MH7xw/npvry2j5OejNvnzroX8af27YNkZggfYE1GZZdxrgfZCGwLAVOnmhtodAjUfE0VmwbOfUJDGBAWtk9aQckOE03QkvQpua5Za+a4+6au0SNwG3fG6iQ8jiEM0De+O0joFlc4JkPWQ09NlowUi3Lg2etS8HI8GhH9sTinmt6l9PDw9PYDdOvHkDGx2m4Sb81lv23VNfHMXs3ISWxw7Wj57Ch8jD3xlP0/7Yh12AELYVwkCdQA6jbNp9AMMWMEjgl65floVb/5w1GbR+cVQjzJ4ZB787H/D+SLdnoQby4AHywkFSfbA8IRLKjuLpheC/Ubw3IV2yc7GI3RDRIr68+LltCqMQ1IepicZRW3q4OFbSFaGMEd36QthxxEu5wYmMQfr30KeodBWdGXAkQSxxT1uG84rn5NEHvkQboZtfg2NSgOlABMVy+wah7VbIk0eZVg0blmUK+Lv3lNYWOGgTwQT6p98tGAgWed01KQl4Y4VE5crN77XAzI/sBBmqPMhRfAE/gcAspGmhry8uKx2LyeT0OVmVh8NhK8xGhnTloa9zanJ7eDcB7kbNHLVjWMto64VY9iW6bOTBOPsUoxO+CSQU/UKL1GBLL4yRxmlGOJzRVo57vfOzvsrXgb6TZ3lO023RW/XdGmDZ+A2oIA2eKP6dz/4zTxoxjeGgJnzsTqNyDa4nIQ8ZL+IRS4a90m+/RVAcdiczW0/IizG+jQkaUWQbMJWxhotRau8bjOl3Rue2TqiFtIuGhlmdcHpKhvXODIRv0G5v4dGXbe2QfSQE7GyHkiTrRDuJ5Ha+4KxsNL8afhMUxn6fDKHdTjAjkXEVqAS9hfujuEFMWgtbXt9nH+EJoAk1+YDamyONp1ZPiYkiweMZCNGOXhNhEB17sm/tk4Wzaenl+w3gkEbk9imhbA2NJT0H8cwmY2Jq8JBycalEvET6OvzMrTfWsBkBjHfHu2iu1rbiuBZHSUBu2GKFeMKf65fGhqiAosdXwIhxYpqHRJzLMbjOa4q+r+SoMReHOBxgsBF1RTSpsFb0ul72GKIMVlN9bWG9VlVPCM3TEIP4p0Y8Y1pY63DSjj9V7cICqD2QdRW7WMhiTxA5GjALnucz3jxM32TWZ7nAKUCRE4feTRbIwjzUPfLrDVw4KKMv+wT0do5uiHp5MT6pQbx1+EG1yPDJNAsWxcJI69SU2b//3W8E7ggWYtGPNBiH0teRZbLY/DLqcT5/DRRZa5pbVMTA32mmCxO8y8kow9EnH/evkVaTvq/botDLMb+LcVCO6NL/Tl1NTh6Y3jojNCf02fOhM7YjuGnE9wjJyCnSuomiImo6nxMAHqLbUWt1CGAmzwQn6qFjCWw2TQp14BD1ehKSyCAOPt925ao7/8N7JXD8c9smmbddvgr22QdU1bF5eeA+yXttV2XYlutuiC/bMYgAllQGaM+4CijZ4LXlcCN4x6vxTIGDvhERFMNmEyd4JcuY3kCi0tzOBt2x7w8xJPCuGf93QuBs9X/WtuI7efDL54dYBsuU0C3BK1q+YUp60A3m7mQLIA+PGz3Qw3ksndyTMdAJwRX6Wmrw1SlGh3kVm/r520D5PXeGc1gdpyYBYZu5HefWpPq8XnIQuPvvGs4z/pTftdSAiNfWqWfUe2twuft5rHmmbfDiUVJdt4HSjtTt2fV5a+zH5dvkGRp87v4JpCj5+9qm0k1QmoVFxOu9nygEdXME3BwvohRssVEXIYWM47L/b4rJfp1cB/dSrKyE9VJf3RjEIWfw7wA8hgLMhXhivMdhJk2BzuZ7gxPUvInGBJ7Fa4QeCLyrnASEvHe+y8xGr+vR4JkzNhoMIhFI/5o2Jc5wIs1IF8JpS3skXtWMOBFQmDAG++YmbLw/gxVFBCG9jr766sF2A24RX+rXppcHu8+dUyStfCU0jW3zJ0XQkW5NhRDzGUXpDbJw4g5+VY8JetMnsqBeHu8IiVLF3SikD6W6juuAfq1pHeMzokUTgNhIdWFvQVVDU+5i7u4L4cVSOXxBGtVdSJXFiqzDvA/5hr1Vyv542DX3xjKLvi3Ybh2Bn7zNEgnragOK2lC/nGSSnnJmK4pjhPM6x2XTeBIGizoX7o1KIe641GuZTb1NWXtT1nKzTIfGWZykfKDCKHRxLonL76JtCtbFAl9lYRTH97Q9Lf/6kKNYA9YbSWOG4ALFw47jbBkrbcjItNcTCGfJjoa/EYb3JZCQ1DPvhiUWaAXz9fApFyVH98TOVWu53Ly0TEV5OnIFiwPoStGPxYlPYABFJ0vbMl56th3wbLeF5EMJVBNBxEPaxzG4b8wDTvN7IGGyX+52cYhg5ZTyzMBEotS2HuQkPWwoKUagdYnmHjlyU0/N3lze3IZvaBWmLOGmNHhP2DVUDhCBa4y+/t9A42Bj0tEjW16bX9Cb/0KDKwFMgIxwF9wNO9GMXogkD6+mwybST+MjXY2/MRpFpJ5zIg9ycnfxYpOAu6QFqMTUkAu5QJIcjZfgw+ftUkxPx7+4MAgvOR2q4A2//nkW5+T/y4b735zAXBdYifLSG5Y5IQdJ1HMDpq88FiEOZY9AHAHD5szFRaQprDmKnLqS9+fOqFAHyR6Ud6FmgV3aDFzLak+ftkVGxsX3ERlCS4V/yx4kWqMf8OG/+jHsZCgWm/XypURTBtXFPPxYGtHKfYzb1wPoPasApVrJELCjIlkLU1Mlh/9T/nXSFn1gXkBzaN64iAcyLWraxlUzIycv/lu88yK+JWLeyhtFTtu0cub8XpUxvS6btSFmhcpjBF10hMPRzaiP83knv+AaNwROsGqQyf5xQbRgynyS6NQ/veIVzVNtDbXOeGtSa0jZOCz+PKTUFnbuhronUz2juwA6V21piC2hVF/tao43Ry0tUUpHqPG4S2VgN6eVpjH54EoXxLQweIA70jEaDKox7SHYJBaChi87pC8Ib2QZlEfKGyGj09AFRyunCe3ISovldw3oWjmzpuYIlmlmNrJhe4LSiCMbFa99nYtAtSiKRnt5ugWs6Y44mYo52vXsoQsKznvZoLU5aW0ztrAnEEJvhJAL3YzhcGCxplvetbklyc6UavXmGSkiGxNflNlDSICVKoOjhlyAjHo88tCsCgPoLKz7ioo+v+MkfitrAjIGb4wFBAY4K4E62mlsH+kQO/E79NgN4XtrV6A+1AHjEzHrL1yOSENe5bISap/L8byW8Mtmb9Gjbx/g3xXuF848cWJdpb/FWqWYd/eNMoeURCGV3lmMkah+eR+GILSockGNDVWl/fpsXGCxIKR4/73pevW6KM4qqanx+ReA+9uicKvl1LfPnlYeaqgxjPXZNcmbDhxw6ZadPvnBB83NimfLlmjM1Oc74vzJske9vQpI1RjdZu1NX6cDCpxg29evMmW/e01puU7uoh/Ck/qxXQJptbRVnvmNq/WzUMTWRkBxbNLYdsqqXv3ccVDXJgQubZ0c2DIDxYZ53v09hHjCePhNrAOT+FGZ8InCPZURqvzm8uwqF9S4NPZra3zQ9KF/UXmA3z7e3RtRzJBPOV0cJsbjQ/Q7ABDInE+QOCAOEO6oQ0Asy38dCCqJsVqHiABmh1jeh0h7dRFUWxaqC5gcKbmxw3xMQA2CU4XT4nJbUBb62CHH7u+uEWaRet3bS3Rw/a/07FiIBmr6+wZI416sjDCZVCVLodsUAlzKg+MzO/g10ZLG7YD9JSaValfFJQ7VvE4LPyY2N6pg+/CPUzcThdTIicEOX02IepKcRCSn5rwhIlZyUh331ERyZlBUWjM79I6Fr36goXrmGfA+/P2alp3xN0N81WMip9qRvTwkeVbDQ7kJ8hFGi31eBZHivh6fQsrkXboLUl6ryUB1XKiKGIQup0ZCWKA+VN3ubktMnx8GHLxUDYXg/hok46Yr9+8fWzMbaXDn79wiqXBuR7zcf5O1p950QzyqEwTmxb9FqKczx1RjTIBkDatGWVTUylOKm5ws7gqtVLdZh0Ahf1jVVHYk2L8yTD9+OIlxHWLSI5PpqTrw/a/6EGKx8IkVcW+qVrBjh+l0kpZ+7vAVNeQEg999uwZHS1ixoLXxZQnz1dXKJHHz3smdIp6ToeuXldHxNdjbCs9LKEuc/O0vkRUZOzdj2s6O0P04RsOEcN8kCvi8Ti25FhwRfF0S/eo6GMe/ePiSdA8TVfe8pX9W0lVlc4z1J/3NEl4v10HfUgzEllhVQNqUAJfY+u/+o2H81xSw+W+iQTocFGV1EAyYgm+NuNhFa/Q2EXjvM/op4ZUJXN02Aj2xtyTMpGyDW7S13kQtGwaMrNKPAd1ePHvDfutuw76xdvB3XKU/0jVficDndXMmpiR5UDx5BmhQcMvp6z5eDq0viKuQMHWbt1U3y147D4fF+2qnrxmkeMNvCHrLMwKJY01kMfHJ3iwc7KSG1GR/3DEcbH2qZLFhCMJxMLjH5Q6BOSe6PFi6bgnTWI29xUrBcpBqDYQVe09F5iJgBMRA5xOizlTjndDPfqsN9mW70eGHapc1+XtWLaU/FmGSUaeBYGmyHxRK4yjEEZ5Ikl8q38WiVFqSCcQlj86LC7yZyHNzVDBRwqYmrzPm3bv2pX5qEdpcjj/a+yI7t43EYJ2CVqFTdmN7Rbx5bRvoageFlzkbZ8AWpcLd1XyhKF8CS4X5WiANRU4RI/3oGg0vgwUVi7CJUQ+PNN3CYtbTLq5bhx4/Di6FkCxkIuCZWQ/nzNWrfc7ZtZV8K4oyPAhVh7i0khKdduPrv5wYjRWR28ugFkzwq8ufdTFIv4fFsqC54Dg5QE+q+oRm2NDldqofBwEQ6Y02GQShfFDjWLbT/LlmA8Cq5ZgrnI5WyngGHuZoffDlLzYQ+CQUgRKl9+h+PWRUf/X552HnKVxipjqt1ZZysZzPKudG7LUthZfjfH34b7fkMjBZIpYJD4l4ONnk7CobqPW3zsEWMxjpGAw/AmB9giFFbigagiIoCM+k57V6L2bYy7aPWxdjYM4EarkmkcjE533PrPjPD7/0O2cZg8BgoTEoLhA9PhTFkoogRUGWtdV9nLOOpWVZlZn8HGGy1CwksWb8XIX/F++wWBlFAUU61u6mSUizNGQYOy5HAQpEBBk5D+92k9Q4fGg2ZaJMlMlvgr0+ksj5L9J1Adce7kDxjjneTDEDQqGI5xGNA4HIZZv+wBpVZbyVtjgXRusSRAvPNBaEivAKtFgkJdidhxgmWzo84WWGXxpdURnkSF60xaIN2d3fe/q1+LGDeVkWdE+HQEmZQUHyKOESWjD/leIFU69nXk6mY0EtyX1AzAT+Jpc4uaq20o/1O5lkYlg1peW6OpBu+P2sUPVjXyHAhuTzlicsTlYa4tlOkdPjXhiIf37fXKGYf/AHIhAPpJXVjpGr98t19MS/v28uVyw4GFfPRwo/hJ1ZidOD6AubbLk7TRmCeUy3bP6TcBPeNYjMvYinpOLYZcsi6ECS5HKO02p1wFMaHVR65+GFZVgoMf7Hgtaw2ZPVwxSsrt4RX092BqfUdoUNJA2lTF6gYEvLwdTg5cXxtr8o6Pp32c5vbuZSEDPTH6UZ0BlaviEB+CoVc9vRO9VrQyLdMYaUIGmq2Zzm8cqEX/84krYrQpnpye/EAFjCC918/JE2oB2/1caIeSby/uJqApVJzCM8LGh+t+kdMPlrQebZbRn/blvliwfdazzrdYu6OmM0bUdzj+Ue4AIvGwp067eNg2/eo0kgqC78IcqjC72tUkYedPNzuLRBekSQkljIim91mWjlGYYBPHRoNqND5yrkVcj2nDVT0ClGJzHKolRAEySqjGF3a0gNhKzbMyTTs9A+EoPM4uYoef2mxd+/GR/7It1/5ZU6c27RXiczLS85E5aq1SBsoH/0RCUl33yzO1iydOMXshRrsESnUwZjh3iveyOM3vxwAII595/eDm7cKUhEMHFuAOKmVOHRZWuX4VpWyjhK69LYZseHjz3BVmyKrJSjoNgjBk1TAptayoJs84zS5NlGhYwskd7EN9tSdzMLaqR9BclkCVWmaVs+FwW9vF+98YF2i0C6HoStajJi0p8Rb5Z3tnYSysMDfNZt//yqKYrt2yMNc7ssglChb9jIR+Hteruv3jf25VczKGItenFGA67GHz74/YHrvGmP6fmGhqdT1xIIPy/7hpwPdszjR0s+f/PVt9G82CDbZicCGSthVW6gPBp0GMbLQUUDHbM0PTlmJUSLe4bgAdpHwAcA1CIMxWLuk6Nhpam8U8wwYidOlltw3QkyTkZsHYM7wWT5IYh7PuzD3MKt2PGUk1a6Lu8MMRp/WNV2YC1yOsypMjdtcIUxJWuaXWibnTKFeMVZVIq+D1r0DvJ1O6i5gMIkxuZBts3ip/BiHhe/mPHonQS6V/NONiDvUEg0jXtDJP3TRAR6ZwAe/XLpwopKouvkO2fmNu9X9CCpeW7QIKkoOcLD6iPv0XO1SIPAPTVgDouo/XMCNYpHGgOU1SZs2yHaO2v6Btp+777mK9J4x0VtpdBnwx3w+z+RmmphXTiE9YXGYJusGdgCJwLdp3F1T0xNRFYycDiWYDU2SCdPaPLYRhg1KwJFpC4Vms80IaVnk36N7RjRsw3x4kkEw7iIESyIqHRhiJI+CJMrFB3J8LYqcFdFYUqNUnMFT1UPFlsGr5oJYVXbX9gQRuNcEy/xCCQNO3USjOcu4tovdmvGwpdPkhuz+/9e6NRm8WKswuDsFPbvPzvkO5vk8a+Yaqj4tVO10B5RlgduJkxB81yvsmpjPPURkiA3X91zwRTFo0C29UiDMrMyG+VRYKAGOdDs9Moi5cVqEVJ0BbxmWS8YumEFpFfg1M7tecZ82Jt7s54eguEfh7U1yT+o9H5cUNyLC0IZitKmXbGCPqpZgAk6Kp6LpsnDSlO5QdjmGShzMgmqGRPLJTRMo8vDZ1KOzafpVYRPMB1F1YTR/BdnmaRRA9rMGk2JwAzRUK1wEdFAwB6F9qdINnQCg3SxPerKSPNoKOjT9nsOaXCk3aadrwlSJkiUslhLLPtovbG2tjpp89HkGlvt4aKcSLk2cIOgv1gs/GTW/lXd313rXrU262SgIaxDYCzy89abeJGEY2tgf9oWRo3J3T7dvqlis2Rt+oBY6CeOcvcbAOqWNqan2xszi+xZjQQCF2U3XFChrVtWgRcytFxBpbgzH+B3zgp8QSTANFnNZGowQ25hZ7NGnag0NSgM3/YZ8IysGAMjOL/woAdm/EKEESoMoH+IMOVfbRJQAi83k+JgwZuUxbrFspdScKLTRobYGDm/WwJKL2UYjEj9lUt76PRfU2GEMsy1Igc3RubdZPi8aznSf9kTe7kZvlWUDJ7GsBG2o4z1jOrkI6G/tQ8V5yl39/0WenG/3bymRAWo8YmD1k+qeqtE+64kDv0NeCWjWrszEc0xWESImKVRLSwt7kvuK9fB1GE8kjb96uVflf0d5o69FR/0WgQzZylLIp037lWk9it/vWz5I52J5Dgkts0f82D+K8Qja1hoYCXsIept1dtg6vjGhvPB+ua1ztZ0UvC+xsZPtiFpO+Nua2vlq0XN10ScQYiRru8kBGwWfYl4eSakslb7GCo0ML4O5rY2LWxHrawj68vQMn6J1mEgV8kYZsYJkF9yjjQec+P6rmYybtS+kFujK39rdzMGlaG4tGHuYD36cPAe7oEIkVI6E3g47XiwcNPqM0LQKD374VMM3+T12kf683le9omgyfbNfBSP5mHbCDTS3g7WEn56cGxh4/deL9qEqxdd2/ip0I5NONpGMdBBroEi6PotU+7rbBpKAoHIKHwaUlEnFaUlWXH9kP61pVnxeceVK1f5HY7yKqS+YUW1LtM8kocygQdXxE6uH0smLsTsH1zTz1qCgdCGmjdPPOXHpcsIZO4Qw5nhdxXENYV9duLNQ9j6GRDtrLl2AvqJlbMC/dGldSjJWl2j20FoNVshpDXNVNVACUdzk1z7124wWSxfgs2myPLKq6yw488b1A8dBGJqaNJ+9tT7nUxeZM8G3l0qg4owIIMq5gghgcWHlT/XQNnUlF7Pq69naR54vDIQmKKzb09mnoHaXUPMpJu3WLVHUlnBSXlx+7XMgHx/B2903RXGxVf6O8N4+N58scCh1g70rXYJnXG9wjGesDRL3Axsx2aSJ6FFXWRwPL3ZpcmaSB2BodiC0ESPItMSEjeqcsWb2UbeMd8SCDNTPNqBfDB7t3J2vrHWv0Rr4hgNaSZuyXljsz/ADeZrh2uaUwJhymkp9nPHl9F+SlEzrW0fX1dX7r+TnnWt+BPqi2MIswvjaboM2JpCriM7vac6BSzQJ6Oqes3L//F8/aw7fk1uqEibfhZ8rXOxAhEINLsRTVzBRSANU53BOwL0Yq9dlwy8LTfK7T4PudcxNu717P33cD32fTeFCJENCIIHengP8jChXX4GYibiMCMF6ppELx3iVks5RqXdrbiJ4T77Tdp01t6WbhyN8+NwfIyMQhMa/JwJ6JpFynIPZveUtgedgZEgMNk9FySOPQ1CnKnode7Nu4UIetoWIndu5fUKl58E0cpug4BzMnJn+e2gJ1qDngTdLu913lBxBhFMfGfwrYoNCEUAfsStvA20YqIo2i0iCUCJkSq7DY5ytiJ3VtxyCllAdos+CgkeIl6gl+ZanO761kH+cgLht5gW36h05lK658w5pTpbseENxS0XNl6JnAF3O93URKpl4vNGw4s5NfhVghRBbxFBxUl+RuFnIQVdHS6T99Fdp7sSIc8ONZWUrBnPMdk6VNWKiko5K9zlwfABRfJJ+T/3N0RazR1zVBFhnovPYOqNCAmglqlUJmDqpdzuibvh7+ydzQL5ydfd5u7XJ+UC59oGO79SAdj4FwI2fisEs2hm5oOOJQ1XGmqzT5k1DQBF0pl5KfPhBINx+hsLo6OM53rFf/tdvKNMKHH/9vNcpa6CefMMepOSnsgKVbQVsrfdHmWF6H4AW2miArb3st+xVLkeAulssd6qa5LgDZda0qVCmeA4cNgzSRn5DLhqjyXwbX64n2U9/Dfgcb8Va6+THGmCgWUUB9lBKVvYPM56gIVqhy7FWST1Q3mutyuisW0f/U9OjnZFr+iOELsxG0EGwUJiAxDiADW5XFhnfkWZX1UBsH0tUMh4DXEz10MHQVYRwW8KjTmmsLMVfUnFH+Nu/Aki/ny5EdS5XSQkcbAAZMAYSdpHIsce/Edw6E7H9TCn0PZwN/eZCEUUEr1J5pr3QecOyc2YAR0LO2RGl1LGUMc1TxwFth86UE3aHhlvDjMrilsFZabaKqXgHTAFYepFfUmrnfqRYa4AvPIB00OYg+0JSHiLIAFpQmU3uXL64flaebNOXwDa9xqiPh/K58uEwMIpMjlnk9Ojh+LzVLL4DS5zkQel/8LRVWICV5qVAzUDyqIz35NecI39fbn8ePz5eEt2gVheVhZRiXfgy2Or7HrfqWw7goi41fLN/gvVc5YZ94ZiEU02PN74j6l4Sk2/b2Wozfyiaod8xeYrvVcaXOfuC/BvygUiXBVrLK6MM5Lf2RhRVRqFzSlo//8CoXJhE3z79KDRAHrGzr9CREvgzx6dFXnVgv+6ZOXZ2RX8qklZl3zlue/K0lpSHYeShOL0gAPsK4qPn7pyKyj18tDhzQuoS8ypMCUFcsyXCaYPrtyNl9Ssk1ozWEU/gaXvx48ElQaAC+rsCZ7WwYqlhBBzPmDr0oGTsZN2ofOiL14Sgu590njTDW8V77xT+2FWW/syDKCuXTy+FAGoGefcjh3F+tlm9AyyuBTCPXC546OBRSpi2AZBapicCEnB4IaXZuiDdLt5aPHeDWxiNwb6xJDOEFQuQnRvTI5xWAXop0kBuSbqPM/qjohxGPRaoVWuk3uhuevjEaC/WsNJxoMJN1wPBVzZt+szZW+senfD9HRyYGDdVajZKPko6DMBboMDudTPl3gQwiN0Hc9u1mTwwwdvg+QS2KbzBSxUxwyOIcjRc7fayY3450/pDD0ANHocRqgJLKY5XTyvtPj9/vs/Ud+y/CdWob/hKPoJ8iEBI8o+WNv5wc2iK2VJx3d27LxAJNGULBK8zmg6NR3yLPwvWaRhexK1paBNcViVe5dkdqLEd2OUJCKiHJatmqhNz8hsRF4R9KzgtNkQozpKPvqUyxn4jq9sA6dsKu9WXPEGdMLApvts9JEDSCCG8kefbREY+LUxtYYla5vjZVRFoOkdgcANdm2QX27LVs3NTT7i15s8p+ev6BNGHySy8ueidT+/H7zn8ujl918we/ErDF0NqK729DrjDg3k7555+dCeKWAfii7e+sI28VpXH7kRhbrI/Xw/ddZuEYGgWeQHZRFEQxCyiqEK4104lpwKNfSQI/jeNHUdihwaQjk9A5BlwO+axi52JTbWJHYFpuWRivNFYh8h1DJHP1FhzjFLlj6AvJkBALxDkCcPLWcCffDqWCCy2T7yY18fYoZkmVD9ZoMfp66MSgmLsCUuTcbuH73txhEQO1+jeFnozoHGU8o5MwWAvBQnUaPSylKlf3NJs9hO7eiPb6SX1OgPpBlSm46/sT3VyVn7UF+uSNAZZKNJDPqt2fa0wsJVLci+UT/SLInGRiP25ij3SJxlXp25TRjhW+pD3Su8PNVPYx0SFlBrsTJWULim8MiDCI32iwAJQOGihZLRbfzHjH+hC9NUvfHEARVYkMbx/d/t/9W+GVi/sfh57DzLLCqH18Hrb0RDncyAFEyvV9GEPNfNQNqm17OgX16iO4XvvkA6pVRv8A/TW94CSRnQxZkTT+s2X2r2SHyxoctWW/fw4ddfm051la2tVcDDzElks427AzPC5iRgeO8kcZg65A3rhs4ZMm+Qt2/Mccz7KbZmBnuFf7/tiCAYKMsHW/jCBk6wtuWwgreC9q/M6dizZpWf8kY1xiXOTmDjY25BBuHyhfEUTBv3nK/e+N+c4HigA+I2Vjj666oMmT+Kopu6oHjL4rzNZs1GSPM3D06tS7Zum0EsMjFXeuDdtXF2cXxFppneiZxHmiBnHD5ZIZYw5Yfh8QdFmDMkxDUTca6/iooWPA9oyVpQsly6uDRneYn0CC7PLr1QOKShgeF1qVXJ5bC4qqQztArXPlj8UlBqVQOvx5C54bjnvrxbunw5aRjZazPKglAcLBwOEWMppNgiVlsYwQsnCrPsa9KFfFZ73Ry83JngLnSEwnDvEEI8jEkgAYIkYXUnRfmSAFQzjxn5lWwAgE1aCNay4JVLpM9wDkt5E6rto2DissrSZJv5zLIb7Gqg6D6Zb3EGzhvM9S78Ni9sl/+KcCUm6vMT+6RwTy3YdTTeE8f3pyip+CfBt6M3Ru2OJ2DYfmT/ACogpf5ut2pbeajwaOgooz9Fqi0KKQd2EamumZ0rxLkr2F/BTbl3UywBfIkbcTglV4IiKfCDzC9K28VzqihLOUf8WNxFzmky3r9cVfpjJvVBZgpqVWBRVi7lPko+Jjj92M24Dck9sm8KUOL7xQCQMv1rmKMsSviTG0rKWkLqWKOKMPbNV0PN6OXoZuj09WiJiJyOyVfhuH8mhC7yD0VE1O++JB4IFFiVcrK88zJp+QLpMrTGK9EXla46Onv/xnxm+HFwlgGZkVdsSydTI7nb7o3kxt/YLj79LMimTS7M3N5J2oiEwRaQRrpJ0P+C++fFD6mfD383IGZwpHCV8LHQh+9Gv/2e+JwFSIkNtM0roRSEnzyKWfIaOx5dEfujEV/P8eM2K8uobc0kvEFvyAMHT7lh22mIyaesZcVsUJ+xKz4ZE7BsOTwctvSu3fIV+IraJYaTakr857YHvZJ7lT8jRtebSrcw3bN5exHv4xFjgi7C+Yj6VgFMGTTr8zFRut/k7Sa76zB/3UTS/oA5INbCQ95reGLkGV6Od0PgEVeQBCscSpOJFmLvlYn97D0x9gyzLhherN79yfjKq8En40uHKqu7Abc8AxazDMW2U3WwPV4xRVIs7NAfijuYErI8fE5NI9aAseCQN+SIO8/hiqEVDuTYmwu2HlbSyg8XbG22r0k2+7SCdGlEcUiMjMzmTgs6QunCXBdpGPhJLcN64xb+8ko+v9x2ozTKzGcP9Bk2JG3T83kDwo3Et/7VbBeAcnP7/q3AUKQIKGJAHNPhd2nhzPrEoiymlI2ddV9XtJKIW7VM+ASgIxA5Q0zl0g+crl93DMX8WOi2mISrJ7Zl2F2U9xf+FuFnIbgyjoo7CbDfXJFM+3hFeDK5b2WqbzXspMLBcir19FeHynGrsdRU+sd5i8iz2gxb/yr8cyvQbCirtcmTkWYMv2sM1xNyG7NhayQE6WCCEB4+5IgeBAB7EBhG8bTfXHUQTlgitF7iZnAev7PEmvJ64Y9Pn1YgrLJpw4cRUbHfVp5k9lxFJMF92hRDSCBmAJzOjseNMEc09uJiHksDi4oJF/6mDioM80REzg4YbEZmaEVWsPMWki3RcswWX4prk8A3s796EGzGVz8KEDp/bh9VaPLtr47Y9u7lw7cRAm1pg0DE48tIF+9RUQRyXasGaQCPBsixLSMaKPoPOddKfHV4UaqYPbuu/FeKQugqQ1C0qDDgu5SuGSKNidJdUkugoIgT8OEpT769WZpZZM/ev1jGOlszmoTZ8nCDs8zp5sdw07kxqxbZX64++e7GYKqaoFjeWgx6HhkHS3Zw9peqq4I+fWXjLNRWCePEvNCHBRccPT0KwIMIAWjwBA9w2vQYd9CrTcjGWMioyVSAE4aR9SeyeR5z21JcquNt4Vu8VrB4kncKeVCffRXzHmDRSI4Z1muQ3517aGuDwWt/uvYmMFlM0zbeWh27282XsoiMr6nbprV0VpWmIDkXlZoXlM9BE/zbskVSFQ4I3GAPokX+H4bQrGTO/FcHdJDPoQS+LOI4ye3FcfH3Y59W57sF5S6Zm0+8xqXiBIkDiflJGjZTm2QRWKTE1sf7CrCyDfEZfBG5WoRRhInfCt+LyaeMN6obPceSnn4HSKKO1q0UutfhuMWRKPbxOHu8ws9raZILBUWSW75WXACyfs1Zmo/b7KosvrQ/c+fYR4vbkU/YiMkZA83PPftKqQ829SoGOUEa4q3IhbSryeApqkzRhMcNpMkn5ORSWbKOmBtYKjaQoLDAYimQpJ+Zm5TIF/JzzhbGNC0RBpDEbaYDio6u3EYJ2ZRYs8z48FhzzNIP2U0NriRxI7Nk6d5PZ1C9SFIBbMx6WOgz+0CSvCt+opuZH56GIX/gBkbW9NceLRkhozyO1J55wRYUuVfcV+LaG8hpSrhKsRjYAV+zbdVdCgiBQRjj1JSCaDLWggkohNOG5/78s3zolD4XgwYxHDNKtCeDwT8YuaGOMnPygTNHlO2GdiX7eT3CquygJLYLdYkWEV8yGmRfOrjUHrSoCYNZdpLlp8YH5samfiEk5+8BqU5yPZ+gqu5U3nEsLzc895zt8897e0EvXxno8O7N/Qvjm4e/TIgpbf7dX5l6qoBMESNfv5s4SyZkvSxeOJccEEA+a/idTgiNnOLR5p0b2rXm0d3OL3a3Poh5abh9ewjt6Y2Nb/vLqYZ8z6sbXtuQctlz6MaS8rNlow2uvYHHUHXRQHgmvmAGdCEFnSmP3wBkDZ2gqBjIcA3MFPvrr3uda5mhNXmPHuW0ccOq0YL8/tHAVqFN99atih0LI6uGC9f4StKAROSsHIpflXArK2fNJiHA6McZr5oMaBaTqPi6h3lQid/Kszzk1YyP9Xn3el0Sm3ug5HQXiRjIeFEfct1A3SVbri9+Jm0mDuVL+q39wqyss4gZxX4u/C65lLowNjz3nFJcCjouf6NZ7EsMWWIKb49S0N1hnz+rTlM1vB8Qefr6B1km6IL9HWuHj0S91CLFxXz51zYm3EShMv9afzEy3RC5+5E4dpCSCWZ9oTe2Tn/6aga35dM/TveGgNc1rZXvhcxofcl+yBwqeMjtfvFqbamgJcRUn9iyxIEB1PODWqDj+yd0vDQBIyfZFCIgg3P2PRkaHPwnEva/dHrQAQjwQqvXwq+uIqEZAh55tgLF2GUb1QwrHuJgc2bYe1jgo7QzWk/3xzCLWAtjRVYvFJm6MDBedDoEkNCedkSY12n98LMg5SzsB8GlEQ4TbG01IjEpV5UoAa6KuMiRkNDh5kfKgBEn4Y34KJU2Yue2srsj30RkgI9pYu+mNzFK8G4J4Dob60wS1t4ss6i+v150NOtY0lP0l1oF/fbhkQpJCVu6u/Y3mXtu+yl151quNdWniS0omfjHEMg4eS4xcthKvciio/DBEgOcJB9jGFpkmGnJTmJviieRWnuGQ6BFC62HbLbNJ41NagXAMolsFkGSfGgQdQMNPkC1zYyFGGa+DIodRHyA99G4I8wDLfxoYLBK+fGPHb4OBO7kjXQS2OMfcdksUHUSigbb9DNMlKG7g09RxcfcsojeXyae6hEUsosDaRXF6ziIOOWkGmXeSnstl38iD/Aw0K9U+yZuiCMYpSVphmL5OfPN5maer6uLodi42RcM5X+7qxf48loUJ08Ozv6+kcO/MLDYVsBEFS/3pqfIgsHGukzL6KigNgJ6s8Ux46PgGLHc0pslWwr9sMRRiNVuDnJBFAEtDHFdAzTQwmY/xZe4SjgXmSwDtL0TISQkwmYHYWU04M3r83w/CWEg/CNyXh1HR9eLIA68TUZ1vJVBxYKSuC0GzcNTWp6OoSkMwHIB0mL0ha4MFYF70UAuEwgPEc2E+x7aLm6Unqt+lHfhqU5Wwn4H6831oEv/pyrUFR3aJlTFJu1LZ30YdvyVENejNWuBJCKpapmg6nvo7gC7A5BoW1BpNNtd78gykvHbQVQksjtBOzM3FX+JjxMfg7nNBtrppt0czU8aaVrUSnIDC44rs/cVp6g2d9yRT+OaY0a10wx8NypffrnyX+AaoRmgJxBXX264d28QByD3MNNTH0mhQWMOQB7UtIR6DtGx9mADYjoRoFrMr5fNzSH4AgUtRC8Oyq3uPrFar4KVljNmDUFLisA9FZvPZpH/JadtBpoxghz8DIMPcTDl4MLHYvV/qIi8vT23b3TBPG/YmcYGcGhYbCOl+o+8HjJTuCrRHiNsLpm7iXbGnEEfN2JATGpatp0+r/I4Gkk1oakjuuPsV7R55QvUYY9s7HysMYUS5yuft2bV6u3bv5sFVMm5SehjHPAH1OD6uidG/nxxXCTGvV3jOQUq9R8S3LVbKJLFCLYUuejt6PiC1PWFq3GY8dD7cyfT655ahRVvKpKNXEaRUUzQMtlh9JcXm+7E6RLDcULK8pCfAH0ks2Q+JbE2qkg5LFKcVp5ujzRq9Joo046e5+Nge6RBq1dHmjRP6NtTrjGvGTaSKhkHBH8wBgoOUMDjiX3Pyzm/cLeGiAvH22U7thfHm5Bfpn4ZSpVTMR7RZHBqjjgiuvFzLPULSvhvpj4MpG7/1itEbp5oQcLWtDBW4wgP9/G5xU/LnVvWWqDziwiFNyDS715suzN/3JVcamENmXBKoO5lnnltkIjaCrP7zfK92cBupnQlu7D9ZEWL++5dy+Kvx8KkpA+gpkfS0PBHYqXybT3cWlVBut1QJKmWZyq7mWTZ1utJAcxnGIYeXhlbbruBq56KBPW53fBeVkcRwgmhD7x0f9EmhE9UHJ0DusbKCef9cgwZ/cRj5842F2F9w0lSe3+e/VUBj90kphPcCJrD9xiVOvbksYwiLx8Yh4BySlNYxrO/fZV9cJ7zj1AEK+eXCYSw8FHQyAgBHxM139fpd8iuGQeMfeYvqmjMdjdlz5sLroLCQn5E+wsqtLH/2crZKriqv6YABwDcfWXzgXp3TNed91eLba8NV+FHrx1pLToxhuEjS7iUfHJX+WYCbRY58c2S5m5aO5sHvXV80AJ7mk9/cxbWgKK1CSrAI4V7xTJpjdTNwLSEsX4mDLcT0uYV7gUO4ZW7trxNK3x9yUt/B6XulI7VqHMRqhEgAYZcPBli+cDc+pYtD8oXebEKbklvz3oIz1EQ8UxKQm70Oikm17MyvEnp95N3dVyTkcDeM84cacu35n/0VjurLxozFCdlS34rXJNeynTt9wcw/8q1mEuK+CFftcoQfBwpbu9oby++k99+7I7szgbpgNWfB1eepVt1pTUqdQ3Fo9VmlAdTnmwJlM57MhJXeAAtC33d63EUBCb7kcrNs5mDm3IuPnVu9wbSwvOM7H48gCGnsdHhYJhVq/p4LzM8Z459vA9Ip4wzw7QO6mig2UG1PMNEx/HA9GWX6Z2GVmhGGhgxyDNuigMS9LkZDcIw3iHnAPFPXLX7t5psi2atnsSSCEVMx+lBgzHvy9tw+2qlUPhfXXtwTmlUrOWdIxWxZgrgr/UdYMvma7Ut8EyzXb0CqIcAV9h2oBvYK7AI/L+Jw+ubDIMJxRh1WO2yIFWYMkzRAAhdBq1UNveJn8pGczrYNFRcubw5pCjKHmWKD46HNkUXMmzxJTaFFAFgCyqXabe3cK/3VTlf7+SA1mDF0E0iE0MziKSrakfC4lANisOfqa3CAURXbrgUFifVKuPwRzfsphV3Qab3lkK1OKZFgRA0s226fDTDkBQyIyBaNAtZ7qG8ZRRlhkm4Ye8X2TDUcBWjt1j2QROJrCh1myj4uAOxnTHkkLgeuq3tk3aTBAkMXz+daq+VbvVBOhhmAl+MkKT/KnWvNjt61UUD681ZULvluz1heB5CvzGM744BV6/+srNSuzUy8E0t7J19QJFpG/0brIowwuxGciRKWjbT/LQ38lz/BU5gbmu8JZaJZEAcOtKtYCg+Lo6/sBZYXq2VE7IT7FloTwCL44x0Tgi5eG5sZcYDFbMMa2CdcAy7bBKL96FUZMR6IGj1p3gYBCaHbWzVsQtUixfxOD4u8uCYP5QHlBrqxo0ERDws8EG3td2Tmw2hbkCUKq+YByxzSBAQ3VlsWHK+PqqJGDd4GI+VCgYQlvP7rfMk5+WdPufQl+AU5km07IiEQHgltCWMn+CPNmncN47z49gY0MulswJua7gs9we1ygi4ZXZ5QXweZeMxvBbJ7ze6Nq6AOnh258pBrZyXXmwmmuiYKE+TUB+u2NlUntJEss14anN5RF5eQ1y3trEhMFNXacI9RXsV9u0z3X759bXwAgF/Xs2BTovuhRWcWpmGMvmKdt++uTEa/VOpiDAHD2mcPaQNoEu/UabCSfQY5dbLx8tD/wyrx66xnp/AH09Y4JRShf+Hj3VfTas0QJe+45nSvEfldyuZc8LHcJNmJgEcT7KTFwBs0J63zOy8R3WtrRHl8zMtI5KKguo4LUnd1kEFWo41VGQ0lGVKvh8b97HcZMhrr324OCU5UJKBogr9iT8yQwio2BfaJ/Sa0vCV362m8hdisasJdLTXq6jAtg6RmqL9LMkjgIbhDsqVdRUtC/sUFXs4THmqMm5giMkBfzkgLRHt+mcaW4QFTkzjC8yddZG/a3WPsKFEHCqs6jhqfC1c4n7TEAivWoa5TGj2twWfwdekpxeh+rkM4CIAwU1BWHPjturuR0dj2/73kQQPoYA6lQa6gKCPNUExnMfEoK1sJXt84krQYU4CyA7j9VgaJCBtlVtuiOrUHlWXni6lw5apiZEQRJ/GT2l5SJ/GFBIke91NOgJxwjA9YkUMSo6XRYHut/287HvfZsD+Xbyik6DSAnWBZn4liwNJT0XREoLWxkLo29VWXJ6mS6XDVCX/Td4/xZX6tOY4ESru/e4btpIS28NHcBfEm92Qdsw4+/PjPXJdT7kRFJWnj0EaumRIgLmBtZngCW/pLrjL106QzOHdip4L/oMHzzwfhgs3Php1RbI+d5To/895IZM6r6YclxeebqdwnduK74uS2Hr5pv+G7AxuSlL+IyIlOfm2QLp4soyXvOmV8Dm5X+88N7kns82FrEO1BoV9t2dDHhNpKJbANzVpYI1s68QCEvjziv7fFEt/VC58UjNY28JUhfDWxeAfZ2M1txIqxysT/tSswwCDkxjtYIFgPdpIYyIyAx210KkybnBYDLmAWtxoY2l4de0qwVLzNJFDyh3yLZc+lP6gIXGyJdN8/278JtpYnJFmi/CA4Hx2QEa0LPbC8PP059eagF4egGrNYqqdcZ1AWuoiEywoaElZLnwDAH60LNYQk4+1YS/NT4IbNeEqtBLdWhtNUKerjinPrcgdqIRGM8gEandW6V301SwsgcCdMmY++W1zQJuIQndw0/oPmN1rFw0jgs5e4LOAt+fogOJR8jTWym+M7F2hiLDUYbo86vgnfnsdVmX4sorVq07/8Cd3PaLnqULtYtLklbi86pnOFb1uUYXjxr3lcsPtrWfMCHeh3Mz5s/ih6Q7WDldPPGTlevHZm4tbUMjWcDlwWwB/WURH7xPyJEqH613F9vExRadUdvd83NOe5UDNo5GYL6xF+bhUwe1XCWl5FP7RxKEv7+QIxCvtTmcf4/Yi/9REMeM3o8ju9474bQ+Slz69gXGgugaF/3zw6uBsRr0wOfQF+mjEy0rw7WVCVnp+XohkPIIEjRYWtL4vJzy8n+Wj+mj9JzZLm6hnvAOXkr10gIyTaTO5Cfd1CYzJfWJ0LeFofCJxSlK2MmF+o11IZN8kti+NPxLPiD862poXTCB9IBMo/JTkDyRCJc+UxiGvJmsoSdTeP5HAMX9tMWfNwx3f52TFEsRMW5T7JkM27fRT3QVrjvwfe9anBy8s6Lz9K3/WZJjTBkZDBBqaipfnsX/6/24FTC8n6lxNT34IFyZwb1ybjK/mSpKk5du3St85foysIas3cqU5T+4Vg4T8hxsqxXXCnDpRY7AIGTlS1YUBBgBYIc5YMaChq3Hblsf8Qwxx9/i23eNmVqAvGngwV39LVeKdSuO2Fk5N1txQ0FKiqfcdhAguZGo0629SQM0ugckZWz/L7kONC782H66yvhs6NWZ6zEhAZsbbyxwI7wu/gz6KFa+I25BB0f7IEf4Ib5Q/CvxFWlMqrBEIaoy1gQQCd7DWEDiHVBN0s/ZsbkFTHs8q5VhkedcRkVhLOP80fij3tki4VmnedUSklmIuhLJBNHL8f6j82KFlhj5DOxMV4AknhyYDgGfcKvbzTicdyDNndL28Pu8JGwtN1mzSWYVEcRTza4ojm3zbNaYcO9o6HCwNzLP/LMfK7/xX+VZ4DDGDGDO/r/uI2ZlAbYz9kxdpinsQnXdBceBWrulUNzlFAQMHx5UMSBcoMODEeBYl68J5EBlRoHQfnQzRyovHEZgILyUgiOGRnYk6xG+SwAPeCAO1rTkrIA4JYCH25W4mo0k0h6miu0/V8SDCutaesyxnvaM9hZRrFueSUtyQBQ+NTMiWMKkSdi0bPgtVWwiOCUe8I8aOHOEaB/qIn/kd8CNnmuwiq7LDClXF0XP3eELaP+uWPqG9lN47kqXAYezPpNcncZftfpF/8eAb5ZywOnD7TLTM1CS/up+G8c8ZmK24hS4aeW5du7MU8WDhvJI1OPhmzn4V7lUMtUJRUjc9tgKyQVapk+5ekWMjr6XFVlqhuYULitB+uYsXPihDblhkfU6/uIp8uGieXw68+P4zwwxAuy796BF1VJmHbqIavv667I+vj1a6aZPLIMrNn4vbvt1i+UnRpxxG+IrZJO45gFBUJNphxvYd6iSpMK2JYDbW2BmAcsBvOiaG9OZSrLUXw3wS3b9bHQCmPwtI5sg1xDO5c8gTZ/nky9dH5IPysZGrqZstAa3jnlgZsQSYRVeuj6H7chaStlj8PRyLET0+uzYi71OMDc/oiLuefcrlayOKwZzhi9fhDAMO6wWlOYzljIBRzBjsMKIAmiaP11Mu/yvM+bJxHZ6M1ikxZsWHgXjdtd7oRVFOIDyJP69+jnW9jb1AAktaIVgXZ1tbxoFIVIqsIjNRSgSzLYqV++njl9DStPDYc0FV3Z3d3hlwN3dSxLNT1xNI7CJoPC1APT6rU8KhY5G4L4OfQNM77IoErrftS4iXL/rouDPnV7IXtoNGq8F/KmzFRUQCG8tX31w98ANsfzzepqp+9u0EY9zeVHfZ0Zos0bDo9WpGLumG3jhoWR8VUCfpId8BZ3zUO8ErA9S9L0mRdTzWtrbYEHISkp6x+bWjMisoGvOjapnGMc5/e5MbEK66h7SDnn8JpX/kfKs1tP6Z87W27cuGL3uQl4WRzi9U/jPITGT9P7nhtRM+zChC3fQvTD7qkuJN6siPUuOBqaHUG3ubibRz30ZmM/oYexnbGLPvhd66ZNoNSuF2CwCEjBHbEG211lxSqXYcQg7bxsovlam6DBraFMFZ9eC8I15IxrBtGLndV6feZkvX7w40vIfCMM+5aIl3XSopsp0DfpIEy42abtYZneTG/6YXpBwTDAmOkQSDQLZkdVpeXLWHD6sHRUXxiyK0VMvY/29yrjBk4k+PnSKci5He3mmlsiY6pWlNzlJpUxZZGkC0fp8dx3fhi7LiKXdQonnu/HKOXemeudNf2VuzwFMvvzzPTYk6yvkebvVE9vC9f0xvpi3xJPBkvopxaP0iR5QbStSB2hZqDy1MohHiBjaO/IER56Zg9u80cpg7UudNS15+ROfae2w2TCxF8SJfk26OFyKTAF97iB3QCx2iEonQZAAoWTiccFYiDruYsGyZSCIGNTWLOYKFnlgWu3cZgdCLo5hg6AYMIKgUiUSnZI1HqYo4xwiUtWIcSqlIWhZgyELEKBNT0GpCOzbR0q5KcmZkF7RoLA3uZ9k1lhcozyjkvnO1fg4AkvNeS+UiBgr5yPN5TkkWxzskMekhkRApqHG4HAEQAgRs8FnYuoEESGqYGbxgTnL13L/IwP/MgPJXU3XyaJUuF/MgwdBAWbqXdCjoRlAfcWDjk2l/MIpMvttsR9AngyAxWlPizxEcwVaXVgyPFTokjHwlp5iwiE+p2lbpAkeJpG7XjY+m/LWp9aEdBeIHS+tSHw9W5tf2xAL/AyEICirxVOLv+2M/zovg1b7lJECt2neiDKV/Me4xPR08nx2iEIn/xldpS9b0a+rjWlarIf1Ac2iXRQ2kSe67krDYqvfFEQbiLjVygCVTFPlEIqWFsqVf8GV7znyziOkWxWyvEuScTEDjn0fTMYsis3Xkx5uZDZ8ngTVmNSOKl+Hd4ZzY1E7G3QSHRW7KKKt4TRz46t/KIPb4bLXkAlsnBrNyti+g1fNTXa22IFkgXjeSYm7DPFnpJBQgY67MgVMuNd9QOoz/U7V2d+L5O+I7nm/nrdnP1akNRNN/ooGMmKr82GfGUMHm0d+8faZtLfPDksXkxA/qg0pNwNB/R+YWuEROle8r6kaBGmBwl2vDG4+6hv1nXIi9NyT7pCnCG4T9VCp4d+nPOWGqyfexWO1zx3ky3vLfwaC5pQA7mOoNz27cvRYBAJK5imvzBG5Wa5DykDWIpRdYurcKHSdrGLLzv2QLjWDcaVXdcNOSVqb+P3FDpNRUupcQGrpUH9HTVsyKnRkF7Oipxs1F3QwwExF0zN/4W3mK6T/5DxHf3X+ilIau8H/iznSvEqyWQC1G3Lf5JHHTY0vfXZr4t+m9BFCsid6CnlGaGACmD+SsXAHR2T20KMWD7+QeFQnqamlyWYEuRM91mnW/c3nKhobTddz1cPr68Cc1ABjbm9wNnkWT28BzpA5hY4P/riTZtMgJzLaf3tfKWoZbJ91W2dcsH3K2E14HiLUO1WGYDdQMIRnItyAUOFknZLEzpN/RCJJA3RBhk0goieQceQISMBop49ghuu3/v9tEk/0fKd6CoucAHBL6FR5SwuDFoiv2mZ2IuyNL6O0yo/i2bQhYPBpkIDpdMf3R27oByYUp+dWvEnErpCZWzrG2VCxZV55A8CVRtnRQPZO8UkF0AbfEyBmhp/0bQAOQFd/RsnJkAOYLhvB8uzKOp2JAOUlOwJV7paHJbnS3xtMuLTIxDQe6pCa/PbHNC01Lgl/21PNaXAXlRQXqmSjGu/HkBGxF6NS8Cb49LxFKlu6iKxwIWgnEVtwKgi+PT+eTMWRdhfg29sIGp+1jqmHXJq/M7mgS2HfYhbHC2rFNMz17fp/QRi4mx5GttVkezNxOridbUYDq2OnhCx7hdv6V4VYzsN7bn7llFnTz36Fr6234d4hsnq2mSpOpc8xQ0Vm+w2QLH78dJsQPf/n4KYq/T7pUlg7odz1Fw4R/QmaRXtHQyKCkv6Yh4fP/MA4y/jkPz4cPIA+i/rlD816yO1HbK5+txdi7pDeUY1WaZx5At0u9ZB76KK0WyYKLkKF3B+7qhv/aOopZmTPaO3fjomHFH5iTDsw+RsNS5WPlslmCnOMd1WUxD33g03IfEIs2TJ16kBGJdhzUmlX5xn1bxQsXviVvN8sEJ2Fy6FsjM2ttcVttpHD/Nr3evYRlpiw3FVYzZc43/7650sVl5TChGqTzYVsNU6bMWDJfCk7S/aTP2Uy0EENEgKh9IQcGwtDslvrCm57RWdGVThktH9x4QFyy8U9B30BWS8oMcHjptqOCnnWla55RSHj2Ar8Ku+ukLpviJLvBxI9M16ERRw/PddaOqP5dJsqrSZwxJamXKmAIqNtxM7OTGqlOr9N2dI2keKp56d7hzK2R0K6366TwB/WU4rtRuI3hLzN/sb59oz4OTH7MhMPji80/IoCqd8l4uAGV1FEllQkkOTPstkqncwfxLbFxdgcBrl3+fOmyueSUGmnH77KImvKEO3jU4qM8cgH+x+I6csdR8c/FH4faxlDpjqwt3fPx3VGqH+kC0gQllbderJJ08CTKCSkC+l1V1AR+fvcWZUZuWA/7tXLVJAAhjBEc4WLAFjdv/w8W+48OrUNC4mwURA1VqVd3JGCZNC2UQJueAUUmYKIgLcjE5nQsU1dB1SjVOB5i4/XmUFS1GkpBmVBlgtbc84VT8OkYtRqA0PtWKJC6GhK69PoyQLRyxckikbWOzpC41mUbidJQro/81Tmbhv16/YZXHT2Ud+W7cTJtlOGpwuxKs2/hnkE3O80ePFuQV5X/hmDmIeWQijTVHmZzjrFd2cc47Lz3mcPK+vlo5SFd2H84EvwYNewNfL4+jApuE7kOFo3ZgP/tAMVwc5vnhAHK6fewPT41is4ABxAholLVKHUSp86W31v0LXUdZfqFOMA52VnKQzgf5EfhmnMchHdDORh1ObyP1IfpRA95auhL2SyQoThbj+3GzoResjVvIGiJsJ0xqBhitDP7FX3g7Yni56b/Je+M1AT6fslcyTZR34I0JIqhSuCOuAHBgp2eLt0uZAO5fbZ2/GenkPa/k4iHmssTawvKVs/8u6rmZHfUAmXu+eYh3QND5RcEb7orj/vDN9FwbdO3RYfpKPOqg3mJxHF6Utqc9ISmwzC6HHm5KKW47tis6zASImBce9KMqUiAso3bCs1xPSt+a35jemd+p6PvF/eLt8HMqUDCte3a8lLmmtxUZqY8c0XOm3BuZjyyyE81eSlliB10wrisuVnMNoTOWv1eQGQzqhyxlo6LCex6HRLNDh3RI9En/prrw1pz8RK7WZMAjUfqBdXQ6Ku8GJTlZCWl9orDKociJS6AZ//K4YYDEBpX7MjZ9ZfrBUxrQpFpA//RT5vOAhHMckYu563tiIxc+T3bCMLUYuyGCcHDnynx2peNtWoDrYarBYRmT5qOCqW9YEgP2LkwHQKpRTKN576dFVJq8nHQcEmtvsLZuJ+Y865qoHzi/d/vs0oQo+3eBtfg3dXyR4un8O7WyWphaswFZH030+1bxUGzD7VcsvXNCoE+Kfa/yBQnzcvELp0POrumbkqaBiOdfHHHKXZLPORZC+zWoScav7N93pONltYeoz3LACDXuIWh2gdUe8fvjSRsBcCIZiCIHEXWbfiGU5IuKzpBGLbNa0pBUKVIPGaZnBwClMc8PCPC6GPMTS30NQWawU2hSMRqV+ciHrlE6udSrWluFI0uY+RZ6PYxYhCe1ubmsxfAAwlGwFjcydoGofpJQ48MFW74a9ukZ8JlcsxELx0olu6bLiVLA/lSsVRPfBDnfFIY98D5qlQEOpXZMHcP1NWnAJJAn/KeC1L2bvF0kOEhfI6pJdVhuqOOVIu2HfCYydHoFN+VCYZQK6ktjAtCbaRWqIcxfn/E/oC2XhrSVvwhu0KGHP5ajCk6rjjvo96DoPLcYl8wIGk+NeAz0Obp+XgcM/KN283sm6430++qFI+zBWzLEZ/uj8l7/2Sz3ri8YREzbXOEOjD82iADsffuH9c3LPprvQzMGnMdY5FLrLPAFRDl7xIEB2Ldc33r8hZ8Bm2VEjMu72ztNCPPen8lDYY0MjKl+ujO4c4BMrqYRvkEwZGdA1KA3YMrSCDEGXN0cr7jmrsptxiw4e+wadZWZ6z+92gKIC8gAZIvdCwgn0ES/4f01Lne/x7GXvG+4rPL27eX9Z/1C8cGIyWBeUQMX310/lXahHAaJCLztrh4ko4be4wjVlfXfA3GLzXmZHdPWrxqTXBimn1H/BD1Rd32snRPIshiBxH5RaxLTktAi4NLyEuyyEFMRoSzxs0x5x0QFOVtsEzhwWxoN5fIQk4pgaBs+A3EHANdwtwlJZp/37by6lCnhQnp6kPZxiddZW3m35lhN3L7MfO3oNGjimEwphhDo5U/kMYU5SRJyti91JRb9+87afj3byoqlN0rRspGf/0+if+duHRc0tOJ2hc6Il2/DmNFF2HCUdEoK5QrgxB8Y1LZS5TPyxHMD2WOrQ5cIsevHpdfiDCgPWkqsfZtphfxWx66GoI5rpr5vs+vxAmSyPglX1FQKpqC8seJya75CfnvA7Ha5PR8OYmktd/Wp//7KQVLr6Z+ubk5SYg6UVCRFIB+lFvVkdq0/pLDxFrsxnVPxhOeQTVoxCm80hL5HFd584Zp2YrLmqYEPAh5ZCd/JDF0PyysjtL5t1bT6zfO2PbNwEj5SF4qcpJEaBSfcCbuPb9AcWQSweY6Myzjr9XGKDl2o3ttXk+xhzhW7q9d4lrsVQEaI392+2wloAJ3ZpTPAt7oNge/FtOuHEgoElXNHcDHp3Rh32O1sTTQ9iGBaT87Hvdti2f++HpSAY4mbxtyowHYJngcth4VUSrRMjsdBRHDI4DLHZlo+JCtFGGFr5jRWDQ8lDQFkczorzwuARISJU98JyUuaQ5knAg1zNB2/fKAS2jaeiFVSsnBZp9KxPKeXVqXpgdMSUi8LHBXJJw4r4gowi+ezIfJEy8Vhv5jqnoarHb+6yvaB4bCmdQEOG9vAtbhxpirYr0piMyTuf4VLk6cV/MfAb8++85yWZH9GVscNV+X0ZkefpFVb22e+P6XRM3TZXamhd9j14tm5Kz57vOTJaGq3t5vTqsXqxyW4+P7d1tZqturkDBcImnCtjyiueR4nitIZvDNegCFdNZkolagRZsQSOgtxbxmCgAyTGsC5cEA4ZEFhZDP4u3Qs14E9B0FDS0Uxhf9LCAN8EscIAlE9hgudv4xUkpleQ6t7mdDdMKBqXFQmnbcLj2+Ufwn2g+P960/d/BfzqkZoi1vr8+5k7xHOynRcanXhHQiMWrYrQPzsko/9sr9JqVJTSgocGahImZVfVrvZLqVYXIm0f8bQm/q9tUBsdzDreEj/u89Jx4q8Byb5cLefvBcMiKsggQUTCpYYzSAQl/uMvrGOZsy60WV58ulX+u71o46nVrurxy+t/HNrf9n/Zh2d+n/pRMJM7YKlWXnLX/PJ4KJnwlA7aMZIZdayrOdxgL3pWlo+xIIYyjf8108koat7erCxtJ/M/80uaKX+02kTNt39MiOqitzxTPXYLNl8GMm7CL1DhN+QhRxUGwh/JDQtWE409XoQBoLmlt0xvYYQMyCH7DZLjZHpYKMs/fqyefrfPnRMnVbXfaTbmy+a+7wq2fFP+rUPf+s99USfLVcYF1SX8G2cdwnY2cTspHZh8++mTs5B5i2rYBw5MROvf32gvPadT/mW0aW6Cc9egD0pQXKTF3YxMpW4/tq3eQCvX4qUqdvmVbwscZBx42Eg7noa7HjecrY45vbBLK1oyd+NC/tdv4onURubtt/QlY285Jw4ufCWknbY7gAk1I8lXjn1xst+dHNv9oXk8Dyzhh+xUigs1y0dtHc9rmdjhcT+PYFNl1NYh8eOs8pWFXDxbSdHj+uvW3aE6Y3+z/bH5eL12QDtvdJgb7ChkCeXBrUZjxlrM6GD5WkHK68cHzxY5afsyihpY3nOn8PmHozqa+U6+oX+6uNdV5U1jNTH83OzRp1jBrEV/zn1IDLN5dxn7WX+/YD2NBXAUmAM4zIr2u4X9zQt6sXH3TefbPfMYBWk61c2lJDnlmzalc+99qUtOdAd/8f2TwZmhQW+vKBfpkjUdCr40/e6I49LHC4pODqp1HquAZJ23493fkDyH0NuRgUV5zknxsvbVZ/Lso078f0xaH5oo/xvirB1ar9QmGieCVySYNiZsCWUV44H9Gh9kz0C99ZVIM8XKNHh1vtfAf4Ck7p2d2eqGQmJCzFylOAztxq6qPhOdsRl2sOy2h3roG5hYdaAdhZ/3EGxQzT8LD4sOZQo8F3RqXhTVXRk9J/vcEks1V2kD5z4C71W3Hxk2jegxKymlzylAdW25mv3nx+OZqEmIdIGv38QohP+4pRThPYEi/vIpLmaYW8+PUUNC5jjr/58vMIIulAEmLkRS++Bf6q3DKVIy8/Hw4gDoB3jhef340DcWuol0Swcb6Xl0XTtmwabrcf8NAkTY7OxFSN850X/rYXAEauHeeSBBWbV/olSVy59mwjqMD+RuKMvpFS9ufgoFz8eHrN2Aj/LgrClfcWjSpH+z4C6PT4N39X+pR56sCUsbLhWpUCj52RNSMy6tmp50+lOp0gkm9eiMErXIrGlCM1QSw0IFi48aKSgwdKRPFcM37DbntxW9keuCwHPDY7RgqA17pSMuEd8SfeEcju/AX82N2L0Xb0ZMiOXnyU8LV0kGiUYl94PSMRnYLGcQXWPpDdw5e2t9rR+bBnvvti1CwlYD9JnzBCR1LMaTo6RXOUaIKgBjItx1ZhkS8ECGi7C6qwvaO7NAYgSW13LwSCobYVw4XADRAMKQQOgl7RhxZqc2UDzu2vUzXVnX899fWV63yxU7C+Ur3M99Sezmpx6t1vgVn+Ptq09IJ4oFQf/4CsVqVS0RQuYXeiL8F4UQbWaPdNNQVCmaDDkBEFQUboMMq7hSimY8UtLTCWLhqlhtVAKG/oSMYe4iiOQNrQPLEenqPeCotFwTXUjBWHIciXTQs8BUh6ctLS9Sf+Yw9/vOQ/2rk0z+ytl3w26IH7C+X2WkwtZlHroiboHpHEoyvkBmjDjMXoWswGTBF68WwDTIm16HhMbWAWGSY5kWDyv/x3pqqXKKgQmom2QRDahp4J2SGpe4UEvQoNQVIhtEyi458FnTGhygW8ZQxxUfOpRxL9ZJ8UbbkReWppkWX/wriMtEmpkczGvzE1mPMnz7cKfQ1jx1xAF/lKPLz/nC8d99Hhc0cPEwt6AVMz4rIKlS9c8lAt7Tw2GfJGlKJSoCYkYS6OnQOZ0bPvN0vAQwT2o4cVdQhpEbY4heWHu/IhEySEGxlEBOPWuqNTXqSBqNkIkAiRHDC1zu4RKlVkhipCzoxIVTDDJfIS3SXXH8ATuhZ+jTnmEpZWp5/fGHy2nr2nEY2+a0ZMWXLVv+lZ1pEFPlOS3Nc1B1RmNGV0nJZux8xzXv/ClpaalpGGTQNHZ6JQzDrcg6Nccwo5mzrHxsWCvXeJNm82JkkLW+A6rlgSJkVfk+gmaJK8yowfrzcXpeyeG5WWOjElEiiQ9iD2b3YzJ4OBnPcLPBUJo1QTtZnwBmr60ej1KAmSgBSj1iM1iwztJEID/hDOFRgPdPCuuEOXIvpYfRTQPOg3WhifimCdHNNGacOsxXRRujDuxlBvchvZ5CRGaSHxMW9KG6XWbcXHIvmmvzHtlHbMI8ih0d/G86RKxV/AzcddwCtTccPBNxkaeg6jHePTo/xWUSipmKkwnWGI5/shkI5/m8rI6ELIFW1Dk8fbDjeIUD50Iyx1BtoGRaFtbuPM62hINySthIZyRYkgsZUqLjMH5tLAklZcMw6oUYhotJDJCcaIHVb0hvGc+51RXRNlAtEqCW5xSC4/O9Mw4k3yngLL1ZAriianzdSStDNgGaBLTWbCcoo3NZRionh5HfPaBEOp3r+hOyVDajVFS21B1xBr0eSN2wRWwVYq0TWywkkxUSXSLCpMaIWEQt4oWaBSGRi9B4HwStQdKz7mA2FQFsWFkLRvYSIyEWmT2it3MwLQ8o15uA/XxXkWH8j7n8toO7oxnuYF2dBWyIa3QdFRUZCdYIfuoe3lXrux7eRuTHQSEmET4214MQA3S6cQgUyyYrvJ3aB+vhc/os4xQo8rvbViFicGh6tGx5vjY+HsxGxhdg1pAV+7lkmo/u9dK5dpdup2ur1ybVC1aoILoZoJExbcV1hnmv268KV/CroFB7xmwQBH6sPmOUjn/L91aDrtxk3Rr/T1zsjwnsRF45PhK9GFTJwUOnNiaOhEXc1jrHSGRFXVwZjB4OVfRqCsSobQIGlqVjFEerlGi9bKxAQ7QcvS4gu9U5E0E0/vr2zWmRxmVgZnXxy6kCCRaRbb+5ru6Tg5U6k3CtRLldAxCGigH21HR6HDQBsdDdmBBvEV7zkghsIBRXAm/hZArsOCsCjCMCEyK9bHBwclZqHRTDTanEuk+Ncm7TTHCodivOkH8O8Jikp8ukcVZE1hpDMfF9yCHiRuCszULziV6jo1DMXTMP5AJO4NjE58sneQJEBpMp7k30S/S9wYlKFfOGZXeWzm1txV9DHmGAFr+U7PMWHg7m0IT8M0JtJnp1OfrohDoAkZQN2RT/wdyHWoRBbqP0PiL5C5JCgcCj+GDyKM4GFFdMqyFN0fG7S1jgn0OL9/Nx70E8AUN/bwAhNtjFTG9fzTX15MbjNjb6qqOrbWIQz+KEAMUIt70FOZ1wrOfH6hsw1QlB8oW5G70pfUyA19bouw3lhRW/c866cyUaYOOCcZC3NCAIdMltPFqc17rqI8k5xC+PPP38hcUe5jTcxPMAGlMRIAw3Xe/sElbttmzEBIUnKYAQA4ReIFvMoibLWCd0w4Ha3IAl2ZYGMy76mGVfc0aw2jyIihLYqwJ1slUj7gS7VAbPA3SGbMuBAuUEmTVU0wEsXHCSKGWlrGVPfAG9XY+Z8A3e4lNepKoDaEEN8ONGPwuugJVUHGqPqIyIYo+cakyYUQbu8DYmHpHr2xAOPhjxABr6Rk71Q8eF2YNwm71IlSbIEQXYxZUKKmi7o6dRCHnp6JmrysHWOL05B3LZp98losX3Wyl7HMgELPE2zYhLJBA8hjkE08sQRdEZORMxFdEZ3RFVvHIO0TuqnSJqzfIOmAMGhDwbEyxnutmICuRFfwpvpu7vrdEiQGQbs+AdDIEBLBQkQhtaC6BYGkRQWAEAEQix8jdj+08JYRLqcT2wmV1z6gn7oxtLIMgrfAAG4bG7Hczc9tUcjGgjk/Y6OSBMpBoEBdA7BcFepEjRH2wo1bTH6tSPZcZJFPqjY5RZ2uvZLhk6rRpnlnTMhzS3ZNWlninW5zKF+Iuddupt44tNKaJwgTlHrlhY3n+bUBtf6wJcaxxhf5Y87gicNgmE5la0PVXbv5e8r4wh/J/uN22qf45VnFsv3Gsmt/AZzpFPv4Xcn+P6rHp/4oMlffndFqrDSUlRkqjS0WZh9Dl7cI2qQP+Fov3OcTB/j3BUeJLHxUL9gXeuDn7+DwOPLDANdXtZ1HV8qTvs7+NdC/2XR4qt+Mq1FT6OzS6CvDX+wcQLduLplQE5adzf+oh8pM+N4H+CE8Eao+GSW5YZi+HwsfiviA4F9VOIc32+KAA9pS1lmRPq/Ybw4m0jMVvY4Y2RQ8fhLTrEyLpIol00I9E/EjknkYxo9XSjPXVuVAi4k+eUZiiW+pT89R1C2unPG9qG9jbysRS2xdva79WR+gau1xYpqVAsj2tbxzaetYWh/QSOarNnZhmzS/G4NQj4ruKf5//l/5xSKw9mK04xbZZAw5F17sHnVbqkmN8Cw3i4dUTVWub18VYxTuOAyNtAtjzUvNwcTdhwON70/LIV/NQAsM2IlJeRuTBLAMYN4ZhegixpSefs0UTA/NskCjMX4Okz+R/5K+WMt9yl73L0n73OxVStt/PoaEjs8tap53rKWGdame+/lEflwRVxJZmwyzbHB8gcTbwjCSyLhHgLvhh3r6QMYPEo2jLVciuTOdPuhoET/0rknG18KDqGp+8u1bOIO/do0rKZJPCifZGoU5SjSfaCHatwa/mu5gw78Dc11Og2Qh2ecNxi6g6dNt+rQF1FhGAkHRw1gE9JRJNL92kf3JApgV2VIPD6CeeO+Oj8jErsbH7ZyeMVD0viQ6uV912u581d3p/uasYO/t1OPfXeP0yH3G85DfWxw6QUQVAdapNn9oVo1UrFvbr0WNx291oCVcSEGjKqna/sdErEPCor0s7s0/FvF5EybxeGtQltiz+49JzxwCk4jWbKtP0Udrdy6aaKEMWmoNrRQVRh6ATVecogLUuGKmWS1Iy3Nmoi30cxPtDC05/vqNw5Z+3baP49QlhxEBMVSjh5SVAZlLcNtuMdoON+OGaIO4Gdx91gM4OZv+u3sWE4Xk2bNClYH5FMkjtr7eJNmPG6QOYhdasc/wlynHUugJYqO5Pm0e4RbmaPBCgn9haTAnnG+Vh+RhIMXbcU10o/yP7XWXtX4r6ttp077P/5SOT/UqTBjEAY/g+3CRm2ai76dbob6t/1Q44bSwzqOe29L2j8Xj8G5Jh4tYOT62V+2iCrezwwTKxxFtnTVeSXFYvwY1U2tUVFHm2qh/51TqfWcOOAz6adP0czYtfgQGCsFvlbgVHmogFqYajBCOESVhqopkKVOWsZS8H/MrvwvKpx0zsEyczKDxt/JBx+JIEVxtRdRa/JkTyxd4N1Mb0CfLEyBRiolTeEw/KspF3LeJoDhfqauh3rQz0qUtVxzACFrHSiys/0U/UpeqAdh2hKm6l7piisb0AmIAKjEc6oaSFUABpvaDDIDUCHxjgE0bZNuYFivLxgrmzdNNyFmQUJld9OpBrMzgUojKM9UbpC7o+tlo3OW7pbYsjslUJWhS2xavF+QgzhSKIDg/qcui645IV383ACwpc6P14AIACIQJAZAQReAF6Ifz/XwH293TKDMdD3AxzFDMCrqyT+dq7WVCYtbS6TuFOUC9sBLQCY/HIZEIUl7Z0nHyIkIEKkS3v3yp1uKUfr73UAgAsEgEQKlqFfKTeXv2rGXd9VuLOgJpnTr6w4IpgO4xdPNmu6PEoWvNWmyuwZi9hINNQAj56KXxAgoCEzWxdfKGI+LnF1+muhxF69pv3OimuIUuPoqPCgeqsdgAMZPRxzQJ2QuZ/fJ+5iFsrm+7PYXJnMsYZGATZ2QeYFRBBsHryUoLZfqzzmQm/f139wwrlcXLxoUItSs/AcVbUOdVL50t0q35ws2FP/ZD8O5MB7nykHHWf1JxeLCSJL9fF51UB9X/q4wExmW0LBZR64wx8tVmB8PF7PHoDR+P/uwFf0+9KvBkqfTmopJUtObgR/ea6FRzibNl42V+wvrvdEZqy9aL0tLrLqvUQK97Wlywuj15Lk9uZN7SFq+ZiPCiI77dTz1/Ll7l0XZw/wv3HU9wf2wcigKNlXzFBGGRutLeQO9gz7x2o3mzua+4FTUrIOzDczmQdqxKRziE5xvvnjSf/bcPFM/MiclxpEVjrTgdAu4bDRm1cB9E9sEGybmd1DpTraW6UdGsGlxQaZzxiljMCybn8Su5i9YKCuqYn6Di7kLqGcMFOJOy43DqhAxXUqqq6GdlznnTcWMpem4z3+/pcUnsfbXpQgUw1ybhW31Xg5WHixdX5lTN4UbNbolPDHSQ6AlosdStd0WO//R4fntouFwkuvUvsvqlk7uZbR+otOfyBHBCZp6ZiK3IoLuLwm5X4Xf3Zwd8/S8/NNgxOIwfFuIYkjvApEVBrR42Jy0IDfccL/NMTpxTnzXnFC7LdyM1DiSdGb3K2yVqPz3p5mpMIrLx8kO+w6nXe5z9qU2JWz+Jvmf0wX3C8TPhbZm8j1F4R8He16ccHB8i4MTf1jQY0zeojpdsnrz6ZuaNNhv3QyQzGSUydpiM7QtYaIfJLGfkmK1/6LwBk6G93XS6UjQ7wdAG2pkgDLiZQC+5uYu5krm7mIAm1u1i+JPyABhk/rMx4YWiHoJWAUZgEcg9NIRyjRmgEGA2EQAKEFRSnirz5AQChM++5dHlkSnNeutyz0UOdjgjN5OnrgtSt1nXJfXFBOgrpmZkzPhVcqxRgUqs0zEDSKfg7Tc3TTHQdfKKo5EAIMaEA+rrRyW7GyqypKK8gNEvrgUQZdRXVNKSJSQGYwMlR4LQpme3gxgI6dJpWxUCwhyE7Xe4tXFbYprceuX0w/Q/9WlXEEz/wYJniRxihcupCCSz2TlhliDDMCjwQUCqOywmItsqXjfOuYK4T8QzO6AxwaBUDhBKrr+RnhYGhJV5zvIlNGoV1Ub7k2ZLf8MXU426WNnJVnONjUNbCxvqGwYlx0PK97/iqh+lv1RiaLvF2DhLUEueQZI0NJqZKLDgj3eu99x+hYfb7K9ZY27vwsXr/er2xvWXxUUwEr82tVVt2vq60ok2VPffZU4nHoPYCxDxai5Vo1mx9HfGrZ7kOUKWt9drZ4WFsOEtzqBD2iQZJx5rlYD7tLxJuku73Mu5NtwDcEH56r/WJC6/vVV53S9Y/Hdt8ityO53mIW8Ku1w50pn/57PjvpYdX14i6WIHIF8EUuHEvq8dNv6S56v1lDfYfovoivTqvefzXoenbYm0vGMbzyGP1crGAgEfs6Eh5+P45v/zHpv4WehxpqZ5I79aR0cVfYrRlpauO7jpy54xq7J1AQLQn6agrYrNG/c2aPA2ZIwxz+XLFOcBeQjA/KUvqwdKQqAcgmUFoC/ggtbY0W0GxU/PsxzYdiOZendL234TQxi+fpXzf49/5NbktHFaZFzR7BVUwNh0+wktlYst2ebOWXfVfsDdeDdIdH4E88+K9wfP7ReUZ7ljF3Kn1JyguIpv9/IJXurinqbP086VOX6SF/ROhqtuVhguWmYkOGYvyTNnMDdEpSS4zfEnpoXGWnjoH0PKQgkZinNl8xSLl8DHJT30bg966s5U7o/z+3tmTpwChYZdPk836Q4apuHxSlj/Mm1bnehmehkFVf1FKonBX3foWb30x+l59R6Vn2gsaNWfSvbKRfminM0i7nL365Lav0oCBDxZRfl1lA3143gcce61LL/+UpbVUloGQ+UxSMmC74o5k2+7aAPPRTZxFYDGZVnW338dtvxuQl12G98pz3zxd/MKEmPDbeKztM0qcs+yV+MaXflZbSzcXlG8AKn2WRBi+vSf3q/7Pi379b6Mf6E2+60lgUE1AdADsCl6MDxp+a42VVr+QX0JhjMLSC73ZST4/G3AtQYZ+Zlnjrf1MSu3CROVmQdOgpF3V5UOyHPHJwgTL0EzUYSOOZEZZeizb0zGDBgER/wOcqBWxqCiX1E9PotFw0jzIB1jJDUs+WNAmmDy9Z3lZ7l7CIhpXt0D8D6pmyuMbUYDAaRqM3aYG8bR5B/yWEJL+xhmUDFSWPzw9UjOoAKoe6sE5SmMIcYItEnK8ET3KfoYbgm/wFvo7qLb9ISHGIofF2yQtJt9L+pANThaJPpFdy/sTdjrRMaYrE06SIcnjsdDRAHWJXk93RPlOi/lvBtepUG5oF37Uwe3lwE5j4eXSTCo1yiMNGo8Y1UcbE9HYtr/VZgQ1680it5fvazfRc9BGsUnrZMUm6Y6welCPkayG/1/tA66vnnv1JVIaHJ1mIXBoZe0EwfWP5UufbUCBOXglvKdyKhG12MU2nFMdgZoMQlJJv2ZwLr0GBlBEfsAekYMAlDyI6J/wvxahDNi2MAYk7dJ5zKgrWDKZVqjtl6jKdQ1viIQsP03aqcIbUSvMjcg8gmECcLgOQPm8wl27rzuFCSIgPECsKEeNaeQ69eF/mokNxNLcH04DExM9wQgM8Zngh3EVqIj3Haon5ytppfYbJTu3IGMo/HOyw64hOu+DScGaAmuDzuDlocmzdgBurJEiCiMf+NVoQCd19WeHrsBVBtb9Cj7SXVW1Fb19YxYdwPIYN/QbTcAPf0gcnUgFG/z3Dlt54QJc2a1mnLFkTTMVdRr973gTC3CADQ7P2sVWJu8iO4YmuHONZHY0O8lqtAWHXNa6X/x6HCpCASEbvpXIj8EBrrGRQAUACScIbrpol5tIPkAQCuFNMDkRVU4dktx+Bhxa/ih2J8JsfvUtV4FdyKqMtfFd2CKw/l1m6AbXC/0ywi5yOKtmcw9MHU/deavVhWrgo9WjRornls1sKO8ZsYZjvZKQIPgqlQfPqboZulmm5pejqbGs1qiL5DpU0j37iUyJRs3lpdtW59fsD0z2qxg/iyYTAGVIzwsKireq1sxOk3Xp9s5lgxuTK+6d1xPv5qfyc3SFQyO/o7xpJWdY273n52/OTGUcKmB5J9jdJql7x+4hbStvaIey89fCJtQ5oVilA9KvGXLlCmrQH6T3HP5Jl7mSbI7aW8Wb8+2dDbv4e0FquNTWoDJ734K/jWRjFqcoxnNbe60LazvO5EbbcosNKJ+E5YgRbOqsJTnEMM8Svw7nGSj3EogoFqino8LfGZioR8eHMKzibuj4L7iTJuzGj+Ioz3E9me+ohWR4kzBDVeyO+L+e3IkfjFKnDCqFqHfhb1+eSn0wb/lkkEJqTodBPtb3suIyVjDzsdxUWnkWZrzSWAvl0XuXwoNbt0M1vyDypDZMC4r3YWhm7NcNjrAWhoqj8xtOBioKoN+/XRaKRazrIQAMaQ2FtiLGRWcNscSeflRQXW1TVFseNGexZMNxWZowckqmiKSI8ovcJXxKwQNMEcNji+PtPPUsUCbb+6Kt+Zj0FMD7KiJubmTgB3Sm/+ZwicXKV2mpg7h4HNyL7650n7ufFi0m1YCyNNw0synDrQeU6f3tgtX2mjADald569v8lthTqzkF3K4UWUE4sttQ57TyeEgFXYGrmebZluPuq1tHWzGDzMO4ZtnEQ4xhgjNzYQhxoVpPAt/gTGMB+E3r2ZFSDIbeV4oBHNYtdpw/oJoM9BrmospuS6Dt2XpZ8kB4Nv24CW5NvWqIzWSCw1+GShcmWNehygaHwB5RbnDxKQLKa7Kof9O/oMC0vgX0NYv32YhUJNQ4vDvKjNIH4QeNlw8dkTcnOj8AdiQNN0BVHlkCneWsSybEuqg9W5yZ3M4E3pGXJZNZk0n+12BNfY24jr1nZR2hBhs6JDbmMBcl6EjwWRAhkkyeSB0QPE+C1rzLNGoblQ/phvDvUbDtags+nBhE1KHHhpDwpf0pUhGmVD01RCyIytKvmpD8empR6frtuVsyC/Tjmwy1jzH+lWb92zavhnN25izrlA/L8rX21/2cXFxH3XoQ+PwUa79Sg9/wOGV+As1MMLqw4a9rbectqgvra20tHivMva4lAoO3Oxeva6VCAGAIrZu7O0TAXPSLKHQpVh/QPdf+Wfwk9nLCz6nknR9ztGWg085r3V7XooIpEJTe0zfnsSfMOuxg6NasxguL29PcktfdtvlhRbnNfli0nAyWfRyj+41x3vgRZuvyHhPcz6WQJCvvJpYjHOO7K1c/GrWusq9qlf+PYpyEkz8MczFAELL7oxz+m7fNAYIEcOZ0Dn5JqI5YBR92sdnnXKTpRGo7rbsqxih3Pcht+x4GfeFr9wZc4Vb1o0qpSWrj7+TrdBXI0/D1WJ6VzIG25HLx7D07Wln6mgT8FfaDvptWi3yp1iWAWoHgHYWArjy+E1HmzysgESZKzrrFfUVAAjWtf55YlP4ZAx8KjVcxYtgs8L5zAXCt6IForfCMdE9Hsz8Cn3B9JYCYeGNBWNvWaK3+reycucHaG1J6KxgR8CAOO6qlRFHw7G3I8nRiICdyOvP8Ko2qgJlV24GbLVQE60zAUhEU3ITI5MkhqdY+/WeF7HXSncnT/4wOm5u/8vM7celJy7xzJKwFpaEcLNu85fHzAB05dCZ4/9eFBL8XXaSELoXOcI3wpzHCN1HnqNZbs0nf+ulO+t0wy+zhrJBJLqRvD2SOJwsAN5bt7sVFL9KXJhFh+ZeRe0tymC6OgedauTzdWd1NFwOOejCeyhJkqPQodrA69+0YFydlyxmRiCg2fXX1Lw9Tnej/kJo6NHQKfcmw0Awkw8QFXWKcjkh95Gyrpc1q5ogz7hqPCkIclS++8KTInNQ1QMknmQnEa8/ip+wOOT4GekZcTwbRaCUDEC0PpnzHcxvaM/EgAmJiCWlwoTNxnZTJ5LI12F+YlvlLjA41VGXywMS+HdxNM94O/1ZeO/UiFOYWN8T6cePmMjjMLmyTqYVh0uKiVp6HuArqJXpP2xWJxErmUGGV7i5X2080laPSYoi2Qkz2mst6F1/y7bcNYFaQvaQXcCSMkHKfGSL5QLE5Zk7JsYs574saU+FzkOagWwaYOAuoHzJl08tY90VZokkRuryJyRqonxVSg5+OX5Vz1yLnAv6ptIiQDeQoGBWRCrMjbIyyTxtOMgByBc35XZe9U6jiqeQNhk/6sUolaPyQUUewG8YCV7g3YKbvV/hYRaJ9sG1y7a1Qgb1XB8UbXu9sMXlC1cQmVIc9oV/jGUtlPng8qIXfOIYcXGucJx4nzlGPOBP7mWI/rzIilKfjonqAV/S1VgKoqwN4tes6iLnaa94/bGjYNSXPRodMD2ihvb/y9q7n25XzmNBDKQldvnr0STgJYcbkreJ9UYpSMqBr9rmkTCbtJcSy5TjTbXMHvRMzP85nZKst4qgakGP8YtF1ga/ewPxHiGWOMZ62xMh1LrgSAXEeyyQTni7e5D4m230QDwijrFHSW2QAsI/K/GJEmwYW63PJV8Q7zTb1Usp4ZSl6u23GiiaHdHse+zHECz67XvT220/GB+kcicLhSKjBaLA3fxkU8ImZP0j/OgssQSRDKD7EPdK4lMAcbbeZkKG8/chxWqtue1fQPKahMBggXgR454wmBYN/DCTcjh5Ti9+dNHqeTYEtBd5dbOhNXk21HfAsReRZBF9TBYGlHkbXPJVAYWvpEkwcXBmz76jRY3BNmW1YWXg1KfnEPpE/Om/25sI4Dh2Kf24oTkgbEln8PVyV8ahKaxuadSyQHFQFO1fi7wahb2jfPLHtmLW6W53nBGjo1ehqx2PckNaDz0YgJ2LKT/uDFMEq/ZsWHv90Cdh6beXgmRcBTj4MKK+aTz32oMWpMlFCI5SOGlW/Bg/IU3D11Kqqiw/yxcnS6AEx4s/+XFalTOXzjErWJaxxQ7QhqDC1aOz1+GPYP+8y28jvHHocfh//gKKlG/ASwTG3yqVvGX9FknN3tq6t+F7I7Ys37LFJdHj2bXp6NGh1683bhSLE3GiuVpGgSBVa6V9eeXCF2HYjUNFe5IvJwNx7k3R+KpoqGon56Guuoq5suOEoo61W9GmODH+eK+mN2GDcoWSz/rj+cZh27aLqjyq+1yI7l65CuqTWippGubS1PyaxHnnHDxm5eXUAA3N1XRwQ3VV4AMw0n2gugaJQ/2R+FzZRpjnCoWkVj+HHEFeqp9bTUU9VrMsFeQkdc+Nk/jpkRUnivroDlGrCYiSXF4ld8kqYT42MTw9Ka1/S9Avuv+OCYuTUdhktdnS/Yj9hRAeWbDJEtuuaM8CMLEYIKtcAeivfJnu3yyPV9lCdR3jHTtXmnDTz4I4/8hRe7myWvGhirfZ+qMhWZ/9xPqCTEYZY/FcWRoz+oIaYfhwyNSzXOKYAFqx0URwNkv/ghJzi7oF8xs7EgNgSiYvWyyWsfb2lmSzLdkPm6ckJejO210+UNGJdV8A38kXlMUH55WtX7rpVaxqYY2Ob8MW4byj3WwS/6ExZ3NfFJOTqZrz1s4yqr1W5OWVy32zmltugOGSkh2WDXWKlmb5/ZzbOZOaAX3Hl7GZvouNxsfgbFgDf+ZCVeyTTUvXlzVby7wLVqJuzdoJoG3eyvZTb2cFZMZcfUg251SmmePUxo+TQPOkKwi4pDlGkCdvKSprbt4bmX4jp6yluWU9RYZDpAMD5YH83WC7JtPMwauyYd1wdyDIjvKOdTCKFdhGnofwS4NIqDeSBSxGH+MZPdc4Mvroz+w9c+dv3SCw4QULPW7rHR86zl9D75OHM0A28JJwjf2T3cG6K7MsLmf8s5xZEKvbkF8QqSvFRrAbczgxMd8ZsK2xutgnhI5O2XWuzpcK8CqhRWYLScLSyBbf3RMnHQ9ck5EgroJuXo5PY/GaHRpYF67Gj5cHNUF5VWtd+L8c8jOUO2x6chDIrVcUCoFg1WsctruubqLdsc0Shagvqo9vSfF6wM+a450bc56GPT213jLNAUdjRzePbgJ3Pk+4O8G3qZAwuc+msifcr/TrXFDp2zkCQ8BHb+l+n8P1ZWUiCqCMSQA5VrTfm8AgxhFEpId4T3DVozwFkL1s+YlU0l++f0mi0fnG/X0BR9tPtoGtnxWkf4iSQlr/QBMOBR5g+5rQS4qLqNRhsXbNoMxtt/lLjYWzI/yda6hc3FJbkltNjKzeGFn/Ym5c//IiG/658igNnU69oc/I1rG29tlpxU4woGdjStv2k0V9kveEft5sIfb9XrU+QjvNvceZO31ac/7OKWnGEfKD9SIP4bQ1qe+pG+75XclV/gpFWddId3ds7Aao/c8dNm9Iz2pTdw/YeZO1zS99Ij1oPy+luBsH4LqhXP24KkjNWPszCLx2bJC4ShpqvwNt+fkbvDrzi5QJATFqcuqV1HzHC8nuDa7jmt3sWfn5VvmjwbVOpZ5JaRAssliWeTQ8+Ms2vzAuj2TzSk1Wm4nj+k1naMgURo9Fev62+UD07FkxWXRknYBEjnlcAr6JRy+bXKWdOlKeklqdYqV5GT2HwVQMiPWEZ9O+wU4ZGsrIRPb23r4NHpdv8d1SOurreDOke0npHoWlM2Uneu/iTxDeEk6QRogn8L9Vh2dPsnlUvZT/f7p1NxCGwcGLgFvarLjYKFouMSVsw//G7yK7KSp3r9Ss7CkeKopW+q7EYO2L+Jz11YAuNtofMjpaMglYugCBBFk9Gq+Qukgi1wy7r/BdEaotj9e6UGsJv/DLCf+QVueyuz0Cdx2QTVrhoVdOc2bp5u7VPVkpPfl9qKjLUAiMlAcqfH3nz/aZ7+sXiL+osn4ScBF3knSRcM5OeZ/QyvgS+EXwxffLD1lZa3Bv0BYrmHn5x0+/OxGjYB7jj/OrViXU0f6x/iDV+TI125lJFFE4mSK0ToNZz/Fw3EG2h+0OcGgugg0eKhgSF8VflSPXQrdIykq8Eb/YCBjkIC7UdZTzz+z4j94QxcRq66WR6JzWfIO8lu1ysWrlE7HvlGKusGLfH0oPXdFardpWLJaG5lqwizMiJHF1794Zyf+wld0I/WOdgSB4qQQzr3pXGDgXdsqSLRMnqtFMwwdS11yc7F7dmqyAfP1S9wV6H1XWlrp73rxcLu0I0wCrPtFtkoWOnnTRyTquMYM9sN7n0062C3z5T6ad98YCbW/nPJmdPvgGr9zS8HL/ywaHoY/2/9UApgpEgdAGB7KsVD91cDY5SA70G/VTg9R3JzKiRTmCnOOlNwjkF1SNdMFm2FsrmSNpkdjjrGKORuutaQFFFMTJo6KWUhzMyXgXgxk62t1DZWdgyozGMggYgB8907Z+CQ0HRiPPQ5s3N0SCG/WJPbDInwdSdKUcQ8pX3uTPntptuEiS1+S/8A3iJZ3/Hhn33ROvixU8/Rd87sjPZ7lc7Fp5Vju4XNa97JfUt5M81XjyEl9VvstVy8of/CtZLPpWlLJlixiPNnBuPgucOjxcXLBFVxgI6b+C+8oRpWrzYpxEeT/rP7caB+WQicpxgBr99gxY4mLKrVhu6Oj/u6wdONO/HzQxuzQ0b/x/B87mGib3uUTYB9mrCMwCp5D4INSt2OhLatAVloxH6obMX6xn/ovZttXo/YIPEMWI82dzOphJOVIfYz4+q1wvuAnuz8hUubbscdc5U1spcCs5esyvvTk6IDLrlsDtQsB3P116BHzD5K4P1/NNN+771ZDu58k+tQCcIopDG/wENa+RCfECnRKH9BTifrA0y4cffEGYT7ocDOw93Ndd/Bqa1omEa3PJi/KNU/8hXrdyx2O3Yk8j796ODl2zE/qcK8EB+li1e2Y9Ozq7iFlPckQYRQIzNBjCYmVGiS8jYGnIAKEdN+u0E9qzEWQTd2ndIjBLswwdBOEwsoWaGeQpOe+Dh3YUTD/DY3iqPRkcwFRjl4/Rji8qOZppPylOSBCdyA/oBLv9ULCrNZpJt1VRbSk8NSevoLgOfLOkKM7ReABXt1+y5Nd0ed+852MqefrScYIHaqL6mEcaqhh/f1aVkaFRBcnDk0wBJcjDd/+CIwBRo9SxLqcSv4Hnyp+QtyJ7+AuNPv+vbQf0XGpwobXcJTCTzRIXK+7Q00jBtbAu7X4LSc+NXvafKliADEKStXM9piLvRjz85m8EJEmLnQfDhpxbnXOS9dHOD8aHVU4RHmomxrNNX7Mva9+7vdd82F5Z2NoZI3jijQQk6W/SJbIRM44H0gDmP0wi3R+2HGfVQUBHda77b/t/kfaXrm0vQVL1cFkh5oJKh+4xp603IFcyHkEfEq8FVHp/cLHhUZ3b9OQuzZpIfSxz0+AqANCffvYHvqgTT+9NXXdONA/81tQH65cXLK+DdR/NNMVVtqSIUuTkR4lm6ywdRujiz1USNBkmdEGRRiS6/Pm25KTktqWbPuCrsflAXPnDhw8QPhcpV3bHHz0i0qkPamrBtLAXgoxZsG48cbylbe0fa0aLN5+rPweeplFl3NKRpI7MUAD7dTDWheWwNbDkll/M3W1VWAfpTprW9R5yaAoE+8kFeprJWh0h+mfzc3VUl0oe1I0F+67omPznolfzRpaE8thnXjzEWbNu42nxL7iqvDMn5Az2zJ2PwLKBiZ1bPot6L+oz56dvMmX8Xzjxsrjvus6+aaj+dEa/LVwGOIwZtETgqiLAoRg/3aNvSawD/wXHv4BP+yLWQQ1hv6NHvg0su0uLnESvMpRXzt1WxveNf1G2Rg/XrSLeMfwOmxIC0RtS1nd94muk23r2frbgF2oocL6W9+CtwQpdn+Jp9bW2InVN6tTjUpUfWpAOhTKCeLZCNduIu/3xTaT9wwgwRzcjS2vaSykuzL51ZC3yRK1wo6SfSZH5AlexXI+isYup2yPJfrSApISBKfzczt+Nhg6DBlMlOjTa2sLPxyT+HIqF0dPskwRKZuJjgAO3TUN2HqRNJukbBpcxsEC6a6f/73mC8Q/4D6uEqUJD8utU5+x183PWZT/06orGCucKa/siJ3lT8eezw9+al025ZQM0K1HOZihAZleRspQOBkPGBq7p13mlMwfuYaeXorCYbEoepgvTR95+fFP857I6eT3h58tdzglxcjpG2i6pG4iwW/4G0XXjtCesjgraX59e5NHfM+gV/31rhV1+Rk7cK8OcYnCvnPicH8eKP/9W84dq9cghwWTB2PZIg8SWt561Zu4mUkdhPIArHh6Pnq+eHBMczVUe04Zqnk5V7xT4PHCWgLcUYa+x/mAPZkb6Jgssw943dFnPj8uugwTrEDVHcHLqnK8lYcAT1r1s2wu385qNI09/Y3IW2nn9iIj73poWxLu6dVVWQ3Bqz5okMkSuJzsM5X/f8Lvc1i4WfdedrcPKheJUs8RSr9MScB2iNXQCHbIxLbQWlNZTxuW8VVGOVQqSnhV0FLetmT4rZ9h4tIPWkaKK4kbDDfCXRPE99YjbPEe2dHf6qSOp33XScjV8TuMkM5NktP+CHFmy3enXgexHJGHO2qD5jhzf3RlJyHyCIhmbf9nLT/fFy/cpvqccPZW+S+Yq25V+6miKeZe7cHY8M9HXeTJUxmWaL8xtpsq/R+Jb1wTPc4znsBIFRXxSNvK2rXhutQH5hLgflqP1kK8D2z0z/8vMFxEvmBdmr7kezvPSrcgNkI8jy4cOcN76lCp7vVc2P3DwEtmco/hq+9ylCO0mMdfDDSgOMyu+FRjMCFz4FiCvwsb3H5Tz1gSduWELcNgdzaBQyrsIPtnM7/8wES7w2x7VodB7Gb3wkAma1iHt9RZuXgH6+MfWmro6tK53WcyBFOTXbzpF39omrfRDSq6o3LVPkHL18B+vWKJeUgHNf9OBeSdDb5ZQ9YYgvczeNbyl7HhfYK1r3acrjLEyU1CD/btVZzLrvy9IwrF9m1x9w4nMJoq6eUpP2nUO2M6PxA0fW6SZvDI+6qC5WnvftJ2J2cT98fg7+uZ97ckYQltLz6pbJy7hVtEqHKFSJ67Rmvr2pECV5NMzsYuSxf+ls1yLn7Z1bO48/tU0g4MQMr9mbtOGjYMHSr7ktUWpktl13P8p3jhUJHppilSbW9OyBxMTu3t12QkBVSJCbk+pI3mAmg2m9tvdsXQ0REFRSEhAqiVd5eOIiLndzgkkOCs4vzAIFg6SsUinujsLRY7ObZA6q7dffuHKSDj3JWkNo2bOXteDrakhXoiZ2nAHmtQ7VrKWi4QlhTvW9thdMrFL2lNEFF1Nnd9B8nzI6EtUCtQ/Ap0glpKVr6alKz0WENdXN8+7fl5Zg2/EN+Rq6HW5VgQ7x+faTG8GELjDU3savI/lnrdsXbfnt6NfPFbdEniruntn4e+bq+NEkrRUawmnuiTVdOXBXpnUHIXyhDzidJ3rkWE4baIgHb1nMRFex+SzlIybGRxITNCkx+4ipjU1JW44tVW9F0ugEgOlf0628kFPZ3kcxaQR1ldpD+yl7NVsdWKmJXdUaRz3YYblSZP+SX0M+/YMMe5JI7g/S2Z6MCOWf7+F0v9f3e7VJGwMOYqLgkUhx+/HjKip/Z+F7IhIszM9HNJh7d7airnB5U2FxoQSaPny7uWNZyJ8WYnxN8vGBD6QUeOALwBrGsd7Gm9snajXmQBA0lL68kpWJDA1spEj37jF2w/a2FvUR9xEWQH6yFGcmn0VOJ8x5QUVhdtF1P/wgp/cSD0kdSZSieT/SY557xpEDF6r79oabV+jZO2dM3TZ/Ep78i+Hf0j2pvlS+Mf+mYmNa1GuhuqkFlN7CxBcbm+vCcCSc34/DOY3HCohzXSqafRGn6QFmSoZlXR0bJZ5Rehm5yaOsoaInOkOlYiT6bnS+PZHku5xdKqPDWvWIyfeVZuwlK4DNNTRlpYCWtPpbMcpvDMjstZymbjWPYl0lDzs6gf8FFWxEtqIvffxZS3V3TjhHKFQ+Y6vknd+g/G8j1dZ8+sYNp3v0QTmpbDQsNQre+I2LlGyTwwvMhTLFHCY4yl5Tt1oq1QcD4drE3Dk9+QwJfjjYsIM39DmGe/1LpFviB4Q9Iz54MbDViBtjZhfePda+XU0tv9ewKoExIeVZSN/4NHXfGv5IwUU9KyasH94h3Fv/t0u3vHts76847wi5DKLW9x+PdRzaj2hdAckYu6aEFvfxFN/XcKPscscckBFZ2NLQyO6spigTnwLziwo0wpyxXUJpbj6yAqInkveMdpgRPMDXHzFPjHc8oulmKzQUp0wR1y37OPv3y35UmZ9nGX1FdSq8/H4CGSSOF10whAIxaBwMFSYvl/Pefx4+iz3sLsyMy8Ia8QcKmpQf8H0oSZTC8/eBC8iWaLZyExkehQ//936nx9KEmCx3AcyHSRR8eOJkXul1arhGZav1yqBl7sQlCTUMWGpcg+9yCZyiI+RhK/r6CKz2AFLQ5ldBtfBRgk6Tu6mCy0SR8qAPI7mtgltv5JIkncqO1w2kV08B7psrdKYsE50h5k5Q1SXWBZcGhbgGvEKmd6+9G9rKD7BxVlflVHrlmmFuaLa5R9KoWMAxJ4CauhucoQsINLhSPXH0+5WMmFy5nuKC4ok/RvJqqGqzfmVf7AvAN/jF97RuoXdNOk7af80DtUJSn6PvRt1we1pupC4XENxFSwpAzwGjnFbswm0GJdL846SOWj0ddntvUtoUkk0lcYP2YqAZJJIKh3TWQ1F/j46TrtzR+zULzARDjhFeqGAeJdCq00tkcpcZopV/kv1Iy7u0Tw+T7oLov6VbrklS7V2yYQjN7h5+S4GrJCYivGI/cmIriYWYYyTpBj6k3zmeFMA88AqnjOlOhbzjCom2oji2nONFF262jf87Hl50ZojVFT0CVnStihXfmSSVrdPk/YhjC7EmNE1+OpWBcmvmtF2Yopcu5ZgX7QArf0tJqQQxchCtMdAtDg7Uey8X56omTfR2Uc2QfJbSwwniIEq90intV/Sar3SvPFcmJHNpRlL9ZserzLehUPeDdfy2H/XvL45JCueLsJwzFnLLkt+xhMrNz/NjwjV50TdYU+xIu/w/ticG/TmAzY9CLkQqHNJPwg5NMOCS4IpYusJ0I2TzGqdtRH3jqLoyDBRhF3xfwu8hP7H6C+7IC86MAMa0Y+CunCllrnCpvh54envaMeRkkeZj6xExsWycdxUsVCCFAWzDB6h8Onjx49EuoOH9kbYorbHtku2i48LMgvAuQ+k5mg71hagF5dVtLCtuHxxVatwqW3bvyFbRQk7Ao08ea4MTB1H1uOqMy1pZQQ5VuG/XREox5dRzIwanI5SwAL3xqTrpeXdJC9Jsq3SW/l+N+JF9jpS1j/YbN7cZwTMz5Id4M1i8+MlHoE3PQHHBwnW0T0lG6A5PdqCFdS4xCg0xyyHozUm7+DQqkurVAcE2oIrijRPXXSn58oMiT2A1kK3J+87XnP8NLc7oQnrfJNbPdWTGF8xVCoi3CBREVB9Ui6LiKxDUqO7J8RP3aPuHoc5oDzJn10naEnQG0ikWWVJ7qF9eTMyQnbVY5JH0NVyxi69K4x6g36fnlVufbFlzRbjbdGr96rW8adFi6OtWP5dNC2bNuvaoqn0wx9/SjRmMAh4SZ9H3F+hP0YbkYOlf4PoP6PQziYGWu5kcsDQVSiOvR3pZI5ocRIdbYpORNlwtKhhu4ISCilwUVinSDdwNhXBoGSUgk5/b5XgtJ910gwCqhBHiSiv/nBfHYpdyqtKxXzCOrmOnm0h4a5NgvM5aILn6S47Up2Ors4Cw0j60uD4pxY/5hwYSkDQkCmQwUSHInNRws32FG9CDNppeSgnlUxShiPrl64jOQnJ9DIIcwLld9t4CvNUz79gzSLGWi/Jy65CODXDwTRRZFAlSRk+VwuM/M6PSe5PsKs+fYdl17BT6lFlTUXdQloHZg6xGHNneRRubQVnQtIMEI7p6QYwEU5KpkaVVxaSHKMRc5C9d0Q4+PxSojpJjvCL9yrgvvPa7px26SWqK+Tw8PgCO9x3m5Qf2G2jcE5GJlrB1ycHAMEOIzAWgXzUrZhyo7OxCP6QEY7pafooApyXTItqrwkyyQr60vN5ST/0EvV5cvhiXj0LCMS+hcon+UAW23E5qimgqDh7Wv6wADe+2x9XbMheGcN//96y7mXCT24qN+IVYmd6tg/i7uE5uDfZ/JJjmwyKMtMkfDFfw9eepGg3GWK+5HeFsOEqdYF82Ge7ebt7Fs1KSyJiVt5oMrmwjNYlghVr/mGVfJN6c7pq4Juim/Vs1gO+0MBqrpUxuNLXfksgwZMlitdSrson18mtmxme/t3xDO6hHgy0GJPKIGzAlzx4idgABvA7nRiWrGFeT79yAiBv3JblkdXFzMpcz/LIzBpj/mS2syZn0cz/4bZVWR5ROHcjh5H6h40dXbUU4Q67g5Ud2clW3JoXjUzaRJ3J0luWlv0tCTTignYXMm/QGa4RB2C9NWK1lFeYLQV7XkaijLNqQeKXsEIUPCHplxA4BcWCbcwFCjukYRcGrM54lWiFGAAKW8aO2sBRFZuQQ1xEc3wT6Ik/Pis3YGDmV+WqdjG09WsThzle16qgjzf/i5ITA5qrSn5NDnt25nYBDpfY6DIrgV/Vuytpt/HN/rorKZF1cZbNiOOgS4QMbOxCzoEIlZ3NsnAdhwGgaWc72KFMbb5aXdANZ52626nJ7wGQVONvMuq2IvomnVPTd9Yw4ow4und/UewFSZ9EskJGlryQHmV6p3SfBYqqaDSLYWMIMh/Pf1Exb3D+YNsBZreyW9XObQMSzTq5NbsejDTK4sf0fN39+PuEB54zc4yg/KBtfDnwDOo9eTuERbf2dOOVDYrCVV913j/g8xVWfQntAuenUv5K+YNcpss/sftrQDeuOrnxj4bORDFxV8NA58a1Yjq4tft7hSlUsocgj4V49BWcskbRtJrHMZtTuclGBk9tf9UoQGbPsXQp2QPSwnETAVgL8DDTjQTO3YSZxKsi7LgvLoUnlJvaE2KOvvf3ujpGajMITHkCPbi/pQ5/HH2KS6kYhX3T4gcFU55EcPh+mx21QvEqX6a/H8WY6WWCV1HFndEjUbrOnI8XHEjaxQboFz1112Iv/uQE3Nnz+wTo3W8bZxMIS7/+pX5GQA6ERD+SLzv8zge5i/uJRmWS+qigfGBt+ZfjQa0lg6ua4wgxLPlao7148MHakkTUTEGm6hgRjqZ2FfMY8bDmrrlUGLZDiifk8GtrlGtmqzTJpUn2GdXoWqVlOsSaSe9K85Lq0ZUXlyizq7Ol4m3b5Mrlh/74K6zwQQ4DPTeLUhw9xgwrM9zEwJswZBmnTuYNItAqaCduYm0CwtZNIGQ2SIbqEWJ1+BBEEHwbbs8Re3m5/YfRsjK7zik2NansO6xQnOuly4UORWeQ1dq78Zmuo+8jHvf+R/6HgM3KjWMQOCZKs6WK1j118LWn566SlCoi07CxDDMKeiAjmXR5mJHloiUqriy/Xh4ahvR6tf2QFU0JHJRVlBlcBB+T2/VDl/YfsINApCX0Pr/Sc/NxEH/vL9z9f+atR72D6o7P75vv//fPl+2OlJdzSFu3PpuLdOAbwhm74YR5d1f9A7K3jaayqEUNEn+m/RmNu9RrTKvW0G0bYi/PnWtDOtzYZkPhTomu7vr9p/5tIqwwwpuBoHePUsEY77gMBNKHZMeBok+IFTks18M9wGkoBEN1UXSoHiS61Vivklj/n0S8C4XFEoNZUpjJHgQgTMGhxDBbnvyKEH/gdC6qUGsQAF06feCKt/eWRKtkuBxTXSZGmGwUn3lmm7IxjoIjWyUYY3E9a9vYfV3uVt/aEYzAEH5tkHzeKhIjt91WYxFCVeTE471ydnh4+MoS1NqJ+V2OSf55k8azja1an7RbCkJoi8OHOSc1OMRjyro4sKtSs1IaYrMgJCBwCsgzJSDabEfndZGEH/7UnLsPjp1LiFE8JiQ+WGnCTNaMp3iVobM3TsxYcVWn86GfVmtpaf2HEY2z32nUiYxyMB0jCo2uzImSlAlAzRmft57yFPFt2vh9bxzZgTf6umMKGBlu3VcYyG2zDTSGZ6wkh+loAr/UY4nHTNjU9KcRSxsWpKWu9cNELBv+kIOlv/GrWJ6q/aSbki3wK/8hQF5hCXbAChtghB9KLY9WBzNpfxBHstEC/eK399ZKSlGXkrhj08Ngeje+s1/ZkGeLfpueS99Kft8eUW00bjJ2GTuprs3KqPoWnPJLGeNYWiS1+FvuL3WnorxHYrHf/rBJTBng72i12V1pMpbPn412JU5iErWRZQBtNPHQPImNrjCJpdF/7N4sqGoyspA9JkJiTZgm6DnUSqRJBBFys9McB01idR1lowCCT2V8uTaXBkIdOgJ6dshRuUz+6OTm7gnUOtUTlFfneGiAut787jtkcuhyxGtbiaprr0o3QOivGi+duafl2pX9a69c+0Y5Qxgt3Hqo7S1s9X6WjTbb6OYpr38xRqmafIWpD2bAAmeSVIMx/rkSU5+8ldTr6U26dQL4VP7M8rGw/JHaN2CGEMsoWL60q+7LnUoH/XTSE1YvqfrUPF/Yy1v5k8aRi8e2ZuG5IOhT13rSD+Dg5vnuX3/k0xZW1yaETAf6OFcXQUMzlC5hW7mwaBFoHn0mMhWSq7lEhZarjcNAk8VEeXn1NpKKkLLqykdWNb2TqZnQMDvV9A5b2YnEGSdyT2CTv6v/7z8RQht+oYq8tDNBpTQeK6hKivXxpln4wvc/vBIZ4gbc3vOm4MipjQ5wo4Lg85hh3m3mMIZLww6ID+Aaa3leKw9cw6k6ofYivF8S3YvLknMFmUaCqq1BkRhzfaYTzFE/qq1qXXI3dPz4Y3mRSvVriV1mzMUZsy70Pbagnie8XisOWlheaOUYJ3JS2Q8fylKv0JHck7SIa0WtrCWSiM520Ue/d/BXACRjnO5hhejSEauHhhdhS17mF04O0EUP5tsB9/bAfCrHcIurcLg/OyQwv/S8mZ/qhI9B12Kr8tjMxBjavxa+cackIF8WYZ2YgNqy8xGC16dmzoRVQzXMpBiQEiEgLRmrwlFl582mQB1RZNYUMpwRr5h74udXY2+dLxqyYhMjJn4H7F55eAaEjyKxp5AQdKlOPvfK6y+JKDMUPaaPSgyfuJJkpxnM8D0QBwipnr89aSC/4ldBwE2oDFYylmsZUJc0ZJh6h2jRhoDCevUShZdcyBdulVhMacXFwQbFygxtosoiNVF8e/9uqoYE+dNsq8YeYpIhpYVC8x5ml7V4pVmWyJ+1uwVKxiR72bn65CwmCVJNC2cicZsNRGJd7eGr+g+UekKYqpJNgNuNqt8ACHZb2EtmGXRzdI3Nhst8ITs/Hm9cwmYvag7RDYfOalTuMJddHK+Pn2sqewmsE7X456ZAtZaPYUCQ3NtfrY4yivDmm1o0ZjKmELdSliHpmZseKa6gvaJ9+W3HsffEmKkheiRhJboUm8fzPzFH5sbYM8Xr3SQ4scP5ZCv1ExK6GJ2HWy6x8af3BRziMKHTHCQ4xL0B/nRqOGE5Og9djD0AxTtVMLvF36L04KO/kOGf6QZXsbuPaeOFwNBcndJ/fJWiek9mUiAhvGS4sTN8gnHSqwx12dHoHVNmW16wo6KisHDPZu3BQSA9TnSdDScRanLbtoWu03EkVSNIDS86N2QOarfl+Eudsmk5VTuQhTjvyIiy0dc19o9oo113Yt175FIFE9/aFyVlEMBy2WxOcxCPZ312JHdP3vJPFwNgTJazn6rJ807uveYImrYj33qhFzSnvhrYOZzJXXmy3NRpTq+L2GQ3o/i2A8/z31zNp/+kpxp8O83T7sx89+5u1iSqiI0d8SpGFLeX/ogeqPa5p3p3Vk1Z4w6S7BlJykxlvRP62OYGBYhTwaxcbPbebk/53SPST9zYxbXcoE2SdjyJi+A7EKtdlWoQhO0XngvqtOH600ZILVKfDRn+hZ023ICUmpPkCzk7kxzj4nwHCmc5GOif9JuzxCrp1Pv/1KrkDQ0J5Q1npGdqAwZkfeip9+7Mz3HZFQ0Y3xlVCvOvI6aiwSd9znx1E/atWuXETrGcc1aNBuVTuqA69N2qL2fNG3FE3MZVqwb4eWvUCrbUGXrv0pjK3Ircbtu/P+YWHHjphqska7tjakB0runWllu5UEgOgWtt4d6NR+Y5KVBqvTKNYIpVWg5c465v4mFwnQcPnjw1JyUocZtDzPl0R1lwP7Vw9NSQAYq91RJy1ntpSUMLvn2gvvfOPfWTAdP+xdOmHTvWhYe37l25OaPt9cC26QEI0NkQAARkc9Str57tndkTTt14/vw0BIxwXZ6I5MCMrnL1vcoHO543IjFA4/81JGEOXi5a1LBjVrP2M1Y591rcNXC7khvq7CgtBaG7jfPR3/68DC4rt9nzHaGWCHvPB1DmIq1Ba8uVhoIlNP0I3A2PAGsXbbg1UJNGoK59GC+3LOdLSrYphk3m7PDzUm2WsCk7u9IwszBCxCxL8OEdQYTi3Zv3PWjVNnMn/BL9kjbKaEdUGlMXkDZ2hORLlZdm6kIqm7KFvG7Z8wcxMlPZsw+AYrVT2/8BEXOWz/f1R3Uu1kfynVkS35Tn8XxncHH1NloPtYIxB3bA9tH6sA4QVIGgI7chxYgXuD5qH+4FbRv219yINHguubNo3dra4IldLVkQlBUoIuOQeZw5Bhvl+ICWwKkFBRohciKjkFl5ATsUfHE1cp6Mdfj03sy2CIhFRC6B/Bc+2BsOy2xyHAbTz7VxaT8IOMImq7iSFP8Zfm5V54hx5f+HI/w4+P9Bp7dHD8JbAgPupm+1pjWXMYlwj8igdzFWcACHQbVRq7g9By3CyWXQVrRwFoiqWrqasXopFslASgS1fIZUIk0zEVEJX+htQpFh7T7mOAOma208goOQsCEkQEJYBpmFxJSOYSLYGuW4uuvEuj/n/YEAe2dWwWwch0H/wnUZcmVIgLgwEcfAqbDtnRUBELR+Rn8fHduNdXAPPStDln1yAq6o6Cx0LTozk2504guOk/i3+aTjgl1KmVZWLvOWmSAu383i2S72G9Yd9hjbGapFt/OLBO3oWkjFesOev5fDo4G4xOkYia/CqXM/aW+Owo0qt0g3jyKeE13Owq/AMxiserXz9h5fm5NLkctmpm8aDBth+vwIC68onuErcGO4gZff1aeZ1J7YpnwlG8I9GRdVdT/qyfgoz/1T1nMYXsAV0HuUzcXNfvTsaN18sbvQ/m9WeHztvM+ayD6bvb8wN6EP9x7qOTq7gdRrVnQR+toCa48J3wCi9vAOnyodiDQOgsT3u5iIrpHRMOUQhpIgf44LejVoJRHBpZGUaLuISIB9i6AM/bokqMhrjyp6ge2tX7KW3yq41hKGtTAG8qzIByXb6oaGOOYmu/ZAX+0QF4WXce3g4ERnLBGw3xOH4TrUAbqFrhDfuyKKFNYhlMq8Av7tbyac0foz07MXVApJyL1upAcfc9W3J2KaN7ltKgTPryMDR+VuA7tl2yW8634dPZ4UQYyITGjGpCCRAGGDsUiIvVdgRh9gnIgtJiwrO5GmhTotoLJOOWodtfhNgECiSCEiMAIAxJGtSAQM9PFBAAIwQ5uI0QDpv3McxDeEU8R7hAhArDzuk5EPTJXnZkoi1VwbFVecpOxW8qA5/hYca0a3Ryizf0hqd2D6ZSCRfPbZ/KJL7Ersnhre3vW/HQPxse+Ch6v3Cg0YdfLLve/vGBIGxQ1eoOjPE12+Plm2Pea4xeeMhbaC9dR3jU5WLeu12BXcmVDy7KQUUXvJbeReak3b5h8yzLoGY3q2FYibqvLEfSkUojW/lnHrSae9ONcQ3G7+r0XF4y5Ifn4whUKYSnpAiCRd2wh25dVKe3IaykIFhSzyckAdQownvSfEVkeSQlyA07fhT20+NFWnL3QC7LxGjCVSF6p3xIKTXa1RludAcXHchXGGpEQuhgl6weTh5P/09EjA26Oo2LA84uCeJUVWzx5W3FP7pl2stZSm+knNixou3AKfk8qBBiZRKFZN9/y2NcdX3CM024GEchMwW11T9eGRBAttePdyZVqjMSONpYOjTTLSPKatA4bJY6Ix7gu9UEivcBEY5bWQXf1EvlUGBoy1TXJXiEPVsA1Zjo7PMWTydSLCC0dGCxsVECPfGX08+rhGWzSgjWv773N+gyk6GTxntNt58QxFiRA8BCe8NeTHjS2d1wCnExL5bsrgMlDTg8QgoxdBEvBdsqJ75FQKkjO4OvKFYhfgWKCBuCGQdjocFvXOt8YpFCKcbqNslTvfSC6g94h90Ctx22G7deFE+vde95tFx0KOLdo+du+pQ+hizd9vxq0P1X3Tfe9f0qWV4sV4M37cJzJbxJfVvDLVPxG9E58UvxNZ5Lbk38QzsC3WdzoZb1o92ccKkrDpI55fVdteDVy61ZUmiN6Ie8W/RXw/vhRvJ/SN/QDSOOEe7M4T89IXhTzgaXibgjdxHeGd3AfcnbArN/3SwHTlqqvrVbnx1xlkGqkOSh5MriPBs9+q3UmQsw63kGgD7rhbDfDgdzj3ARqYuqFOEoqSagjUWG2LYkB7EC4bGiQklMsIEfQkmVlmJg1Z1oCC/eaaEzw/YkKwRsHIHw+Opi108tW3Sr9Elo1ptjCsbJ1mQWimPRSKiwq3ekW4qEUoCQteKI2JihzAlI3ZeuUr8wrz63ApE/i+698u81gkYnAus2oyjdk4yRgPzlNzbC7V3yvM+Iu9N3ovRlFNp0uT8nQ+kyodB5nrNhJYEDQ0LlI2TZdnnXGJgiCmDCAaFzduTIbssnhxksMxuZvgoGiUBMDo6tqYBFnj5c5w3JTfT4Ba1k4BqU6Y9kQ0pdfYok8Hn1scgLlypWypSs3Nn+858t4iiaRJAqxB151DfnsHu/3gNzCmWdHZIn8I7/Z0LWsYpMOIn7fSb72wJJJW49cqLT70o7fo419zEx4QVhjjjOHi6S4vEIlBiH2BAtIGEcqbMfWtgEMpzJTgXL9L9skvotWzc7lp3Bjs/7mJcMHa1f45sknwkTf+Eb+syzPfVL8YZd2pJzotpCK24RxrZ8/xCuBPPXXhDV5Q6/3mSOwwc1u0Igiud7rfRXJ1a3/IC65VZS1SUWXRDG144LPD79kFmSlqdfB82gzsgoLfojJ3lRmZvMX/umLRDyzSvX8deI1oksdcwi/tf/Nyxt4v6dxZqvQo9b8b7ILwz3XB6bD5dHi95UDMjckoUAxYeJsQ9dKQzrFKSYAQcb7iH1OLuIQ4OQNgFgJQErDsAQisb70bkhJKoLFXtF7I9I95i4GZdP6hJSgDGGYaS1BO5BQrHQ//4qLhGXFj3NzK3ZbZy5Jor9kq9nJvtJefWVy+pOpmC7Irytvfvp/zAYQdIx12uH3d8291lOz9OyziyVBU1FWK0JFlp7+a3cGsssJP9dtL9jgEx97rePu+2J9Frf5p+pT9OgvKzzhPcyXA4Xw8JT9l5SKRzqxBkXIXi1hRfJhhC8GruFaPM6ZNNFlMiCuS2DfangadEy59ajLadau90MoMTaN3XN9+xWgc0QVjFiqBqLslbufpVpDYU3jfCpqY6eelZIXSEkO7EFgKIZYPiSCpxzKIBoHsgjxiPPflHHG4oIsyDMLBFGg1PaEvbYmH/dDsOIvOUlAkjIMNAWxWXcN+gJsvLUcPmscsi2x0L0yYspxadClIvmWCnR4eY7e0syeER9iPQBq72L9MC8sw4foFicXbSRcJ8aR/2NyM8b9DBMFFKmNMJTlmjRthtxfzSm0mpylkJYOesx4634UrI76/pwQYPl9xRnYHx2HeuJ30oo8ZnVc64ppaNofEA1EXQ+b/568tNs6pJ6SrIXa55bxieo+j+M7a546jsEs7wPJnD5MuskeJ1/HaXwX+mrCJOv2EAV28WatflqIGhfFVBGiq8dtA5ATTQryENMJ+02ZL3tldU97zAI5KOvEb9Ug1zOO1gybwD2fFpu668avAq8YjLW/9frKbpR3nRafGutHrM28oh1ise/mflfFb99P1r1WmnmtlV4HP+0Ow5SjUM4+Ia0/SpLvZNQcDLGsvgJlpYwU+Csu351BLRk8nxXgY4LpwUlQlshBzEtuHS8+G8AKVS7gmw08zHloRm3h4J/eB54Lzn21j/mcSnKia+Ss+UPNXOOgLdw2JKIsT/xKHhU6cEBx2QqFz36Oa4YUTjYJ+lHwbXETDMbZHKNv5X3F8ejvjNkKE8Ng23vNk2kSLa3ymaul/quhT6jaO0FsdFUlDbi6IRUw76njCpMpqeqtEFbpfi5hoUcbGyWAIqQPiy1YsRi6nX0odP35rCdN++H+kCFFw2edYXhrJ5BNSALZL5DL6lZRx47dNktomgwoyEkZWEVOOJRULtDL3ZPGFH21lYhdmQsUF2xKhDQekIxpAKLzMob8pwrXsLyuVqJgJlSPmDUIbUXJR3YLtAUd8z86DMU2+/FN0XB/2ZVbjJih//4IhsmFBKKn/MZxEQBewKD+nNEdjXuH6KOE2zCtMZXU49ONjX2UcQUd6sIC9x75k2il9QvE3fmQ1mQKus9i/2d6Uz6dHzmVMIq3kYbaNjLE0uD42pBDasBpI21d0RUbzYCBhoLiNU2x/WT2npiG+ColsRIqeJ9LohFHGMGOEOUx4b5eNeYg5hpeoxxmkY6pJdFQV8rcH24WTv2M062mwN6Ybw1r9b+HymoY2VZMSl+aD1+uJ0yNd9Ho75pyfS4N+Rgn79+bDuSj26Y8tHBM05CMJ0j9WVXxrxiZzJudA2C0vhrq7w4Hh5PrEiKpvS7PJeHNYYAGk46YsoYCED3Ss2B+fcEOGTHh3awoBEh6JFFX4ERLeTf7YnLsRJ5Law43XJAK5s8admwInVrWtftFpAaKPeMCIHl7x10KJk2CAuM5hQKCoaA9XWzbgsX3YOBx44HGBfJkcy5+6TbmNG6T346NVeMf4aL/gvb8x3xziMIcY0vVfwPUcQrRyWfa02TExOBTD0Kzn7v77TRtygobvECUGkJo2WZvM4/73VjFM5T0OqSCi/cDF1CW0aGFtCyEPU4cB0LbTQUcAG+C55qlTrEbaH17x8/T5NfRo+n4i2NdXJOrSpMIwJTk6RMdhABa6Vn0Fj36Im6YzMFs282QOIKWCJa7V3wBWh6evxzlltTJTpOfEyvGe9LirRPUyVerO/xRx++LWKWyPZot31aodi/3Ypxx0lj3nU3E5U8fgSQsUVJlhKU6NybQlO+LTQRYoIRX4tN9Bzj7QU8ahmNk9klwENbdxP+8rGHK0BxvORTiXKEASszIrNWHCXvDYM660OEE6xSJ2dJ74R/ncL07C0QyhaVqrwnNJlSoKTi+gxy1wBPg5Vnp6fj5+T03jxv62QyeRy5IN3zCEHbRAzoIc0H4bAzgNbdHiixxNyk6qQCRaPE+i9+Ssl6DIJ/JusgCzpBqMwRWSOsOr14aE8wD0crRICKR6LG2oSJVCbCaSAgaLpKwule4niSsL0KnWf3yNZep0muNnwt5E/W+U9W/NDa+n9R8NbDoqooqpMyi5REVg68noKxQzn6WNS19tOmasb7GcM416xo4vVRDB8W2GgL+Xbean5sxIHnOVRzPS2QEVwHaKhU+hKEVJhoY0+tLN++ad3bqv3nBnFSGPYnYC0iSUWsa+WUCh5KkG7gDB2L6tmWCw/uubHsfzjaUsb0JUimNxfT0+rtWoHtRQlDI7jy2CiJFzFnZGJTZKJHfwxOy8+dCiNqB63qRIPbQNsbl/z54e4XwVsM3WuGAQWAFUOWNejyn648dnHMqXe/qw2KRekku4ptpmU56FUFTiYjY1U/dxEr3e7cx3ia0pYvv38+btirz41kOYuCUuLr0yf+Lr/JO6KBP+X7UwYXjeYUMWGDwc9Is0OmNxaIZnYZQedVdQa0GKGld1UedW29EZXo4oow7sF2kuUqxJ/6BguQt6Sd6XwirP7dgY+0SyrjtxeBY6MUfUDHlQJzQUG9aV5PCheuSsg7ipKQYBiwkbAGC4SdGqPK5sVXgdZ15g5Ga+xzi++P1Z1LB67ghZVzxtOEPXALyoN1DvnHHjVqE70ZatpVJkaFZb64YCKXe77ylHEedEPKdo5j2WzRI7br1mfPDfvAvtOw8BuaFK67uVC7zr2j22V4y7q0j9kFzcIn55oOSTsbO1BPVbcnMPVlVNPZVKMAW13f3U5svSNU0HTsnGuV6C28RtcMNFd5Ao6RN3M00nyjgba4tJwQtdi7dAWl4ZOO/7/fvev9nDhJeS8K3Y/vny8vSHNZajQAxcVYMok3Hlcod5eqPJ5a+HRQiVLTifErn9lARQJWqQHm1TEJCJpCs/e5I9GPsVki3JsaG9hFZDaOjLy9smTeSGuPVvsAmgXr/U7a8Wf4xeD2NorlW69Z+3Luk9EtBrCXCevWsrF1PQBUXU7712eb2URObklcy2+NdXDgUvfZ1FjJ3zeTxqzgeBoCCxyCTXLDihimDbVh+N3JOazsruK1yCEtFREc2MV7oBr+/MVFxqQ6NNH4qZfikuvkh5PzDDunznRKo7BGMCA93ImOv9swZpSOjph2IhSTLgGvPO9him/V3xj/uWLXwnZ8ctK24vv2NAAhT9ocJEI+krJ75+fG1b7ra/nvJT/EiwGuUY7YfBaEIihXO9W7/15F72+Sk6FMrbJXIlghapXLuZ70zjb95ys4KkQbAghSmTpGeeGbepubN5dM8Tkn4cEyaPBF4uQ/hlRRUxoK3YItimiCrUBsTGlhDmJQ6IMYQjYgP4Uot5Zo4tPBY4XnZNoLu3l9+b6Erkk4WkmTMvNd5oXRMk+jgZv+HUAmqPK9GuujR75rxEohCa9c5hiEoOJDv9N3vzBXqEd9zcJTO9di1nri8eeYpmulxHuEcF8OcF+P7UXGGQBasbLjWeaWgUkBmQE6vJXCJT5zBcAcdQGILMqO9wyA7Syg6r1T098IMPhF/hj3QwMABpFy5w3wt22O4BGcn9MrHES1jny/b9ZTSevvsQ9JyitfTGWP+m5obvGAbJ/wKS5+LI//63b3Orbsjv2dS1bl1Nze7W1weNhz/5vBXM/DRtQdC/M3f/a2quTA3IzQ3deTM2tjhm2du4M7Kypr0aLQdhjEIU3naUpQxFIdMKKBhMZXLitJ96BQ/bHSNAUHNkqlqzWvAHD7OUGFwJ10ZiLXwtgpv4/kCv8wMAK5/ZNvJh6eIZwLiWvcQodLuN6bgE3q2mit5ssRXVQm1Bud3ET8HPmjzMygieCWyMkUnnpDXz3AIjvaLLC36nrEIxZVNL7QjRF6/J3aGKqxjlKVckTvz45M5dbOvVIZInYH5nFYCB7chWaqG7x93dzWI5nAqQmkVDshWTpWXEISrc/gEgMIbyhvLAv0WbukiToSWrccQhjudiAcEn8fV8a4IG99FvtqNuUUqQedOuJ5YwB23eSVFd7QZJViV8lfglWySNHrye9tn9bLlBg75j1b4CcesPb3yvzYUQK02JBn79KiluKhoMOKlLgs9/DLAmu+Eeu6ht7208fKMlWYy2cCY2kyevnVypORky5Wvj/AG7tXWTU6GdYei/aFZW2zFbxh/1XyN7pkE4XkhB6yefxyW978Nay+VY3/v8+cdWzyxg42Zjkr/gvEYS+iNIMzetMCO3syFczXIbXUW2hDfsnjXIu8wLOgT7p2R5t3puO0/x9qD4UBee8hDEj+ThithtdFKOH1O1d9eoquSKbFXs7i62KXOy/+V/edFAc7KcF69jUBUJ6HCsibF7M/cuDPazJTQpqS/A8u6/vmbPmhrc2M2jm9mveKW4j/Cl2tbEv66MBwMqzqlodoQ3XeSovn+X4etzA/gej/s8+vlt+A8+YINi3VN7pXbd5c3Jmzcpr2y+sq6e5C5tCWcB4o9+2hiArSP+sXkW3rCzkGPEFO/wTEwZNGxvb9wZkJmcTYjXFkkNpOVQi09eI3+UvChMz3JBt8atkaWNRM7Oe/06txMQrQdqC9U16rVY/yyQhPz46meE2P3Mlq0ydSpX7FeBGn6/3hEGxCftNd/c+0jBXYH4q4j2ttObBz1Xgo3I8wtqU0IHRXYSXpqXh8fg8MF4FvY7DaYiCPPCuweuKrzePmjZPkdb7o+DGQEjSSzzPmUJ9/Pthgwg5LRiwGm7S9tf5VQkUwPjZINh+jwCWeeK6emMalAqItFpavKCMvCkeEHmoeCAH6lDxNEzNEHkTZdnRvVvSj2gmd9oZtsB5fQUWmRp8asyuycOWnEnP+slwf9Ej57JjIElyYY3gRlCFhFdHHt/ACh+pHmnLMW4u8W622nX4sdEeUVuXjlQ5H5bbWpCihE6UcZicHZNINoGcSAbOgJ2HNbQbCiZdm7GZeAgBn4AFXUi6Qg0Uo9xy5/v5UHTZBtEo9M4zDZzYt7e322cYwCNQEJi8OrGPFJ3VZc0jwx44NhkcqvZ3IvrNRo7Ud9Pnfq26DIJQWLA7pkkmOQ/akK1NQFnS7vcrW2pGaOmO4UK75jz38umkGikyYvv3bNxkJZseDeOROOCFGwPZRsOIoEyBAl6hnAkULpzhvEFsrD4HAFEy8Z0WNraxnUR869eGeoeMpomx215sWet8IKskyyTcxh4+Mg2kRFcAPh8MuhrEgCu8lE4JRapdwfBlWSdzUMAzd5JGKOanazpvDI1cjx+UZJfDZSW6eWBqhbh+wiLq3yOG5zGSecArZKiRQROjrarJONzF8doy+DvqcFNNOLmeAPwGpgGOl3HMHkcRDD8YKHfLfiW38MOz0gvw0Q3GOgmRs8yADqVfWr8ySCsZ9m0Aw1aXbFe/WhQKjkZobqOB8OufA6XDVJwUVCHB/Dd4fVeBLzvAECTnvCcUmV9Cg0RWVxFMqRE1FCKX75q0s5cs4EkXu5HRSIBubKWWk8ipOQ3lKlTEBOqbicQ02qAXvhOtXHmml1EaadvhAeQgdKONYMAE0iL2jPASvh/S+9f7f+oEFAeSN0YTWai77cGxqy/1wTiiMDo69D/oYNVAFqxuEmsL++8t2OGPzFmDH9F1hP7i+qrXLxDy6wpq8Bh18ih4TZuq21WAw83y4FEwDRaDg6iDh5u47QBOQo4zm7gHbvmyEqZSx+Xfbk8KyMQzArLkiPU9l6btccOOCqz17oU9FhsPcsJtFBbPZuGOPTxXTNzimV/WJMBVVINhB4JkOHZV/IvVzRdzg8vj+8u8jtDO4tfUUWvS12RPxkx+OedS40B1CYhd/76be3T5rn3a5/fGso3QabDph1GRgcomh5fSSchSC4YJP0KK/VjMeM2GAsprgk68G3QW0LQldmTzMMcGMe3mwyb8Cx2iXVEiQMOdZpeEvsqvaxgCM12Be+OXsWrZqBnFGQA6ujl9EvpNGiKbqEuBYpLaxZ9X5zo6zzk1D4znX0Js76Tmv/ODhu4AiBrIk9zHFh1aSCZPSq8QDGKC1vZ1qNvbMZoBnL7+w9LNie0YuzodqgW3YrZJFnk5wAF0qm2PzNpVlWzEAdwVS9fGgXjIwR/a0RQ807iL7zOjCLynZKUy0GWhX0pM6w30lM1k/YZJJnyZ+f4jCWdr1XewtIvTkzLzj1Rq9uOfkBz3vOQfmPGhDZgypH2wFDyN/eHLnKJ9M7IOcGA+q8aa5ACkOu1wxUUk9cqtHFMRb3W+eBabHyhrpyP1W9eWw2cQy7Mx2OjyQeTR96MP/NusRY/B69dbBSkMo6hKBqKUz4hhX4ZSTFQBKY5RocFDsY5FXUQWn6sPKy8NS5G4P8pcXL0MyNkCtTkpGHUMytXCA0oZDkZENR6lCavphBhQ5SFfzoF9P0r3m4sirizfu5o3lYrAfr9+I772zCNFgmDRABG6BEEnBoNaREwwooQIZBpgB9xWMEfPEHqIyEpOy+7/Q5Va5F0AHIRKfXc4tXq8hepQPR4zzxwLfUoR8ibT9rSeWbrme2dW0jzuTAXHOfSePMFsWe2n9k6WSRWxEXwUWz8GH4+ofXZ+WcnW4nzCKP44/hRwjxi6w5QXCtuIX4EB/Av7q59c+qfU/unLZ94buv5vvPPzz04ufphZT/t/I5zOyYuB2cxhnK9vqxFXy7SUiayrSy9TJdJWeJRsM1jeU8yP9YOU2oo/FY+VJoUXoiBLRT+3I85NMg34zlay1oCP9bhl2M9/42j+riYyVqLMJMDMr4yZjEc7zmfrK+3WJH59Ox5BdrNRJw4MQmiFlGMS8yUIkFDmtkMnMYNDOD7GH34ge2ETTNhu4sBzeE79RN09Vptoa7pTwLcVK9t0v1JYID6vNbUxzWNOsTuzM7bXIyApmOy8rzBt+qxdcfLG1Vj4oI1Q6wTsx625KMq4hHEEk99xb6X4GyOgLBStnf2iX+31Km+yZrhWH/95QqwS5eXW7Ia8/FUghf7EDTtSYUbUEGfeJoGqkgnZHmLBWVUQC4eWBKLBeORY1szra4mwwcmnXHfJKzRlP1Y0PFIZPtULuyqd8f0Hpi+TKoJ6O0BrxfKw0d1kh36aWW3UTsWdoCpoNq4tlalytfGnxEI3O1x7TOCft69plZdr0FUesUFRewlle0rF5VIL2umZWWSnjFHumPXpBJzBYy0bfO/Fi8SbmjbHdt+s6giJzEQi/i9X0XROa/If3lHo7d6Js1wXMGOWyOxZScTwd+FLglgZ3I8HpsoIgGc6x2X1GJcLJCVow8fcXCMqFhDouDdjd0efHXLaKYcGSRIKAntTEn25e02FSXJM0dLIlsPe/ICWqbInTmkrydH56fTMxFMkaNTdt1HpUikWRvYmnlyZZXr/5pvmN/I3YNwLR5rdSTqw8ZjVKEQRXecNVuvNxToGeXCu/grVA/hlHl/V+MwadWWPw7iBwt6dmcszs/OA9BVDVIx6wKN7mn+6A0niSBNYSUIanmJYFdBGBKbm5vH/y/rP7Ygtx3hnZ/IT59xiUTleRwIh3EirgqDSVqW6uS6TI/2onR0xszeHOOVkNOFc5EqFi19KPLJ2Upk4sX+W01p17NN3De+65bbM8VuOL4oo9A84Ve4o9upCEBauoiBGyQfwjBKoEyvNE9NnHfCONwgBkvIHFkSseQwQGqRaKQVCROyWn89ucEbdbvPJjuwZVJTaPcjI6LVQ5ESkaK4cf33HBOehe3HQrdLhNKm4Xo8BjuEBVk+CdrYNM9ML0eXpDmOztVqkt5aMjM8mujAiWYalgqBP5Kk59NjZY1tf3AxjavrpI1TMgyCB05WLS6cYeBE344iNkQkldw/B4IWv08NCtMUrZmxekaRJiw1KK0VQZxWluKb8tVH5CuS23xtdaOAxefAokumbHrFtApZicw3xZeY3helFYWKkG0DiM9+3jImvmz7w6Z5L4+OijoEk7zKzkdHD62lGBXtVf6ZJCNBnXicdDJn2SVxKhdUhbDQINfCwOIovK3arTyKlxpiF2IwWKmflUKztT1cLM6SIIFzfs1QM7uRpTXqbQFLuMfF4R8fbQmMHFTRZGpNBbadoWadpYG5FzGoytcnHl/Rkc5tVg+aWYVxpWNL/XhKDe0RgRSDWyIs7b3E+aMuTFn2aD2aNy8/nkTdNvW9uZl1w5kHf5aYQt8c4roPhLYpeYhE81fpLvzcBxM9toAk7br13usRhUO90vWO6xWOTEdlM5fS8DjsWJxb1IBvxENqym2SQWo41pjraQCA6kaZf+6ECIxWPwnxOTc0uGONHUWkUyX5wEVVkg9c5NJ2BqRHRi84ToCzEd+0rJHC42LS4xkyGoVHmqdIc4Mfzp0TtK3Bs0ojzFvxEeasH5n/Gg2/A4293zmedYy/xD/LB9uecZAcr7GuAgcQXEdb7n/nYfV4TVVbbkluJwBCVpF72kVCb35K3n+CFDwWiVxxPi0a78CHqzWiIKuG1NqdnUopRYRYenGNOiElx5HrxJcsckzdmR/w1D/qZy8jXRQfNGLNuE0twgIDsYSAMduc7Ul5s0X+47FK4NFHM6f3sGBiD2+KKEbF1pERrubVp50nRUUbdCgsw7whmjRZD2z7c6F8oT+hvAi+OQ8K/y4h4W8g5W/+GE5G41ejNCMTDbGmER7/KVcCS0u8aF40Uo83112wyjmRMObkvrCaSNwUKeFTwmmNnY2oYtUmd4qZsrtyd5dvY6w7tnsaj8pFstzZH7mJ2Te54VQ7QypPZBYDPh2KGMmgcN9wf3Jg+xXnLeeM8oyETvqJa8fudd4LZ1oGGYPyRbyyTeAVkIoCNUZtLeGDoVXCang+0hQSxqgCEBHbN6ILsmgnVw2dM4WOgg+M9g//A3x2e16Sa2UeLR5Mq+waX6aVO1VBzalzTniccIOLCojfful9xbyc2p/qdfZgt7xbxpFzkLl/8jV9c3vdz3ni02rI03PAAcsbY9jmPvvbX8ChpdWL7xyyAPDjllfzXolPG9cbv59cLl0koc1/sj8X/PlTcnDeOvdTnoTUSlJzzsrcmEyTmvUnmpYU/bbfu/fKqujYbyW3oi1rC7PhEgyAtFXXc68JdwsWCW71zZDOosKk6PsZ8+96dbd3ux5yIyRNJjRkL8yOyEQG+C14jODHiiN7V3ofvN2UmwKVQrlFiywxn0lHgLP1wsxJbHN8zf8n4o0D9uH/fxJFPK6r+sGjaaXGk4BceSwmr1Y9JRC401TVTwLylHoFu/KesRat/xXupyh80uDoB5EfsJg0raTuXNaOKACUKWfGa9Se13xaLZEpIykOyJtGUBrEL2aw/J/a4KakXNFWhmCr11GvqsSDxKbEc7OcMymacznql8qyuonq0v8FcWZXMHaezRUxIGet83FeDLz35+8RvP7zDqo5KtGjlOe7dPh+QphJe0jdyRe70rkSjdCBo0GoE27EP49rgSWCfM31j3GO5HJ6lvw+b+oYG3bKtB0Qq7Fq8YLJmaqPllsLpsBinEhkdFKJmSi6TH6fmeLkQbzEE3wVcEgk0UPl3A+O97koTjn6cV4WnSa/8ovIhThyjE2bOHmij0KCxrgfHaY+RrNfOADNFY5/LO29aU4wUzLG7UDgRDipvtad0uVGYtbC0/DduEpyVnVG+cIIJj4+20m6Nv4QRQP0SZKXnae4kTk1WT5KgY3y96Qm2riMyH6+fTwiIvEgN81q3Sl5UhnH3CWGJBDn5En18gfXVtdLLwRHaH93saBtXpc8UdYEZvrj/h7mOnw3Pha/De7BLXTGVkivhYTrrkecXMgXJE9UdmN2ZsAPFBTspvVBD9cH5PnznvL7+NMhSdubIAs8QLFRhJJ0RBfmAK6d3IM9wBlhj4YHXkDE/SPbDwgPxJEeibZv7PThme/VBMfp2bdmp0oUSONVmwt33DW7NH/T1Q6s0488xXUULOqecM+2iPFYyJEwgWIDilS7puMQGcqz9RTvP3O9jYPgtV47M0xC55kW+p59870dC3Ct359dII2nJo9Zzl0UMK+OSoUvUh03fP4Xs/g7gVCdXCwf7yvuchcQaJx5YL2ryfT9TCjnEVG5/omAuLqs7KlteWreduoNT68uTnfmYU9f3pP6aIzhEnb/THZCpXN9e/ovm/HIt/lEg6VwX+iQnwehSpMFpNzGiTQiCZZU9cBMghPxiO6UdCz5Pe83uUAWJrlR/I1AynqgQCR9ixzlbOeMcBY1psIMQ/dwXdhv2ZF/OxZEjHmBbiwce4UDUtZzVB1QLcB2Y8OxWzEggrm8fa47tOGKu07tc9slArnppECQUrJpbvtcL2+fsN05IWCh4kUQQtLQYkwPBp2YzL0Bus9brHDqgc3b3V3cg4ZUQx95Bd4Oj8JY0vsc9JI4AXK6CCv6LXoOMHZ3cbu74M9McGlattFlo5q2HUiA2Ke2VZGdQJGjpQgokcsY8vV9z5sCPCLAqeAISS4Z2kf5TFxnKwwh7wpdMZSo5ArUPHgd39NhECIJ3PnhBAfh2z5TEuWdfbU1lKoqII2xUZpNg+dnXz1yD6wr9YC5qz0gV6cEwhInOcAJhQUrh/mUJXJKKrVoSgOqPlVSdXTKzmh5McqpJuo+MViJCos6Cu2NM45LnpHnK5X0VEw9ZuTyEgjC2LIxXgxVwkBJxBAISqje9fHVh+gVP34TBaQyyCIvopQo2SndCSTWkz4D7d+bZ6LMACcgsCfweONTv6ctvnmV+ZWLjrYXjfm8zMNFS5lSKfjPd5B/zUIq01xgxlRIU/EboA/ptbOL5pygbYpZgdIgYZ/30eHq8xEnosWck9k+6LkVbo/kSsPr9g+0c2gkwr5z5PRdv1x294i1mpU9L5iutUGQNBQ+A9dGbcMl4ohWjEhfIxX87CJsvZKVCkMB+uwY7tiAGIUCOY49PxeHYUBCGzbWrau2Rz0tSRbP2gsoXmgsMPjAFeN439AnUFk+bT0ZiyjYNsripP0vZm++Ypw936kvYdbCAEr+xaKS1YPtxTHZGybvvOgjPjO394DkN8whuC2vCZwT5uJj+qMCZDU735slCzJzrBV2CWdRSdeG26sqdGlZcUpc13AP9ghVnczd4q1ELl0b83XzmkjERddFMA2BxpGpSg9Xi7kRviq64M/fn7GlkQfMIRtbzgV5T4DapDbib3mO1smpxbp6tbpQ1/iCQL569T78i5PLCMTef4hOxCNBv0P6MCrzx4/IDq64q6gmqQrttOyZWM1pr14CU63GnDISN6hfuefAG+mv9XZDgSmHmTtAwBDNZ4LVt1K3R4FP+yn1q9rrZyVZVilTmv2nLl3Zo/eX38NklxRWEn1F45uePfy+4jTpH0PfnLDO9HRkOaRKEmud0QqoUbGp8D7MAshYauiPFl+17/OJMxMRnrwnzqShOHUJtgcDw6cx3V+Pu22Y0zBVQ3W8A8tg+T7ZvgoIQSDUCYBhFhJLhKlKZ5iIQiFZ5djswkQCA7Endho/bztf4AMtM1xHAxwJIHqlG1HVQSyPt5lvPdjB/juc+kK2hfQ4nv/ncpuk7etyosw7WkbnL9S9kIRJar4MY6aIrQNvlWxGVmc1kwn9wah2goaAy/nAy6svX/QNDf5m/bR/77ufSP4rfXt7f7L+B/M0bbyuoi4nkSk665tll59DXQKYSjhzqI7UPsFlgtde2C0Q87oLS3K+ftrFazO1C9rS+ROmA85/n3v8aHjVN47iUZ14AWUNqrGprV1mCmI8EDo8O5GYTXf7VgjFIto41xGTLZ316JE/EmNNqQWhGhprjTqq67UNSRy50HfMV5N0Ddc2WrhhwxAD84T+OuzP1WsK6TXhDPqpc4cY2Ccohd6pkRQ4WI+ir1kztNBDDs36VHaWY4z1yJ7tLks6u4h0Ef4OfJJWwe/xI4SPkFoEoa8f07oasA+yEXapY99XdSm9GztyUtiEEXyzt66c5Dy5iN2YtTqTtL+U7DH2COsN29+5TyI9v8V7z6QXK3LZN9kDHCBUY2yayGWL4oIFQoZlM1xa42DOF/oYRNZsZ8IcQiu1lTAHE6VvFBbjgAMZPR3soZacTLQTZmmaGnT9cZ1uoh4y+8ZmnVbd49FV7OmPCvxeYWyszsMHyvLaPs5+LOnyOIukF1nYbHWKMcuYwg4E6fmUApKnhIq+lcH/ye7LIZ4t8O5v+BFL5vLmKVITgDVl2rLq/kp36ICeRLoEhARSVPbpv60Uk+yb6cQwDCdl2omvvOf7JoXjElT1y85fzfUCAOfKHakRHPbBC1pYrDXMphdG1l1mVSPNvDpUbdbtzEqYTVnIsI8nc/9iNT60kAnv2+/PZa3P7lTFFS4KiGUYq17lyDfob0wylhndyQlL3JO3XAQqE5NlYgtUyMIM1KWjAQtmBlCDPrAerkRh4G/HI/xgMgxwFgMTNTUeog+Hr6w0OXatN4kfSR4ZrzCMHupzKz9QSwj0kZc8Me8cZKzFyrUCcaPTpEn2ivKmxVj6uXNWm10E3+1ps9+2KWhYm0RVgz7KXD2RscShx6GD9y8f0ISg9Gzp4vMj58/PjGzbsSNzfJvBBPLLw+BKJBb+eTIigE6mFzizwER1rZP6y/GR1Uuh7e3yRPXE+xFD6yG6uPoDmeVIv/EF0JfAojQQZCo/TfSh1dLY1ITEQlHZwhQK5DPmE5x3TLvz9mXAUDMS7naPDyKTSiAHdgojUUJKENbCxAK3NBwLYqPsahKU47V3ERW7FaNhnE8RIBkKoEYKvTyNdUhXcRJD25qw0sRUrnHLYESAzctyH+MIp8qHJKscEGYqK4m3SjJtV1MzmvJV8AThbndVLBQqAYHk6oZhGuo4Cq6WmpQsMiCxUUqvYRhG7USJhBWFq7nDkFjB4PxTXcwFI06ZvMzRKsyLriKzcSAHE1B8yOXqpPC0ovZYblkph5yfJ60jYaXTDZZr6sS8hVa+y1hbkRB8wH7o6Gf6V+R6CIJlewW7Et0TVhYr4WmdaUpDkon0D5eXiLnA8NcPepwseH/RoaOf0GrVW8yFH9yehs7qSlMZko2k6MTBvjtm/vJeHrqAFZmSE2X0wgWdX5IduM9xYUjOCSSDkwqPJS1cmyGHwiwxmjXugM0Qg4xXar41U1P4gDpfTTCLe/BLCdSqNYvsyoggD1O++H9zc0ENLNf0iZcPoFxc7/x4mjLLqwV9wPf5ZjcVaucy1acu24lSPT210WuOhCtaUOMIqyEQtyy92RAgfxYiy0ZdPQCpXMGeW75bmXPmolKe/HjlmsAqcZ9mft202D/8eODoxBW9Bwsr71c9QSX0bsjIxU+n29ZtHGnp4gyExK4L3Hqw/I8YFaAQ9hyqd74hfMXf5+7RN7ToDjq/EmbJBPHM76mFlFe0lLTMmKJUYq2ZMW20V36+FSVT1sXoY4UeXm/k+EClimqTCK3r9uyQnq9FypW1C1ZUDMhP3F688ea2/8f3BqEuT8AYPwC1dN+kSz7TV22c6PvFpH3eXu8RWuzUy58CtzT9v/+bPZtoNqSZuCD/ppmR5vTqaxt9Np7w3ui9err3AMVYaEa5ZgzkDwDOrVJYqrwy4/KIUkqTzpjF3T3zjRtC3kk7fW0dAB4gmHOC1rKjR2ZHsbfG1GRmXH4oeRZ57IlAFPRrCVUodZkxOzx7FodKA4p8aDg9mFE6DTutJsMeGZmbOU7MS/CXdWGxnRTzF00WVZNjKX/p/jqwU1RIBmQDD4vd9qGeNi3BOXZb4WCxS2Q+JCqEz/T+6bWzp5QgKBg6VSzmkFoGbtmzO1IwbQTDzNxCnlHud+rOh0umzVjExKCPJBv2gBkdOEY+t+tEab4oJAz4WDnx2SSNVyRMFIWrI8HtUV7xrqOWFp2rbWGije1g2iwsO2evxcXKYvY/VyZcWbs5SbI7T8HrF9R+QXhrlITCJVmYpcuLWKPf/+9kvmDVPngte6C4JVS2raQHjb7BuBV+SPZHTV0PNY/4JpBg+hTOfuThTxxjjxH9RfrUHlfcH0lZAvYDEt5QyLsqpXo1U0VQdskVVeC++KDkh2Bs9w79KvdX0Dk3tDRS+sR9lX6HVYgqncCZoUAfYHGaS5xOqCf0k4TJCcx2FNB9g5wU5RNZjav/vh9rExFbFaZGMH1CagKP0mZxlXWxO0L6kEsHKHs6B8h/j4QSkApNW3O721wxEgQ0Thra7Lp0IPCpxdy7cTj/X7Hftwvk8wNth+KTev/b2xdlm7aqZMXCsSSj18jdo03ftOlUx5U2F3aUA2g8nJcHTcEVoqeMIHoiBAMS2j8SG0SX1uDiNejC6Ja5kQ4zD9K/gwVr0+ocUQl5U9TpkNOFbzyj+VzaELpHu7jlRVxeNFDq7i4SPK0xnAYwtQFRi+Gj24htaD6mlmARYdqCXHe0h/ixWoSZSnQZ1JLqOOuwdRhHTBuxHY01tRgEOY9gn5u0kJeh9nb/X6Q65B9bWgNrQ7/C5I+zvEyN98wzg+tkQOzFvlokWqJ/tEQfVxYuAK9cycLWkmuxrFUrkaG2Uq3rpF459VHk/yIFmRTsXI1tJ0IGSBtoFS04AsNk2LjXtGWB82sPTSCqGSgTTl8cAWpYDT67WFuXrdx/Bfz4ryhe4ObzYgS+Mx7xPLeb31XOQAjkSY8EfpHCjB+tdHy0wVK3LMal17b0uhgBlpprH0sdEO+ORkFc34m7b7KDnw4kIUekAcsOec0Wq4omg9wdEBDD2HqGbI7JtiaMIxv0+LvSyPf2cB/5nyJxonKCqYXUKWDemfqOn1dv1QZZh/99gNokalVtBQJJ39+UZIoMMlZxoYyrxX8X357n9LcToivt7zT6TuR06UDJUdJb3hsepHd/3nct0+I/G6EL5Yrpxv7J6nPcCKsK2ynt1R3VqBVilWn7BQRBii0/xIMRGAzMG4Yx5XASfQjbNXwXeOTveOgCZpH8fesB9r5a9LDoQTv9IX1eyv0U0W9TJX3h7YQHvHu8Md6DUaNvldF431fi+8Wg1yskfi7qqY5HfsAKU2H2BR1Xm/M+JGDunm8d+6vzEolU+qtS4HAsq4Idr2SHDxzomzdxgqCjgT+hpXhjSIdttXFNjUqVp67/Jah/B9xgZ59aeq1KnaeNP93hAxWpiPy4tkpFtCzrqVU3/MZvqFLcGI/jQqy64UtsHc2vVLR9fpxiRMydxabaNqlAop0JghH5IKDxCMt2ZuUJAwJvZnP2wurINptXobQIkpVfNzZ33rxFbfn50ALfoNRfLCgVXsvo5uHSy5thEycet2nK8rF9WM+f+xk3QaB+zlrcMHUYtzDZbz9WCGKP4JLKrBRuqv/vssoALDlh3RYS+1JQwpHgqwhfRHbW8WtaquMmjBijNzHBRKTHt2DhK8dXMsMKLE281/fwsmyDhp6/u6asJCE3apI6ZfyXVIQQZbpdtu7kAyHLS+vCtJ5y56Mq4fr6HkzPjcXBCa68TNb3Eo0P7oVfLoduVTQwf4+B2XpUEexfmyKTIL9d8da/ObX++v8Ic8zL/x/tkeGGacM4zvakqT/IOGOGgCu+yxWFzm0+vBYc9dQjD/mfa0tuAM2Sk1CHqJ656cltrucWPArhhRIJcQOuWPJkxdKyZhHUURVSEgIoEG7z1nGx303mffJURChAVpQv3OJNRM1G/ope/mPgto8nMgAFh0M9TwWLODxyoIsGcmcpDWrLRYU9CTMb6byR0HJn+nAddgrsxutpOZioMCyrNCovu+SUBc1/fpx5YLMXdJWFDVj+otX9ZS9Ij1kmi6avbpQ1XrudX8m2P3lWJOeF6FCS157K6HqLGnS34r8liwi74jK/SgLv/3tVZpRFu1v5AbrVKuy2oZd7+YzrI208GFJ/5708kWVhmEbj1puUJoZndL3CxCTZdYS3ti0dC88H52L42mOPxjSnrt9pfX185d+nFi6sNllm2iI66aeAMFUs06qKpbJk4X3vuSxIrPQ6RcceMVO34AX5kaVp4eI40Hf4LWtXnQX71FEei7vY71fsWbNxApjA1/x5VaNFfXTRhD9rOLKXLt8YofN9u4hcal8VZQX923IDRkYNP1knc3xEevONxrw3FXeqhFJyuqyKi6gj/mK9JRbw/ygivmP9IkRtFCycmIuG/ocNjMWai8Cp3o1bszxLnPtrd/ntyrd2nzIy2oG3RbeaH/z7nLWbPYb2g+6x12wfrNi848qGXLCTUPjnVYME/cmVBof/MmONv7w3Qu/7bnno1TXfZ19/5PE6ueOHAZn1Zuq6t0GgqldPJbyF0Dki5HVRvYJFIPAX8WB1mnfvisuRLXKwdrffbjAtxRJQ9Aet84B7RsJSKC7833hN4d1/ZC3Rl0+AZzW7z79xTzs19fYfBlmKT2f6x3OFJwp3nh/l27vJhv4Od3Cfr4vFiuZWe95KN33Y5l+umV89fL82yi/hBcoiQfWK/DQvYVvuidkWVVDN+F2IujVfdpG2ef/a+v0/KAOmXX5wkycAamtGIp4EO8Dkn0cZIYsd6Es70cnjqhPL6aq7k8Ep5NJjs3G/pjCbHe2OOmi06a9SwykDP4WfQKHADqKSxBQy3YIJJcnRvhkx1WHq/gfFLMEcLat/ORUnuXPqgOxT4B7YsW097T480EaEn2sR6wbgB7SK/HyeVh2hzy3MTIaMGXHru9+/8Tb+eATAXfK49OJs63X4Duf/dLgof/62bnrNPwPrV+SYxbmBuT8pxYav+OxLpMrmTvSP9gc/Bu94O9+8dx1u11/it/c3Rs8PCaxTguHyQ8/Gyhf/SoplU9KnJ9gz5kQrlhctL6sqjRk21JpIjBguQ90FiGh7YYPX8FmXCT3rQHWE7PIgGtWhFKoXEK/rY1iJPNVoFgtV1+KmvVGFQSNEYNOwDlZhy7dTZq6b83+fUAjO5Zy1ylqLhTg04WaCC1nUyUlDteVoxqy3lj4TIMnn/hQKSbaxalsFGWnq9Xk9T9LvuG/E8lHBZKXcoqnHfc60LKMpk0HZZkknc7kxSDcCig1l7Wk1I5IcWhYWt2FLbeYVp0/g9Ka6JuPBizz+Gc+xS+q3fm1JqtZKqnRSsbdw1JhIlkafJlldTy0ojtMOo3Gl0aSQgtdEuFsphIpQ29tKDTtJxvDG5Uw5PpzpZpOqJBV7OfX0d5KbQc+o+kW78o8Js5qE3yPlYJskK28ycxZTzFEDCmHB1DOWkSTm1G559Sq0oyyFHfMIl8B4jnsUJFHf+Ki4GRCl4VJgpNXfQNifOlASS5YoBa7J23dxIQis99c63JsqYEnedSUncbwW0uK3aaWD1NBKQuHPYKtw7pyyFtamnjQmwQmeMAvKmv7V4l6ufbsvqDZ8YXGVW96BZwL1QNzdCJZRO7F8t/Ec1p4BqAJKuTBolyr12mME/0XO9JE/1gHu74OWlrlztAPSkaveVe3cGDrU2nGIXi5v9bkESWopt1ONg8ZRafl4nFeoT0C5MkmdoCcycZaS73ZMcODIbF063NhjCLqeKDOcFbNdWmAnhSvlEFaJbX9HARIlHhW0d8mwQmDg1bhjPdyrGtfJDVbiCJXMSwFGrbOdPsaWcSWlixyQS4GBqECi+dDMQVrFbGRaSY/8EGZe7X2gG7uVb1AakoDBGrHvrY6sGiWlCK0GhS1QksjfxmMt24YlL63C8bhIPEn9WAOtBy00kiYh7tGEAS3yZPfE6twNaWDk/wolJ91u1h2pM6GWrtI9tnJWIjRqqV75vX7mQlgbehhfi24WEKgXPNG6jSOF73SoXE5W0MN47FinQVepdFITGFiSiQc/VhGMn0VeT0M7LRAQVGoFXjJp5b7uClbQtFBKHLBl/+gC7pHXIrYig73NuxUlWkdLqyDh1tHZBq1BvM3w9KZ5wFyycx+JdYCdw8wNjsQ6SfPs+hHjdh3SqxgwZR44IlFHLeMBa1J2yOoc3qGh1Vug3e80G4UkmydQmi8l340ClbKLx1KTMqThH3ub9c4aDz2H1Fhh8ZILEitycObuaWDXsIItclp9GNJwxyuHuMovwaHVbwPRZAgHVl4l8zbo2c+umpcRl2ZeP7xTHWIHpYVMhGuiNH3yll35mDjbEu09XDh1eOtSs0XJixBGaEoR5YxA8Rhqk7q0msBPmUlpC86dt3g2CGLNwptjlhj0zqW8w7iqkVdyJry4R1IWu+eAFqtZmycKNFpI+IzjdlBI6xA5bT2EROANgLOOS2UtBlve87DJ3UxXR/6MenPz470cvcuIjvNrRZncmW11TdVMdkS5Pw44c4UTkEcRc/sxDBQxhOeXkdQxTULrljOeCyvnnlPEnrctHikD6bFrl3BycXR3ZWQ6BElnCDfYRsO3O7Bj7bR1XGLSLgADZHGakdYUR7VBZrlS9MhSQNQ4xqBdHpxNaCSkyfYTlIErfq+iFxHeABHvECBpnIqkBYGyB7XTeh6JcuCEoydGqYV1dKNG2tpZYjbuvNToJVjtrK4Eh6xWWrG0YFAakprYFQcpgsv7iN92QJxgiE7MM0JLGPVYN0p/IcjpIVOQnvuE9R0VEU+tZ/NwoPoqpOKOWHjnhYXku5XnfkkG9rR5VSm1guEnQSZFo0h6c2U75I6NFqWjHklqRKAsORKnEbl6h3HPKeUGABGkp1SsvAInzu69vep6vuTlyfZMftkz+jxLWcnywLWyoEO70HkfSHq6+FJQa+Ie7zHgJT3yMlQoOf0XNl7MUzKM3nT89P59g5od8xN+tOoA7yUViig8dfqTot4C/OZg0VRUDHG1Ri6549bzU5zDq6LFl29SL3/YkS7cN9u04SxFJsn2JG8+DgRueHebYOQGlQWcKdy/ER0l5SPcVNdKWAdZ6m2zR/NNqrRSG5WRztynPKYrIaiEgS/cHPLBJspmyh7BVMta/kl030iGnR5k6fKlduki3HKaD9O1dGxqTFtptJaf7ndfJB11/1ukiIGl651ZSiVyfBRmEiQjkzwLI1484zRIbPAQJNUs0lYn8XSEeybpFxWJ/DmCv3VlkYbVm2SoubV2fXh8k1ua09L795woORuNmu+bmt8SPTlGkxc18KslMioGBt3QRBAz3mdQ+tqqoz+yHYG/3THPoqtbW8lcbl/M9fAqVq8HpP1x9MbX3PC05NEtK7mu42xz5/oa5QZyS4bOhOINL6ptgnF3oTfGrLVlR+1mlwIVyoXHZm0Y0pNMV3w9UkdWWShyfQqP20r22mk2STYGbn93Hu7I14n23rzA0efRHGdFX3vkPdVyW5cRhKEly4ENswAp6w3oNCJTK5XptcVe4Es3c9oplrastPTpMr1no4fNvrMY2utRvxtJz3N8cLtpMGH4JpCk757orCmHMS9cWumrDYFPLJcre6feJanndNSycHKL9a0kIUUUEGl4FHLlKqgFbyuRZKhFg6klAiU1Wb39KeM8f53gtKE9/bCvW7rIUHpxbbl4Gg/Scw1YmCfROL94Wgilnnk1zl7oEad6z3mE0tycCSs8xRJzay0BxO1eGdkKdDpcEfc8dTUle60MkmgerZ365qvTG+pFT+l99tyKxK1nccPG9ZmS3BNlxS3KkZuzPE13N6XcD66p9gxannzHK8lpfBLAwtvunpEi8sATcZd1AXeR6XF/VEPrSMOfkj95YOFJKDdKe3HAKu/DtDOuL6PiYr2ajJgM09Llhe7dLcn/InmW5Cc7HeCanhpg2ScSNTo4eiOGZ3+xj4mjgnpilA4+kdYymFrhLiyoz+NyJBU/4RRdkLW3FlZwv+fUUkYzUkquScos8lwecoKIOlW/pN1LiH+pyagpbojkvbiM9PKWeuwjgtpO8VOzRgGfTjmPukfDJ6qj1Moi68VZConF5pIhkzxz+wTymdLpRuSsIElLIdbGPI2B3F7J8kJkfLJGtFeEcDNbqwXsrTHNy0IL0LSSS5xio4Vkr55kJKOGVE2jWMPIsBS4UbWwCsh7TYnlTH5PorXYqcFxRqGXIvlTNSafPGt8FYiijlKk4GW08VMdYJeJ55inJXciRSSaA8S1sHGl7NOUDMWi2JkHb1YmUuJ5TdlCKSeocIarVfvtkmAL4GEtcZbJFcvCfTY4ybKIij9xBZkMTKVIdEnOSkn1jNz6BJErHhMzyYiVXPafvjDjPq+K/e3xlQP6G3kZ09l7jG9QL0m+1rFpuItq/ziSTv9397XaauYff5n4MrcvFFD9vjtEnbK/ylcQ6D/IMtsg32r5lGQ4/ZzSp+3YkjLvEm/91430udFx1659uzirdNBhD3A+3P8XeMLw8weW/AdGjnbarZ1+/YFXQn9kHf5ImH7+gWYHBm22J2TdYMKIh+XK1Ip78wghlYHHjsN1/jB1tHdxjqZL/hcMrSz6F2JF44RRdwDvvf+9Q+JRjmsjuhpgfjHznPQRs3vF8SesPP4w1bL+Uba8/VGTlge2ciLkaAr475ekhOTGbCLZ67aHm8WirSdCIzOR2hSEjjHRqw70LDd4/kFALJ9/JpS4PP9GnHwlyxPR0o8ItSm1aXoSni8SVTILS7SWF1gKlm8/X0Z0vYrlYPl/PZ+R3O8dyH8DT+NUdl7sSfmJ+g6yuevPjvfF1m1OsHR0kWXZMWGThBccJ+ibXikVKM8RNkuEIWQoL5M7PGk0SYVNnZf9bIynxUFR58We799U+Yn6DrIF9UPIX2wrbMnPWQKL0RyF3vkUTZRE4AuIx59T959eESMqgHLLUeS39FBEHBic3/niH3aYYnhkZpALMzHDqajh0ZlK0+P6oxeMWScV6BAKRtAYmPhnL2P+jbeyvgBEmOBVeBxzIZU21vkgjOIkzfKirOqm7fphnOZl3fbjvO7n/X4AhGAExXCCpGiG5XhBlOR/htH/A6MbpmU7rucHYRQnaZYXZVU3bdcP4zQv67Yf53U/7/cDIAQjKIYTJEUzLMcLoiQrqqYbpmU7rucHYRQnaZYXZVU3bdcP4zQv67Yf53U/7/dbACJMKONCKm07rucHYRQnJs3yoqzqpu36YZzmZd3247zuR0iljXU+CKM4STEuJGlGZmTLniNnrtx58ubLL8jX/8WIMKGMC6m0sc4HYRQnaZYXZVU3bdcP4zQv67Yf53U/7/cDIAQjKIYTJEUzLMcLoiQrqqYbpmU7rucHYRQnaZYXZVU3bdcP4zQv67Yf53U/7/cDIAQjKIYTJEUzLMcLoiQrqqYbpmU7rucHYRQnaZYXZVU3bdcP4zQv67Yf53U/7/dbACJMKONCKm07rucHYRQnJs3yoqzqpu36YZzmZd3247zuR0iljXU+CKM4STHwm7ajs7p179GzV+8+ffv1BxBhQhkXUmljnQ/CKE7SLC/Kqm7arh/GaV7WbT/O637e7wdACEZQDCdIimZYjhdESVZUTTdMy3Zczw/CKE7SLC/Kqm7arh/GaV7WbT/O637e7wdACEZQDCdIimZYjhdESVZUTTdMy3Zczw/CKE7SLC/Kqm7arh/GaV7WbT/O637eb6/+RxCACBPKuJBK247r+UEYxYlJs7woq7ppu34Yp7qpqJ4NqrNajvO6HyGVNtb5IIziZDxCIgNaBbXZHU6X2+P1mX4AESaUcSGVNtb5oB35/wUYJ2mWF2VVN23XD+M0L+u2H+d1P+/3AyAEIyiGEyRFMyzHC6IkK6qmG6ZlO67nB2EUJ2mWF2VVN23XD+M0L+u2H+d1P+/3AyAEIyiGEyRFMyzHC6IkK6qmG6ZlO67nB2EUJ2mWF2VVN23XD+M0L+u2H+d1P+/3WwAiTCjjQiptO67nB2EUJybN8qKs6qbt+mGc5mXd9uO87kdIpY11PgijOEkxIpiWy34e4/bw9PL28eXbj18AIkwo40IqbazzQcg/4v8EJmmWF2VVN23XD+M0L+u2H+d1P+/3AyAEIyiGEyRFMyzHC6IkK6qmG6ZlO67nB2EUJ2mWF2VVN23XD+M0L+u2H+d1P+/3AyAEIyiGEyRFMyzHC6IkK6qmG6ZlO67nB2EUJ2mWF2VVN23XD+M0L+u2H+d1P+/3WwAiTCjjQiptO67nB2EUJybN8qKs6qbt+mGc5mXd9uO87kdIpY11PgijOEn7CSZhlIqT/52CCyczKzsnV+48eQEgBCMohhMkRTMsxwuEIrFEKpMrlCq1RqvTG4wms8Vqszucy7SmDYd9N6eB4+JauJIm4EinePT6ABQp5p1hko8XH4CnR3moEmzGOZx2R0eybK3jouTfTpbts5M3ToLuNlNkHgpKInQdVIrVW4XJvJLPtXT+7T/OwBqJIpi4nScYremZJrn2Hcrtkb8eNEyZ5ObShxYL8XlQfDgNfZeuSmfjUuUv8rz4jHRKJ8zInb5QshFMtgAzC53LZci4obgefpX8rkyHkye3wSLo9cIPCyp+d/C67dgjc8Kl3AgNG148ysobPZHTzZ67HVXxONNaud2yZrIhMkqid1+xJK1fj/6/Tm1+r/+Uz1JiWRtplnHAIIXcMgGWMoIukdBaOtNg6XHOP/dxOZYauvBKWZwurHTllGrpNSjNclXhsvC4PAgPt15ZBhxDIlsEi9IOiI7Lsy6Ul1zZFlgq6xJSjpIf+y4sqH+GXYhoqB/EsLD0/PLlij7e7mpknppQtlJfSTggZQimcyE6ULvNSSs6fxQPyYTlcK5SyBs53n/EzS3vr+f+0yxDCuwbWuIq65vQgxEEzSYWJlfyqeVhLmd/wvjpncqh71oHpgCFvcjQYcnAOoMHGvoB5iGy+ziy5c1NYcK4/ajFvLpxJuylf77g+Ms3tLbzFUeeO6WTLU1XRD1KcSVWVkr5NIriV00WnIJwAGUqcMPkGJZ8RlpaEisHpmTJptFCpWxZbm0ofx7kA6RfKM41iIU9qkliKXm/OnkyhKhXJJON0feuncbVYREf231/PQvX0fSovbieC2bkYgDheL9EynghtIxpot+Bv9RQK8GM8yWhpNrsdwTT4XEP1NLjdNxS9L69Nvur4NTNkyhOrYw3lMp5T91KpgGIokJbRPAm1LwHLVNXTqzq+9GkkjT8z3z//hr8sCy37a8Xii06GhzgnJ8+2OXgonxlh5Uyu2TTP+3vZ7aGCwEJlfR2ITWcngLu3arkYYobR9RrFKABiqxPzRpkqPp8TaTFo4phveJrYt5+dw7ruPkQQlfWZeeU7J7hue7vXjZRgtVyN1dTazwBt5Ta3PjRra/lbt78PMih2Nv/5DD5/+9rsxM5dHSghizQhXi+fLGWjxtMlt48XStZhHtnpZ0ebv5WB774NRbb0A6o+mTj+lbO7ugvlEUdZ/6/kFwy35JxO/LJ7HD3WbP1svWxkHljEYrRbVbenOp559MPD2iZ98e/JfrMOfbXc391GAdN2XwDVrnwaY+kr+Uw5/Eq61j6RVUK6I7Z3SYeQiqeN1RcMvHOS5EuSV9q+ovKmS9FLYHbobsS5bfLI5tYZzAvKmaOASgl2mdEJLphxOTRpGXo8dKEVWLcWRXMZiDXKKCId1+10rqVZdhxCHqpy3Tb2zQWXg9RkCaTCH0IyXXcrXl5/KVLwt19x/5qeuGdlTI/sK9XjhxGKZWsBzqFVgOHluK4nyi53l9PhTssHfp6EixJToor2fLDFT5df7hlaajIgSGyhAWGcj5Ivh4sFMETC+fp1m8wkVYbml8P29CECQW10G/Qk2IJjihCuQs8ypUR5DDZe/l6JeJ5xefU27ZOnN9S744P6QM21VlaO5z5QhIhV+7IwQsL4luvinD55daElsFGCivdB1TZim2b+Bmqyv2xWu+sCxT0jF618zRoORnTkHWn2a8jMjlUxby1OQRBmDAL5u/ob534EqAuQvXPwc3rf2atvHEdKBCDk/5wz68f4JwKU6D3dPzj9YfDjg5kI99eKuFgF1RqVglYN9dMyt6LGGZOT1I1fdw8IdaROS9JaC8X9HbD14rSG+RA/a7N8y5Ioun4/N1ptAdfpuTZjcD89gkB1iIjytztJLwTkqcPa3Xjeu/bRG1MVzTZSirW9R5JjhOxoeZbyfd0E1yj3VkZALWg5Uf0+gQGo3PrIfyby0lJ91bEa5a/LzTnx2aFtuqkjduywnb0jwCNZ/OqefcBHozueje+LCakYzlEg6Lvi04lwTHZdCFqPQleVIOg1xiQACu5rQDMBZOenWZYdMrh+vX7yd5R/ea9WQBJgfXmsxqTSNy32FV6paMMHceocftVkLyZ0onsVb0oAg/KTEdlUw/yEbaW0pyUjjsCNS5ukNzIo5Crek4WHctEMqou686ypdd5Jvlp2NN4vVGGPS8r+oKX9T/V4MaGMAV5Tw24OPSgdtTInu9QjfFU4B2VABVJV3K6Eb0U7db460tjOQTFVKkk1ZeQJnWlcuAkVOM1IRP0iDldLgianpgdytI1Vh12qD43GkS94+db1EclDAGVst8RKBQT85d3KH3sqDvIS3DEJM+KrwKoBOsjUk4KNNpSpYiWBtosna5/+JE0y6nY8dluVoqNKo92/+nXS3YgBV6H06woR1+Zj1ijeJyPaRLqCRiY9ggULzsPJEOfywZLjeD3Jx4J0z7vCCx9YEajdky8DIU0yVXzVZgzxbKSeSKBuQR7oDcfcDBtqaID0klmBpNE17DOrndg8sWRL5ueOzDlknDEuH8bTL0cABu5GOvyEFSzFadCvFHNvOZpdOH5qqUWq2mAJdm0gX5GO/yWrS1kMLtNKHdhNpQ5odsNR6wnOliT/GWxoL41hKWsw16hUZvIY+WextlCVB0pHckV1apLg9W0Ha+rRHNGS9i1Uclfg1AateP/ArOVERDppstzSHPLjoSH9KC3+1fUhWDlSPNTvnGA0MRoJav7Joq8rpDoWQ4qHTKgMpbl/U9U2WsOPhz6Trrcg0lAaGjcCguKiqIhYIHIEkuFgk5kDxhYnp1Jq5xeQF8OuTUCJ6zkjwxfBvSsNalXC6jICeHsg4pcmy0eEcSv7Hg0p9e8Jijx1oGSakpu4PRwoKYq7OECU5vnOzkAtJblCx+KiO0BFGzokok5COmCMANUwPCXbVYCaF6nLYtwK97t6tzHINho6Ky6CeYjyb8mfk115h3XQMc44PuQyj6QWBIasjxADZ301Y7kdwHPhSPxF2jCDO366Q5qXG7kg90AhY6R9Nv3Kn3JTfrGIbYOQyy6/pg4TJumdn6Wobm+U4QxKG3CYjmfmgAZ7irnGOcLxHdrPcVushnMTno9o5JXBbVGwU7V7m1wxZwXVhS71mpZyBw5C+8dSgdLJu+LPOfxeaA37B1eKxVjnQx9QrUM8koijMCFnAqOCXy24CviUUZCWf09ZuEKzOa0tfU+CziPI1Evkai3GsW5J5vaFXv3Ia1Dw/LU4IUja7Xjtj4BDnSeyBL3+fmljYSOswl6rdw1ZalHHinEG7RcDCV3gVsqgOVKftexzDmjdNSWlUWN00KD4m8RAOYw8YHQpmgNp/hbhYgdYTdjU3DD09JMFh1ZjnhKcK0G8Nghvw3E6HmMyUbFmrk7omyIW/wwUdaifC6TNaxaRmj2fQO1jJTl8In+FhvMACUDTurv2DxffE4nF8NaAkrsKzoSBFcUe8pIFg1lQRXVy9xxzogSq7CwwIpazzMsaG3t5kVRDROqPGmMNNn2GQN/jXn7VLM4L1R/u+Knwcs3IV6Hj9hE+Ev/N3rkv+Ju/lS71eYtIlReYyuoNJYgTm0yuUU8SDYIwxFfuj6mpPnE1+gS4IYsm3XE3WI0m0acgIB8Ty0poMOgzQBOnt6jd1ZMA+x9h/g578KFFw+cHykxMacIlT2xGM8TmI8iawGUFngFmx9+q9VNn2Shywh4dU5Yx2//NkLYIsZuPB8vkjS+exM4c8pnLHTP+jyKPGzzHVSTgdNUxDvX18JmzkkeDE6RqHct/IJ6/guEOZwqmGUmILzewwlUO2C+cSVLXxKcUJ2OqgLGpvdnnsh7MeRAf03pGDius5YABijQNBq6m5rXhwAfz4Q2InyH1fxo9JcAAgaoEJF8ZXcHIgoWXt+DyX8LZv9TsPjfB6v/Q5D8H4Ps/xQU/+dgk18audMJ9Rt+pNuKLU2AWuH4tRO0jfU19Zj9hJC8OjYs4Fcnns6Q0Ky0n4Gq9geyobqh2sp6J2+n+TWHWHnuMTupxsWNNXGhqmhl/rRWYIUO1eqiUxcslGtM5NEi6c7nJC1ar84jE6MwrdntPE7yBYV+U8Hlkq1065RSrBcT67Gbb+iWAfpM8S4UuNjF4XxpMMtqjO+EgKeNE5ULpiSNPE48UHpICkWsrdj2qgoFsE76YG0T8jJWdMpyh/2FToVR0vBNbXX7MIVRV+1vRLAFz2cWecGb+7lTUMZqHr6f9J7fBKvqLc9hGiL0Hmp/sz/vyJpQULLPw3K3MmxP3GjXfJRr97gdhLlFSwm8zs+G9NVP88+GbH74z4auUyeCHwSoCROJ0YAXQyRKCP2Y4y3QBNBTBtmiQXbopgTVPGqLCzbqWBsiKtmNOsQc9BKT+fs7HJDeOSGJxJkSpiDF5rCizJqCEYhkvRzz7kaNW1ocK5NmfsNTRMd6S+J6NX3dAiCJT8y7N74mWyxqn+pyTyfrQoC1AtLpio0OR/PDO9Xx6Vod+jRMOyRRSoJnOkqAOYB3QHWpcwC+9jzICWvQaBI07mgpg8blngplwrqQCpcdiXwZSl/L8NfkOkU2vscRPNtRJjaG9ZLL0w1UdRq/yE1Sbp9VOJxFE2sUKJstJOSYLknctzHJ49vn1iwOXwQjBhllcryWy+xJYKSh8zp+oT3iNw3n/BTgM71IiY6o/IwG9BR9vZtA+p7F+rqtRZy/MZvicBqzjmwYGgRNM++z9pFE0CjzhDWoEtmKng3e2RAO+KDR4kYHTYtArW73JGJeh9uBMNXr+BxHzV3YjjsSd6DTgYuqMwQ9u8FPV7SxOkYzi4YyoTnz33FCe26+pTuBudFfPnayoLWTeJR4twJWCvYQK4cCdrebr1zpiew2hpcTKOvuQV3iNNhglCkeOMtKSuC9JzihfFpp81G7Ue+GkaZ90CfNDZHlZBm4xxY03hQEe1qvEww3ELQJSxnOSUE4w9F40rDk4rtetJGhH9nQsgp+2hP9V0xLoGD8QuW8PSU8vPQVNMNcFp4c/YR4Dw1LWRJ+AzzURnB59jHs6r8yDZmOQIJnMIqdwpF+6DZFEqSIDlFQ5nVB00wIoZNxHqPYIdXTW0TxnePJ0kKkxWw0SSk6Q0rZ5fb4BoW8tIICP1+UU9ztBm02OXDchN46OIUBzQvO9Og0rMzhiK8E7iAjOK2sMyyMLhrqei1x9gLkJ7MQfpUt6AKbLhgHRhQasIXVonN+n9wSiP9LcGj1EwT5xoVyCqTuRjRtXTlxe10jaFjRQGIbr3n3kfU1t3kmz3TdL/X0wLqUc18mtrSiNyynOycIGX/5glED6mLl/wPgW7Je3zzxnR/cqtM5ZV44T8/ubmDRt158jzemPpN9C0pBdMR6E2W7m9+QjVCUQEe5KcphaSNKOe3plNen/lgHjbHDVmiGCryFT+8B9L8PkP9DgI9//DMgsc1Ve6p+kkcrWussGZ3KqHV1zxG6sznnKXWtpuyEks9sT7OGLEm6m43q5p1LQ5jocVJyoKEfhjphvTdcOPkqwFsjapsCGEjSRjoITCELjSJwSRkmkLRx2ZFYONpnIXpXxQhx9nPge9jWOkdo25Cqhe5P+Qnn5wdKyV+uAH7+qFRsogfSkeG428AX+cVoLHSCjd6WMTlmpvq7pKY9qxxvaK13xJZXU/R5OIBVya+WM/SFUXQcR/mwmOblVOSmAiySNRtxt4uzrmN4UGzEgjQxk4Qv/plLUC9CiSLHrumQ5Gd4W8Bp0dlpRtAdvOo76I4hvgd2XvROjxBfIWI1K5cE1dyqkB5JoxQ5pNnGi8aVIPhB/Ye02oPjMVZKRjuDQtKHA/Bo4yK9XkHIIyIp6NRdA6CPCJsdeeZXPx06gpMQBsXNDz8vvScciQ7nv7xi51K4V7cNauQrFBMpDW4XIV8kpxOAOtR5e1iGF4oJz8xEE9+Qmiv6OEx/AXi8Ji4CJf4ETNinNs+PL8Q2a6r+iovJ11gv5B0LJ/gsyPH4ReukwArT+BJ0LQQ5G0TMj5zrZZSYozgajnaCm6GsdmOtDUGexUpHhTSTcEXm5tiw5jsNrcDMsQKdJt8ALtpkupPmponiN1p25EqqYHS7gXfxYUfPk4RR0M86jsgcWwpuaIdDMi4IYmwm6O6Rr3ZbabnIj6FAjlJ5T34ZeRNi28bXlVfQ9NMa8sSQs6LUJA1aCspkXX7rbzGZZjS0PNGCPrS71xLnjSpjzXodQ8K9DFos2JqmUVDvFr5AXasYnTloxVA9LdaHDPwVCq/P0wWhFcKlnfVp0xA0Lanoz+84D1OU65NQvFkrOXaVTUGqtlZCI1oAjgFpXRHmohMenn97mxI1d8RSzS/Ai6yQKIc2bQuJfmMbaOtdzd7uCCoUQAGlKwjlQeWGUEk6BzClGkLhZo2UBuUQ1QnyhKi/gkIfZQ2+EAhrihV3sNMOfQBK3Mkjf1pI86MHhhou3XURA3qdX7ANdcT6H/8m5oegSAnYYlM15qEGue1KNLpZuP4EL8l0XmFh+m0YrEsET+JuZNAzzObdSvfyrQdi1jUdZ3hw52Zzbg4xa3Q8icA8h7WWcusJOAw7yGc3xqg97zw/8Zi40TUsh4qpmTwf+jTwZGbpTov4rVM8TE4dOTsrORSzdpRbzPD0YPREeD9A6bi0eJh1v9OiqAlHa6jYivWDbLqGSIM+oTk3hnX5P6G5gjR+JACIr0hgT2FMwuUuRLcMaT5gosBPhIARlRVJRSHU5IJjZfsG9SL4Kkwj01RThX8T1zzbHyhbKjZNAu9v+NojxlxxKsS9Md2OXNEELMlTEVIpgrhlFTbjQmCbStYxrR9wqkTtmFYoGLt+Ja9lPjvFmtpHxaHxA9qikL4N+VtSc97Q3hFSNtJJ2ezWKEn0AsdKkzc1rFG+764TTu2EeFcIWbAea0IrMUZw6XyHVm0SeJ1vwf3VT/OPYJsffn2pHmRzBvM9BkHwhGB51rxGnwNciMThCI5PCQTjzGkCwXe+p6qM2WYyxoiWwJ+atVkxjiQEtQsCtLDZLgLxs/jR8/e/M7RShWKulx0QVAh2M+Sf+GhQ4wgnMhFyQL7xj2ApMEmE854XAp5soDq1EL9pHgVV+1Kh/cNRVqpDfArF1Ey+fSVP8+Jp+dnmWNH1cCtaUvTkwLapR2se+AkFIyJ698Ek8Qsa4BUpekmtrbdpRo0W0fvLoDLcYEJIgehSkFDJPkG0AWzlgrTTFuJX6RnWxtKKLtQ+QUJBaaTjyte7RIhtp/fugjSphLkEeU7vhXPoaQHddWdK/g3S8DasFDXx26RGg95xdAXzS+LrtXORjh9idvOzrpD0Dm8SFWmJciVXymfiTdpk4jwvA2qSKv4u9qReLta6KWnS+ffj6adrbdxgcMNel8AxIuNnvxEUvrRRBhghwKxNpnEM3puQolz8hBpZ4TWX9Ltdo7wfp0jigxdO1Qlbjq+5NPQE50sPZ0V1Wb4I+u6s716qkUEerQ7dDFN3Op8wDjR0AFLb7Gj5llTZxlMyiPdKy3F8w9fIP5Mxzz0AwLTHwYs6qs0/MgQdvsvT+A9JJ6628ukE1FZcW8oTvG9OxFSHyDn/fYXiUpvn55cg03SEMvV+c62Qj17paUKMA7dvI1aPZoTgPhfcOgt+DDc4lPL5Botz4g7cJwz8EK3lSnfa2EakwwV5IlypplF9XIyC2BGaAT90w/LtRvNvHHrekMD4x9mBBKRUGqA+tVJNrQgMmWAPSZ9OJq4CYHOmZl+uL8B6WZhnSnpPo+MNiiUwKFRpfB31lRYoKHXbI8QxwCQFXL1NkqpbpG/ItWYB4AupERkxoQqgTiRn5Tuv1wgTEbrY0JcKkX/pBN25oZ+GHLp5b7cZG/U6fLHFRgtNhLiB6vxThhOoToV47Pr5QmChukJDAA52IuH5siYppqLvIsqN6fhUsXv5QLm6jWWFyM/3756EfguK2jEp2w3Nlxc0aqCnD4DET0vsukBUiKMYBp/++sYPkcpua1XiVtX8w8UxJafQ7QPAcE37b498aX0oRiffOMwfiaClGT5aGUB88i0WVK0fcV5QJDA1bEOPLTVSC/5m28jMEhC6AaghABP/xjhylnVxKbTTpPZcXQhKzOKk5cSuH24C90IwIpHOu5st7Vg/6Rk/Gb2aNAnBiZukBFAesHd8J4kTheIOJDB0pCE0PQHnkeZaGPmB64hQBCPwLTaIrmGpLCDGcWL3Rwsavtt56R56T5iZpAYhkAmO4WtUrfG4naErlec62iSTVe8+AWNHr2av7U/DoXTeDVq6wo0Ee9CpPdtoEcWUErYYcZ4lvqfwOn/3At58+vMlEBKb50z8KKm52YKmWysJaLKzivC/EGcwSxPJTOhwcZQVsPd4n+U0EfKSzMC0YYREzeJGmswzlxP3CMy7J5S6N+33m9i2ucZMDlY+ZQUUvFFdwBdEsjW/+gADJum0hklVMkiNwc6iidnSGGW0CPxAm0NqIwThDYcaPyJeOGqr5SHirc4mFYQiCMGWNPOlAeA7PAB8HvLUxlTNI1vayHlmqp0IddTDDSTc361NeFGLJkg6CaFOxi/oJC+pTy8E6j3beHLeoxCcR88F6pKoOYDygGnL5+/Szjtwpnjn10pasN2HG2rEMxPi7BGutFwQYGjSCHmKMiwCLqQVK7YlhMwdT1Xote3Vgm4jqMJb/ePCZLS2bes+afOpaju2TTuWbMRZgx/Xgr7Y+HQlrDoJM2qPIj3EGXXYZ83qALZn1HF38XmwHFdLC5FO2DKsZTW0gc9qykbr2vnRu6ZiVOUiJRDxR7KyYmbZY0zWkKVwkW0io+mswg+2SRtZ++2OwkKQ4bZi3OjXyLN5VzjQdTE6EImEtkKw3m84okhHxi+jMHi1QqZ7Qry8+RGzrMGj2CnRvWsv9SZzRCHVslBq4WI9ZFgIIgM/TzkOnV9RrZhQIYbq6Qx5bMr5gSeWphrHbYfbFTWQHp3TgbTm5+mVFTNWO8KznOtCaclEmIeXH3nmm8PqIvbwY7QGnDNKLQC3PKlizJHhuX12dOwqj8K6ZldPNnJMNNcfUCVvaiWseHb4i1kDGwkN+1e4UvFbBbXD6rL5uzu3M/MlXlr4KqSVbUB0WK/lvmbLyaz9/7rbBr7C+a2gXNVAnyG7Z1+mVRh5zkD+UiQuju0stBTucWjSVwf9cv2HP/xX2O55RFbjEOJ4XqQwXH70kXh7ILKVobvCfBvPGHUD1xxU5Bkawbz9HCpnHkl69ivMKV2bE75OK9sFsz1Dgk0KpX14O2JzuNyXDbZCcGTPg+btJ9SJV8t6UqfOjF0j7i1dOqbLW+L58+ZgJyo/YUZqA3TSmGWAL9J0/JSH6dtvqBM/J+ksBjxnTv+JkCYqhQ2TjLmcVRMq9w5vZ+OE0tdlTWeAAx5Cp1JEsie28XHOClzKGlcvZTRqcyWqT10l28mbcvN7rG1+Bn8e1Ez0OGEzXd6HjMbrPA7MjsjPmO9oBMC7ULmH77kigNJOfY61F44d/3//1+FcM6FW9Z2B2XB3rvafsB/3djBpug+7h8OPtzPF7PIdjDje/pLPYsezoJG9SjDVqJ/AvHRslDVfyDreb/N/pf7Vibsj1VYleC7BpIWlc0OnXHAYpeBzXDll1oUCZbIeukctZfnLyQmurvgjtlknFzH87Dcz+J2n119vY2k1efZaivFdq+MF7zTenQn2Do043hLJJ/7Vhiam40bkKvUrTMr5MF0I/dmtycrx5vVEGIcrvkae4hamm8+eGNHWwvjBb2QH9N5AJ3OS/o+OqoTjHcIE+VInMpk84Shg/RsyI7wCxcZGnsc+iHqVCv1qrKieWVlyJ0FeFnakwVe3J800WEDgc0mSCyOCMh+Oc0m+ynEVXCLZDigXZFnqHx4ktFnhaOnYZdya+iUpf34YhPSdMKvVGU6LHz74PLiTXTonFfcr6RTm5E/ox7JpROEviZ/YvP80KrqLNj5DHXEYs7281juS3fLIntbCt5UU0ZhZlyE0yKR5/wv3ItU9bFe4Q+P3jAYHzrNuGud5gaDwxuoyAzmZEOcBDC4dZV2yjYOGf/VWIrem+/9KOt6DCmM+T7V0BRuZzjmACf4QGNkAplOd6YAtkm7CmtfA9IkvEsqVtoLeV9d1khkcgyM1dZurutb4vIfXgxKptuavUEn1KYNlx+jRhVcK94v5/GoJSwCegkxl1tfm09UEJT0Akt6/Ur59EGq2s/8WdXwZzvNRhXBfptDjyA9oa4e0wglOaEm/bBPwpKiI48vBqhVU8keRxpfTdTHFYUke/seZ5Oe23dokOm1KNDQGqPScbHwbOpKYCBxS8vFtrlyG/DhXCh4roV9ROu7bqhOlrDOcLb/J31NWsHmJuK4dmrcfUNlpdDpWjuPrXGTOVWB8t5iWwNJb6kTGaMth75V5Kem+77M3kD4ZqeVOdI4JEaUZKw4OiFo49GPbccymFdKx7yEjYbxa5pZ1XA0kkDEtWdN4mQteAOW371EcOYlSVdD1tT5kHYy/jUSGVJcIqpVRFZEYkR+T/m/df5yoyUnAWkzV5dLEN9Qh3b/uj6Ei728+YUbx/WIAQnFaSf4234J/hTVp8bdm7SWWQn3O2NKsL1GjTKffvzRRbQXTdeSzyn9IPtlSp0V+Uvm/XsO4iB2Bfp1GLMGZzITf9PZe3vFEBJ/VvUN0BaGYOy8Xy3kTxm3GfBTjTTNLatqi1sabVrlTGfeHxJoNrSz+Bte0a1sZJj7GNVdRcNN4M+MvV9qYlXQj7B8gtqmkcCU2+weTcIFQEh8KtNlJAhjDQTk5DNA5oWtV3oi5Lp5yZSElp3+uSx6cLpLMzPnJWX4wz1RSzW0JulNHJ2nDn+SnJOLzvp9UDb0Pocb/gJrTU7GMI47jnpZlb67WVLUkJA6RIwRt3M43xH65jzsxZO3vRyJvdz2jpex0Hxy1U+bW1jv5Apce9/ZtEbBzdT4pc+hRM5+dG1FsVV1Q4ZDDmijbp8UqrRMEDpoAczzB6J/hW6/nADIZLfELpklsrACyUTqVAhaCtD/8Efebt7v4CStMDhUybs2y6ja+6z9VjYidcv2JedLdHhb1Ol850ymgo6dB956oa1yOJByBIoyrO0ZMrVpKSJZE48beDALVqeB5VML/FU3HhILU5p2/x2P8SHf7l6LK0rv70KSxqjMDYarWCx13091XO6Zzs+tAjSakX0l+ZVO+RskSyWlYg5fZSF21dRrVDplJzG4+wUkwfEJk0qngPPWN3IhBp+6Uo8IsB8CmoM+D4jdeeT+yWaa2qzyvWCmjoyZ9Ou0q6TKgB8sVFCWHfLq4jz8PSxemfiZoNDXmSjUTw8yQ74jDNRw0F6DyRt4fLgTB+HydBlPb/56E4/Ppl4V/G/fboKlaAQiDbz96PGIjjLfrisZEDij5cd/TK/cNrFWbaxTkmoiUJknlCiTa6CVYCBnkwXcctGm/tmCWBx134UQnEqQSS0rcNklfhgUdNZkq22EZ9gCL0HDozprv9we/jffpSVCEQvxpetEvCPA33vDnYaen7T5NS1ioaSP+JQ6YDKh1bdxHkQh/US0jCQW8+q/9p1moK1K3mP/sJwEkU6OansmrE9a0iI2xSj+EFq4MNeIEFpvKmpfDNx7U5x3p0PWlgg7Kf/dfDiIQwpm2gMl5kkebSgotfEeiTdotcv2JYclOg+RK0rZUnROsRPthfF5t2BLHads/RsJspRK+9O/9lwsCtXkBXSGufzeklQXHZF3Qjf4a3rBQJAGJUnPIbhAVbvTHVj/kpIky0Z/Gyq0CTiPoPHr6M53gRon8S3pSo5e+6HCh/4zaZDWDcei/rBluqEXc8+/99dk6pA9Ap8X9Z3+/5s1iHq0qlnTScHj0vyFLK0sWpuNg5MJWFaefMHyHCy0SfCWhSU4tk3BNUqvtaSNK6bWqRkmFNrifSWE2gx+GiUJah+yDWzedXRVaR150IjRMtKwwKwmSZJPoP19Ra+ADQyXVz84Dt0LpyTVMlLFClKkFEuuav5KqZ1enIRJ0cmuEk3b3Y/1BM831kvLXnlZZvtDCom25ZrQmqYcW2V3V96+kJhrcF+di5bDD9KD3Sxpqmh6GSYGSbzytTXQl4OicRWD/reRyyNWS7tGuFGycrI7GaYq55p7op8BpHtqdUZvZo1/WOAqJoJIdkYob6QJ8Nb3rVVVt3RdiJKS5EfwCGvMFloq1gc5d702ycfETw2n/6c9LUCvECkhnI71kvg5zWsqHWhMixXJ32xbRBeQHNNyu80pXlNm0F/X5sN3nPYThGSBXZPh1Tm2Ap1BJ8tthaiO//vnb+FQ/8/b/BChXfpruKHEtZ8k/cPb57Xxa/imrPqqfqCkm+PN3bfD5lV/G1R796rT8T8h5r9i4gWg04H8p6hZg5rIyfLiQ/O/95wmDpMn/2QuRkY7/O78mR5NY6v07yf/bP7z7kOj8bAq/nlZY0pyOjtFOUQszVW47pFdj9sLhcpry45g460GWWgXpqwKnNbtnkgYad01q73MjxdYCGXioZkOm0arfYjlMZod7RFutXpuA2KpIyYXoReBM3QvdpiKP57l5Zn2TbQ8h7bRaIRx9s9UMDfVI7jVxMA/aWBatL3e7uZbjS0piTMTiVOPIjEPZ9un9l6nX+/j7eXAkfppl+2VBnRbrJ+ZAPHt5wiwrdMilSRZdg9e3Fd9RXXTmsB+wYFpNENH7lY5+AJdimGy+dDEy3UkQ19rv73iTBaqY+EKqvNLTbi0Gn6CW7/yAvI/YEm/nFacwGVMGSSmtcTI9o7pBRPvo6IJWG4yDgFb1t3h/h/Ejbvena6O9ivwt2X/GJmm95tf/sqVPoNDeP1Eewv0S8b/vvBgtwksKXWm25g50qsBEvxsOPqlnztndvMVDfe3fFVRgQqG/+OFy6tu4PphCkbQdkqM09dOwJx0n1Ps09fuhK6dVp+upVOt4/gYBm3p2xzznQlJSue4yqn1VndnrGKT9GEE8GfW0FmT5NitQhay0sY5n/qzAMBs9HR29hU+6Llj4uFMoN7Fy5HvMuv0VsFnlWWqg1N/vEll642vihoKlAr9ZhcxTr+tWvLJzRfOuuFauh2gOk71fh3U/3nWdwL0Kl1CvUovLziAs++mVonQiR3TRyQtnOi4XgF+yobmn9ajTF+PWavkRe45ebk02HGOSzbsYGGScjvuluxGJS7mTYNx8FlyuMeRpK+5UZax/jrKEQhSfYwWPM/U5oA04/5pymlv940typAboqP4peH33a3Af2l79UP79fhV7neuWPiOFdv5jcpPVPjnyvb83gdeVFKXzrqkRc2IoJg+V0nOkCOs4FmkqouqNr1BFk84aXzHnqNNJKeAipFB/x0cl1OC0Sk12jxKSyG4x7wiV/7X1SmQPIyquNNGzFp17p646ntS6tCa3k7uaJ+kwqWaJYQQar+MiAZ1PriA5rEILjrXXbJrQFUXihnrDl2/bxwMWYbxcPu8vHmsKZG+RjGCyxCLiR18685lsdjJ+SCxSTNtROgh+1nNJWNx4m0XxIIPgW3K1YprD1xiP8suhn8fT7tQoRbIlQm77EgvZlU/q0vjyw2vZ1ZDSgLgHP+ZJ8HkwzDv53BONkUv+sQVSqDS+ZmNqCeFXrHcL1tGaWCIWzaAa2/TR/p0If9wHQxe+vITYcSMjvj1f5oudn6DpmFjmw9XdetL+cY7xxMSykIgTCCqgEj7RWB65gXbp9ZiukMhhNnHm7KX5961I52kkDW+idJLm4POdF2t0IYLJwYF3Yml+4cBOOOp2XKByYNh6QMxArBXl3r/5cloyw3zSWrFOnx26kFLUUy1L5Z5VDILq1DIpViW34/MRQPhSE0WgkXNcCImkrwpOrOo7fSeIRGGgmxIc+cYD1SLtEOQNxpmHL57vkLOaXsueF42g1yNbBi011WA1MuoZDq2hIu0GwvRiatCb2MZ9vpVO978CHqd5T2BX/jp5oZlphovS0WDc2es+m8gUtLt4+5w9zVYOYeM9egWAEr71S+LTUrGRZd7ENoXyF86mJnPWNhU/netG199wSyyn4n28mQG9YbuRdJEowevzz2MSlj23gMJrkNHEtkXI5IeW5ok1RNsK9xE3HQlNUZuP8jWqeMdCnbC1ZnX6ZTUqTZqWkRCQPvyefp/Tt4tBqgaPBHY00RkEgL+nwgf6iiwRS6FcekCbOO/bLZGOrpNVnBh37AQh4lcoN+9jQ9IVGMKD/wMAAA==) format('woff2'),
          /*savepage-url=../../commun/fonts/fts_picto.woff*/
          url(data:font/woff;base64,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) format('woff'),
          /*savepage-url=../../commun/fonts/fts_picto.svg*/
          url() format('svg');
        font-weight: 400;
        font-style: normal;
        /*savepage-font-display=block*/
      }

      [class*=ei_gly_]:before,
      [class^=ei_gly_]:before {
        font-family: fts_picto;
        font-display: block;
        speak: none;
        font-style: normal;
        font-weight: 400;
        font-variant: normal;
        text-transform: none;
        line-height: 1;
        -webkit-font-smoothing: antialiased;
        -moz-osx-font-smoothing: grayscale
      }

    </style>
    <script data-savepage-type="" type="text/plain" async="" data-savepage-src="https://www.googletagmanager.com/gtm.js?id=GTM-PQWGBV9"></script>
    <script data-savepage-type="" type="text/plain" async="" data-savepage-src="https://static.critizr.com/widgets/e2b89168cdbcb94614eec99bee0bb32b.js"></script>
    <script data-savepage-type="text/javascript" type="text/plain" data-savepage-src="https://cdnii.e-i.com/INGR/sd/monabanq_2017/4.101.19/fr/javascript/appli/jquery_ei.js"></script>
    <script data-savepage-type="text/javascript" type="text/plain" data-savepage-src="https://cdnii.e-i.com/INGR/sd/monabanq_2017/4.101.19/fr/javascript/appli/lightbox.js"></script>
    <script data-savepage-type="text/javascript" type="text/plain" data-savepage-src="https://cdnii.e-i.com/INGR/sd/monabanq_2017/4.101.19/fr/javascript/appli/ei_tools.js"></script>



    <meta name="viewport" content="shrink-to-fit=no, user-scalable=no, initial-scale = 1, minimum-scale = 1, maximum-scale = 1, width=device-width">
    <style data-savepage-href="https://cdnwmii.e-i.com/SITW/wm/global/1.0.0/monabanq/css/footer.css?v=20210719">
      @media print {

        *,
        *:before,
        *:after {
          background: transparent !important;
          color: #000 !important;
          box-shadow: none !important;
          text-shadow: none !important
        }

        a,
        a:visited {
          text-decoration: underline
        }

        a[href]:after {
          content: " ("attr(href) ")"
        }

        abbr[title]:after {
          content: " ("attr(title) ")"
        }

        a[href^="#"]:after,
        a[href^="javascript:"]:after {
          content: ""
        }

        pre,
        blockquote {
          border: 1px solid #999;
          page-break-inside: avoid
        }

        thead {
          display: table-header-group
        }

        tr,
        img {
          page-break-inside: avoid
        }

        img {
          max-width: 100% !important
        }

        p,
        h2,
        h3 {
          orphans: 3;
          widows: 3
        }

        h2,
        h3 {
          page-break-after: avoid
        }

        .navbar {
          display: none
        }

        .btn>.caret,
        .dropup>.btn>.caret {
          border-top-color: #000 !important
        }

        .label {
          border: 1px solid #000
        }

        .table {
          border-collapse: collapse !important
        }

        .table td,
        .table th {
          background-color: #fff !important
        }

        .table-bordered th,
        .table-bordered td {
          border: 1px solid #ddd !important
        }
      }

      @font-face {
        font-family: 'Glyphicons Halflings';
        src:
          /*savepage-url=../fonts/bootstrap/glyphicons-halflings-regular.eot*/
          url();
        src:
          /*savepage-url=../fonts/bootstrap/glyphicons-halflings-regular.eot?#iefix*/
          url() format("embedded-opentype"),
          /*savepage-url=../fonts/bootstrap/glyphicons-halflings-regular.woff2*/
          url() format("woff2"),
          /*savepage-url=../fonts/bootstrap/glyphicons-halflings-regular.woff*/
          url() format("woff"),
          /*savepage-url=../fonts/bootstrap/glyphicons-halflings-regular.ttf*/
          url() format("truetype"),
          /*savepage-url=../fonts/bootstrap/glyphicons-halflings-regular.svg#glyphicons_halflingsregular*/
          url() format("svg")
      }

      .glyphicon {
        position: relative;
        top: 1px;
        display: inline-block;
        font-family: 'Glyphicons Halflings';
        font-style: normal;
        font-weight: normal;
        line-height: 1;
        -webkit-font-smoothing: antialiased;
        -moz-osx-font-smoothing: grayscale
      }

      .glyphicon-asterisk:before {
        content: "\002a"
      }

      .glyphicon-plus:before {
        content: "\002b"
      }

      .glyphicon-euro:before,
      .glyphicon-eur:before {
        content: "\20ac"
      }

      .glyphicon-minus:before {
        content: "\2212"
      }

      .glyphicon-cloud:before {
        content: "\2601"
      }

      .glyphicon-envelope:before {
        content: "\2709"
      }

      .glyphicon-pencil:before {
        content: "\270f"
      }

      .glyphicon-glass:before {
        content: "\e001"
      }

      .glyphicon-music:before {
        content: "\e002"
      }

      .glyphicon-search:before {
        content: "\e003"
      }

      .glyphicon-heart:before {
        content: "\e005"
      }

      .glyphicon-star:before {
        content: "\e006"
      }

      .glyphicon-star-empty:before {
        content: "\e007"
      }

      .glyphicon-user:before {
        content: "\e008"
      }

      .glyphicon-film:before {
        content: "\e009"
      }

      .glyphicon-th-large:before {
        content: "\e010"
      }

      .glyphicon-th:before {
        content: "\e011"
      }

      .glyphicon-th-list:before {
        content: "\e012"
      }

      .glyphicon-ok:before {
        content: "\e013"
      }

      .glyphicon-remove:before {
        content: "\e014"
      }

      .glyphicon-zoom-in:before {
        content: "\e015"
      }

      .glyphicon-zoom-out:before {
        content: "\e016"
      }

      .glyphicon-off:before {
        content: "\e017"
      }

      .glyphicon-signal:before {
        content: "\e018"
      }

      .glyphicon-cog:before {
        content: "\e019"
      }

      .glyphicon-trash:before {
        content: "\e020"
      }

      .glyphicon-home:before {
        content: "\e021"
      }

      .glyphicon-file:before {
        content: "\e022"
      }

      .glyphicon-time:before {
        content: "\e023"
      }

      .glyphicon-road:before {
        content: "\e024"
      }

      .glyphicon-download-alt:before {
        content: "\e025"
      }

      .glyphicon-download:before {
        content: "\e026"
      }

      .glyphicon-upload:before {
        content: "\e027"
      }

      .glyphicon-inbox:before {
        content: "\e028"
      }

      .glyphicon-play-circle:before {
        content: "\e029"
      }

      .glyphicon-repeat:before {
        content: "\e030"
      }

      .glyphicon-refresh:before {
        content: "\e031"
      }

      .glyphicon-list-alt:before {
        content: "\e032"
      }

      .glyphicon-lock:before {
        content: "\e033"
      }

      .glyphicon-flag:before {
        content: "\e034"
      }

      .glyphicon-headphones:before {
        content: "\e035"
      }

      .glyphicon-volume-off:before {
        content: "\e036"
      }

      .glyphicon-volume-down:before {
        content: "\e037"
      }

      .glyphicon-volume-up:before {
        content: "\e038"
      }

      .glyphicon-qrcode:before {
        content: "\e039"
      }

      .glyphicon-barcode:before {
        content: "\e040"
      }

      .glyphicon-tag:before {
        content: "\e041"
      }

      .glyphicon-tags:before {
        content: "\e042"
      }

      .glyphicon-book:before {
        content: "\e043"
      }

      .glyphicon-bookmark:before {
        content: "\e044"
      }

      .glyphicon-print:before {
        content: "\e045"
      }

      .glyphicon-camera:before {
        content: "\e046"
      }

      .glyphicon-font:before {
        content: "\e047"
      }

      .glyphicon-bold:before {
        content: "\e048"
      }

      .glyphicon-italic:before {
        content: "\e049"
      }

      .glyphicon-text-height:before {
        content: "\e050"
      }

      .glyphicon-text-width:before {
        content: "\e051"
      }

      .glyphicon-align-left:before {
        content: "\e052"
      }

      .glyphicon-align-center:before {
        content: "\e053"
      }

      .glyphicon-align-right:before {
        content: "\e054"
      }

      .glyphicon-align-justify:before {
        content: "\e055"
      }

      .glyphicon-list:before {
        content: "\e056"
      }

      .glyphicon-indent-left:before {
        content: "\e057"
      }

      .glyphicon-indent-right:before {
        content: "\e058"
      }

      .glyphicon-facetime-video:before {
        content: "\e059"
      }

      .glyphicon-picture:before {
        content: "\e060"
      }

      .glyphicon-map-marker:before {
        content: "\e062"
      }

      .glyphicon-adjust:before {
        content: "\e063"
      }

      .glyphicon-tint:before {
        content: "\e064"
      }

      .glyphicon-edit:before {
        content: "\e065"
      }

      .glyphicon-share:before {
        content: "\e066"
      }

      .glyphicon-check:before {
        content: "\e067"
      }

      .glyphicon-move:before {
        content: "\e068"
      }

      .glyphicon-step-backward:before {
        content: "\e069"
      }

      .glyphicon-fast-backward:before {
        content: "\e070"
      }

      .glyphicon-backward:before {
        content: "\e071"
      }

      .glyphicon-play:before {
        content: "\e072"
      }

      .glyphicon-pause:before {
        content: "\e073"
      }

      .glyphicon-stop:before {
        content: "\e074"
      }

      .glyphicon-forward:before {
        content: "\e075"
      }

      .glyphicon-fast-forward:before {
        content: "\e076"
      }

      .glyphicon-step-forward:before {
        content: "\e077"
      }

      .glyphicon-eject:before {
        content: "\e078"
      }

      .glyphicon-chevron-left:before {
        content: "\e079"
      }

      .glyphicon-chevron-right:before {
        content: "\e080"
      }

      .glyphicon-plus-sign:before {
        content: "\e081"
      }

      .glyphicon-minus-sign:before {
        content: "\e082"
      }

      .glyphicon-remove-sign:before {
        content: "\e083"
      }

      .glyphicon-ok-sign:before {
        content: "\e084"
      }

      .glyphicon-question-sign:before {
        content: "\e085"
      }

      .glyphicon-info-sign:before {
        content: "\e086"
      }

      .glyphicon-screenshot:before {
        content: "\e087"
      }

      .glyphicon-remove-circle:before {
        content: "\e088"
      }

      .glyphicon-ok-circle:before {
        content: "\e089"
      }

      .glyphicon-ban-circle:before {
        content: "\e090"
      }

      .glyphicon-arrow-left:before {
        content: "\e091"
      }

      .glyphicon-arrow-right:before {
        content: "\e092"
      }

      .glyphicon-arrow-up:before {
        content: "\e093"
      }

      .glyphicon-arrow-down:before {
        content: "\e094"
      }

      .glyphicon-share-alt:before {
        content: "\e095"
      }

      .glyphicon-resize-full:before {
        content: "\e096"
      }

      .glyphicon-resize-small:before {
        content: "\e097"
      }

      .glyphicon-exclamation-sign:before {
        content: "\e101"
      }

      .glyphicon-gift:before {
        content: "\e102"
      }

      .glyphicon-leaf:before {
        content: "\e103"
      }

      .glyphicon-fire:before {
        content: "\e104"
      }

      .glyphicon-eye-open:before {
        content: "\e105"
      }

      .glyphicon-eye-close:before {
        content: "\e106"
      }

      .glyphicon-warning-sign:before {
        content: "\e107"
      }

      .glyphicon-plane:before {
        content: "\e108"
      }

      .glyphicon-calendar:before {
        content: "\e109"
      }

      .glyphicon-random:before {
        content: "\e110"
      }

      .glyphicon-comment:before {
        content: "\e111"
      }

      .glyphicon-magnet:before {
        content: "\e112"
      }

      .glyphicon-chevron-up:before {
        content: "\e113"
      }

      .glyphicon-chevron-down:before {
        content: "\e114"
      }

      .glyphicon-retweet:before {
        content: "\e115"
      }

      .glyphicon-shopping-cart:before {
        content: "\e116"
      }

      .glyphicon-folder-close:before {
        content: "\e117"
      }

      .glyphicon-folder-open:before {
        content: "\e118"
      }

      .glyphicon-resize-vertical:before {
        content: "\e119"
      }

      .glyphicon-resize-horizontal:before {
        content: "\e120"
      }

      .glyphicon-hdd:before {
        content: "\e121"
      }

      .glyphicon-bullhorn:before {
        content: "\e122"
      }

      .glyphicon-bell:before {
        content: "\e123"
      }

      .glyphicon-certificate:before {
        content: "\e124"
      }

      .glyphicon-thumbs-up:before {
        content: "\e125"
      }

      .glyphicon-thumbs-down:before {
        content: "\e126"
      }

      .glyphicon-hand-right:before {
        content: "\e127"
      }

      .glyphicon-hand-left:before {
        content: "\e128"
      }

      .glyphicon-hand-up:before {
        content: "\e129"
      }

      .glyphicon-hand-down:before {
        content: "\e130"
      }

      .glyphicon-circle-arrow-right:before {
        content: "\e131"
      }

      .glyphicon-circle-arrow-left:before {
        content: "\e132"
      }

      .glyphicon-circle-arrow-up:before {
        content: "\e133"
      }

      .glyphicon-circle-arrow-down:before {
        content: "\e134"
      }

      .glyphicon-globe:before {
        content: "\e135"
      }

      .glyphicon-wrench:before {
        content: "\e136"
      }

      .glyphicon-tasks:before {
        content: "\e137"
      }

      .glyphicon-filter:before {
        content: "\e138"
      }

      .glyphicon-briefcase:before {
        content: "\e139"
      }

      .glyphicon-fullscreen:before {
        content: "\e140"
      }

      .glyphicon-dashboard:before {
        content: "\e141"
      }

      .glyphicon-paperclip:before {
        content: "\e142"
      }

      .glyphicon-heart-empty:before {
        content: "\e143"
      }

      .glyphicon-link:before {
        content: "\e144"
      }

      .glyphicon-phone:before {
        content: "\e145"
      }

      .glyphicon-pushpin:before {
        content: "\e146"
      }

      .glyphicon-usd:before {
        content: "\e148"
      }

      .glyphicon-gbp:before {
        content: "\e149"
      }

      .glyphicon-sort:before {
        content: "\e150"
      }

      .glyphicon-sort-by-alphabet:before {
        content: "\e151"
      }

      .glyphicon-sort-by-alphabet-alt:before {
        content: "\e152"
      }

      .glyphicon-sort-by-order:before {
        content: "\e153"
      }

      .glyphicon-sort-by-order-alt:before {
        content: "\e154"
      }

      .glyphicon-sort-by-attributes:before {
        content: "\e155"
      }

      .glyphicon-sort-by-attributes-alt:before {
        content: "\e156"
      }

      .glyphicon-unchecked:before {
        content: "\e157"
      }

      .glyphicon-expand:before {
        content: "\e158"
      }

      .glyphicon-collapse-down:before {
        content: "\e159"
      }

      .glyphicon-collapse-up:before {
        content: "\e160"
      }

      .glyphicon-log-in:before {
        content: "\e161"
      }

      .glyphicon-flash:before {
        content: "\e162"
      }

      .glyphicon-log-out:before {
        content: "\e163"
      }

      .glyphicon-new-window:before {
        content: "\e164"
      }

      .glyphicon-record:before {
        content: "\e165"
      }

      .glyphicon-save:before {
        content: "\e166"
      }

      .glyphicon-open:before {
        content: "\e167"
      }

      .glyphicon-saved:before {
        content: "\e168"
      }

      .glyphicon-import:before {
        content: "\e169"
      }

      .glyphicon-export:before {
        content: "\e170"
      }

      .glyphicon-send:before {
        content: "\e171"
      }

      .glyphicon-floppy-disk:before {
        content: "\e172"
      }

      .glyphicon-floppy-saved:before {
        content: "\e173"
      }

      .glyphicon-floppy-remove:before {
        content: "\e174"
      }

      .glyphicon-floppy-save:before {
        content: "\e175"
      }

      .glyphicon-floppy-open:before {
        content: "\e176"
      }

      .glyphicon-credit-card:before {
        content: "\e177"
      }

      .glyphicon-transfer:before {
        content: "\e178"
      }

      .glyphicon-cutlery:before {
        content: "\e179"
      }

      .glyphicon-header:before {
        content: "\e180"
      }

      .glyphicon-compressed:before {
        content: "\e181"
      }

      .glyphicon-earphone:before {
        content: "\e182"
      }

      .glyphicon-phone-alt:before {
        content: "\e183"
      }

      .glyphicon-tower:before {
        content: "\e184"
      }

      .glyphicon-stats:before {
        content: "\e185"
      }

      .glyphicon-sd-video:before {
        content: "\e186"
      }

      .glyphicon-hd-video:before {
        content: "\e187"
      }

      .glyphicon-subtitles:before {
        content: "\e188"
      }

      .glyphicon-sound-stereo:before {
        content: "\e189"
      }

      .glyphicon-sound-dolby:before {
        content: "\e190"
      }

      .glyphicon-sound-5-1:before {
        content: "\e191"
      }

      .glyphicon-sound-6-1:before {
        content: "\e192"
      }

      .glyphicon-sound-7-1:before {
        content: "\e193"
      }

      .glyphicon-copyright-mark:before {
        content: "\e194"
      }

      .glyphicon-registration-mark:before {
        content: "\e195"
      }

      .glyphicon-cloud-download:before {
        content: "\e197"
      }

      .glyphicon-cloud-upload:before {
        content: "\e198"
      }

      .glyphicon-tree-conifer:before {
        content: "\e199"
      }

      .glyphicon-tree-deciduous:before {
        content: "\e200"
      }

      .glyphicon-cd:before {
        content: "\e201"
      }

      .glyphicon-save-file:before {
        content: "\e202"
      }

      .glyphicon-open-file:before {
        content: "\e203"
      }

      .glyphicon-level-up:before {
        content: "\e204"
      }

      .glyphicon-copy:before {
        content: "\e205"
      }

      .glyphicon-paste:before {
        content: "\e206"
      }

      .glyphicon-alert:before {
        content: "\e209"
      }

      .glyphicon-equalizer:before {
        content: "\e210"
      }

      .glyphicon-king:before {
        content: "\e211"
      }

      .glyphicon-queen:before {
        content: "\e212"
      }

      .glyphicon-pawn:before {
        content: "\e213"
      }

      .glyphicon-bishop:before {
        content: "\e214"
      }

      .glyphicon-knight:before {
        content: "\e215"
      }

      .glyphicon-baby-formula:before {
        content: "\e216"
      }

      .glyphicon-tent:before {
        content: "\26fa"
      }

      .glyphicon-blackboard:before {
        content: "\e218"
      }

      .glyphicon-bed:before {
        content: "\e219"
      }

      .glyphicon-apple:before {
        content: "\f8ff"
      }

      .glyphicon-erase:before {
        content: "\e221"
      }

      .glyphicon-hourglass:before {
        content: "\231b"
      }

      .glyphicon-lamp:before {
        content: "\e223"
      }

      .glyphicon-duplicate:before {
        content: "\e224"
      }

      .glyphicon-piggy-bank:before {
        content: "\e225"
      }

      .glyphicon-scissors:before {
        content: "\e226"
      }

      .glyphicon-bitcoin:before {
        content: "\e227"
      }

      .glyphicon-btc:before {
        content: "\e227"
      }

      .glyphicon-xbt:before {
        content: "\e227"
      }

      .glyphicon-yen:before {
        content: "\00a5"
      }

      .glyphicon-jpy:before {
        content: "\00a5"
      }

      .glyphicon-ruble:before {
        content: "\20bd"
      }

      .glyphicon-rub:before {
        content: "\20bd"
      }

      .glyphicon-scale:before {
        content: "\e230"
      }

      .glyphicon-ice-lolly:before {
        content: "\e231"
      }

      .glyphicon-ice-lolly-tasted:before {
        content: "\e232"
      }

      .glyphicon-education:before {
        content: "\e233"
      }

      .glyphicon-option-horizontal:before {
        content: "\e234"
      }

      .glyphicon-option-vertical:before {
        content: "\e235"
      }

      .glyphicon-menu-hamburger:before {
        content: "\e236"
      }

      .glyphicon-modal-window:before {
        content: "\e237"
      }

      .glyphicon-oil:before {
        content: "\e238"
      }

      .glyphicon-grain:before {
        content: "\e239"
      }

      .glyphicon-sunglasses:before {
        content: "\e240"
      }

      .glyphicon-text-size:before {
        content: "\e241"
      }

      .glyphicon-text-color:before {
        content: "\e242"
      }

      .glyphicon-text-background:before {
        content: "\e243"
      }

      .glyphicon-object-align-top:before {
        content: "\e244"
      }

      .glyphicon-object-align-bottom:before {
        content: "\e245"
      }

      .glyphicon-object-align-horizontal:before {
        content: "\e246"
      }

      .glyphicon-object-align-left:before {
        content: "\e247"
      }

      .glyphicon-object-align-vertical:before {
        content: "\e248"
      }

      .glyphicon-object-align-right:before {
        content: "\e249"
      }

      .glyphicon-triangle-right:before {
        content: "\e250"
      }

      .glyphicon-triangle-left:before {
        content: "\e251"
      }

      .glyphicon-triangle-bottom:before {
        content: "\e252"
      }

      .glyphicon-triangle-top:before {
        content: "\e253"
      }

      .glyphicon-console:before {
        content: "\e254"
      }

      .glyphicon-superscript:before {
        content: "\e255"
      }

      .glyphicon-subscript:before {
        content: "\e256"
      }

      .glyphicon-menu-left:before {
        content: "\e257"
      }

      .glyphicon-menu-right:before {
        content: "\e258"
      }

      .glyphicon-menu-down:before {
        content: "\e259"
      }

      .glyphicon-menu-up:before {
        content: "\e260"
      }

      * {
        -webkit-box-sizing: border-box;
        -moz-box-sizing: border-box;
        box-sizing: border-box
      }

      *:before,
      *:after {
        -webkit-box-sizing: border-box;
        -moz-box-sizing: border-box;
        box-sizing: border-box
      }

      /* html {
     font-size: 10px;
     -webkit-tap-highlight-color: transparent
 } */

      input,
      button,
      select,
      textarea {
        font-family: inherit;
        font-size: inherit;
        line-height: inherit
      }

      .ei_tpl_redac main#ei_tpl_content a:focus,
      .ei_tpl_transac main#ei_tpl_content a:focus {
        outline: thin dotted;
        outline: 5px auto -webkit-focus-ring-color;
        outline-offset: -2px
      }

      figure {
        margin: 0
      }

      img {
        vertical-align: middle
      }

      .img-responsive {
        display: block;
        max-width: 100%;
        height: auto
      }

      .img-rounded {
        border-radius: 6px
      }

      .img-thumbnail {
        padding: 4px;
        line-height: 1.42857;
        background-color: #fff;
        border: 1px solid #ddd;
        border-radius: 4px;
        -webkit-transition: all .2s ease-in-out;
        -o-transition: all .2s ease-in-out;
        transition: all .2s ease-in-out;
        display: inline-block;
        max-width: 100%;
        height: auto
      }

      .img-circle {
        border-radius: 50%
      }

      hr {
        margin-top: 20px;
        margin-bottom: 20px;
        border: 0;
        border-top: 1px solid #eeeeee
      }

      .sr-only {
        position: absolute;
        width: 1px;
        height: 1px;
        margin: -1px;
        padding: 0;
        overflow: hidden;
        clip: rect(0, 0, 0, 0);
        border: 0
      }

      .sr-only-focusable:active,
      .sr-only-focusable:focus {
        position: static;
        width: auto;
        height: auto;
        margin: 0;
        overflow: visible;
        clip: auto
      }

      [role="button"] {
        cursor: pointer
      }

      h1,
      h2,
      h3,
      h4,
      h5,
      h6,
      .h1,
      .h2,
      .h3,
      .h4,
      .h5,
      .h6 {
        font-family: inherit;
        font-weight: 500;
        line-height: 1.1;
        color: inherit
      }

      h1 small,
      h1 .small,
      h2 small,
      h2 .small,
      h3 small,
      h3 .small,
      h4 small,
      h4 .small,
      h5 small,
      h5 .small,
      h6 small,
      h6 .small,
      .h1 small,
      .h1 .small,
      .h2 small,
      .h2 .small,
      .h3 small,
      .h3 .small,
      .h4 small,
      .h4 .small,
      .h5 small,
      .h5 .small,
      .h6 small,
      .h6 .small {
        font-weight: normal;
        line-height: 1;
        color: #777777
      }

      h1,
      .h1,
      h2,
      .h2,
      h3,
      .h3 {
        margin-top: 20px;
        margin-bottom: 10px
      }

      h1 small,
      h1 .small,
      .h1 small,
      .h1 .small,
      h2 small,
      h2 .small,
      .h2 small,
      .h2 .small,
      h3 small,
      h3 .small,
      .h3 small,
      .h3 .small {
        font-size: 65%
      }

      h4,
      .h4,
      h5,
      .h5,
      h6,
      .h6 {
        margin-top: 10px;
        margin-bottom: 10px
      }

      h4 small,
      h4 .small,
      .h4 small,
      .h4 .small,
      h5 small,
      h5 .small,
      .h5 small,
      .h5 .small,
      h6 small,
      h6 .small,
      .h6 small,
      .h6 .small {
        font-size: 75%
      }

      h1,
      .h1 {
        font-size: 36px
      }

      h2,
      .h2 {
        font-size: 30px
      }

      h3,
      .h3 {
        font-size: 24px
      }

      h4,
      .h4 {
        font-size: 18px
      }

      h5,
      .h5 {
        font-size: 14px
      }

      h6,
      .h6 {
        font-size: 12px
      }

      /* .ei_tpl_redac main#ei_tpl_content p,.ei_tpl_transac main#ei_tpl_content p {
     margin: 0 0 10px
 } */

      .ei_tpl_redac main#ei_tpl_content a.btn_hover,
      .ei_tpl_transac main#ei_tpl_content a.btn_hover {
        text-align: center;
        margin-bottom: 20px;
        margin-top: 20px;
        position: relative;
      }

      .lead {
        margin-bottom: 20px;
        font-size: 16px;
        font-weight: 300;
        line-height: 1.4
      }

      @media (min-width:768px) {
        .lead {
          font-size: 21px
        }
      }

      small,
      .small {
        font-size: 85%
      }

      mark,
      .mark {
        background-color: #fcf8e3;
        padding: .2em
      }

      .text-left {
        text-align: left
      }

      .text-right {
        text-align: right
      }

      .text-center {
        text-align: center
      }

      .text-justify {
        text-align: justify
      }

      .text-nowrap {
        white-space: nowrap
      }

      .text-lowercase {
        text-transform: lowercase
      }

      .text-uppercase,
      .initialism {
        text-transform: uppercase
      }

      .text-capitalize {
        text-transform: capitalize
      }

      .text-muted {
        color: #777777
      }

      .text-primary {
        color: #337ab7
      }

      a.text-primary:hover,
      a.text-primary:focus {
        color: #286090
      }

      .text-success {
        color: #3c763d
      }

      a.text-success:hover,
      a.text-success:focus {
        color: #2b542c
      }

      .text-info {
        color: #31708f
      }

      a.text-info:hover,
      a.text-info:focus {
        color: #245269
      }

      .text-warning {
        color: #8a6d3b
      }

      a.text-warning:hover,
      a.text-warning:focus {
        color: #66512c
      }

      .text-danger {
        color: #a94442
      }

      a.text-danger:hover,
      a.text-danger:focus {
        color: #843534
      }

      .bg-primary {
        color: #fff
      }

      .bg-primary {
        background-color: #337ab7
      }

      a.bg-primary:hover,
      a.bg-primary:focus {
        background-color: #286090
      }

      .bg-success {
        background-color: #dff0d8
      }

      a.bg-success:hover,
      a.bg-success:focus {
        background-color: #c1e2b3
      }

      .bg-info {
        background-color: #d9edf7
      }

      a.bg-info:hover,
      a.bg-info:focus {
        background-color: #afd9ee
      }

      .bg-warning {
        background-color: #fcf8e3
      }

      a.bg-warning:hover,
      a.bg-warning:focus {
        background-color: #f7ecb5
      }

      .bg-danger {
        background-color: #f2dede
      }

      a.bg-danger:hover,
      a.bg-danger:focus {
        background-color: #e4b9b9
      }

      .page-header {
        padding-bottom: 9px;
        margin: 40px 0 20px;
        border-bottom: 1px solid #eeeeee
      }

      ul,
      ol {
        margin-top: 0;
        margin-bottom: 10px
      }

      ul ul,
      ul ol,
      ol ul,
      ol ol {
        margin-bottom: 0
      }

      .list-unstyled {
        padding-left: 0;
        list-style: none
      }

      .list-inline {
        padding-left: 0;
        list-style: none;
        margin-left: -5px
      }

      .list-inline>li {
        display: inline-block;
        padding-left: 5px;
        padding-right: 5px
      }

      dl {
        margin-top: 0;
        margin-bottom: 20px
      }

      dt,
      dd {
        line-height: 1.42857
      }

      .col-xs-1,
      .col-sm-1,
      .col-md-1,
      .col-lg-1,
      .col-xs-2,
      .col-sm-2,
      .col-md-2,
      .col-lg-2,
      .col-xs-3,
      .col-sm-3,
      .col-md-3,
      .col-lg-3,
      .col-xs-4,
      .col-sm-4,
      .col-md-4,
      .col-lg-4,
      .col-xs-5,
      .col-sm-5,
      .col-md-5,
      .col-lg-5,
      .col-xs-6,
      .col-sm-6,
      .col-md-6,
      .col-lg-6,
      .col-xs-7,
      .col-sm-7,
      .col-md-7,
      .col-lg-7,
      .col-xs-8,
      .col-sm-8,
      .col-md-8,
      .col-lg-8,
      .col-xs-9,
      .col-sm-9,
      .col-md-9,
      .col-lg-9,
      .col-xs-10,
      .col-sm-10,
      .col-md-10,
      .col-lg-10,
      .col-xs-11,
      .col-sm-11,
      .col-md-11,
      .col-lg-11,
      .col-xs-12,
      .col-sm-12,
      .col-md-12,
      .col-lg-12 {
        position: relative;
        min-height: 1px;
        padding-left: 0;
        padding-right: 0
      }

      .col-xs-1,
      .col-xs-2,
      .col-xs-3,
      .col-xs-4,
      .col-xs-5,
      .col-xs-6,
      .col-xs-7,
      .col-xs-8,
      .col-xs-9,
      .col-xs-10,
      .col-xs-11,
      .col-xs-12 {
        float: left
      }

      .col-xs-1 {
        width: 8.33333%
      }

      .col-xs-2 {
        width: 16.66667%
      }

      .col-xs-3 {
        width: 25%
      }

      .col-xs-4 {
        width: 33.33333%
      }

      .col-xs-5 {
        width: 41.66667%
      }

      .col-xs-6 {
        width: 50%
      }

      .col-xs-7 {
        width: 58.33333%
      }

      .col-xs-8 {
        width: 66.66667%
      }

      .col-xs-9 {
        width: 75%
      }

      .col-xs-10 {
        width: 83.33333%
      }

      .col-xs-11 {
        width: 91.66667%
      }

      .col-xs-12 {
        width: 100%
      }

      .col-xs-pull-0 {
        right: auto
      }

      .col-xs-pull-1 {
        right: 8.33333%
      }

      .col-xs-pull-2 {
        right: 16.66667%
      }

      .col-xs-pull-3 {
        right: 25%
      }

      .col-xs-pull-4 {
        right: 33.33333%
      }

      .col-xs-pull-5 {
        right: 41.66667%
      }

      .col-xs-pull-6 {
        right: 50%
      }

      .col-xs-pull-7 {
        right: 58.33333%
      }

      .col-xs-pull-8 {
        right: 66.66667%
      }

      .col-xs-pull-9 {
        right: 75%
      }

      .col-xs-pull-10 {
        right: 83.33333%
      }

      .col-xs-pull-11 {
        right: 91.66667%
      }

      .col-xs-pull-12 {
        right: 100%
      }

      .col-xs-push-0 {
        left: auto
      }

      .col-xs-push-1 {
        left: 8.33333%
      }

      .col-xs-push-2 {
        left: 16.66667%
      }

      .col-xs-push-3 {
        left: 25%
      }

      .col-xs-push-4 {
        left: 33.33333%
      }

      .col-xs-push-5 {
        left: 41.66667%
      }

      .col-xs-push-6 {
        left: 50%
      }

      .col-xs-push-7 {
        left: 58.33333%
      }

      .col-xs-push-8 {
        left: 66.66667%
      }

      .col-xs-push-9 {
        left: 75%
      }

      .col-xs-push-10 {
        left: 83.33333%
      }

      .col-xs-push-11 {
        left: 91.66667%
      }

      .col-xs-push-12 {
        left: 100%
      }

      .col-xs-offset-0 {
        margin-left: 0%
      }

      .col-xs-offset-1 {
        margin-left: 8.33333%
      }

      .col-xs-offset-2 {
        margin-left: 16.66667%
      }

      .col-xs-offset-3 {
        margin-left: 25%
      }

      .col-xs-offset-4 {
        margin-left: 33.33333%
      }

      .col-xs-offset-5 {
        margin-left: 41.66667%
      }

      .col-xs-offset-6 {
        margin-left: 50%
      }

      .col-xs-offset-7 {
        margin-left: 58.33333%
      }

      .col-xs-offset-8 {
        margin-left: 66.66667%
      }

      .col-xs-offset-9 {
        margin-left: 75%
      }

      .col-xs-offset-10 {
        margin-left: 83.33333%
      }

      .col-xs-offset-11 {
        margin-left: 91.66667%
      }

      .col-xs-offset-12 {
        margin-left: 100%
      }

      @media (min-width:768px) {

        .col-sm-1,
        .col-sm-2,
        .col-sm-3,
        .col-sm-4,
        .col-sm-5,
        .col-sm-6,
        .col-sm-7,
        .col-sm-8,
        .col-sm-9,
        .col-sm-10,
        .col-sm-11,
        .col-sm-12 {
          float: left
        }

        .col-sm-1 {
          width: 8.33333%
        }

        .col-sm-2 {
          width: 16.66667%
        }

        .col-sm-3 {
          width: 25%
        }

        .col-sm-4 {
          width: 33.33333%
        }

        .col-sm-5 {
          width: 41.66667%
        }

        .col-sm-6 {
          width: 50%
        }

        .col-sm-7 {
          width: 58.33333%
        }

        .col-sm-8 {
          width: 66.66667%
        }

        .col-sm-9 {
          width: 75%
        }

        .col-sm-10 {
          width: 83.33333%
        }

        .col-sm-11 {
          width: 91.66667%
        }

        .col-sm-12 {
          width: 100%
        }

        .col-sm-pull-0 {
          right: auto
        }

        .col-sm-pull-1 {
          right: 8.33333%
        }

        .col-sm-pull-2 {
          right: 16.66667%
        }

        .col-sm-pull-3 {
          right: 25%
        }

        .col-sm-pull-4 {
          right: 33.33333%
        }

        .col-sm-pull-5 {
          right: 41.66667%
        }

        .col-sm-pull-6 {
          right: 50%
        }

        .col-sm-pull-7 {
          right: 58.33333%
        }

        .col-sm-pull-8 {
          right: 66.66667%
        }

        .col-sm-pull-9 {
          right: 75%
        }

        .col-sm-pull-10 {
          right: 83.33333%
        }

        .col-sm-pull-11 {
          right: 91.66667%
        }

        .col-sm-pull-12 {
          right: 100%
        }

        .col-sm-push-0 {
          left: auto
        }

        .col-sm-push-1 {
          left: 8.33333%
        }

        .col-sm-push-2 {
          left: 16.66667%
        }

        .col-sm-push-3 {
          left: 25%
        }

        .col-sm-push-4 {
          left: 33.33333%
        }

        .col-sm-push-5 {
          left: 41.66667%
        }

        .col-sm-push-6 {
          left: 50%
        }

        .col-sm-push-7 {
          left: 58.33333%
        }

        .col-sm-push-8 {
          left: 66.66667%
        }

        .col-sm-push-9 {
          left: 75%
        }

        .col-sm-push-10 {
          left: 83.33333%
        }

        .col-sm-push-11 {
          left: 91.66667%
        }

        .col-sm-push-12 {
          left: 100%
        }

        .col-sm-offset-0 {
          margin-left: 0%
        }

        .col-sm-offset-1 {
          margin-left: 8.33333%
        }

        .col-sm-offset-2 {
          margin-left: 16.66667%
        }

        .col-sm-offset-3 {
          margin-left: 25%
        }

        .col-sm-offset-4 {
          margin-left: 33.33333%
        }

        .col-sm-offset-5 {
          margin-left: 41.66667%
        }

        .col-sm-offset-6 {
          margin-left: 50%
        }

        .col-sm-offset-7 {
          margin-left: 58.33333%
        }

        .col-sm-offset-8 {
          margin-left: 66.66667%
        }

        .col-sm-offset-9 {
          margin-left: 75%
        }

        .col-sm-offset-10 {
          margin-left: 83.33333%
        }

        .col-sm-offset-11 {
          margin-left: 91.66667%
        }

        .col-sm-offset-12 {
          margin-left: 100%
        }
      }

      @media (min-width:992px) {

        .col-md-1,
        .col-md-2,
        .col-md-3,
        .col-md-4,
        .col-md-5,
        .col-md-6,
        .col-md-7,
        .col-md-8,
        .col-md-9,
        .col-md-10,
        .col-md-11,
        .col-md-12 {
          float: left
        }

        .col-md-1 {
          width: 8.33333%
        }

        .col-md-2 {
          width: 16.66667%
        }

        .col-md-3 {
          width: 25%
        }

        .col-md-4 {
          width: 33.33333%
        }

        .col-md-5 {
          width: 41.66667%
        }

        .col-md-6 {
          width: 50%
        }

        .col-md-7 {
          width: 58.33333%
        }

        .col-md-8 {
          width: 66.66667%
        }

        .col-md-9 {
          width: 75%
        }

        .col-md-10 {
          width: 83.33333%
        }

        .col-md-11 {
          width: 91.66667%
        }

        .col-md-12 {
          width: 100%
        }

        .col-md-pull-0 {
          right: auto
        }

        .col-md-pull-1 {
          right: 8.33333%
        }

        .col-md-pull-2 {
          right: 16.66667%
        }

        .col-md-pull-3 {
          right: 25%
        }

        .col-md-pull-4 {
          right: 33.33333%
        }

        .col-md-pull-5 {
          right: 41.66667%
        }

        .col-md-pull-6 {
          right: 50%
        }

        .col-md-pull-7 {
          right: 58.33333%
        }

        .col-md-pull-8 {
          right: 66.66667%
        }

        .col-md-pull-9 {
          right: 75%
        }

        .col-md-pull-10 {
          right: 83.33333%
        }

        .col-md-pull-11 {
          right: 91.66667%
        }

        .col-md-pull-12 {
          right: 100%
        }

        .col-md-push-0 {
          left: auto
        }

        .col-md-push-1 {
          left: 8.33333%
        }

        .col-md-push-2 {
          left: 16.66667%
        }

        .col-md-push-3 {
          left: 25%
        }

        .col-md-push-4 {
          left: 33.33333%
        }

        .col-md-push-5 {
          left: 41.66667%
        }

        .col-md-push-6 {
          left: 50%
        }

        .col-md-push-7 {
          left: 58.33333%
        }

        .col-md-push-8 {
          left: 66.66667%
        }

        .col-md-push-9 {
          left: 75%
        }

        .col-md-push-10 {
          left: 83.33333%
        }

        .col-md-push-11 {
          left: 91.66667%
        }

        .col-md-push-12 {
          left: 100%
        }

        .col-md-offset-0 {
          margin-left: 0%
        }

        .col-md-offset-1 {
          margin-left: 8.33333%
        }

        .col-md-offset-2 {
          margin-left: 16.66667%
        }

        .col-md-offset-3 {
          margin-left: 25%
        }

        .col-md-offset-4 {
          margin-left: 33.33333%
        }

        .col-md-offset-5 {
          margin-left: 41.66667%
        }

        .col-md-offset-6 {
          margin-left: 50%
        }

        .col-md-offset-7 {
          margin-left: 58.33333%
        }

        .col-md-offset-8 {
          margin-left: 66.66667%
        }

        .col-md-offset-9 {
          margin-left: 75%
        }

        .col-md-offset-10 {
          margin-left: 83.33333%
        }

        .col-md-offset-11 {
          margin-left: 91.66667%
        }

        .col-md-offset-12 {
          margin-left: 100%
        }
      }

      @media (min-width:1200px) {

        .col-lg-1,
        .col-lg-2,
        .col-lg-3,
        .col-lg-4,
        .col-lg-5,
        .col-lg-6,
        .col-lg-7,
        .col-lg-8,
        .col-lg-9,
        .col-lg-10,
        .col-lg-11,
        .col-lg-12 {
          float: left
        }

        .col-lg-1 {
          width: 8.33333%
        }

        .col-lg-2 {
          width: 16.66667%
        }

        .col-lg-3 {
          width: 25%
        }

        .col-lg-4 {
          width: 33.33333%
        }

        .col-lg-5 {
          width: 41.66667%
        }

        .col-lg-6 {
          width: 50%
        }

        .col-lg-7 {
          width: 58.33333%
        }

        .col-lg-8 {
          width: 66.66667%
        }

        .col-lg-9 {
          width: 75%
        }

        .col-lg-10 {
          width: 83.33333%
        }

        .col-lg-11 {
          width: 91.66667%
        }

        .col-lg-12 {
          width: 100%
        }

        .col-lg-pull-0 {
          right: auto
        }

        .col-lg-pull-1 {
          right: 8.33333%
        }

        .col-lg-pull-2 {
          right: 16.66667%
        }

        .col-lg-pull-3 {
          right: 25%
        }

        .col-lg-pull-4 {
          right: 33.33333%
        }

        .col-lg-pull-5 {
          right: 41.66667%
        }

        .col-lg-pull-6 {
          right: 50%
        }

        .col-lg-pull-7 {
          right: 58.33333%
        }

        .col-lg-pull-8 {
          right: 66.66667%
        }

        .col-lg-pull-9 {
          right: 75%
        }

        .col-lg-pull-10 {
          right: 83.33333%
        }

        .col-lg-pull-11 {
          right: 91.66667%
        }

        .col-lg-pull-12 {
          right: 100%
        }

        .col-lg-push-0 {
          left: auto
        }

        .col-lg-push-1 {
          left: 8.33333%
        }

        .col-lg-push-2 {
          left: 16.66667%
        }

        .col-lg-push-3 {
          left: 25%
        }

        .col-lg-push-4 {
          left: 33.33333%
        }

        .col-lg-push-5 {
          left: 41.66667%
        }

        .col-lg-push-6 {
          left: 50%
        }

        .col-lg-push-7 {
          left: 58.33333%
        }

        .col-lg-push-8 {
          left: 66.66667%
        }

        .col-lg-push-9 {
          left: 75%
        }

        .col-lg-push-10 {
          left: 83.33333%
        }

        .col-lg-push-11 {
          left: 91.66667%
        }

        .col-lg-push-12 {
          left: 100%
        }

        .col-lg-offset-0 {
          margin-left: 0%
        }

        .col-lg-offset-1 {
          margin-left: 8.33333%
        }

        .col-lg-offset-2 {
          margin-left: 16.66667%
        }

        .col-lg-offset-3 {
          margin-left: 25%
        }

        .col-lg-offset-4 {
          margin-left: 33.33333%
        }

        .col-lg-offset-5 {
          margin-left: 41.66667%
        }

        .col-lg-offset-6 {
          margin-left: 50%
        }

        .col-lg-offset-7 {
          margin-left: 58.33333%
        }

        .col-lg-offset-8 {
          margin-left: 66.66667%
        }

        .col-lg-offset-9 {
          margin-left: 75%
        }

        .col-lg-offset-10 {
          margin-left: 83.33333%
        }

        .col-lg-offset-11 {
          margin-left: 91.66667%
        }

        .col-lg-offset-12 {
          margin-left: 100%
        }
      }

      .dropup,
      .dropdown {
        position: relative
      }

      .dropdown-toggle:focus {
        outline: 0
      }

      .dropdown-menu {
        position: absolute;
        top: 100%;
        left: 0;
        z-index: 1000;
        display: none;
        float: left;
        min-width: 160px;
        padding: 5px 0;
        margin: 2px 0 0;
        list-style: none;
        font-size: 14px;
        text-align: left;
        background-color: #fff;
        border: 1px solid #ccc;
        border: 1px solid rgba(0, 0, 0, .15);
        border-radius: 4px;
        -webkit-box-shadow: 0 6px 12px rgba(0, 0, 0, .175);
        box-shadow: 0 6px 12px rgba(0, 0, 0, .175);
        background-clip: padding-box
      }

      .dropdown-menu.pull-right {
        right: 0;
        left: auto
      }

      .dropdown-menu .divider {
        height: 1px;
        margin: 9px 0;
        overflow: hidden;
        background-color: #e5e5e5
      }

      .dropdown-menu>li>a {
        display: block;
        padding: 3px 20px;
        clear: both;
        font-weight: normal;
        line-height: 1.42857;
        color: #333333;
        white-space: nowrap
      }

      .dropdown-menu>li>a:hover,
      .dropdown-menu>li>a:focus {
        text-decoration: none;
        color: #262626;
        background-color: #f5f5f5
      }

      .dropdown-menu>.active>a,
      .dropdown-menu>.active>a:hover,
      .dropdown-menu>.active>a:focus {
        color: #fff;
        text-decoration: none;
        outline: 0;
        background-color: #337ab7
      }

      .dropdown-menu>.disabled>a,
      .dropdown-menu>.disabled>a:hover,
      .dropdown-menu>.disabled>a:focus {
        color: #777777
      }

      .dropdown-menu>.disabled>a:hover,
      .dropdown-menu>.disabled>a:focus {
        text-decoration: none;
        background-color: transparent;
        background-image: none;
        filter: progid:DXImageTransform.Microsoft.gradient(enabled=false);
        cursor: not-allowed
      }

      .open>.dropdown-menu {
        display: block
      }

      .open>a {
        outline: 0
      }

      .dropdown-menu-right {
        left: auto;
        right: 0
      }

      .dropdown-menu-left {
        left: 0;
        right: auto
      }

      .dropdown-header {
        display: block;
        padding: 3px 20px;
        font-size: 12px;
        line-height: 1.42857;
        color: #777777;
        white-space: nowrap
      }

      .dropdown-backdrop {
        position: fixed;
        left: 0;
        right: 0;
        bottom: 0;
        top: 0;
        z-index: 990
      }

      .pull-right>.dropdown-menu {
        right: 0;
        left: auto
      }

      .dropup .caret,
      .navbar-fixed-bottom .dropdown .caret {
        border-top: 0;
        border-bottom: 4px dashed;
        border-bottom: 4px solid \9;
        content: ""
      }

      .dropup .dropdown-menu,
      .navbar-fixed-bottom .dropdown .dropdown-menu {
        top: auto;
        bottom: 100%;
        margin-bottom: 2px
      }

      @media (min-width:992px) {
        .navbar-right .dropdown-menu {
          right: 0;
          left: auto
        }

        .navbar-right .dropdown-menu-left {
          left: 0;
          right: auto
        }
      }

      .btn-group,
      .btn-group-vertical {
        position: relative;
        display: inline-block;
        vertical-align: middle
      }

      .btn-group>.btn,
      .btn-group-vertical>.btn {
        position: relative;
        float: left
      }

      .btn-group>.btn:hover,
      .btn-group>.btn:focus,
      .btn-group>.btn:active,
      .btn-group>.btn.active,
      .btn-group-vertical>.btn:hover,
      .btn-group-vertical>.btn:focus,
      .btn-group-vertical>.btn:active,
      .btn-group-vertical>.btn.active {
        z-index: 2
      }

      .btn-group .btn+.btn,
      .btn-group .btn+.btn-group,
      .btn-group .btn-group+.btn,
      .btn-group .btn-group+.btn-group {
        margin-left: -1px
      }

      .btn-toolbar {
        margin-left: -5px
      }

      .btn-toolbar:before,
      .btn-toolbar:after {
        content: " ";
        display: table
      }

      .btn-toolbar:after {
        clear: both
      }

      .btn-toolbar .btn,
      .btn-toolbar .btn-group,
      .btn-toolbar .input-group {
        float: left
      }

      .btn-toolbar>.btn,
      .btn-toolbar>.btn-group,
      .btn-toolbar>.input-group {
        margin-left: 5px
      }

      .btn-group>.btn:not(:first-child):not(:last-child):not(.dropdown-toggle) {
        border-radius: 0
      }

      .btn-group>.btn:first-child {
        margin-left: 0
      }

      .btn-group>.btn:first-child:not(:last-child):not(.dropdown-toggle) {
        border-bottom-right-radius: 0;
        border-top-right-radius: 0
      }

      .btn-group>.btn:last-child:not(:first-child),
      .btn-group>.dropdown-toggle:not(:first-child) {
        border-bottom-left-radius: 0;
        border-top-left-radius: 0
      }

      .btn-group>.btn-group {
        float: left
      }

      .btn-group>.btn-group:not(:first-child):not(:last-child)>.btn {
        border-radius: 0
      }

      .btn-group>.btn-group:first-child:not(:last-child)>.btn:last-child,
      .btn-group>.btn-group:first-child:not(:last-child)>.dropdown-toggle {
        border-bottom-right-radius: 0;
        border-top-right-radius: 0
      }

      .btn-group>.btn-group:last-child:not(:first-child)>.btn:first-child {
        border-bottom-left-radius: 0;
        border-top-left-radius: 0
      }

      .btn-group .dropdown-toggle:active,
      .btn-group.open .dropdown-toggle {
        outline: 0
      }

      .btn-group>.btn+.dropdown-toggle {
        padding-left: 8px;
        padding-right: 8px
      }

      .btn-group>.btn-lg+.dropdown-toggle,
      .btn-group-lg.btn-group>.btn+.dropdown-toggle {
        padding-left: 12px;
        padding-right: 12px
      }

      .btn-group.open .dropdown-toggle {
        -webkit-box-shadow: inset 0 3px 5px rgba(0, 0, 0, .125);
        box-shadow: inset 0 3px 5px rgba(0, 0, 0, .125)
      }

      .btn-group.open .dropdown-toggle.btn-link {
        -webkit-box-shadow: none;
        box-shadow: none
      }

      .btn .caret {
        margin-left: 0
      }

      .btn-lg .caret,
      .btn-group-lg>.btn .caret {
        border-width: 5px 5px 0;
        border-bottom-width: 0
      }

      .dropup .btn-lg .caret,
      .dropup .btn-group-lg>.btn .caret {
        border-width: 0 5px 5px
      }

      .btn-group-vertical>.btn,
      .btn-group-vertical>.btn-group,
      .btn-group-vertical>.btn-group>.btn {
        display: block;
        float: none;
        width: 100%;
        max-width: 100%
      }

      .btn-group-vertical>.btn-group:before,
      .btn-group-vertical>.btn-group:after {
        content: " ";
        display: table
      }

      .btn-group-vertical>.btn-group:after {
        clear: both
      }

      .btn-group-vertical>.btn-group>.btn {
        float: none
      }

      .btn-group-vertical>.btn+.btn,
      .btn-group-vertical>.btn+.btn-group,
      .btn-group-vertical>.btn-group+.btn,
      .btn-group-vertical>.btn-group+.btn-group {
        margin-top: -1px;
        margin-left: 0
      }

      .btn-group-vertical>.btn:not(:first-child):not(:last-child) {
        border-radius: 0
      }

      .btn-group-vertical>.btn:first-child:not(:last-child) {
        border-top-right-radius: 4px;
        border-top-left-radius: 4px;
        border-bottom-right-radius: 0;
        border-bottom-left-radius: 0
      }

      .btn-group-vertical>.btn:last-child:not(:first-child) {
        border-top-right-radius: 0;
        border-top-left-radius: 0;
        border-bottom-right-radius: 4px;
        border-bottom-left-radius: 4px
      }

      .btn-group-vertical>.btn-group:not(:first-child):not(:last-child)>.btn {
        border-radius: 0
      }

      .btn-group-vertical>.btn-group:first-child:not(:last-child)>.btn:last-child,
      .btn-group-vertical>.btn-group:first-child:not(:last-child)>.dropdown-toggle {
        border-bottom-right-radius: 0;
        border-bottom-left-radius: 0
      }

      .btn-group-vertical>.btn-group:last-child:not(:first-child)>.btn:first-child {
        border-top-right-radius: 0;
        border-top-left-radius: 0
      }

      .btn-group-justified {
        display: table;
        width: 100%;
        table-layout: fixed;
        border-collapse: separate
      }

      .btn-group-justified>.btn,
      .btn-group-justified>.btn-group {
        float: none;
        display: table-cell;
        width: 1%
      }

      .btn-group-justified>.btn-group .btn {
        width: 100%
      }

      .btn-group-justified>.btn-group .dropdown-menu {
        left: auto
      }

      [data-toggle="buttons"]>.btn input[type="radio"],
      [data-toggle="buttons"]>.btn input[type="checkbox"],
      [data-toggle="buttons"]>.btn-group>.btn input[type="radio"],
      [data-toggle="buttons"]>.btn-group>.btn input[type="checkbox"] {
        position: absolute;
        clip: rect(0, 0, 0, 0);
        pointer-events: none
      }

      .input-group {
        position: relative;
        display: table;
        border-collapse: separate
      }

      .input-group[class*="col-"] {
        float: none;
        padding-left: 0;
        padding-right: 0
      }

      .input-group .form-control {
        position: relative;
        z-index: 2;
        float: left;
        width: 100%;
        margin-bottom: 0
      }

      .input-group .form-control:focus {
        z-index: 3
      }

      .input-group-addon,
      .input-group-btn,
      .input-group .form-control {
        display: table-cell
      }

      .input-group-addon:not(:first-child):not(:last-child),
      .input-group-btn:not(:first-child):not(:last-child),
      .input-group .form-control:not(:first-child):not(:last-child) {
        border-radius: 0
      }

      .input-group-addon,
      .input-group-btn {
        width: 1%;
        white-space: nowrap;
        vertical-align: middle
      }

      .input-group-addon {
        padding: 6px 12px;
        font-size: 14px;
        font-weight: normal;
        line-height: 1;
        color: #555555;
        text-align: center;
        background-color: #eeeeee;
        border: 1px solid #ccc;
        border-radius: 4px
      }

      .input-group-addon.input-sm,
      .input-group-sm>.input-group-addon,
      .input-group-sm>.input-group-btn>.input-group-addon.btn {
        padding: 5px 10px;
        font-size: 12px;
        border-radius: 3px
      }

      .input-group-addon.input-lg,
      .input-group-lg>.input-group-addon,
      .input-group-lg>.input-group-btn>.input-group-addon.btn {
        padding: 10px 16px;
        font-size: 18px;
        border-radius: 6px
      }

      .input-group-addon input[type="radio"],
      .input-group-addon input[type="checkbox"] {
        margin-top: 0
      }

      .input-group .form-control:first-child,
      .input-group-addon:first-child,
      .input-group-btn:first-child>.btn,
      .input-group-btn:first-child>.btn-group>.btn,
      .input-group-btn:first-child>.dropdown-toggle,
      .input-group-btn:last-child>.btn:not(:last-child):not(.dropdown-toggle),
      .input-group-btn:last-child>.btn-group:not(:last-child)>.btn {
        border-bottom-right-radius: 0;
        border-top-right-radius: 0
      }

      .input-group-addon:first-child {
        border-right: 0
      }

      .input-group .form-control:last-child,
      .input-group-addon:last-child,
      .input-group-btn:last-child>.btn,
      .input-group-btn:last-child>.btn-group>.btn,
      .input-group-btn:last-child>.dropdown-toggle,
      .input-group-btn:first-child>.btn:not(:first-child),
      .input-group-btn:first-child>.btn-group:not(:first-child)>.btn {
        border-bottom-left-radius: 0;
        border-top-left-radius: 0
      }

      .input-group-addon:last-child {
        border-left: 0
      }

      .input-group-btn {
        position: relative;
        font-size: 0;
        white-space: nowrap
      }

      .input-group-btn>.btn {
        position: relative
      }

      .input-group-btn>.btn+.btn {
        margin-left: -1px
      }

      .input-group-btn>.btn:hover,
      .input-group-btn>.btn:focus,
      .input-group-btn>.btn:active {
        z-index: 2
      }

      .input-group-btn:first-child>.btn,
      .input-group-btn:first-child>.btn-group {
        margin-right: -1px
      }

      .input-group-btn:last-child>.btn,
      .input-group-btn:last-child>.btn-group {
        z-index: 2;
        margin-left: -1px
      }

      .nav {
        margin-bottom: 0;
        padding-left: 0;
        list-style: none
      }

      .nav:before,
      .nav:after {
        content: " ";
        display: table
      }

      .nav:after {
        clear: both
      }

      .nav>li {
        position: relative;
        display: block
      }

      .nav>li>a {
        position: relative;
        display: block;
        padding: 10px 15px;
        text-decoration: none
      }

      .nav>li>a:hover,
      .nav>li>a:focus {
        text-decoration: none;
        background-color: #eeeeee
      }

      .nav>li.disabled>a {
        color: #777777
      }

      .nav>li.disabled>a:hover,
      .nav>li.disabled>a:focus {
        color: #777777;
        text-decoration: none;
        background-color: transparent;
        cursor: not-allowed
      }

      .nav .open>a,
      .nav .open>a:hover,
      .nav .open>a:focus {
        background-color: #eeeeee;
        border-color: #337ab7
      }

      .nav .nav-divider {
        height: 1px;
        margin: 9px 0;
        overflow: hidden;
        background-color: #e5e5e5
      }

      .nav>li>a>img {
        max-width: none
      }

      .nav-tabs {
        border-bottom: 1px solid #ddd
      }

      .nav-tabs>li {
        float: left;
        margin-bottom: -1px
      }

      .nav-tabs>li>a {
        margin-right: 2px;
        line-height: 1.42857;
        border: 1px solid transparent;
        border-radius: 4px 4px 0 0
      }

      .nav-tabs>li>a:hover {
        border-color: #eeeeee #eeeeee #ddd
      }

      .nav-tabs>li.active>a,
      .nav-tabs>li.active>a:hover,
      .nav-tabs>li.active>a:focus {
        color: #555555;
        background-color: #fff;
        border: 1px solid #ddd;
        border-bottom-color: transparent;
        cursor: default
      }

      .nav-pills>li {
        float: left
      }

      .nav-pills>li>a {
        border-radius: 4px
      }

      .nav-pills>li+li {
        margin-left: 2px
      }

      .nav-pills>li.active>a,
      .nav-pills>li.active>a:hover,
      .nav-pills>li.active>a:focus {
        color: #fff;
        background-color: #337ab7
      }

      .nav-stacked>li {
        float: none
      }

      .nav-stacked>li+li {
        margin-top: 2px;
        margin-left: 0
      }

      .nav-justified,
      .nav-tabs.nav-justified {
        width: 100%
      }

      .nav-justified>li,
      .nav-tabs.nav-justified>li {
        float: none
      }

      .nav-justified>li>a,
      .nav-tabs.nav-justified>li>a {
        text-align: center;
        margin-bottom: 5px
      }

      .nav-justified>.dropdown .dropdown-menu {
        top: auto;
        left: auto
      }

      @media (min-width:768px) {

        .nav-justified>li,
        .nav-tabs.nav-justified>li {
          display: table-cell;
          width: 1%
        }

        .nav-justified>li>a,
        .nav-tabs.nav-justified>li>a {
          margin-bottom: 0
        }
      }

      .nav-tabs-justified,
      .nav-tabs.nav-justified {
        border-bottom: 0
      }

      .nav-tabs-justified>li>a,
      .nav-tabs.nav-justified>li>a {
        margin-right: 0;
        border-radius: 4px
      }

      .nav-tabs-justified>.active>a,
      .nav-tabs.nav-justified>.active>a,
      .nav-tabs-justified>.active>a:hover,
      .nav-tabs.nav-justified>.active>a:hover,
      .nav-tabs-justified>.active>a:focus,
      .nav-tabs.nav-justified>.active>a:focus {
        border: 1px solid #ddd
      }

      @media (min-width:768px) {

        .nav-tabs-justified>li>a,
        .nav-tabs.nav-justified>li>a {
          border-bottom: 1px solid #ddd;
          border-radius: 4px 4px 0 0
        }

        .nav-tabs-justified>.active>a,
        .nav-tabs.nav-justified>.active>a,
        .nav-tabs-justified>.active>a:hover,
        .nav-tabs.nav-justified>.active>a:hover,
        .nav-tabs-justified>.active>a:focus,
        .nav-tabs.nav-justified>.active>a:focus {
          border-bottom-color: #fff
        }
      }

      .tab-content>.tab-pane {
        display: none
      }

      .tab-content>.active {
        display: block
      }

      .nav-tabs .dropdown-menu {
        margin-top: -1px;
        border-top-right-radius: 0;
        border-top-left-radius: 0
      }

      .navbar {
        position: relative;
        min-height: 50px;
        margin-bottom: 20px;
        border: 1px solid transparent
      }

      .navbar:before,
      .navbar:after {
        content: " ";
        display: table
      }

      .navbar:after {
        clear: both
      }

      @media (min-width:992px) {
        .navbar {
          border-radius: 4px
        }
      }

      .navbar-header:before,
      .navbar-header:after {
        content: " ";
        display: table
      }

      .navbar-header:after {
        clear: both
      }

      @media (min-width:992px) {
        .navbar-header {
          float: left
        }
      }

      .navbar-collapse {
        overflow-x: visible;
        padding-right: 0;
        padding-left: 0;
        border-top: 1px solid transparent;
        box-shadow: inset 0 1px 0 rgba(255, 255, 255, .1);
        -webkit-overflow-scrolling: touch
      }

      .navbar-collapse:before,
      .navbar-collapse:after {
        content: " ";
        display: table
      }

      .navbar-collapse:after {
        clear: both
      }

      .navbar-collapse.in {
        overflow-y: auto
      }

      @media (min-width:992px) {
        .navbar-collapse {
          width: auto;
          border-top: 0;
          box-shadow: none
        }

        .navbar-collapse.collapse {
          display: block !important;
          height: auto !important;
          padding-bottom: 0;
          overflow: visible !important
        }

        .navbar-collapse.in {
          overflow-y: visible
        }

        .navbar-fixed-top .navbar-collapse,
        .navbar-static-top .navbar-collapse,
        .navbar-fixed-bottom .navbar-collapse {
          padding-left: 0;
          padding-right: 0
        }
      }

      .navbar-fixed-top .navbar-collapse,
      .navbar-fixed-bottom .navbar-collapse {
        max-height: 340px
      }

      @media (max-device-width:480px) and (orientation:landscape) {

        .navbar-fixed-top .navbar-collapse,
        .navbar-fixed-bottom .navbar-collapse {
          max-height: 200px
        }
      }

      .container>.navbar-header,
      .container>.navbar-collapse,
      .container-fluid>.navbar-header,
      .container-fluid>.navbar-collapse {
        margin-right: 0;
        margin-left: 0
      }

      @media (min-width:992px) {

        .container>.navbar-header,
        .container>.navbar-collapse,
        .container-fluid>.navbar-header,
        .container-fluid>.navbar-collapse {
          margin-right: 0;
          margin-left: 0
        }
      }

      .navbar-static-top {
        z-index: 1000;
        border-width: 0 0 1px
      }

      @media (min-width:992px) {
        .navbar-static-top {
          border-radius: 0
        }
      }

      .navbar-fixed-top,
      .navbar-fixed-bottom {
        position: fixed;
        right: 0;
        left: 0;
        z-index: 1030
      }

      @media (min-width:992px) {

        .navbar-fixed-top,
        .navbar-fixed-bottom {
          border-radius: 0
        }
      }

      .navbar-fixed-top {
        top: 0;
        border-width: 0 0 1px
      }

      .navbar-fixed-bottom {
        bottom: 0;
        margin-bottom: 0;
        border-width: 1px 0 0
      }

      .navbar-brand {
        float: left;
        padding: 5px 0;
        padding-top: 10px;
        font-size: 18px;
        line-height: 20px;
        height: 50px
      }

      .navbar-brand:hover,
      .navbar-brand:focus {
        text-decoration: none
      }

      .navbar-brand>img {
        display: block
      }

      @media (min-width:992px) {

        .navbar>.container .navbar-brand,
        .navbar>.container-fluid .navbar-brand {
          margin-left: 0
        }
      }

      .navbar-toggle {
        position: relative;
        float: right;
        margin-right: 0;
        padding: 9px 10px;
        margin-top: 8px;
        margin-bottom: 8px;
        background-color: transparent;
        background-image: none;
        border: 1px solid transparent;
        border-radius: 4px
      }

      .navbar-toggle:focus {
        outline: 0
      }

      .navbar-toggle .icon-bar {
        display: block;
        width: 22px;
        height: 2px;
        border-radius: 1px
      }

      .navbar-toggle .icon-bar+.icon-bar {
        margin-top: 4px
      }

      @media (min-width:992px) {
        .navbar-toggle {
          display: none
        }
      }

      .navbar-nav {
        margin: 7.5px 0
      }

      .navbar-nav>li>a {
        padding-top: 10px;
        padding-bottom: 10px;
        line-height: 20px
      }

      @media (max-width:991px) {
        .navbar-nav .open .dropdown-menu {
          position: static;
          float: none;
          width: auto;
          margin-top: 0;
          background-color: transparent;
          border: 0;
          box-shadow: none
        }

        .navbar-nav .open .dropdown-menu>li>a,
        .navbar-nav .open .dropdown-menu .dropdown-header {
          padding: 5px 15px 5px 25px
        }

        .navbar-nav .open .dropdown-menu>li>a {
          line-height: 20px
        }

        .navbar-nav .open .dropdown-menu>li>a:hover,
        .navbar-nav .open .dropdown-menu>li>a:focus {
          background-image: none
        }
      }

      @media (min-width:992px) {
        .navbar-nav {
          float: left;
          margin: 0
        }

        .navbar-nav>li {
          float: left
        }

        .navbar-nav>li>a {
          padding-top: 15px;
          padding-bottom: 15px
        }
      }

      .navbar-form {
        margin-left: 0;
        margin-right: 0;
        padding: 10px 0;
        border-top: 1px solid transparent;
        border-bottom: 1px solid transparent;
        -webkit-box-shadow: inset 0 1px 0 rgba(255, 255, 255, .1), 0 1px 0 rgba(255, 255, 255, .1);
        box-shadow: inset 0 1px 0 rgba(255, 255, 255, .1), 0 1px 0 rgba(255, 255, 255, .1);
        margin-top: 8px;
        margin-bottom: 8px
      }

      @media (min-width:768px) {
        .navbar-form .form-group {
          display: inline-block;
          margin-bottom: 0;
          vertical-align: middle
        }

        .navbar-form .form-control {
          display: inline-block;
          width: auto;
          vertical-align: middle
        }

        .navbar-form .form-control-static {
          display: inline-block
        }

        .navbar-form .input-group {
          display: inline-table;
          vertical-align: middle
        }

        .navbar-form .input-group .input-group-addon,
        .navbar-form .input-group .input-group-btn,
        .navbar-form .input-group .form-control {
          width: auto
        }

        .navbar-form .input-group>.form-control {
          width: 100%
        }

        .navbar-form .control-label {
          margin-bottom: 0;
          vertical-align: middle
        }

        .navbar-form .radio,
        .navbar-form .checkbox {
          display: inline-block;
          margin-top: 0;
          margin-bottom: 0;
          vertical-align: middle
        }

        .navbar-form .radio label,
        .navbar-form .checkbox label {
          padding-left: 0
        }

        .navbar-form .radio input[type="radio"],
        .navbar-form .checkbox input[type="checkbox"] {
          position: relative;
          margin-left: 0
        }

        .navbar-form .has-feedback .form-control-feedback {
          top: 0
        }
      }

      @media (max-width:991px) {
        .navbar-form .form-group {
          margin-bottom: 5px
        }

        .navbar-form .form-group:last-child {
          margin-bottom: 0
        }
      }

      @media (min-width:992px) {
        .navbar-form {
          width: auto;
          border: 0;
          margin-left: 0;
          margin-right: 0;
          padding-top: 0;
          padding-bottom: 0;
          -webkit-box-shadow: none;
          box-shadow: none
        }
      }

      .navbar-nav>li>.dropdown-menu {
        margin-top: 0;
        border-top-right-radius: 0;
        border-top-left-radius: 0
      }

      .navbar-fixed-bottom .navbar-nav>li>.dropdown-menu {
        margin-bottom: 0;
        border-top-right-radius: 4px;
        border-top-left-radius: 4px;
        border-bottom-right-radius: 0;
        border-bottom-left-radius: 0
      }

      .navbar-btn {
        margin-top: 8px;
        margin-bottom: 8px
      }

      .navbar-btn.btn-sm,
      .btn-group-sm>.navbar-btn.btn {
        margin-top: 10px;
        margin-bottom: 10px
      }

      .navbar-btn.btn-xs,
      .btn-group-xs>.navbar-btn.btn {
        margin-top: 14px;
        margin-bottom: 14px
      }

      .navbar-text {
        margin-top: 15px;
        margin-bottom: 15px
      }

      @media (min-width:992px) {
        .navbar-text {
          float: left;
          margin-left: 0;
          margin-right: 0
        }
      }

      @media (min-width:992px) {
        .navbar-left {
          float: left !important
        }

        .navbar-right {
          float: right !important;
          margin-right: 0
        }

        .navbar-right~.navbar-right {
          margin-right: 0
        }
      }

      .navbar-default {
        background-color: #f8f8f8;
        border-color: #e7e7e7
      }

      .navbar-default .navbar-brand {
        color: #777
      }

      .navbar-default .navbar-brand:hover,
      .navbar-default .navbar-brand:focus {
        color: #5e5e5e;
        background-color: transparent
      }

      .navbar-default .navbar-text {
        color: #777
      }

      .navbar-default .navbar-nav>li>a {
        color: #777
      }

      .navbar-default .navbar-nav>li>a:hover,
      .navbar-default .navbar-nav>li>a:focus {
        color: #333;
        background-color: transparent
      }

      .navbar-default .navbar-nav>.active>a,
      .navbar-default .navbar-nav>.active>a:hover,
      .navbar-default .navbar-nav>.active>a:focus {
        color: #555;
        background-color: #e7e7e7
      }

      .navbar-default .navbar-nav>.disabled>a,
      .navbar-default .navbar-nav>.disabled>a:hover,
      .navbar-default .navbar-nav>.disabled>a:focus {
        color: #ccc;
        background-color: transparent
      }

      .navbar-default .navbar-toggle {
        border-color: #ddd
      }

      .navbar-default .navbar-toggle:hover,
      .navbar-default .navbar-toggle:focus {
        background-color: #ddd
      }

      .navbar-default .navbar-toggle .icon-bar {
        background-color: #888
      }

      .navbar-default .navbar-collapse,
      .navbar-default .navbar-form {
        border-color: #e7e7e7
      }

      .navbar-default .navbar-nav>.open>a,
      .navbar-default .navbar-nav>.open>a:hover,
      .navbar-default .navbar-nav>.open>a:focus {
        background-color: #e7e7e7;
        color: #555
      }

      @media (max-width:991px) {
        .navbar-default .navbar-nav .open .dropdown-menu>li>a {
          color: #777
        }

        .navbar-default .navbar-nav .open .dropdown-menu>li>a:hover,
        .navbar-default .navbar-nav .open .dropdown-menu>li>a:focus {
          color: #333;
          background-color: transparent
        }

        .navbar-default .navbar-nav .open .dropdown-menu>.active>a,
        .navbar-default .navbar-nav .open .dropdown-menu>.active>a:hover,
        .navbar-default .navbar-nav .open .dropdown-menu>.active>a:focus {
          color: #555;
          background-color: #e7e7e7
        }

        .navbar-default .navbar-nav .open .dropdown-menu>.disabled>a,
        .navbar-default .navbar-nav .open .dropdown-menu>.disabled>a:hover,
        .navbar-default .navbar-nav .open .dropdown-menu>.disabled>a:focus {
          color: #ccc;
          background-color: transparent
        }
      }

      .navbar-default .navbar-link {
        color: #777
      }

      .navbar-default .navbar-link:hover {
        color: #333
      }

      .navbar-default .btn-link {
        color: #777
      }

      .navbar-default .btn-link:hover,
      .navbar-default .btn-link:focus {
        color: #333
      }

      .navbar-default .btn-link[disabled]:hover,
      .navbar-default .btn-link[disabled]:focus,
      fieldset[disabled] .navbar-default .btn-link:hover,
      fieldset[disabled] .navbar-default .btn-link:focus {
        color: #ccc
      }

      .navbar-inverse {
        background-color: #222;
        border-color: #090909
      }

      .navbar-inverse .navbar-brand {
        color: #9d9d9d
      }

      .navbar-inverse .navbar-brand:hover,
      .navbar-inverse .navbar-brand:focus {
        color: #fff;
        background-color: transparent
      }

      .navbar-inverse .navbar-text {
        color: #9d9d9d
      }

      .navbar-inverse .navbar-nav>li>a {
        color: #9d9d9d
      }

      .navbar-inverse .navbar-nav>li>a:hover,
      .navbar-inverse .navbar-nav>li>a:focus {
        color: #fff;
        background-color: transparent
      }

      .navbar-inverse .navbar-nav>.active>a,
      .navbar-inverse .navbar-nav>.active>a:hover,
      .navbar-inverse .navbar-nav>.active>a:focus {
        color: #fff;
        background-color: #090909
      }

      .navbar-inverse .navbar-nav>.disabled>a,
      .navbar-inverse .navbar-nav>.disabled>a:hover,
      .navbar-inverse .navbar-nav>.disabled>a:focus {
        color: #444;
        background-color: transparent
      }

      .navbar-inverse .navbar-toggle {
        border-color: #333
      }

      .navbar-inverse .navbar-toggle:hover,
      .navbar-inverse .navbar-toggle:focus {
        background-color: #333
      }

      .navbar-inverse .navbar-toggle .icon-bar {
        background-color: #fff
      }

      .navbar-inverse .navbar-collapse,
      .navbar-inverse .navbar-form {
        border-color: #101010
      }

      .navbar-inverse .navbar-nav>.open>a,
      .navbar-inverse .navbar-nav>.open>a:hover,
      .navbar-inverse .navbar-nav>.open>a:focus {
        background-color: #090909;
        color: #fff
      }

      @media (max-width:991px) {
        .navbar-inverse .navbar-nav .open .dropdown-menu>.dropdown-header {
          border-color: #090909
        }

        .navbar-inverse .navbar-nav .open .dropdown-menu .divider {
          background-color: #090909
        }

        .navbar-inverse .navbar-nav .open .dropdown-menu>li>a {
          color: #9d9d9d
        }

        .navbar-inverse .navbar-nav .open .dropdown-menu>li>a:hover,
        .navbar-inverse .navbar-nav .open .dropdown-menu>li>a:focus {
          color: #fff;
          background-color: transparent
        }

        .navbar-inverse .navbar-nav .open .dropdown-menu>.active>a,
        .navbar-inverse .navbar-nav .open .dropdown-menu>.active>a:hover,
        .navbar-inverse .navbar-nav .open .dropdown-menu>.active>a:focus {
          color: #fff;
          background-color: #090909
        }

        .navbar-inverse .navbar-nav .open .dropdown-menu>.disabled>a,
        .navbar-inverse .navbar-nav .open .dropdown-menu>.disabled>a:hover,
        .navbar-inverse .navbar-nav .open .dropdown-menu>.disabled>a:focus {
          color: #444;
          background-color: transparent
        }
      }

      .navbar-inverse .navbar-link {
        color: #9d9d9d
      }

      .navbar-inverse .navbar-link:hover {
        color: #fff
      }

      .navbar-inverse .btn-link {
        color: #9d9d9d
      }

      .navbar-inverse .btn-link:hover,
      .navbar-inverse .btn-link:focus {
        color: #fff
      }

      .navbar-inverse .btn-link[disabled]:hover,
      .navbar-inverse .btn-link[disabled]:focus,
      fieldset[disabled] .navbar-inverse .btn-link:hover,
      fieldset[disabled] .navbar-inverse .btn-link:focus {
        color: #444
      }

      .breadcrumb {
        padding: 8px 15px;
        margin-bottom: 20px;
        list-style: none;
        background-color: #f5f5f5;
        border-radius: 4px
      }

      .breadcrumb>li {
        display: inline-block
      }

      .breadcrumb>li+li:before {
        content: "/ ";
        padding: 0 5px;
        color: #ccc
      }

      .breadcrumb>.active {
        color: #777777
      }

      .pagination {
        display: inline-block;
        padding-left: 0;
        margin: 20px 0;
        border-radius: 4px
      }

      .pagination>li {
        display: inline
      }

      .pagination>li>a,
      .pagination>li>span {
        position: relative;
        float: left;
        padding: 6px 12px;
        line-height: 1.42857;
        text-decoration: none;
        color: #337ab7;
        background-color: #fff;
        border: 1px solid #ddd;
        margin-left: -1px
      }

      .pagination>li:first-child>a,
      .pagination>li:first-child>span {
        margin-left: 0;
        border-bottom-left-radius: 4px;
        border-top-left-radius: 4px
      }

      .pagination>li:last-child>a,
      .pagination>li:last-child>span {
        border-bottom-right-radius: 4px;
        border-top-right-radius: 4px
      }

      .pagination>li>a:hover,
      .pagination>li>a:focus,
      .pagination>li>span:hover,
      .pagination>li>span:focus {
        z-index: 2;
        color: #bad606;
        background-color: #eeeeee;
        border-color: #ddd
      }

      .pagination>.active>a,
      .pagination>.active>a:hover,
      .pagination>.active>a:focus,
      .pagination>.active>span,
      .pagination>.active>span:hover,
      .pagination>.active>span:focus {
        z-index: 3;
        color: #fff;
        background-color: #337ab7;
        border-color: #337ab7;
        cursor: default
      }

      .pagination>.disabled>span,
      .pagination>.disabled>span:hover,
      .pagination>.disabled>span:focus,
      .pagination>.disabled>a,
      .pagination>.disabled>a:hover,
      .pagination>.disabled>a:focus {
        color: #777777;
        background-color: #fff;
        border-color: #ddd;
        cursor: not-allowed
      }

      .pagination-lg>li>a,
      .pagination-lg>li>span {
        padding: 10px 16px;
        font-size: 18px;
        line-height: 1.33333
      }

      .pagination-lg>li:first-child>a,
      .pagination-lg>li:first-child>span {
        border-bottom-left-radius: 6px;
        border-top-left-radius: 6px
      }

      .pagination-lg>li:last-child>a,
      .pagination-lg>li:last-child>span {
        border-bottom-right-radius: 6px;
        border-top-right-radius: 6px
      }

      .pagination-sm>li>a,
      .pagination-sm>li>span {
        padding: 5px 10px;
        font-size: 12px;
        line-height: 1.5
      }

      .pagination-sm>li:first-child>a,
      .pagination-sm>li:first-child>span {
        border-bottom-left-radius: 3px;
        border-top-left-radius: 3px
      }

      .pagination-sm>li:last-child>a,
      .pagination-sm>li:last-child>span {
        border-bottom-right-radius: 3px;
        border-top-right-radius: 3px
      }

      .pager {
        padding-left: 0;
        margin: 20px 0;
        list-style: none;
        text-align: center
      }

      .pager:before,
      .pager:after {
        content: " ";
        display: table
      }

      .pager:after {
        clear: both
      }

      .pager li {
        display: inline
      }

      .pager li>a,
      .pager li>span {
        display: inline-block;
        padding: 5px 14px;
        background-color: #fff;
        border: 1px solid #ddd;
        border-radius: 15px
      }

      .pager li>a:hover,
      .pager li>a:focus {
        text-decoration: none;
        background-color: #eeeeee
      }

      .pager .next>a,
      .pager .next>span {
        float: right
      }

      .pager .previous>a,
      .pager .previous>span {
        float: left
      }

      .pager .disabled>a,
      .pager .disabled>a:hover,
      .pager .disabled>a:focus,
      .pager .disabled>span {
        color: #777777;
        background-color: #fff;
        cursor: not-allowed
      }

      .label {
        display: inline;
        padding: .2em .6em .3em;
        font-size: 75%;
        font-weight: bold;
        line-height: 1;
        color: #fff;
        text-align: center;
        white-space: nowrap;
        vertical-align: baseline;
        border-radius: .25em
      }

      .label:empty {
        display: none
      }

      .btn .label {
        position: relative;
        top: -1px
      }

      a.label:hover,
      a.label:focus {
        color: #fff;
        text-decoration: none;
        cursor: pointer
      }

      .label-default {
        background-color: #777777
      }

      .label-default[href]:hover,
      .label-default[href]:focus {
        background-color: #5e5e5e
      }

      .label-primary {
        background-color: #337ab7
      }

      .label-primary[href]:hover,
      .label-primary[href]:focus {
        background-color: #286090
      }

      .label-success {
        background-color: #5cb85c
      }

      .label-success[href]:hover,
      .label-success[href]:focus {
        background-color: #449d44
      }

      .label-info {
        background-color: #5bc0de
      }

      .label-info[href]:hover,
      .label-info[href]:focus {
        background-color: #31b0d5
      }

      .label-warning {
        background-color: #f0ad4e
      }

      .label-warning[href]:hover,
      .label-warning[href]:focus {
        background-color: #ec971f
      }

      .label-danger {
        background-color: #d9534f
      }

      .label-danger[href]:hover,
      .label-danger[href]:focus {
        background-color: #c9302c
      }

      .badge {
        display: inline-block;
        min-width: 10px;
        padding: 3px 7px;
        font-size: 12px;
        font-weight: bold;
        color: #fff;
        line-height: 1;
        vertical-align: middle;
        white-space: nowrap;
        text-align: center;
        background-color: #777777;
        border-radius: 10px
      }

      .badge:empty {
        display: none
      }

      .btn .badge {
        position: relative;
        top: -1px
      }

      .btn-xs .badge,
      .btn-group-xs>.btn .badge,
      .btn-group-xs>.btn .badge {
        top: 0;
        padding: 1px 5px
      }

      .list-group-item.active>.badge,
      .nav-pills>.active>a>.badge {
        color: #337ab7;
        background-color: #fff
      }

      .list-group-item>.badge {
        float: right
      }

      .list-group-item>.badge+.badge {
        margin-right: 5px
      }

      .nav-pills>li>a>.badge {
        margin-left: 3px
      }

      a.badge:hover,
      a.badge:focus {
        color: #fff;
        text-decoration: none;
        cursor: pointer
      }

      .jumbotron {
        padding-top: 30px;
        padding-bottom: 30px;
        color: inherit;
        background-color: #eeeeee
      }

      .jumbotron.yellow {
        color: #333333
      }

      .jumbotron h1,
      .jumbotron .h1 {
        color: inherit
      }

      .jumbotron p {
        margin-bottom: 15px;
        font-size: 21px;
        font-weight: 200
      }

      .jumbotron>hr {
        border-top-color: #d5d5d5
      }

      .container .jumbotron,
      .container-fluid .jumbotron {
        padding-left: 0;
        padding-right: 0
      }

      .jumbotron .container {
        max-width: 100%
      }

      @media screen and (min-width:768px) {
        .jumbotron {
          padding-top: 48px;
          padding-bottom: 48px
        }

        .container .jumbotron,
        .container-fluid .jumbotron {
          padding-left: 60px;
          padding-right: 60px
        }

        .jumbotron h1,
        .jumbotron .h1 {
          font-size: 63px
        }
      }

      .thumbnail {
        display: block;
        padding: 4px;
        margin-bottom: 20px;
        line-height: 1.42857;
        background-color: #fff;
        border: 1px solid #ddd;
        border-radius: 4px;
        -webkit-transition: border .2s ease-in-out;
        -o-transition: border .2s ease-in-out;
        transition: border .2s ease-in-out
      }

      .thumbnail>img,
      .thumbnail a>img {
        display: block;
        max-width: 100%;
        height: auto;
        margin-left: auto;
        margin-right: auto
      }

      .thumbnail .caption {
        padding: 9px;
        color: #333333
      }

      a.thumbnail:hover,
      a.thumbnail:focus,
      a.thumbnail.active {
        border-color: #337ab7
      }

      .alert {
        padding: 15px;
        margin-bottom: 20px;
        border: 1px solid transparent;
        border-radius: 4px
      }

      .alert h4 {
        margin-top: 0;
        color: inherit
      }

      .alert .alert-link {
        font-weight: bold
      }

      .alert>p,
      .alert>ul {
        margin-bottom: 0
      }

      .alert>p+p {
        margin-top: 5px
      }

      .alert-dismissable,
      .alert-dismissible {
        padding-right: 35px
      }

      .alert-dismissable .close,
      .alert-dismissible .close {
        position: relative;
        top: -2px;
        right: -21px;
        color: inherit
      }

      .alert-success {
        background-color: #dff0d8;
        border-color: #d6e9c6;
        color: #3c763d
      }

      .alert-success hr {
        border-top-color: #c9e2b3
      }

      .alert-success .alert-link {
        color: #2b542c
      }

      .alert-info {
        background-color: #d9edf7;
        border-color: #bce8f1;
        color: #31708f
      }

      .alert-info hr {
        border-top-color: #a6e1ec
      }

      .alert-info .alert-link {
        color: #245269
      }

      .alert-warning {
        background-color: #fcf8e3;
        border-color: #faebcc;
        color: #8a6d3b
      }

      .alert-warning hr {
        border-top-color: #f7e1b5
      }

      .alert-warning .alert-link {
        color: #66512c
      }

      .alert-danger {
        background-color: #f2dede;
        border-color: #ebccd1;
        color: #a94442
      }

      .alert-danger hr {
        border-top-color: #e4b9c0
      }

      .alert-danger .alert-link {
        color: #843534
      }

      @-webkit-keyframes progress-bar-stripes {
        from {
          background-position: 40px 0
        }

        to {
          background-position: 0 0
        }
      }

      @keyframes progress-bar-stripes {
        from {
          background-position: 40px 0
        }

        to {
          background-position: 0 0
        }
      }

      .progress {
        overflow: hidden;
        height: 20px;
        margin-bottom: 20px;
        background-color: #f5f5f5;
        border-radius: 4px;
        -webkit-box-shadow: inset 0 1px 2px rgba(0, 0, 0, .1);
        box-shadow: inset 0 1px 2px rgba(0, 0, 0, .1)
      }

      .progress-bar {
        float: left;
        width: 0%;
        height: 100%;
        font-size: 12px;
        line-height: 20px;
        color: #fff;
        text-align: center;
        background-color: #337ab7;
        -webkit-box-shadow: inset 0 -1px 0 rgba(0, 0, 0, .15);
        box-shadow: inset 0 -1px 0 rgba(0, 0, 0, .15);
        -webkit-transition: width .6s ease;
        -o-transition: width .6s ease;
        transition: width .6s ease
      }

      .progress-striped .progress-bar,
      .progress-bar-striped {
        background-image: -webkit-linear-gradient(45deg, rgba(255, 255, 255, .15) 25%, transparent 25%, transparent 50%, rgba(255, 255, 255, .15) 50%, rgba(255, 255, 255, .15) 75%, transparent 75%, transparent);
        background-image: -o-linear-gradient(45deg, rgba(255, 255, 255, .15) 25%, transparent 25%, transparent 50%, rgba(255, 255, 255, .15) 50%, rgba(255, 255, 255, .15) 75%, transparent 75%, transparent);
        background-image: linear-gradient(45deg, rgba(255, 255, 255, .15) 25%, transparent 25%, transparent 50%, rgba(255, 255, 255, .15) 50%, rgba(255, 255, 255, .15) 75%, transparent 75%, transparent);
        background-size: 40px 40px
      }

      .progress.active .progress-bar,
      .progress-bar.active {
        -webkit-animation: progress-bar-stripes 2s linear infinite;
        -o-animation: progress-bar-stripes 2s linear infinite;
        animation: progress-bar-stripes 2s linear infinite
      }

      .progress-bar-success {
        background-color: #5cb85c
      }

      .progress-striped .progress-bar-success {
        background-image: -webkit-linear-gradient(45deg, rgba(255, 255, 255, .15) 25%, transparent 25%, transparent 50%, rgba(255, 255, 255, .15) 50%, rgba(255, 255, 255, .15) 75%, transparent 75%, transparent);
        background-image: -o-linear-gradient(45deg, rgba(255, 255, 255, .15) 25%, transparent 25%, transparent 50%, rgba(255, 255, 255, .15) 50%, rgba(255, 255, 255, .15) 75%, transparent 75%, transparent);
        background-image: linear-gradient(45deg, rgba(255, 255, 255, .15) 25%, transparent 25%, transparent 50%, rgba(255, 255, 255, .15) 50%, rgba(255, 255, 255, .15) 75%, transparent 75%, transparent)
      }

      .progress-bar-info {
        background-color: #5bc0de
      }

      .progress-striped .progress-bar-info {
        background-image: -webkit-linear-gradient(45deg, rgba(255, 255, 255, .15) 25%, transparent 25%, transparent 50%, rgba(255, 255, 255, .15) 50%, rgba(255, 255, 255, .15) 75%, transparent 75%, transparent);
        background-image: -o-linear-gradient(45deg, rgba(255, 255, 255, .15) 25%, transparent 25%, transparent 50%, rgba(255, 255, 255, .15) 50%, rgba(255, 255, 255, .15) 75%, transparent 75%, transparent);
        background-image: linear-gradient(45deg, rgba(255, 255, 255, .15) 25%, transparent 25%, transparent 50%, rgba(255, 255, 255, .15) 50%, rgba(255, 255, 255, .15) 75%, transparent 75%, transparent)
      }

      .progress-bar-warning {
        background-color: #f0ad4e
      }

      .progress-striped .progress-bar-warning {
        background-image: -webkit-linear-gradient(45deg, rgba(255, 255, 255, .15) 25%, transparent 25%, transparent 50%, rgba(255, 255, 255, .15) 50%, rgba(255, 255, 255, .15) 75%, transparent 75%, transparent);
        background-image: -o-linear-gradient(45deg, rgba(255, 255, 255, .15) 25%, transparent 25%, transparent 50%, rgba(255, 255, 255, .15) 50%, rgba(255, 255, 255, .15) 75%, transparent 75%, transparent);
        background-image: linear-gradient(45deg, rgba(255, 255, 255, .15) 25%, transparent 25%, transparent 50%, rgba(255, 255, 255, .15) 50%, rgba(255, 255, 255, .15) 75%, transparent 75%, transparent)
      }

      .progress-bar-danger {
        background-color: #d9534f
      }

      .progress-striped .progress-bar-danger {
        background-image: -webkit-linear-gradient(45deg, rgba(255, 255, 255, .15) 25%, transparent 25%, transparent 50%, rgba(255, 255, 255, .15) 50%, rgba(255, 255, 255, .15) 75%, transparent 75%, transparent);
        background-image: -o-linear-gradient(45deg, rgba(255, 255, 255, .15) 25%, transparent 25%, transparent 50%, rgba(255, 255, 255, .15) 50%, rgba(255, 255, 255, .15) 75%, transparent 75%, transparent);
        background-image: linear-gradient(45deg, rgba(255, 255, 255, .15) 25%, transparent 25%, transparent 50%, rgba(255, 255, 255, .15) 50%, rgba(255, 255, 255, .15) 75%, transparent 75%, transparent)
      }

      .media {
        margin-top: 15px
      }

      .media:first-child {
        margin-top: 0
      }

      .media,
      .media-body {
        zoom: 1;
        overflow: hidden
      }

      .media-body {
        width: 10000px
      }

      .media-object {
        display: block
      }

      .media-object.img-thumbnail {
        max-width: none
      }

      .media-right,
      .media>.pull-right {
        padding-left: 10px
      }

      .media-left,
      .media>.pull-left {
        padding-right: 10px
      }

      .media-left,
      .media-right,
      .media-body {
        display: table-cell;
        vertical-align: top
      }

      .media-middle {
        vertical-align: middle
      }

      .media-bottom {
        vertical-align: bottom
      }

      .media-heading {
        margin-top: 0;
        margin-bottom: 5px
      }

      .media-list {
        padding-left: 0;
        list-style: none
      }

      .list-group {
        margin-bottom: 20px;
        padding-left: 0
      }

      .list-group-item {
        position: relative;
        display: block;
        padding: 10px 15px;
        margin-bottom: -1px;
        background-color: #fff;
        border: 1px solid #ddd
      }

      .list-group-item:first-child {
        border-top-right-radius: 4px;
        border-top-left-radius: 4px
      }

      .list-group-item:last-child {
        margin-bottom: 0;
        border-bottom-right-radius: 4px;
        border-bottom-left-radius: 4px
      }

      a.list-group-item,
      button.list-group-item {
        color: #555
      }

      a.list-group-item .list-group-item-heading,
      button.list-group-item .list-group-item-heading {
        color: #333
      }

      a.list-group-item:hover,
      a.list-group-item:focus,
      button.list-group-item:hover,
      button.list-group-item:focus {
        text-decoration: none;
        color: #555;
        background-color: #f5f5f5
      }

      button.list-group-item {
        width: 100%;
        text-align: left
      }

      .list-group-item.disabled,
      .list-group-item.disabled:hover,
      .list-group-item.disabled:focus {
        background-color: #eeeeee;
        color: #777777;
        cursor: not-allowed
      }

      .list-group-item.disabled .list-group-item-heading,
      .list-group-item.disabled:hover .list-group-item-heading,
      .list-group-item.disabled:focus .list-group-item-heading {
        color: inherit
      }

      .list-group-item.disabled .list-group-item-text,
      .list-group-item.disabled:hover .list-group-item-text,
      .list-group-item.disabled:focus .list-group-item-text {
        color: #777777
      }

      .list-group-item.active,
      .list-group-item.active:hover,
      .list-group-item.active:focus {
        z-index: 2;
        color: #fff;
        background-color: #337ab7;
        border-color: #337ab7
      }

      .list-group-item.active .list-group-item-heading,
      .list-group-item.active .list-group-item-heading>small,
      .list-group-item.active .list-group-item-heading>.small,
      .list-group-item.active:hover .list-group-item-heading,
      .list-group-item.active:hover .list-group-item-heading>small,
      .list-group-item.active:hover .list-group-item-heading>.small,
      .list-group-item.active:focus .list-group-item-heading,
      .list-group-item.active:focus .list-group-item-heading>small,
      .list-group-item.active:focus .list-group-item-heading>.small {
        color: inherit
      }

      .list-group-item.active .list-group-item-text,
      .list-group-item.active:hover .list-group-item-text,
      .list-group-item.active:focus .list-group-item-text {
        color: #c7ddef
      }

      .list-group-item-success {
        color: #3c763d;
        background-color: #dff0d8
      }

      a.list-group-item-success,
      button.list-group-item-success {
        color: #3c763d
      }

      a.list-group-item-success .list-group-item-heading,
      button.list-group-item-success .list-group-item-heading {
        color: inherit
      }

      a.list-group-item-success:hover,
      a.list-group-item-success:focus,
      button.list-group-item-success:hover,
      button.list-group-item-success:focus {
        color: #3c763d;
        background-color: #d0e9c6
      }

      a.list-group-item-success.active,
      a.list-group-item-success.active:hover,
      a.list-group-item-success.active:focus,
      button.list-group-item-success.active,
      button.list-group-item-success.active:hover,
      button.list-group-item-success.active:focus {
        color: #fff;
        background-color: #3c763d;
        border-color: #3c763d
      }

      .list-group-item-info {
        color: #31708f;
        background-color: #d9edf7
      }

      a.list-group-item-info,
      button.list-group-item-info {
        color: #31708f
      }

      a.list-group-item-info .list-group-item-heading,
      button.list-group-item-info .list-group-item-heading {
        color: inherit
      }

      a.list-group-item-info:hover,
      a.list-group-item-info:focus,
      button.list-group-item-info:hover,
      button.list-group-item-info:focus {
        color: #31708f;
        background-color: #c4e3f3
      }

      a.list-group-item-info.active,
      a.list-group-item-info.active:hover,
      a.list-group-item-info.active:focus,
      button.list-group-item-info.active,
      button.list-group-item-info.active:hover,
      button.list-group-item-info.active:focus {
        color: #fff;
        background-color: #31708f;
        border-color: #31708f
      }

      .list-group-item-warning {
        color: #8a6d3b;
        background-color: #fcf8e3
      }

      a.list-group-item-warning,
      button.list-group-item-warning {
        color: #8a6d3b
      }

      a.list-group-item-warning .list-group-item-heading,
      button.list-group-item-warning .list-group-item-heading {
        color: inherit
      }

      a.list-group-item-warning:hover,
      a.list-group-item-warning:focus,
      button.list-group-item-warning:hover,
      button.list-group-item-warning:focus {
        color: #8a6d3b;
        background-color: #faf2cc
      }

      a.list-group-item-warning.active,
      a.list-group-item-warning.active:hover,
      a.list-group-item-warning.active:focus,
      button.list-group-item-warning.active,
      button.list-group-item-warning.active:hover,
      button.list-group-item-warning.active:focus {
        color: #fff;
        background-color: #8a6d3b;
        border-color: #8a6d3b
      }

      .list-group-item-danger {
        color: #a94442;
        background-color: #f2dede
      }

      a.list-group-item-danger,
      button.list-group-item-danger {
        color: #a94442
      }

      a.list-group-item-danger .list-group-item-heading,
      button.list-group-item-danger .list-group-item-heading {
        color: inherit
      }

      a.list-group-item-danger:hover,
      a.list-group-item-danger:focus,
      button.list-group-item-danger:hover,
      button.list-group-item-danger:focus {
        color: #a94442;
        background-color: #ebcccc
      }

      a.list-group-item-danger.active,
      a.list-group-item-danger.active:hover,
      a.list-group-item-danger.active:focus,
      button.list-group-item-danger.active,
      button.list-group-item-danger.active:hover,
      button.list-group-item-danger.active:focus {
        color: #fff;
        background-color: #a94442;
        border-color: #a94442
      }

      .list-group-item-heading {
        margin-top: 0;
        margin-bottom: 5px
      }

      .list-group-item-text {
        margin-bottom: 0;
        line-height: 1.3
      }

      .panel {
        margin-bottom: 20px;
        background-color: #fff;
        border: 1px solid transparent;
        border-radius: 4px;
        -webkit-box-shadow: 0 1px 1px rgba(0, 0, 0, .05);
        box-shadow: 0 1px 1px rgba(0, 0, 0, .05)
      }

      .panel-body {
        padding: 15px
      }

      .panel-body:before,
      .panel-body:after {
        content: " ";
        display: table
      }

      .panel-body:after {
        clear: both
      }

      .panel-heading {
        padding: 10px 15px;
        border-bottom: 1px solid transparent;
        border-top-right-radius: 3px;
        border-top-left-radius: 3px
      }

      .panel-heading>.dropdown .dropdown-toggle {
        color: inherit
      }

      .panel-title {
        margin-top: 0;
        margin-bottom: 0;
        font-size: 16px;
        color: inherit
      }

      .panel-title>a,
      .panel-title>small,
      .panel-title>.small,
      .panel-title>small>a,
      .panel-title>.small>a {
        color: inherit
      }

      .panel-footer {
        padding: 10px 15px;
        background-color: #f5f5f5;
        border-top: 1px solid #ddd;
        border-bottom-right-radius: 3px;
        border-bottom-left-radius: 3px
      }

      .panel>.list-group,
      .panel>.panel-collapse>.list-group {
        margin-bottom: 0
      }

      .panel>.list-group .list-group-item,
      .panel>.panel-collapse>.list-group .list-group-item {
        border-width: 1px 0;
        border-radius: 0
      }

      .panel>.list-group:first-child .list-group-item:first-child,
      .panel>.panel-collapse>.list-group:first-child .list-group-item:first-child {
        border-top: 0;
        border-top-right-radius: 3px;
        border-top-left-radius: 3px
      }

      .panel>.list-group:last-child .list-group-item:last-child,
      .panel>.panel-collapse>.list-group:last-child .list-group-item:last-child {
        border-bottom: 0;
        border-bottom-right-radius: 3px;
        border-bottom-left-radius: 3px
      }

      .panel>.panel-heading+.panel-collapse>.list-group .list-group-item:first-child {
        border-top-right-radius: 0;
        border-top-left-radius: 0
      }

      .panel-heading+.list-group .list-group-item:first-child {
        border-top-width: 0
      }

      .list-group+.panel-footer {
        border-top-width: 0
      }

      .panel>.table,
      .panel>.table-responsive>.table,
      .panel>.panel-collapse>.table {
        margin-bottom: 0
      }

      .panel>.table caption,
      .panel>.table-responsive>.table caption,
      .panel>.panel-collapse>.table caption {
        padding-left: 15px;
        padding-right: 15px
      }

      .panel>.table:first-child,
      .panel>.table-responsive:first-child>.table:first-child {
        border-top-right-radius: 3px;
        border-top-left-radius: 3px
      }

      .panel>.table:first-child>thead:first-child>tr:first-child,
      .panel>.table:first-child>tbody:first-child>tr:first-child,
      .panel>.table-responsive:first-child>.table:first-child>thead:first-child>tr:first-child,
      .panel>.table-responsive:first-child>.table:first-child>tbody:first-child>tr:first-child {
        border-top-left-radius: 3px;
        border-top-right-radius: 3px
      }

      .panel>.table:first-child>thead:first-child>tr:first-child td:first-child,
      .panel>.table:first-child>thead:first-child>tr:first-child th:first-child,
      .panel>.table:first-child>tbody:first-child>tr:first-child td:first-child,
      .panel>.table:first-child>tbody:first-child>tr:first-child th:first-child,
      .panel>.table-responsive:first-child>.table:first-child>thead:first-child>tr:first-child td:first-child,
      .panel>.table-responsive:first-child>.table:first-child>thead:first-child>tr:first-child th:first-child,
      .panel>.table-responsive:first-child>.table:first-child>tbody:first-child>tr:first-child td:first-child,
      .panel>.table-responsive:first-child>.table:first-child>tbody:first-child>tr:first-child th:first-child {
        border-top-left-radius: 3px
      }

      .panel>.table:first-child>thead:first-child>tr:first-child td:last-child,
      .panel>.table:first-child>thead:first-child>tr:first-child th:last-child,
      .panel>.table:first-child>tbody:first-child>tr:first-child td:last-child,
      .panel>.table:first-child>tbody:first-child>tr:first-child th:last-child,
      .panel>.table-responsive:first-child>.table:first-child>thead:first-child>tr:first-child td:last-child,
      .panel>.table-responsive:first-child>.table:first-child>thead:first-child>tr:first-child th:last-child,
      .panel>.table-responsive:first-child>.table:first-child>tbody:first-child>tr:first-child td:last-child,
      .panel>.table-responsive:first-child>.table:first-child>tbody:first-child>tr:first-child th:last-child {
        border-top-right-radius: 3px
      }

      .panel>.table:last-child,
      .panel>.table-responsive:last-child>.table:last-child {
        border-bottom-right-radius: 3px;
        border-bottom-left-radius: 3px
      }

      .panel>.table:last-child>tbody:last-child>tr:last-child,
      .panel>.table:last-child>tfoot:last-child>tr:last-child,
      .panel>.table-responsive:last-child>.table:last-child>tbody:last-child>tr:last-child,
      .panel>.table-responsive:last-child>.table:last-child>tfoot:last-child>tr:last-child {
        border-bottom-left-radius: 3px;
        border-bottom-right-radius: 3px
      }

      .panel>.table:last-child>tbody:last-child>tr:last-child td:first-child,
      .panel>.table:last-child>tbody:last-child>tr:last-child th:first-child,
      .panel>.table:last-child>tfoot:last-child>tr:last-child td:first-child,
      .panel>.table:last-child>tfoot:last-child>tr:last-child th:first-child,
      .panel>.table-responsive:last-child>.table:last-child>tbody:last-child>tr:last-child td:first-child,
      .panel>.table-responsive:last-child>.table:last-child>tbody:last-child>tr:last-child th:first-child,
      .panel>.table-responsive:last-child>.table:last-child>tfoot:last-child>tr:last-child td:first-child,
      .panel>.table-responsive:last-child>.table:last-child>tfoot:last-child>tr:last-child th:first-child {
        border-bottom-left-radius: 3px
      }

      .panel>.table:last-child>tbody:last-child>tr:last-child td:last-child,
      .panel>.table:last-child>tbody:last-child>tr:last-child th:last-child,
      .panel>.table:last-child>tfoot:last-child>tr:last-child td:last-child,
      .panel>.table:last-child>tfoot:last-child>tr:last-child th:last-child,
      .panel>.table-responsive:last-child>.table:last-child>tbody:last-child>tr:last-child td:last-child,
      .panel>.table-responsive:last-child>.table:last-child>tbody:last-child>tr:last-child th:last-child,
      .panel>.table-responsive:last-child>.table:last-child>tfoot:last-child>tr:last-child td:last-child,
      .panel>.table-responsive:last-child>.table:last-child>tfoot:last-child>tr:last-child th:last-child {
        border-bottom-right-radius: 3px
      }

      .panel>.panel-body+.table,
      .panel>.panel-body+.table-responsive,
      .panel>.table+.panel-body,
      .panel>.table-responsive+.panel-body {
        border-top: 1px solid #ddd
      }

      .panel>.table>tbody:first-child>tr:first-child th,
      .panel>.table>tbody:first-child>tr:first-child td {
        border-top: 0
      }

      .panel>.table-bordered,
      .panel>.table-responsive>.table-bordered {
        border: 0
      }

      .panel>.table-bordered>thead>tr>th:first-child,
      .panel>.table-bordered>thead>tr>td:first-child,
      .panel>.table-bordered>tbody>tr>th:first-child,
      .panel>.table-bordered>tbody>tr>td:first-child,
      .panel>.table-bordered>tfoot>tr>th:first-child,
      .panel>.table-bordered>tfoot>tr>td:first-child,
      .panel>.table-responsive>.table-bordered>thead>tr>th:first-child,
      .panel>.table-responsive>.table-bordered>thead>tr>td:first-child,
      .panel>.table-responsive>.table-bordered>tbody>tr>th:first-child,
      .panel>.table-responsive>.table-bordered>tbody>tr>td:first-child,
      .panel>.table-responsive>.table-bordered>tfoot>tr>th:first-child,
      .panel>.table-responsive>.table-bordered>tfoot>tr>td:first-child {
        border-left: 0
      }

      .panel>.table-bordered>thead>tr>th:last-child,
      .panel>.table-bordered>thead>tr>td:last-child,
      .panel>.table-bordered>tbody>tr>th:last-child,
      .panel>.table-bordered>tbody>tr>td:last-child,
      .panel>.table-bordered>tfoot>tr>th:last-child,
      .panel>.table-bordered>tfoot>tr>td:last-child,
      .panel>.table-responsive>.table-bordered>thead>tr>th:last-child,
      .panel>.table-responsive>.table-bordered>thead>tr>td:last-child,
      .panel>.table-responsive>.table-bordered>tbody>tr>th:last-child,
      .panel>.table-responsive>.table-bordered>tbody>tr>td:last-child,
      .panel>.table-responsive>.table-bordered>tfoot>tr>th:last-child,
      .panel>.table-responsive>.table-bordered>tfoot>tr>td:last-child {
        border-right: 0
      }

      .panel>.table-bordered>thead>tr:first-child>td,
      .panel>.table-bordered>thead>tr:first-child>th,
      .panel>.table-bordered>tbody>tr:first-child>td,
      .panel>.table-bordered>tbody>tr:first-child>th,
      .panel>.table-responsive>.table-bordered>thead>tr:first-child>td,
      .panel>.table-responsive>.table-bordered>thead>tr:first-child>th,
      .panel>.table-responsive>.table-bordered>tbody>tr:first-child>td,
      .panel>.table-responsive>.table-bordered>tbody>tr:first-child>th {
        border-bottom: 0
      }

      .panel>.table-bordered>tbody>tr:last-child>td,
      .panel>.table-bordered>tbody>tr:last-child>th,
      .panel>.table-bordered>tfoot>tr:last-child>td,
      .panel>.table-bordered>tfoot>tr:last-child>th,
      .panel>.table-responsive>.table-bordered>tbody>tr:last-child>td,
      .panel>.table-responsive>.table-bordered>tbody>tr:last-child>th,
      .panel>.table-responsive>.table-bordered>tfoot>tr:last-child>td,
      .panel>.table-responsive>.table-bordered>tfoot>tr:last-child>th {
        border-bottom: 0
      }

      .panel>.table-responsive {
        border: 0;
        margin-bottom: 0
      }

      .panel-group {
        margin-bottom: 20px
      }

      .panel-group .panel {
        margin-bottom: 0;
        border-radius: 4px
      }

      .panel-group .panel+.panel {
        margin-top: 5px
      }

      .panel-group .panel-heading {
        border-bottom: 0
      }

      .panel-group .panel-heading+.panel-collapse>.panel-body,
      .panel-group .panel-heading+.panel-collapse>.list-group {
        border-top: 1px solid #ddd
      }

      .panel-group .panel-footer {
        border-top: 0
      }

      .panel-group .panel-footer+.panel-collapse .panel-body {
        border-bottom: 1px solid #ddd
      }

      .panel-default {
        border-color: #ddd
      }

      .panel-default>.panel-heading {
        color: #333333;
        background-color: #f5f5f5;
        border-color: #ddd
      }

      .panel-default>.panel-heading+.panel-collapse>.panel-body {
        border-top-color: #ddd
      }

      .panel-default>.panel-heading .badge {
        color: #f5f5f5;
        background-color: #333333
      }

      .panel-default>.panel-footer+.panel-collapse>.panel-body {
        border-bottom-color: #ddd
      }

      .panel-primary {
        border-color: #337ab7
      }

      .panel-primary>.panel-heading {
        color: #fff;
        background-color: #337ab7;
        border-color: #337ab7
      }

      .panel-primary>.panel-heading+.panel-collapse>.panel-body {
        border-top-color: #337ab7
      }

      .panel-primary>.panel-heading .badge {
        color: #337ab7;
        background-color: #fff
      }

      .panel-primary>.panel-footer+.panel-collapse>.panel-body {
        border-bottom-color: #337ab7
      }

      .panel-success {
        border-color: #d6e9c6
      }

      .panel-success>.panel-heading {
        color: #3c763d;
        background-color: #dff0d8;
        border-color: #d6e9c6
      }

      .panel-success>.panel-heading+.panel-collapse>.panel-body {
        border-top-color: #d6e9c6
      }

      .panel-success>.panel-heading .badge {
        color: #dff0d8;
        background-color: #3c763d
      }

      .panel-success>.panel-footer+.panel-collapse>.panel-body {
        border-bottom-color: #d6e9c6
      }

      .panel-info {
        border-color: #bce8f1
      }

      .panel-info>.panel-heading {
        color: #31708f;
        background-color: #d9edf7;
        border-color: #bce8f1
      }

      .panel-info>.panel-heading+.panel-collapse>.panel-body {
        border-top-color: #bce8f1
      }

      .panel-info>.panel-heading .badge {
        color: #d9edf7;
        background-color: #31708f
      }

      .panel-info>.panel-footer+.panel-collapse>.panel-body {
        border-bottom-color: #bce8f1
      }

      .panel-warning {
        border-color: #faebcc
      }

      .panel-warning>.panel-heading {
        color: #8a6d3b;
        background-color: #fcf8e3;
        border-color: #faebcc
      }

      .panel-warning>.panel-heading+.panel-collapse>.panel-body {
        border-top-color: #faebcc
      }

      .panel-warning>.panel-heading .badge {
        color: #fcf8e3;
        background-color: #8a6d3b
      }

      .panel-warning>.panel-footer+.panel-collapse>.panel-body {
        border-bottom-color: #faebcc
      }

      .panel-danger {
        border-color: #ebccd1
      }

      .panel-danger>.panel-heading {
        color: #a94442;
        background-color: #f2dede;
        border-color: #ebccd1
      }

      .panel-danger>.panel-heading+.panel-collapse>.panel-body {
        border-top-color: #ebccd1
      }

      .panel-danger>.panel-heading .badge {
        color: #f2dede;
        background-color: #a94442
      }

      .panel-danger>.panel-footer+.panel-collapse>.panel-body {
        border-bottom-color: #ebccd1
      }

      .embed-responsive {
        position: relative;
        display: block;
        height: 0;
        padding: 0;
        overflow: hidden
      }

      .embed-responsive .embed-responsive-item,
      .embed-responsive iframe,
      .embed-responsive embed,
      .embed-responsive object,
      .embed-responsive video {
        position: absolute;
        top: 0;
        left: 0;
        bottom: 0;
        height: 100%;
        width: 100%;
        border: 0;
        z-index: 1
      }

      .embed-responsive-16by9 {
        padding-bottom: 56.25%
      }

      .embed-responsive-4by3 {
        padding-bottom: 75%
      }

      .well {
        min-height: 20px;
        padding: 19px;
        margin-bottom: 20px;
        background-color: #f5f5f5;
        border: 1px solid #e3e3e3;
        border-radius: 4px;
        -webkit-box-shadow: inset 0 1px 1px rgba(0, 0, 0, .05);
        box-shadow: inset 0 1px 1px rgba(0, 0, 0, .05)
      }

      .well blockquote {
        border-color: #ddd;
        border-color: rgba(0, 0, 0, .15)
      }

      .well-lg {
        padding: 24px;
        border-radius: 6px
      }

      .well-sm {
        padding: 9px;
        border-radius: 3px
      }

      .close {
        float: right;
        font-size: 21px;
        font-weight: bold;
        line-height: 1;
        color: #000;
        text-shadow: 0 1px 0 #fff;
        opacity: .2;
        filter: alpha(opacity=20)
      }

      .close:hover,
      .close:focus {
        color: #000;
        text-decoration: none;
        cursor: pointer;
        opacity: .5;
        filter: alpha(opacity=50)
      }

      button.close {
        padding: 0;
        cursor: pointer;
        background: transparent;
        border: 0;
        -webkit-appearance: none
      }

      .modal-open {
        overflow: hidden
      }

      .modal {
        display: none;
        overflow: hidden;
        position: fixed;
        top: 0;
        right: 0;
        bottom: 0;
        left: 0;
        z-index: 1050;
        -webkit-overflow-scrolling: touch;
        outline: 0
      }

      .modal.fade .modal-dialog {
        -webkit-transform: translate(0, -25%);
        -ms-transform: translate(0, -25%);
        -o-transform: translate(0, -25%);
        transform: translate(0, -25%);
        -webkit-transition: -webkit-transform .3s ease-out;
        -moz-transition: -moz-transform .3s ease-out;
        -o-transition: -o-transform .3s ease-out;
        transition: transform .3s ease-out
      }

      .modal.in .modal-dialog {
        position: absolute;
        top: 50%;
        left: 50%;
        transform: translate(-50%, -50%) !important;
        z-index: 10000;
        max-width: 70% !important
      }

      .modal-open .modal {
        overflow-x: hidden;
        overflow-y: auto
      }

      .modal-dialog {
        position: relative;
        width: auto;
        margin: 10px
      }

      .modal-content {
        position: relative;
        background-color: #fff;
        border: 1px solid #999;
        border: 1px solid rgba(0, 0, 0, .2);
        border-radius: 6px;
        -webkit-box-shadow: 0 3px 9px rgba(0, 0, 0, .5);
        box-shadow: 0 3px 9px rgba(0, 0, 0, .5);
        background-clip: padding-box;
        outline: 0
      }

      .modal-backdrop {
        position: fixed;
        top: 0;
        right: 0;
        bottom: 0;
        left: 0;
        z-index: 1040;
        background-color: #000
      }

      .modal-backdrop.fade {
        opacity: 0;
        filter: alpha(opacity=0)
      }

      .modal-backdrop.in {
        opacity: .5;
        filter: alpha(opacity=50)
      }

      .modal-header {
        padding: 15px;
        border-bottom: 1px solid #e5e5e5
      }

      .modal-header:before,
      .modal-header:after {
        content: " ";
        display: table
      }

      .modal-header:after {
        clear: both
      }

      .modal-header .close {
        margin-top: -2px
      }

      .modal-title {
        margin: 0;
        line-height: 1.42857
      }

      .modal-body {
        position: relative;
        padding: 15px
      }

      */ .modal-footer {
        padding: 15px;
        text-align: right;
        border-top: 1px solid #e5e5e5
      }

      .modal-footer:before,
      .modal-footer:after {
        content: " ";
        display: table
      }

      .modal-footer:after {
        clear: both
      }

      .modal-footer .btn+.btn {
        margin-left: 5px;
        margin-bottom: 0
      }

      .modal-footer .btn-group .btn+.btn {
        margin-left: -1px
      }

      .modal-footer .btn-block+.btn-block {
        margin-left: 0
      }

      @media screen and (min-width:768px) {

        .carousel-control .glyphicon-chevron-left,
        .carousel-control .glyphicon-chevron-right,
        .carousel-control .icon-prev,
        .carousel-control .icon-next {
          width: 30px;
          height: 30px;
          margin-top: -10px;
          font-size: 30px
        }

        .carousel-control .glyphicon-chevron-left,
        .carousel-control .icon-prev {
          margin-left: -10px
        }

        .carousel-control .glyphicon-chevron-right,
        .carousel-control .icon-next {
          margin-right: -10px
        }

        .carousel-caption {
          left: 20%;
          right: 20%;
          padding-bottom: 30px
        }

        .carousel-indicators {
          bottom: 20px
        }
      }

      .clearfix:before,
      .clearfix:after {
        content: " ";
        display: table
      }

      .clearfix:after {
        clear: both
      }

      .center-block {
        display: block;
        margin-left: auto;
        margin-right: auto
      }

      .pull-right {
        float: right !important
      }

      .pull-left {
        float: left !important
      }

      .hide {
        display: none !important
      }

      .show {
        display: block !important
      }

      .container-fluid .invisible {
        /* visibility: hidden */
      }

      .text-hide {
        font: 0/0 a;
        color: transparent;
        text-shadow: none;
        background-color: transparent;
        border: 0
      }

      .hidden {
        display: none !important
      }

      .affix {
        position: fixed
      }

      @-ms-viewport {
        width: device-width
      }

      .visible-xs {
        display: none !important
      }

      .visible-sm {
        display: none !important
      }

      .visible-md {
        display: none !important
      }

      .visible-lg {
        display: none !important
      }

      .visible-xs-block,
      .visible-xs-inline,
      .visible-xs-inline-block,
      .visible-sm-block,
      .visible-sm-inline,
      .visible-sm-inline-block,
      .visible-md-block,
      .visible-md-inline,
      .visible-md-inline-block,
      .visible-lg-block,
      .visible-lg-inline,
      .visible-lg-inline-block {
        display: none !important
      }

      @media (max-width:767px) {
        .visible-xs {
          display: block !important
        }

        table.visible-xs {
          display: table !important
        }

        tr.visible-xs {
          display: table-row !important
        }

        th.visible-xs,
        td.visible-xs {
          display: table-cell !important
        }
      }

      @media (max-width:767px) {
        .visible-xs-block {
          display: block !important
        }
      }

      @media (max-width:767px) {
        .visible-xs-inline {
          display: inline !important
        }
      }

      @media (max-width:767px) {
        .visible-xs-inline-block {
          display: inline-block !important
        }
      }

      @media (min-width:768px) and (max-width:991px) {
        .visible-sm {
          display: block !important
        }

        table.visible-sm {
          display: table !important
        }

        tr.visible-sm {
          display: table-row !important
        }

        th.visible-sm,
        td.visible-sm {
          display: table-cell !important
        }
      }

      @media (min-width:768px) and (max-width:991px) {
        .visible-sm-block {
          display: block !important
        }
      }

      @media (min-width:768px) and (max-width:991px) {
        .visible-sm-inline {
          display: inline !important
        }
      }

      @media (min-width:768px) and (max-width:991px) {
        .visible-sm-inline-block {
          display: inline-block !important
        }
      }

      @media (min-width:992px) and (max-width:1199px) {
        .visible-md {
          display: block !important
        }

        table.visible-md {
          display: table !important
        }

        tr.visible-md {
          display: table-row !important
        }

        th.visible-md,
        td.visible-md {
          display: table-cell !important
        }
      }

      @media (min-width:992px) and (max-width:1199px) {
        .visible-md-block {
          display: block !important
        }
      }

      @media (min-width:992px) and (max-width:1199px) {
        .visible-md-inline {
          display: inline !important
        }
      }

      @media (min-width:992px) and (max-width:1199px) {
        .visible-md-inline-block {
          display: inline-block !important
        }
      }

      @media (min-width:1200px) {
        .visible-lg {
          display: block !important
        }

        table.visible-lg {
          display: table !important
        }

        tr.visible-lg {
          display: table-row !important
        }

        th.visible-lg,
        td.visible-lg {
          display: table-cell !important
        }
      }

      @media (min-width:1200px) {
        .visible-lg-block {
          display: block !important
        }
      }

      @media (min-width:1200px) {
        .visible-lg-inline {
          display: inline !important
        }
      }

      @media (min-width:1200px) {
        .visible-lg-inline-block {
          display: inline-block !important
        }
      }

      @media (max-width:767px) {
        .hidden-xs {
          display: none !important
        }
      }

      @media (min-width:768px) and (max-width:991px) {
        .hidden-sm {
          display: none !important
        }
      }

      @media (min-width:992px) and (max-width:1199px) {
        .hidden-md {
          display: none !important
        }
      }

      @media (min-width:1200px) {
        .hidden-lg {
          display: none !important
        }
      }

      .visible-print {
        display: none !important
      }

      @media print {
        .visible-print {
          display: block !important
        }

        table.visible-print {
          display: table !important
        }

        tr.visible-print {
          display: table-row !important
        }

        th.visible-print,
        td.visible-print {
          display: table-cell !important
        }
      }

      .visible-print-block {
        display: none !important
      }

      @media print {
        .visible-print-block {
          display: block !important
        }
      }

      .visible-print-inline {
        display: none !important
      }

      @media print {
        .visible-print-inline {
          display: inline !important
        }
      }

      .visible-print-inline-block {
        display: none !important
      }

      @media print {
        .visible-print-inline-block {
          display: inline-block !important
        }
      }

      @media print {
        .hidden-print {
          display: none !important
        }
      }

      a .use-fb-icon {
        fill: #fff;
        color: #fff
      }

      a .use-linkedin-icon {
        fill: #fff;
        color: #fff
      }

      a .use-youtube-icon {
        fill: #fff;
        color: #fff
      }

      a .use-twitter-icon {
        fill: #fff;
        color: #fff
      }

      .bg-gray2 {
        background-color: #ededed
      }

      .bg-gray7 {
        background-color: #e2e2e2
      }

      #menu_ban {
        display: none
      }

      #pictChatAllTime {
        height: 67px !important;
        width: 170px !important
      }

      footer {
        clear: both
      }

      footer .phone-image {
        margin-bottom: 20px;
        display: block;
        width: 100%;
        height: auto;
        min-height: 19px
      }

      footer .download-box {
        position: relative;
        margin-bottom: 20px
      }

      footer .download-box a {
        font-weight: bold;
        position: absolute;
        top: 50%;
        left: 70px;
        transform: translateY(-50%);
        display: inline-block;
        min-width: 130px;
        max-width: 200px;
        color: #333333;
        text-decoration: none
      }

      footer .download-box a:hover {
        color: #b3ce00
      }

      footer .download-box img {
        float: left;
        border: 3px solid #fff;
        -webkit-box-shadow: 4px 10px 16px rgba(0, 0, 0, .22);
        -moz-box-shadow: 4px 10px 16px rgba(0, 0, 0, .22);
        box-shadow: 4px 10px 16px rgba(0, 0, 0, .22);
        margin-right: 10px;
        width: 64px
      }

      footer .footer-col-1 {
        padding: 35px 20px
      }

      footer .footer-col-1 p.tel-footer {
        margin: 0
      }

      footer .footer-col-1 #list-network {
        padding: 0;
        overflow: hidden;
        border-top: 2px #494949 solid
      }

      footer .footer-col-1 #list-network li {
        list-style: none;
        padding: 0;
        margin: 0;
        display: block;
        background: #494949;
        text-align: center;
        float: left;
        border-right: 2px #fff solid
      }

      footer .footer-col-1 #list-network li a {
        line-height: 1;
        display: inline-block;
        width: 50px;
        height: 50px;
        line-height: 50px;
        text-decoration: none
      }

      footer .footer-col-1 #list-network li a .use-fb-icon {
        fill: #fff
      }

      footer .footer-col-1 #list-network li a .use-twitter-icon {
        fill: #fff
      }

      footer .footer-col-1 #list-network li a .use-youtube-icon {
        fill: #fff
      }

      footer .footer-col-1 a.lien_tarifs {
        display: block;
        text-transform: uppercase;
        font-weight: bold;
        font-size: 1.1rem;
        text-decoration: none
      }

      footer .footer-col-2 {
        padding: 35px 20px
      }

      footer .footer-col-2 .sitemap {
        width: 100%;
        font-weight: normal;
        text-align: left;
        background: #494949;
        font-size: 1.5rem;
        margin-bottom: 30px;
        margin-top: 10px;
        padding-left: 10px
      }

      footer .footer-col-2 .sitemap:hover {
        background: #494949;
        border: none
      }

      footer .footer-col-2 .sitemap .caret {
        border-bottom: 8px dashed;
        position: absolute;
        right: 15px;
        top: 20px
      }

      footer .footer-col-2 .sitemap-menu {
        padding: 15px 15px 0 15px;
        border: none;
        border-radius: 0;
        width: 100%;
        z-index: 10000
      }

      footer .footer-col-2 .sitemap-menu li {
        color: #494949;
        list-style: none;
        margin-bottom: 10px
      }

      footer .footer-col-2 .sitemap-menu li a {
        color: #494949;
        padding: 0;
        text-decoration: none !important
      }

      footer .footer-col-2 .sitemap-menu li a:hover {
        background: transparent
      }

      footer .footer-col-2 .sitemap-menu li ul {
        padding: 0
      }

      footer .footer-col-2 .sitemap-menu li ul li {
        margin-bottom: 0;
        padding: .2em 1em .2em .2em
      }

      footer .footer-col-2 .footer-menu {
        padding: 0;
        text-align: center
      }

      footer .footer-col-2 .footer-menu li {
        list-style: none;
        display: inline-block
      }

      footer .footer-col-2 .footer-menu li a {
        position: relative;
        padding-right: 10px;
        color: #494949;
        text-decoration: none
      }

      footer .footer-col-2 .footer-menu li:not(:last-child) a:after {
        content: "";
        display: inline;
        position: absolute;
        top: 0;
        right: 1px;
        background: #494949
      }

      footer .footer-col-2 .btn-primary:active,
      footer .footer-col-2 .btn-primary.active,
      footer .footer-col-2 .open>.btn-primary.dropdown-toggle {
        background: #494949
      }

      footer p.medium-txt {
        margin-top: 1em
      }

      .pre-footer {
        padding: 20px;
        background: #f8f8f8;
        z-index: 0
      }

      .pre-footer .default-txt,
      .pre-footer .tab-conatiner-wrapper .nav-tabs strong,
      .tab-conatiner-wrapper .nav-tabs .pre-footer strong,
      .pre-footer .tab-conatiner-wrapper .tab-content li.prod-list-tab,
      .tab-conatiner-wrapper .tab-content .pre-footer li.prod-list-tab,
      .pre-footer .tab-conatiner-wrapper .tab-content li.prod-list-tab strong,
      .tab-conatiner-wrapper .tab-content li.prod-list-tab .pre-footer strong,
      .pre-footer .mindset-wrapper .quote,
      .mindset-wrapper .pre-footer .quote,
      .pre-footer .product-en-bref .services .right-col .info,
      .product-en-bref .services .right-col .pre-footer .info,
      .pre-footer .product-en-bref .services .right-col .carousel p,
      .product-en-bref .services .right-col .carousel .pre-footer p,
      .pre-footer .product-en-bref .services .right-col .info-txt,
      .product-en-bref .services .right-col .pre-footer .info-txt,
      .pre-footer .product-en-bref .acc-create .btn,
      .product-en-bref .acc-create .pre-footer .btn,
      .pre-footer .product-en-bref .read-more .btn,
      .product-en-bref .read-more .pre-footer .btn,
      .pre-footer .product-offers p,
      .product-offers .pre-footer p,
      .pre-footer .product-offers .btn,
      .product-offers .pre-footer .btn,
      .pre-footer .produit-en-pratique .tab-conatiner-wrapper strong,
      .produit-en-pratique .tab-conatiner-wrapper .pre-footer strong,
      .pre-footer .product-detail-page .conditions .list li .list-txt,
      .product-detail-page .conditions .list li .pre-footer .list-txt,
      .pre-footer .product-detail-page .conditions .right-col .inner-right .info-txt,
      .product-detail-page .conditions .right-col .inner-right .pre-footer .info-txt,
      .pre-footer .product-detail-page .current-features .info-title,
      .product-detail-page .current-features .pre-footer .info-title,
      .pre-footer .product-detail-page .options .info-box p,
      .product-detail-page .options .info-box .pre-footer p,
      .pre-footer .product-detail-page .options .carousel p,
      .product-detail-page .options .carousel .pre-footer p,
      .pre-footer .product-detail-page .visa-box .info-txt p,
      .product-detail-page .visa-box .info-txt .pre-footer p,
      .pre-footer .product-detail-page .visa-box .tab-pane p.title,
      .product-detail-page .visa-box .tab-pane .pre-footer p.title,
      .pre-footer .souscription ul.list-prod li.prod-list-tab,
      .souscription ul.list-prod .pre-footer li.prod-list-tab,
      .pre-footer .souscription ul.list-prod li.prod-list-tab strong,
      .souscription ul.list-prod li.prod-list-tab .pre-footer strong,
      .pre-footer .souscription .tab-conatiner-wrapper strong,
      .souscription .tab-conatiner-wrapper .pre-footer strong {
        padding-bottom: 10px;
        margin: 0;
        font-weight: bold
      }

      .pre-footer .default-txt .logo-green,
      .pre-footer .tab-conatiner-wrapper .nav-tabs strong .logo-green,
      .tab-conatiner-wrapper .nav-tabs .pre-footer strong .logo-green,
      .pre-footer .tab-conatiner-wrapper .tab-content li.prod-list-tab .logo-green,
      .tab-conatiner-wrapper .tab-content .pre-footer li.prod-list-tab .logo-green,
      .tab-conatiner-wrapper .tab-content li.prod-list-tab .pre-footer strong .logo-green,
      .pre-footer .mindset-wrapper .quote .logo-green,
      .mindset-wrapper .pre-footer .quote .logo-green,
      .pre-footer .product-en-bref .services .right-col .info .logo-green,
      .product-en-bref .services .right-col .pre-footer .info .logo-green,
      .pre-footer .product-en-bref .services .right-col .carousel p .logo-green,
      .product-en-bref .services .right-col .carousel .pre-footer p .logo-green,
      .pre-footer .product-en-bref .services .right-col .info-txt .logo-green,
      .product-en-bref .services .right-col .pre-footer .info-txt .logo-green,
      .pre-footer .product-en-bref .acc-create .btn .logo-green,
      .product-en-bref .acc-create .pre-footer .btn .logo-green,
      .pre-footer .product-en-bref .read-more .btn .logo-green,
      .product-en-bref .read-more .pre-footer .btn .logo-green,
      .pre-footer .product-offers p .logo-green,
      .product-offers .pre-footer p .logo-green,
      .pre-footer .product-offers .btn .logo-green,
      .product-offers .pre-footer .btn .logo-green,
      .pre-footer .produit-en-pratique .tab-conatiner-wrapper strong .logo-green,
      .produit-en-pratique .tab-conatiner-wrapper .pre-footer strong .logo-green,
      .pre-footer .product-detail-page .conditions .list li .list-txt .logo-green,
      .product-detail-page .conditions .list li .pre-footer .list-txt .logo-green,
      .pre-footer .product-detail-page .conditions .right-col .inner-right .info-txt .logo-green,
      .product-detail-page .conditions .right-col .inner-right .pre-footer .info-txt .logo-green,
      .pre-footer .product-detail-page .current-features .info-title .logo-green,
      .product-detail-page .current-features .pre-footer .info-title .logo-green,
      .pre-footer .product-detail-page .options .info-box p .logo-green,
      .product-detail-page .options .info-box .pre-footer p .logo-green,
      .pre-footer .product-detail-page .options .carousel p .logo-green,
      .product-detail-page .options .carousel .pre-footer p .logo-green,
      .pre-footer .product-detail-page .visa-box .info-txt p .logo-green,
      .product-detail-page .visa-box .info-txt .pre-footer p .logo-green,
      .pre-footer .product-detail-page .visa-box .tab-pane p.title .logo-green,
      .product-detail-page .visa-box .tab-pane .pre-footer p.title .logo-green,
      .pre-footer .souscription ul.list-prod li.prod-list-tab .logo-green,
      .souscription ul.list-prod .pre-footer li.prod-list-tab .logo-green,
      .souscription ul.list-prod li.prod-list-tab .pre-footer strong .logo-green,
      .pre-footer .souscription .tab-conatiner-wrapper strong .logo-green,
      .souscription .tab-conatiner-wrapper .pre-footer strong .logo-green {
        color: #ccec00
      }

      .pre-footer .txt-footer {
        padding: 0;
        margin: 0;
        color: #656565;
        padding-top: 10px
      }

      .pre-footer .txt-footer a {
        color: #656565;
        text-decoration: underline
      }

      .pre-footer .txt-footer a:hover {
        color: #bad606
      }

      .pre-footer .txt-footer a:focus {
        color: #656565
      }

      #toolbox_mobile #toolbox_mobile_btn_open {
        position: fixed;
        opacity: .8;
        display: block;
        bottom: 10px;
        right: 10px;
        z-index: 2;
        background-color: #717171;
        color: #f8f8f8;
        width: 45px;
        height: 45px;
        line-height: 40px;
        font-size: 2.4em;
        text-align: center;
        -webkit-border-radius: 23px;
        -moz-border-radius: 23px;
        border-radius: 23px;
        cursor: pointer
      }

      #toolbox_mobile #toolbox_mobile_btn_close {
        position: fixed;
        display: block;
        bottom: 10px;
        right: 10px;
        z-index: 2;
        background-color: #f8f8f8;
        color: #333333;
        width: 45px;
        height: 45px;
        text-align: center;
        line-height: 45px;
        -webkit-border-radius: 23px;
        -moz-border-radius: 23px;
        border-radius: 23px;
        cursor: pointer
      }

      #toolbox_mobile #toolbox_mobile_content {
        display: none
      }

      #toolbox_mobile #toolbox_mobile_content .cross_icon {
        margin: 0;
        cursor: pointer
      }

      #toolbox_mobile #toolbox_mobile_content .cross_icon::before,
      #toolbox_mobile #toolbox_mobile_content .cross_icon::after {
        background-color: #333333;
        position: absolute;
        display: block;
        content: '';
        transform: rotate(45deg)
      }

      #toolbox_mobile #toolbox_mobile_content .cross_icon::before {
        width: 25px;
        height: 2px;
        top: 22px;
        left: 10px
      }

      #toolbox_mobile #toolbox_mobile_content .cross_icon::after {
        width: 2px;
        height: 25px;
        left: 22px;
        top: 10px
      }

      #toolbox_mobile #toolbox_mobile_content #toolbox_mobile_content_choice {
        position: fixed;
        text-align: right;
        bottom: 55px;
        right: 10px;
        z-index: 2
      }

      #toolbox_mobile #toolbox_mobile_content #toolbox_mobile_content_choice .toolbox_mobile_menu {
        margin-bottom: 12px
      }

      #toolbox_mobile #toolbox_mobile_content #toolbox_mobile_content_choice .toolbox_mobile_menu a {
        text-decoration: none
      }

      #toolbox_mobile #toolbox_mobile_content #toolbox_mobile_content_choice .toolbox_mobile_menu a span,
      #toolbox_mobile #toolbox_mobile_content #toolbox_mobile_content_choice .toolbox_mobile_menu a p {
        display: inline-block;
        background-color: #f8f8f8;
        color: #333333 !important;
        fill: #333333 !important;
        text-align: center
      }

      #toolbox_mobile #toolbox_mobile_content #toolbox_mobile_content_choice .toolbox_mobile_menu a p {
        font-weight: bold;
        padding: 2px 10px;
        margin-right: 5px;
        -webkit-border-radius: 5px;
        -moz-border-radius: 5px;
        border-radius: 5px
      }

      #toolbox_mobile #toolbox_mobile_content #toolbox_mobile_content_choice .toolbox_mobile_menu a span {
        width: 35px;
        line-height: 35px;
        height: 35px;
        font-size: 1.1em;
        -webkit-border-radius: 18px;
        -moz-border-radius: 18px;
        border-radius: 18px;
        cursor: pointer;
        position: relative
      }

      #toolbox_mobile #toolbox_mobile_content #toolbox_mobile_content_choice .toolbox_mobile_menu a span span.info-icon.info_mobile {
        background: #b3ce00;
        color: #000 !important;
        -webkit-border-radius: 50%;
        -moz-border-radius: 50%;
        border-radius: 50%;
        position: absolute;
        bottom: 0;
        left: inherit;
        right: -3px;
        bottom: 5px;
        -webkit-transform: translateX(-50%);
        -moz-transform: translateX(-50%);
        -ms-transform: translateX(-50%);
        -o-transform: translateX(-50%);
        transform: translateX(-50%);
        width: 12px;
        height: 12px;
        line-height: 12px;
        font-size: 9px;
        font-weight: bold;
        margin-left: 10px
      }

      #toolbox_mobile #toolbox_mobile_content #toolbox_mobile_content_choice .toolbox_mobile_menu a span span.info-icon.info_mobile.etoile {
        line-height: 15px
      }

      #toolbox_mobile #toolbox_mobile_content #toolbox_mobile_content_choice .toolbox_mobile_menu a:hover span {
        color: #b3ce00 !important;
        fill: #b3ce00 !important
      }

      #toolbox_mobile #toolbox_mobile_content #toolbox_mobile_content_choice .toolbox_mobile_menu a:hover span span.info-icon.info_mobile {
        background: #b3ce00;
        color: #000 !important;
        -webkit-border-radius: 50%;
        -moz-border-radius: 50%;
        border-radius: 50%;
        position: absolute;
        bottom: 0;
        left: inherit;
        right: -3px;
        bottom: 5px;
        -webkit-transform: translateX(-50%);
        -moz-transform: translateX(-50%);
        -ms-transform: translateX(-50%);
        -o-transform: translateX(-50%);
        transform: translateX(-50%);
        width: 12px;
        height: 12px;
        line-height: 12px;
        font-size: 9px;
        font-weight: bold;
        margin-left: 10px
      }

      #toolbox_mobile #toolbox_mobile_content #toolbox_mobile_content_choice .toolbox_mobile_menu a:hover span span.info-icon.info_mobile.etoile {
        line-height: 15px
      }

      #toolbox_mobile #icon_toolbox_mobile_btn_open span#info_toolbox_notif {
        bottom: 7px;
        right: -1px;
        width: 14px;
        height: 14px;
        font-family: "Helvetica Neue", Helvetica, Arial, sans-serif
      }

      #toolbox_mobile .overlay-toolbox_mobile {
        display: block;
        width: 100%;
        position: fixed;
        background: #000;
        opacity: .4;
        height: 100%;
        z-index: 2;
        left: 0
      }

      #toolbox_mobile #toolbox_mobile_notif {
        display: block
      }

      #toolbox_mobile #toolbox_mobile_notif #toolbox_mobile_content_notif {
        position: fixed;
        text-align: right;
        bottom: 55px;
        right: 10px;
        z-index: 2
      }

      #toolbox_mobile #toolbox_mobile_notif #toolbox_mobile_content_notif .toolbox_mobile_menu a {
        display: none
      }

      #toolbox_mobile #toolbox_mobile_notif #toolbox_mobile_content_notif .toolbox_mobile_menu a .notif_toolbox_mobile {
        position: fixed;
        left: 20px;
        width: calc(100% - 40px)
      }

      #toolbox_mobile #toolbox_mobile_notif #toolbox_mobile_content_notif .toolbox_mobile_menu a .notif_toolbox_mobile .tooltip-inner {
        background-color: #b3ce00;
        position: relative;
        color: #fff;
        border: 1px solid #b3ce00;
        padding: 14px 20px;
        font-size: 1.3rem;
        border-radius: 0;
        max-width: 100%
      }

      #toolbox_mobile #toolbox_mobile_notif #toolbox_mobile_content_notif .toolbox_mobile_menu a .notif_toolbox_mobile .tooltip-inner p {
        padding: 0;
        -webkit-border-radius: 0;
        -moz-border-radius: 0;
        border-radius: 0;
        display: block;
        background-color: inherit;
        color: #333333 !important;
        fill: #333333 !important;
        text-align: left;
        font-weight: normal;
        margin: 0
      }

      #toolbox_mobile #toolbox_mobile_notif #toolbox_mobile_content_notif .toolbox_mobile_menu a .notif_toolbox_mobile .tooltip-inner p.link {
        color: #fff !important;
        text-transform: uppercase;
        font-size: .8em;
        font-weight: bold;
        margin-top: 10px
      }

      #toolbox_mobile #toolbox_mobile_notif #toolbox_mobile_content_notif .toolbox_mobile_menu a .notif_toolbox_mobile .tooltip-inner span.close-notif {
        cursor: pointer;
        position: absolute;
        top: 0;
        right: 0;
        width: 25px;
        height: 30px;
        display: inline-block;
        background-color: inherit;
        color: inherit !important;
        fill: inherit !important;
        text-align: center
      }

      #toolbox_mobile #toolbox_mobile_notif #toolbox_mobile_content_notif .toolbox_mobile_menu a .notif_toolbox_mobile .tooltip-inner span.close-notif::before {
        width: 15px;
        top: 11px;
        left: 6px
      }

      #toolbox_mobile #toolbox_mobile_notif #toolbox_mobile_content_notif .toolbox_mobile_menu a .notif_toolbox_mobile .tooltip-inner span.close-notif::after {
        height: 15px;
        left: 12px;
        top: 5px
      }

      .standard #toolbox_mobile #toolbox_mobile_notif #toolbox_mobile_content_notif .toolbox_mobile_menu a .notif_toolbox_mobile {
        top: 70px
      }

      .level3 #toolbox_mobile #toolbox_mobile_notif #toolbox_mobile_content_notif .toolbox_mobile_menu a .notif_toolbox_mobile {
        top: 120px
      }

      .produit #toolbox_mobile #toolbox_mobile_notif #toolbox_mobile_content_notif .toolbox_mobile_menu a .notif_toolbox_mobile {
        top: 170px
      }

      .text-title-col {
        padding: 25px 20px 0
      }

      @media only screen and (min-width:767px) {

        .small-txt,
        .slide-up-section .close-slide,
        .tab-conatiner-wrapper .nav-tabs h3 a span,
        .tab-conatiner-wrapper .details-info,
        .mindset-wrapper .autor-name,
        .mosaic-wrapper .roll-over-img .mindset-wrapper .autor-name,
        .product-en-bref .services .right-col .carousel .item ul li,
        .produit-en-pratique .deposit .info-txt,
        .produit-en-pratique .tab-conatiner-wrapper .nav-tabs h3 a,
        .produit-en-pratique .tab-conatiner-wrapper .panel-group .panel-heading h3,
        .produit-en-pratique .tab-conatiner-wrapper .panel-group .panel-heading a,
        .produit-en-pratique .downloads a,
        .produit-en-pratique .downloads p,
        .product-detail-page .conditions .deposit .info-txt,
        .product-detail-page .conditions .notice .info-txt,
        .product-detail-page .tab-conatiner-wrapper .nav-tabs h3 a,
        .product-detail-page .tab-conatiner-wrapper .panel-group .panel-heading h3,
        .product-detail-page .tab-conatiner-wrapper .panel-group .panel-heading a,
        .product-detail-page .downloads a,
        .product-detail-page .downloads p,
        .product-detail-page .options .carousel ul li,
        .product-detail-page .visa-box .tab-pane p,
        .product-detail-page .visa-box .notice p,
        .souscription .tab-conatiner-wrapper .nav-tabs h3 a,
        .souscription .tab-conatiner-wrapper .panel-group .panel-heading h3,
        .souscription .tab-conatiner-wrapper .panel-group .panel-heading a {
          font-size: 1.4rem
        }

        .default-txt,
        .tab-conatiner-wrapper .nav-tabs strong,
        .tab-conatiner-wrapper .tab-content li.prod-list-tab,
        .tab-conatiner-wrapper .tab-content li.prod-list-tab strong,
        .mindset-wrapper .quote,
        .product-en-bref .services .right-col .info,
        .product-en-bref .services .right-col .carousel p,
        .product-en-bref .services .right-col .info-txt,
        .product-en-bref .acc-create .btn,
        .product-en-bref .read-more .btn,
        .product-offers p,
        .product-offers .btn,
        .produit-en-pratique .tab-conatiner-wrapper strong,
        .product-detail-page .conditions .list li .list-txt,
        .product-detail-page .conditions .right-col .inner-right .info-txt,
        .product-detail-page .current-features .info-title,
        .product-detail-page .options .info-box p,
        .product-detail-page .options .carousel p,
        .product-detail-page .visa-box .info-txt p,
        .product-detail-page .visa-box .tab-pane p.title,
        .souscription ul.list-prod li.prod-list-tab,
        .souscription ul.list-prod li.prod-list-tab strong,
        .souscription .tab-conatiner-wrapper strong {
          font-size: 1.6rem
        }

        .medium-txt,
        .tab-conatiner-wrapper .nav-tabs h3 a,
        .mosaic-wrapper .bg-gray1 h2,
        .product-en-bref .services .right-col ul.list li,
        .product-en-bref .acc-create p,
        .product-en-bref .read-more p,
        .produit-en-pratique .deposit .title,
        .produit-en-pratique .downloads .title,
        .product-detail-page .conditions .deposit .title,
        .product-detail-page .conditions .right-col .title,
        .product-detail-page .conditions .right-col .inner-right ul li,
        .product-detail-page .downloads .title,
        .product-detail-page .convinced .title,
        .product-detail-page .options .info-box h3,
        .product-detail-page .visa-box h3 {
          font-size: 2.2rem
        }

        .extra-medium-txt,
        .tab-conatiner-wrapper strong,
        .tab-conatiner-wrapper h2,
        .tab-conatiner-wrapper .per-month span,
        .mindset-wrapper .quote:before,
        .mindset-wrapper .quote:after,
        .produit-en-pratique .deposit .title span,
        .product-detail-page .conditions .deposit .title span {
          font-size: 3rem
        }

        .semi-large-txt {
          font-size: 4.4rem
        }

        .large-txt,
        .jumbotron p,
        .tab-conatiner-wrapper h1,
        .tab-conatiner-wrapper .per-month,
        .product-detail-page .titles span,
        .bienvenue-nous-page h2.title span {
          font-size: 5rem
        }

        .extra-large-txt,
        .jumbotron .heading-page {
          font-size: 8rem
        }
      }

      @media only screen and (min-width:1280px) {

        .small-txt,
        .slide-up-section .close-slide,
        .tab-conatiner-wrapper .nav-tabs h3 a span,
        .tab-conatiner-wrapper .details-info,
        .mindset-wrapper .autor-name,
        .mosaic-wrapper .roll-over-img .mindset-wrapper .autor-name,
        .product-en-bref .services .right-col .carousel .item ul li,
        .produit-en-pratique .deposit .info-txt,
        .produit-en-pratique .tab-conatiner-wrapper .nav-tabs h3 a,
        .produit-en-pratique .tab-conatiner-wrapper .panel-group .panel-heading h3,
        .produit-en-pratique .tab-conatiner-wrapper .panel-group .panel-heading a,
        .produit-en-pratique .downloads a,
        .produit-en-pratique .downloads p,
        .product-detail-page .conditions .deposit .info-txt,
        .product-detail-page .conditions .notice .info-txt,
        .product-detail-page .tab-conatiner-wrapper .nav-tabs h3 a,
        .product-detail-page .tab-conatiner-wrapper .panel-group .panel-heading h3,
        .product-detail-page .tab-conatiner-wrapper .panel-group .panel-heading a,
        .product-detail-page .downloads a,
        .product-detail-page .downloads p,
        .product-detail-page .options .carousel ul li,
        .product-detail-page .visa-box .tab-pane p,
        .product-detail-page .visa-box .notice p,
        .souscription .tab-conatiner-wrapper .nav-tabs h3 a,
        .souscription .tab-conatiner-wrapper .panel-group .panel-heading h3,
        .souscription .tab-conatiner-wrapper .panel-group .panel-heading a {
          font-size: 1.4rem
        }

        .default-txt,
        .tab-conatiner-wrapper .nav-tabs strong,
        .tab-conatiner-wrapper .tab-content li.prod-list-tab,
        .tab-conatiner-wrapper .tab-content li.prod-list-tab strong,
        .mindset-wrapper .quote,
        .product-en-bref .services .right-col .info,
        .product-en-bref .services .right-col .carousel p,
        .product-en-bref .services .right-col .info-txt,
        .product-en-bref .acc-create .btn,
        .product-en-bref .read-more .btn,
        .product-offers p,
        .product-offers .btn,
        .produit-en-pratique .tab-conatiner-wrapper strong,
        .product-detail-page .conditions .list li .list-txt,
        .product-detail-page .conditions .right-col .inner-right .info-txt,
        .product-detail-page .current-features .info-title,
        .product-detail-page .options .info-box p,
        .product-detail-page .options .carousel p,
        .product-detail-page .visa-box .info-txt p,
        .product-detail-page .visa-box .tab-pane p.title,
        .souscription ul.list-prod li.prod-list-tab,
        .souscription ul.list-prod li.prod-list-tab strong,
        .souscription .tab-conatiner-wrapper strong {
          font-size: 1.6rem
        }

        .medium-txt,
        .tab-conatiner-wrapper .nav-tabs h3 a,
        .mosaic-wrapper .bg-gray1 h2,
        .product-en-bref .services .right-col ul.list li,
        .product-en-bref .acc-create p,
        .product-en-bref .read-more p,
        .produit-en-pratique .deposit .title,
        .produit-en-pratique .downloads .title,
        .product-detail-page .conditions .deposit .title,
        .product-detail-page .conditions .right-col .title,
        .product-detail-page .conditions .right-col .inner-right ul li,
        .product-detail-page .downloads .title,
        .product-detail-page .convinced .title,
        .product-detail-page .options .info-box h3,
        .product-detail-page .visa-box h3 {
          font-size: 2.2rem
        }

        .extra-medium-txt,
        .tab-conatiner-wrapper strong,
        .tab-conatiner-wrapper h2,
        .tab-conatiner-wrapper .per-month span,
        .mindset-wrapper .quote:before,
        .mindset-wrapper .quote:after,
        .produit-en-pratique .deposit .title span,
        .product-detail-page .conditions .deposit .title span {
          font-size: 3.6rem
        }

        .semi-large-txt {
          font-size: 5.4rem
        }

        .large-txt,
        .jumbotron p,
        .tab-conatiner-wrapper h1,
        .tab-conatiner-wrapper .per-month,
        .product-detail-page .titles span,
        .bienvenue-nous-page h2.title span {
          font-size: 6rem
        }

        .extra-large-txt,
        .jumbotron .heading-page {
          font-size: 9rem
        }
      }

      @media only screen and (min-width:1440px) {
        html {
          font-size: 11px
        }
      }

      @media only screen and (min-width:1600px) {
        html {
          font-size: 12px
        }
      }

      @media only screen and (min-width:1800px) {
        html {
          font-size: 13px
        }
      }

      @media only screen and (min-width:1920px) {
        html {
          font-size: 14px
        }
      }

      @media only screen and (min-width:768px) {
        footer {
          height: 76%
        }

        footer .txt-footer {
          padding: 50px 30px;
          background: #f8f8f8;
          margin: 0
        }

        footer .footer-col-1 {
          position: static;
          padding: 35px
        }

        footer .footer-col-1 .container-network-footer {
          bottom: 15px
        }

        footer .footer-col-1 .container-network-footer #list-network {
          margin: 0
        }

        footer .footer-col-1 .container-network-footer #list-network li {
          background: none
        }

        footer .footer-col-1 .container-network-footer #list-network li a {
          position: relative;
          -webkit-transform: translate3d(0, 0, 0);
          -moz-transform: translate3d(0, 0, 0);
          -ms-transform: translate3d(0, 0, 0);
          -o-transform: translate3d(0, 0, 0);
          transform: translate3d(0, 0, 0);
          background: transparent
        }

        footer .footer-col-1 .container-network-footer #list-network li a:before {
          display: block;
          position: absolute;
          top: 0;
          left: 0;
          width: 100%;
          height: 100%;
          background: #232323;
          content: '';
          z-index: -2
        }

        footer .footer-col-1 .container-network-footer #list-network li a:after {
          display: block;
          position: absolute;
          top: 0;
          left: 0;
          width: 100%;
          height: 100%;
          background: #494949;
          content: '';
          z-index: -1;
          opacity: 0;
          -moz-transform: scaleX(0);
          -o-transform: scaleX(0);
          -webkit-transform: scaleX(0);
          transform: scaleX(0);
          -moz-transform-origin: 0 0;
          -o-transform-origin: 0 0;
          -webkit-transform-origin: 0 0;
          transform-origin: 0 0;
          -moz-transition: transform .4s cubic-bezier(.77, 0, .175, 1), opacity .05s linear .4s;
          -o-transition: transform .4s cubic-bezier(.77, 0, .175, 1), opacity .05s linear .4s;
          -webkit-transition: transform .4s cubic-bezier(.77, 0, .175, 1), opacity .05s linear;
          transition: transform .4s cubic-bezier(.77, 0, .175, 1), opacity .05s linear .4s
        }

        footer .footer-col-1 .container-network-footer #list-network li a:hover:after {
          width: 100%;
          opacity: 1;
          -moz-transform: scaleX(1);
          -o-transform: scaleX(1);
          -webkit-transform: scaleX(1);
          transform: scaleX(1);
          -moz-transition-delay: 0s;
          -o-transition-delay: 0s;
          -webkit-transition-delay: 0s;
          transition-delay: 0s
        }

        footer .footer-col-2 {
          padding: 35px
        }

        footer .footer-col-2 .sitemap-menu {
          display: block;
          position: static;
          width: 100%;
          background: transparent;
          box-shadow: none;
          padding: 0;
          margin-bottom: 20px
        }

        footer .footer-col-2 .sitemap-menu li {
          font-weight: bold;
          margin-bottom: 30px
        }

        footer .footer-col-2 .sitemap-menu li:nth-child(3) {
          clear: both
        }

        footer .footer-col-2 .sitemap-menu li:nth-child(3) li {
          clear: none
        }

        footer .footer-col-2 .sitemap-menu li:nth-child(5) {
          clear: both
        }

        footer .footer-col-2 .sitemap-menu li:nth-child(5) li {
          clear: none
        }

        footer .footer-col-2 .sitemap-menu li a,
        footer .footer-col-2 .sitemap-menu li strong {
          padding: 0;
          color: #000
        }

        footer .footer-col-2 .sitemap-menu li ul {
          padding: 0
        }

        footer .footer-col-2 .sitemap-menu li ul li {
          margin: 0
        }

        footer .footer-col-2 .sitemap-menu li ul li a {
          color: #494949
        }

        footer .footer-col-2 .sitemap-menu li ul li a:hover {
          color: #232323
        }

        footer .footer-col-2 .footer-menu {
          text-align: left;
          border-top: solid 1px #cbcbcb;
          clear: both;
          padding-top: 30px
        }

        footer .footer-col-2 .footer-menu li a {
          color: #494949
        }

        footer .footer-col-2 .footer-menu li a:hover {
          color: #232323
        }

        footer .footer-col-2 .footer-menu li:first-child a {
          padding-left: 0
        }

        footer .footer-col-2 .footer-menu li:last-child a {
          padding-right: 0
        }
      }

      @media only screen and (min-width:992px) {
        footer {
          z-index: 0;
          position: relative;
          overflow: hidden
        }

        footer .footer-col-1 .container-network-footer {
          transform: none
        }

        footer .footer-col-1 #list-network #list-network li a .use-fb-icon {
          position: relative;
          top: 3px
        }

        footer .footer-col-2 .sitemap-menu {
          display: block;
          position: static;
          width: 100%;
          background: transparent;
          box-shadow: none
        }

        footer .footer-col-2 .sitemap-menu li:nth-child(3) {
          clear: none
        }

        footer .footer-col-2 .sitemap-menu li:nth-child(4) {
          clear: both
        }

        footer .footer-col-2 .sitemap-menu li:nth-child(4) li {
          clear: none
        }

        footer .footer-col-2 .sitemap-menu li:nth-child(5) {
          clear: none
        }
      }

      .home .home-mosaic .img-text-2-col:first-child .text-title-col {
        padding-top: 0
      }

      .contacts-wrapper .text-title-col {
        padding-top: 130px
      }

      .contacts-wrapper .green-block-container {
        padding-right: 30px;
        margin-top: 0
      }

      .contacts-wrapper .green-block-container .bg-green {
        width: 100%
      }

      .contacts-wrapper .bg-green {
        padding: 40px 30px
      }

      .contacts-wrapper .small-txt,
      .contacts-wrapper .slide-up-section .close-slide,
      .slide-up-section .contacts-wrapper .close-slide,
      .contacts-wrapper .tab-conatiner-wrapper .nav-tabs h3 a span,
      .tab-conatiner-wrapper .nav-tabs h3 a .contacts-wrapper span,
      .contacts-wrapper .tab-conatiner-wrapper .details-info,
      .tab-conatiner-wrapper .contacts-wrapper .details-info,
      .contacts-wrapper .mindset-wrapper .autor-name,
      .mindset-wrapper .contacts-wrapper .autor-name,
      .contacts-wrapper .mosaic-wrapper .roll-over-img .mindset-wrapper .autor-name,
      .mosaic-wrapper .roll-over-img .mindset-wrapper .contacts-wrapper .autor-name,
      .contacts-wrapper .product-en-bref .services .right-col .carousel .item ul li,
      .product-en-bref .services .right-col .carousel .item ul .contacts-wrapper li,
      .contacts-wrapper .produit-en-pratique .deposit .info-txt,
      .produit-en-pratique .deposit .contacts-wrapper .info-txt,
      .contacts-wrapper .produit-en-pratique .tab-conatiner-wrapper .nav-tabs h3 a,
      .produit-en-pratique .tab-conatiner-wrapper .nav-tabs h3 .contacts-wrapper a,
      .contacts-wrapper .produit-en-pratique .tab-conatiner-wrapper .panel-group .panel-heading h3,
      .produit-en-pratique .tab-conatiner-wrapper .panel-group .panel-heading .contacts-wrapper h3,
      .contacts-wrapper .produit-en-pratique .tab-conatiner-wrapper .panel-group .panel-heading a,
      .produit-en-pratique .tab-conatiner-wrapper .panel-group .panel-heading .contacts-wrapper a,
      .contacts-wrapper .produit-en-pratique .downloads a,
      .produit-en-pratique .downloads .contacts-wrapper a,
      .contacts-wrapper .produit-en-pratique .downloads p,
      .produit-en-pratique .downloads .contacts-wrapper p,
      .contacts-wrapper .product-detail-page .conditions .deposit .info-txt,
      .product-detail-page .conditions .deposit .contacts-wrapper .info-txt,
      .contacts-wrapper .product-detail-page .conditions .notice .info-txt,
      .product-detail-page .conditions .notice .contacts-wrapper .info-txt,
      .contacts-wrapper .product-detail-page .tab-conatiner-wrapper .nav-tabs h3 a,
      .product-detail-page .tab-conatiner-wrapper .nav-tabs h3 .contacts-wrapper a,
      .contacts-wrapper .product-detail-page .tab-conatiner-wrapper .panel-group .panel-heading h3,
      .product-detail-page .tab-conatiner-wrapper .panel-group .panel-heading .contacts-wrapper h3,
      .contacts-wrapper .product-detail-page .tab-conatiner-wrapper .panel-group .panel-heading a,
      .product-detail-page .tab-conatiner-wrapper .panel-group .panel-heading .contacts-wrapper a,
      .contacts-wrapper .product-detail-page .downloads a,
      .product-detail-page .downloads .contacts-wrapper a,
      .contacts-wrapper .product-detail-page .downloads p,
      .product-detail-page .downloads .contacts-wrapper p,
      .contacts-wrapper .product-detail-page .options .carousel ul li,
      .product-detail-page .options .carousel ul .contacts-wrapper li,
      .contacts-wrapper .product-detail-page .visa-box .tab-pane p,
      .product-detail-page .visa-box .tab-pane .contacts-wrapper p,
      .contacts-wrapper .product-detail-page .visa-box .notice p,
      .product-detail-page .visa-box .notice .contacts-wrapper p,
      .contacts-wrapper .souscription .tab-conatiner-wrapper .nav-tabs h3 a,
      .souscription .tab-conatiner-wrapper .nav-tabs h3 .contacts-wrapper a,
      .contacts-wrapper .souscription .tab-conatiner-wrapper .panel-group .panel-heading h3,
      .souscription .tab-conatiner-wrapper .panel-group .panel-heading .contacts-wrapper h3,
      .contacts-wrapper .souscription .tab-conatiner-wrapper .panel-group .panel-heading a,
      .souscription .tab-conatiner-wrapper .panel-group .panel-heading .contacts-wrapper a {
        line-height: 1.7
      }

      .text-title-col {
        padding: 45px 25px 0 35px
      }

      @media only screen and (min-width:1280px) {
        .home-v2-wrapper .animate-elements-end {
          width: 80%
        }

        .contacts-wrapper .text-title-col {
          padding-right: 80px
        }

        .text-title-col {
          padding: 45px 25px 0 50px
        }
      }

      @media only screen and (min-width :1280px) {
        footer .footer-col-1 {
          padding: 50px
        }

        .container-network-footer {
          left: 50px
        }

        .footer-col-2 {
          padding: 50px
        }

        .col-xs-12.col-sm-6.text-title-col .header-lined-bel.extra-medium-txt,
        .jumbotron .extra-medium-txt,
        .picto-article-3col h1 .extra-medium-txt,
        .col-xs-12.col-sm-12.pad-10-30.border-solid-wrap.no-border-bottom.no-padding-bottom .extra-medium-txt,
        .title-holder .large-txt,
        .title-holder .extra-medium-txt,
        .extra-medium-txt {
          font-size: 3rem
        }

        .tab-conatiner-wrapper h2,
        .mosaic-wrapper .category-wrapper h2,
        .mosaic-wrapper .category-wrapper h3 {
          font-size: 2.5rem
        }

        .jumbotron p,
        .tab-conatiner-wrapper h1,
        .col-xs-12.col-sm-12.pad-10-30.border-solid-wrap.no-border-bottom.no-padding-bottom h4,
        .picto-article-3col h1 .large-txt,
        h2 .large-txt {
          font-size: 4rem
        }

        .tab-conatiner-wrapper .per-month,
        h1 .large-txt {
          font-size: 5rem
        }

        .extra-large-txt,
        .jumbotron .heading-page {
          font-size: 6rem
        }
      }

      footer button.dropdown-toggle {
        border: none;
        color: #ffffff;
        height: 41px;
        position: relative
      }

      footer .footer-col-2 .sitemap .caret {
        border-bottom: 8px dashed;
        position: absolute;
        right: 15px;
        top: 20px;
        display: inline-block;
        width: 0;
        height: 0;
        margin-left: 2px;
        vertical-align: middle;
        border-top: 4px dashed;
        border-top: 4px solid \9;
        border-right: 4px solid transparent;
        border-left: 4px solid transparent;
        border-top: 0;
        content: ""
      }

      .text-16 {
        font-size: 16px
      }

      .white {
        color: #fff
      }

      .white strong {
        font-weight: 700
      }

      .yellow {
        color: #fff600
      }

      #footerBaz>div:nth-child(1)>p:nth-child(1) {
        padding: 1em 0
      }

      #footerBaz .titre.medium-txt.yellow {
        font-weight: bold;
        margin: 1em 0 .5em
      }

      #footerBaz>div>div>p.produits:nth-child(2) {
        color: #c1c1c1;
        border-top: 1px solid;
        border-bottom: 1px solid;
        padding: .5em 1em
      }

      #footerBaz>div>div>p.produits a {
        color: #c1c1c1
      }

      #footerBaz>div>div>p.produits a:hover {
        color: #bad606
      }

      #footerBaz>div>div>p.produits {
        border-top: 0;
        color: #c1c1c1;
        border-bottom: 1px solid;
        padding: .5em 1em
      }

      #footerBaz>div>div>p.produits a {
        text-decoration: none
      }

      #footerBaz .deuxiemeLigne {
        margin-top: 2em
      }

      .footer-menu li {
        display: inline
      }

      .footer-menu li a {
        text-decoration: none
      }

      .footer-menu.text-center {
        width: 80%;
        color: grey;
        padding: 0 1em;
        margin: 1.5% 10%
      }

      #footerAplli {
        padding: 3em 0;
        background-color: #232323
      }

      #footerAplli .medium-txt {
        font-size: 1.6em
      }

      .applimobile a {
        text-decoration: none
      }

      #list-network a {
        text-decoration: none
      }

      #list-network li {
        display: inline-block;
        padding: .1em .3em;
        border-radius: 50%;
        margin-right: 0em
      }

      #list-network a .use-youtube-icon,
      #list-network a .use-fb-icon,
      #list-network a .use-twitter-icon {
        fill: #000;
        color: #fff;
        font-size: 1.5em
      }

      #Avis-C {
        z-index: 1000
      }

      #footer\ bg-white {
        background: #FFF
      }

      #footer\ bg-white .row {
        padding: 1em 0 2em
      }

      .footDrapeau {
        border: 1px solid #333
      }

      .footDrapeau,
      .footCm {
        width: 105px;
        margin-top: 10px
      }

      .footEsca {
        width: 80px;
        padding-top: 10px
      }

      #footerAplli .ctaJaune.black {
        display: block;
        text-align: center
      }

      #footer .col-xs-4.text-center div:first-child {
        min-height: 9em;
        padding: 2em 0
      }

      #\#twitter-icon::before,
      #\#youtube-icon::before,
      #\#fb-icon::before {
        vertical-align: middle
      }

      .imgprefooter {
        height: 10em
      }

      iframe[name="google_conversion_frame"] {
        display: none
      }

      @media screen and (max-width:768px) {
        #footer\ bg-white>div:nth-child(1)>div>div {
          margin-top: 2em
        }

        #footerBaz .deuxiemeLigne {
          margin-top: 0
        }

        #footerBaz div p.titre {
          font-weight: 700
        }

        #footerAppli {
          padding: 3em
        }

        #footer .col-xs-12.text-center {
          text-align: center !important
        }

        #footer .col-xs-12.col-sm-4.text-center div:first-child {
          height: auto;
          padding: 1em 0
        }

        #footer>div:nth-child(1)>div {
          padding: 2em 0
        }

        #footer .col-xs-4.text-center div:first-child {
          min-height: auto;
          padding: 0
        }

        .txtFooterArg {
          min-height: 5em
        }

        .imgprefooter {
          height: 7em
        }

        .large-txt {
          font-size: 3.6rem
        }
      }

      .containerOffre:not(.products)~footer #footer #testsup {
        display: none
      }

      label::before {
        content: none
      }

    </style>

    <style data-savepage-href="/fr/css/faq/search-faq.css">
      .dialog-search {
        padding: 17px 26px 28px
      }

      .inbenta .inbenta-interface.inbenta-jsonp {
        font-family: "Helvetica Neue", Helvetica, Roboto, Arial, sans-serif;
        background: #f8f8f8
      }

      .inbenta .inbenta-interface.inbenta-jsonp .container {
        padding-top: 0;
        padding-bottom: 0
      }

      .inbenta .inbenta-interface .container {
        margin: 0;
        padding: 0
      }

      .inbenta #search h1,
      .inbenta #search-contact h1 {
        font-size: 16px;
        font-weight: 700;
        color: #000;
        margin-bottom: 20px
      }

      .inbenta #search .form-control,
      .inbenta #search-contact .form-control {
        border-radius: 0;
        border: 0;
        box-shadow: none
      }

      .inbenta .inbenta-contents .no-results {
        font-size: 22px;
        font-weight: 700;
        color: #bad606
      }

      .inbenta .inbenta-contents .no-results span {
        font-size: 16px;
        font-weight: 700;
        color: #000
      }

      .inbenta #popular h1,
      .inbenta .results-container h1 {
        border-bottom: 1px solid #dedede;
        padding-bottom: 10px;
        font-family: "Helvetica Neue", Helvetica, Roboto, Arial, sans-serif;
        font-size: 22px;
        font-weight: 700;
        color: #000
      }

      .inbenta #popular .num-results,
      .inbenta .results-container .num-results {
        position: absolute;
        top: 32px;
        right: 0;
        font-family: "Helvetica Neue", Helvetica, Roboto, Arial, sans-serif;
        font-size: 16px;
        font-weight: 700;
        color: #bad606
      }

      .inbenta .inbenta-interface.inbenta-jsonp #btn-faq {
        position: relative;
        padding: 0;
        border-radius: 0;
        background: #232323;
        width: 330px;
        height: 62px;
        line-height: 62px;
        vertical-align: middle;
        text-align: center
      }

      .inbenta .inbenta-interface.inbenta-jsonp #btn-faq:after {
        display: block;
        position: absolute;
        top: 0;
        left: 0;
        width: 100%;
        height: 100%;
        background: #565656;
        content: '';
        z-index: 1;
        transition: transform .4s cubic-bezier(.77, 0, .175, 1);
        transform-origin: left;
        transform: scaleX(0)
      }

      .inbenta .inbenta-interface.inbenta-jsonp #btn-faq:hover:after {
        transform: scaleX(1)
      }

      .inbenta .inbenta-interface.inbenta-jsonp #btn-faq a {
        position: relative;
        z-index: 2;
        margin: 0
      }

      .inbenta .inbenta-interface.inbenta-jsonp .container .faq {
        position: relative
      }

      .inbenta .inbenta-interface.inbenta-jsonp .container .faq .faq-link {
        margin-bottom: 30px;
        padding-left: 30px;
        height: 20px;
        font-family: "Helvetica Neue", Helvetica, Roboto, Arial, sans-serif;
        font-weight: 700;
        font-size: 16px;
        color: #000
      }

      .inbenta .inbenta-interface.inbenta-jsonp .container .faq .faq-link.active {
        font-weight: 700
      }

      .inbenta .inbenta-interface.inbenta-jsonp .container .faq .icon.angle-right:before {
        content: "+";
        font-size: 22px;
        line-height: .8;
        text-align: center;
        font-weight: 700;
        position: absolute;
        top: 8px;
        left: 0;
        width: 20px;
        height: 20px;
        color: #fff;
        background: #000
      }

      .inbenta .inbenta-interface.inbenta-jsonp .container .faq .faq-link.active .icon:before {
        content: "-" !important;
        font-size: 26px;
        line-height: .6
      }

      .inbenta .inbenta-interface.inbenta-jsonp .container .faq .faq-body {
        position: relative;
        margin-bottom: 30px;
        padding: 30px 40px;
        background: #e2e2e2
      }

      .inbenta .inbenta-interface.inbenta-jsonp .container .faq .faq-body ul {
        list-style-type: disc
      }

      .inbenta .inbenta-interface.inbenta-jsonp .container .faq .faq-body li {
        display: list-item
      }

      .inbenta .inbenta-interface.inbenta-jsonp .container .faq .faq-body p a {
        text-decoration: underline;
        font-style: italic;
        font-weight: 700;
        margin-bottom: 0
      }

      .inbenta .inbenta-interface.inbenta-jsonp .container .faq .faq-body u {
        text-decoration: underline
      }

      .inbenta .inbenta-interface.inbenta-jsonp .container .faq .faq-body strong {
        font-weight: 700
      }

      .inbenta .inbenta-interface.inbenta-jsonp .container .faq .faq-body:before {
        content: '';
        position: absolute;
        top: -7px;
        left: 0;
        width: 0;
        height: 0;
        border-style: solid;
        border-width: 0 7px 7px 7px;
        border-color: transparent transparent #e2e2e2 transparent
      }

      .inbenta .inbenta-interface.inbenta-jsonp .container .faq .faq-body a {
        max-width: auto;
        width: auto;
        text-decoration: none;
        font-style: italic;
        font-weight: 800
      }

      .inbenta .inbenta-interface.inbenta-jsonp .container .faq .faq-body a:hover {
        text-decoration: underline
      }

      .inbenta .inbenta-interface.inbenta-jsonp .container .faq .faq-body-response {
        font-family: "Helvetica Neue", Helvetica, Roboto, Arial, sans-serif;
        font-size: 14px;
        color: #000
      }

      .inbenta .inbenta-interface.inbenta-jsonp .container .faq .inbenta-rating {
        padding: 0;
        background: #e2e2e2
      }

      .inbenta .inbenta-interface.inbenta-jsonp .container .faq .rating-content {
        display: block
      }

      .inbenta .inbenta-interface.inbenta-jsonp .container .faq .rating-phrase {
        font-family: "Helvetica Neue", Helvetica, Roboto, Arial, sans-serif;
        font-weight: 700;
        font-size: 16px;
        color: #000;
        margin-bottom: 15px
      }

      .inbenta .inbenta-interface.inbenta-jsonp .container .faq .buttons-container i {
        display: none
      }

      .inbenta .inbenta-interface.inbenta-jsonp .container .faq .buttons-container .rating-button {
        padding: 24px 30px !important;
        background: #494949
      }

      .inbenta .inbenta-interface.inbenta-jsonp .container .faq .buttons-container .rating-button:before {
        background: #494949
      }

      .inbenta .inbenta-interface.inbenta-jsonp .container .faq .rating-comment {
        position: relative;
        width: 80%
      }

      .inbenta .inbenta-interface.inbenta-jsonp .container .faq .rating-comment p {
        font-family: "Helvetica Neue", Helvetica, Roboto, Arial, sans-serif;
        font-size: 14px;
        color: #000
      }

      .inbenta .inbenta-interface.inbenta-jsonp .container .faq .rating-comment p:nth-child(3) {
        position: absolute;
        bottom: 37px;
        right: 0;
        font-size: 11px;
        font-style: italic
      }

      .inbenta .inbenta-interface.inbenta-jsonp .container .faq .rating-comment .flex-container {
        display: block
      }

      .inbenta .inbenta-interface.inbenta-jsonp .container .faq .rating-comment .flex-container button,
      .inbenta .inbenta-interface.inbenta-jsonp .container .faq .rating-comment .flex-container textarea {
        display: block
      }

      .inbenta .inbenta-interface.inbenta-jsonp .container .faq .rating-comment .flex-container textarea {
        margin-bottom: 10px;
        min-height: 180px;
        width: 100%;
        border: 0
      }

      .inbenta .inbenta-interface.inbenta-jsonp .container .faq .rating-comment .flex-container button {
        padding: 24px 30px
      }

      .inbenta .inbenta-interface.inbenta-jsonp .container .faq .rating-thanks-no,
      .inbenta .inbenta-interface.inbenta-jsonp .container .faq .rating-thanks-yes {
        font-family: "Helvetica Neue", Helvetica, Roboto, Arial, sans-serif;
        font-weight: 700;
        font-size: 16px;
        color: #000
      }

      .inbenta .inbenta-interface.inbenta-jsonp #catSearch .tableCat {
        position: relative
      }

      .inbenta .inbenta-interface.inbenta-jsonp #catSearch h2 {
        font-family: "Helvetica Neue", Helvetica, Roboto, Arial, sans-serif;
        color: #000;
        font-size: 22px;
        font-weight: 700;
        padding-bottom: 10px;
        border-bottom: 1px solid #dedede
      }

      .inbenta .inbenta-interface.inbenta-jsonp #catSearch .num-results {
        position: absolute;
        top: 17px;
        right: 0
      }

      .inbenta .inbenta-interface.inbenta-jsonp #catSearch .sse {
        margin-bottom: 0;
        padding-right: 70px
      }

      .inbenta .inbenta-interface.inbenta-jsonp #catSearch .sse-title i {
        display: none
      }

      .inbenta .inbenta-interface.inbenta-jsonp #catSearch .sse-link {
        text-align: left;
        font-family: "Helvetica Neue", Helvetica, Roboto, Arial, sans-serif;
        color: #000;
        font-size: 14px;
        font-weight: 700;
        margin-bottom: 22px
      }

      .inbenta .inbenta-interface.inbenta-jsonp .link-more-result .seeMoreExt {
        position: relative;
        display: block;
        margin: 0 auto;
        padding-right: 20px;
        padding-top: 0;
        width: 180px;
        text-align: left;
        font-family: "Helvetica Neue", Helvetica, Roboto, Arial, sans-serif;
        color: #000;
        font-size: 11px;
        font-weight: 700;
        text-transform: uppercase
      }

      .inbenta .inbenta-interface.inbenta-jsonp .seeMoreExtMob {
        position: relative;
        display: block;
        margin: 0 auto;
        padding-right: 20px;
        padding-top: 0;
        width: 21px;
        height: 21px;
        overflow: hidden;
        text-align: left;
        font-family: "Helvetica Neue", Helvetica, Roboto, Arial, sans-serif;
        color: #000;
        font-size: 11px;
        font-weight: 700;
        text-transform: uppercase
      }

      .inbenta .inbenta-interface.inbenta-jsonp .link-more-result .seeMoreExt:after {
        content: "+";
        font-size: 22px;
        line-height: .8;
        text-align: center;
        font-weight: 700;
        position: absolute;
        top: 0;
        right: 0;
        width: 21px;
        height: 21px;
        color: #fff;
        background: #000
      }

      .inbenta .inbenta-interface.inbenta-jsonp .seeMoreExtMob:after {
        content: "+";
        font-size: 22px;
        line-height: .8;
        text-align: center;
        font-weight: 700;
        position: absolute;
        top: 0;
        right: 0;
        width: 21px;
        height: 21px;
        color: #fff;
        background: #000
      }

      .inbenta .inbenta-interface.inbenta-jsonp .link-more-result .seeMoreExt.open:after {
        content: "-";
        font-size: 22px;
        line-height: .8;
        text-align: center
      }

      .inbenta .inbenta-interface.inbenta-jsonp .seeMoreExtMob.open:after {
        content: "-";
        font-size: 22px;
        line-height: .8;
        text-align: center
      }

      .inbenta .inbenta-interface.inbenta-jsonp .link-more-result {
        margin-top: 30px;
        border-top: 1px solid #dedede;
        padding-top: 20px
      }

      .inbenta .inbenta-interface.inbenta-jsonp #catSearch .tableCat {
        padding: 0
      }

      .inbenta .inbenta-interface.inbenta-jsonp #catSearch .tableCat.cat-two {
        width: 45%
      }

      .inbenta .inbenta-interface.inbenta-jsonp #catSearch .tableCat {
        margin-right: 9%
      }

      .inbenta .inbenta-interface.inbenta-jsonp #catSearch .tableCat:only-child {
        margin-right: 0
      }

      .inbenta .inbenta-interface.inbenta-jsonp #catSearch .tableCat:last-child {
        margin-right: 0
      }

      .inbenta #inbenta-contents-contact {
        padding-top: 40px;
        background-color: #f8f8f8
      }

      .inbenta #inbenta-contents-contact .results-container {
        padding: 0
      }

      .inbenta #inbenta-contents-contact #results-contact {
        margin-bottom: 40px
      }

      .inbenta #inbenta-contents-contact .contactByForm a {
        width: auto;
        text-decoration: underline
      }

      .popin-head div#search form div.search-block input {
        background-color: #fff
      }

      .popin-head div#search form button {
        height: 76%
      }

      header.ei_tpl_header p {
        color: #000
      }

      #ei_tpl_search_m a.more::before {
        content: ""
      }

      #faq-desktop-detect-search table {
        width: 100% !important
      }

      #faq-desktop-detect-search table tr td {
        border: 1px solid #000 !important;
        padding: 1%
      }

      @media (min-width:1200px) {
        .inbenta-interface .container {
          max-width: 100%
        }
      }

      @media (min-width:992px) {
        .inbenta-interface .container {
          max-width: 100%
        }
      }

      @media (min-width:768px) {
        .inbenta-interface .container {
          max-width: 100%
        }
      }

      @media (max-width:1023px) {
        .inbenta .inbenta-interface.inbenta-jsonp {
          padding-bottom: 50px
        }

        .inbenta .inbenta-interface.inbenta-jsonp #catSearch .tableCat {
          margin-right: 0
        }

        .inbenta .inbenta-interface.inbenta-jsonp #catSearch .tableCat.cat-two {
          width: 100%
        }

        .inbenta .inbenta-interface.inbenta-jsonp #catSearch .num-results {
          position: absolute;
          top: 1px;
          right: 0;
          left: auto;
          font-size: 13px
        }

        .inbenta .inbenta-interface.inbenta-jsonp #catSearch .sse-link {
          display: block;
          margin-bottom: 20px;
          color: #494949
        }

        .inbenta .inbenta-interface.inbenta-jsonp #btn-faq {
          width: 290px
        }

        .inbenta .inbenta-interface.inbenta-jsonp #btn-faq a {
          position: relative;
          width: 100%;
          display: block;
          text-align: center
        }

        .inbenta .inbenta-interface.inbenta-jsonp .link-more-result {
          display: none
        }

        .inbenta #search h1,
        .inbenta #search-contact h1 {
          font-size: 15px;
          font-weight: 400;
          color: #000;
          margin-bottom: 20px
        }

        .inbenta #search .search-form,
        .inbenta #search-contact .search-form {
          width: 100%
        }

        .inbenta #search .form-control,
        .inbenta #search-contact .form-control {
          border-radius: 0;
          border: 0;
          box-shadow: none
        }

        .inbenta #popular h1 {
          font-size: 18px
        }

        .inbenta .inbenta-interface.inbenta-jsonp .container .faq .faq-link {
          position: relative;
          height: auto
        }

        .inbenta .inbenta-interface.inbenta-jsonp .container .faq .icon.angle-right:before {
          top: 50%;
          left: 0;
          transform: translateY(-50%)
        }

        .inbenta .inbenta-interface.inbenta-jsonp .container .faq .rating-content {
          text-align: left
        }

        .inbenta .inbenta-interface.inbenta-jsonp .container .faq .rating-comment {
          width: 100%
        }

        .inbenta .inbenta-interface.inbenta-jsonp .container .faq .rating-comment .flex-container textarea {
          margin-bottom: 60px
        }

        .inbenta .inbenta-interface.inbenta-jsonp .container .faq .rating-comment .flex-container button {
          width: 115px
        }

        .inbenta .inbenta-interface.inbenta-jsonp .container .faq .rating-comment p:nth-child(3) {
          bottom: 64px;
          font-size: 12px
        }

        .inbenta .results-container h1 {
          padding-bottom: 30px
        }

        .inbenta .results-container .num-results {
          top: 80px;
          left: 0
        }
      }

      #search-contact>h1 {
        display: none
      }

      #ask-contact {
        margin-right: 0
      }

    </style>
    <style data-savepage-href="/fr/fonts/style.css">
      @font-face {
        font-family: 'icomoon';
        src:
          /*savepage-url=/fr/fonts/icomoon.eot?h5w3ct*/
          url();
        src:
          /*savepage-url=/fr/fonts/icomoon.eot?h5w3ct#iefix*/
          url() format('embedded-opentype'),
          /*savepage-url=/fr/fonts/icomoon.ttf?h5w3ct*/
          url() format('truetype'),
          /*savepage-url=/fr/fonts/icomoon.woff?h5w3ct*/
          url() format('woff'),
          /*savepage-url=/fr/fonts/icomoon.svg?h5w3ct#icomoon*/
          url() format('svg');
        font-weight: normal;
        font-style: normal;
      }

      [class^="icon-"],
      [class*=" icon-"] {
        font-family: 'icomoon' !important;
        speak: none;
        font-style: normal;
        font-weight: normal;
        font-variant: normal;
        text-transform: none;
        display: inline-block;
        text-decoration: inherit;
        text-align: center;
        -webkit-font-smoothing: antialiased;
        -moz-osx-font-smoothing: grayscale;
      }

      .icon-search:before {
        content: "\e955";
      }

      .icon-faq-small:before {
        content: "\e900";
      }

      .icon-no-document-big:before {
        content: "\e901";
      }

      .icon-calc:before {
        content: "\e902";
      }

      .icon-euro:before {
        content: "\e903";
      }

      .icon-distributeur:before {
        content: "\e904";
      }

      .icon-document-big:before {
        content: "\e905";
      }

      .icon-dossier_ok-big:before {
        content: "\e906";
      }

      .icon-drapeau-big:before {
        content: "\e907";
      }

      .icon-enregistrer-big:before {
        content: "\e908";
      }

      .icon-fiche_info-big:before {
        content: "\e909";
      }

      .icon-filtres:before {
        content: "\e90a";
      }

      .icon-fleches-big:before {
        content: "\e90b";
      }

      .icon-imprimer-big:before {
        content: "\e90c";
      }

      .icon-lieu-big:before {
        content: "\e90d";
      }

      .icon-mail_traite-big:before {
        content: "\e90e";
      }

      .icon-mail-big:before {
        content: "\e90f";
      }

      .icon-mbonline-big:before {
        content: "\e910";
      }

      .icon-money-big:before {
        content: "\e911";
      }

      .icon-offre-big:before {
        content: "\e912";
      }

      .icon-sablier:before {
        content: "\e913";
      }

      .icon-securite-big:before {
        content: "\e914";
      }

      .icon-smartphone_contact-big:before {
        content: "\e915";
      }

      .icon-smartphone_picture-big:before {
        content: "\e916";
      }

      .icon-smiley:before {
        content: "\e917";
      }

      .icon-time-big:before {
        content: "\e918";
      }

      .icon-world-big:before {
        content: "\e919";
      }

      .icon-assistance-big:before {
        content: "\e91a";
      }

      .icon-banque-big:before {
        content: "\e91b";
      }

      .icon-billets-big:before {
        content: "\e91c";
      }

      .icon-bulle_euro-big:before {
        content: "\e91d";
      }

      .icon-cb_deux-big:before {
        content: "\e91e";
      }

      .icon-cb_opposition-big:before {
        content: "\e91f";
      }

      .icon-cb-big:before {
        content: "\e920";
      }

      .icon-cheque_emission-big:before {
        content: "\e921";
      }

      .icon-cheque_reception-big:before {
        content: "\e922";
      }

      .icon-cheque-big:before {
        content: "\e923";
      }

      .icon-cle-big:before {
        content: "\e924";
      }

      .icon-dab-big:before {
        content: "\e925";
      }

      .icon-arrow-down-small:before {
        content: "\e926";
      }

      .icon-arrow-left-small:before {
        content: "\e927";
      }

      .icon-arrow-right-small:before {
        content: "\e928";
      }

      .icon-arrow-up-small:before {
        content: "\e929";
      }

      .icon-assistance-small:before {
        content: "\e92a";
      }

      .icon-attention-small:before {
        content: "\e92b";
      }

      .icon-cb-small:before {
        content: "\e92c";
      }

      .icon-chat-small:before {
        content: "\e92d";
      }

      .icon-courrier-small:before {
        content: "\e92e";
      }

      .icon-devenir-client-small:before {
        content: "\e92f";
      }

      .icon-envoyer-small:before {
        content: "\e930";
      }

      .icon-espace-client_close-small:before {
        content: "\e931";
      }

      .icon-espace-client-small:before {
        content: "\e932";
      }

      .icon-euro-small:before {
        content: "\e933";
      }

      .icon-facebook-small:before {
        content: "\e934";
      }

      .icon-google_plus-small:before {
        content: "\e935";
      }

      .icon-hand-small:before {
        content: "\e936";
      }

      .icon-info-small:before {
        content: "\e937";
      }

      .icon-linkedin-small:before {
        content: "\e938";
      }

      .icon-mail-small:before {
        content: "\e939";
      }

      .icon-money-small:before {
        content: "\e93a";
      }

      .icon-offre-small:before {
        content: "\e93b";
      }

      .icon-partage-small:before {
        content: "\e93c";
      }

      .icon-phone-small:before {
        content: "\e93d";
      }

      .icon-piece_jointe-small:before {
        content: "\e93e";
      }

      .icon-plus-small:before {
        content: "\e93f";
      }

      .icon-smartphone-small:before {
        content: "\e940";
      }

      .icon-telecharger-small:before {
        content: "\e941";
      }

      .icon-twitter-small:before {
        content: "\e942";
      }

      .icon-up-small:before {
        content: "\e943";
      }

      .icon-viadeo-small:before {
        content: "\e944";
      }

      .icon-youtube-small:before {
        content: "\e945";
      }

      .icon-minus-small:before {
        content: "\e946";
      }

      .icon-youtube-big:before {
        content: "\e947";
      }

      .icon-annulation_voyage-small:before {
        content: "\e948";
      }

      .icon-carte_qui_epargne-big:before {
        content: "\e949";
      }

      .icon-edition_carte-big:before {
        content: "\e94a";
      }

      .icon-invalidite-small:before {
        content: "\e94b";
      }

      .icon-neige_montagne-small:before {
        content: "\e94c";
      }

      .icon-perte_bagages-small:before {
        content: "\e94d";
      }

      .icon-responsabilite_civile-small:before {
        content: "\e94e";
      }

      .icon-retard_avion-small:before {
        content: "\e94f";
      }

      .icon-retard_bagages-small:before {
        content: "\e950";
      }

      .icon-vehicule_location-small:before {
        content: "\e951";
      }

      .icon-youtube:before {
        content: "\e952";
      }

      .icon-loupe:before {
        content: "\e953";
      }

      .icon-chat-double:before {
        content: "\e954";
      }

    </style>
    <style data-savepage-href="https://cdnwmii.e-i.com/SITW/wm/global/1.0.0/monabanq/css/gabarit.css?v=20210728">
      @charset "UTF-8";

      /********************* 
 ** Reprise MAIN.CSS   **
/*********************
*/

      body {
        line-height: 1.42857;
      }

      html {
        font-size: 10px;
      }

      html body a {
        outline: 0;
      }

      #customer-area .customer-inner .customer-form .title {
        padding-bottom: 15px;
        border-bottom: 2px solid #000;
        margin-bottom: 40px;
        color: #000;
      }

      #customer-area .customer-inner .customer-form .title span {
        color: #b3ce00;
        font-weight: 500;
        display: block;
      }

      #customer-area .customer-inner .customer-form input[type="text"],
      #customer-area .customer-inner .customer-form input[type="password"] {
        width: 100%;
        display: block;
        margin-bottom: 10px;
        padding: 15px 10px;
        border: none;
        background: #fff;
      }

      #customer-area .customer-inner .customer-form .form-link {
        color: #000;
        display: block;
        margin: 20px 0 10px 0;
        font-weight: 700;
        font-size: 1.1rem;
      }

      #customer-area .customer-inner .customer-form .blocboutons {
        float: right;
      }

      a {
        text-decoration: underline;
        background-color: transparent;
        color: inherit;
      }

      ul {
        list-style: none;
        padding: 0;
        margin: 0;
      }

      b,
      strong {
        font-weight: 700
      }

      label {
        display: inline-block;
        max-width: 100%;
        margin-bottom: 5px;
        font-weight: 700
      }

      .header-lined-bel {
        margin-top: 0;
        margin-bottom: 20px;
        padding-bottom: 20px;
        position: relative
      }

      .header-lined-bel:before {
        content: '';
        width: 30px;
        height: 0;
        border: 1px solid #000;
        position: absolute;
        left: 0;
        bottom: 0
      }

      a:active,
      a:hover,
      a:focus {
        /* outline: 0 !important; */
        text-decoration: none;
      }

      .bg-primary {
        color: #fff
      }

      .bg-primary {
        background-color: #337ab7
      }

      a.bg-primary:hover,
      a.bg-primary:focus {
        background-color: #286090
      }

      .bg-success {
        background-color: #dff0d8
      }

      a.bg-success:hover,
      a.bg-success:focus {
        background-color: #c1e2b3
      }

      .bg-info {
        background-color: #d9edf7
      }

      a.bg-info:hover,
      a.bg-info:focus {
        background-color: #afd9ee
      }

      .bg-warning {
        background-color: #fcf8e3
      }

      a.bg-warning:hover,
      a.bg-warning:focus {
        background-color: #f7ecb5
      }

      .bg-danger {
        background-color: #f2dede
      }

      a.bg-danger:hover,
      a.bg-danger:focus {
        background-color: #e4b9b9
      }

      .circle-holder.green-bg {
        background: #bad606
      }

      .circle-holder.white-bg {
        background: #fff
      }

      .green {
        color: #ccec00
      }

      .green2 {
        color: #bad606
      }

      .green4 {
        color: #b3ce00
      }

      .green5 {
        color: #cde602
      }

      .white {
        color: #fff
      }

      .black {
        color: #000
      }

      .yellow {
        color: #fff600
      }

      .yellow3 {
        color: #f0e001
      }

      .dark-green {
        color: #829201
      }

      .bg-white {
        background-color: #fff
      }

      .bg-gray1 {
        background-color: #f8f8f8
      }

      .bg-gray2 {
        background-color: #ededed
      }

      .bg-gray3 {
        background-color: #f8f8f8
      }

      .bg-gray7 {
        background-color: #e2e2e2
      }

      .bg-yellow {
        background-color: #fff600
      }

      .bg-green {
        background-color: #ccec00
      }

      .bg-green2 {
        background-color: #bad606
      }

      .bg-green4 {
        background-color: #b3ce00
      }

      .bg-green5 {
        background-color: #cde602
      }

      a.appstore,
      a.googleplay,
      a.windowsstore {
        display: inline-block !important;
        height: 40px !important;
        margin: 8px 0 0 !important;
        max-width: 135px;
        width: 48% !important
      }

      a.appstore {
        background:
          /*savepage-url=/fr/images/logo-appstore.png*/
          url() no-repeat center transparent;
        background-size: contain
      }

      a.googleplay {
        background:
          /*savepage-url=/fr/images/logo-googleplay.png*/
          url() no-repeat center transparent;
        background-size: contain
      }

      a.windowsstore {
        background:
          /*savepage-url=/fr/images/logo-windowsstore.png*/
          url() no-repeat center transparent;
        background-size: contain;
        max-width: 134px
      }

      .review .review__box {
        padding: 25px;
      }

      .row {
        margin-left: 0;
        margin-right: 0
      }

      .row:before,
      .row:after {
        content: " ";
        display: table
      }

      .row:after {
        clear: both
      }

      .review__star.black .star--full svg {
        fill: #000;
      }

      .review__star.black svg {
        stroke: black;
        stroke-width: 1;
        fill: transparent;
      }

      #review .review__wrapper ul {
        margin: 0;
        padding: 0;
        list-style: none;
      }

      #review .review__filter .filter__rate li {
        margin: 10px auto;
        text-align: left;
        width: 80%;
      }

      #review .review__filter .filter__rate li .btn_rate_wrapper {
        margin-top: 20px;
        display: inline-block;
      }

      #review .review__filter .filter__rate li a.btn_rate_all {
        font-weight: 700;
        display: none;
        font-size: 1.7rem;
      }

      #review .review__filter .filter__rate li a.btn_rate_all span.reset:before {
        transform: rotate(45deg);
      }

      #review .review__filter .filter__rate li a.btn_rate_all span.reset:after {
        transform: rotate(-45deg);
      }

      #review .review__filter .filter__rate li a.btn_rate_all span.reset {
        display: inline-block;
        margin-right: 10px;
        width: 20px;
        height: 20px;
        vertical-align: middle;
        position: relative;
      }

      #review .review__filter .filter__rate li a.btn_rate_all span.reset:before,
      #review .review__filter .filter__rate li a.btn_rate_all span.reset:after {
        content: "";
        position: absolute;
        top: 0;
        left: 10px;
        width: 2px;
        height: 100%;
        background: black;
      }

      #review #slider_review .review__slider-controls {
        text-align: center;
        margin: 50px 0;
      }

      #review #slider_review .review__slider-controls button {
        background: transparent;
        border: 0;
        line-height: 0;
        vertical-align: middle;
        outline: none;
        transition: transform 0.3s ease-in-out;
        width: 30px;
        height: 20px;
      }

      #review .review__footer {
        margin-top: 80px;
      }

      #review .review__filter .review__star {
        display: inline-block;
        vertical-align: middle;
      }

      #review .review__wrapper .review__item {
        border-bottom: 1px solid #DEDEDE;
      }

      #review #slider_review .review__list.active {
        display: block;
      }

      #review #slider_review .review__list {
        display: none;
      }

      #review .review__wrapper .review__item .item__rate {
        margin-top: 20px;
      }

      .black {
        color: #000;
      }

      .container {
        width: 100%;
      }

      /* WEBPERF */
      /* .col-xs-1,
.col-sm-1,
.col-md-1,
.col-lg-1,
.col-xs-2,
.col-sm-2,
.col-md-2,
.col-lg-2,
.col-xs-3,
.col-sm-3,
.col-md-3,
.col-lg-3,
.col-xs-4,
.col-sm-4,
.col-md-4,
.col-lg-4,
.col-xs-5,
.col-sm-5,
.col-md-5,
.col-lg-5,
.col-xs-6,
.col-sm-6,
.col-md-6,
.col-lg-6,
.col-xs-7,
.col-sm-7,
.col-md-7,
.col-lg-7,
.col-xs-8,
.col-sm-8,
.col-md-8,
.col-lg-8,
.col-xs-9,
.col-sm-9,
.col-md-9,
.col-lg-9,
.col-xs-10,
.col-sm-10,
.col-md-10,
.col-lg-10,
.col-xs-11,
.col-sm-11,
.col-md-11,
.col-lg-11,
.col-xs-12,
.col-sm-12,
.col-md-12,
.col-lg-12 {
    position: relative;
    min-height: 1px;
    padding-left: 0;
    padding-right: 0
}

.col-xs-1,
.col-xs-2,
.col-xs-3,
.col-xs-4,
.col-xs-5,
.col-xs-6,
.col-xs-7,
.col-xs-8,
.col-xs-9,
.col-xs-10,
.col-xs-11,
.col-xs-12 {
    float: left
}

.col-xs-1 {
    width: 8.33333%
}

.col-xs-2 {
    width: 16.66667%
}

.col-xs-3 {
    width: 25%
}

.col-xs-4 {
    width: 33.33333%
}

.col-xs-5 {
    width: 41.66667%
}

.col-xs-6 {
    width: 50%
}

.col-xs-7 {
    width: 58.33333%
}

.col-xs-8 {
    width: 66.66667%
}

.col-xs-9 {
    width: 75%
}

.col-xs-10 {
    width: 83.33333%
}

.col-xs-11 {
    width: 91.66667%
}

.col-xs-12 {
    width: 100%
}

.col-xs-pull-0 {
    right: auto
}

.col-xs-pull-1 {
    right: 8.33333%
}

.col-xs-pull-2 {
    right: 16.66667%
}

.col-xs-pull-3 {
    right: 25%
}

.col-xs-pull-4 {
    right: 33.33333%
}

.col-xs-pull-5 {
    right: 41.66667%
}

.col-xs-pull-6 {
    right: 50%
}

.col-xs-pull-7 {
    right: 58.33333%
}

.col-xs-pull-8 {
    right: 66.66667%
}

.col-xs-pull-9 {
    right: 75%
}

.col-xs-pull-10 {
    right: 83.33333%
}

.col-xs-pull-11 {
    right: 91.66667%
}

.col-xs-pull-12 {
    right: 100%
}

.col-xs-push-0 {
    left: auto
}

.col-xs-push-1 {
    left: 8.33333%
}

.col-xs-push-2 {
    left: 16.66667%
}

.col-xs-push-3 {
    left: 25%
}

.col-xs-push-4 {
    left: 33.33333%
}

.col-xs-push-5 {
    left: 41.66667%
}

.col-xs-push-6 {
    left: 50%
}

.col-xs-push-7 {
    left: 58.33333%
}

.col-xs-push-8 {
    left: 66.66667%
}

.col-xs-push-9 {
    left: 75%
}

.col-xs-push-10 {
    left: 83.33333%
}

.col-xs-push-11 {
    left: 91.66667%
}

.col-xs-push-12 {
    left: 100%
}

.col-xs-offset-0 {
    margin-left: 0%
}

.col-xs-offset-1 {
    margin-left: 8.33333%
}

.col-xs-offset-2 {
    margin-left: 16.66667%
}

.col-xs-offset-3 {
    margin-left: 25%
}

.col-xs-offset-4 {
    margin-left: 33.33333%
}

.col-xs-offset-5 {
    margin-left: 41.66667%
}

.col-xs-offset-6 {
    margin-left: 50%
}

.col-xs-offset-7 {
    margin-left: 58.33333%
}

.col-xs-offset-8 {
    margin-left: 66.66667%
}

.col-xs-offset-9 {
    margin-left: 75%
}

.col-xs-offset-10 {
    margin-left: 83.33333%
}

.col-xs-offset-11 {
    margin-left: 91.66667%
}

.col-xs-offset-12 {
    margin-left: 100%
} */

      /* WEBPERF END */

      @media (min-width:768px) {
        #review .review__btn .right {
          text-align: right;
        }

        #review .review__wrapper {
          margin: 80px 0;
          min-height: 1500px;
        }

        #review .review__wrapper h3 {
          margin-left: 50px;
        }

        #review .review__filter {
          font-size: 0;
        }

        #review .review__filter .filter__rate {
          padding-left: 40px;
          padding-right: 40px;
          text-align: center;
        }

        #review .review__filter .filter__rate li a {
          padding: 0;
          display: inline-block;
        }

        #review .review__filter .filter__rate li a {
          padding: 0;
          display: inline-block;
        }

        .review__star svg {
          width: 18px;
          height: 18px;
          fill: #DEDEDE;
        }

        .review__star .star--full svg {
          fill: #f0e001;
        }

        #review .review__filter .bg-filter {
          background:
            /*savepage-url=/fr/images/avis/avis.jpg*/
            url() no-repeat center center;
          background-size: cover;
          min-height: 310px;
        }

        #review .review__filter .filter__thematic {
          padding-bottom: 45px;
        }

        #review .review__filter .filter__rate .rate__label {
          padding-left: 30px;
          display: inline-block;
          vertical-align: middle;
          font-size: 1.7rem;
        }

        #review .review__wrapper .review__item .review__content {
          padding-right: 30px;
          border-right: 1px solid #DEDEDE;
        }

        #review .review__wrapper .review__item .review__desc {
          padding-left: 30px;
          min-height: 120px;
        }

        /* WEBPERF */
        /* .col-sm-1,
    .col-sm-2,
    .col-sm-3,
    .col-sm-4,
    .col-sm-5,
    .col-sm-6,
    .col-sm-7,
    .col-sm-8,
    .col-sm-9,
    .col-sm-10,
    .col-sm-11,
    .col-sm-12 {
        float: left
    }
    .col-sm-1 {
        width: 8.33333%
    }
    .col-sm-2 {
        width: 16.66667%
    }
    .col-sm-3 {
        width: 25%
    }
    .col-sm-4 {
        width: 33.33333%
    }
    .col-sm-5 {
        width: 41.66667%
    }
    .col-sm-6 {
        width: 50%
    }
    .col-sm-7 {
        width: 58.33333%
    }
    .col-sm-8 {
        width: 66.66667%
    }
    .col-sm-9 {
        width: 75%
    }
    .col-sm-10 {
        width: 83.33333%
    }
    .col-sm-11 {
        width: 91.66667%
    }
    .col-sm-12 {
        width: 100%
    }
    .col-sm-pull-0 {
        right: auto
    }
    .col-sm-pull-1 {
        right: 8.33333%
    }
    .col-sm-pull-2 {
        right: 16.66667%
    }
    .col-sm-pull-3 {
        right: 25%
    }
    .col-sm-pull-4 {
        right: 33.33333%
    }
    .col-sm-pull-5 {
        right: 41.66667%
    }
    .col-sm-pull-6 {
        right: 50%
    }
    .col-sm-pull-7 {
        right: 58.33333%
    }
    .col-sm-pull-8 {
        right: 66.66667%
    }
    .col-sm-pull-9 {
        right: 75%
    }
    .col-sm-pull-10 {
        right: 83.33333%
    }
    .col-sm-pull-11 {
        right: 91.66667%
    }
    .col-sm-pull-12 {
        right: 100%
    }
    .col-sm-push-0 {
        left: auto
    }
    .col-sm-push-1 {
        left: 8.33333%
    }
    .col-sm-push-2 {
        left: 16.66667%
    }
    .col-sm-push-3 {
        left: 25%
    }
    .col-sm-push-4 {
        left: 33.33333%
    }
    .col-sm-push-5 {
        left: 41.66667%
    }
    .col-sm-push-6 {
        left: 50%
    }
    .col-sm-push-7 {
        left: 58.33333%
    }
    .col-sm-push-8 {
        left: 66.66667%
    }
    .col-sm-push-9 {
        left: 75%
    }
    .col-sm-push-10 {
        left: 83.33333%
    }
    .col-sm-push-11 {
        left: 91.66667%
    }
    .col-sm-push-12 {
        left: 100%
    }
    .col-sm-offset-0 {
        margin-left: 0%
    }
    .col-sm-offset-1 {
        margin-left: 8.33333%
    }
    .col-sm-offset-2 {
        margin-left: 16.66667%
    }
    .col-sm-offset-3 {
        margin-left: 25%
    }
    .col-sm-offset-4 {
        margin-left: 33.33333%
    }
    .col-sm-offset-5 {
        margin-left: 41.66667%
    }
    .col-sm-offset-6 {
        margin-left: 50%
    }
    .col-sm-offset-7 {
        margin-left: 58.33333%
    }
    .col-sm-offset-8 {
        margin-left: 66.66667%
    }
    .col-sm-offset-9 {
        margin-left: 75%
    }
    .col-sm-offset-10 {
        margin-left: 83.33333%
    }
    .col-sm-offset-11 {
        margin-left: 91.66667%
    }
    .col-sm-offset-12 {
        margin-left: 100%
    } */
        /* WEBPERF END */
      }

      /* WEBPERF */
      /* @media (min-width:992px) {

    .col-md-1,
    .col-md-2,
    .col-md-3,
    .col-md-4,
    .col-md-5,
    .col-md-6,
    .col-md-7,
    .col-md-8,
    .col-md-9,
    .col-md-10,
    .col-md-11,
    .col-md-12 {
        float: left
    }
    .col-md-1 {
        width: 8.33333%
    }
    .col-md-2 {
        width: 16.66667%
    }
    .col-md-3 {
        width: 25%
    }
    .col-md-4 {
        width: 33.33333%
    }
    .col-md-5 {
        width: 41.66667%
    }
    .col-md-6 {
        width: 50%
    }
    .col-md-7 {
        width: 58.33333%
    }
    .col-md-8 {
        width: 66.66667%
    }
    .col-md-9 {
        width: 75%
    }
    .col-md-10 {
        width: 83.33333%
    }
    .col-md-11 {
        width: 91.66667%
    }
    .col-md-12 {
        width: 100%
    }
    .col-md-pull-0 {
        right: auto
    }
    .col-md-pull-1 {
        right: 8.33333%
    }
    .col-md-pull-2 {
        right: 16.66667%
    }
    .col-md-pull-3 {
        right: 25%
    }
    .col-md-pull-4 {
        right: 33.33333%
    }
    .col-md-pull-5 {
        right: 41.66667%
    }
    .col-md-pull-6 {
        right: 50%
    }
    .col-md-pull-7 {
        right: 58.33333%
    }
    .col-md-pull-8 {
        right: 66.66667%
    }
    .col-md-pull-9 {
        right: 75%
    }
    .col-md-pull-10 {
        right: 83.33333%
    }
    .col-md-pull-11 {
        right: 91.66667%
    }
    .col-md-pull-12 {
        right: 100%
    }
    .col-md-push-0 {
        left: auto
    }
    .col-md-push-1 {
        left: 8.33333%
    }
    .col-md-push-2 {
        left: 16.66667%
    }
    .col-md-push-3 {
        left: 25%
    }
    .col-md-push-4 {
        left: 33.33333%
    }
    .col-md-push-5 {
        left: 41.66667%
    }
    .col-md-push-6 {
        left: 50%
    }
    .col-md-push-7 {
        left: 58.33333%
    }
    .col-md-push-8 {
        left: 66.66667%
    }
    .col-md-push-9 {
        left: 75%
    }
    .col-md-push-10 {
        left: 83.33333%
    }
    .col-md-push-11 {
        left: 91.66667%
    }
    .col-md-push-12 {
        left: 100%
    }
    .col-md-offset-0 {
        margin-left: 0%
    }
    .col-md-offset-1 {
        margin-left: 8.33333%
    }
    .col-md-offset-2 {
        margin-left: 16.66667%
    }
    .col-md-offset-3 {
        margin-left: 25%
    }
    .col-md-offset-4 {
        margin-left: 33.33333%
    }
    .col-md-offset-5 {
        margin-left: 41.66667%
    }
    .col-md-offset-6 {
        margin-left: 50%
    }
    .col-md-offset-7 {
        margin-left: 58.33333%
    }
    .col-md-offset-8 {
        margin-left: 66.66667%
    }
    .col-md-offset-9 {
        margin-left: 75%
    }
    .col-md-offset-10 {
        margin-left: 83.33333%
    }
    .col-md-offset-11 {
        margin-left: 91.66667%
    }
    .col-md-offset-12 {
        margin-left: 100%
    }
} */
      /* WEBPERF END */

      /* WEBPERF */
      /* @media (min-width:1200px) {
    .col-lg-1,
    .col-lg-2,
    .col-lg-3,
    .col-lg-4,
    .col-lg-5,
    .col-lg-6,
    .col-lg-7,
    .col-lg-8,
    .col-lg-9,
    .col-lg-10,
    .col-lg-11,
    .col-lg-12 {
        float: left
    }
    .col-lg-1 {
        width: 8.33333%
    }
    .col-lg-2 {
        width: 16.66667%
    }
    .col-lg-3 {
        width: 25%
    }
    .col-lg-4 {
        width: 33.33333%
    }
    .col-lg-5 {
        width: 41.66667%
    }
    .col-lg-6 {
        width: 50%
    }
    .col-lg-7 {
        width: 58.33333%
    }
    .col-lg-8 {
        width: 66.66667%
    }
    .col-lg-9 {
        width: 75%
    }
    .col-lg-10 {
        width: 83.33333%
    }
    .col-lg-11 {
        width: 91.66667%
    }
    .col-lg-12 {
        width: 100%
    }
    .col-lg-pull-0 {
        right: auto
    }
    .col-lg-pull-1 {
        right: 8.33333%
    }
    .col-lg-pull-2 {
        right: 16.66667%
    }
    .col-lg-pull-3 {
        right: 25%
    }
    .col-lg-pull-4 {
        right: 33.33333%
    }
    .col-lg-pull-5 {
        right: 41.66667%
    }
    .col-lg-pull-6 {
        right: 50%
    }
    .col-lg-pull-7 {
        right: 58.33333%
    }
    .col-lg-pull-8 {
        right: 66.66667%
    }
    .col-lg-pull-9 {
        right: 75%
    }
    .col-lg-pull-10 {
        right: 83.33333%
    }
    .col-lg-pull-11 {
        right: 91.66667%
    }
    .col-lg-pull-12 {
        right: 100%
    }
    .col-lg-push-0 {
        left: auto
    }
    .col-lg-push-1 {
        left: 8.33333%
    }
    .col-lg-push-2 {
        left: 16.66667%
    }
    .col-lg-push-3 {
        left: 25%
    }
    .col-lg-push-4 {
        left: 33.33333%
    }
    .col-lg-push-5 {
        left: 41.66667%
    }
    .col-lg-push-6 {
        left: 50%
    }
    .col-lg-push-7 {
        left: 58.33333%
    }
    .col-lg-push-8 {
        left: 66.66667%
    }
    .col-lg-push-9 {
        left: 75%
    }
    .col-lg-push-10 {
        left: 83.33333%
    }
    .col-lg-push-11 {
        left: 91.66667%
    }
    .col-lg-push-12 {
        left: 100%
    }
    .col-lg-offset-0 {
        margin-left: 0%
    }
    .col-lg-offset-1 {
        margin-left: 8.33333%
    }
    .col-lg-offset-2 {
        margin-left: 16.66667%
    }
    .col-lg-offset-3 {
        margin-left: 25%
    }
    .col-lg-offset-4 {
        margin-left: 33.33333%
    }
    .col-lg-offset-5 {
        margin-left: 41.66667%
    }
    .col-lg-offset-6 {
        margin-left: 50%
    }
    .col-lg-offset-7 {
        margin-left: 58.33333%
    }
    .col-lg-offset-8 {
        margin-left: 66.66667%
    }
    .col-lg-offset-9 {
        margin-left: 75%
    }
    .col-lg-offset-10 {
        margin-left: 83.33333%
    }
    .col-lg-offset-11 {
        margin-left: 91.66667%
    }
    .col-lg-offset-12 {
        margin-left: 100%
    }
} */
      /* WEBPERF END */

      @media (min-width:1280px) {
        .extra-large-txt {
          font-size: 9rem;
        }

        .extra-medium-txt {
          font-size: 3.6rem;
        }
      }

      .dialog-phone .tab-content img {
        width: 201px;
        height: 79px;
        margin-bottom: 28px
      }

      .dialog-phone a.arcep {
        text-align: left !important;
        margin-left: 0px !important
      }

      .dialog-phone a.arcep img {
        width: 210px;
        height: auto
      }

      .phone-image {
        display: block;
        width: 13em;
        height: auto;
        min-height: 19px
      }

      .dialog-phone .faq-mail-link .green {
        padding-bottom: 0 !important;
        display: block
      }

      .btn {
        display: inline-block;
        margin-bottom: 0;
        font-weight: 400;
        text-align: center;
        vertical-align: middle;
        touch-action: manipulation;
        cursor: pointer;
        background-image: none;
        border: 1px solid transparent;
        white-space: nowrap;
        padding: 6px 12px;
        font-size: 14px;
        line-height: 1.42857;
        border-radius: 4px;
        -webkit-user-select: none;
        -moz-user-select: none;
        -ms-user-select: none;
        user-select: none;
      }

      .btn {
        border-radius: 0;
        border: none;
        font-weight: 700;
        font-size: 1.5rem;
        padding: 10px 0;
        text-decoration: none
      }

      .btn-default {
        padding: 20px 30px;
        background: #232323;
        color: #fff;
        text-decoration: none;
        position: relative;
        -webkit-transform: translate3d(0, 0, 0);
        -moz-transform: translate3d(0, 0, 0);
        -ms-transform: translate3d(0, 0, 0);
        -o-transform: translate3d(0, 0, 0);
        transform: translate3d(0, 0, 0);
        background: transparent
      }

      .btn-default:hover,
      .btn-default:active,
      .btn-default:focus {
        color: #fff !important
      }

      .btn-default:before {
        display: block;
        position: absolute;
        top: 0;
        left: 0;
        width: 100%;
        height: 100%;
        background: #232323;
        content: '';
        z-index: -2
      }

      .btn-default:after {
        display: block;
        position: absolute;
        top: 0;
        left: 0;
        width: 100%;
        height: 100%;
        background: #565656;
        content: '';
        z-index: -1;
        opacity: 0;
        -moz-transform: scaleX(0);
        -o-transform: scaleX(0);
        -webkit-transform: scaleX(0);
        transform: scaleX(0);
        -moz-transform-origin: 0 0;
        -o-transform-origin: 0 0;
        -webkit-transform-origin: 0 0;
        transform-origin: 0 0;
        -moz-transition: transform 0.4s cubic-bezier(.77, 0, .175, 1), opacity 0.05s linear 0.4s;
        -o-transition: transform 0.4s cubic-bezier(.77, 0, .175, 1), opacity 0.05s linear 0.4s;
        -webkit-transition: transform 0.4s cubic-bezier(.77, 0, .175, 1), opacity 0.05s linear;
        -webkit-transition-delay: 0s, 0.4s;
        transition: transform 0.4s cubic-bezier(.77, 0, .175, 1), opacity 0.05s linear 0.4s
      }

      .btn-default:hover:after {
        width: 100%;
        opacity: 1;
        -moz-transform: scaleX(1);
        -o-transform: scaleX(1);
        -webkit-transform: scaleX(1);
        transform: scaleX(1);
        -moz-transition-delay: 0s;
        -o-transition-delay: 0s;
        -webkit-transition-delay: 0s;
        transition-delay: 0s
      }

      p {
        margin: 0 0 10px
      }

      .dialog-phone .btn {
        margin: 0 30px
      }

      .dialog-phone .btn.btn-default {
        margin-left: 0
      }

      .dialog-phone {
        padding: 17px 18px 58px
      }

      fieldset {
        padding: 0;
        margin: 0;
        border: 0;
        min-width: 0
      }

      .container {
        margin-right: auto;
        margin-left: auto;
        padding-left: 0;
        padding-right: 0
      }


      /** FIN MAIN.CSS*/

      .articles li {
        list-style:
          /*savepage-url=/fr/images/list-green-arrow.png*/
          url();
      }


      /* ------------  Bouton "nouveau crédit immo" dans le menu à gauche  ----------- */

      .credit-immo a {
        color: #FFF600 !important;
        padding: 0 70px 0 40px !important;
        margin-top: 1.7em;
        font-weight: 200 !important;
        font-size: 12px !important;
      }

      .credit-immo a::before {
        content: "NOUVEAU" !important;
        background-color: #FFF600 !important;
        height: 13px !important;
        width: 65px !important;
        color: black !important;
        font-weight: 800 !important;
        font-size: 0.8em !important;
        top: -18px !important;
        left: 40px !important;
        text-align: center !important;
        vertical-align: baseline !important;
      }

      .credit-immo a:hover {
        font-weight: bolder !important;
      }


      /* ------------------- Fin bouton ----------------------*/


      /* ALL */

      body .menuBazooka a {
        position: relative;
      }

      .inline {
        display: inline-block;
      }

      .overflow {
        overflow-y: auto !important;
      }

      [class^="icon-"],
      [class*=" icon-"] {
        font-family: 'icomoon' !important;
      }

      body .ei_tpl_redac #ei_tpl_content img {
        display: block;
      }

      .disp-p,
      .disp-ca,
      .disp-na,
      .disp-wcb-clt,
      .disp-wcb-ppt,
      .product_menu.client ul.row li.souscrire {
        display: none;
      }

      .disp-wcb-clt,
      .disp-wcb-ppt {
        background-color: #f8f8f8;
        padding: 0 17px;
        transition: background 0.4s;
      }

      .disp-wcb-clt:hover,
      .disp-wcb-ppt:hover {
        background-color: #fffbb1;
      }

      li.jaffiche {
        display: list-item !important;
      }

      .product_menu.client ul li.col-md-3 {
        width: 33.33333% !important;
      }

      .ei_gly_ic_search:before {
        /* font-size: 25px; */
      }

      .resetCTA {
        display: none;
      }

      a:focus {
        color: inherit;
      }

      .spacing {
        padding-bottom: 15px;
      }

      .txt-bold {
        font-weight: 700;
      }

      .pre-code {
        font-family: "monospace";
        font-style: italic;
      }

      .anim-pourcentage {
        display: none;
      }

      @media only screen and (min-width: 1280px) {
        .small-txt {
          font-size: 1.1em !important
        }

        sup.small-txt {
          font-size: 0.3em;
          vertical-align: 1em;
        }

        .medium-txt {
          font-size: 1.2em !important;
        }

        #ei_tpl_blocbottom {
          bottom: -50px;
        }
      }

      .ei_tpl_redac main strong {
        font-weight: 700 !important;
        font-size: inherit;
      }


      /* Button */

      .btn_yellow>span {
        background-color: #bad606;
        color: #000;
      }

      .btn_green>span {
        background-color: #bad606;
        color: #000;
      }

      .btn_black>span {
        background-color: #000;
        color: #fff;
      }

      .btn_white>span {
        background-color: #f8f8f8;
        color: #000;
      }

      .btn_grey>span {
        background-color: #c3c3c3;
        color: #000;
      }

      .btn_hover>span {
        position: relative;
        padding: 20px 30px;
        font-size: 1.6rem;
        display: inline-block;
        text-decoration: none;
        font-weight: bold;
        text-align: center;
        z-index: 0;
      }

      .mt-X {
        margin-top: 6.4em;
      }

      .btn_hover {
        text-decoration: none !important;
      }

      .btn_hover:hover>span::after {
        width: 100%;
      }

      .btn_hover>span::after {
        background-color: #fff;
        opacity: 0.5;
        content: '';
        display: block;
        width: 0;
        transition: width 0.4s;
        position: absolute;
        left: 0;
        top: 0;
        height: 100%;
        z-index: -1;
      }

      #ei_tpl_menuPrincipal>nav>ul>li.menuBazooka>a:before {
        left: -5px !important;
      }

      @keyframes slideright {
        0% {
          left: calc(100% - 55px);
        }

        10% {
          left: calc(100% - 45px);
        }

        20% {
          left: calc(100% - 55px);
        }

        40% {
          left: calc(100% - 15px);
        }

        60% {
          left: calc(100% - 55px);
        }

        100% {
          left: calc(100% - 55px);
        }
      }

      .btn_anim {
        position: relative;
      }

      .btn_anim::after {
        content: '\276F';
        font-weight: 700;
        display: inline-block;
        position: absolute;
        top: 50%;
        transform: translateY(-50%);
        animation-name: slideright;
        animation-duration: 2.5s;
        color: #000000;
        font-size: 20px;
        left: calc(100% - 55px);
        animation-iteration-count: infinite;
        animation-timing-function: linear;
        font-family: "fts_commun";
      }

      .btn_anim span {
        padding-right: 65px !important;
        /* font-size: 23px; */
      }

      .box-btn {
        display: inline-block;
        margin-left: 25px;
      }

      .box-btn p {
        font-size: 1.1em;
        font-weight: 700;
        margin-bottom: 0;
      }

      .acc-create .btn_yellow>span {
        padding: 20px 55px;
      }


      /* End button */


      /*.btn {padding: 9px 0;}*/

      .content-popin-head p.title-header {
        margin-bottom: 0;
      }

      #ei_tpl_wcb_bt {
        display: none;
      }

      .content-head .header-lined-bel:before {
        width: 100%;
      }

      .popin-head {
        background-color: rgba(0, 0, 0, 0.8);
        width: 100%;
        position: fixed;
        top: 60px;
        height: 100%;
        z-index: 999;
        display: none;
        left: 0;
        margin-left: 300px;
      }

      .popin-head .content-popin-head {
        background-color: #f8f8f8;
        height: 100%;
        padding: 1% 2% 5% 2%;
        width: calc(83.333% - 480px);
        overflow-y: auto;
        display: none;
      }

      .popin-head .content-popin-head.content-popin-head-p {
        width: calc(83.333% - 180px);
        overflow-y: auto;
      }

      .close-popin-desk {
        background-color: transparent;
        opacity: 0.5;
        height: 100%;
        width: 480px;
        top: 0;
        position: absolute;
        right: 0;
        display: none;
        z-index: 1000;
        cursor: pointer
      }

      .close-popin-desk-p {
        width: 179px;
      }

      @media screen and (max-width: 1400px) {
        .popin-head .content-popin-head {
          width: calc(80% - 350px);
          padding-left: 50px !important;
        }

        .popin-head .content-popin-head.content-popin-head-p {
          width: calc(80% - 180px);
        }

        .close-popin-desk {
          width: 180px;
        }
      }

      @media screen and (max-width: 1220px) {
        .popin-head .content-popin-head {
          width: calc(80% - 369px);
        }

        .close-popin-desk {
          width: 406px;
        }

        .close-popin-desk-p {
          width: 70px;
        }

        .popin-head .content-popin-head.content-popin-head-p {
          width: calc(80% - 70px);
          height: calc(100% - 110px);
        }
      }

      @media screen and (max-width: 1098px) {
        .close-popin-desk {
          width: 104px;
        }
      }

      #ei_tpl_search #input-question {
        box-shadow: none;
      }

      #ei_tpl_search button#search-head {
        top: 6px;
      }

      @media screen and (max-width: 1098px) {
        .popin-head .content-popin-head {
          width: calc(80% - 70px) !important;
        }
      }

      .popin-head #search {
        display: none;
      }

      .popin-head .faq-mail-display-form {
        text-decoration: underline;
        cursor: pointer;
      }

      .ei_appl_ident_blocbts {
        text-align: right;
      }


      /* SEARCH TRANSAC */


      /* CONTACTEZ NOUS TRANSAC */

      div#phone-head-content>div {
        height: 100%;
      }

      #contact-transac ul {
        margin-top: 30px;
      }

      #contact-transac ul li {
        background-color: #ffffff;
        margin-bottom: 10px;
        position: relative;
      }

      #contact-transac ul li[class*='ei_gly_']::before {
        position: absolute;
        top: 50%;
        transform: translateY(-50%);
        left: 20px;
        font-size: 20px;
        color: #dddddd;
      }

      #contact-transac ul li a {
        text-decoration: none;
      }

      #contact-transac ul li a p {
        font-weight: 700;
        width: 100%;
        padding: 15px 60px;
      }

      #contact-transac ul li a p span {
        color: #dddddd;
        font-size: 12px;
        font-weight: 100;
      }

      #phone-head-content div[id*='-open'] {
        display: none;
      }

      .content-contact-transac {
        overflow-y: auto;
      }

      .content-contact-transac p strong {
        font-weight: 700;
      }

      .content-contact-transac a {
        text-decoration: none;
        position: relative;
        font-weight: 700;
      }

      .content-contact-transac a span {
        margin: 20px 0;
      }

      .content-contact-transac a[class*='ei_gly_']::before {
        position: absolute;
        top: -2px;
        left: 0px;
        font-size: 20px;
      }

      .content-contact-transac .content-detail {
        background-color: #ffffff;
        padding: 1%;
        height: auto;
        position: relative;
        display: inline-block;
      }

      .content-contact-transac .content-detail {
        padding: 2em;
      }

      .content-contact-transac {
        height: calc(100% - 90px);
      }

      #contact-1-open>div>div:nth-child(6)>p {
        margin-left: 40px
      }

      #contact-1-open div p {
        font-weight: 400;
        margin: 20px 0 20px 0;
      }

      #contact-1-open div p strong {
        font-weight: 700;
      }

      #contact-1-open div div.etapex p {
        font-weight: 100;
      }

      #contact-1-open div a img.phone-image {
        width: 75%;
      }

      #contact-1-open div.content-detail {
        background-color: #ffffff;
      }

      #contact-1-open div.content-detail ul,
      #contact-2-open div.content-detail ul {
        padding: 4%;
      }

      #contact-1-open div.content-detail ul:nth-child(1),
      #contact-2-open div.content-detail ul:nth-child(1) {
        border-right: 1px solid #e2e2e2;
      }

      .content-contact-transac div.bloc-grey {
        background-color: #f8f8f8;
        position: relative;
        display: inline-block;
        padding: 2%;
      }

      .content-contact-transac .return-contact-transac {
        line-height: 90px;
        margin-left: 5%;
      }

      .content-contact-transac .intro {
        padding: 0 0 2% 5%;
      }

      .content-contact-transac div.bloc-grey ul {
        padding-right: 35px;
        line-height: 18px;
      }

      #contact-3-open ul li {
        margin-bottom: 50px;
        padding-left: 50px;
        position: relative;
      }

      #contact-3-open ul li::before {
        position: absolute;
        left: 0px;
        top: 0px;
        background-color: #bad606;
        border-radius: 50%;
        width: 35px;
        height: 35px;
        text-align: center;
        font-size: 20px;
        line-height: 35px;
      }

      #contact-3-open ul li p.conseil {
        color: #bad606;
        font-weight: 700;
        position: relative;
        padding-left: 20px;
        cursor: pointer;
      }

      #contact-3-open ul li p.conseil::before {
        content: '+';
        display: block;
        left: 0;
        top: 0;
        position: absolute;
        color: #ffffff;
        background-color: #bad606;
        width: 15px;
        height: 15px;
        text-align: center;
      }

      #contact-3-open ul li p.conseil.open::before {
        content: '-';
        display: block;
        line-height: 15px;
        left: 0;
        top: 0;
        position: absolute;
        color: #ffffff;
        background-color: #bad606;
        width: 15px;
        height: 15px;
        text-align: center;
      }

      #contact-3-open ul li p.conseil span {
        display: none;
        position: relative;
        background-color: #e2e2e2;
        color: #333333;
        font-weight: 400;
        padding: 15px;
        margin-top: 15px;
      }

      #contact-3-open ul li p.conseil span::before {
        position: absolute;
        top: -17px;
        left: 0;
        color: #e2e2e2;
        font-size: 30px;
      }

      #contact-4-open a p {
        padding: 20px 25px;
        background-color: #fff600;
        text-align: center;
        width: 300px;
        position: relative;
        left: 50%;
        transform: translateX(-50%);
      }

      #contact-4-open div.bloc-grey p:nth-child(2) {
        position: relative;
        left: 50%;
        transform: translateX(-50%);
        text-align: center;
      }

      #contact-5-open div p.steps {
        font-weight: 700;
        color: #bad606;
        margin: 30px 0 20px 0;
      }

      #contact-5-open div p strong {
        font-weight: 700;
      }

      #contact-5-open ul {
        margin-left: 20px;
      }

      #contact-5-open ul li strong {
        font-weight: 700;
      }

      #contact-5-open div.engage {
        background-color: #bad606;
        padding: 20px;
        margin-top: 40px;
      }

      #contact-5-open div.engage ul li {
        color: #333333
      }

      #contact-5-open div.engage ul li p strong {
        color: #ffffff;
        font-weight: 700;
      }

      #contact-6-open a:hover {
        color: #000000;
      }

      #contact-6-open a div.bloc-grey-other {
        background-color: #f8f8f8;
        padding: 2%;
        position: relative;
      }

      #contact-6-open a div.bloc-grey-other::before {
        font-family: "fts_commun";
        content: "\EBB6";
        position: absolute;
        top: 35px;
        right: 20px;
      }

      #contact-6-open div.bloc-grey-other img {
        width: 80px;
        height: auto;
      }

      #contact-6-open a div.bloc-grey-other p.inline {
        vertical-align: top;
        margin-left: 15px;
      }

      #contact-6-open a div.bloc-grey-other p:nth-child(3) {
        font-weight: 100;
        font-size: 12px;
      }

      #contact-6-open a:hover div.bloc-grey-other p.inline {
        color: #bad606
      }

      #contact-6-open a:hover div.bloc-grey-other::before {
        color: #bad606;
      }

      #contact-6-open div.contact-cf {
        background-color: #bad606;
        padding: 5%;
        position: relative;
      }

      #contact-6-open div.contact-cf ul {
        margin-bottom: 0;
      }

      #contact-6-open div.contact-cf ul.ulleft {
        width: 65%;
      }

      #contact-6-open div.contact-cf ul.ulright {
        width: 30%;
        position: absolute;
        top: 50%;
        transform: translateY(-50%);
        margin-left: 2em;
      }

      #contact-6-open div.contact-cf ul.ulright li {
        background-color: #ffffff;
        width: 100%;
        padding: 20px;
      }

      #contact-7-open div ul {
        margin-bottom: 0;
      }

      #contact-7-open div ul li {
        padding: 4em 2em 2em 2em;
        position: relative;
      }

      #contact-7-open div ul li[class*=ei_gly]::before {
        background-color: #bad606;
        padding: 10px;
        font-size: 25px;
        border-radius: 50%;
        position: absolute;
        top: 0;
        color: #ffffff;
      }

      #contact-7-open div ul li strong {
        font-weight: 700;
        margin-bottom: 20px;
      }

      #contact-7-open div ul li p {
        margin-top: 20px;
      }

      #contact-7-open div ul li ul li {
        display: inline-block;
      }

      .content-head ul li[class*='ei_gly_']:hover::before {
        color: #bad606 !important;
      }


      /* MENU MOBILE TOOLBOX VITRINE */

      #icon_toolbox_mobile_btn_open::before {
        line-height: 1.3;
      }

      #toolbox_mobile_content_choice div a::before {
        content: '';
      }


      /* FOOTER */

      .pre-footer {
        z-index: 0;
        padding: 25px 50px 25px 50px;
      }


      /* HP */

      .mask-img {
        position: relative
      }

      span.list-icon::before {
        position: absolute;
        top: 50%;
        left: 50%;
        transform: translate(-50%, -50%);
      }

      @media screen and (max-width: 1400px) {
        .col-xs-offset-2.popin-head {
          margin-left: 20%;
        }
      }

      @media screen and (max-width: 1220px) {
        #ei_tpl_blocident a div.verticalcenter span {
          display: none;
        }

        #ei_tpl_blocident a div.verticalcenter div.ei_gly_lock {
          font-size: 25px;
        }
      }

      @media screen and (max-width: 991px) {
        #ei_tpl_wcb_bt {
          display: none !important;
        }

        .popin-head .content-popin-head {
          width: 100% !important;
          margin-left: 0;
        }

        .popin-head .content-popin-head {
          background-color: #f8f8f8;
        }

        .col-xs-offset-2.popin-head {
          top: 50px;
          margin-left: 0
        }

        .popin-head #search {
          display: block;
          background-color: #f8f8f8;
        }

        #btn-faq a#linkNode::before {
          content: '';
        }

        a#search-head.changed::before {
          content: '\2715';
        }

        .close-popin-mobile {
          position: fixed;
          top: 53px;
          right: 8px;
          color: #ffffff;
          font-size: 50px;
          z-index: 10000;
          display: none;
          cursor: pointer;
        }

        #ei_tpl_blocident {
          width: 40px;
          display: block;
          top: -1px;
          position: relative;
        }

        #ei_tpl_blocident a {
          background-color: #000000;
          height: 49px;
        }

        /* #ei_tpl_blocident a::after {
        position: absolute;
        left: 9px;
        top: 15px;
    } */
        #ei_tpl_blocident a:hover::after {
          color: #bad606;
        }
      }


      /* MENU PRODUITS */

      .product_menu {
        line-height: 60px;
        text-align: center;
        font-weight: 700;
        border-bottom: 1px solid #e2e2e2;
        border-top: 1px solid #e2e2e2;
      }

      .product_menu ul {
        margin-bottom: 0;
      }

      .product_menu ul li a {
        font-weight: 700;
        text-decoration: none !important;
      }

      .product_menu ul li a div {
        width: 100%;
        height: 100%;
        border-right: 1px solid #e2e2e2;
        background-color: #ffffff;
        z-index: 0;
        position: relative;
      }

      .product_menu ul li.souscrire a div {
        background-color: #fff600;
      }

      .product_menu ul li a div::after {
        content: '';
        display: block;
        width: 0;
        transition: width 0.4s;
        background-color: #bad600;
        position: absolute;
        left: 0;
        top: 0;
        height: 100%;
        z-index: -1;
      }

      .product_menu ul li.souscrire a div::after {
        background-color: #ffffff;
        opacity: 0.5;
      }

      .product_menu ul li a:hover div::after {
        width: 100%
      }

      .product_menu ul li a:hover {
        color: #ffffff !important;
      }

      .product_menu ul li.souscrire a:hover {
        color: #000000 !important;
      }

      .product_menu ul li.active {
        background-color: #bad606;
        color: #ffffff;
        border-right: none;
      }

      .product_menu ul li.souscrire {
        border-right: none;
        margin-bottom: 0
      }

      .list-table {
        padding: 3%;
      }

      .smart_menu ul {
        margin-bottom: 0;
        z-index: 1000;
        position: relative;
      }

      .smart_menu ul li.active {
        text-align: left;
        padding-left: 2%;
        cursor: pointer;
      }

      .smart_menu ul li.active::after {
        content: "❯";
        display: block;
        position: absolute;
        right: 5%;
        top: 0;
        font-family: "fts_commun";
        transform: rotate(90deg);
      }

      .smart_menu ul li.active.open::after {
        content: "❯";
        display: block;
        position: absolute;
        right: 5%;
        top: 0;
        font-family: "fts_commun";
        transform: rotate(-90deg);
      }

      .smart_menu ul li.souscrire {
        background-color: #fff606;
      }

      .popin_sub_menu {
        position: fixed;
        width: 100%;
        height: 100%;
        background-color: rgba(0, 0, 0, 0.5);
        z-index: 100;
        top: 60px;
      }

      .sub_menu_smart {
        display: none;
        z-index: 100;
        position: absolute;
        width: 100%;
      }

      .sub_menu_smart li {
        background-color: #ffffff;
        text-align: left;
        padding-left: 10%;
      }

      #ei_tpl_blocbottom {
        position: fixed;
        bottom: 0;
      }

      @media only screen and (min-width: 1280px) {
        #ei_tpl_blocbottom {
          bottom: -50px;
        }
      }

      ul.list-prod li.prod-list-tab {
        font-size: 1.6rem;
        position: relative;
      }

      ul.list-prod li.prod-list-tab::after {
        content: '';
        width: 0;
        display: block;
        border-color: transparent #bad606;
        border-style: solid;
        border-width: 5px 0 5px 9px;
        position: absolute;
        top: 10px;
        left: -18px;
      }

      .ei_tpl_dolcredit .main_title {
        font-size: 3.6rem;
      }

      .ei_tpl_dolcredit table.saisie th>label,
      table.tab2dim th>label {
        font-size: 1.1em;
      }

      .ei_tpl_dolcredit .ei_idpe_form p.a_titre2 {
        font-size: 1.9em !important;
      }

      .ei_tpl_dolcredit table.fiche td a,
      .ei_tpl_dolcredit table.liste td a,
      .ei_tpl_dolcredit table.saisie td a,
      .ei_tpl_dolcredit table.tab2dim td a {
        font-weight: 700 !important;
        text-decoration: underline;
      }


      /*cédric: retour MOA SA0000035412792
#b12\3a D > div > div > p:nth-child(1) > strong{font-size:1.4rem;}
#b12\3a D > div > div > p:nth-child(3){font-size:1.4rem;line-height:1.42857em;}
.ei_tpl_dolcredit .ei_idpe_block.blocmsg .blocboutons a.idpe_btn_save {background-color:inherit!important;font-weight: 700!important;padding:0!important;font-size:1.4rem;font-weight:400!important;text-decoration:underline;}
*/

      #C2\3a pointinfo\2e F4_13\2e debit\3a span {
        text-align: right;
      }

      p.escaMenu {
        text-align: center;
      }

      img.escaMenu {
        width: 30%;
        height: auto;
        margin: auto;
      }

      .err {
        /*display:none;*/
      }


      /* PAGES PRODUITS */

      .jumb1otron {
        color: #333333;
        background-color: #bad606;
      }

      ol.listVisa li {
        padding: 0 !important
      }

      ol.listVisa li img {
        min-width: 45px;
        max-width: 80px;
        margin: 0 10px 0 0;
        float: left;
      }

      @media only screen and (min-width: 767px) {
        .product-detail-page .testemonials .video-section {
          z-index: 0;
        }

        .product-detail-page .other-products .col-sm-6+.col-sm-6 {
          width: 25%;
        }

        .product-detail-page .other-products .col-sm-6 {
          width: 75%;
        }

        #customer-area .customer-inner .customer-form input[type="text"],
        #customer-area .customer-inner .customer-form input[type="password"] {
          width: 100%;
        }

        #customer-area .customer-inner .customer-form .form-link {
          color: #000;
          display: block;
          margin: 15px 0 10px 0;
        }
      }


      /* CTC EN RESUME */

      .white-icon {
        line-height: 75px;
      }


      /* CTC SOUSCRIPTION */

      .souscription ul.list-prod li.prod-list-tab:after {
        content: "";
        width: 0;
        display: block;
        border-color: transparent #bad606;
        border-style: solid;
        border-width: 5px 0 5px 9px;
        position: absolute;
        top: 10px;
        left: -18px;
      }

      @media only screen and (max-width: 992px) {
        .product-offers p {
          max-width: 100% !important;
        }

        #ei_tpl_blocbottom {
          width: 100% !important;
        }
      }


      /* PLAN DU SITE */

      .pages-divers-titre ul.puce-list {
        padding: 0 30px;
      }

      .pages-divers {
        padding-left: 20px;
      }

      .pages-divers p.list-items a {
        font-weight: bold;
      }


      /* APPLICATION MOBILE */

      .resp-desktop {
        display: block;
        width: 100%;
      }

      @media screen and (max-width: 991px) {
        .resp-desktop {
          display: none;
        }

        .resp-mobile {
          display: block;
          width: 100%;
        }

        .product_menu ul li a div::after {
          background-color: #fff;
        }

        .product_menu ul li a:hover {
          color: initial;
        }

        .sub_menu_smart li {
          padding-left: 20px;
        }

        #ei_tpl_blocbottom .prm-button {
          width: 100%;
          background-color: #000;
        }

        .credit .advantages ul:last-of-type {
          margin-top: 0em !important;
        }
      }


      /* QUESTIONS REPONSES */

      div#search form div.search-block {
        width: calc(84%);
      }

      .just-clt-search {
        display: none;
      }

      #input-question-mob-clt {
        border: none;
        width: 81%;
        padding: 15px 20px;
        color: #333333;
      }

      #btn-question-mob-clt {
        border: none;
        background-color: #000000;
        color: #ffffff;
        padding: 15px;
      }

      #ei_tpl_search_m a.btn-faq-link::before {
        content: "";
      }

      @media (min-width: 1200px) {
        .inbenta-interface .container {
          max-width: 100% !important;
        }
      }


      /* AVIS */

      #ei_tpl_ariane>span:nth-child(5)>em,
      #ei_tpl_ariane>span:nth-child(5)>span {
        display: none;
      }


      /* FOOTER */

      footer {
        clear: both
      }

      footer .phone-image {
        margin-bottom: 20px;
        display: block;
        width: 100%;
        height: auto;
        min-height: 19px
      }

      footer .download-box {
        position: relative;
        margin-bottom: 20px
      }

      footer .download-box a {
        font-weight: 700;
        position: absolute;
        top: 50%;
        left: 70px;
        transform: translateY(-50%);
        display: inline-block;
        min-width: 130px;
        max-width: 200px;
        color: #333;
        text-decoration: none
      }

      footer .download-box a:hover {
        color: #b3ce00
      }

      footer .download-box img {
        float: left;
        border: 3px solid #fff;
        -webkit-box-shadow: 4px 10px 16px rgba(0, 0, 0, .22);
        -moz-box-shadow: 4px 10px 16px rgba(0, 0, 0, .22);
        box-shadow: 4px 10px 16px rgba(0, 0, 0, .22);
        margin-right: 10px;
        width: 64px
      }

      footer .footer-col-1 {
        padding: 50px;
      }

      footer .footer-col-1 p.tel-footer {
        margin: 0
      }

      footer .footer-col-1 #list-network {
        padding: 0;
        overflow: hidden;
        border-top: 2px #494949 solid
      }

      footer .footer-col-1 #list-network li {
        list-style: none;
        padding: 0;
        margin: 0;
        display: block;
        background: #494949;
        text-align: center;
        float: left;
        border-right: 2px #fff solid
      }

      footer .footer-col-1 #list-network li a {
        display: inline-block;
        width: 50px;
        height: 50px;
        line-height: 50px;
        text-decoration: none
      }

      footer .footer-col-1 #list-network li a .use-fb-icon,
      footer .footer-col-1 #list-network li a .use-twitter-icon,
      footer .footer-col-1 #list-network li a .use-youtube-icon {
        fill: #fff
      }

      footer .footer-col-1 a.lien_tarifs {
        display: block;
        text-transform: uppercase;
        font-weight: 700;
        font-size: 1.1rem;
        text-decoration: none
      }

      footer .footer-col-2 {
        padding: 50px
      }

      footer .footer-col-2 .sitemap {
        width: 100%;
        font-weight: 400;
        text-align: left;
        background: #494949;
        font-size: 1.5rem;
        margin-bottom: 30px;
        margin-top: 10px;
        padding-left: 10px
      }

      footer .footer-col-2 .sitemap:hover {
        background: #494949;
        border: none
      }

      footer .footer-col-2 .sitemap .caret {
        border-bottom: 8px dashed;
        position: absolute;
        right: 15px;
        top: 20px
      }

      footer .footer-col-2 .sitemap-menu {
        padding: 15px 0 0;
        border: none;
        border-radius: 0;
        width: 100%;
        z-index: 10000
      }

      footer .footer-col-2 .sitemap-menu li {
        color: #494949;
        list-style: none;
        margin-bottom: 10px
      }

      footer .footer-col-2 .sitemap-menu li a {
        color: #494949;
        padding: 0;
        text-decoration: none;
        font-weight: bold;
      }

      footer .footer-col-2 .sitemap-menu li a:hover {
        background: 0 0
      }

      footer .footer-col-2 .sitemap-menu li ul {
        padding: 0
      }

      footer .footer-col-2 .sitemap-menu li ul li {
        margin-bottom: 0
      }

      footer .footer-col-2 .footer-menu {
        /* padding:0; */
        text-align: left
      }

      footer .footer-col-2 .footer-menu li {
        list-style: none;
        display: inline-block
      }

      footer .footer-col-2 .footer-menu li a {
        position: relative;
        padding-right: 10px;
        color: #494949;
        text-decoration: none
      }

      footer .footer-col-2 .footer-menu li:not(:last-child) a:after {
        content: "";
        display: inline;
        position: absolute;
        top: 0;
        right: 1px;
        width: 1px;
        height: 17px;
        background: #494949
      }

      footer .footer-col-2 .btn-primary.active,
      footer .footer-col-2 .btn-primary:active,
      footer .footer-col-2 .open>.btn-primary.dropdown-toggle {
        background: #494949
      }


      /* AUTHENTIFICATION */

      .ei_appl_ident_lig:nth-child(4) {
        display: none;
      }


      /* ETAPE 0 */

      div.landing-page form select#IDPETIETITRE {
        font-size: 1.4rem;
      }

      input.btn-valider {
        min-width: 300px;
      }


      /* PAGES PRODUITS TRANSAC */

      .fill-it {
        background-color: #bad606 !important;
        padding: 2em;
      }

      .ei_tpl_trproduit #ei_tpl_content {
        padding-left: 0px;
        padding-right: 0px;
      }

      .products {
        min-height: 300px;
        /* background: url(/fr/images/ajax-loader.gif) no-repeat center center; */
      }


      /* DETAIL OPERATION COMPTE 
//.a_blocongh ul:before {bottom: 1px!important;}
*/


      /*MANDAT DE PRELEVEMENT*/

      div.pdt-det div.pdt-det-ban {
        background-color: #bad606;
        color: #333333;
        padding: 30px 50px;
        font-weight: 700;
      }

      div.pdt-det div.pdt-det-ban h1,
      div.pdt-det div.pdt-det-ban h4 {
        font-weight: 700;
      }

      .greyBlock {
        background-color: #f8f8f8;
        margin: 3em 0 2em 5em;
        font-size: 1.3em;
      }

      .leftBlock h2 {
        font-size: 27px;
        font-weight: 700;
      }

      .inherGreyBlock {
        margin-left: 3%;
        margin-top: 3%;
        padding-bottom: 5%;
      }

      .greyBlock h3 {
        color: #bad606;
        margin-bottom: 1.3%;
      }

      .greyBlock ol {
        list-style: none;
        counter-reset: li;
        margin: 0 0 2.5% 2%;
      }

      .greyBlock li {
        counter-increment: li;
        margin-bottom: 0.5%;
      }

      .greyBlock li::before {
        content: counter(li);
        color: #bad606;
        ;
        display: inline-block;
        width: 1.2em;
        font-size: 1.5em;
        margin-left: -1em;
        font-weight: bold;
      }

      .leftBlock {
        padding-left: 2%;
        font-size: 1.1em;
      }

      .border2 {
        border-bottom: 3px solid #000;
        line-height: 0px;
        width: 60px;
        margin: 0 0 3em;
      }

      .whiteBorder {
        border-bottom: 5px solid #FFF;
        margin-top: 5%;
        width: 100px;
      }

      .whiteTitle {
        font-size: 4em;
        font-weight: 700;
      }

      .chev::before {
        content: "\002023";
        position: absolute;
        color: #FFF;
        background-color: #bad630;
        font-size: 1.8em;
        font-weight: bold;
        border-radius: 50%;
        width: 24px;
        height: 24px;
        line-height: 22px;
        text-align: center;
      }

      .leftblock h3 {
        color: #bad606;
        margin-left: 2em;
        margin-bottom: 1em;
        font-size: 20px;
      }

      .leftBlock ul {
        list-style: none;
        margin-left: 4%;
      }

      .leftBlock li::before {
        content: "\00203A";
        color: #bad606;
        position: absolute;
        font-size: 1.5em;
        margin: -0.75% 0 0 -0.65em;
      }

      .leftBlock li {
        margin-top: 1.2em;
      }

      .content-ordi {
        padding-left: 5%;
      }

      .margX {
        margin: 6% 0;
      }

      .absol {
        position: absolute;
        width: 65%;
      }

      .rela {
        position: relative;
        top: 23px;
        left: 23px;
        width: 68%;
      }

      .faq-mandat {
        padding: 4em 0;
        display: inline-block;
        background:
          /*savepage-url=/fr/images/Image_FAQ2.jpg*/
          url();
        background-size: cover;
      }

      .faq-mandat h1 {
        color: #FFF;
      }

      .iAstuce::before {
        content: "i";
        position: absolute;
        color: black;
        font-size: 1em;
        font-weight: bold;
        border-radius: 50%;
        width: 20px;
        height: 20px;
        line-height: 20px;
        text-align: center;
        margin-right: 15px;
        background-color: #f0f1f3;
      }

      .argfaq ul li {
        background-color: #ffffff;
        padding: 15px 35px;
        position: relative;
        box-shadow: 0 1px 0 0 #c8c8c8;
        cursor: pointer;
        list-style: none;
      }

      .argfaq ul li.faqclose::after {
        content: '+';
        display: block;
        font-size: 30px;
        width: 14px;
        height: 14px;
        position: absolute;
        right: 50px;
        top: 25px;
      }

      .argfaq ul li.faqopen::after {
        content: '-';
      }

      .argfaq ul li hr {
        margin-bottom: -10px;
      }

      .argfaq ul li p {
        color: #000000;
        font-size: 14px;
        width: 100%;
        display: none;
      }

      .argfaq ul li p img {
        width: 100%;
      }

      .argfaq ul li h2 {
        color: #000000;
        font-size: 18px;
        font-weight: 700;
        width: 80%;
      }

      .spanAstuce {
        margin: 0 3% 0 2%;
      }

      .ml-X {
        margin-left: 5%;
      }

      .mt-5 {
        margin-top: 5%;
      }

      .mt-3 {
        margin-top: 3%;
      }

      .attention {
        background-color: #f0f1f3;
        padding: 2% 5%;
        font-size: 1.2em;
      }

      @media screen and (max-width: 1400px) {
        .rela {
          width: 65%;
        }
      }

      @media screen and (max-width:768px) {
        .ml-X {
          margin-left: 9%;
        }

        .mt-X {
          margin-top: 0em;
        }

        div.pdt-det div.pdt-det-ban {
          padding: 10px 20px;
        }

        div.pdt-det div.pdt-det-ban h1 {
          font-size: 1.6em;
          margin-top: 1%;
        }

        div.pdt-det div.pdt-det-ban h4 {
          font-size: 1.2em;
        }

        .greyBlock {
          margin: 1em 0 2em 1.3em;
          padding: 5%;
          font-size: 1em;
        }

        .greyBlock h3 {
          font-size: 1.05em;
          font-weight: bold;
        }

        .greyBlock ol {
          padding-inline-start: 0%;
          margin: 1em 0 2em 0;
        }

        .greyBlock li::before {
          margin-left: 0;
          font-weight: normal;
          width: 0.95em;
          font-size: 1.3em;
        }

        .greyBlock li {
          margin-bottom: 5%;
        }

        .leftBlock {
          padding-left: 5%;
        }

        .leftBlock h2 {
          font-size: 1.2em;
          font-weight: bold;
          margin-bottom: 10%;
        }

        .leftBlock h3 {
          font-size: 1.05em;
          font-weight: bold;
          margin-bottom: 8%;
          margin-left: 0;
        }

        .leftBlock ul {
          margin-left: 0;
          padding-inline-start: 10px;
        }

        .leftBlock li::before {
          margin: -1.5% 0 0 -0.5em;
        }

        .whiteTitle {
          font-size: 2.4em;
        }

        .whiteBorder {
          width: 60px;
          margin-bottom: 1.5em;
        }

        .iAstuce::before {
          color: #FFF;
          background-color: #bad606;
        }
      }


      /*Pour IE */

      @media screen and (-ms-high-contrast: active),
      (-ms-high-contrast: none) {
        @media screen and (max-width: 768px) {
          .spanAstuce {
            margin: 0;
          }

          .ml-X {
            margin-bottom: 1em;
          }
        }
      }


      /*END MANDAT */


      /*PAGES ANNEXE CLIENT */

      .content-clt .bgwhite {
        background-color: #ffffff;
      }

      .content-clt .bggrey {
        background-color: #e2e2e2;
      }

      .content-clt .bggreen {
        background-color: #bad606;
      }

      .content-clt .contentpad {
        padding: 3em 2em
      }

      .content-clt .titlecontent {
        color: #ffffff;
        padding: 1em;
        background-color: #bad606;
        font-weight: 700;
        margin-bottom: 0;
        margin-top: 0;
      }

      .content-clt .content {
        display: inline-block;
        position: relative;
        vertical-align: bottom;
      }

      #ei_tpl_content>div:nth-child(2)>div.col-xs-12.bgwhite.content {
        padding: 1em;
      }

      .content-clt .content a {
        color: #bad606;
        font-weight: 700;
        text-decoration: none;
        position: relative;
      }

      .content-clt .content p {
        line-height: 30px;
        font-size: 17px;
        padding-top: 0px;
      }

      .content-clt.content-clt-dispense .contentpad {
        padding: 1em;
        position: relative;
      }

      .content-clt.content-clt-dispense .contentpad[class*=ei_gly]::before {
        position: absolute;
        top: 20px;
      }

      .content-clt.content-clt-dispense .contentpad ul li {
        position: relative;
        padding-left: 20px;
      }

      .content-clt.content-clt-dispense .contentpad ul li::before {
        position: absolute;
        left: 0;
        top: 7px;
      }

      .content-clt.content-clt-dispense .contentpad h2 {
        margin-top: 85px;
      }

      .content-clt .content .contentpad:nth-child(1) {
        border-right: 1px solid #e2e2e2;
      }

      .content-clt .content .ei_gly_ic_euro_symbol {
        height: 100%;
        position: absolute;
        right: 0;
      }

      .content-clt .content .ei_gly_ic_euro_symbol::before {
        font-size: 45px;
        font-weight: 700;
        background-color: #ffffff;
        border-radius: 50%;
        padding: 8px;
      }

      .content-clt .content .ei_gly_mbq-document::before {
        font-size: 33px;
        font-weight: 700;
        background-color: #bad606;
        border-radius: 50%;
        padding: 14px;
        color: #ffffff;
        top: 20px;
      }

      .content-clt.content-clt-procu .contentpad.bggrey {
        text-align: center;
      }

      .content-clt.content-clt-procu .contentpad.bggrey img {
        width: 100%;
        max-width: 500px;
      }

      .content-clt.content-clt-procu .contentpad a span {
        background-color: #BAD606;
        color: #000000;
        position: relative;
        z-index: 0;
        text-align: center;
        line-height: 60px;
        padding: 0;
        width: 100%;
        max-width: 250px;
        margin-top: 40px;
      }

      .content-clt .content .onglets {
        height: 60px;
        color: #333333;
        font-weight: 700;
        text-align: center;
        padding-top: 12px;
        background-color: #ffffff;
        border: 1px solid #e2e2e2;
        cursor: pointer;
      }

      .content-clt .content .ongletselect {
        color: #ffffff;
        background-color: #bad606;
        position: relative;
      }

      .content-clt .content .ongletselect::before {
        position: absolute;
        bottom: -20px;
        left: 50%;
        color: #bad606;
        z-index: 1;
        transform: translateX(-50%);
        font-size: 35px;
      }

      .content-clt.content-clt-rdc .content .contentrdc {
        border: 1px solid #e2e2e2;
        text-align: center;
      }

      .content-clt.content-clt-rdc .content p.ei_gly_ic_arrow_drop_right {
        margin: 30px 0;
        position: relative;
      }

      .content-clt.content-clt-rdc .content p.ei_gly_ic_arrow_drop_right::before {
        position: absolute;
        color: #000000;
        padding: 5px;
        border-radius: 50%;
        left: -50px;
        top: 50%;
        transform: translateY(-50%);
        font-size: 35px;
      }

      .content-clt.content-clt-rdc .content p.ei_gly_mbq-cheque::before {
        color: #ffffff;
        background-color: #bad606;
        position: absolute;
        font-size: 35px;
        padding: 10px;
        border-radius: 50%;
        left: -70px;
      }

      .content-clt.content-clt-rdc .content .contentcourrier p.ei_gly_ic_arrow_drop_right {
        padding-left: 20px;
      }

      .content-clt.content-clt-rdc .content .contentcourrier p.ei_gly_ic_arrow_drop_right::before {
        font-size: 15px;
        left: -5px;
        top: 13px;
      }

      .content-clt.content-clt-rdc .content .contentrdc p {
        margin: 30px 0;
        padding: 1em;
      }

      .content-clt.content-clt-rdc .content .contentrdc .steps {
        text-align: left;
      }

      .content-clt.content-clt-rdc .content .contentcourrier a {
        margin: 30px 0;
      }

      .content-clt.content-clt-rdc .content .contentcourrier .bggreen {
        text-align: left;
        color: #ffffff;
        padding: 2em;
      }

      .content-clt.content-clt-rdc .content .contentcourrier .bggreen h2 {
        font-size: 20px;
        font-weight: 700;
        position: relative;
        margin-bottom: 50px;
      }

      .content-clt.content-clt-rdc .content .contentcourrier .bggreen h2::after {
        position: absolute;
        content: '';
        display: block;
        width: 40px;
        border-bottom: 1px solid #333333;
        bottom: -20px;
      }

      .content-clt.content-clt-rdc .content .contentcourrier .bggreen h3 {
        font-size: 18px;
        font-weight: 700;
      }

      .content-clt.content-clt-rdc .content .contentcourrier .bggreen p {
        padding-top: 0;
        font-size: 18px;
        color: #333333;
        margin-top: 10px;
      }

      .content-clt.content-clt-rdc .content .contentcourrier .bggreen .info {
        background-color: #ffffff;
        color: #333333;
        width: 100%;
        margin: 0 auto;
        padding: 20px 20px 20px 60px;
        position: relative;
        border: none;
      }

      .content-clt.content-clt-rdc .content .contentcourrier .bggreen .info::before {
        position: absolute;
        left: 15px;
        top: 50%;
        font-size: 30px;
        transform: translateY(-50%);
      }

      .content-clt.content-clt-rdc .content .contentcourrier .bggreen .exemple {
        text-align: center;
        margin: 40px 0;
      }

      .content-clt.content-clt-rdc .content .contentcourrier .bggreen table {
        margin: 0 auto 50px auto;
        width: 100%;
      }

      .content-clt.content-clt-rdc .content .contentcourrier .bggreen table tr td {
        background-color: #ffffff;
        color: #333333;
        text-align: center;
        padding: 2%;
        border: 1px solid #bad606;
        box-sizing: border-box;
      }

      .content-clt.content-clt-rdc .content .contentcourrier .bggrey {
        padding: 20px;
        background-color: #f8f8f8;
      }

      .content-clt.content-clt-rdc .content .contentgab p {
        text-align: left;
        padding: 1em;
      }

      .content-clt.content-clt-rdc .content .contentrdc p span {
        color: #bad606;
      }

      .content-clt.content-clt-rdc .content .contentgab .bggrey {
        padding: 20px;
        background-color: #f8f8f8;
      }

      .content-clt.content-clt-rdc .content .contentgab .bggrey p {
        text-align: center;
      }

      .content-clt.content-clt-rdc .content .contentgab .bggrey .steps p {
        text-align: left;
      }

      .content-clt.content-clt-rdc .content .cta-grey p {
        width: 100%;
        max-width: 400px;
        height: 60px;
        background-color: #333333;
        color: #ffffff !important;
        font-weight: 700;
        z-index: 0;
        position: relative;
        text-align: center;
        line-height: 60px;
        margin: 0;
      }

      .content-clt.content-clt-rdc .content .cta-grey p::after {
        content: '';
        display: block;
        position: absolute;
        left: 0;
        top: 0;
        height: 100%;
        width: 0%;
        background-color: #ffffff;
        opacity: 0.2;
        z-index: -1;
        transition: width 0.4s;
      }

      .content-clt.content-clt-rdc .content .cta-grey:hover p::after {
        width: 100%;
      }

      .content-clt.content-clt-rdc .content .mobalone p.ei_gly_ic_arrow_drop_right::before {
        font-size: 20px;
        left: 25px;
        color: #bad606;
      }

      .content-clt.content-clt-rdc .content .mobalone p.ei_gly_ic_arrow_drop_right {
        font-size: 17px;
        padding-left: 60px;
        margin: 0;
      }

      .content-clt.content-clt-clos .content .contentclos {
        border: 1px solid #e2e2e2;
        padding: 1em;
      }

      .content-clt.content-clt-clos .content .contentclos p.ei_gly_ic_info {
        position: relative;
        padding-left: 60px;
        width: 80%;
        margin: 50px auto;
      }

      .content-clt.content-clt-clos .content .contentclos p.ei_gly_ic_info::before {
        position: absolute;
        color: #bad606;
        font-size: 35px;
        left: 7px;
        top: 50%;
        transform: translateY(-50%);
      }

      .content-clt.content-clt-clos .content .contentclos form {
        margin-top: 50px;
      }

      .content-clt.content-clt-clos .content .contentclos form h3 {
        font-size: 17px;
        font-weight: 700;
      }

      .content-clt.content-clt-clos .content .contentclos form p {
        display: flex;
        padding-top: 0;
      }

      .content-clt.content-clt-clos .content .contentclos form input[type=text] {
        width: 100%;
        height: 40px;
        max-width: 430px;
      }

      .content-clt.content-clt-clos .content .contentclos form input[type=radio] {
        position: relative;
        margin-top: 7px;
      }

      .content-clt.content-clt-clos .content .contentclos form input[type=radio]::before {
        content: '';
        display: block;
        position: absolute;
        width: 15px;
        height: 15px;
        left: -2px;
        top: 0;
        background-color: #ffffff;
        border: 1px solid #e2e2e2;
        border-radius: 50%;
      }

      .content-clt.content-clt-clos .content .contentclos form input[type=radio]::after {
        content: '';
        display: none;
        position: absolute;
        width: 9px;
        height: 9px;
        left: 1px;
        top: 3px;
        background-color: #bad606;
        border-radius: 50%;
      }

      .content-clt.content-clt-clos .content .contentclos form input[type=radio]:checked::after {
        display: block;
      }

      .content-clt.content-clt-clos .content .contentclos form label {
        margin-left: 10px;
      }

      .content-clt.content-clt-clos .content .contentclos form div.taright label {
        margin-left: 0;
      }

      .content-clt.content-clt-clos .content .contentclos form div.taright+input {
        margin-bottom: 20px;
      }

      #formcloslivetape1>p:nth-child(16)>label {
        margin-left: 14px;
      }

      .content-clt.content-clt-clos .content .contentclos form div.buttons {
        text-align: center;
        margin-top: 20px;
      }

      .content-clt.content-clt-clos .content .contentclos form div.buttons button {
        width: 200px;
        border: none;
        background-color: #BAD606;
        color: #333333;
        height: 50px;
        font-weight: 700;
        position: relative;
        z-index: 0;
        font-size: 17px;
      }

      .content-clt.content-clt-clos .content .contentclos form div.buttons button::after {
        content: '';
        position: absolute;
        width: 0%;
        background-color: #ffffff;
        height: 100%;
        z-index: -1;
        left: 0;
        top: 0;
        opacity: 0.5;
        transition: width 0.4s;
      }

      .content-clt.content-clt-clos .content .contentclos form div.buttons button:hover::after {
        width: 100%;
      }

      .content-clt.content-clt-clos .content .contentclos form div.buttons a p {
        width: 200px;
        border: none;
        background-color: #000000;
        color: #ffffff;
        height: 50px;
        font-weight: 700;
        position: relative;
        z-index: 0;
        line-height: 50px;
        display: inline-block;
        margin-left: 30px;
        cursor: pointer;
      }

      .content-clt.content-clt-clos .content .contentclos form div.buttons a p::after {
        content: '';
        position: absolute;
        width: 0%;
        background-color: #ffffff;
        height: 100%;
        z-index: -1;
        left: 0;
        top: 0;
        opacity: 0.3;
        transition: width 0.4s;
      }

      .content-clt.content-clt-clos .content .contentclos form div.buttons a:hover p::after {
        width: 100%;
      }

      .content-clt.content-clt-clos .content .contentclos form#formclosliv {
        display: none
      }

      .content-clt.content-clt-clos .content .contentclos form#formclosliv div.taright2 {
        display: inline-block;
        width: 50%;
        text-align: right;
      }

      .content-clt.content-clt-clos .content .contentclos form#formclosliv input {
        border: none;
        width: 45%;
        margin-left: 8px;
      }

      .content-clt.content-clt-clos .content .contentclos .helpover {
        display: table-cell;
        position: relative;
        vertical-align: bottom;
        bottom: 8px;
      }

      #ei_tpl_content>div:nth-child(3)>div.main_flex>div.main_content>div>div.col-xs-12.bgwhite.content>div>div.col-xs-12.contentcloslivret.contentclos>div>p {
        display: table-cell;
      }

      .content-clt.content-clt-clos .content .contentclos .helpover span {
        display: none;
        position: absolute;
        width: 200px;
        background-color: #747474;
        color: #ffffff;
        left: -200px;
        top: 40px;
        padding: 5px;
        z-index: 1;
      }

      #formcloslivetape1>div.helpover>span {
        top: 45px;
      }

      .content-clt.content-clt-clos .content .contentclos .helpover img:hover+span {
        display: block;
      }

      #formcloslivetape1>div:nth-child(23) {
        display: table-cell;
      }

      #formcloslivetape1>div.helpover {
        bottom: 16px;
        left: 5px;
      }

      #ei_tpl_content>div:nth-child(2)>div>div.col-xs-12.bgwhite.content>div>div.col-xs-12.contentcloslivret.contentclos>div>p {
        display: table-cell;
      }

      #formclosccetape1>div:nth-child(24),
      #formclosccetape1>div:nth-child(28) {
        display: table-cell;
      }

      #formclosccetape1>div:nth-child(25),
      #formclosccetape1>div:nth-child(29) {
        bottom: 17px;
      }

      #formclosccetape1>div:nth-child(27)>span {
        top: 48px;
      }

      .pages-divers .pages-divers-titre h2 {
        font-size: 35px;
        position: relative;
        margin-top: 30px;
      }

      .pages-divers .pages-divers-titre h2::before {
        position: absolute;
        content: '';
        display: block;
        border-bottom: 2px solid #333333;
        width: 50px;
        bottom: -5px;
      }

      .pages-divers .pages-divers-titre div {
        float: none;
      }


      /* table.saisie td {
    vertical-align: middle;
} */

      table.saisie td label {
        padding-top: 0;
      }


      /* SYNTHESE */

      #C\3a P\3a F>div.a_blocappli>div._c1.a_blocfctltitre._c1 {
        display: none;
      }


      /* GAME */

      .main_game:empty {
        display: none;
      }

      .game_home .main_game {
        padding-top: 20px;
      }

      .game_zone {
        position: relative;
        width: 100%;
        left: 50%;
        transform: translateX(-50%);
      }

      .header_game img,
      .footer_game img {
        width: 100%;
        max-height: 300px;
        height: auto;
      }


      /* .main_game {max-width: inherit!important;width:20%;} */

      .main_game img {
        width: 100%;
        height: auto;
      }

      .footer_game {
        margin-top: 40px;
      }

      .header_game table {
        width: 70%;
        min-height: 50px;
        margin: 0 auto;
      }

      .header_game table tr td strong {
        font-weight: 700;
      }

      .bx-viewport {
        min-height: 50px;
      }

      .bx-wrapper {
        box-shadow: none !important;
        min-height: 50px;
      }

      .bx-wrapper .bx-controls-direction a {
        opacity: 0.3;
      }

      .bx-wrapper .bx-pager.bx-default-pager a {
        background: #c2c2c2 !important;
      }

      .bx-wrapper .bx-pager.bx-default-pager a.active,
      .bx-wrapper .bx-pager.bx-default-pager a:focus {
        background: #000 !important
      }

      ;

      @media screen and (max-width:991px) {
        .content-clt .content .ei_gly_ic_euro_symbol {
          position: relative;
        }

        .content-clt .content .contentpad:nth-child(1) {
          border-right: none;
          border-bottom: 1px solid #e2e2e2;
        }

        .content-clt.content-clt-rdc .content .contentpad:nth-child(1) {
          border-right: none;
        }

        .content .contentpad {
          padding: 0
        }

        .content-clt.content-clt-rdc .content .contentpad:nth-child(2) {
          padding-top: 0;
        }

        .content-clt.content-clt-rdc .content .contentrdc .steps {
          text-align: center;
          padding: 1em;
        }

        .content-clt.content-clt-rdc .content p.ei_gly_mbq-cheque::before {
          left: 50%;
          top: 0px;
          transform: translateX(-50%) !important;
          transform: translateY(0);
        }

        .content-clt.content-clt-rdc .content .contentgab p.ei_gly_mbq-cheque::before {
          top: -24px;
        }

        .content-clt.content-clt-rdc .content p.ei_gly_ic_info::before {
          left: 15px;
        }

        .content-clt.content-clt-rdc .content .contentcourrier .bggreen {
          padding: 1em;
        }

        .content-clt.content-clt-rdc .content p.ei_gly_ic_arrow_drop_right::before {
          transform: none;
        }

        .content-clt.content-clt-rdc .content .contentcourrier .bggreen p {
          font-size: 12px;
          padding-top: 0;
        }

        .content-clt.content-clt-rdc .content .contentgab .bggrey {
          padding: 0
        }

        .content-clt.content-clt-rdc .content .contentgab .bggrey .steps p {
          text-align: center
        }

        .content-clt.content-clt-clos .content .contentclos form div.buttons a p {
          margin-top: 20px;
          margin-left: 0;
        }

        .content-clt.content-clt-clos .content .contentclos p {
          padding-top: 0;
        }

        .content-clt.content-clt-clos .content .contentclos form input[type=radio] {
          margin-left: 0;
        }

        .content-clt.content-clt-procu .contentpad {
          padding: 1em;
        }

        .content-clt.content-clt-clos .content .contentclos form#formclosliv div.taright2 {
          text-align: center;
          width: 100%;
          margin-top: 1em;
          font-weight: 700;
        }

        .content-clt.content-clt-clos .content .contentclos form#formclosliv input {
          width: 100%;
          text-align: center;
          max-width: 100%;
        }
      }

      @media screen and (max-width: 767px) {

        /* Button */
        .box-btn {
          margin-left: 0;
        }

        #premierconnexion .confirmation-phone .btn_hover span {
          width: 100%;
        }

        /* Confirmation numéro de téléphone */
        #premierconnexion section.infos article {
          float: left;
          display: block;
        }

        #premierconnexion section.infos article:first-child,
        #premierconnexion section.infos article:last-child {
          border: none;
        }

        .confirmation-phone li span:first-child {
          display: block;
          text-align: center;
          padding-bottom: 0.5em;
        }

        .confirmation-phone li span:last-child {
          width: 100%;
        }

        .confirmation-phone span.number {
          padding-right: 0;
        }

        .confirmation-phone .box-btn {
          margin-top: 20px;
          width: 100%;
        }

        #premierconnexion section.infos article:first-child {
          border-bottom: 1px solid #ccc;
          border-right: none;
        }

        #premierconnexion section.infos article:last-child {
          border-top: 1px solid #ccc;
          border-left: none;
        }

        #premierconnexion section.infos {
          padding: 0 2em;
        }

        #premierconnexion section.infos article {
          padding: 3em 0;
        }

        #premierconnexion .confirmation-phone {
          padding-left: 1em;
          padding-right: 1em;
        }

        #premierconnexion .confirmation-phone .confirm {
          text-align: center;
        }

        .dropdown-menu .disp-p {
          padding: 0 15px;
        }

        /* #ei_tpl_menuPrincipal>nav>ul>li>a {padding:2% 0!important;} */
        img.escaMenu {
          width: 25%;
        }
      }

      .mCS-ei-theme.mCSB_scrollTools .mCSB_draggerRail {
        background-color: #989898;
      }

      .mCS-ei-theme.mCSB_scrollTools .mCSB_dragger .mCSB_dragger_bar {
        background-color: #949494;
      }


      /* ARCEP */

      div.arcepgratuit {
        background:
          /*savepage-url=/fr/images/arcep/SGAG.png*/
          url() no-repeat center center;
        width: 220px;
        height: 30px;
        padding: 8px 0 0 20px;
        color: #78b41e;
        display: inline-block;
      }

      div.arcepgratuit a:hover {
        color: #78b41e;
      }

      .mnq_normtelCRISTAL {
        background:
          /*savepage-url=/fr//images/arcep/cristal.png*/
          url() center 0px no-repeat !important;
        font-size: 13px !important;
        color: #6A6A6A !important;
        font-weight: bold !important;
        text-align: right !important;
        padding: 0px 19px 0 0px !important;
        width: 205px !important;
        height: 26px !important;
        margin: 0 !important;
        display: inline-block !important;
        line-height: 22px;
      }

      .mnq_normtelSPPA4 {
        background:
          /*savepage-url=/fr//images/arcep/SPPA4.png*/
          url() center 0px no-repeat !important;
        font-size: 17px !important;
        color: #a50f78 !important;
        font-weight: bold !important;
        text-align: left !important;
        padding: 3px 19px 0 10px !important;
        width: 225px !important;
        height: 26px !important;
        margin: 0 !important;
        display: inline-block !important;
        line-height: 22px;
      }

      .mnq_normtelSPPA {
        background:
          /*savepage-url=/fr//images/arcep/SPPA.png*/
          url() center 0px no-repeat !important;
        font-size: 17px !important;
        color: #a50f78 !important;
        font-weight: bold !important;
        text-align: left !important;
        padding: 3px 19px 0 10px !important;
        width: 225px !important;
        height: 26px !important;
        margin: 0 !important;
        display: inline-block !important;
        line-height: 22px;
      }

      .arcepgratuit {
        background:
          /*savepage-url=/fr/images/arcep/SGAG.png*/
          url() center 0px no-repeat !important;
        font-size: 17px !important;
        color: #74b844 !important;
        font-weight: bold !important;
        text-align: left !important;
        padding: 3px 19px 0 18px !important;
        width: 225px !important;
        height: 26px !important;
        margin: 0 !important;
        display: inline-block !important;
        line-height: 22px;
      }


      /* AUTHENT BTN RADIO */

      form[name=frmTRAN] input[type=radio] {
        position: relative;
        margin-top: 7px;
        display: block !important;
        margin: 10px 0 0 93%;
      }

      form[name=frmTRAN] input[type=radio]::before {
        content: '';
        display: block;
        position: absolute;
        width: 15px;
        height: 15px;
        left: -2px;
        top: 0;
        background-color: #ffffff;
        border: 1px solid #e2e2e2;
        border-radius: 50%;
      }

      form[name=frmTRAN] input[type=radio]::after {
        content: '';
        display: none;
        position: absolute;
        width: 9px;
        height: 9px;
        left: 1px;
        top: 3px;
        background-color: #bad606;
        border-radius: 50%;
      }

      form[name=frmTRAN] input[type=radio]:checked::after {
        display: block;
      }

      form[name=frmTRAN] table tr td {
        border: 0
      }

      form[name=frmTRAN] input[name=demande] {
        position: relative;
        margin-top: 7px;
        display: inline-block !important;
        margin: 2px 0 0 0;
        vertical-align: top;
      }

      form[name=frmTRAN] label {
        display: inline-grid !important;
        max-width: 80% !important;
      }

      #descriptionZone2 {
        padding-left: 10px;
      }


      /* MENU SMALL */


      /* .ei_tpl_redac #ei_tpl_menuPrincipal>nav {padding-bottom:70px!important;} 
#ei_tpl_logo a {margin:5vh 22px 5vh 22px!important;}
*/


      /* #ei_tpl_menuPrincipal>nav>ul>li>.e_smenu>ul>li {margin-bottom: 0px!important} */


      /* #ei_tpl_menuPrincipal>nav>ul>li {margin: 0 22px 0px 22px!important;} */

      @media only screen and (min-width: 992px) {
        .prm-button a {
          padding: 15px 0px !important;
        }
      }


      /* #ei_tpl_menuPrincipal>nav>ul>li>a {padding:3% 0!important;} */


      /* #ei_tpl_menuPrincipal>nav>ul>li>a#ei_fav_next{padding-top:1%!important;} */


      /* #ei_tpl_level0 li#ei_m_favoris a#ei_fav_next {bottom: -5px!important} */


      /* #ei_tpl_menuPrincipal>nav>ul>li>.e_smenu>ul>li>a {padding: 3px 25px!important;} */


      /* #ei_tpl_menuPrincipal > nav > ul > li:nth-child(2) > a{padding-top:10%!important} */


      /* #ei_tpl_menuPrincipal > nav > ul > li.menuProduit.menuderoulant > a{padding-top:0!important;} */


      /* #ei_tpl_menuPrincipal>nav>ul>li>.e_smenu>ul>li>a:after {top: 50%;transform: translateY(-50%);} */


      /*WCB*/

      .wcb img {
        width: 40px;
      }

      .wcb-popin {
        display: none;
        position: fixed;
        top: 0;
        left: 0;
        width: 100%;
        height: 100%;
        background-color: rgba(0, 0, 0, 0.8);
        z-index: 1210;
        cursor: pointer;
      }

      .wcb-content {
        display: none;
        position: fixed;
        top: 50%;
        left: 50%;
        width: 95%;
        max-width: 420px;
        transform: translate(-50%, -50%);
        background-color: #bad606;
        z-index: 1211;
      }

      .wcb-content h2 {
        padding: 26px 20px;
        text-align: center;
        font-size: 20px;
        margin: 0;
        background-color: #fff;
        position: relative;
      }

      .wcb-content h2::before {
        position: absolute;
        left: 6%;
        top: 50%;
        transform: translateY(-50%);
        content: "";
        background:
          /*savepage-url=/fr/images/wcb.svg*/
          url() no-repeat center center;
        width: 40px;
        height: 40px;
      }

      .wcb-content h2 span {
        position: absolute;
        right: 10px;
        top: 10px;
        cursor: pointer;
      }

      .wcb-content iframe {
        width: 100%;
        height: 384px;
        border: none;
        padding: 1.5em 1.5em 0 1.5em
      }

      @media only screen and (max-width:420px) {
        .wcb-content h2 {
          font-size: 14px
        }

        .wcb-content h2 {
          padding: 26px 45px;
          text-align: right;
        }

        .disp-wcb-clt,
        .disp-wcb-ppt {
          padding: 0;
        }

        .wcb img {
          width: 25px;
        }
      }


      /*PAGES PRODUIT CREDITS*/

      .container {
        background-color: #fff;
      }

      hr.undertitlewhite {
        width: 50px;
        border-top: 3px solid #fff;
        margin: 0;
        text-align: left
      }

      hr.undertitlegreen {
        width: 50px;
        border-top: 3px solid #bad606;
        margin: 0;
        text-align: left
      }

      hr.undertitleblack {
        width: 50px;
        border-top: 3px solid #000;
        margin: 0;
        text-align: left
      }

      .credit_2 div {
        padding: 0em 2.5em;
      }

      .credit_2 .advantages {
        margin-top: -30px;
        padding-right: 1em;
      }

      .credit_2 .advantages ul {
        margin-top: 0em !important;
      }

      .credit .mustrefund {
        padding: 1em;
        text-align: center;
      }

      .credit .header {
        padding: 0;
      }

      .credit .header img {
        width: 100%;
      }

      .credit .header h1 {
        font-weight: 700;
      }

      .credit h2 {
        font-size: 25px;
        font-weight: 700;
        color: #000;
      }

      .credit .CTAsimul {
        padding: 2em;
      }

      .credit .hangs {
        padding-top: 2em;
        padding-bottom: 2em;
      }

      .credit .solution h2 {
        color: #bad606;
      }

      .credit_2 .solution h2 {
        margin-top: 0.2em;
      }

      .credit .solution ul {
        margin-top: 0.5em;
      }

      .credit .solution ul li {
        text-align: center;
        word-wrap: break-word;
        padding: 0.5em 1em;
        -webkit-hyphens: auto;
        -moz-hyphens: auto;
        -ms-hyphens: auto;
        hyphens: auto;
      }

      .credit .solution ul li:nth-child(1) {
        border: none !important;
        height: 150px !important
      }

      .credit .solution ul li:nth-child(2) {
        border: none !important;
        height: 150px !important
      }

      .credit .solution ul li:nth-child(3) {
        border: none !important;
        height: 150px !important
      }

      .credit .solution ul li:nth-child(4) {
        border: none !important;
        height: 150px !important
      }

      .credit_2 .solution ul li {
        margin-top: -25px;
      }

      .credit.creditCRM .solution ul li:nth-child(3) {
        border-right: 1px solid #cccccc
      }

      .credit .solution ul li p {
        padding: 1em;
      }

      .credit .solution ul li img {
        width: 85px;
      }

      .credit_2 .solution ul li img {
        width: 60px;
      }

      .credit .advantages h2 {
        color: #bad606;
      }

      .credit .advantages ul {
        margin-top: 2em;
      }

      .credit .advantages ul li {
        position: relative;
        padding-left: 20px;
        margin-bottom: 1em;
      }

      .credit .advantages ul li::before {
        content: '\2714';
        position: absolute;
        top: 0;
        left: 0;
        color: #bad606;
      }

      .credit .clics {
        background-color: #f8f8f8;
      }

      .credit .clics ul {
        margin-top: 0.5em;
      }

      .credit .clics ul li {
        padding: 0.5em 2em 0.5em 2em;
        font-weight: 700;
        font-size: 25px;
      }

      .credit .clics ul li span {
        vertical-align: bottom;
        line-height: 20px;
      }

      .credit .clics ul li p {
        font-weight: 400;
        font-size: 14px;
        text-align: left;
        padding-top: 0.5em;
      }

      .credit .clics ul li img {
        width: 50px;
        display: inline-block;
      }

      .credit .clics p {
        text-align: left;
      }

      .credit.creditAUTO>div.clics.col-xs-12>div {
        padding-top: 4em;
      }

      .credit.creditAUTO>div.clics.col-xs-12>p {
        padding-left: 4em;
      }

      .credit .clics p span {
        color: #bad606;
      }

      @media only screen and (max-width:767px) {
        .credit h1 {
          font-size: 30px;
        }

        .credit h2 {
          font-size: 20px;
        }

        .credit .hangs {
          padding-top: 1em;
          padding-bottom: 1em;
        }

        .credit .solution ul {
          margin-top: 0
        }

        .credit .solution ul li:nth-child(1) {
          border-bottom: 1px solid #cccccc;
          border-right: none
        }

        .credit .solution ul li:nth-child(2) {
          border-bottom: 1px solid #cccccc;
          border-right: none
        }

        .credit.creditCRM .solution ul li:nth-child(3) {
          border-bottom: 1px solid #cccccc;
          border-right: none
        }

        .credit .solution ul li {
          padding-bottom: 0em;
        }

        .credit .advantages {
          padding-top: 1em;
        }

        .credit.creditAUTO>div.solution.col-xs-12 {
          padding-top: 1em;
        }

        #ei_tpl_content>div.container.credit>div.advantages.col-xs-12>ul:nth-child(3) {
          margin-bottom: 0
        }

        #ei_tpl_content>div.container.credit>div.advantages.col-xs-12>ul:nth-child(4) {
          margin-top: 0
        }

        .credit .clics ul li {
          text-align: center;
          padding: 0em 0em 1em 0em;
        }

        .credit.creditAUTO>div.clics.col-xs-12>p {
          padding-left: 0
        }

        .credit .clics ul li p {
          text-align: center;
          padding: 1em;
        }

        .credit.creditAUTO .header {
          padding: 0;
        }

        /* .credit .CTAsimul.sticky{position:sticky;top:50px;z-index:100;padding:0} */
      }


      /*PERSO FIL ACTU INFOS TRANSAC*/

      .actuMNBQ li p.title {
        font-weight: 700;
        color: #bad606;
      }

      .actuMNBQ li {
        padding-left: 50px !important;
        position: relative;
      }

      .actuMNBQ li img {
        position: absolute;
        left: 5%;
        top: 50%;
        transform: translateY(-50%);
        width: 30px;
      }

      .actuMNBQ li a {
        text-decoration: underline !important;
      }


      /*div > div > div > div._c1.ei_tile_body._c1, div > div > div > div._c1.ei_tile_body._c1 > div, ._c2.ei_tile_expanded._c2._c1.ei_tile.ei_tile_theme3.widget.ei_tile_situation._c1._c3._c3{display:flex!important;}*/


      /*bazook*/

      @media screen and (max-width:767px) {
        /* .menuBazooka::before {
        transform: translateY(50%)!important;
    }
    .menuBazooka.e_select::after {
        content: '';
        top: 0;
        left: -3em;
        width: 75em;
        background: rgba(255,255,255,0.2);
        height: 50px;
        position: absolute;
    } */
      }

      @media screen and (min-width:768px) {
        /* #ei_tpl_level0 ul li.menuBazooka a:before, #ei_tpl_level0 ul li.e_select a:before{
        position: absolute;
        content: "";
        left: 0;
        bottom: 3px;
        width: 4px;
        height: 0;
        background-color: #bad606;
        transition: height .25s linear;
        left: -7px;
        top:1px;
    }
    #ei_tpl_level0 ul li.menuBazooka a:focus:before,
    #ei_tpl_level0 ul li.menuBazooka a:hover::before,
    #ei_tpl_level0 ul li.e_select a::before {
      height: 35px;
      width: 3px;
  }
  .menuBazooka.apropos {
    padding-top: 0;
}
.menuBazooka.e_select a::after {
    background: rgba(255,255,255,0.2);
    position: absolute;
    content: '';
    width: 25em;
    height: 37px;
    top: 0px;
    right: 0;
}    */
      }

      p.escaMenu {
        display: none;
      }


      /* #ei_tpl_menuPrincipal > nav > ul > li.menuBazooka > a {
font-weight: normal;
font-size: 1em;
content: #f0f0f0;
}
.menuBazooka.apropos a, .menuBazooka.avisclient a {
font-weight: bold!important;
}
.menuBazooka.menuCc:before {
content:url('/fr/images/img/menu/CompteCourant.svg');
}
.menuBazooka.menuEp:before {
content:url('/fr/images/img/menu/epargne.svg');
}
.menuBazooka.menuAss:before {
content:url('/fr/images/img/menu/assurance.svg');
}
.menuBazooka.menuCr:before {
content:url('/fr/images/img/menu/credit.svg');
}
.menuBazooka.menuPla:before {
content:url('/fr/images/img/menu/placement.svg');
}
.menuBazooka.menuJeunes:before {
content:url('/fr/images/img/menu/jeunes.svg');
}
.menuBazooka.menuAe:before {
content:url('/fr/images/img/menu/autoEntrepreneur.svg');
}
.menuBazooka:before {
float: left;
margin: 0 1em 0 0 ;
transform: translateY(20%);
}
.menuBazooka .noteavis {
color: yellow;
font-weight: bold;
font-size: 1.25em;
}
#ei_tpl_menuPrincipal > nav > ul > li.menuBazooka > a:hover {
font-weight: bold;
} */


      /* #ei_tpl_menuPrincipal>nav>ul>li>a{ 
padding:10px 0!important;
} */

      .product-detail-page ul.list li {
        list-style-image:
          /*savepage-url=/fr/images/list-green-arrow.png*/
          url() !important;
        margin-bottom: 10px !important;
      }


      /*STYLE BTN PRM*/

      #ei_tpl_blocbottom .prm-button {
        position: absolute;
        bottom: 50px;
      }

      .prm-button a {
        width: 100%;
        display: inline-block;
        padding: 18px 0;
        font-weight: bold;
        text-align: center;
        text-decoration: none;
        font-size: 15px;
        color: #fff;
        vertical-align: bottom;
      }

      .mlevel1 .prm-button,
      .mlevel2 .prm-button {
        display: none;
      }

      @media only screen and (min-width: 767px) {
        .prm-button a {
          font-size: 16px;
        }
      }

      @media only screen and (min-width: 992px) {
        .sifi-simuweb-global .e-colg .sifi-simulateurCont {
          min-height: 755px !important;
          padding-top: 65px;
        }

        .mlevel1 .prm-button,
        .mlevel2 .prm-button {
          display: block;
        }

        .ei_tpl_blocbottom {
          width: 100%;
        }

        .prm-button {
          /*width: 16.6666666667%;*/
          width: 100%;
          display: block;
        }

        .prm-button a {
          padding: 25px 0px;
          text-align: center;
        }

        .prm-button a:before {
          display: block;
          position: absolute;
          top: 0;
          left: 0;
          width: 0%;
          height: 100%;
          background: rgba(255, 255, 255, 0.1);
          content: '';
          z-index: 0;
          transition: width 0.5s;
        }

        .prm-button a:hover:before {
          width: 100%;
        }
      }

      @media only screen and (min-width: 1440px) {
        .prm-button a {
          font-size: 17.6px;
        }

        html {
          font-size: 11px
        }
      }

      @media only screen and (min-width: 1600px) {
        .prm-button a {
          font-size: 19.2px;
        }

        html {
          font-size: 12px
        }
      }

      @media only screen and (min-width: 1800px) {
        .prm-button a {
          font-size: 20.8px;
        }

        html {
          font-size: 13px
        }
      }

      @media only screen and (min-width:1920px) {
        html {
          font-size: 14px
        }
      }


      /*OPTION PREMIUM SLIDE*/

      .premiumOption {
        background-color: #f8f8f8;
        position: relative;
        height: auto;
        width: 82%;
        border-radius: 55px;
        max-width: 520px;
      }

      .premiumOption .textslide {
        position: absolute;
        top: 59%;
        font-size: 10px !important;
        left: 23px;
      }

      .premiumOption .makeChoice {
        display: inline-block;
      }

      .premiumOption .makeChoice .line {
        position: absolute;
        background-color: #fff;
        border: 1px solid #c8c8c8;
        width: 50px;
        height: 15px;
        border-radius: 10px;
        top: 40%;
        transform: translateY(-50%);
        left: 23px;
      }

      .premiumOption .makeChoice .circle {
        position: absolute;
        background-color: #c8c8c8;
        width: 22px;
        height: 22px;
        border-radius: 50%;
        top: 40%;
        transform: translateY(-50%);
        cursor: pointer;
        left: 23px;
        box-shadow: 2px 0px 3px #c8c8c8;
      }

      .premiumOption .makeChoice .circle.activep {
        background-color: #fff600;
        animation-name: slidePremiumYes;
        animation-duration: 0.4s;
        animation-timing-function: ease;
        left: 50px;
        box-shadow: 2px 0px 3px #c8c8c8;
      }

      @keyframes slidePremiumYes {
        0% {
          left: 23px;
        }

        100% {
          left: 50px;
        }
      }

      .premiumOption .makeChoice .circle.desactivep {
        background-color: #c8c8c8;
        animation-name: slidePremiumNo;
        animation-duration: 0.4s;
        animation-timing-function: ease;
        left: 23px;
        box-shadow: 2px 0px 3px #c8c8c8;
      }

      @keyframes slidePremiumNo {
        0% {
          left: 50px;
        }

        100% {
          left: 23px;
        }
      }

      .premiumOption .text {
        position: relative;
        width: 65%;
        display: inline-block;
        left: 95px;
        padding: 10px 0;
      }

      .premiumOption .text>p {
        font-size: 16px;
        font-weight: 700;
        margin: 0;
      }

      .premiumOption .text p {
        margin: 0;
      }

      .premiumOption .text span {
        font-size: 12px;
      }

      @media screen and (max-width: 767px) {
        .premiumOption {
          width: 100%;
        }
      }

      .supMini {
        font-size: 50%;
      }


      /**
 ** Campagne Cash Back
 * TODO: Gère affichage des éléments de la campagne
*/

      .compteCourantCashBack {
        position: static !important;
        margin-left: 5.3%;
      }

      #hp1-cashBack {
        background-image:
          /*savepage-url=/fr/images/Bazook_HP2i.jpg*/
          url();
        /* background-image: url({% cdn wm.SITW.resources %}monabanq/images/HomePage/Bazook_HP2i.jpg?v=@CDN_IMG@); */
        background-position: center 0%;
        background-repeat: no-repeat;
        background-size: cover;
        padding: 100px 0;
        position: relative;
        min-height: 40em;
      }

      #hp1-cashBack .visaPremier {
        background-position: 36%;
        background:
          /*savepage-url=/fr/images/World-map.png*/
          url() #FFF;
        display: block;
        height: 100%;
        margin-left: 105px !important;
        padding: 3em 0;
        background-position-x: 0%;
        background-position-y: 0%;
        background-repeat: repeat;
      }

      .containerCashBack {
        display: inline;
        font-size: 3.5rem;
      }

      .containerSlideCB {
        overflow-y: hidden;
        height: 1.5em;
      }

      .containerSlideCB>li {
        position: relative;
        animation-name: slideCashBack;
        -webkit-animation-name: slideCashBack;
        /* Safari 4.0 - 8.0 */
        -webkit-animation-duration: 5s;
        /* Safari 4.0 - 8.0 */
        animation-duration: 5s;
        animation-iteration-count: infinite;
      }


      /**
* TODO : Gestion rotation du slide cask back
*/

      @keyframes slideCashBack {
        0% {
          top: 1em;
        }

        5% {
          top: 0em;
        }

        45% {
          top: 0em;
        }

        55% {
          top: -1.5em;
        }

        95% {
          top: -1.5em;
        }

        100% {
          top: -2.5em;
        }
      }


      /* Safari 4.0 - 8.0 */

      @-webkit-keyframes slideCashBack {
        0% {
          top: 1em;
        }

        5% {
          top: 0em;
        }

        45% {
          top: 0em;
        }

        55% {
          top: -1.3em;
        }

        95% {
          top: -1.3em;
        }

        100% {
          top: -2.3em;
        }
      }

      .banCashBack {
        background-color: rgb(0, 159, 227);
        color: white;
        font-size: 2em;
        min-height: 100px;
        padding: 15px;
      }

      .banCashBack a {
        text-decoration: none;
        font-size: 1em;
      }

      .banCashBack a:hover {
        color: white;
      }

      .banCashBack a span {
        margin-left: 1%;
        font-size: 0.86em;
      }

      .banCashBack a span img {
        width: 14%;
      }

      .banCashBack a span a {
        margin-left: 5%;
        font-size: 0.75em;
      }

      .banCashBack a span span:hover {
        color: #bad606 !important;
      }

      .cashBack-medium-txt {
        font-weight: bold;
        line-height: 0.9em;
        font-size: 2.9em;
      }

      .cashBack-medium-txt span {
        font-size: 0.60em;
      }

      .cashBack-sup-mini {
        top: -1em;
        font-size: 35%
      }

      .cashBack-large-txt {
        font-size: 4.3rem;
      }

      .cashBack-xs-12 {
        margin-top: 1.4%;
      }

      @media screen and (min-width: 1156px) and (max-width: 1439px) {
        #hp1-cashBack {
          padding: 2.5em 0;
          min-height: 30em;
        }

        .compteCourantCashBack {
          margin-left: 2.5%
        }

        #hp1-cashBack .visaPremier {
          padding: 1em 0;
        }

        .banCashBack {
          min-height: auto;
          font-size: 1.5em;
        }

        #hp1.compte_courant {
          min-height: 30em
        }
      }

      @media screen and (min-width: 1440px) and (max-width: 1600px) {
        #hp1-cashBack {
          padding: 0;
          min-height: 35em;
        }

        #hp1-cashBack .visaPremier {
          margin: 4% 0 4% 80px !important;
        }

        .compteCourantCashBack {
          margin-top: 4%;
        }

        .cashBack-xs-12 {
          margin-bottom: 5%;
        }

        .banCashBack {
          min-height: 0%;
          font-size: 1.9em;
        }
      }

      @media screen and (min-width: 992px) and (max-width: 1455px) {
        .credit .solution ul li {
          padding: 0 !important;
        }

        .credit .solution ul li p {
          padding: 0.5em !important;
        }
      }

      @media screen and (min-width: 992px) and (max-width: 1255px) {
        .credit .solution ul li {
          padding: 0 !important;
        }

        .credit .solution ul li p {
          padding: 0.5em !important;
        }

        #hp1-cashBack {
          padding: 0;
          min-height: 35em;
        }

        #hp1-cashBack .visaPremier {
          margin: -70px 0 0 80px !important;
          padding: 1em 0;
        }

        .containerCashBack {
          font-size: 2.3em;
        }

        .cashBack-medium-txt {
          font-size: 2em;
        }

        .containerSlideCB>li:nth-child(2) {
          margin-top: 15px;
        }

        .banCashBack {
          font-size: 1.5em;
          min-height: 0%;
          padding: 0;
        }
      }

      @media screen and (min-width: 768px) and (max-width: 991px) {
        #hp1-cashBack .visaPremier {
          margin: -70px 0 0 80px !important;
        }

        .cashBack-medium-txt {
          font-size: 1.8em;
        }

        .containerCashBack {
          font-size: 2.3em;
        }

        .containerSlideCB {
          height: 2.45em;
        }

        .containerSlideCB>li:nth-child(1) {
          margin-bottom: 25px;
        }

        .banCashBack {
          font-size: 1.431em;
          min-height: 0%;
          padding: 0;
        }
      }

      @media screen and (max-width: 767px) {
        #hp1-cashBack {
          background-image:
            /*savepage-url=/fr/images/HP_responsive_CB.jpg*/
            url();
          background-repeat: no-repeat;
          background-size: cover;
          padding: 2em 0;
          background-position: 32%;
          position: relative;
          min-height: 415px;
        }

        .cashBack-medium-txt {
          font-size: 1.8em;
        }

        .containerCashBack {
          font-size: 2.7rem;
        }

        .cashBack-large-txt {
          font-size: 3rem;
        }

        .containerSlideCB {
          height: 2.6em;
        }

        .containerSlideCB>li:nth-child(1) {
          margin-bottom: 25px;
        }

        .containerSlideCB>li {
          animation-name: slideCashBackMobile;
          -webkit-animation-name: slideCashBackMobile;
          /* Safari 4.0 - 8.0 */
        }

        #hp1souscription {
          margin-top: 100px;
        }

        .cashBack-xs-12 {
          margin-bottom: 45px;
        }

        @keyframes slideCashBackMobile {
          0% {
            top: 2em;
          }

          5% {
            top: 0em;
          }

          45% {
            top: 0em;
          }

          55% {
            top: -2.5em;
          }

          95% {
            top: -2.5em;
          }

          100% {
            top: -4.5em;
          }
        }

        /* Safari 4.0 - 8.0 */
        @-webkit-keyframes slideCashBackMobile {
          0% {
            top: 2em;
          }

          5% {
            top: 0em;
          }

          45% {
            top: 0em;
          }

          55% {
            top: -2.5em;
          }

          95% {
            top: -2.5em;
          }

          100% {
            top: -4.5em;
          }
        }

        .banCashBack {
          text-align: center;
          font-size: 1.24em;
        }

        .banCashBack span {
          margin-left: 0%;
          font-size: inherit;
        }

        .banCashBack span img {
          width: 55%;
        }

        .banCashBack span a {
          display: block;
        }

        .banCashBack a {
          text-decoration: none;
          font-size: 1em;
        }

        .banCashBack a span {
          margin-left: 0%;
          font-size: inherit;
        }

        .banCashBack a span img {
          width: 55%;
        }

        .banCashBack a span span {
          display: block;
          margin-left: 5%;
          font-size: 0.75em;
          text-decoration: underline;
        }
      }


      /*
/********************* 
 ** Fin Cash Back   **
/*********************
*/

      #avisclientId>p>img {
        width: 20px
      }

      @media screen and (min-width: 750px) {
        .pages-divers-titre {
          padding-left: 50px;
        }
      }

      .ei_gly_ic_close:before {
        content: "\F0228";
      }

    </style>
    <style data-savepage-href="/fr/css/gabarit-img.min.css">
      .contacts-wrapper {
        padding: 0 0 80px;
        background-image:
          /*savepage-url=/fr/images/contact-bg.png*/
          url();
        background-repeat: no-repeat;
        background-size: contain;
        background-position: bottom right
      }

      .contacts-wrapper .icon-deafi:before {
        background:
          /*savepage-url=/fr/images/icon-deafi.png*/
          url() center no-repeat transparent !important;
        content: "";
        display: block;
        height: 66px;
        width: 66px
      }

      .slick-next::before {
        content:
          /*savepage-url=/fr/images/img/chevron_blanco-next.svg*/
          url() !important;
        display: block;
        width: 10px;
        margin: 5px auto
      }

      .slick-prev::before {
        content:
          /*savepage-url=/fr/images/img/chevron_blanco-prev.svg*/
          url() !important;
        display: block;
        width: 10px;
        margin: 5px auto
      }

      a.appstore {
        background:
          /*savepage-url=/fr/images/logo-appstore.png*/
          var(--savepage-url-53) no-repeat center transparent !important;
        background-size: contain !important
      }

      a.googleplay {
        background:
          /*savepage-url=/fr/images/logo-googleplay.png*/
          var(--savepage-url-54) no-repeat center transparent !important;
        background-size: contain !important
      }

      a.windowsstore {
        background:
          /*savepage-url=/fr/images/logo-windowsstore.png*/
          url() no-repeat center transparent;
        background-size: contain;
        max-width: 134px
      }

      #review .review__filter .bg-filter {
        background:
          /*savepage-url=/fr/images/avis/avis.jpg*/
          url() no-repeat center center;
        background-size: cover;
        min-height: 310px
      }

      .products {
        min-height: 300px
      }

      .faq-mandat {
        padding: 4em 0;
        display: inline-block;
        background:
          /*savepage-url=/fr/images/Image_FAQ2.jpg*/
          url();
        background-size: cover
      }

      div.arcepgratuit {
        background:
          /*savepage-url=/fr/images/arcep/SGAG.png*/
          var(--savepage-url-51) no-repeat center center;
        width: 220px;
        height: 30px;
        padding: 8px 0 0 20px;
        color: #78b41e;
        display: inline-block
      }

      .wcb-content h2::before {
        position: absolute;
        left: 6%;
        top: 50%;
        -webkit-transform: translateY(-50%);
        transform: translateY(-50%);
        content: "";
        background:
          /*savepage-url=/fr/images/wcb.svg*/
          url() no-repeat center center;
        width: 40px;
        height: 40px
      }

      .product-detail-page ul.list li {
        list-style-image:
          /*savepage-url=/fr/images/list-green-arrow.png*/
          url() !important;
        margin-bottom: 10px !important
      }

      #hp1-cashBack {
        background-image:
          /*savepage-url=/fr/images/Bazook_HP2i.jpg*/
          url();
        background-position: center 0%;
        background-repeat: no-repeat;
        background-size: cover;
        padding: 100px 0;
        position: relative;
        min-height: 40em
      }

      #hp1-cashBack .visaPremier {
        background-position: 36%;
        background:
          /*savepage-url=/fr/images/World-map.png*/
          url() #fff;
        display: block;
        height: 100%;
        margin-left: 105px !important;
        padding: 3em 0;
        background-position-x: 0%;
        background-position-y: 0%;
        background-repeat: repeat
      }

      .articles li {
        list-style:
          /*savepage-url=/fr/images/list-green-arrow.png*/
          url()
      }

      .mnq_normtelSGAG {
        background:
          /*savepage-url=/fr/images/arcep/SGAG.png*/
          var(--savepage-url-51) center center no-repeat !important;
        font-size: 16px !important;
        color: #78b41e !important;
        font-weight: bold !important;
        text-align: left !important;
        padding: 3px 0 0 10px !important;
        width: 204px !important;
        height: 25px !important;
        margin: 0 !important;
        display: inline-block !important
      }

      .mnq_normtelSPPA {
        background:
          /*savepage-url=/fr/images/arcep/SPPA.png*/
          url() center center no-repeat !important;
        font-size: 16px !important;
        color: #a30d76 !important;
        font-weight: bold !important;
        text-align: left !important;
        padding: 3px 0 0 10px !important;
        width: 219px !important;
        height: 25px !important;
        margin: 0 !important;
        display: inline-block !important
      }

      .mnq_normtelSPPA4 {
        background:
          /*savepage-url=/fr/images/arcep/SPPA4.png*/
          url() center center no-repeat !important;
        font-size: 16px !important;
        color: #a30d76 !important;
        font-weight: bold !important;
        text-align: left !important;
        padding: 3px 0 0 10px !important;
        width: 219px !important;
        height: 25px !important;
        margin: 0 !important;
        display: inline-block !important
      }

      .mnq_normtelCRISTAL {
        background:
          /*savepage-url=/fr/images/arcep/cristal.png*/
          url() center 0 no-repeat !important;
        font-size: 13px !important;
        color: #6a6a6a !important;
        font-weight: bold !important;
        text-align: right !important;
        padding: 0 19px 0 0 !important;
        width: 205px !important;
        height: 26px !important;
        margin: 0 !important;
        display: inline-block !important;
        line-height: 22px
      }

      .pages-divers ul.puce-list li {
        list-style-image:
          /*savepage-url=/fr/images/list-green-arrow.png*/
          url() !important;
        margin-bottom: 10px
      }

      .pages-divers ul.puce-list li ul li {
        list-style-type: disc;
        list-style-image: none
      }

      .pages-divers ul.puce-list li ul li ul li {
        list-style-type: circle
      }

      @media screen and (max-width: 767px) {
        #hp1-cashBack {
          background-image:
            /*savepage-url=/fr/images/HP_responsive_CB.jpg*/
            url();
          background-repeat: no-repeat;
          background-size: cover;
          padding: 2em 0;
          background-position: 32%;
          position: relative;
          min-height: 415px
        }
      }

      @media screen and (min-width: 767px) {
        .padd {
          padding-left: 60px !important;
          padding-right: 60px
        }
      }

      label[for=offreAll]::before {
        content:
          /*savepage-url=/fr/images/nouvelle-offre/Chevron_blanc.svg*/
          var(--savepage-url-41);
        display: block;
        position: absolute;
        left: 100%;
        -webkit-transition: all .3s ease-in-out;
        transition: all .3s ease-in-out;
        -webkit-transform: rotate(90deg);
        transform: rotate(90deg);
        top: 8px;
        width: 5px
      }

      label[for=offreAll]::before {
        display: none
      }

      @media all and (max-width: 390px) {
        label[for=offreAll]::before {
          display: block
        }
      }

      /*# sourceMappingURL=gabarit-img.min.css.map */

    </style>
    <style data-savepage-href="/fr/css/webmaster-style.css">
      ul {
        list-style: none;
        padding: 0;
        margin: 0
      }

      .contentPopinBG {
        width: 100%;
        height: 100%;
        position: fixed;
        background: rgba(0, 0, 0, .7);
        z-index: 10000
      }

      .libelle {
        position: absolute;
        bottom: 10px;
        color: #fff;
        width: 100%;
        text-align: center;
        font-size: 16px
      }

      .contentPopin div.contenuPopin {
        position: fixed;
        left: 50%;
        top: 50%;
        transform: translate(-50%, -50%);
        width: 90%;
        height: 90%;
        max-width: 1000px;
        max-height: 800px;
        z-index: 10001
      }

      .contentPopin div.contenuPopin {
        height: 100%
      }

      .contentPopin div.titrePopin {
        position: relative;
        display: flex;
        flex-direction: column;
        flex-wrap: nowrap;
        justify-content: center;
        width: 100%;
        background-color: #333;
        padding: 15px 20px 15px 20px;
        font-size: 18px;
        color: #fff;
        font-weight: 700;
        text-transform: uppercase;
      }

      .contentPopin div.titrePopin:not(.col-xs-12) {
        position: sticky;
        top: 0;
        z-index: 100;
        height: 70px;
      }

      .contentPopin div.titrePopin h2 {
        margin: 0;
        font-size: 17px;
        text-transform: initial;
        text-align: center;
        font-weight: 700
      }

      .contentPopin div.contenuPopin {
        max-height: calc(800px - 63px);
        height: 90%;
        overflow-y: auto;
        background-color: #fff;
        padding: 2%
      }

      .contentPopin div.titrePopin h2 span.closePopin {
        position: absolute;
        right: 3%;
        top: 50%;
        transform: translateY(-50%);
        cursor: pointer;
        font-size: 20px
      }

      .contentPopin div.titrePopin h2 span[class*=ei_gly] {
        color: #bad606;
        margin-right: 15px
      }

      @media (max-width:768px) {
        .contentPopin div.titrePopin h2 span.closePopin {
          /* top: 0;
        transform: none */
        }
      }

    </style>
    <style data-savepage-href="/fr/css/responsiveslides.css">
      .rslides {
        position: relative;
        list-style: none;
        overflow: hidden;
        width: 100%;
        padding: 0;
        margin: 0;
      }

      .rslides li {
        -webkit-backface-visibility: hidden;
        position: absolute;
        display: none;
        width: 100%;
        left: 0;
        top: 0;
      }

      .rslides li:first-child {
        position: relative;
        display: block;
        float: left;
      }

      .rslides img {
        display: block;
        height: auto;
        float: left;
        width: 100%;
        border: 0;
      }

      .rslides_nav.prev {
        transform: rotate(180deg);
        position: absolute;
        background:
          /*savepage-url=/fr/images/compte_courant/chevron_slide.svg*/
          url()no-repeat;
        width: 20px;
        height: 35px;
        top: 50%;
        left: 1%;
        z-index: 10000000000000000000000000000;
        color: transparent
      }

      .rslides_nav.next {
        position: absolute;
        background:
          /*savepage-url=/fr/images/compte_courant/chevron_slide.svg*/
          url()no-repeat;
        width: 20px;
        height: 35px;
        top: 50%;
        right: 5%;
        z-index: 10000000000000000000000000000;
        color: transparent;
      }

      .bullet {
        margin-left: 2%;
        background-color: #e2e2e2;
        width: 8px;
        height: 8px;
        display: inline-block;
        border-radius: 100%;
      }

      .align-li {
        display: inline;
      }

      .rslides_here>a {
        background-color: #bad630 !important;
        width: 10px !important;
        height: 10px !important;
      }

      .rslides_tabs {
        text-align: center;
        margin-bottom: 0;
      }

    </style>

    <script data-savepage-type="" type="text/plain" data-savepage-src="/fr/js/webmaster-script.js"></script>
    <script data-savepage-type="" type="text/plain" data-savepage-src="/fr/js/statut.min.js" defer=""></script>
    <script data-savepage-type="" type="text/plain" data-savepage-src="/fr/js/responsiveslides.min.js"></script>

    <link rel="apple-touch-icon" sizes="57x57" data-savepage-href="/fr/images/favicon/apple-touch-icon-57x57.png" href="">
    <link rel="apple-touch-icon" sizes="60x60" data-savepage-href="/fr/images/favicon/apple-touch-icon-60x60.png" href="">
    <link rel="apple-touch-icon" sizes="72x72" data-savepage-href="/fr/images/favicon/apple-touch-icon-72x72.png" href="">
    <link rel="apple-touch-icon" sizes="76x76" data-savepage-href="/fr/images/favicon/apple-touch-icon-76x76.png" href="">
    <link rel="apple-touch-icon" sizes="114x114" data-savepage-href="/fr/images/favicon/apple-touch-icon-114x114.png" href="">
    <link rel="apple-touch-icon" sizes="120x120" data-savepage-href="/fr/images/favicon/apple-touch-icon-120x120.png" href="">
    <link rel="apple-touch-icon" sizes="144x144" data-savepage-href="/fr/images/favicon/apple-touch-icon-144x144.png" href="">
    <link rel="apple-touch-icon" sizes="152x152" data-savepage-href="/fr/images/favicon/apple-touch-icon-152x152.png" href="">
    <link rel="apple-touch-icon" sizes="180x180" data-savepage-href="/fr/images/favicon/apple-touch-icon-180x180.png" href="">
    <link rel="apple-touch-icon-precomposed" data-savepage-href="/fr/images/favicon/apple-touch-icon-57x57.png" href="">
    <link rel="icon" type="image/png" data-savepage-href="/fr/images/favicon/favicon-32x32.png" href="data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAACAAAAAgCAMAAABEpIrGAAABUFBMVEX///+61ga51QK61gW51gO51QO61gS51gS61gfX52292BC81w79/vn///641QDW52zQ41Xj7pnL4EX8/fX+//3+//zB2iHe64e92BHi7pb7/fLG3TL8/fTW52vM4Ufm8KT6/O7J3zz5++jW523u9cTw9sri7pjy99DX527m8KP3+uPS5Fv6/Ozq87PP41TI3jjV5mfd64XA2h3a6Xvf7I3+/vzw9snj75v6/O38/fPN4UvI3zrM4UbB2h7h7ZTV5mbI3jnU5WPx98zG3TDP41Px983g7I7b6n3w9svs87rZ6HXr87XU5WS61gjI3jfz+NTO4k/g7Y/a6Xjr87i+2Rb9/vjs9LnT5WLN4UzR5Fjs9Lvw9sfp8rDz+NO+2BT8/fb2+t+/2Rq81w/1+dre7InK3z78/fLd64T1+dvQ41e81wzs9Lrz+NK/2Rnd64O+2BXtYF7RAAAA+ElEQVR4XuXS1XLDQAyG0ZWWDGFOmZmZmZmZmfv+3FUmtd1XSHX1zT/nUqz0Lhws/9KLq2fvL+zpYm22p3cuzdj1/t7GdH9n2S9I7rg59/nj1UFEkdk9vD++MiWdruYiqKhCrmOPqDgA6NzDiVTcJMdEmwcA3jh8H2zSfmdp59ZVYC4fAOrz63xlqY8EnB5dro+ZwvaQD6xsirFUVALorRszDk0qEN0dHlCZbco4AIhlqtEJCaK8zgNiZoSy2gLgeapQDP+C2hoPxP8rSERkZLwAWjVKbCqABTPOG0A9VWlHB5KUjS22Xd9ANThsxmzxZ8J0fgbHUrkfUgkmBbEViY0AAAAASUVORK5CYII=" sizes="32x32">
    <link rel="icon" type="image/png" data-savepage-href="/fr/images/favicon/android-chrome-192x192.png" href="data:image/png;base64,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" sizes="192x192">
    <link rel="icon" type="image/png" data-savepage-href="/fr/images/favicon/favicon-96x96.png" href="data:image/png;base64,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" sizes="96x96">
    <link rel="icon" type="image/png" data-savepage-href="/fr/images/favicon/favicon-16x16.png" href="data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAMAAAAoLQ9TAAAA5FBMVEX///+81w651gTH3jb5++i51QLm8KX6/O39/vfo8ay61ge92BDu9cC61gb0+Nb1+drr87ji7pjI3jjF3C3t9MC41QDi7pff7Iv6/O6+2BPx9sv9/vn8/fT7/fDq87Tz+NLl75/V5mfv9cXp8rD6/O/F3S6/2Rb2+t+71wq92BLf7I35++no8avL4ET8/fO51gPn8aq61gXv9sa51QHv9cTS5F3D2yfN4kzG3TO/2Rfx98z+/vq+2BXx98vX5272+d7W52zu9cPY6HHE3CzC2yTd64Pt9L74++fi7pa/2Rm71gjr87Yzr60qAAAAfUlEQVR4Xp3INRICQRQFwDez7oa7u7u7c//7UJ+QKpLtsBGGkq/3JtpqrY60UoaiUOtOmfW8Hoxhs5gFEOvri5PAX5fdXG+UKfjyiDezHtjPxi0K6XxHKsluSAjR+DcCkcL8jcjf8HhVxHZjmKj4EoUj51QonUEbaVe2EcIHIqENyLIgDs4AAAAASUVORK5CYII=" sizes="16x16">
    <link rel="manifest" data-savepage-href="/fr/images/favicon/manifest.json" href="">
    <link rel="icon" data-savepage-href="/fr/images/favicon/favicon.ico" href="data:image/vnd.microsoft.icon;base64,AAABAAEAEBAAAAEAIABoBAAAFgAAACgAAAAQAAAAIAAAAAEAIAAAAAAAAAQAACMuAAAjLgAAAAAAAAAAAAD///////////////////////////////////////////////////////////////////////////////////////////7////7/v7//P/+/////////////v////z+/v/7/v7//v///////////////P/+//v+/v/9////////////////////////////////////////////////////////////////////////////////////////////////////3vr2/6Tw5v+28+v/+/7+///////x/fv/rPHo/6rx5//t/Pr///////7///+69Oz/ovDl/9r59f///////////5ru4v8Az6//H9m///T9/P//////1Pjz/wDUtv8A0rT/x/Xv///////7/v7/K9vC/wDPrv+M697///////////+e7+T/ANO0/yjcw//0/fz//////9X48/8J1rv/A9W5/8n28P//////+/7+/zPdxv8A0rP/kO3g////////////ne/k/wDSs/8l28P/9P38///////V+PP/Bta6/wDVuP/I9vD///////v+/v8w3cb/ANGy/4/t4P///////////53v5P8A0rP/JdvC//P9/P//////1Pjz/wbWuv8A1bj/yPbw///////6/v7/L93G/wDRsv+P7eD///////////+d7+T/ANKz/yTbwv/z/fz//////9P48/8G1rr/ANW4/8b27///////+f79/zHdxv8A0bL/j+3g////////////nO/k/wDTtf8N17z/0ffy///////A9e7/AtW5/wDUt/+e7+T//////+v8+v8g2sH/ANK0/4/s4P///////////5vu4/8A07X/BNW5/yHawP996tv/Mt3G/wDVuP8B1Lf/E9e7/3jp2v9M4c3/AtW5/wDStP+18+r///////////+f7+T/ANKz/0Xgy/9f5dP/ANGx/wLTtP8A1bj/ku3h/2/n1/8A0bH/A9Kz/wDUt/9d5NL/////////////////8v37/9r59f/n+/j//////9D38v+u8uj/1vj0////////////0/jz/6/y6f/O9/H//f///////////////////////////////v////3//v/////////////////8//7//f/+//////////////////3//v/+///////////////+/////f/+//7//////////f/+//z+/v/9//7////////////9//7//P7+//3//v//////////////////////////////////////////////////////////////////////////////////////////////////////AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA==" type="image/x-icon">
    <link rel="shortcut icon" data-savepage-href="/fr/images/favicon/favicon.ico" href="data:image/vnd.microsoft.icon;base64,AAABAAEAEBAAAAEAIABoBAAAFgAAACgAAAAQAAAAIAAAAAEAIAAAAAAAAAQAACMuAAAjLgAAAAAAAAAAAAD///////////////////////////////////////////////////////////////////////////////////////////7////7/v7//P/+/////////////v////z+/v/7/v7//v///////////////P/+//v+/v/9////////////////////////////////////////////////////////////////////////////////////////////////////3vr2/6Tw5v+28+v/+/7+///////x/fv/rPHo/6rx5//t/Pr///////7///+69Oz/ovDl/9r59f///////////5ru4v8Az6//H9m///T9/P//////1Pjz/wDUtv8A0rT/x/Xv///////7/v7/K9vC/wDPrv+M697///////////+e7+T/ANO0/yjcw//0/fz//////9X48/8J1rv/A9W5/8n28P//////+/7+/zPdxv8A0rP/kO3g////////////ne/k/wDSs/8l28P/9P38///////V+PP/Bta6/wDVuP/I9vD///////v+/v8w3cb/ANGy/4/t4P///////////53v5P8A0rP/JdvC//P9/P//////1Pjz/wbWuv8A1bj/yPbw///////6/v7/L93G/wDRsv+P7eD///////////+d7+T/ANKz/yTbwv/z/fz//////9P48/8G1rr/ANW4/8b27///////+f79/zHdxv8A0bL/j+3g////////////nO/k/wDTtf8N17z/0ffy///////A9e7/AtW5/wDUt/+e7+T//////+v8+v8g2sH/ANK0/4/s4P///////////5vu4/8A07X/BNW5/yHawP996tv/Mt3G/wDVuP8B1Lf/E9e7/3jp2v9M4c3/AtW5/wDStP+18+r///////////+f7+T/ANKz/0Xgy/9f5dP/ANGx/wLTtP8A1bj/ku3h/2/n1/8A0bH/A9Kz/wDUt/9d5NL/////////////////8v37/9r59f/n+/j//////9D38v+u8uj/1vj0////////////0/jz/6/y6f/O9/H//f///////////////////////////////v////3//v/////////////////8//7//f/+//////////////////3//v/+///////////////+/////f/+//7//////////f/+//z+/v/9//7////////////9//7//P7+//3//v//////////////////////////////////////////////////////////////////////////////////////////////////////AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA==">

    <meta name="apple-mobile-web-app-title" content="Monabanq">
    <meta name="application-name" content="Monabanq">
    <meta name="msapplication-TileColor" content="#ffffff">
    <meta name="msapplication-TileImage" content="/fr/images/favicon/mstile-144x144.png">
    <meta name="msapplication-config" content="/fr/images/favicon/browserconfig.xml">
    <meta name="theme-color" content="#ffffff">

    <script data-savepage-type="application/ld+json" type="text/plain"></script>

    <script data-savepage-type="text/javascript" type="text/plain"></script>
    <script data-savepage-type="text/javascript" type="text/plain" data-savepage-src="/fr/js/menu.js"></script>
    <script data-savepage-type="text/javascript" type="text/plain" data-savepage-src="/fr/js/customer-area.js"></script>
    <script data-savepage-type="" type="text/plain" data-savepage-src="/fr/js/pdtsep.js"></script>


    <!-- <script src="/fr/javascript/lightbox-5140.js" type="text/javascript"></script> -->
    <meta name="google-site-verification" content="K_-wTG1xNjDo9k6G2ft9u39lJ8KwFCKku-P3537z-x4">


    <style data-savepage-href="https://stackpath.bootstrapcdn.com/font-awesome/4.7.0/css/font-awesome.min.css">
      /*!
 *  Font Awesome 4.7.0 by @davegandy - http://fontawesome.io - @fontawesome
 *  License - http://fontawesome.io/license (Font: SIL OFL 1.1, CSS: MIT License)
 */
      @font-face {
        font-family: 'FontAwesome';
        src:
          /*savepage-url=../fonts/fontawesome-webfont.eot?v=4.7.0*/
          url();
        src:
          /*savepage-url=../fonts/fontawesome-webfont.eot?#iefix&v=4.7.0*/
          url() format('embedded-opentype'),
          /*savepage-url=../fonts/fontawesome-webfont.woff2?v=4.7.0*/
          url() format('woff2'),
          /*savepage-url=../fonts/fontawesome-webfont.woff?v=4.7.0*/
          url() format('woff'),
          /*savepage-url=../fonts/fontawesome-webfont.ttf?v=4.7.0*/
          url() format('truetype'),
          /*savepage-url=../fonts/fontawesome-webfont.svg?v=4.7.0#fontawesomeregular*/
          url() format('svg');
        font-weight: normal;
        font-style: normal
      }

      .fa {
        display: inline-block;
        font: normal normal normal 14px/1 FontAwesome;
        font-size: inherit;
        text-rendering: auto;
        -webkit-font-smoothing: antialiased;
        -moz-osx-font-smoothing: grayscale
      }

      .fa-lg {
        font-size: 1.33333333em;
        line-height: .75em;
        vertical-align: -15%
      }

      .fa-2x {
        font-size: 2em
      }

      .fa-3x {
        font-size: 3em
      }

      .fa-4x {
        font-size: 4em
      }

      .fa-5x {
        font-size: 5em
      }

      .fa-fw {
        width: 1.28571429em;
        text-align: center
      }

      .fa-ul {
        padding-left: 0;
        margin-left: 2.14285714em;
        list-style-type: none
      }

      .fa-ul>li {
        position: relative
      }

      .fa-li {
        position: absolute;
        left: -2.14285714em;
        width: 2.14285714em;
        top: .14285714em;
        text-align: center
      }

      .fa-li.fa-lg {
        left: -1.85714286em
      }

      .fa-border {
        padding: .2em .25em .15em;
        border: solid .08em #eee;
        border-radius: .1em
      }

      .fa-pull-left {
        float: left
      }

      .fa-pull-right {
        float: right
      }

      .fa.fa-pull-left {
        margin-right: .3em
      }

      .fa.fa-pull-right {
        margin-left: .3em
      }

      .pull-right {
        float: right
      }

      .pull-left {
        float: left
      }

      .fa.pull-left {
        margin-right: .3em
      }

      .fa.pull-right {
        margin-left: .3em
      }

      .fa-spin {
        -webkit-animation: fa-spin 2s infinite linear;
        animation: fa-spin 2s infinite linear
      }

      .fa-pulse {
        -webkit-animation: fa-spin 1s infinite steps(8);
        animation: fa-spin 1s infinite steps(8)
      }

      @-webkit-keyframes fa-spin {
        0% {
          -webkit-transform: rotate(0deg);
          transform: rotate(0deg)
        }

        100% {
          -webkit-transform: rotate(359deg);
          transform: rotate(359deg)
        }
      }

      @keyframes fa-spin {
        0% {
          -webkit-transform: rotate(0deg);
          transform: rotate(0deg)
        }

        100% {
          -webkit-transform: rotate(359deg);
          transform: rotate(359deg)
        }
      }

      .fa-rotate-90 {
        -ms-filter: "progid:DXImageTransform.Microsoft.BasicImage(rotation=1)";
        -webkit-transform: rotate(90deg);
        -ms-transform: rotate(90deg);
        transform: rotate(90deg)
      }

      .fa-rotate-180 {
        -ms-filter: "progid:DXImageTransform.Microsoft.BasicImage(rotation=2)";
        -webkit-transform: rotate(180deg);
        -ms-transform: rotate(180deg);
        transform: rotate(180deg)
      }

      .fa-rotate-270 {
        -ms-filter: "progid:DXImageTransform.Microsoft.BasicImage(rotation=3)";
        -webkit-transform: rotate(270deg);
        -ms-transform: rotate(270deg);
        transform: rotate(270deg)
      }

      .fa-flip-horizontal {
        -ms-filter: "progid:DXImageTransform.Microsoft.BasicImage(rotation=0, mirror=1)";
        -webkit-transform: scale(-1, 1);
        -ms-transform: scale(-1, 1);
        transform: scale(-1, 1)
      }

      .fa-flip-vertical {
        -ms-filter: "progid:DXImageTransform.Microsoft.BasicImage(rotation=2, mirror=1)";
        -webkit-transform: scale(1, -1);
        -ms-transform: scale(1, -1);
        transform: scale(1, -1)
      }

      :root .fa-rotate-90,
      :root .fa-rotate-180,
      :root .fa-rotate-270,
      :root .fa-flip-horizontal,
      :root .fa-flip-vertical {
        filter: none
      }

      .fa-stack {
        position: relative;
        display: inline-block;
        width: 2em;
        height: 2em;
        line-height: 2em;
        vertical-align: middle
      }

      .fa-stack-1x,
      .fa-stack-2x {
        position: absolute;
        left: 0;
        width: 100%;
        text-align: center
      }

      .fa-stack-1x {
        line-height: inherit
      }

      .fa-stack-2x {
        font-size: 2em
      }

      .fa-inverse {
        color: #fff
      }

      .fa-glass:before {
        content: "\f000"
      }

      .fa-music:before {
        content: "\f001"
      }

      .fa-search:before {
        content: "\f002"
      }

      .fa-envelope-o:before {
        content: "\f003"
      }

      .fa-heart:before {
        content: "\f004"
      }

      .fa-star:before {
        content: "\f005"
      }

      .fa-star-o:before {
        content: "\f006"
      }

      .fa-user:before {
        content: "\f007"
      }

      .fa-film:before {
        content: "\f008"
      }

      .fa-th-large:before {
        content: "\f009"
      }

      .fa-th:before {
        content: "\f00a"
      }

      .fa-th-list:before {
        content: "\f00b"
      }

      .fa-check:before {
        content: "\f00c"
      }

      .fa-remove:before,
      .fa-close:before,
      .fa-times:before {
        content: "\f00d"
      }

      .fa-search-plus:before {
        content: "\f00e"
      }

      .fa-search-minus:before {
        content: "\f010"
      }

      .fa-power-off:before {
        content: "\f011"
      }

      .fa-signal:before {
        content: "\f012"
      }

      .fa-gear:before,
      .fa-cog:before {
        content: "\f013"
      }

      .fa-trash-o:before {
        content: "\f014"
      }

      .fa-home:before {
        content: "\f015"
      }

      .fa-file-o:before {
        content: "\f016"
      }

      .fa-clock-o:before {
        content: "\f017"
      }

      .fa-road:before {
        content: "\f018"
      }

      .fa-download:before {
        content: "\f019"
      }

      .fa-arrow-circle-o-down:before {
        content: "\f01a"
      }

      .fa-arrow-circle-o-up:before {
        content: "\f01b"
      }

      .fa-inbox:before {
        content: "\f01c"
      }

      .fa-play-circle-o:before {
        content: "\f01d"
      }

      .fa-rotate-right:before,
      .fa-repeat:before {
        content: "\f01e"
      }

      .fa-refresh:before {
        content: "\f021"
      }

      .fa-list-alt:before {
        content: "\f022"
      }

      .fa-lock:before {
        content: "\f023"
      }

      .fa-flag:before {
        content: "\f024"
      }

      .fa-headphones:before {
        content: "\f025"
      }

      .fa-volume-off:before {
        content: "\f026"
      }

      .fa-volume-down:before {
        content: "\f027"
      }

      .fa-volume-up:before {
        content: "\f028"
      }

      .fa-qrcode:before {
        content: "\f029"
      }

      .fa-barcode:before {
        content: "\f02a"
      }

      .fa-tag:before {
        content: "\f02b"
      }

      .fa-tags:before {
        content: "\f02c"
      }

      .fa-book:before {
        content: "\f02d"
      }

      .fa-bookmark:before {
        content: "\f02e"
      }

      .fa-print:before {
        content: "\f02f"
      }

      .fa-camera:before {
        content: "\f030"
      }

      .fa-font:before {
        content: "\f031"
      }

      .fa-bold:before {
        content: "\f032"
      }

      .fa-italic:before {
        content: "\f033"
      }

      .fa-text-height:before {
        content: "\f034"
      }

      .fa-text-width:before {
        content: "\f035"
      }

      .fa-align-left:before {
        content: "\f036"
      }

      .fa-align-center:before {
        content: "\f037"
      }

      .fa-align-right:before {
        content: "\f038"
      }

      .fa-align-justify:before {
        content: "\f039"
      }

      .fa-list:before {
        content: "\f03a"
      }

      .fa-dedent:before,
      .fa-outdent:before {
        content: "\f03b"
      }

      .fa-indent:before {
        content: "\f03c"
      }

      .fa-video-camera:before {
        content: "\f03d"
      }

      .fa-photo:before,
      .fa-image:before,
      .fa-picture-o:before {
        content: "\f03e"
      }

      .fa-pencil:before {
        content: "\f040"
      }

      .fa-map-marker:before {
        content: "\f041"
      }

      .fa-adjust:before {
        content: "\f042"
      }

      .fa-tint:before {
        content: "\f043"
      }

      .fa-edit:before,
      .fa-pencil-square-o:before {
        content: "\f044"
      }

      .fa-share-square-o:before {
        content: "\f045"
      }

      .fa-check-square-o:before {
        content: "\f046"
      }

      .fa-arrows:before {
        content: "\f047"
      }

      .fa-step-backward:before {
        content: "\f048"
      }

      .fa-fast-backward:before {
        content: "\f049"
      }

      .fa-backward:before {
        content: "\f04a"
      }

      .fa-play:before {
        content: "\f04b"
      }

      .fa-pause:before {
        content: "\f04c"
      }

      .fa-stop:before {
        content: "\f04d"
      }

      .fa-forward:before {
        content: "\f04e"
      }

      .fa-fast-forward:before {
        content: "\f050"
      }

      .fa-step-forward:before {
        content: "\f051"
      }

      .fa-eject:before {
        content: "\f052"
      }

      .fa-chevron-left:before {
        content: "\f053"
      }

      .fa-chevron-right:before {
        content: "\f054"
      }

      .fa-plus-circle:before {
        content: "\f055"
      }

      .fa-minus-circle:before {
        content: "\f056"
      }

      .fa-times-circle:before {
        content: "\f057"
      }

      .fa-check-circle:before {
        content: "\f058"
      }

      .fa-question-circle:before {
        content: "\f059"
      }

      .fa-info-circle:before {
        content: "\f05a"
      }

      .fa-crosshairs:before {
        content: "\f05b"
      }

      .fa-times-circle-o:before {
        content: "\f05c"
      }

      .fa-check-circle-o:before {
        content: "\f05d"
      }

      .fa-ban:before {
        content: "\f05e"
      }

      .fa-arrow-left:before {
        content: "\f060"
      }

      .fa-arrow-right:before {
        content: "\f061"
      }

      .fa-arrow-up:before {
        content: "\f062"
      }

      .fa-arrow-down:before {
        content: "\f063"
      }

      .fa-mail-forward:before,
      .fa-share:before {
        content: "\f064"
      }

      .fa-expand:before {
        content: "\f065"
      }

      .fa-compress:before {
        content: "\f066"
      }

      .fa-plus:before {
        content: "\f067"
      }

      .fa-minus:before {
        content: "\f068"
      }

      .fa-asterisk:before {
        content: "\f069"
      }

      .fa-exclamation-circle:before {
        content: "\f06a"
      }

      .fa-gift:before {
        content: "\f06b"
      }

      .fa-leaf:before {
        content: "\f06c"
      }

      .fa-fire:before {
        content: "\f06d"
      }

      .fa-eye:before {
        content: "\f06e"
      }

      .fa-eye-slash:before {
        content: "\f070"
      }

      .fa-warning:before,
      .fa-exclamation-triangle:before {
        content: "\f071"
      }

      .fa-plane:before {
        content: "\f072"
      }

      .fa-calendar:before {
        content: "\f073"
      }

      .fa-random:before {
        content: "\f074"
      }

      .fa-comment:before {
        content: "\f075"
      }

      .fa-magnet:before {
        content: "\f076"
      }

      .fa-chevron-up:before {
        content: "\f077"
      }

      .fa-chevron-down:before {
        content: "\f078"
      }

      .fa-retweet:before {
        content: "\f079"
      }

      .fa-shopping-cart:before {
        content: "\f07a"
      }

      .fa-folder:before {
        content: "\f07b"
      }

      .fa-folder-open:before {
        content: "\f07c"
      }

      .fa-arrows-v:before {
        content: "\f07d"
      }

      .fa-arrows-h:before {
        content: "\f07e"
      }

      .fa-bar-chart-o:before,
      .fa-bar-chart:before {
        content: "\f080"
      }

      .fa-twitter-square:before {
        content: "\f081"
      }

      .fa-facebook-square:before {
        content: "\f082"
      }

      .fa-camera-retro:before {
        content: "\f083"
      }

      .fa-key:before {
        content: "\f084"
      }

      .fa-gears:before,
      .fa-cogs:before {
        content: "\f085"
      }

      .fa-comments:before {
        content: "\f086"
      }

      .fa-thumbs-o-up:before {
        content: "\f087"
      }

      .fa-thumbs-o-down:before {
        content: "\f088"
      }

      .fa-star-half:before {
        content: "\f089"
      }

      .fa-heart-o:before {
        content: "\f08a"
      }

      .fa-sign-out:before {
        content: "\f08b"
      }

      .fa-linkedin-square:before {
        content: "\f08c"
      }

      .fa-thumb-tack:before {
        content: "\f08d"
      }

      .fa-external-link:before {
        content: "\f08e"
      }

      .fa-sign-in:before {
        content: "\f090"
      }

      .fa-trophy:before {
        content: "\f091"
      }

      .fa-github-square:before {
        content: "\f092"
      }

      .fa-upload:before {
        content: "\f093"
      }

      .fa-lemon-o:before {
        content: "\f094"
      }

      .fa-phone:before {
        content: "\f095"
      }

      .fa-square-o:before {
        content: "\f096"
      }

      .fa-bookmark-o:before {
        content: "\f097"
      }

      .fa-phone-square:before {
        content: "\f098"
      }

      .fa-twitter:before {
        content: "\f099"
      }

      .fa-facebook-f:before,
      .fa-facebook:before {
        content: "\f09a"
      }

      .fa-github:before {
        content: "\f09b"
      }

      .fa-unlock:before {
        content: "\f09c"
      }

      .fa-credit-card:before {
        content: "\f09d"
      }

      .fa-feed:before,
      .fa-rss:before {
        content: "\f09e"
      }

      .fa-hdd-o:before {
        content: "\f0a0"
      }

      .fa-bullhorn:before {
        content: "\f0a1"
      }

      .fa-bell:before {
        content: "\f0f3"
      }

      .fa-certificate:before {
        content: "\f0a3"
      }

      .fa-hand-o-right:before {
        content: "\f0a4"
      }

      .fa-hand-o-left:before {
        content: "\f0a5"
      }

      .fa-hand-o-up:before {
        content: "\f0a6"
      }

      .fa-hand-o-down:before {
        content: "\f0a7"
      }

      .fa-arrow-circle-left:before {
        content: "\f0a8"
      }

      .fa-arrow-circle-right:before {
        content: "\f0a9"
      }

      .fa-arrow-circle-up:before {
        content: "\f0aa"
      }

      .fa-arrow-circle-down:before {
        content: "\f0ab"
      }

      .fa-globe:before {
        content: "\f0ac"
      }

      .fa-wrench:before {
        content: "\f0ad"
      }

      .fa-tasks:before {
        content: "\f0ae"
      }

      .fa-filter:before {
        content: "\f0b0"
      }

      .fa-briefcase:before {
        content: "\f0b1"
      }

      .fa-arrows-alt:before {
        content: "\f0b2"
      }

      .fa-group:before,
      .fa-users:before {
        content: "\f0c0"
      }

      .fa-chain:before,
      .fa-link:before {
        content: "\f0c1"
      }

      .fa-cloud:before {
        content: "\f0c2"
      }

      .fa-flask:before {
        content: "\f0c3"
      }

      .fa-cut:before,
      .fa-scissors:before {
        content: "\f0c4"
      }

      .fa-copy:before,
      .fa-files-o:before {
        content: "\f0c5"
      }

      .fa-paperclip:before {
        content: "\f0c6"
      }

      .fa-save:before,
      .fa-floppy-o:before {
        content: "\f0c7"
      }

      .fa-square:before {
        content: "\f0c8"
      }

      .fa-navicon:before,
      .fa-reorder:before,
      .fa-bars:before {
        content: "\f0c9"
      }

      .fa-list-ul:before {
        content: "\f0ca"
      }

      .fa-list-ol:before {
        content: "\f0cb"
      }

      .fa-strikethrough:before {
        content: "\f0cc"
      }

      .fa-underline:before {
        content: "\f0cd"
      }

      .fa-table:before {
        content: "\f0ce"
      }

      .fa-magic:before {
        content: "\f0d0"
      }

      .fa-truck:before {
        content: "\f0d1"
      }

      .fa-pinterest:before {
        content: "\f0d2"
      }

      .fa-pinterest-square:before {
        content: "\f0d3"
      }

      .fa-google-plus-square:before {
        content: "\f0d4"
      }

      .fa-google-plus:before {
        content: "\f0d5"
      }

      .fa-money:before {
        content: "\f0d6"
      }

      .fa-caret-down:before {
        content: "\f0d7"
      }

      .fa-caret-up:before {
        content: "\f0d8"
      }

      .fa-caret-left:before {
        content: "\f0d9"
      }

      .fa-caret-right:before {
        content: "\f0da"
      }

      .fa-columns:before {
        content: "\f0db"
      }

      .fa-unsorted:before,
      .fa-sort:before {
        content: "\f0dc"
      }

      .fa-sort-down:before,
      .fa-sort-desc:before {
        content: "\f0dd"
      }

      .fa-sort-up:before,
      .fa-sort-asc:before {
        content: "\f0de"
      }

      .fa-envelope:before {
        content: "\f0e0"
      }

      .fa-linkedin:before {
        content: "\f0e1"
      }

      .fa-rotate-left:before,
      .fa-undo:before {
        content: "\f0e2"
      }

      .fa-legal:before,
      .fa-gavel:before {
        content: "\f0e3"
      }

      .fa-dashboard:before,
      .fa-tachometer:before {
        content: "\f0e4"
      }

      .fa-comment-o:before {
        content: "\f0e5"
      }

      .fa-comments-o:before {
        content: "\f0e6"
      }

      .fa-flash:before,
      .fa-bolt:before {
        content: "\f0e7"
      }

      .fa-sitemap:before {
        content: "\f0e8"
      }

      .fa-umbrella:before {
        content: "\f0e9"
      }

      .fa-paste:before,
      .fa-clipboard:before {
        content: "\f0ea"
      }

      .fa-lightbulb-o:before {
        content: "\f0eb"
      }

      .fa-exchange:before {
        content: "\f0ec"
      }

      .fa-cloud-download:before {
        content: "\f0ed"
      }

      .fa-cloud-upload:before {
        content: "\f0ee"
      }

      .fa-user-md:before {
        content: "\f0f0"
      }

      .fa-stethoscope:before {
        content: "\f0f1"
      }

      .fa-suitcase:before {
        content: "\f0f2"
      }

      .fa-bell-o:before {
        content: "\f0a2"
      }

      .fa-coffee:before {
        content: "\f0f4"
      }

      .fa-cutlery:before {
        content: "\f0f5"
      }

      .fa-file-text-o:before {
        content: "\f0f6"
      }

      .fa-building-o:before {
        content: "\f0f7"
      }

      .fa-hospital-o:before {
        content: "\f0f8"
      }

      .fa-ambulance:before {
        content: "\f0f9"
      }

      .fa-medkit:before {
        content: "\f0fa"
      }

      .fa-fighter-jet:before {
        content: "\f0fb"
      }

      .fa-beer:before {
        content: "\f0fc"
      }

      .fa-h-square:before {
        content: "\f0fd"
      }

      .fa-plus-square:before {
        content: "\f0fe"
      }

      .fa-angle-double-left:before {
        content: "\f100"
      }

      .fa-angle-double-right:before {
        content: "\f101"
      }

      .fa-angle-double-up:before {
        content: "\f102"
      }

      .fa-angle-double-down:before {
        content: "\f103"
      }

      .fa-angle-left:before {
        content: "\f104"
      }

      .fa-angle-right:before {
        content: "\f105"
      }

      .fa-angle-up:before {
        content: "\f106"
      }

      .fa-angle-down:before {
        content: "\f107"
      }

      .fa-desktop:before {
        content: "\f108"
      }

      .fa-laptop:before {
        content: "\f109"
      }

      .fa-tablet:before {
        content: "\f10a"
      }

      .fa-mobile-phone:before,
      .fa-mobile:before {
        content: "\f10b"
      }

      .fa-circle-o:before {
        content: "\f10c"
      }

      .fa-quote-left:before {
        content: "\f10d"
      }

      .fa-quote-right:before {
        content: "\f10e"
      }

      .fa-spinner:before {
        content: "\f110"
      }

      .fa-circle:before {
        content: "\f111"
      }

      .fa-mail-reply:before,
      .fa-reply:before {
        content: "\f112"
      }

      .fa-github-alt:before {
        content: "\f113"
      }

      .fa-folder-o:before {
        content: "\f114"
      }

      .fa-folder-open-o:before {
        content: "\f115"
      }

      .fa-smile-o:before {
        content: "\f118"
      }

      .fa-frown-o:before {
        content: "\f119"
      }

      .fa-meh-o:before {
        content: "\f11a"
      }

      .fa-gamepad:before {
        content: "\f11b"
      }

      .fa-keyboard-o:before {
        content: "\f11c"
      }

      .fa-flag-o:before {
        content: "\f11d"
      }

      .fa-flag-checkered:before {
        content: "\f11e"
      }

      .fa-terminal:before {
        content: "\f120"
      }

      .fa-code:before {
        content: "\f121"
      }

      .fa-mail-reply-all:before,
      .fa-reply-all:before {
        content: "\f122"
      }

      .fa-star-half-empty:before,
      .fa-star-half-full:before,
      .fa-star-half-o:before {
        content: "\f123"
      }

      .fa-location-arrow:before {
        content: "\f124"
      }

      .fa-crop:before {
        content: "\f125"
      }

      .fa-code-fork:before {
        content: "\f126"
      }

      .fa-unlink:before,
      .fa-chain-broken:before {
        content: "\f127"
      }

      .fa-question:before {
        content: "\f128"
      }

      .fa-info:before {
        content: "\f129"
      }

      .fa-exclamation:before {
        content: "\f12a"
      }

      .fa-superscript:before {
        content: "\f12b"
      }

      .fa-subscript:before {
        content: "\f12c"
      }

      .fa-eraser:before {
        content: "\f12d"
      }

      .fa-puzzle-piece:before {
        content: "\f12e"
      }

      .fa-microphone:before {
        content: "\f130"
      }

      .fa-microphone-slash:before {
        content: "\f131"
      }

      .fa-shield:before {
        content: "\f132"
      }

      .fa-calendar-o:before {
        content: "\f133"
      }

      .fa-fire-extinguisher:before {
        content: "\f134"
      }

      .fa-rocket:before {
        content: "\f135"
      }

      .fa-maxcdn:before {
        content: "\f136"
      }

      .fa-chevron-circle-left:before {
        content: "\f137"
      }

      .fa-chevron-circle-right:before {
        content: "\f138"
      }

      .fa-chevron-circle-up:before {
        content: "\f139"
      }

      .fa-chevron-circle-down:before {
        content: "\f13a"
      }

      .fa-html5:before {
        content: "\f13b"
      }

      .fa-css3:before {
        content: "\f13c"
      }

      .fa-anchor:before {
        content: "\f13d"
      }

      .fa-unlock-alt:before {
        content: "\f13e"
      }

      .fa-bullseye:before {
        content: "\f140"
      }

      .fa-ellipsis-h:before {
        content: "\f141"
      }

      .fa-ellipsis-v:before {
        content: "\f142"
      }

      .fa-rss-square:before {
        content: "\f143"
      }

      .fa-play-circle:before {
        content: "\f144"
      }

      .fa-ticket:before {
        content: "\f145"
      }

      .fa-minus-square:before {
        content: "\f146"
      }

      .fa-minus-square-o:before {
        content: "\f147"
      }

      .fa-level-up:before {
        content: "\f148"
      }

      .fa-level-down:before {
        content: "\f149"
      }

      .fa-check-square:before {
        content: "\f14a"
      }

      .fa-pencil-square:before {
        content: "\f14b"
      }

      .fa-external-link-square:before {
        content: "\f14c"
      }

      .fa-share-square:before {
        content: "\f14d"
      }

      .fa-compass:before {
        content: "\f14e"
      }

      .fa-toggle-down:before,
      .fa-caret-square-o-down:before {
        content: "\f150"
      }

      .fa-toggle-up:before,
      .fa-caret-square-o-up:before {
        content: "\f151"
      }

      .fa-toggle-right:before,
      .fa-caret-square-o-right:before {
        content: "\f152"
      }

      .fa-euro:before,
      .fa-eur:before {
        content: "\f153"
      }

      .fa-gbp:before {
        content: "\f154"
      }

      .fa-dollar:before,
      .fa-usd:before {
        content: "\f155"
      }

      .fa-rupee:before,
      .fa-inr:before {
        content: "\f156"
      }

      .fa-cny:before,
      .fa-rmb:before,
      .fa-yen:before,
      .fa-jpy:before {
        content: "\f157"
      }

      .fa-ruble:before,
      .fa-rouble:before,
      .fa-rub:before {
        content: "\f158"
      }

      .fa-won:before,
      .fa-krw:before {
        content: "\f159"
      }

      .fa-bitcoin:before,
      .fa-btc:before {
        content: "\f15a"
      }

      .fa-file:before {
        content: "\f15b"
      }

      .fa-file-text:before {
        content: "\f15c"
      }

      .fa-sort-alpha-asc:before {
        content: "\f15d"
      }

      .fa-sort-alpha-desc:before {
        content: "\f15e"
      }

      .fa-sort-amount-asc:before {
        content: "\f160"
      }

      .fa-sort-amount-desc:before {
        content: "\f161"
      }

      .fa-sort-numeric-asc:before {
        content: "\f162"
      }

      .fa-sort-numeric-desc:before {
        content: "\f163"
      }

      .fa-thumbs-up:before {
        content: "\f164"
      }

      .fa-thumbs-down:before {
        content: "\f165"
      }

      .fa-youtube-square:before {
        content: "\f166"
      }

      .fa-youtube:before {
        content: "\f167"
      }

      .fa-xing:before {
        content: "\f168"
      }

      .fa-xing-square:before {
        content: "\f169"
      }

      .fa-youtube-play:before {
        content: "\f16a"
      }

      .fa-dropbox:before {
        content: "\f16b"
      }

      .fa-stack-overflow:before {
        content: "\f16c"
      }

      .fa-instagram:before {
        content: "\f16d"
      }

      .fa-flickr:before {
        content: "\f16e"
      }

      .fa-adn:before {
        content: "\f170"
      }

      .fa-bitbucket:before {
        content: "\f171"
      }

      .fa-bitbucket-square:before {
        content: "\f172"
      }

      .fa-tumblr:before {
        content: "\f173"
      }

      .fa-tumblr-square:before {
        content: "\f174"
      }

      .fa-long-arrow-down:before {
        content: "\f175"
      }

      .fa-long-arrow-up:before {
        content: "\f176"
      }

      .fa-long-arrow-left:before {
        content: "\f177"
      }

      .fa-long-arrow-right:before {
        content: "\f178"
      }

      .fa-apple:before {
        content: "\f179"
      }

      .fa-windows:before {
        content: "\f17a"
      }

      .fa-android:before {
        content: "\f17b"
      }

      .fa-linux:before {
        content: "\f17c"
      }

      .fa-dribbble:before {
        content: "\f17d"
      }

      .fa-skype:before {
        content: "\f17e"
      }

      .fa-foursquare:before {
        content: "\f180"
      }

      .fa-trello:before {
        content: "\f181"
      }

      .fa-female:before {
        content: "\f182"
      }

      .fa-male:before {
        content: "\f183"
      }

      .fa-gittip:before,
      .fa-gratipay:before {
        content: "\f184"
      }

      .fa-sun-o:before {
        content: "\f185"
      }

      .fa-moon-o:before {
        content: "\f186"
      }

      .fa-archive:before {
        content: "\f187"
      }

      .fa-bug:before {
        content: "\f188"
      }

      .fa-vk:before {
        content: "\f189"
      }

      .fa-weibo:before {
        content: "\f18a"
      }

      .fa-renren:before {
        content: "\f18b"
      }

      .fa-pagelines:before {
        content: "\f18c"
      }

      .fa-stack-exchange:before {
        content: "\f18d"
      }

      .fa-arrow-circle-o-right:before {
        content: "\f18e"
      }

      .fa-arrow-circle-o-left:before {
        content: "\f190"
      }

      .fa-toggle-left:before,
      .fa-caret-square-o-left:before {
        content: "\f191"
      }

      .fa-dot-circle-o:before {
        content: "\f192"
      }

      .fa-wheelchair:before {
        content: "\f193"
      }

      .fa-vimeo-square:before {
        content: "\f194"
      }

      .fa-turkish-lira:before,
      .fa-try:before {
        content: "\f195"
      }

      .fa-plus-square-o:before {
        content: "\f196"
      }

      .fa-space-shuttle:before {
        content: "\f197"
      }

      .fa-slack:before {
        content: "\f198"
      }

      .fa-envelope-square:before {
        content: "\f199"
      }

      .fa-wordpress:before {
        content: "\f19a"
      }

      .fa-openid:before {
        content: "\f19b"
      }

      .fa-institution:before,
      .fa-bank:before,
      .fa-university:before {
        content: "\f19c"
      }

      .fa-mortar-board:before,
      .fa-graduation-cap:before {
        content: "\f19d"
      }

      .fa-yahoo:before {
        content: "\f19e"
      }

      .fa-google:before {
        content: "\f1a0"
      }

      .fa-reddit:before {
        content: "\f1a1"
      }

      .fa-reddit-square:before {
        content: "\f1a2"
      }

      .fa-stumbleupon-circle:before {
        content: "\f1a3"
      }

      .fa-stumbleupon:before {
        content: "\f1a4"
      }

      .fa-delicious:before {
        content: "\f1a5"
      }

      .fa-digg:before {
        content: "\f1a6"
      }

      .fa-pied-piper-pp:before {
        content: "\f1a7"
      }

      .fa-pied-piper-alt:before {
        content: "\f1a8"
      }

      .fa-drupal:before {
        content: "\f1a9"
      }

      .fa-joomla:before {
        content: "\f1aa"
      }

      .fa-language:before {
        content: "\f1ab"
      }

      .fa-fax:before {
        content: "\f1ac"
      }

      .fa-building:before {
        content: "\f1ad"
      }

      .fa-child:before {
        content: "\f1ae"
      }

      .fa-paw:before {
        content: "\f1b0"
      }

      .fa-spoon:before {
        content: "\f1b1"
      }

      .fa-cube:before {
        content: "\f1b2"
      }

      .fa-cubes:before {
        content: "\f1b3"
      }

      .fa-behance:before {
        content: "\f1b4"
      }

      .fa-behance-square:before {
        content: "\f1b5"
      }

      .fa-steam:before {
        content: "\f1b6"
      }

      .fa-steam-square:before {
        content: "\f1b7"
      }

      .fa-recycle:before {
        content: "\f1b8"
      }

      .fa-automobile:before,
      .fa-car:before {
        content: "\f1b9"
      }

      .fa-cab:before,
      .fa-taxi:before {
        content: "\f1ba"
      }

      .fa-tree:before {
        content: "\f1bb"
      }

      .fa-spotify:before {
        content: "\f1bc"
      }

      .fa-deviantart:before {
        content: "\f1bd"
      }

      .fa-soundcloud:before {
        content: "\f1be"
      }

      .fa-database:before {
        content: "\f1c0"
      }

      .fa-file-pdf-o:before {
        content: "\f1c1"
      }

      .fa-file-word-o:before {
        content: "\f1c2"
      }

      .fa-file-excel-o:before {
        content: "\f1c3"
      }

      .fa-file-powerpoint-o:before {
        content: "\f1c4"
      }

      .fa-file-photo-o:before,
      .fa-file-picture-o:before,
      .fa-file-image-o:before {
        content: "\f1c5"
      }

      .fa-file-zip-o:before,
      .fa-file-archive-o:before {
        content: "\f1c6"
      }

      .fa-file-sound-o:before,
      .fa-file-audio-o:before {
        content: "\f1c7"
      }

      .fa-file-movie-o:before,
      .fa-file-video-o:before {
        content: "\f1c8"
      }

      .fa-file-code-o:before {
        content: "\f1c9"
      }

      .fa-vine:before {
        content: "\f1ca"
      }

      .fa-codepen:before {
        content: "\f1cb"
      }

      .fa-jsfiddle:before {
        content: "\f1cc"
      }

      .fa-life-bouy:before,
      .fa-life-buoy:before,
      .fa-life-saver:before,
      .fa-support:before,
      .fa-life-ring:before {
        content: "\f1cd"
      }

      .fa-circle-o-notch:before {
        content: "\f1ce"
      }

      .fa-ra:before,
      .fa-resistance:before,
      .fa-rebel:before {
        content: "\f1d0"
      }

      .fa-ge:before,
      .fa-empire:before {
        content: "\f1d1"
      }

      .fa-git-square:before {
        content: "\f1d2"
      }

      .fa-git:before {
        content: "\f1d3"
      }

      .fa-y-combinator-square:before,
      .fa-yc-square:before,
      .fa-hacker-news:before {
        content: "\f1d4"
      }

      .fa-tencent-weibo:before {
        content: "\f1d5"
      }

      .fa-qq:before {
        content: "\f1d6"
      }

      .fa-wechat:before,
      .fa-weixin:before {
        content: "\f1d7"
      }

      .fa-send:before,
      .fa-paper-plane:before {
        content: "\f1d8"
      }

      .fa-send-o:before,
      .fa-paper-plane-o:before {
        content: "\f1d9"
      }

      .fa-history:before {
        content: "\f1da"
      }

      .fa-circle-thin:before {
        content: "\f1db"
      }

      .fa-header:before {
        content: "\f1dc"
      }

      .fa-paragraph:before {
        content: "\f1dd"
      }

      .fa-sliders:before {
        content: "\f1de"
      }

      .fa-share-alt:before {
        content: "\f1e0"
      }

      .fa-share-alt-square:before {
        content: "\f1e1"
      }

      .fa-bomb:before {
        content: "\f1e2"
      }

      .fa-soccer-ball-o:before,
      .fa-futbol-o:before {
        content: "\f1e3"
      }

      .fa-tty:before {
        content: "\f1e4"
      }

      .fa-binoculars:before {
        content: "\f1e5"
      }

      .fa-plug:before {
        content: "\f1e6"
      }

      .fa-slideshare:before {
        content: "\f1e7"
      }

      .fa-twitch:before {
        content: "\f1e8"
      }

      .fa-yelp:before {
        content: "\f1e9"
      }

      .fa-newspaper-o:before {
        content: "\f1ea"
      }

      .fa-wifi:before {
        content: "\f1eb"
      }

      .fa-calculator:before {
        content: "\f1ec"
      }

      .fa-paypal:before {
        content: "\f1ed"
      }

      .fa-google-wallet:before {
        content: "\f1ee"
      }

      .fa-cc-visa:before {
        content: "\f1f0"
      }

      .fa-cc-mastercard:before {
        content: "\f1f1"
      }

      .fa-cc-discover:before {
        content: "\f1f2"
      }

      .fa-cc-amex:before {
        content: "\f1f3"
      }

      .fa-cc-paypal:before {
        content: "\f1f4"
      }

      .fa-cc-stripe:before {
        content: "\f1f5"
      }

      .fa-bell-slash:before {
        content: "\f1f6"
      }

      .fa-bell-slash-o:before {
        content: "\f1f7"
      }

      .fa-trash:before {
        content: "\f1f8"
      }

      .fa-copyright:before {
        content: "\f1f9"
      }

      .fa-at:before {
        content: "\f1fa"
      }

      .fa-eyedropper:before {
        content: "\f1fb"
      }

      .fa-paint-brush:before {
        content: "\f1fc"
      }

      .fa-birthday-cake:before {
        content: "\f1fd"
      }

      .fa-area-chart:before {
        content: "\f1fe"
      }

      .fa-pie-chart:before {
        content: "\f200"
      }

      .fa-line-chart:before {
        content: "\f201"
      }

      .fa-lastfm:before {
        content: "\f202"
      }

      .fa-lastfm-square:before {
        content: "\f203"
      }

      .fa-toggle-off:before {
        content: "\f204"
      }

      .fa-toggle-on:before {
        content: "\f205"
      }

      .fa-bicycle:before {
        content: "\f206"
      }

      .fa-bus:before {
        content: "\f207"
      }

      .fa-ioxhost:before {
        content: "\f208"
      }

      .fa-angellist:before {
        content: "\f209"
      }

      .fa-cc:before {
        content: "\f20a"
      }

      .fa-shekel:before,
      .fa-sheqel:before,
      .fa-ils:before {
        content: "\f20b"
      }

      .fa-meanpath:before {
        content: "\f20c"
      }

      .fa-buysellads:before {
        content: "\f20d"
      }

      .fa-connectdevelop:before {
        content: "\f20e"
      }

      .fa-dashcube:before {
        content: "\f210"
      }

      .fa-forumbee:before {
        content: "\f211"
      }

      .fa-leanpub:before {
        content: "\f212"
      }

      .fa-sellsy:before {
        content: "\f213"
      }

      .fa-shirtsinbulk:before {
        content: "\f214"
      }

      .fa-simplybuilt:before {
        content: "\f215"
      }

      .fa-skyatlas:before {
        content: "\f216"
      }

      .fa-cart-plus:before {
        content: "\f217"
      }

      .fa-cart-arrow-down:before {
        content: "\f218"
      }

      .fa-diamond:before {
        content: "\f219"
      }

      .fa-ship:before {
        content: "\f21a"
      }

      .fa-user-secret:before {
        content: "\f21b"
      }

      .fa-motorcycle:before {
        content: "\f21c"
      }

      .fa-street-view:before {
        content: "\f21d"
      }

      .fa-heartbeat:before {
        content: "\f21e"
      }

      .fa-venus:before {
        content: "\f221"
      }

      .fa-mars:before {
        content: "\f222"
      }

      .fa-mercury:before {
        content: "\f223"
      }

      .fa-intersex:before,
      .fa-transgender:before {
        content: "\f224"
      }

      .fa-transgender-alt:before {
        content: "\f225"
      }

      .fa-venus-double:before {
        content: "\f226"
      }

      .fa-mars-double:before {
        content: "\f227"
      }

      .fa-venus-mars:before {
        content: "\f228"
      }

      .fa-mars-stroke:before {
        content: "\f229"
      }

      .fa-mars-stroke-v:before {
        content: "\f22a"
      }

      .fa-mars-stroke-h:before {
        content: "\f22b"
      }

      .fa-neuter:before {
        content: "\f22c"
      }

      .fa-genderless:before {
        content: "\f22d"
      }

      .fa-facebook-official:before {
        content: "\f230"
      }

      .fa-pinterest-p:before {
        content: "\f231"
      }

      .fa-whatsapp:before {
        content: "\f232"
      }

      .fa-server:before {
        content: "\f233"
      }

      .fa-user-plus:before {
        content: "\f234"
      }

      .fa-user-times:before {
        content: "\f235"
      }

      .fa-hotel:before,
      .fa-bed:before {
        content: "\f236"
      }

      .fa-viacoin:before {
        content: "\f237"
      }

      .fa-train:before {
        content: "\f238"
      }

      .fa-subway:before {
        content: "\f239"
      }

      .fa-medium:before {
        content: "\f23a"
      }

      .fa-yc:before,
      .fa-y-combinator:before {
        content: "\f23b"
      }

      .fa-optin-monster:before {
        content: "\f23c"
      }

      .fa-opencart:before {
        content: "\f23d"
      }

      .fa-expeditedssl:before {
        content: "\f23e"
      }

      .fa-battery-4:before,
      .fa-battery:before,
      .fa-battery-full:before {
        content: "\f240"
      }

      .fa-battery-3:before,
      .fa-battery-three-quarters:before {
        content: "\f241"
      }

      .fa-battery-2:before,
      .fa-battery-half:before {
        content: "\f242"
      }

      .fa-battery-1:before,
      .fa-battery-quarter:before {
        content: "\f243"
      }

      .fa-battery-0:before,
      .fa-battery-empty:before {
        content: "\f244"
      }

      .fa-mouse-pointer:before {
        content: "\f245"
      }

      .fa-i-cursor:before {
        content: "\f246"
      }

      .fa-object-group:before {
        content: "\f247"
      }

      .fa-object-ungroup:before {
        content: "\f248"
      }

      .fa-sticky-note:before {
        content: "\f249"
      }

      .fa-sticky-note-o:before {
        content: "\f24a"
      }

      .fa-cc-jcb:before {
        content: "\f24b"
      }

      .fa-cc-diners-club:before {
        content: "\f24c"
      }

      .fa-clone:before {
        content: "\f24d"
      }

      .fa-balance-scale:before {
        content: "\f24e"
      }

      .fa-hourglass-o:before {
        content: "\f250"
      }

      .fa-hourglass-1:before,
      .fa-hourglass-start:before {
        content: "\f251"
      }

      .fa-hourglass-2:before,
      .fa-hourglass-half:before {
        content: "\f252"
      }

      .fa-hourglass-3:before,
      .fa-hourglass-end:before {
        content: "\f253"
      }

      .fa-hourglass:before {
        content: "\f254"
      }

      .fa-hand-grab-o:before,
      .fa-hand-rock-o:before {
        content: "\f255"
      }

      .fa-hand-stop-o:before,
      .fa-hand-paper-o:before {
        content: "\f256"
      }

      .fa-hand-scissors-o:before {
        content: "\f257"
      }

      .fa-hand-lizard-o:before {
        content: "\f258"
      }

      .fa-hand-spock-o:before {
        content: "\f259"
      }

      .fa-hand-pointer-o:before {
        content: "\f25a"
      }

      .fa-hand-peace-o:before {
        content: "\f25b"
      }

      .fa-trademark:before {
        content: "\f25c"
      }

      .fa-registered:before {
        content: "\f25d"
      }

      .fa-creative-commons:before {
        content: "\f25e"
      }

      .fa-gg:before {
        content: "\f260"
      }

      .fa-gg-circle:before {
        content: "\f261"
      }

      .fa-tripadvisor:before {
        content: "\f262"
      }

      .fa-odnoklassniki:before {
        content: "\f263"
      }

      .fa-odnoklassniki-square:before {
        content: "\f264"
      }

      .fa-get-pocket:before {
        content: "\f265"
      }

      .fa-wikipedia-w:before {
        content: "\f266"
      }

      .fa-safari:before {
        content: "\f267"
      }

      .fa-chrome:before {
        content: "\f268"
      }

      .fa-firefox:before {
        content: "\f269"
      }

      .fa-opera:before {
        content: "\f26a"
      }

      .fa-internet-explorer:before {
        content: "\f26b"
      }

      .fa-tv:before,
      .fa-television:before {
        content: "\f26c"
      }

      .fa-contao:before {
        content: "\f26d"
      }

      .fa-500px:before {
        content: "\f26e"
      }

      .fa-amazon:before {
        content: "\f270"
      }

      .fa-calendar-plus-o:before {
        content: "\f271"
      }

      .fa-calendar-minus-o:before {
        content: "\f272"
      }

      .fa-calendar-times-o:before {
        content: "\f273"
      }

      .fa-calendar-check-o:before {
        content: "\f274"
      }

      .fa-industry:before {
        content: "\f275"
      }

      .fa-map-pin:before {
        content: "\f276"
      }

      .fa-map-signs:before {
        content: "\f277"
      }

      .fa-map-o:before {
        content: "\f278"
      }

      .fa-map:before {
        content: "\f279"
      }

      .fa-commenting:before {
        content: "\f27a"
      }

      .fa-commenting-o:before {
        content: "\f27b"
      }

      .fa-houzz:before {
        content: "\f27c"
      }

      .fa-vimeo:before {
        content: "\f27d"
      }

      .fa-black-tie:before {
        content: "\f27e"
      }

      .fa-fonticons:before {
        content: "\f280"
      }

      .fa-reddit-alien:before {
        content: "\f281"
      }

      .fa-edge:before {
        content: "\f282"
      }

      .fa-credit-card-alt:before {
        content: "\f283"
      }

      .fa-codiepie:before {
        content: "\f284"
      }

      .fa-modx:before {
        content: "\f285"
      }

      .fa-fort-awesome:before {
        content: "\f286"
      }

      .fa-usb:before {
        content: "\f287"
      }

      .fa-product-hunt:before {
        content: "\f288"
      }

      .fa-mixcloud:before {
        content: "\f289"
      }

      .fa-scribd:before {
        content: "\f28a"
      }

      .fa-pause-circle:before {
        content: "\f28b"
      }

      .fa-pause-circle-o:before {
        content: "\f28c"
      }

      .fa-stop-circle:before {
        content: "\f28d"
      }

      .fa-stop-circle-o:before {
        content: "\f28e"
      }

      .fa-shopping-bag:before {
        content: "\f290"
      }

      .fa-shopping-basket:before {
        content: "\f291"
      }

      .fa-hashtag:before {
        content: "\f292"
      }

      .fa-bluetooth:before {
        content: "\f293"
      }

      .fa-bluetooth-b:before {
        content: "\f294"
      }

      .fa-percent:before {
        content: "\f295"
      }

      .fa-gitlab:before {
        content: "\f296"
      }

      .fa-wpbeginner:before {
        content: "\f297"
      }

      .fa-wpforms:before {
        content: "\f298"
      }

      .fa-envira:before {
        content: "\f299"
      }

      .fa-universal-access:before {
        content: "\f29a"
      }

      .fa-wheelchair-alt:before {
        content: "\f29b"
      }

      .fa-question-circle-o:before {
        content: "\f29c"
      }

      .fa-blind:before {
        content: "\f29d"
      }

      .fa-audio-description:before {
        content: "\f29e"
      }

      .fa-volume-control-phone:before {
        content: "\f2a0"
      }

      .fa-braille:before {
        content: "\f2a1"
      }

      .fa-assistive-listening-systems:before {
        content: "\f2a2"
      }

      .fa-asl-interpreting:before,
      .fa-american-sign-language-interpreting:before {
        content: "\f2a3"
      }

      .fa-deafness:before,
      .fa-hard-of-hearing:before,
      .fa-deaf:before {
        content: "\f2a4"
      }

      .fa-glide:before {
        content: "\f2a5"
      }

      .fa-glide-g:before {
        content: "\f2a6"
      }

      .fa-signing:before,
      .fa-sign-language:before {
        content: "\f2a7"
      }

      .fa-low-vision:before {
        content: "\f2a8"
      }

      .fa-viadeo:before {
        content: "\f2a9"
      }

      .fa-viadeo-square:before {
        content: "\f2aa"
      }

      .fa-snapchat:before {
        content: "\f2ab"
      }

      .fa-snapchat-ghost:before {
        content: "\f2ac"
      }

      .fa-snapchat-square:before {
        content: "\f2ad"
      }

      .fa-pied-piper:before {
        content: "\f2ae"
      }

      .fa-first-order:before {
        content: "\f2b0"
      }

      .fa-yoast:before {
        content: "\f2b1"
      }

      .fa-themeisle:before {
        content: "\f2b2"
      }

      .fa-google-plus-circle:before,
      .fa-google-plus-official:before {
        content: "\f2b3"
      }

      .fa-fa:before,
      .fa-font-awesome:before {
        content: "\f2b4"
      }

      .fa-handshake-o:before {
        content: "\f2b5"
      }

      .fa-envelope-open:before {
        content: "\f2b6"
      }

      .fa-envelope-open-o:before {
        content: "\f2b7"
      }

      .fa-linode:before {
        content: "\f2b8"
      }

      .fa-address-book:before {
        content: "\f2b9"
      }

      .fa-address-book-o:before {
        content: "\f2ba"
      }

      .fa-vcard:before,
      .fa-address-card:before {
        content: "\f2bb"
      }

      .fa-vcard-o:before,
      .fa-address-card-o:before {
        content: "\f2bc"
      }

      .fa-user-circle:before {
        content: "\f2bd"
      }

      .fa-user-circle-o:before {
        content: "\f2be"
      }

      .fa-user-o:before {
        content: "\f2c0"
      }

      .fa-id-badge:before {
        content: "\f2c1"
      }

      .fa-drivers-license:before,
      .fa-id-card:before {
        content: "\f2c2"
      }

      .fa-drivers-license-o:before,
      .fa-id-card-o:before {
        content: "\f2c3"
      }

      .fa-quora:before {
        content: "\f2c4"
      }

      .fa-free-code-camp:before {
        content: "\f2c5"
      }

      .fa-telegram:before {
        content: "\f2c6"
      }

      .fa-thermometer-4:before,
      .fa-thermometer:before,
      .fa-thermometer-full:before {
        content: "\f2c7"
      }

      .fa-thermometer-3:before,
      .fa-thermometer-three-quarters:before {
        content: "\f2c8"
      }

      .fa-thermometer-2:before,
      .fa-thermometer-half:before {
        content: "\f2c9"
      }

      .fa-thermometer-1:before,
      .fa-thermometer-quarter:before {
        content: "\f2ca"
      }

      .fa-thermometer-0:before,
      .fa-thermometer-empty:before {
        content: "\f2cb"
      }

      .fa-shower:before {
        content: "\f2cc"
      }

      .fa-bathtub:before,
      .fa-s15:before,
      .fa-bath:before {
        content: "\f2cd"
      }

      .fa-podcast:before {
        content: "\f2ce"
      }

      .fa-window-maximize:before {
        content: "\f2d0"
      }

      .fa-window-minimize:before {
        content: "\f2d1"
      }

      .fa-window-restore:before {
        content: "\f2d2"
      }

      .fa-times-rectangle:before,
      .fa-window-close:before {
        content: "\f2d3"
      }

      .fa-times-rectangle-o:before,
      .fa-window-close-o:before {
        content: "\f2d4"
      }

      .fa-bandcamp:before {
        content: "\f2d5"
      }

      .fa-grav:before {
        content: "\f2d6"
      }

      .fa-etsy:before {
        content: "\f2d7"
      }

      .fa-imdb:before {
        content: "\f2d8"
      }

      .fa-ravelry:before {
        content: "\f2d9"
      }

      .fa-eercast:before {
        content: "\f2da"
      }

      .fa-microchip:before {
        content: "\f2db"
      }

      .fa-snowflake-o:before {
        content: "\f2dc"
      }

      .fa-superpowers:before {
        content: "\f2dd"
      }

      .fa-wpexplorer:before {
        content: "\f2de"
      }

      .fa-meetup:before {
        content: "\f2e0"
      }

      .sr-only {
        position: absolute;
        width: 1px;
        height: 1px;
        padding: 0;
        margin: -1px;
        overflow: hidden;
        clip: rect(0, 0, 0, 0);
        border: 0
      }

      .sr-only-focusable:active,
      .sr-only-focusable:focus {
        position: static;
        width: auto;
        height: auto;
        margin: 0;
        overflow: visible;
        clip: auto
      }

    </style>
    <style data-savepage-href="//netdna.bootstrapcdn.com/font-awesome/4.0.3/css/font-awesome.css">
      /*!
 *  Font Awesome 4.0.3 by @davegandy - http://fontawesome.io - @fontawesome
 *  License - http://fontawesome.io/license (Font: SIL OFL 1.1, CSS: MIT License)
 */
      /* FONT PATH
 * -------------------------- */
      @font-face {
        font-family: 'FontAwesome';
        src:
          /*savepage-url=../fonts/fontawesome-webfont.eot?v=4.0.3*/
          url();
        src:
          /*savepage-url=../fonts/fontawesome-webfont.eot?#iefix&v=4.0.3*/
          url() format('embedded-opentype'),
          /*savepage-url=../fonts/fontawesome-webfont.woff?v=4.0.3*/
          url() format('woff'),
          /*savepage-url=../fonts/fontawesome-webfont.ttf?v=4.0.3*/
          url() format('truetype'),
          /*savepage-url=../fonts/fontawesome-webfont.svg?v=4.0.3#fontawesomeregular*/
          url() format('svg');
        font-weight: normal;
        font-style: normal;
      }

      .fa {
        display: inline-block;
        font-family: FontAwesome;
        font-style: normal;
        font-weight: normal;
        line-height: 1;
        -webkit-font-smoothing: antialiased;
        -moz-osx-font-smoothing: grayscale;
      }

      /* makes the font 33% larger relative to the icon container */
      .fa-lg {
        font-size: 1.3333333333333333em;
        line-height: 0.75em;
        vertical-align: -15%;
      }

      .fa-2x {
        font-size: 2em;
      }

      .fa-3x {
        font-size: 3em;
      }

      .fa-4x {
        font-size: 4em;
      }

      .fa-5x {
        font-size: 5em;
      }

      .fa-fw {
        width: 1.2857142857142858em;
        text-align: center;
      }

      .fa-ul {
        padding-left: 0;
        margin-left: 2.142857142857143em;
        list-style-type: none;
      }

      .fa-ul>li {
        position: relative;
      }

      .fa-li {
        position: absolute;
        left: -2.142857142857143em;
        width: 2.142857142857143em;
        top: 0.14285714285714285em;
        text-align: center;
      }

      .fa-li.fa-lg {
        left: -1.8571428571428572em;
      }

      .fa-border {
        padding: .2em .25em .15em;
        border: solid 0.08em #eeeeee;
        border-radius: .1em;
      }

      .pull-right {
        float: right;
      }

      .pull-left {
        float: left;
      }

      .fa.pull-left {
        margin-right: .3em;
      }

      .fa.pull-right {
        margin-left: .3em;
      }

      .fa-spin {
        -webkit-animation: spin 2s infinite linear;
        -moz-animation: spin 2s infinite linear;
        -o-animation: spin 2s infinite linear;
        animation: spin 2s infinite linear;
      }

      @-moz-keyframes spin {
        0% {
          -moz-transform: rotate(0deg);
        }

        100% {
          -moz-transform: rotate(359deg);
        }
      }

      @-webkit-keyframes spin {
        0% {
          -webkit-transform: rotate(0deg);
        }

        100% {
          -webkit-transform: rotate(359deg);
        }
      }

      @-o-keyframes spin {
        0% {
          -o-transform: rotate(0deg);
        }

        100% {
          -o-transform: rotate(359deg);
        }
      }

      @-ms-keyframes spin {
        0% {
          -ms-transform: rotate(0deg);
        }

        100% {
          -ms-transform: rotate(359deg);
        }
      }

      @keyframes spin {
        0% {
          transform: rotate(0deg);
        }

        100% {
          transform: rotate(359deg);
        }
      }

      .fa-rotate-90 {
        filter: progid:DXImageTransform.Microsoft.BasicImage(rotation=1);
        -webkit-transform: rotate(90deg);
        -moz-transform: rotate(90deg);
        -ms-transform: rotate(90deg);
        -o-transform: rotate(90deg);
        transform: rotate(90deg);
      }

      .fa-rotate-180 {
        filter: progid:DXImageTransform.Microsoft.BasicImage(rotation=2);
        -webkit-transform: rotate(180deg);
        -moz-transform: rotate(180deg);
        -ms-transform: rotate(180deg);
        -o-transform: rotate(180deg);
        transform: rotate(180deg);
      }

      .fa-rotate-270 {
        filter: progid:DXImageTransform.Microsoft.BasicImage(rotation=3);
        -webkit-transform: rotate(270deg);
        -moz-transform: rotate(270deg);
        -ms-transform: rotate(270deg);
        -o-transform: rotate(270deg);
        transform: rotate(270deg);
      }

      .fa-flip-horizontal {
        filter: progid:DXImageTransform.Microsoft.BasicImage(rotation=0, mirror=1);
        -webkit-transform: scale(-1, 1);
        -moz-transform: scale(-1, 1);
        -ms-transform: scale(-1, 1);
        -o-transform: scale(-1, 1);
        transform: scale(-1, 1);
      }

      .fa-flip-vertical {
        filter: progid:DXImageTransform.Microsoft.BasicImage(rotation=2, mirror=1);
        -webkit-transform: scale(1, -1);
        -moz-transform: scale(1, -1);
        -ms-transform: scale(1, -1);
        -o-transform: scale(1, -1);
        transform: scale(1, -1);
      }

      .fa-stack {
        position: relative;
        display: inline-block;
        width: 2em;
        height: 2em;
        line-height: 2em;
        vertical-align: middle;
      }

      .fa-stack-1x,
      .fa-stack-2x {
        position: absolute;
        left: 0;
        width: 100%;
        text-align: center;
      }

      .fa-stack-1x {
        line-height: inherit;
      }

      .fa-stack-2x {
        font-size: 2em;
      }

      .fa-inverse {
        color: #ffffff;
      }

      /* Font Awesome uses the Unicode Private Use Area (PUA) to ensure screen
   readers do not read off random characters that represent icons */
      .fa-glass:before {
        content: "\f000";
      }

      .fa-music:before {
        content: "\f001";
      }

      .fa-search:before {
        content: "\f002";
      }

      .fa-envelope-o:before {
        content: "\f003";
      }

      .fa-heart:before {
        content: "\f004";
      }

      .fa-star:before {
        content: "\f005";
      }

      .fa-star-o:before {
        content: "\f006";
      }

      .fa-user:before {
        content: "\f007";
      }

      .fa-film:before {
        content: "\f008";
      }

      .fa-th-large:before {
        content: "\f009";
      }

      .fa-th:before {
        content: "\f00a";
      }

      .fa-th-list:before {
        content: "\f00b";
      }

      .fa-check:before {
        content: "\f00c";
      }

      .fa-times:before {
        content: "\f00d";
      }

      .fa-search-plus:before {
        content: "\f00e";
      }

      .fa-search-minus:before {
        content: "\f010";
      }

      .fa-power-off:before {
        content: "\f011";
      }

      .fa-signal:before {
        content: "\f012";
      }

      .fa-gear:before,
      .fa-cog:before {
        content: "\f013";
      }

      .fa-trash-o:before {
        content: "\f014";
      }

      .fa-home:before {
        content: "\f015";
      }

      .fa-file-o:before {
        content: "\f016";
      }

      .fa-clock-o:before {
        content: "\f017";
      }

      .fa-road:before {
        content: "\f018";
      }

      .fa-download:before {
        content: "\f019";
      }

      .fa-arrow-circle-o-down:before {
        content: "\f01a";
      }

      .fa-arrow-circle-o-up:before {
        content: "\f01b";
      }

      .fa-inbox:before {
        content: "\f01c";
      }

      .fa-play-circle-o:before {
        content: "\f01d";
      }

      .fa-rotate-right:before,
      .fa-repeat:before {
        content: "\f01e";
      }

      .fa-refresh:before {
        content: "\f021";
      }

      .fa-list-alt:before {
        content: "\f022";
      }

      .fa-lock:before {
        content: "\f023";
      }

      .fa-flag:before {
        content: "\f024";
      }

      .fa-headphones:before {
        content: "\f025";
      }

      .fa-volume-off:before {
        content: "\f026";
      }

      .fa-volume-down:before {
        content: "\f027";
      }

      .fa-volume-up:before {
        content: "\f028";
      }

      .fa-qrcode:before {
        content: "\f029";
      }

      .fa-barcode:before {
        content: "\f02a";
      }

      .fa-tag:before {
        content: "\f02b";
      }

      .fa-tags:before {
        content: "\f02c";
      }

      .fa-book:before {
        content: "\f02d";
      }

      .fa-bookmark:before {
        content: "\f02e";
      }

      .fa-print:before {
        content: "\f02f";
      }

      .fa-camera:before {
        content: "\f030";
      }

      .fa-font:before {
        content: "\f031";
      }

      .fa-bold:before {
        content: "\f032";
      }

      .fa-italic:before {
        content: "\f033";
      }

      .fa-text-height:before {
        content: "\f034";
      }

      .fa-text-width:before {
        content: "\f035";
      }

      .fa-align-left:before {
        content: "\f036";
      }

      .fa-align-center:before {
        content: "\f037";
      }

      .fa-align-right:before {
        content: "\f038";
      }

      .fa-align-justify:before {
        content: "\f039";
      }

      .fa-list:before {
        content: "\f03a";
      }

      .fa-dedent:before,
      .fa-outdent:before {
        content: "\f03b";
      }

      .fa-indent:before {
        content: "\f03c";
      }

      .fa-video-camera:before {
        content: "\f03d";
      }

      .fa-picture-o:before {
        content: "\f03e";
      }

      .fa-pencil:before {
        content: "\f040";
      }

      .fa-map-marker:before {
        content: "\f041";
      }

      .fa-adjust:before {
        content: "\f042";
      }

      .fa-tint:before {
        content: "\f043";
      }

      .fa-edit:before,
      .fa-pencil-square-o:before {
        content: "\f044";
      }

      .fa-share-square-o:before {
        content: "\f045";
      }

      .fa-check-square-o:before {
        content: "\f046";
      }

      .fa-arrows:before {
        content: "\f047";
      }

      .fa-step-backward:before {
        content: "\f048";
      }

      .fa-fast-backward:before {
        content: "\f049";
      }

      .fa-backward:before {
        content: "\f04a";
      }

      .fa-play:before {
        content: "\f04b";
      }

      .fa-pause:before {
        content: "\f04c";
      }

      .fa-stop:before {
        content: "\f04d";
      }

      .fa-forward:before {
        content: "\f04e";
      }

      .fa-fast-forward:before {
        content: "\f050";
      }

      .fa-step-forward:before {
        content: "\f051";
      }

      .fa-eject:before {
        content: "\f052";
      }

      .fa-chevron-left:before {
        content: "\f053";
      }

      .fa-chevron-right:before {
        content: "\f054";
      }

      .fa-plus-circle:before {
        content: "\f055";
      }

      .fa-minus-circle:before {
        content: "\f056";
      }

      .fa-times-circle:before {
        content: "\f057";
      }

      .fa-check-circle:before {
        content: "\f058";
      }

      .fa-question-circle:before {
        content: "\f059";
      }

      .fa-info-circle:before {
        content: "\f05a";
      }

      .fa-crosshairs:before {
        content: "\f05b";
      }

      .fa-times-circle-o:before {
        content: "\f05c";
      }

      .fa-check-circle-o:before {
        content: "\f05d";
      }

      .fa-ban:before {
        content: "\f05e";
      }

      .fa-arrow-left:before {
        content: "\f060";
      }

      .fa-arrow-right:before {
        content: "\f061";
      }

      .fa-arrow-up:before {
        content: "\f062";
      }

      .fa-arrow-down:before {
        content: "\f063";
      }

      .fa-mail-forward:before,
      .fa-share:before {
        content: "\f064";
      }

      .fa-expand:before {
        content: "\f065";
      }

      .fa-compress:before {
        content: "\f066";
      }

      .fa-plus:before {
        content: "\f067";
      }

      .fa-minus:before {
        content: "\f068";
      }

      .fa-asterisk:before {
        content: "\f069";
      }

      .fa-exclamation-circle:before {
        content: "\f06a";
      }

      .fa-gift:before {
        content: "\f06b";
      }

      .fa-leaf:before {
        content: "\f06c";
      }

      .fa-fire:before {
        content: "\f06d";
      }

      .fa-eye:before {
        content: "\f06e";
      }

      .fa-eye-slash:before {
        content: "\f070";
      }

      .fa-warning:before,
      .fa-exclamation-triangle:before {
        content: "\f071";
      }

      .fa-plane:before {
        content: "\f072";
      }

      .fa-calendar:before {
        content: "\f073";
      }

      .fa-random:before {
        content: "\f074";
      }

      .fa-comment:before {
        content: "\f075";
      }

      .fa-magnet:before {
        content: "\f076";
      }

      .fa-chevron-up:before {
        content: "\f077";
      }

      .fa-chevron-down:before {
        content: "\f078";
      }

      .fa-retweet:before {
        content: "\f079";
      }

      .fa-shopping-cart:before {
        content: "\f07a";
      }

      .fa-folder:before {
        content: "\f07b";
      }

      .fa-folder-open:before {
        content: "\f07c";
      }

      .fa-arrows-v:before {
        content: "\f07d";
      }

      .fa-arrows-h:before {
        content: "\f07e";
      }

      .fa-bar-chart-o:before {
        content: "\f080";
      }

      .fa-twitter-square:before {
        content: "\f081";
      }

      .fa-facebook-square:before {
        content: "\f082";
      }

      .fa-camera-retro:before {
        content: "\f083";
      }

      .fa-key:before {
        content: "\f084";
      }

      .fa-gears:before,
      .fa-cogs:before {
        content: "\f085";
      }

      .fa-comments:before {
        content: "\f086";
      }

      .fa-thumbs-o-up:before {
        content: "\f087";
      }

      .fa-thumbs-o-down:before {
        content: "\f088";
      }

      .fa-star-half:before {
        content: "\f089";
      }

      .fa-heart-o:before {
        content: "\f08a";
      }

      .fa-sign-out:before {
        content: "\f08b";
      }

      .fa-linkedin-square:before {
        content: "\f08c";
      }

      .fa-thumb-tack:before {
        content: "\f08d";
      }

      .fa-external-link:before {
        content: "\f08e";
      }

      .fa-sign-in:before {
        content: "\f090";
      }

      .fa-trophy:before {
        content: "\f091";
      }

      .fa-github-square:before {
        content: "\f092";
      }

      .fa-upload:before {
        content: "\f093";
      }

      .fa-lemon-o:before {
        content: "\f094";
      }

      .fa-phone:before {
        content: "\f095";
      }

      .fa-square-o:before {
        content: "\f096";
      }

      .fa-bookmark-o:before {
        content: "\f097";
      }

      .fa-phone-square:before {
        content: "\f098";
      }

      .fa-twitter:before {
        content: "\f099";
      }

      .fa-facebook:before {
        content: "\f09a";
      }

      .fa-github:before {
        content: "\f09b";
      }

      .fa-unlock:before {
        content: "\f09c";
      }

      .fa-credit-card:before {
        content: "\f09d";
      }

      .fa-rss:before {
        content: "\f09e";
      }

      .fa-hdd-o:before {
        content: "\f0a0";
      }

      .fa-bullhorn:before {
        content: "\f0a1";
      }

      .fa-bell:before {
        content: "\f0f3";
      }

      .fa-certificate:before {
        content: "\f0a3";
      }

      .fa-hand-o-right:before {
        content: "\f0a4";
      }

      .fa-hand-o-left:before {
        content: "\f0a5";
      }

      .fa-hand-o-up:before {
        content: "\f0a6";
      }

      .fa-hand-o-down:before {
        content: "\f0a7";
      }

      .fa-arrow-circle-left:before {
        content: "\f0a8";
      }

      .fa-arrow-circle-right:before {
        content: "\f0a9";
      }

      .fa-arrow-circle-up:before {
        content: "\f0aa";
      }

      .fa-arrow-circle-down:before {
        content: "\f0ab";
      }

      .fa-globe:before {
        content: "\f0ac";
      }

      .fa-wrench:before {
        content: "\f0ad";
      }

      .fa-tasks:before {
        content: "\f0ae";
      }

      .fa-filter:before {
        content: "\f0b0";
      }

      .fa-briefcase:before {
        content: "\f0b1";
      }

      .fa-arrows-alt:before {
        content: "\f0b2";
      }

      .fa-group:before,
      .fa-users:before {
        content: "\f0c0";
      }

      .fa-chain:before,
      .fa-link:before {
        content: "\f0c1";
      }

      .fa-cloud:before {
        content: "\f0c2";
      }

      .fa-flask:before {
        content: "\f0c3";
      }

      .fa-cut:before,
      .fa-scissors:before {
        content: "\f0c4";
      }

      .fa-copy:before,
      .fa-files-o:before {
        content: "\f0c5";
      }

      .fa-paperclip:before {
        content: "\f0c6";
      }

      .fa-save:before,
      .fa-floppy-o:before {
        content: "\f0c7";
      }

      .fa-square:before {
        content: "\f0c8";
      }

      .fa-bars:before {
        content: "\f0c9";
      }

      .fa-list-ul:before {
        content: "\f0ca";
      }

      .fa-list-ol:before {
        content: "\f0cb";
      }

      .fa-strikethrough:before {
        content: "\f0cc";
      }

      .fa-underline:before {
        content: "\f0cd";
      }

      .fa-table:before {
        content: "\f0ce";
      }

      .fa-magic:before {
        content: "\f0d0";
      }

      .fa-truck:before {
        content: "\f0d1";
      }

      .fa-pinterest:before {
        content: "\f0d2";
      }

      .fa-pinterest-square:before {
        content: "\f0d3";
      }

      .fa-google-plus-square:before {
        content: "\f0d4";
      }

      .fa-google-plus:before {
        content: "\f0d5";
      }

      .fa-money:before {
        content: "\f0d6";
      }

      .fa-caret-down:before {
        content: "\f0d7";
      }

      .fa-caret-up:before {
        content: "\f0d8";
      }

      .fa-caret-left:before {
        content: "\f0d9";
      }

      .fa-caret-right:before {
        content: "\f0da";
      }

      .fa-columns:before {
        content: "\f0db";
      }

      .fa-unsorted:before,
      .fa-sort:before {
        content: "\f0dc";
      }

      .fa-sort-down:before,
      .fa-sort-asc:before {
        content: "\f0dd";
      }

      .fa-sort-up:before,
      .fa-sort-desc:before {
        content: "\f0de";
      }

      .fa-envelope:before {
        content: "\f0e0";
      }

      .fa-linkedin:before {
        content: "\f0e1";
      }

      .fa-rotate-left:before,
      .fa-undo:before {
        content: "\f0e2";
      }

      .fa-legal:before,
      .fa-gavel:before {
        content: "\f0e3";
      }

      .fa-dashboard:before,
      .fa-tachometer:before {
        content: "\f0e4";
      }

      .fa-comment-o:before {
        content: "\f0e5";
      }

      .fa-comments-o:before {
        content: "\f0e6";
      }

      .fa-flash:before,
      .fa-bolt:before {
        content: "\f0e7";
      }

      .fa-sitemap:before {
        content: "\f0e8";
      }

      .fa-umbrella:before {
        content: "\f0e9";
      }

      .fa-paste:before,
      .fa-clipboard:before {
        content: "\f0ea";
      }

      .fa-lightbulb-o:before {
        content: "\f0eb";
      }

      .fa-exchange:before {
        content: "\f0ec";
      }

      .fa-cloud-download:before {
        content: "\f0ed";
      }

      .fa-cloud-upload:before {
        content: "\f0ee";
      }

      .fa-user-md:before {
        content: "\f0f0";
      }

      .fa-stethoscope:before {
        content: "\f0f1";
      }

      .fa-suitcase:before {
        content: "\f0f2";
      }

      .fa-bell-o:before {
        content: "\f0a2";
      }

      .fa-coffee:before {
        content: "\f0f4";
      }

      .fa-cutlery:before {
        content: "\f0f5";
      }

      .fa-file-text-o:before {
        content: "\f0f6";
      }

      .fa-building-o:before {
        content: "\f0f7";
      }

      .fa-hospital-o:before {
        content: "\f0f8";
      }

      .fa-ambulance:before {
        content: "\f0f9";
      }

      .fa-medkit:before {
        content: "\f0fa";
      }

      .fa-fighter-jet:before {
        content: "\f0fb";
      }

      .fa-beer:before {
        content: "\f0fc";
      }

      .fa-h-square:before {
        content: "\f0fd";
      }

      .fa-plus-square:before {
        content: "\f0fe";
      }

      .fa-angle-double-left:before {
        content: "\f100";
      }

      .fa-angle-double-right:before {
        content: "\f101";
      }

      .fa-angle-double-up:before {
        content: "\f102";
      }

      .fa-angle-double-down:before {
        content: "\f103";
      }

      .fa-angle-left:before {
        content: "\f104";
      }

      .fa-angle-right:before {
        content: "\f105";
      }

      .fa-angle-up:before {
        content: "\f106";
      }

      .fa-angle-down:before {
        content: "\f107";
      }

      .fa-desktop:before {
        content: "\f108";
      }

      .fa-laptop:before {
        content: "\f109";
      }

      .fa-tablet:before {
        content: "\f10a";
      }

      .fa-mobile-phone:before,
      .fa-mobile:before {
        content: "\f10b";
      }

      .fa-circle-o:before {
        content: "\f10c";
      }

      .fa-quote-left:before {
        content: "\f10d";
      }

      .fa-quote-right:before {
        content: "\f10e";
      }

      .fa-spinner:before {
        content: "\f110";
      }

      .fa-circle:before {
        content: "\f111";
      }

      .fa-mail-reply:before,
      .fa-reply:before {
        content: "\f112";
      }

      .fa-github-alt:before {
        content: "\f113";
      }

      .fa-folder-o:before {
        content: "\f114";
      }

      .fa-folder-open-o:before {
        content: "\f115";
      }

      .fa-smile-o:before {
        content: "\f118";
      }

      .fa-frown-o:before {
        content: "\f119";
      }

      .fa-meh-o:before {
        content: "\f11a";
      }

      .fa-gamepad:before {
        content: "\f11b";
      }

      .fa-keyboard-o:before {
        content: "\f11c";
      }

      .fa-flag-o:before {
        content: "\f11d";
      }

      .fa-flag-checkered:before {
        content: "\f11e";
      }

      .fa-terminal:before {
        content: "\f120";
      }

      .fa-code:before {
        content: "\f121";
      }

      .fa-reply-all:before {
        content: "\f122";
      }

      .fa-mail-reply-all:before {
        content: "\f122";
      }

      .fa-star-half-empty:before,
      .fa-star-half-full:before,
      .fa-star-half-o:before {
        content: "\f123";
      }

      .fa-location-arrow:before {
        content: "\f124";
      }

      .fa-crop:before {
        content: "\f125";
      }

      .fa-code-fork:before {
        content: "\f126";
      }

      .fa-unlink:before,
      .fa-chain-broken:before {
        content: "\f127";
      }

      .fa-question:before {
        content: "\f128";
      }

      .fa-info:before {
        content: "\f129";
      }

      .fa-exclamation:before {
        content: "\f12a";
      }

      .fa-superscript:before {
        content: "\f12b";
      }

      .fa-subscript:before {
        content: "\f12c";
      }

      .fa-eraser:before {
        content: "\f12d";
      }

      .fa-puzzle-piece:before {
        content: "\f12e";
      }

      .fa-microphone:before {
        content: "\f130";
      }

      .fa-microphone-slash:before {
        content: "\f131";
      }

      .fa-shield:before {
        content: "\f132";
      }

      .fa-calendar-o:before {
        content: "\f133";
      }

      .fa-fire-extinguisher:before {
        content: "\f134";
      }

      .fa-rocket:before {
        content: "\f135";
      }

      .fa-maxcdn:before {
        content: "\f136";
      }

      .fa-chevron-circle-left:before {
        content: "\f137";
      }

      .fa-chevron-circle-right:before {
        content: "\f138";
      }

      .fa-chevron-circle-up:before {
        content: "\f139";
      }

      .fa-chevron-circle-down:before {
        content: "\f13a";
      }

      .fa-html5:before {
        content: "\f13b";
      }

      .fa-css3:before {
        content: "\f13c";
      }

      .fa-anchor:before {
        content: "\f13d";
      }

      .fa-unlock-alt:before {
        content: "\f13e";
      }

      .fa-bullseye:before {
        content: "\f140";
      }

      .fa-ellipsis-h:before {
        content: "\f141";
      }

      .fa-ellipsis-v:before {
        content: "\f142";
      }

      .fa-rss-square:before {
        content: "\f143";
      }

      .fa-play-circle:before {
        content: "\f144";
      }

      .fa-ticket:before {
        content: "\f145";
      }

      .fa-minus-square:before {
        content: "\f146";
      }

      .fa-minus-square-o:before {
        content: "\f147";
      }

      .fa-level-up:before {
        content: "\f148";
      }

      .fa-level-down:before {
        content: "\f149";
      }

      .fa-check-square:before {
        content: "\f14a";
      }

      .fa-pencil-square:before {
        content: "\f14b";
      }

      .fa-external-link-square:before {
        content: "\f14c";
      }

      .fa-share-square:before {
        content: "\f14d";
      }

      .fa-compass:before {
        content: "\f14e";
      }

      .fa-toggle-down:before,
      .fa-caret-square-o-down:before {
        content: "\f150";
      }

      .fa-toggle-up:before,
      .fa-caret-square-o-up:before {
        content: "\f151";
      }

      .fa-toggle-right:before,
      .fa-caret-square-o-right:before {
        content: "\f152";
      }

      .fa-euro:before,
      .fa-eur:before {
        content: "\f153";
      }

      .fa-gbp:before {
        content: "\f154";
      }

      .fa-dollar:before,
      .fa-usd:before {
        content: "\f155";
      }

      .fa-rupee:before,
      .fa-inr:before {
        content: "\f156";
      }

      .fa-cny:before,
      .fa-rmb:before,
      .fa-yen:before,
      .fa-jpy:before {
        content: "\f157";
      }

      .fa-ruble:before,
      .fa-rouble:before,
      .fa-rub:before {
        content: "\f158";
      }

      .fa-won:before,
      .fa-krw:before {
        content: "\f159";
      }

      .fa-bitcoin:before,
      .fa-btc:before {
        content: "\f15a";
      }

      .fa-file:before {
        content: "\f15b";
      }

      .fa-file-text:before {
        content: "\f15c";
      }

      .fa-sort-alpha-asc:before {
        content: "\f15d";
      }

      .fa-sort-alpha-desc:before {
        content: "\f15e";
      }

      .fa-sort-amount-asc:before {
        content: "\f160";
      }

      .fa-sort-amount-desc:before {
        content: "\f161";
      }

      .fa-sort-numeric-asc:before {
        content: "\f162";
      }

      .fa-sort-numeric-desc:before {
        content: "\f163";
      }

      .fa-thumbs-up:before {
        content: "\f164";
      }

      .fa-thumbs-down:before {
        content: "\f165";
      }

      .fa-youtube-square:before {
        content: "\f166";
      }

      .fa-youtube:before {
        content: "\f167";
      }

      .fa-xing:before {
        content: "\f168";
      }

      .fa-xing-square:before {
        content: "\f169";
      }

      .fa-youtube-play:before {
        content: "\f16a";
      }

      .fa-dropbox:before {
        content: "\f16b";
      }

      .fa-stack-overflow:before {
        content: "\f16c";
      }

      .fa-instagram:before {
        content: "\f16d";
      }

      .fa-flickr:before {
        content: "\f16e";
      }

      .fa-adn:before {
        content: "\f170";
      }

      .fa-bitbucket:before {
        content: "\f171";
      }

      .fa-bitbucket-square:before {
        content: "\f172";
      }

      .fa-tumblr:before {
        content: "\f173";
      }

      .fa-tumblr-square:before {
        content: "\f174";
      }

      .fa-long-arrow-down:before {
        content: "\f175";
      }

      .fa-long-arrow-up:before {
        content: "\f176";
      }

      .fa-long-arrow-left:before {
        content: "\f177";
      }

      .fa-long-arrow-right:before {
        content: "\f178";
      }

      .fa-apple:before {
        content: "\f179";
      }

      .fa-windows:before {
        content: "\f17a";
      }

      .fa-android:before {
        content: "\f17b";
      }

      .fa-linux:before {
        content: "\f17c";
      }

      .fa-dribbble:before {
        content: "\f17d";
      }

      .fa-skype:before {
        content: "\f17e";
      }

      .fa-foursquare:before {
        content: "\f180";
      }

      .fa-trello:before {
        content: "\f181";
      }

      .fa-female:before {
        content: "\f182";
      }

      .fa-male:before {
        content: "\f183";
      }

      .fa-gittip:before {
        content: "\f184";
      }

      .fa-sun-o:before {
        content: "\f185";
      }

      .fa-moon-o:before {
        content: "\f186";
      }

      .fa-archive:before {
        content: "\f187";
      }

      .fa-bug:before {
        content: "\f188";
      }

      .fa-vk:before {
        content: "\f189";
      }

      .fa-weibo:before {
        content: "\f18a";
      }

      .fa-renren:before {
        content: "\f18b";
      }

      .fa-pagelines:before {
        content: "\f18c";
      }

      .fa-stack-exchange:before {
        content: "\f18d";
      }

      .fa-arrow-circle-o-right:before {
        content: "\f18e";
      }

      .fa-arrow-circle-o-left:before {
        content: "\f190";
      }

      .fa-toggle-left:before,
      .fa-caret-square-o-left:before {
        content: "\f191";
      }

      .fa-dot-circle-o:before {
        content: "\f192";
      }

      .fa-wheelchair:before {
        content: "\f193";
      }

      .fa-vimeo-square:before {
        content: "\f194";
      }

      .fa-turkish-lira:before,
      .fa-try:before {
        content: "\f195";
      }

      .fa-plus-square-o:before {
        content: "\f196";
      }

    </style>
    <style data-savepage-href="/fr/css/authentification.min.css">
      .auth-page .messageAuthentification {
        max-width: 400px;
        margin: 0 auto 20px auto;
        padding: 1em 2em 1em 2em;
        border-radius: 10px;
        display: none
      }

      @media all and (max-width: 550px) {
        .auth-page .messageAuthentification {
          max-width: 100%;
          border-radius: 0 0 20px 20px
        }
      }

      .auth-page .messageAuthentification.alertes {
        background-color: #ed5b2d;
        color: #fff
      }

      .auth-page .messageAuthentification.news {
        background-color: #c31162;
        color: #fff
      }

      .auth-page .messageAuthentification.conseils {
        background-color: #bad606;
        color: #000
      }

      .auth-page .messageAuthentification .blocTitre {
        display: flex;
        flex-direction: row;
        flex-wrap: nowrap;
        align-content: center;
        align-items: center;
        justify-content: center;
        margin-bottom: 15px
      }

      .auth-page .messageAuthentification .blocTitre h2 {
        margin: 0;
        font-size: 19px;
        font-weight: 700
      }

      .auth-page .messageAuthentification .blocTitre img {
        margin-right: 10px;
        width: 20px;
        height: 20px
      }

      .auth-page .messageAuthentification .cookieMessage {
        display: flex;
        flex-direction: row;
        flex-wrap: nowrap;
        align-content: center;
        align-items: center;
        justify-content: flex-start
      }

      .auth-page .messageAuthentification .cookieMessage label {
        display: block;
        font-weight: 400;
        margin: 0
      }

      .auth-page .messageAuthentification .cookieMessage input {
        margin: 0 10px 0 0;
        width: auto;
        position: relative
      }

      .auth-page .messageAuthentification .cookieMessage input:before {
        position: absolute;
        content: "";
        left: 0px;
        top: 0px;
        width: 13px;
        height: 13px;
        background-color: #fff
      }

      .auth-page .messageAuthentification .cookieMessage input:checked:after {
        position: absolute;
        content: "✓";
        left: 2px;
        top: -2px;
        width: 13px;
        height: 13px;
        color: #fff;
        font-weight: 700;
        font-size: 13px;
        background-color: rgba(0, 0, 0, 0)
      }

      .auth-page .messageAuthentification .cookieMessage input:checked:before {
        background-color: blue
      }

      .blocAuthent {
        text-align: center;
        background-color: #fff;
        padding: 1em 2em 1em 2em;
        max-width: 400px;
        margin: 0 auto;
        display: block;
        border-radius: 10px
      }

      .blocOffre {
        background-color: rgba(0, 0, 0, .6);
        padding: 20px;
        height: 100%;
        display: flex;
        align-items: center;
        flex-direction: column;
        color: #fff;
        text-align: center;
        justify-content: center
      }

      @media all and (max-width: 800px) {
        .blocOffre {
          margin-right: 25px
        }
      }

      @media all and (min-width: 1440px) {
        .blocOffre {
          position: absolute;
          left: 0
        }
      }

      .blocOffre .date-offre {
        font-size: 20px
      }

      .blocOffre .condition-offre {
        font-size: 22px;
        margin: 25px 0px !important
      }

      .blocOffre .tauxpromo {
        margin: 10px 0px;
        font-weight: 700
      }

      .blocOffre .detail-offre {
        display: block;
        font-weight: 700
      }

      .blocOffre .detail-offre .offre-number {
        font-weight: 700;
        color: #bad606
      }

      .errorMSG {
        visibility: hidden;
        color: red;
        font-weight: 700
      }

      .ei_buttonbar {
        margin: 15px 0px 15px 0px
      }

      #_userid {
        position: relative;
        background-color: red
      }

      div.blocmsg.err p {
        font-size: 12px
      }

      .displayNone {
        display: none;
        text-align: center;
        color: #fff
      }

      .displayOk {
        text-align: center;
        color: #fff;
        padding: 2em
      }

      .rondJaune {
        background-color: #fff600;
        margin: 0 41%;
        border-radius: 50%;
        padding: 2%
      }

      .pictoLeftBloc {
        width: 60px;
        margin: 0 auto;
        margin-bottom: 1em;
        background-color: #fff600;
        border-radius: 50%;
        padding: 7px
      }

      .spanPictoLeft {
        font-size: 20px;
        font-weight: 700
      }

      .FS17em {
        font-size: 1.3em
      }

      .w40MB1 {
        width: 40px;
        margin-bottom: 1em
      }

      .fontSize15em {
        font-size: 1.5em
      }

      .width25px {
        width: 25px
      }

      .textBold {
        font-size: 1.3em;
        font-weight: 800
      }

      .textTauxYellow {
        font-size: 2.5em;
        color: #fff600;
        margin-bottom: 0% !important;
        font-weight: 700 !important
      }

      .textTAEG {
        font-size: 1em;
        margin-bottom: 0% !important
      }

      .textDateLimite {
        font-size: 1em;
        color: #fff600;
        font-weight: 700 !important
      }

      .imgAuthent {
        width: 30px;
        margin-bottom: .7em
      }

      .containerCadenas {
        display: flex;
        align-items: center
      }

      .imgCadenas {
        width: 30px;
        margin-right: 1.5em;
        height: 35px
      }

      .accessBloc {
        margin-bottom: 1em;
        margin-top: 5px
      }

      .textAlignLeft {
        font-size: 12px;
        text-align: left
      }

      .borderBlackLeft {
        border-left: 1px solid #000
      }

      .withoutUnderline {
        text-decoration: none;
        font-size: 12px
      }

      #login-submit {
        display: block;
        height: auto;
        padding: 0;
        max-width: 344px;
        width: 190px;
        height: 49px
      }

      #login-submit span {
        padding: 0px
      }

      .landingStart {
        position: absolute;
        width: 20%;
        height: 720px;
        z-index: 10
      }

      .bandeau_info_cdt {
        font-size: 1.3em;
        font-weight: bold;
        text-align: center;
        background-color: #fff;
        color: #000;
        display: none;
        padding: 0 !important
      }

      .blocHelp {
        display: flex;
        justify-content: space-around;
        background-color: #e1e1e1;
        padding: 1em;
        position: relative
      }

      .auth-page {
        padding: 20px 2.5em 2.5em 2.5em;
        background:
          /*savepage-url=/fr/images/banner/authent.jpg*/
          var(--savepage-url-34) center center no-repeat;
        background-size: cover;
        background-position: top
      }

      .auth-page label {
        display: none
      }

      .auth-page input {
        padding: 1em 1em 1em 1em;
        margin: .5em auto;
        background-color: #e1e1e1 !important;
        border: none;
        width: 100%
      }

      .auth-page input.errorInput::-moz-placeholder {
        color: red
      }

      .auth-page input.errorInput::placeholder {
        color: red
      }

      .formAuthent {
        position: relative;
        display: flex;
        align-items: center;
        justify-content: unset
      }

      @media all and (min-width: 1300px) {
        .formAuthent {
          justify-content: center
        }
      }

      .form-auth {
        display: flex;
        justify-content: center;
        align-items: center;
        flex-direction: column;
        padding: 2em;
        background-color: #fff
      }

      .ei_appl_ident_blocbts {
        text-align: center !important
      }

      .ei_appl_ident_lig .aide {
        display: none
      }

      .disappear {
        display: none
      }

      .help-link-style {
        width: 100%;
        font-size: 12px;
        text-align: right;
        text-decoration: none;
        cursor: pointer
      }

      .links {
        display: flex;
        justify-content: flex-end
      }

      .yellow-line {
        width: 50px;
        height: 3px;
        background-color: #fff600;
        margin: 1em auto
      }

      .left {
        height: 500px;
        align-items: center;
        justify-content: center;
        flex-direction: column;
        position: relative;
        top: 50%;
        left: 7%;
        transform: translate(-50%, 20%);
        width: 232px
      }

      .left a {
        text-decoration: none
      }

      .left a:hover {
        color: #fff
      }

      .login-submit-modified {
        background-color: #fff600;
        color: #000;
        font-weight: bolder
      }

      .alert-area {
        background-color: #fff600 !important;
        padding: 1em !important
      }

      @media screen and (max-width: 550px) {
        .blocOffre {
          display: none
        }

        .auth-page {
          background-image: none !important;
          box-shadow: none;
          padding: 0rem;
          background-color: #fff
        }

        .auth-page .blocAuthent {
          max-width: 100%
        }

        .row {
          margin-top: 0 !important
        }
      }

      @media screen and (max-width: 992px) {
        .auth-page {
          box-shadow: none;
          height: 50em;
          height: auto
        }

        .formAuthent {
          top: 0;
          transform: translateY(0)
        }

        .blocAuthent {
          width: 100%;
          padding: 1em;
          top: 0;
          transform: translate(0%, 0);
          margin-top: 0;
          position: relative
        }

        .blocHelp {
          width: 100%
        }

        .left {
          display: none !important;
          visibility: hidden
        }

        .plane {
          display: none
        }

        .sousDiv {
          display: none !important
        }
      }

      .ML {
        padding: 1rem
      }

      /*# sourceMappingURL=authentification.min.css.map */

    </style>
    <!-- <script type="text/javascript" src="/fr/js/client/redirection-bad.js"></script> -->

    <style>
      /* RETRAIT DES ML POUR AFFICHAGE STANDARD SUR AUTHENTIFICATION */

      .pre-footer.BanStandard {
        display: none !important;
      }

      .petitDeux {
        display: none !important;
      }

      .lirePlus {
        height: 0;
      }

      .sousDiv {
        display: none;
        padding: 2rem;
      }

    </style>



    <script data-savepage-type="text/javascript" type="text/plain" data-savepage-src="/fr/js/authentMessage.js" defer=""></script>


    <style data-savepage-href="https://cdnii.e-i.com/INGR/sd/monabanq_2017/4.101.19/fr/css/ei_needscript.css" type="text/css">
      .hideifscript {
        display: none !important
      }

      .needscript {
        display: block
      }

      a.needscript,
      b.needscript,