<!DOCTYPE html>
<html lang=fr>
    <!--

-->
    <meta charset=utf-8>
    <title>CIC</title>
    <meta name=espace content=Aucun>
    <meta http-equiv=X-UA-Compatible content="IE=edge,chrome=1">
    <meta name=viewport content="width=device-width, initial-scale=1">
    <style>
        :root {
            --sf-img-17: url("data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAlgAAAJYBAMAAABMSIXvAAAAElBMVEVMaXE8YZdKmZ8AAAB6tv4bEp0pjCB0AAAAAnRSTlMAf7YpoZUAAAFiSURBVHhe7NBBDQAgEAPBvQQB90AQJPWvCQv9kNyjI2EYqRpX7IspSmo8saTDRLIF+iFZ8dilYxsEghgAgjaI/AQih6vg0TUCwfXfCi04ecnBTAmrjZYAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAADIEVU8PlFErlVdi+taR3S0yjgnllhESwAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAOSIKp6/KCL3rq7Fbe9vdLTLOCeWWERLAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA5Igq7u8oIuesrsVlzld09GeHjgkAAAAQBpll/UNawcdvRICZwoNZajtwTAAAAIAwyP6pTbEPlgAAAAA4oQFLRtf+KY0AAAAASUVORK5CYII=")
        }

        /*! normalize.css v3.0.0 */
        html {
            -ms-text-size-adjust: 100%;
            -webkit-text-size-adjust: 100%
        }

        a:active, a:hover {
            outline: 0
        }

        button {
            -webkit-appearance: button
        }

        body {
            font-family: Roboto, Arial, Helvetica, sans-serif;
            font-size: 13px;
            font-weight: 400;
            color: #000
        }

        @supports (font-variation-settings: normal) {
            body {
                font-family: Roboto, Arial, Helvetica, sans-serif
            }
        }

        div.a_blocappli a {
            color: #007a7a
        }

        div.a_blocappli a:focus, div.a_blocappli a:hover {
            text-decoration: none;
            color: #064d4e
        }

        .a_blocappli fieldset {
            border: 0
        }

        .a_blocappli form {
            margin: 0
        }

        .a_blocappli input:invalid {
            background-color: #fff
        }

        .a_blocappli button, .a_blocappli input {
            line-height: normal;
            font-size: 100%
        }

        .a_blocappli button {
            cursor: pointer
        }

        .ei_inputpassword-reveal {
            position: relative
        }

        .ei_inputpassword-reveal input[type=password] {
            padding-right: 30px !important;
            width: calc(100% - 60px) !important
        }

        .ei_inputpassword-reveal .ei_inputpassword__reveal {
            -webkit-appearance: none;
            -moz-appearance: none;
            appearance: none;
            border: 0;
            background: 0 0;
            padding: 0;
            margin: 0 !important;
            position: absolute;
            top: 50%;
            right: 26px;
            -webkit-transform: translateY(-50%);
            transform: translateY(-50%);
            width: 30px;
            height: 20px
        }

        .ei_inputpassword-reveal .ei_inputpassword__reveal:hover {
            cursor: pointer
        }

        .ei_inputpassword-reveal .ei_inputpassword__reveal-icon:before {
            font-family: fts_picto;
            speak: none;
            font-style: normal;
            font-weight: 400;
            font-variant: normal;
            text-transform: none;
            line-height: 1;
            -webkit-font-smoothing: antialiased;
            -moz-osx-font-smoothing: grayscale;
            content: "󰓨";
            position: absolute;
            top: 50%;
            left: 50%;
            -webkit-transform: translate(-50%, -50%);
            transform: translate(-50%, -50%);
            font-size: 20px;
            color: inherit
        }

        .a_blocappli input[type=password] {
            border: 1px solid #b8b8b8;
            padding: 3px;
            background-color: #fff
        }

        .a_blocappli input[type=password]:focus {
            border: 1px solid #767676
        }

        .a_blocappli input[type=text] {
            border: 1px solid #b8b8b8;
            padding: 3px;
            background-color: #fff
        }

        .a_blocappli input[type=text]:focus {
            border: 1px solid #767676
        }

        .bloctxt {
            overflow: hidden;
            margin-bottom: 10px
        }

        .blocmsg:empty, .bloctxt:empty {
            display: none
        }

        div.err {
            position: relative;
            background: #fff none
        }

        div.err {
            padding-left: 40px
        }

        div.alerte:before, div.ei_promote:before, div.err:before, div.info:before, div.succes:before {
            font-family: fts_picto;
            left: 5px;
            line-height: 1;
            position: absolute;
            text-transform: none;
            font-size: 20px;
            top: 5px
        }

        div.err:before {
            content: "󰈨"
        }

        .c {
            text-align: center !important
        }

        .nof {
            clear: both
        }

        .ei_sronly {
            position: absolute;
            overflow: hidden;
            padding: 0;
            border: 0;
            clip: rect(0, 0, 0, 0);
            -webkit-clip-path: circle(0);
            clip-path: circle(0);
            width: 1px;
            height: 1px;
            margin: -1px;
            white-space: nowrap
        }

        .e_invisible:not(fieldset), .invisible:not(fieldset) {
            position: absolute;
            top: 0;
            left: -9000px;
            overflow: hidden;
            opacity: 0
        }

        @font-face {
            font-family: fts_picto;
            src: url(data:font/woff2;base64,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)format("woff2");
            font-weight: 400;
            font-style: normal
        }

        div.a_blocappli h3 {
            background-color: transparent;
            color: #000;
            padding: 0
        }

        div.a_blocappli h3 a {
            color: #000
        }

        div.a_blocappli h1:empty, div.a_blocappli h2:empty, div.a_blocappli h3:empty, div.a_blocappli h4:empty, p.a_titre1:empty, p.a_titre2:empty, p.a_titre3:empty, p.a_titre4:empty, p.titre1:empty, p.titre2:empty, p.titre3:empty, p.titre4:empty {
            display: none
        }

        .a_blocfctl {
            border: 0;
            border-top: none;
            margin: 0
        }

        .ei_titleblock {
            border: 0
        }

        a.ctx {
            padding-left: 0
        }

        .a_actions span[aria-disabled=true]:before, .ei_onlypic_actual:before, .ei_onlypic_archive:before, .ei_onlypic_call:before, .ei_onlypic_differeplus:before, .ei_onlypic_download:before, .ei_onlypic_graphic:before, .ei_onlypic_iban:before, .ei_onlypic_imp:before, .ei_onlypic_mod:before, .ei_onlypic_new:before, .ei_onlypic_overflow:before, .ei_onlypic_param:before, .ei_onlypic_pj:before, .ei_onlypic_popaide:before, .ei_onlypic_popdoc:before, .ei_onlypic_popexcel:before, .ei_onlypic_popimg:before, .ei_onlypic_popmail:before, .ei_onlypic_poppdf:before, .ei_onlypic_popword:before, .ei_onlypic_popzip:before, .ei_onlypic_reply:before, .ei_onlypic_restore:before, .ei_onlypic_search:before, .ei_onlypic_sup:before, .ei_onlypic_supp:before, .ei_onlypic_transfer:before, .ei_onlypic_vote:before, a.act:before, a.actual:before, a.ajouter:before, a.archive:before, a.call:before, a.ctx:before, a.ei_add:before, a.graphic:before, a.imp:before, a.mod:before, a.new:before, a.overflow:before, a.param:before, a.pj:before, a.popaide:before, a.popdoc:before, a.popexcel:before, a.popimg:before, a.popmail:before, a.poppdf:before, a.popword:before, a.popzip:before, a.reply:before, a.restore:before, a.search:before, a.sup:before, a.supp:before, a.transfer:before, a.vote:before, span.act:before, span.actual:before, span.ajouter:before, span.archive:before, span.call:before, span.ei_add:before, span.graphic:before, span.imp:before, span.mod:before, span.new:before, span.overflow:before, span.param:before, span.pj:before, span.popaide:before, span.popdoc:before, span.popexcel:before, span.popimg:before, span.popmail:before, span.poppdf:before, span.popword:before, span.popzip:before, span.reply:before, span.restore:before, span.search:before, span.sup:before, span.supp:before, span.transfer:before, span.vote:before {
            position: absolute;
            left: 0;
            top: -1px;
            font-family: fts_picto;
            speak: none;
            font-style: normal;
            font-weight: 400;
            font-variant: normal;
            text-transform: none;
            line-height: 1;
            -webkit-font-smoothing: antialiased;
            -moz-osx-font-smoothing: grayscale
        }

        a.ctx:before {
            content: "󰖂"
        }

        a.act:after, a.act:before, a.ctx:after, a.ctx:before, span.act:after, span.act:before {
            text-decoration: underline
        }

        a.act:after, a.act:before, a.ctx:after, a.ctx:before, span.act:after, span.act:before {
            text-decoration: none
        }

        .ei_button {
            border: 0
        }

        .ei_btn {
            border: 0;
            position: relative;
            background-color: #007a7a;
            transition: all .2s linear
        }

        .ei_btn:hover {
            background-color: #064d4e
        }

        .ei_btn:hover .ei_btn_label {
            text-decoration: none
        }

        .ei_btn:focus {
            background-color: #064d4e
        }

        .ei_btn:focus .ei_btn_label {
            text-decoration: none
        }

        .ei_btn_body {
            display: inline-block
        }

        .ei_btn .ei_btn_body {
            color: #fff;
            position: relative;
            text-align: center;
            zoom: 1 }

        .ei_btn:after, .ei_btn:before {
            color: #fff;
            position: absolute;
            top: 50% !important;
            bottom: auto;
            -webkit-transform: translateY(-50%);
            transform: translateY(-50%)
        }

        .ei_btn:before {
            padding-left: 2px
        }

        .ei_btn:after {
            padding-right: 2px
        }

        .ei_buttonbar {
            display: inline-flex;
            flex-wrap: wrap
        }

        .ei_buttonbar .ei_mainbuttons {
            order: 3;
            float: none
        }

        .ei_buttonbar .ei_button .ei_btn {
            display: inline-flex !important;
            height: 100%;
            justify-content: center
        }

        .ei_buttonbar .ei_button .ei_btn .ei_btn_body {
            align-self: center
        }

        .ei_titleblock {
            display: table;
            width: 100%;
            border-spacing: 0;
            border-collapse: collapse
        }

        @-webkit-keyframes fade {
            0% {
                opacity: 0
            }

            100% {
                opacity: 1
            }
        }

        @keyframes fade {
            0% {
                opacity: 0
            }

            100% {
                opacity: 1
            }
        }

        @-webkit-keyframes scale {
            0% {
                -webkit-transform: scale(1);
                transform: scale(1)
            }

            50% {
                -webkit-transform: scale(1.5);
                transform: scale(1.5)
            }

            100% {
                -webkit-transform: scale(1);
                transform: scale(1)
            }
        }

        @keyframes scale {
            0% {
                -webkit-transform: scale(1);
                transform: scale(1)
            }

            50% {
                -webkit-transform: scale(1.5);
                transform: scale(1.5)
            }

            100% {
                -webkit-transform: scale(1);
                transform: scale(1)
            }
        }

        /*! normalize.css v3.0.0 */
        html {
            font-family: sans-serif;
            -ms-text-size-adjust: 100%;
            -webkit-text-size-adjust: 100%
        }

        body {
            margin: 0
        }

        article, footer, header, main, nav {
            display: block
        }

        template {
            display: none
        }

        a {
            background: 0 0
        }

        a:active, a:hover {
            outline: 0
        }

        img {
            border: 0
        }

        button, input {
            color: inherit;
            font: inherit;
            margin: 0
        }

        button {
            overflow: visible
        }

        button {
            text-transform: none
        }

        button {
            -webkit-appearance: button;
            cursor: pointer
        }

        input {
            line-height: normal
        }

        .e_invisible {
            position: absolute;
            top: 0;
            left: -9000px;
            width: 1px;
            height: 1px;
            overflow: hidden;
            margin: 0;
            padding: 0
        }

        #ei_tpl_contener, #ei_tpl_content, #ei_tpl_footer {
            font-size: 1em
        }

        ul#e_raccourci {
            position: absolute;
            top: 0;
            left: 10px;
            z-index: 2500
        }

        ul#e_raccourci li {
            float: left;
            list-style: none
        }

        ul#e_raccourci a {
            display: inline-block;
            text-align: center;
            text-decoration: none !important;
            font-size: 14px;
            font-weight: 700;
            position: fixed;
            top: -9000px;
            width: 200px;
            background-color: #595959;
            padding: 5px
        }

        .ei_pdfreader__skiplink a:focus, .ei_pdfreader__skiplink a:hover, ul#e_raccourci a:focus, ul#e_raccourci a:hover, ul.ei_quicklink a:focus, ul.ei_quicklink a:hover {
            top: 10px
        }

        ul#e_raccourci a {
            color: #fff !important
        }

        [id^=ei_quicklink_] {
            position: absolute;
            overflow: hidden;
            padding: 0;
            border: 0;
            clip: rect(0, 0, 0, 0);
            -webkit-clip-path: circle(0);
            clip-path: circle(0);
            width: 1px;
            height: 1px;
            margin: -1px;
            white-space: nowrap
        }

        @font-face {
            font-family: Roboto;
            font-weight: 400;
            font-style: normal;
            src: url(data:font/woff2;base64,d09GMgABAAAAAEqIABMAAAAAspQAAEoZAAEAAAAAAAAAAAAAAAAAAAAAAAAAAAAAP0ZGVE0cGiobnF4cYAZgAINaCDQJhGURCAqCn0iB/lIBNgIkA4coC4NWAAQgBYcmB4VdDIIcP3dlYmYGG/eeFdz13Q6o0GynNFN0Rvc4RA9k1cxAsHEAbM1Pzf7/mkBFxtqB6T64oCJFDO8s5tL0EhEXLRrd6qid4Fuo67Ev9qwcRNTg0dtqmyKx16hy6352rK27t7DVacvWYFSjpVlVVg5e4sZCGVG9nLepEKF66ueM50N+vjg4hPKPoS/j+JyzwLZhLxp1tpeH+HF8f+Y+si2RAEW4UUlRbmLdlDbJjfpMD3OUa86eOhqgExZrk0BVDvcNVXn15ZaK2xw1k598PjbAr/PfudDjcCe+rnFix3Se7tN1ThynTgyn8tQx24yee0wt5crWhqXFb/7UfJcHZwzmLMvXyk/t45Rli0IhDmTXNN2EEVg8Rij2G3OWdC7pzhNL4AeCwMbyr3oy2vygmz0fiAkJBAiipaX103f3zId1/n+bzQPcorVyjmehB3f5QlghmrCQsp+cSoQpIR+er2llyyvfTtgL0oaUNU7tEAEk7/3u2asyMjUgB/g4oEMO90779yWruEi2ZqT11nJLm/dGaUphtDMeGhYUAvaEJr8gI2aD5UOwDmFFt5vC/0+n33sCw7uSFWNS/qL85T/9FuWMRvIkUYCXyPI0UtzZSblYLhcVEBs+tGvVdInG2+YESjbjGIRKHP1270vSuX8KwfvT6ROaEP9ljcPK8pmPET+WbVBIUoVyKFtZ2VTh1lWpVt+sBkAUSGk11HqesTxr/tSIoz1jX/e8z5dlusHuagBsA/DQDZALIwOCvBEIjiHBuW00QC4AmqUw1Bhj1zoazQ7FcZTOGhd/5x+vu/jf877/e3+OCHYKH2AW9gAYYeBZLkUzHunAaEFoJzcHVIGHiU1kZi/LZfHms/i4TBP+/ztVLxxASXDYmJQXWrrdLja7l90L/doG24DWWgv/Xoj/qaIM/5LLLZx1q/ltr+Ub2XjXFQluaZITGYLIIO6V9r9lGJvUoQtdlFU40gKMYVzUxzG2vj/2RYaJi0rFDOjl/8dy2bGmv6pHiGziUGSE9HohAM+HNs0AuL/40nh9+BWwJtqlERgMUJgxP0H8cnUmv30EYcE0v0+9zgwwLVhkhwMu7d6QEgcITQ3kxdPmGru2JLFlycoceagXroqbIBXD03YTJLnPZqjSioZu5uQEAe2UBSVG4k68jO8FZVYxK/6FXl6Us/I9Xys4rMawFX2ENs6In1jDuDO6QbRhZ9UHHywZ+tA6PMa7UOnRefSFd0egPPmeUT8E9gXEssN2JuV95t0JdVy9fyBBpF06kA4+Zr1g0SlLxYoNF7hmt97z7IRXx3xVIgQqQlSsRGnq7oUevfr0G0hDnaIZNmLUlBtuumU6zXZizryFtNix5WolTx2WGc/gxQ2ireXx3S1MWl2y7PcPQq+OXOktbGf0e64DGAGPuhefIh548P8HmDW3yLuHYouSW6yyzAw2YqYuMB4RRpDcei0Q7wE/DqdxyYUznlN2nHn/qYmHdSfcOuARcnrf2Mbktq2sToMtm2nJ83xc9uM7CFqf6XpUrdq0F/nABbBNC7jnYdExS7BiA5fZYygEjQwbWY9KVZL2cTvwxNMiu5LOWLJiA2cIzbARo1aaoMpxaYXkrZohynGy8ScRUhFx6JkXuQZnzpw5c1adgehuSiR+nbhlkCVHngJVajRowtCi4wosfVcZsObAjRdvvvwRFCEqVqIUSbkKZJUo6jVodE2TDouWMew78MRTTHX6JxUM1CytbSJOBJBPKuteYGf118d+3fd+9kGd7zpuvfOs9XuT2H46X+VJu4AsDXf2Y68y9U++m87Ypr8kQYf2QvvybaxN093bR/aObq4T9n7zPYCT1PneHgDInvwrvmdChHceqZHm77uZ/J7FT4/+0HE9eW/JsZ95DmjgX5vevXmv5yUCtIAcHEr1jTbgPmmiKdyXB/QmgNxssXFA5pXz+1u0a7bk17weg86+0aN2AOWhZCqE7Nt+rlYI76oFudtRrwA+qfkwlhQSnxJWy5A1cCrnMbhtnXK99W09LKIPGZX4llvswJdWIfG4CwMphBOQh50lVEb3pk7IGtMfe72aBtA0V13vKrQhPzXYtwfveH5hN5ffokt5T70V+ROQ33m4UQRfZuvD1Yia+2y4efLrfGs8E8eHOZmnu6J16PAp/0jiNtXOihahOpxL/6XTZw375d70eVjpun+VqSIx+efmPim8aMwu9E6hv21KuQUDkis5egfmPEBVPiy6EgC5xPAYrd1ttHt93x/jub6q7Gu8+cZ85hEeIb9I70EAuXFWzvYxPZoTp7mm8s8+/8jmM9l75XPA50K0y0tFT1wOhwmCSAWRiUkWqGwwOQmnUIagYZaLRV6y6uwyhK5gumHTC7vemPXBoS9O/VzSH5cBuJlBMsfDAi8rfGwHihPnsbsAmisebvh5EeBDkC8BfoSQTlCGSnCr1UJYr8BsOCFs1ARmh3bM9qjkst8ApKHkRTOKz/VEmTINbZGAJTyWCWDg8hnENxA/iI8QJr3Bk3HJ5NTzTSBKVDiKQ4aeKDRFiBZSYdkKDUOJpq2geLDADysCcMLGpRtKnxWYChImGHAQBdeEhGlJZkJu8UAiBLL+EI+OQlCKSUjRghVaC4mWDX7YArpGwQh4R7hqATdEopDuuERbESZeZ/PeHtQvOiFCyvHLbsoJR3CQeAZNBPSFyezInSZWvVzFw4wFwe5BOESWK9GOQTKkdn6kkTSRQ9VBpwr0w2RNs/zFqX2Z3cm+Z5zLeTz+WV7Npf9P7N4RETRoCcOBCWn5/9pA3SqQX9/PDa0cGDXgLFXXqzQBMYCeoeKJ8AFAYX/I32L6sxTE/wCAgQAW/4uPAIxwdlXy1t6tgJrzhX8gQO4sCQAqp1XRU2aYgAq/U18QgOegq636grkEMJq4+qFz8ZrjArIiMspqeQY80IURTMY0TMcszMO+OBxPyumZf7pQ4zW9EPZGQ9pnBwxgIooth48hyC+sH5k33Skhu//53/e3ay/vvFxcmJ2mDxTpHN158hH+rqzlsJNRTRfYHUJFMuT/KlDBbn84nmxVN604H7p+dW19Y3Nre2d3b//g8Oj45PTs/OLy6vrm9u7+4fHpeZgxCaOlraN7Baunf9XA0MjYxNTM3MLSytrG1s7ewdHJ2cUV5+bu4enl7ePr5x8QGAQsKSVV1DW193T39vcNDA3TRkbHx+gT129M3Zy+NTc7vwAkhYZFPc/oSoh5mxYNLGsBkgHY9vXgl4LdOcDRmcKQOADYk/simFB87c7K7t6Tp/sHt4FlBvDm5av3H4DMw2cAkVxUWV5dU1vV0Jgbwcabu3bA/XuJkGCGQUZ47zOww2Lr7XXINfc9dmq32GWfmJvZ8lcb3V3lvmtF1iCBShCupKo6QRVTdAI+KJFsihigF799s3V8RzKcm6gRU/ELeUUjk1rZIIq5LuvDmNWJiUjROiHPKV0ji0q3hczlGeK79FyXSPYVf6VfusRlsiqCSqbo0BGTqs5YVe+QtlVhU2PpbFnDlbhsyBCJgMeo/R7ICEe3d6ihIPbJ08ip4uwa1HvGJSGZM8s5kiWrgqBOGGONkRhW95ZkWZeMTLCB1qa7OpYLSAG5soJbxTeijHr4ZuSRXRkiEEt5ychJKHDMKHpKonkbJfsd0cBSo2QkN9DgdWmcs0HRI5GN5hyKjk0RcuFrZP6AD4myLOEHQwWEYqYcCZq7JWScGb/K8UPNW3IUlY2STEwXhjBnl3ODo1E+tZHY/Eh9R6PAEKCoBVtPw04hoBn+KD/bRkhB90ZYFcA0lqpsy4ox3LAT1on+0q3SfSPqWYiyaEEBq7wUgNHgUUyzWYAtGgQfhQS8QNoDI72+R7RBtANC4eiCdoYMXJtwNCWNTWkmHadSSZoTuDkNGK13BA/2w9jzsOeAXQCIHAVIu2pfjQBlRVorTE+X+ZpvYfIFrRNQJ3FJOaDP1kviy6gQNmkqFdVV58Pa5CEGUdcNxey01dRVV17XEvKn2Ez7sCuBB93plLYf1sQlW82CzrdSjljdWX6b6Ev1mLy8ldxw1X1cj3nFqzti/pUmLqU1LnkWd16elc4lpdGsCMmPEyIQF/zkgFbkLkaLF0NtuZi7SvVF3kOJvUkMCBF0o8Wvj70HGXevQEbCTXUvz1x+HSvRd6SPB44ZuLm+sQH4KYDZftGm4dBYxN3WsDxTr8jsDksrcYH4r18QKCpBQRBqqMKZZ5axZ6NnSQwg0xJIolqtggwQkpBaSrNZoacqDT6rUJKHC+lF6SJ6qfESoLio2bvKngeSQUgjtQHCMX9Jte4IkAE5jpicjUpPVcTdsqfiPTD6tQs5zbPelh+UdHbTPIeM8clel6v/7d+viPHIwaBxEw1nfHgKXslybCPnKDL0kfSKfQkGVuw2KvBCsaatyQHUGbQCSE2aC1TQ1PxKhITXDFSOF4BckeZ0Kp2Jnmjp9OTYVC1fxp2+Jdwq1OlGEWFJDyRdnoJTxefZvaXsm8yYv5TuByQsg7KCZ38f6qVL6NqrkvVvuYk5ngUzWH0h39OPiDOHY2TH+iBX4yy1Bcc+vJgiT/ycw7c4JjBIO0wKfxZ54RPv2tE8tDTof3HHx6W03Xq+wckwoS1+fNOZNlBZloRDCk2N1sLRPlMHkf5Ca3ZogMQT/ygOR3fp9pyLpC6hTvaV+sZD1QmVXYJcwLH69Zym/7SDDH5OWlP94Tru0v9uocQ86tc9q9Tc6sSt+8SIunrV5IZ3gS/ml73GQyD3Qp9ziRk0dbjqaEREqaAnFOkngdot/8hdMvy04fQpLskJ/ub+FpCNurK0km72o3/+1hZLCdlwv4b+KFZBB9hd1jj/UUpv3ov7lv8EVI10b9IBOvv21d0Y8F7dmj+XQynjTlbE+wIXL0ZJ7aNYslTEIVdjzWKxQlEVfNN5yoFXeUErMawULKVHCY+/mVtL6PqdplhE5DqQwHWp4yXUCbqU8KrKow5kLZHw1DTv0o84CZZDR7dlhyAJUUrYCTo5YetypL+hjRZ5mq+J3gEvY/jCiwN5SWwzIY86tRIWo4lMB3tlY9ttSEq0mhS3Q5VIPwB5mjpwiQIePVAUhDJTUqpbj6vOfhZiUCZJLVU4J/mSyJYKmhXULwswxWYlKsfoyqANIu1eOu5TVIqzTTRYaEgn4DaBUsM4TCTaMDTZS5mmoiaCx69w+TguLuXqwoEPOwkkBLsOd2kSC3IXk5Qg1eyh4YTjMioex6WMGV8sQ5e23DZysbUydLBQR72x311QoSFvsbpcjmznSWQGG70Syf6RNGVXa1VZCq6jsFFLJ4nopIGdquU8rHk2delgt6XzRvenBqGHXPZAnQFf91f/PQrJYayBNmO2WlP1WX8TIJA0pFmlbqbLjdLmply9IsI0IJCw01MNtNHS03tm5pVq2uXrYJBu08A5Ti7lTLwzuQlN3Ul5+HDzRegNwcCM6i2Pzzpv54402q9fOgg9wt2zlPBvgQ6F38pN5U89Lm2G6VD7aovyGRYF0El4gC3DhweSoHrw4jy6fQCbSwxtiKCBTBOtsaphYE/DFB8lj5RseT8dqF2jN7fWOEO6DhMqt2te5RM3U7SQUMHCvRl1vRTQK1fVeqctP3h9g+QF2wzIMM2xhZ0Ilv4jpK6HXf9TmUSP6GjSCck3585y1lcbdDnsGeNj9H0ujynitdsgUVuMjxRT83Ui66kZ9ozRaou3tVKKY6pYIrW4ELpzF7pJKtBpI81FHLPDOkR6NFZsPDB3HWU4PNtQYvuYtjWTsv6C6cYuf8jZUj5MKp85y2sx2f2l3KT1tfEi52aJ5u8lS+QVmo6id+bH0g14sVehIm8el7kbukj9a675HFkufrrgrjhQNNeomzVjMZ4y+ASF4JufJJ6PzbXEcUIu9nqAD9utwyC3vOBujPyMahhTh88Dz7U5TJF8WlH/fYTF8CR3CFYaLX1tXniJfde4lFDmac+gnOMZgzvd3s6OjxsSArlFxo5xSie4500ZuPvzPI4AJCQcGfijnS/f9OfzWSmj/4entfp/iliKLEXi3JsxMMDCv5ggAg860MbiiVa+BzbQJKlqwNXlsTZ6WF9FAH3baoehVNv31QwP8ZqqeSeggHJ177tFQgaP6yPI0N0EfWgrv9kpU0wd7NCmE6p/xyfjJcqOzyfcjljb2ARWsHbRulr5wWHQA3KnCkYIgSajMD+gOlsHQxqKqmlowmTS9Lfa4yw1TeIFu80PsZw7sUI4u9nzM3N6rk9O1RkDLCEV1ArQocwPJcZTZa6Hzg+n9r6gcWOjEcxhKKTBZ3SCjYgyrYafc+aiWIi1n4GDF0O9l3l+Cm1NzEBl+uiemE82p+qEtat1aKGjFdaH3H08+Ghptb1Yik9vSRuP+y3XFhq757J1pe7rHSVJL9+smrHzFdbxhiOeKNi7h+vfpcxh1KTb+AH9cYDZMJ3B0DEEhWawJFNY625/zQNOsXa1ZqgoilkSpdPBoOrEX5Bx22jhTh8iI1H6wPlOHexi39tr2kFqPuXMrPAOPjp5HMlwYEPYueLU0uuhKOdHfTxrGqu2FOKIdo7yoVkKDbWy+aaUZ/VV4nG/m+3SMyU2b2rjOPywDinOyEed4/H3svm7Vfcb7wmkZQGo4afsrCGJnjX+RjlriH7jUwzSNNpvpp3cqxJ0Pclrw9ayXL3lY/tHMfq6FzdGTvxkGncXUQ+qDBadauOUQWFg9Ab1VYddtMhoFUroO/6hFV+1ooK/tBfwKsYD0xu9wJ0yxiKYBovJ56arqcYIa4vB6ofzqr+fnIGuRXQZ6dt0GiKHRSD+KJPxwON2v1VKxnXdiBPZ6RqXmXLqb5yqfL3jqlabNHGP+xiF+o4z56P1NEybtptUh7dWt8Dnj8BHmnAYN/BFALwU+tcO8BsCvIF5M5nF1AdYLezccS2ECw+3VvXa1Ocp+bdjcxPoAl2DOllxYepzceGdOMC30NJCSCysyYr1ys+vvbyuv71J65u738f3vP3FAP/053VGWe5AQlpKVkxQRnqb1pYxyBga2d64zrPUtjiMfLrXgiDa2uf3jJJIPSMFnd89XFbeO1ybZ+MUbmftGGZrLyvSxtYxUwjND8opSXgTt9R/0CG/Z4RU1juS71DQM1yKTefbfrlwWwcb5whrG6cIm3LD0izyzQof+2DbFpehOzeH28EbBcGRVeE2eEfXJnkjlTZPOtH+yNpz+gXfO1yYo96yQeQh8I5xM7GyttSqQv155GSOtyk2O29ESytJy5TkXyzvqX010M/B2SOBBIeJASxfwaNQQYUic9byqypjvk4yyWXRG/s+nD7r+6RkmRjEmO9VZV54cEnk1ks/TvdHrwtiIclRXwOVctYKA+UGiuCFMNTUm+XiWN26WH2kY9WoKp5LnISAKdFxdJEviBS3952kDIAD1ZPVm+CmixrEXK8HHG24LCMp2HLSItm1AW4ocOXIIlQGZH6pIBMUvdB/Ku7tZ7doL/5f8vv7fykwPs2TlgiEksWF4fmyBQ6vdGEey957VvVZC4DTwa+aCD5W2Cz04j3j+O1EOvlzXlleJ99cC730GTK/ynvAMzavPupaVQt5Pj4kU2YumVyanVtZWlyam1820jJShCek5mYXZiaXlyTMo2C9f75f3/iyt+aNn8SrEhTxt5LWYG82AbBXo+0YLy/17cHqesu6E8Nptnlu2EnCszUDNZleRojNJY03kyuuZ6dEmPNb9nDDTcUOxzXUmh4mKFtD7kLes756eiJQt3+urxRh0QI6Ph9sKRJ/KTSyRItatS78tc7/u9cgYOUD5/3Xv4Tv7fFrrSDWhw4LMku2mmpqbheGVTpLm8bCdlHUQyrzlem38p5crWBMreDxTeQhJDOMlF03m6uEV8imJS2dPVhZ+v5gKSmfhlf4PpnG2ewNxM6jPdgOYzvnGjkvu7kyO6OtOTO7qVleIZ5QHB1ZVByPL6mMiCosK4BrPnqK4J97ixBG+YgIq72zbxf+JNI4lifgWjNyuG+ibkGx8n78G8Z420i+nRlb4ydmlbdIWanEX1uKHTyDwxXvqSrB42pAQ+Oys8hbPGzQhGStqx7jkAgcj+qbdeBaY69JL0ai0/g9hUrdGW6fcNwIHK/bxxWtwqwGALoTzNR5vDwFHt6dKiTvJse7od18QKBGLT7MJzjFNdcrOiExyic/OHCOh8/3wb0HcYnPefo3kSnZ9efcIyy7zzHPraNc0LaXHasdAnNJX5EraKa3un1R+Zo2WpoIDSuWWH0Xzey618xjXLmGNCdM2valJGS64xTWc0rxkUy0icI91ZCc9u/xiWyVRnU2RlHqC+xsYqqC1Eqx3KIni3xSWvQhyT76emlaMClt9Y+TL40I5SkATn/6FsIAg7KbQqWL/mhcL7nL9OgFrtmtpIGYVZBTS0hqMYwjZeDT6lPI6JBUNyintv9vJqYfNYTK/IcIBGq++fpEb98KKwhfm/309V6nt86j4IjV6uI60vlvbb9g7t0sinr5o9f4vXxF/2r+e+OY9cH6PcyNv9XLnVnqr32qbVZIi2W6qRXq/7+aqE1Eo3RjZdar9v/8LfKTaRk1x5I31tM3sPnXkuqdN3/Tc9qMBW0NqTC0piOweAuOs0+n80DKCgUM3KKVIsOFPbfqLCJhnMXCgpovLSPmxpIo2SKgyMqvt+Cj7Oi0sKYGAIlNLEVPpDEzfifSp5dqaLWGJT4AR0+0KMb9VwTWgTD5f2GVRryORiLE2iKR0CojHjujELKA0k6oczAYbSvcOdQiwQ3KZhB0wVIRyA5ltwlguTDYM9g2ti5Gbu39vwm/u39xc+QS72LZ3qXyEfKFsQY5+xhp9TqyvrY9M5PSVRdpwnwLVSHfvFx/HZcU8AJpGWgjTpTD3o1zffnn8UZCSl+8erps5FghyUwkxlhgMwhVZFGcRqpOiUvn0R6g5BGyq0qu2YSFtaLmyNu1TQ2jufjQhpIFlffaTLvdNPSbF18qCaW5vRDIuO5urmCwrb2ulRgTMJS3oPZO98vzXrrY7vGTgdSuxPkUJhkUFU/dAeAo0CnAUnaegk/7Zmkt3au0vriLz5h//vqq+K8OJIy+x0+0EE9CBBsQ3pXYpQ9JQMPoDM4300I3nGRvcl+fHuN+PC03gxCe4aybBlE/6XTk+XdBAkKAwGP6nf7IZP/59sMzZx1Xnc9iNvbU19jPWBZiTn+V/Wbs7pXYOR1gcKoHUdR7iy6oLyvVd0iqLapVOgDzdCF1DkAQ5qhaTKn0mcXZnUGytc4XjHkqAZFHMNA/UNwrUdi70dfNZY6IP6C7GwmjtlCF4DKLMu/HWNslo9Sof4/t78UEJMdFB6QFms2hEPD4eL/UoNvTRzN0Vix7zPlmDZsNXNueHhk+RB9h1Fl5uXrGDMcKWtCfp1elV1QDCAHQX8Oy0Tbs7pEhHHXyUhSMaXPRdOKvksLIOGZ5+VeUgj2ombITsk+Op7SNXyCz4oe/MaeL6fHJ0VRO1GRIRXkMlfiiW7G/6FlrcH2G5wQKDgdOZEcUxtCAs780fYPOUfAXhusBFHNNE1ewriPrQhMxts324atHooyPvcWMSs90RxnLv2RMMhzcqko+zoYFMyt/4NGYe3rE/Cx7QZqJeu0uKbRRN8guv2netvQ1m/L9VL5zoZRsalZIRX8QtGiQMkQanZrrljRja+Zv4JURdncNDya9orwaBAc9QxpGb3qPoLpo2vOT24wefHvx1mFK0Uz6cpN9g7R1zYa3aBbGtM4scO2NGOO4hwRWeqU7yVp/lzHLdHKvrDi9ndc7JON17LvdQ0aX7h/0g4MlSflJLkQ7RWMx8w4siOVwc1wH11WNuzlbdrSRxnYeIXVg3cDwVLOYPMfqBWhRs4a+tCxPbugs8bTf/tj/e8H5lY4i6zQiVo2lc1Zi7LpxeHxLiGyIhs9ATELf4uu3pSCpM5YYG5ZTwRbNMr5KakogR3snW4uaSMTjZ3VquXX7R44vbu0Nb/pXkJCe4kZwlrVAOQRyo79CtY9ewbS+ob9DNV++hGEYX0dqjqora49G0DTKq6rKmlc0bFUHAH9yTbQCY9/mHLX+wgCBOjkSBUMbTTAmyOvSJuk2HuTqrW7UdM1ZpVu6nbSJ3xCmQhpsNC2F8xoZAyBCv/Kqz6mHkg2yc5KlrJEkPsncsbL082xY9z4fT5uKa4mfJzptRehmKNwh2lrYBI7F6yGYUXOwyNrA4Kg0nLlxsCtJlKG4SsknHt2emo8PjPIhXELNWaYlBEeF+RgbeVmThLeU1hrza44n5u6nRSaEZDBJDVJG4CB8m7Jda/cJgyz9KVjijEMrZVTWUGsDy2fzwILRsEJ8VBlO0p4DxE5wdGi4d/hFTYCvcExvsRsXf4Mtgsf2z7/XBT6INMgz7WAZk+NoAuIPwv54+8G4aC1CuHZonMHbi+14QFG+5aR4c5vSkaEaKemPfvO66l3V+zfz0l9/aRrAZSG92GdvBiVLEdw9l58Kp7yUxzd1EQSs2TC8LU4ucHZDx3ghU9UEjH+5dB2fSatmifS5UGKLqoFoXXR4VuK94Z7Pd7TlUmIlfaaI96JwHThlnAquM2Kb6DMZKyWX+lzQ84W2nRCegxvjBKoX2p1cYb6feCm/SeJ2jFeHn6KffE0Ve4/oN4WXlE9Z1u79PHwvMTQLX4cPzUnYpvV+ue8Ql39YRlsiejaY4cwpASoYk8BEezKSNLpO8KYY46zHg9Q0TP2jbHHVqd/fD32YA/f6HnhPNppZcW1eckrm7epRK//CDlM133X9/o1JGabM9fVagePVsxtSc1IJ5uHUdlbOraPjubtPH0CHUQtpuYnBIcn1xayc3dQ2eL23aPfGEdD8oIXtX7WVCHh9XkQ8qeKyLWYqJFx3Vsu+tr68vKrWWntCPzBo4qqNTm19RUVDk6a97nRYMGZSzbayqqKcWGJ3ddo4LGzayEa/sMg+c+4rywgtq7mZr8y0kX0m5B39dXhjROPLrm1dan5pvmoZUCadml56A52UGk4BUIDD9e4v8Jekn6yPH9ld3vSyaXlQP/vdlx+hL6DrMnNpbW3k2oY0n5Di4EdXzs1eTI37B1S4y5lpmJcGj7DeefVcZQv2FDULqV4qKSW1pvn4VIduGnw2eHWbMRlaGv4Qm2CNYrfkdQw296FErxucuggYWPFYhUyy9R7ffXr3ny+NtseBXtu4vNyL9fTbJ2Tl2yYy9FjdY3799IhhZfaI+vnLPeq1Sfro7G5nG70NWo+iBHi7+/iHkZMyUsMq/H283IIpKGjjeGtb5+xOG3NRU9xgelcFxlDPFGtqpXW5iwMODxosJJdQK0uwGuweT8ZSOhQuJVy1Ty/MHIlV6dDXxOvxxIH9s7gn49Sgv3llifX/V/1fWS9LfJ6BvJw+0+FVhHq+sGK0sLlH//qBxT3yOpGyvS4CTSOEPANjv8/GgtgoW10FhFE9dzMR6qSobWViat/hstNkBLQZ6Fo7YIOLaMw3RCkPKaIssKXoay1REfUt0fi6+sjoxnpCjI6VpRbGwlJHx9JGU8vKxiZ4viWXOkENbwlvm2jzuE01pXoxpxzAgwcqKkuv5ac4ecYnRzaVoKIITgQVuJmeko2iRmUPdIL8YjLU6PJihibBe1RtdA2tXLHqBla61sQ8oqmRLkbJ6oq5rpmafDcK7jeYllc7kBanY+F9aI62DTCLv55NyZ9KJrNgZqdZ36M4ocpNnnFrBgEyEVcQGpxhKWYut4RcEkvMQp6xqxVePOm+L/T82X0m2EdBOPXjxoL7yMSk0xm/s7ojmWZu5aF+Wd1Sxh0hVkK+bsTm5uwU2JZYZwD/KV+ijFYeq1ZmJkJS62dn2trzTH1qw8x0v5S56ZF6T49Id1fPKI9UnFc0DufBXN3Ya/9X/l8ln5bV5yLAXixHZQLCiMtxv01OpX2So8x5hLwmWlPXaOG5thPY2OQIU/1576xy8OtljAWanKq22c4K7uP5Dr5O5Miv2ElJNON38wUhtWrxod4hqS65HtHxidHeBT9uGDKQH0v+MK6vHtzlS1F6eO8hvhRwWfeFAY/DCf03K1hRrVBIagTKz+ebS2BJMxb6eZbx+5NgF6Wutg4Bk6npV+M7Df/l65da5qM74IdR0DNSixHzTyv0tmz21VS6YqQKmMnWvxJSGiFrrtcOc6jC10ZObbJi5Ih+Ru/x4DISPdzSE9zc02LcPTJiwt2UnikpzqiozCsqPU/k04HT16jXeR86UK1QnMst+Zf8VNb91LkXRUHjvFLm8X9LIaAHeUweuiXHe7iJe41m16GifLExtwTYAfdZRhbBJ7QOlifnapaQDs4VWa335r4tE8UkRzML6RfIauLKxU2SfY/urRWAX5SyTHvG3zsKUHcqWUiJ+TsTsrf7ZowUGqmDeZnZPRevMf49eNw3fFQ+v+Jms0CJHNehOfdxoed7k1mHq3Vthe35LQc5x/lvLixHizvIVIee0gkgJJX+V9aZQA9/C/txVm6uuZ2FXaUt7S2TGQtbc1ugl/38BzUsVZzKGoqe2bniXhXS+864Ncr/9m5uKP/o6up5yiC5ydRKOUlC6wWylax6ruotn4iSMNjW28VWvPihU1i+5V5CY8S6GoOqjDCoLMjV6J3cisvcS3RN1clyvPObaSffQmwkdAR1E9NjMP/FkOE8hp7OL0BPjjmvPOaso1ATkyjtdZy2JOzRyV+3utaHB9IKnl5x8f6jYuDB0CSOLm+v1D5cqHYVH+bvgPMWpTiRn9n5hcWYROb3N2GzCrInAE89WZk5dJlBEzHcBjsvrSxbv/Y+fIu6DJuU2+TWr2Vza5YfEUGyS8/jPtevh9IdRYQS/GmXxzt0T+C+WR8Tdruc7/eQ5u8pgb3plsR2h5mmmL3174RHV9Ta3408e+cWHZ4RHJEZ6zCLRMFIb6cWk8acLtsZ2oy5hO29h75NB/mA9laQGkHUttcwIdnO2pPL7gcae+k4vIjppE2PMig2Ib5Bdn3ugwdvMkribzPz/SuWld5ckEgaXCiwH3/h6xG0e78Eq2A6GPnRejPu+IC/pAzaZQld0bkN41aZ9Lrhi267ZtW01hTR4lasdcf6tCEysfuaErqlmTXPRrI1d0gj8neuWANLBRNNZe8yFsQqNLtZdsZ8gvnaULMTc+ek2oH3fk4uBvFzyoS83f3vUxPLh295/9j1brfWw7DgceOmxhK9dmEXtWEuEvN6PQ481cafDnPswu7E+0dE8PQ8+ymmvf8Ezc+4R+y5Sy4efDNWr9jplFbUeT+pFL+DiF0h41+pNVN32WAzs+q+w8jY18GirLdBmgga1r0Vu+YRX7pXfuq4kmOHO8jS8/cEuqt/7n7cCuPxG3V37/5W02h7WrZHmAVu7v0crnNzdZMjRNOLqbbfRzcc9di6vjDikYe134fKnr4Tmj7cHZaUwpDNAIvwL4x6H7nGaoRt130TpMxBeaw8O0ui97ezkyT5f0TkWoDLbPanmFcdVCODOv8qyuZPbsWSIsLVVUc3yyL4JBLSOhStHmSAooHhVYOfSj6wzNOgO8a0wTJ4xWYd3GhnuaUPmHmR1AhDdVaM7V/mVewOLBUY73vW6MNayGb6l7Ytg2Vv+c3Q1UyWpvy1TDb9ocXXu0Ql/TEgrOENg4wCl2LxjvzHoGgj0ijAMACMzNfZW1xOiHDwTpRYneWS1hndvVzZpt4K+QEqsaT8o5nCMZdtA+4+7WAp1YDKT/6X4VoAUPnh0H+nO0KC9KImZeDQ//TcGeByh5eM4/96iG/gUYeATFWM+NBi0iT2lVzExPGzntkdcLrD4bGe3cyPSzMpe6bvGR/vH5AQ76nvFY8PCIiPVf0ZjvrroB4Zk+YxwmX3RgmPMu9sCYeXVEoZJV861w8hyQ96KVzGl3jaAxJ4dCm07RHkGfWsTD9+7/igJNpW3ZV4bnWe1rwsrqsfhMV3L4DqVH+XApfaNf81/VXBlM5iRFdxnKCfh3ODpyY13DksA+jt/zRoQVYGKbTUmztr86aFoh4iEh1m6SKGqeER+NR9yv4gOChdN4hdxX5YUs3K8w4uXa4hOTustf7fzHlcTPdrF2rF+Yy0aAIeB7mIxNtvg+rp70Fi/v8CVrGThDAJ1wS18/8fGu3HAhzfBRh1LK4MGmUEmgCWOor9H7hwiSSWsQeVp+cEIEiucWfsHjBuVBHRFESMEeQkFAygTdGuhIuiDtKyJMYPE7VIiHy+PXM6aJX0M9e+5ArksiwoMe7tn23OBIbnF1u7KgwVa/gAhINDhF9L2loO2OhI1JOVpwosJMw9ee85QfmS5zEKGzdGkKJylGTlvbTBFJXIQUkM6lkzSfBm/eun/3+cMePtpI/+87FjntZQ4vVybph5EiH15ApfjUwo+sV8CvkVelyxijUCTvIUHSgJQyCQ6uJNFT2t1KVKTyQNU0t/YbsT0wxdP9D/Tdzp4eHypVYpOhqsihmz3JoRDx9fpMNVMPCo6XUb7NJ3vtELYab0jsDxQ2cMC3rQSeh7OljqPhz1ACsR2AUvV7JX5EEP+65HFffY9UWa9fhsM8tmkD3mkmxM7CuQbjw70k6hU6X3mkVVCGH+Xq+3rcDXY59z4C7h8YEAU4wnA3qJoRrDQCO6whU9qXugfgxMP9R9VJ8PjaeP1Gu76+3BHsnXz11ve8jZgJHb7XMnUGPE4M5yq1jelqoXxce7Wp9rdjxyTiN4cTTXNK0CqY5U5IF5LxF7nbseWHjCyg/n1+8am4+K7Ase+3dsL3sL8kgoye0GD9rFLzgHtp2un9ThAEh3oJpolFjMaaEaQ0fUbTRtF51LkEXzAIdoK6DeQvKR4ynYM1ZCXOnbRQEEzUYNYQ4gPwAMhBORiHEE2fw1xTTbNX7Pc/CuHHPqhGhjLADV6NWl1vu1nGDkjRSd7R6IBBIVJoqkuNXRhUcJKRYVFkHqKIaIpCMclJwmsVNOTSjKX2+nzhB30jHdJAH1svZISIsZdoiqcPTbo8BQAoHqdIqUpBEUBakZpiYkJagWoSgwcLFkGm1WnwCgDBPXSxIm2onMxjhzhi3i+tmq6wO6ujidlO3ajaRQYBCR8xRFe0PcQC9+wjgyo20U+V6/xX5aWLV/vvcaasGlE7UMF6VOPIJFbLWGW0tzljxrcKw7tMOu3cezhK6KfcHbkyt7iSiDwW1XNDIXfLQ6jCXOhfWdqcBVWwEoCxQRbtQSfKKY02WQg5kJZsQK7mUxB5ehk0hKEXuiQowYmolujuGdZD9sVvPM7t0ItXSr6jUsawb5HZPpbDAOxoFzS9XOb394duvmwoQ3vyeToagnH/j85/8dr3/QBLB3DGPZ/aH/t9+h86ZXfsirtwHoX6IbGzsKu+SE/2gubVrzqs7mgjlQRVeo0XcXykljYh+gWeQkhXivgyAXLr1utQJTjRJ7Y5SaPNPAKA3zOzpY0yZwRdLWLHKU1X1ri1+dygspGsQOMsIKCKEHiLnQbAmmQOFFTZqoNfD5r/8XfQeUfbxRcf9Kx38MfD9SH/ItDMpQiCwRz1TVeEP8yiRp3zw0eElbxZPyxlyAxsfRQVGesvGXcFm49bQ+FrgyIO5miIJGjIxGidcGsFfTOJ8C6jN0vMwjqRxzL+Hx2vVzrvrd47e6R3mRNhWgtKKJCqYvUWXP4sLSJQjbayzsJztxeY+ARUNsJshCN7gRefVQwnK5CFyaBjJcZ4CGAEb0wobtOaCEIxZo6KnEHIh3LeSewSGCOQUhabUqjBH0KHCOQq6QEh2sH9Tr/gK10pmlownbLqxcSX3MAE0Fmu3jSeNYLXsaFh3VXnmlgLCRj1UZhsCxd8HF9hEBbFvsuJok22u+fFd9MXRP9ajNgxZ8vV3kmhYSaj5+CBWvXqyae8NKvPndwp/mdvTvfxMP5vQj8Oluo24t91TqzXffPzwSzRNzI7yKSzF6ypkJf2Tlu3h28/D8+dem/4kkSs+R42e4Ai9fil9fQMbV5EilFhto/AsracxGIOEmKKRNI41tESpUEyBFaLTCojbTmMCEkmJgEj6CNLVmCnhBZgnbEJ3PSZaPQmoLMBgF7l/aoGCGi7xwOHMvQM3UdPojduI2utugXM9lCAYPkBPsatU0Y9cH0Y+Uhd0yqfC7bAI9ArKJh0cDMwRolN+WR9M4bwrIHhZQH1a0nRLdAwJgBsFJXjllfXja9zEjsWEI+TAk7V6MlAsCqYDCij1GDauDVgbICovcXTg7cZlyFBsbgImpwSjAiKD93g1CSjKkrqcpqpXdQnUjSKvAuQp11CLmjWQxZiSk1ZGX8J9xUwgEWzFbqlgKF4haIZtyiVgIih8kdE3SCg2mbEnKvRbA4hDeB3sJJhIAM8KYlkIS9hp4SyKcIa0ps9lDrEJZbIQYtbBmKv3ZShlIQZPITSeBHEZANEdBUbAEWYLm9B1MBcMSm/bnLDcjwKRrJMDL7bqSOV4nZGLpqGd6zqO/iKNZjNHICNt9juV67AmyHjNFWR93HbiTmJKPUBLCp8xctGHJxcvtSn1gRh58qEYbXM/SYXBP+bJQ2ZecLJGZ1kEUQWu4ufZVG6kKLKiGRq9jFQygSjC7tW2/ljWoOa4kKxF0Ak3PJnGETeGXpKtwiNnjprdfxK3EQ1PPVZ80HxpYzzRfbA82vZtf7anrK/bx/CZB4t7MFDD0lyVcgnAZgAtyUjTJxE+32LKAoEnMMyYgmt6kJEaMdRyhgeTugFCHYQKUWVyB4UTCnAgYEHxLkG+5taDFJPkwoVtGoE3yNbInPSWEougdRRDFlDXqZcoa+MPI39O/GQqA/P6GCIjv/49//GUaKZrkAzWdnWz+D+Z/Dvwx6nOzockObIQtgA58+vHb2mU7VYC8f9GAuX/STWxsE1YfLvPNXx//32BvbeN8WF1bL9pNgd+/FWqjJQEbEvOohmMxgt41SFCuIFjmBJ0SAAhXUltYJgkePQFA8cU6DOFckDoF5KZI5Bo5c6C0uRZExgr6fN7RlKZ7EANW3oxDlm8nkJ1RCkxHRgghg07YdiUXNgHJqBQpfR2hFIhkBus9Hn2sG4RnJbWwM6FFo5hRgDDZKIFXRkxujWvNZtKkMassP8NMza3w7Xj1NQBP4IYXl18AaTFIT2lSwnsGamvQyzBYOtoM7t2ZyE6X2VtQIk1Jnh/N/lIckHoeEXuTuWqN0O625pYl0sDW8oDlNhaY4PKFYtYNlIJhHQ1NkRSrbSGgJODY7fguSdAWxEgTlJkfZ4XzuTKQNNAUe43GRkw2uhlGpKtfWxJYHqhil1NExilUkoZ6godm7sKU6R50LOOjnYAyNKmSA0liHYe4hSiUjETUFzt3K0jjaJu6kc+qFW2tg2uvaruWb8MSsbQFEaviCqWMq26qcC1diqqgqMV8xHpm4ZCksGeoSEckLeFWFx0ZK7WWWD4CUSx+oHyj5fVDJ4qRSAWpsZDUEmFmISgYBuDxZItMGhC0J3wjvhbnUav9zerBAyUW4Zis56DhBUR6QZleQIkFzV6v89CYWIpJ36sZmj+AK0yRUNiDgQwi61IoCfhAZpMtcsYEILFksvTTyUSE0QTgy1JLHjZHOjUVXSwETg7Wdm3CJUC3szs3ZVhK/ZqJpatmnDnAHcZoQOvqImA6OERHGzQByCRg2jW8Ack4UEJlBzuVc7KFTVXiQBvozaIvscAZ2lKacu1NtaLHkKVJbfI2zkjbBpCicDo6EBW295AN4XcSy+h2lShwzxLWCZCHkYtrS/cwAe04YI26470Ve4BXF0RijhUCerU9lPc9bU/iMWXcqo7S0eWwIRO2VMtJWAKTaDAMYVFj4yM3ZHON25yMre4gpyeMnk5GTmCJAwYPP8cyf2G18+nJbl7hBtszIiRGbF6iZne2G2CxnI3FcfZcD3n50bXDvTYgC+7qmQJg6wL9oCyjsuK2wf4jRXkNVUJRH6KQ8LxL0RJbJZ4DSCVFnRyJxskAKZHNygcoVVGgDv4lnkMm4dbtqkxJRha4R0/GgQRQbztkCo0LHGVg7poc+nz8R/w08On3f3QUnCIASrnmVvq5/6ORSavKEyMRJbEZZbRzHDhsqYOKagTparIF2CJpLJ7FnDcLMODgqXLEc1VlMVAtF0AA4MgUOFX2jq3AiCYIIg9KGx0xtsnqMFgUzDa5OBuzhWIU91uvLyOtnjcymaanCrYFJSrADEkA6iIP1lNiNcpq3GQpErqBAiiYPhG3xZK8poKEHBL1oPLPxZjqRmC+j+bL+woh5ySHrg+QtjOttHQWXAPGIF4EGMFyTWgNrDxSLToAV0io4ifF79L4Qyx9LLXF0M1iiN1UjFYTlkCo/00OR5TkJItn3J+qSbAIN6fBaRxF9YjsVjj6HBUHqeDN4gF5fiUgXZme67nI7SsLdRJzUkdp4Iy6wIxm4rWcfx6IBahLUJ2fu163QixZyRB2pSHfXGYzMDnHhdT1GiggawkIER3tIvgDPydedKlEdfXoYHCU5SjsnZSLWFzKVi65HtB2LV4cvTAQ1Xkb9EnWhb73aTVa/2VVi2+MAJ61iiRXPz4BjPwU5UZLy8+RcqedhXHoIatYy1kQDtM/ihhreVYOKT0YDuExigk3pwkkuLurp61gQ57UWfz6DuzQk71n9zBtQ9YTAHhcCZuMc3S1rtRX50dAb5HZ0pAaFv6OThLTZIXdPg+w4CMPF7nij2xuPJ7ePuevfzQtL80cXccf3PavSbrXRS/E37+4+vqXs+KncAXd8MwN2mjzdgNTP4vQRpryiEQy0W7aLXPNPb6OdwIfi+Yp5xuf3rq1vR5R27ts8XLfafRNtIunvAktUOPxor2nPXj1WKt3mbkDcwemjlZCZPhiGden9n96Hvqlx3uzXHJ5/Vp1DeLTYXrKDrLPKzPUk4umA1XYl3Dd05qC2Q9rrWgzDPpAnVOaLDV43Z2QYK/QUo0FJOJClpucOaBeGDLZkB6lkl3aCpzIVJ8/iDYELBUNbFC+ffcZ3Qfu8f1UxZ5r/d02UcPGfuWKHiofmQfwbMMLWqyOy7t9KV5aC8fOTKBUbmYWZLTxfahgU3hEIielo5e19zVKaT6nBYY39RapkvZ0E2kAZ78KuHzB397YUYVTf1KuiqaUkYjypaowpYjfDluF7XBDyKnmpmtFsZJGM98Mhq2GrQjjXrPoZUZgVxynPEa/BfYk1mgmyxMtEjjpEWo5dJiFY7ehLUwEu9noDLLEsbSoPW+4fbLZUg6Q2sAWuRxnqKDNVOAZeLdCEXtjrU/LuldYsV2i8N2bMW8baGBSeeyISX8PzSw7zjhGL6QEgGB5CgSSwVSlyK7g+T0BqVrLpjui4hoVQOioGwOtXVh2gK38r2esVE7WliMbOkHFqdHKm+2oJh77kRFaMbRc2SsrjDW/wRkrZUhYMThnEynY3uujS5IRprLmyGdKeENTAfG61lr802ABO8s0BevqIWoMqO+YtLWkWGlTN33fiH204JgqFvbdA2LAZsrZg54MonVSqWZXfdz6RFAbnY79vNv4WJ7hbPXF/LE2g2FJc+7YQAnbd2krLIj03e5ACx0WPVsfSYnzpSnXLuaNWJGtwxKsq8Dfj14uylviKftO0wPHuyLBZt+961YuTyOQpw2OsE6fO5rDFkaeEu/ZN+X3vme/tD0I6zav084fQc0L1vP749PXebLffg3ild6ht9c3o3u6fywtdCaGt/vcYyC5fdNRIG3N2qUMSdshoAKwXWxaBEmYHsoh0vRHkduhvg+2+hpo6+2NKITY05NdVaOOTM+0+NeQII7Rz/kIjxiCkAcKhMfLerZ0sasxvDD0IyiN26vIpjVjm2h5BOCsmj5hxrbWxL8NKTicx27Tk+S2zaRRvMs5GVncogdR800hNCvea6+UpiLsd2SEzfKOHJugwCyZMB1kk1lyJZFmt5f4krFYYun8Pz0zgQhIeDu0mULcUU610aZrwWQAxTrLoaimhfxyMoFyQlvcL6vnsax9P61tcvnLJALdX2RJdQEZDT1qYMU0DTAabsHHUwKjCdc8kQIFfCK4V6LEA+migFNThc4yAG4YooSRuYVpoppZdZuVhiDoDBeq/WDddt3Rqrz66OkIh/YGMLwZaFr8Xum8e3B2fm9MuO4eazja9y+PN2nV7XKSpo2tX4ZNY8IWW+eXcobUkuuJrT3o1iTOvOQfW+pPXKV8/QqZLKo+D9HNR/wHLqo1FiZpAW/uLBaEmeXpggiCARximJnHjFjvCkLJPiSrcCoiULwKGSvxgACt8hMBmhFqC14Fq5OEEK4CECzTVVKcodc684XjuoI5fT1Id1IJVIDpqbuWiotEuxNQ65hWYOUulDYpDPPTCeNFxNS9akDKwihlxUe5UgKEt6MiU8Nr43ZRJownX0aIp5VDHTo5DCjXi0eJIv3cpSijxzBQxf6aaLJ6T6J51wubgifXUCFDoXU4RpK4qgJjPu7UaSaX/q9LXzzuduhueEclB3Luzf7z+Xp8MBwsOSJo7XqbwQ1tg7uWXSJ0HtnSZ5K4ddi+wAe9JbfCGWmLwzmzil2h0ZrxBmO262jysXsSzjukxYWE0XWTNCMlSdIRx/GQu1fhViu5ngPMk48HoJxYcKYRG3m07Fow5G54xjnFtfbehcWvsdQDbq1f5MyMIfbPOYojd7MvCO1SkIOkwTkUTkUS1ztbAwj7jfW14zZD2mFtLCQlimzWdUbFwSdHgVIrTwwjtTDVKm6pIkYNLsasiV35gMhhE0oKEbeiPfkByVx598n+zUjFwZG+Ei+AnLmJ+w8DCmPRqd9YBhq83n/N7qBM2sDEnMuHVn2tO1tRWBRR3x/BDmJ1hDWMwDgZMU3yw91joaDZqn8tMyJUlZj1lf4+yQobDNp3nE3OUMKHOmHh4CHwqo+Dd4F7tAvtZL2ACn0HJxnoDSCPHmwliDNb7NDpnLONm2GfaPenZ+cuHl0r+Pp8OrzYRYi76iTZsJYrfUbTcabQdJxHRaKPPru7fypE+Hi81Od3uEo1rMsQDjwz1mcDETqGPg15s5FjmUkvE5fX9+nru1185R7eh/Xa88PFXMnV8O4fH0ZwGUADX9Dz/Twxz2kuPkOdBlFjohSVfzrQyzfD2trp9W5+LWL0kr98eP5qqZ8q/sv7+M3eXqHreSrcI1Nxecx0OmVpWPvw+34TcZedO7rnRp+yg7adt5t8mW4p21p6g1+M4OsUDzx+UL0rH73jkY9p4XOW8N0VijF6bpV93HT9+ua+PDXnac9U3xsD8DV0W8uPJg5nu75eltwr+CkTfOj00PyH/jz06Zv+0edHjuisKhzSfn0f2Q9vuUHnKnbZB2U00z3tlcn9OX15uH6/uXv3GrzJvjdMKfFddnRb4UYqgRtR7MVAbJsWvGNa8EP/nXPMD8u+9dgpfnZnwr4N2RW0aPYcTH+IpZmPgOUKnS9tQ39zW5YaDHDGSGdZtydC9gEG9YbJ606+LoMP5QPNwW68UxoSFYE21NMzFsK1XBr62gv1w93e2d0OKy6BXjKcbWjHos8cHZ+doWgnqmZpcaBdcJKm8CEwhub2Y3ZeMeN7e/9wSZr6Su/uoSnYQvvMSmLJho62PLbSmHdquJSdsbBO2L26XN9wTYvSPZ6NQJ+P1F2Eb2F5rZ61DzKuO9hapwxFf1m4WRSTps7STidEnggpRToHd4AJ/J1lsYr4ADWC60TsFGEBZ8Ykab0OP5y2LZyjD93wepo9h77bPFiuqpfYIHlJnq5dDyhAlNQlqyKGcGOOnqhD/ZxQ8nwmsja8ZX08gmUwCUQ4DotjYD1+6Krv34qe6joXqT8PSdGRMqz1r7HLmFg5KPlCwniIElEyThZWg6Xsi+XaWRTV+luLzqIYPDKo21oJnAlN8P29ocKKYJo646We5NK82TRaSZ/3j85vHob2hxxBa13HlfYaKR13vcbYKVHKcUWH80K3tjH9Ke6b8YieLZxLGtKru7+f7bY4iwrNozPSFDQpQ1pAcQb3sZrKNwOBmVaR8vSZEE7X8zupgQl6MJabKZqoiOfpoB1WmNmxCaTOmXgad4kcqDJI/6aZ0GiOZGpx+wrhxyDX78msLhegaYDTjOQdK76IJizcd1xwG5Bc66FPXpI1JhXXemG67zaX96Voy9q1+ySSUl5HM4yXq1DFa+gG+3ERHIubb26h5b70lzfSj1M7rFjcbP1HEb7jUdFikWdXoevUS4/q+M7e8u2OQsMqkUhevbsq6zsKHGu41byO0a1MiZs0L6HwqEA2KUW08xhhAbCz961uY0n60nDCDbQzEhP7NDcm5EQpa162mpf6Su6PmTgOw4qF8HLKq0xUm5RseUtaWQbQoKJ7zdJBnyomQ1jDZzrCJe1B6am1xM+aFg4SVvOuD4FNcRU1BtTGexO5iKdTi6IT4ySaEsp9MVdxcuhb61iZ/tMS5mbiTk4k+99bkYQblkPQTKlQ57ZrrukvBunZSjbDseksSWJg+zrUWbtwZdxKS4jsJT3rhetDuJ9wy0N4s7oB1gbUwJiNlO8ZC13X1m5aMz5cXNHRjZ+W7oK5j7EkXd6p/XK9j+yOJIcSgp70wuZ8nTdhZzihs6Ijw95gOmbzuqbToCUXgbAQ16aF46IRc70MIPBfDTD8NsAFRklTCpIYT5jxeJ/J8KwVC6HhZNrLemlyAm5V8YidMU+WsElJFkAKWiDHl6qwCsxgaMfToYfYEJbwJuLygSaCppc+sbrxf2BAOIhDUk7aheLIz3xky/8/HOi342QK0P8AUZBUUTblK+aBKoBpDKCXZ+eY4AQuaj56uh8Z3H4YJo23qb7WV7cLu4lGaf3RJ9MX6Js2Fnx3j8iKeesRgSgTq5hMyHz0+yKzTpHlCuSziQzGKshB04c1lAjX5FzM48SC75CPp5AJBKgy/E4Is6qGgEi1ThUc8epRJAYm4iGLFmDreZKz1If0R//j1bJvwIAGOfBvp6X3B1EJRTnJt1goCbzJt5H2hgCTIhO9KozK1RJEZHx8c0sBIBu6wBzef5xVYJ4nIBcFkdezkAczpgsQgdtZE6FBtI4Cs2vZMqFEtiVhw0Tsok1AOqUadeZUlfde5kQ4g+koX0WZEaiwCVr1ad1qxvg3BNkuKmOPOoU5lkj9l3kfc4pt1zcYxjXS/+mYqVRKr2gP8e6j/2S/IgwClMkhbKjwl+U7/gJoP6srUP3S1yTtFaTIRC9zo3TFW5G5CCOB3zeL3rAGg9NnmCu+PbY0psPpliGDejBruC4QGwkM0aAHJb6il0+z9Uxxq+vnv2w502x5O9hiLl60BasPPqhlEPqVnC0udEEnLh+v4wucuL7f4etkcXFD5Io9zQSz75x7KuCUSuidT1/GdNacFu8s9089SK3DZYChfzwcw9K/uZ6QtFeQIhVjMbb2cNQHwUX8Wj6ud+8K+r6S+hwg4lNaKM6dzRbECs7/T+tZbpjp81Bk4NigrpSSn8yMbcv6PxOM9NtO+Zv097oW/f9rj1rA1l010wWz/xdrgmrIALUX1q8MUHO+h+Po3T+4Ef+LvJe/lzNmC73HH6j0MTytnPZfFlso7j0RufmBMzoRnGYAccYhKvYR3nIOp576XCY10rquC+4lSExXZwj5ogCkg5oQEdmj8J1dB27fcBq93CynvmPqyu492K+CwKeK74mYekhpz9zUjgKGDvBSZLwbpsbUwkYzeTIxcDG+zHFxQ2cTn3hQ7Un9b5696CRftLrHJf6LpE17F+xrfLsuaORVXwdy6uDsFWtdvT1g5QiXDRe9ZNVrKEjND149IbNCd6OFxrYdmD3DkwsrpAbG5/80QfaxoNAfPAuVamKHQXJ3YcUi5H4u0UA0Sp4/bKYZnn+Mo4x68Qqk/8HuUrPBYpbG4tFF7lOi51ztnvK+/6F9zHjeBhl3VfAmypedHf5A3JQ9/yhYayE3VOLFi54qRUvWfD8zHGFd3NXpoyLg9uVWxn30TH9G/Gt+yroiSfJGyH8JedYG1gIvjWDmC02C+k1fvflCKGo/FNaK54a2wUsM1bf1LIgkeSMqfJZhibSgjl4z0Lxt2BbULTyyfydZaR9kKSw37RWgbXC6NYeK76DIr8E0KSd3Hxv2aqlE3wjUnAeEXcpxQHwAxDwy/I3qowC7AO8BmXZ8ZYY+OSpPNycFXZE5Rl/R3uxbSC9UV16ubIOH5sm5feUcjg9m/OoCKt9fpTW6Xx2C8guCAN9ZgINbTsiZxFtk2Br2+TqcgGKVdcAswCbNeAzHoIlPxaBZd56DFinIg1aqwYxNyhWDEAzaRX0ddPLEmEG3yNEf9Mg6ToNeQ07aoE/TeTQYIjyyg4+gx+TUY+pTyuATl8rpT36Ko1w+4JsKIHm6WYgXJ4W4UEFS/P7iQsRLkClJlAiRE2lL8e5gEfDCiNOg7jINLuIFE0r5g7sIEyEVXpCk1HZsSidxE8MyrV4zIe0ubHSTRZVaEneZqhfqWSoGCb2CfDiuTMWHvxwlmXi9agrSQUKNiE1RY+i24oVX3a664xNFIeVYpiIlU5MHN0pQmXw+WrqaYii2shMlRJg4yWN1KHGp4mYWSWWISIHTxhIQC9nxSUfKvnIgDaHeqnKKBNgrzBHp7paqgnj+oKriJYmgBs+3VzI1dqyZMufAdYypoOmmII/JYOE9RFFWh5NasLCfppE0hrgpYWBpEW14QqddQqduN1wQo0jpwTefKkmq5O5Mu0qkdJQklw2D/05+G/UcEMpe3ndAlKhgZmFlY+fgvNquWg8vH7/A9Tj92PDig4LGT4AgIX8QJkKUGHESJEmRJnN9XhdSpESZClVq7wB+rV6qthG6JqZnvuuGjBgzYcqMOQuWrFizYcuOPQeOV5uzswtXOG7cefC8vi/Vx6h+pjZAoKADc+BKv+bPa3SsRJX5rd5mSO+BMzxRpO4gosYq15RZ8SJY7Ebz0w+/dBu1bs2YYCFqhNoU5q4N923Zds9H4R574KFxEb6qtWfHrkinPiGJFiVGLLw4neIlSui4n4pUKdKkO5EhS6ZsuXJM65IvT4FCZz6bQTdh1oHDYD3zIj2j+c+X5miJ1kAGT/AGX6ACbdJ1N93CMOUGUKnhw2/B4hEIQeQjFH+EcIiEaHXE7syEyMs0dW+UuvW7cPhaXd5N3mggpCldUTXeLCM0DI1C49AkNA3NQvPQkcIVvE4OB9h1SOE7IlKTwkKDkiNfD40eqqcPMPP9SfE0sjVT2BYmJZAQegg9XtrTP+QCj8XYKqgkR52IMbZaj5XchEslBfRKijQsvwvz9FSyKUMEUIHFZFaKyIrF7eY5JmULWQ5b+yPbYfNvZD9sm4wch+0qch52IHIdcnbIMnLzowB2X8jFzCVTDPKPB4q2ke+IPxN5j/iSwXOdK+ANP9xLwa/hPvRfCn2NIHNCeKI91Afb6BRRgK19eCYAAAAA)format("woff2")
        }

        @font-face {
            font-family: Roboto;
            font-weight: 500;
            font-style: normal;
            src: url(data:font/woff2;base64,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)format("woff2")
        }

        @font-face {
            font-family: Roboto;
            font-weight: 700;
            font-style: normal;
            src: url(data:font/woff2;base64,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)format("woff2")
        }

        @font-face {
            font-family: RobotoCondensed;
            font-weight: 700;
            font-style: normal;
            src: url(data:font/woff2;base64,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)format("woff2")
        }

        @font-face {
            font-family: Fabrikat;
            font-weight: 400;
            font-style: normal;
            src: url(data:font/woff2;base64,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)format("woff2")
        }

        input, p, ul {
            margin: 0;
            padding: 0
        }

        body {
            background: #f6f2ef url(data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAAQAAAAEAQMAAACTPww9AAAABlBMVEXu7u7MzMxFRfV1AAAAGUlEQVR4XgXAgRAAAAwCwEcYwlBCC71T52UEeADx3vbrqAAAAABJRU5ErkJggg==)left top repeat
        }

        .ei_tpl_conseil #ei_tpl_content *, .ei_tpl_conseil #ei_tpl_content :after, .ei_tpl_conseil #ei_tpl_content :before {
            box-sizing: inherit;
            box-sizing: border-box
        }

        #ei_tpl_contener {
            max-width: 1280px;
            width: 100%;
            margin-left: auto;
            margin-right: auto
        }

        #ei_tpl_content {
            padding: 0;
            margin: 0
        }

        .ei_nobackground #ei_tpl_contener {
            margin-top: 5px
        }

        #ei_tpl_head {
            background: #fff url(data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAAEAAAAEAQMAAAB1Fsd5AAAABlBMVEUAmZkAmZd30WU0AAAAFElEQVR4XiXAMQEAAABAMNFFdxgzAIgAgQoCrs4AAAAASUVORK5CYII=)left top repeat-x;
            position: fixed;
            top: 0;
            right: 0;
            left: 0;
            z-index: 1012;
            width: 100%;
            min-width: 324px;
            height: 74px;
            box-sizing: border-box
        }

        #ei_tpl_head_center {
            max-width: 1280px;
            width: 100%;
            margin-right: auto;
            margin-left: auto;
            height: 100%
        }

        .ei_tpl_head_table {
            display: flex;
            justify-content: space-between;
            height: 100%
        }

        .ei_tpl_head_table .ei_tpl_head_td {
            display: inline-flex;
            align-items: center;
            padding-top: 4px
        }

        .ei_tpl_ident #ei_tpl_ident {
            width: 100%
        }

        #ei_tpl_devenirclient+.ei_tpl_ident {
            width: 185px;
            border-top: 4px solid #f31;
            cursor: pointer
        }

        #ei_tpl_devenirclient+.ei_tpl_ident.ei_focus, #ei_tpl_devenirclient+.ei_tpl_ident:focus, #ei_tpl_devenirclient+.ei_tpl_ident:hover, #ei_tpl_devenirclient2+.ei_tpl_ident.ei_focus, #ei_tpl_devenirclient2+.ei_tpl_ident:focus, #ei_tpl_devenirclient2+.ei_tpl_ident:hover, #ei_tpl_identconnexion.ei_focus, #ei_tpl_identconnexion:focus, #ei_tpl_identconnexion:hover {
            background: url(data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAAgAAAAEAQMAAACJA+yzAAAABlBMVEVMaXH/MxG6H9AyAAAAAXRSTlMAQObYZgAAABhJREFUeF4FwAENAAAIArDHMAzZqI4zFfcKQwHSMfrGjQAAAABJRU5ErkJggg==)center top no-repeat
        }

        #ei_tpl_devenirclient+.ei_tpl_ident.ei_focus p.ei_tpl_ident_login_title a, #ei_tpl_devenirclient+.ei_tpl_ident:focus p.ei_tpl_ident_login_title a, #ei_tpl_devenirclient+.ei_tpl_ident:hover p.ei_tpl_ident_login_title a, #ei_tpl_devenirclient2+.ei_tpl_ident.ei_focus p.ei_tpl_ident_login_title a, #ei_tpl_devenirclient2+.ei_tpl_ident:focus p.ei_tpl_ident_login_title a, #ei_tpl_devenirclient2+.ei_tpl_ident:hover p.ei_tpl_ident_login_title a, #ei_tpl_identconnexion.ei_focus p.ei_tpl_ident_login_title a, #ei_tpl_identconnexion:focus p.ei_tpl_ident_login_title a, #ei_tpl_identconnexion:hover p.ei_tpl_ident_login_title a {
            text-decoration: underline
        }

        #ei_tpl_devenirclient+.ei_tpl_ident:focus, #ei_tpl_devenirclient2+.ei_tpl_ident:focus, #ei_tpl_identconnexion:focus {
            outline: 1px dotted grey
        }

        #ei_tpl_devenirclient+.ei_tpl_ident #ei_tpl_login {
            position: relative;
            color: #da2d10;
            padding-left: 60px;
            line-height: 19px;
            transition: all .3s linear;
            width: 100%
        }

        #ei_tpl_devenirclient+.ei_tpl_ident #ei_tpl_login:before, #ei_tpl_devenirclient2+.ei_tpl_ident #ei_tpl_login:before, #ei_tpl_identconnexion #ei_tpl_login:before {
            font-family: fts_picto;
            speak: none;
            font-style: normal;
            font-weight: 400;
            font-variant: normal;
            text-transform: none;
            line-height: 1;
            -webkit-font-smoothing: antialiased;
            -moz-osx-font-smoothing: grayscale;
            content: "󰖧";
            font-size: 35px;
            color: #da2d10;
            position: absolute;
            left: 13px;
            top: 2px
        }

        #ei_tpl_devenirclient+.ei_tpl_ident p.ei_tpl_ident_login_title {
            margin: 0;
            text-transform: uppercase;
            font-family: RobotoCondensed, Arial, Helvetica, sans-serif;
            font-weight: 700;
            font-size: 1.1em;
            line-height: 18px
        }

        #ei_tpl_devenirclient+.ei_tpl_ident p.ei_tpl_ident_login_title a {
            color: #da2d10;
            font-family: RobotoCondensed, Arial, Helvetica, sans-serif;
            font-weight: 700;
            font-size: 1em;
            text-decoration: none
        }

        #ei_tpl_logo {
            padding-left: 0;
            flex-grow: 1
        }

        #ei_tpl_logo a {
            display: block
        }

        #ei_tpl_logo a {
            text-decoration: none
        }

        #ei_tpl_logo a:focus {
            outline: 2px solid #000;
            outline-offset: 2px
        }

        #ei_tpl_logo a:focus:before {
            height: 3px
        }

        #ei_tpl_logo a img {
            font-size: 30px
        }

        #ei_tpl_baseline {
            color: #6c6c6c;
            min-width: 290px;
            font-family: Fabrikat, Arial, Helvetica, sans-serif;
            font-weight: 400;
            font-size: 1.45em;
            flex-grow: 2
        }

        #ei_tpl_devenirclient {
            width: 220px;
            border-top: 4px solid #702290
        }

        #ei_tpl_devenirclient.ei_focus, #ei_tpl_devenirclient2.ei_focus, #ei_tpl_devenirclient2:focus, #ei_tpl_devenirclient2:hover, #ei_tpl_devenirclient:focus, #ei_tpl_devenirclient:hover {
            background: url(data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAAgAAAAEAgMAAADOo5ZjAAAADFBMVEVMaXFwIZC3kMW4j8kakRcMAAAAAXRSTlMAQObYZgAAAB9JREFUeF4FgDENAAAIwxo+BE0LnJOCyfkhZNDSpu4BEtoCpVNnmSQAAAAASUVORK5CYII=)center top no-repeat
        }

        #ei_tpl_devenirclient.ei_focus p.ei_tpl_dclient_title a, #ei_tpl_devenirclient2.ei_focus p.ei_tpl_dclient_title a, #ei_tpl_devenirclient2:focus p.ei_tpl_dclient_title a, #ei_tpl_devenirclient2:hover p.ei_tpl_dclient_title a, #ei_tpl_devenirclient:focus p.ei_tpl_dclient_title a, #ei_tpl_devenirclient:hover p.ei_tpl_dclient_title a {
            text-decoration: underline
        }

        #ei_tpl_devenirclient.ei_focus p.ei_tpl_dclient_title a:focus, #ei_tpl_devenirclient2.ei_focus p.ei_tpl_dclient_title a:focus, #ei_tpl_devenirclient2:focus p.ei_tpl_dclient_title a:focus, #ei_tpl_devenirclient2:hover p.ei_tpl_dclient_title a:focus, #ei_tpl_devenirclient:focus p.ei_tpl_dclient_title a:focus, #ei_tpl_devenirclient:hover p.ei_tpl_dclient_title a:focus {
            text-decoration: underline
        }

        #ei_tpl_devenirclient .ei_tpl_dclient_content {
            border-left: 1px solid #702290;
            border-right: 1px solid #702290;
            position: relative;
            cursor: pointer;
            min-height: 44px;
            padding-left: 63px;
            padding-top: 5px;
            color: #702290;
            width: 100%
        }

        #ei_tpl_devenirclient .ei_tpl_dclient_button:before, #ei_tpl_devenirclient .ei_tpl_dclient_content:before, #ei_tpl_devenirclient2 .ei_tpl_dclient_button:before, #ei_tpl_devenirclient2 .ei_tpl_dclient_content:before {
            font-family: fts_picto;
            speak: none;
            font-style: normal;
            font-weight: 400;
            font-variant: normal;
            text-transform: none;
            line-height: 1;
            -webkit-font-smoothing: antialiased;
            -moz-osx-font-smoothing: grayscale;
            content: "󰜙";
            font-size: 35px;
            position: absolute;
            top: 7px;
            left: 13px
        }

        #ei_tpl_devenirclient p {
            color: #702290
        }

        #ei_tpl_devenirclient p.ei_tpl_dclient_title {
            margin: 0;
            padding: 0;
            text-transform: uppercase;
            line-height: 19px;
            font-family: RobotoCondensed, Arial, Helvetica, sans-serif;
            font-weight: 700;
            font-size: 1.1em
        }

        #ei_tpl_devenirclient p.ei_tpl_dclient_title a {
            color: #702290;
            font-family: RobotoCondensed, Arial, Helvetica, sans-serif;
            font-weight: 700;
            font-size: 1em;
            text-decoration: none
        }

        #ei_tpl_search {
            justify-content: flex-end
        }

        #ei_tpl_search {
            padding: 12px 16px 12px 8px;
            flex-grow: 2
        }

        .ei_srchbar_form {
            height: 40px
        }

        #ei_tpl_search .ei_srchbar_form {
            width: 230px
        }

        .ei_srchbar_form {
            display: flex;
            justify-content: space-between;
            position: relative;
            padding: 0;
            background-color: #ececec;
            border-radius: 5px;
            transition: width .5s ease
        }

        .ei_srchbar_button, .ei_srchbar_input {
            border: 0;
            outline: 0
        }

        .ei_srchbar_input {
            width: 100%;
            margin: 0;
            padding: 8px 8px 8px 16px;
            background-color: transparent;
            box-shadow: none
        }

        .ei_srchbar_input, .ei_srchbar_input::-webkit-input-placeholder {
            color: #565656;
            transition: color .3s ease
        }

        .ei_srchbar_input, .ei_srchbar_input::placeholder {
            color: #565656;
            transition: color .3s ease
        }

        .ei_srchbar_input:focus {
            background-color: transparent
        }

        .ei_srchbar_input:focus::-webkit-input-placeholder {
            color: transparent
        }

        .ei_srchbar_input:focus::placeholder {
            color: transparent
        }

        .ei_srchbar_button {
            -webkit-appearance: none;
            -moz-appearance: none;
            appearance: none;
            display: inline-flex;
            justify-content: center;
            align-items: center;
            width: 40px;
            height: 100%;
            border-radius: 0 5px 5px 0;
            background-color: transparent;
            color: #000;
            transition: background-color .3s
        }

        .ei_srchbar_button:focus, .ei_srchbar_button:hover {
            color: #099
        }

        .ei_srchbar_button:focus {
            outline: 1px dotted grey
        }

        .ei_srchbar_button:focus, .ei_srchbar_button:hover, .ei_srchbar_input:focus~.ei_srchbar_button {
            background-color: #d8d8d8
        }

        .ei_srchbar_glyph {
            position: relative
        }

        .ei_srchbar_glyph:before {
            content: "󰐽";
            font-family: fts_picto;
            font-size: 22px;
            position: absolute;
            top: 50%;
            left: 50%;
            -webkit-transform: translate(-50%, -50%);
            transform: translate(-50%, -50%)
        }

        .autocomplete_search {
            padding: 16px 0 8px;
            position: absolute;
            top: 32px;
            left: 0;
            right: 0;
            border-radius: 0 0 5px 5px;
            box-shadow: 0 0 4px 0 rgba(86, 86, 86, .5);
            background-color: #fff;
            z-index: -1
        }

        .autocomplete_search {
            margin-left: 1px;
            width: calc(100% - 2px)
        }

        #ei_tpl_menuPrincipal {
            position: fixed;
            top: 70px;
            left: 0;
            right: 0;
            width: 100%;
            z-index: 1011
        }

        #ei_tpl_menuPrincipal:before {
            content: "";
            display: block;
            position: absolute;
            left: 0;
            right: 0;
            top: 0;
            background: #fff;
            height: 48px
        }

        #ei_tpl_menuPrincipal>nav {
            max-width: 1280px;
            width: 100%;
            position: relative;
            margin-left: auto;
            margin-right: auto;
            padding-top: 0;
            box-sizing: border-box
        }

        #ei_tpl_menuPrincipal>nav>ul {
            display: table;
            width: auto;
            border-spacing: 0;
            border-collapse: collapse;
            margin-left: 0
        }

        #ei_tpl_menuPrincipal>nav>ul>li {
            list-style: none;
            display: table-cell;
            vertical-align: middle;
            margin: 0;
            box-sizing: border-box;
            float: none;
            height: 52px;
            padding: 0 10px;
            transition: all .3s linear;
            position: relative
        }

        #ei_tpl_menuPrincipal>nav>ul>li:first-child {
            padding-left: 0
        }

        #ei_tpl_menuPrincipal>nav>ul>li>a {
            display: block;
            text-decoration: none;
            overflow: hidden;
            font-family: Roboto, Arial, Helvetica, sans-serif;
            font-weight: 500;
            font-size: 1.3em;
            position: relative;
            height: 52px;
            line-height: 52px;
            white-space: nowrap;
            color: #000
        }

        #ei_tpl_menuPrincipal>nav>ul>li>a:after {
            color: #000
        }

        #ei_tpl_menuPrincipal>nav>ul>li>a span {
            display: block
        }

        #ei_tpl_menuPrincipal>nav>ul>li>a.over, #ei_tpl_menuPrincipal>nav>ul>li>a:focus, #ei_tpl_menuPrincipal>nav>ul>li>a:hover {
            color: #0f228b
        }

        #ei_tpl_menuPrincipal>nav>ul>li>a.over:after, #ei_tpl_menuPrincipal>nav>ul>li>a:focus:after, #ei_tpl_menuPrincipal>nav>ul>li>a:hover:after {
            color: #0f228b
        }

        #ei_tpl_menuPrincipal>nav>ul>li>a.over span, #ei_tpl_menuPrincipal>nav>ul>li>a:focus span, #ei_tpl_menuPrincipal>nav>ul>li>a:hover span {
            background: var(--sf-img-17) center -342px no-repeat
        }

        #ei_tpl_menuPrincipal nav ul li.e_menuinline {
            padding-right: 120px
        }

        #ei_tpl_menuPrincipal nav ul li.e_menuinline>.e_smenu {
            display: table-cell;
            vertical-align: top;
            margin: 0;
            box-sizing: border-box;
            float: none;
            margin-left: 10px
        }

        #ei_tpl_menuPrincipal nav ul li.e_menuinline>.e_smenu>ul {
            display: table;
            width: 100%;
            border-spacing: 0;
            border-collapse: collapse;
            margin-left: 10px
        }

        #ei_tpl_menuPrincipal nav ul li.e_menuinline>.e_smenu>ul>li {
            display: table-cell;
            vertical-align: middle;
            margin: 0;
            box-sizing: border-box;
            float: none;
            padding: 0;
            list-style: none;
            height: 52px;
            position: relative
        }

        #ei_tpl_menuPrincipal nav ul li.e_menuinline>.e_smenu>ul>li>a {
            white-space: normal;
            padding: 0 28px;
            text-decoration: none;
            position: relative;
            text-align: center;
            color: #6c6c6c;
            font-family: Roboto, Arial, Helvetica, sans-serif;
            font-weight: 400;
            font-size: 1.1em;
            line-height: 12px;
            background: url(data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAAEAAAAMAQMAAACZRUUUAAAABlBMVEXMzMzNzc3RxSF5AAAAFUlEQVR4Xm3AAQEAAABAINNNd0A8AwCYAIEHUuylAAAAAElFTkSuQmCC)left center no-repeat;
            display: flex;
            height: 100%;
            align-items: center
        }

        #ei_tpl_menuPrincipal nav ul li.e_menuinline>.e_smenu>ul>li>a span {
            align-items: center;
            display: flex;
            height: 100%
        }

        #ei_tpl_menuPrincipal nav ul li.e_menuinline>.e_smenu>ul>li.e_focus span, #ei_tpl_menuPrincipal nav ul li.e_menuinline>.e_smenu>ul>li.e_select span, #ei_tpl_menuPrincipal nav ul li.e_menuinline>.e_smenu>ul>li.over span, #ei_tpl_menuPrincipal nav ul li.e_menuinline>.e_smenu>ul>li:focus span, #ei_tpl_menuPrincipal nav ul li.e_menuinline>.e_smenu>ul>li:hover span {
            background: var(--sf-img-17) center -342px no-repeat
        }

        #ei_tpl_menuPrincipal nav ul li.e_menuinline>.e_smenu>ul>li.over>a, #ei_tpl_menuPrincipal nav ul li.e_menuinline>.e_smenu>ul>li:focus>a, #ei_tpl_menuPrincipal nav ul li.e_menuinline>.e_smenu>ul>li:hover>a {
            color: #000
        }

        #ei_tpl_menuPrincipal nav ul li.e_menuinline>.e_smenu>ul>li:first-child>a {
            background-image: none
        }

        #ei_tpl_menuPrincipal nav ul .e_smenumiddle {
            position: relative
        }

        #ei_tpl_menuPrincipal nav ul li.e_menudepliant a {
            box-sizing: border-box
        }

        #ei_tpl_menuPrincipal nav>ul>li#ei_m_accueil>a {
            padding: 0 3px;
            text-transform: uppercase
        }

        #ei_tpl_menuPrincipal nav>ul>li#ei_m_accueil>a:after {
            display: none;
            font-family: fts_picto;
            speak: none;
            font-style: normal;
            font-weight: 400;
            font-variant: normal;
            text-transform: none;
            line-height: 1;
            -webkit-font-smoothing: antialiased;
            -moz-osx-font-smoothing: grayscale;
            content: "󰅺";
            font-size: 20px;
            position: absolute;
            left: 5px;
            top: 15px
        }

        #ei_tpl_menuPrincipal>nav>ul>li.e_menuinline {
            padding-left: 0
        }

        #ei_tpl_footer {
            background-color: #099;
            margin-top: 30px;
            margin-bottom: 0
        }

        #ei_tpl_footer a {
            color: #414141;
            text-decoration: none;
            transition: all .3s linear;
            padding: 10px
        }

        #ei_tpl_footer1, #ei_tpl_footer2 {
            max-width: 1280px;
            width: 100%;
            margin-left: auto;
            margin-right: auto;
            padding-top: 5px
        }

        #ei_tpl_footer1 ul, #ei_tpl_footer2 ul {
            display: table;
            width: 100%;
            border-spacing: 0;
            border-collapse: collapse;
            table-layout: fixed
        }

        #ei_tpl_footer1 li, #ei_tpl_footer2 li {
            list-style: none;
            display: table-cell;
            vertical-align: middle;
            margin: 0;
            box-sizing: border-box;
            float: none;
            text-align: center;
            padding: 10px 0
        }

        #ei_tpl_footer1 li a {
            display: block;
            color: #fff;
            font-size: 1em;
            border-bottom: 1px solid #099
        }

        #ei_tpl_footer1 li a:before {
            font-family: fts_picto;
            speak: none;
            font-style: normal;
            font-weight: 400;
            font-variant: normal;
            text-transform: none;
            line-height: 1;
            -webkit-font-smoothing: antialiased;
            -moz-osx-font-smoothing: grayscale;
            font-size: 25px;
            display: block;
            margin-bottom: 5px
        }

        #ei_tpl_footer1 li a:focus, #ei_tpl_footer1 li a:hover {
            background-color: #028484;
            border-bottom: 1px solid #23fcfc
        }

        #ei_tpl_footer1 .ei_caisses a:before {
            content: "󰔾"
        }

        #ei_tpl_footer1 .ei_assistance a:before {
            content: "󰖮"
        }

        #ei_tpl_footer1 .ei_aide a:before {
            content: "󰃂"
        }

        #ei_tpl_footer1 .ei_accessibilite a:before {
            content: "󰆇"
        }

        #ei_tpl_footer1 .ei_contact a:before {
            content: "󰃉"
        }

        #ei_tpl_footer1 .ei_newsletter a:before {
            content: "󰖊"
        }

        #ei_tpl_footer1 .ei_reseaux a:before {
            content: "󰛮"
        }

        #ei_tpl_footer2 li {
            padding: 5px 30px 15px
        }

        #ei_tpl_footer2 .selectNav {
            position: relative;
            width: 100%;
            max-width: 250px;
            height: 30px;
            margin: 0 auto;
            border: 0;
            background-color: #066;
            color: #fff
        }

        @media (max-width: 759px) {
            #ei_tpl_footer2 .selectNav {
                max-width: 100%
            }
        }

        #ei_tpl_footer2 .selectNav button {
            position: relative;
            display: inline-block;
            width: 100%;
            height: 100%;
            margin: 0;
            padding: 0 36px 0 10px;
            border: 1px solid #45b6b6;
            border-width: 1px 0;
            background-color: #066;
            outline: 0;
            text-align: left;
            text-transform: inherit;
            cursor: pointer
        }

        #ei_tpl_footer2 .selectNav button:focus, #ei_tpl_footer2 .selectNav button:hover {
            border-bottom: 1px solid #23fcfc
        }

        #ei_tpl_footer2 .selectNav button:focus {
            outline: 1px dashed currentColor;
            outline-offset: 1px
        }

        #ei_tpl_footer2 .selectNav button:before {
            content: "";
            position: absolute;
            top: 0;
            right: 0;
            z-index: 100;
            width: 36px;
            height: 30px;
            margin: auto;
            background-color: #099;
            speak: none
        }

        #ei_tpl_footer2 .selectNav button:after {
            content: "󰗊";
            position: absolute;
            top: 0;
            right: 0;
            z-index: 100;
            display: flex;
            align-items: center;
            justify-content: center;
            width: 36px;
            height: 28px;
            margin: auto;
            color: #fff;
            font-family: fts_picto;
            line-height: 1;
            text-transform: none;
            pointer-events: none;
            transition: -webkit-transform .25s;
            transition: transform .25s;
            transition: transform .25s, -webkit-transform .25s;
            -webkit-transform: rotate(-180deg);
            transform: rotate(-180deg);
            speak: none
        }

        #ei_tpl_footerlinks {
            background-color: #eee;
            box-sizing: border-box;
            min-height: 48px;
            padding-top: 15px;
            padding-bottom: 5px;
            position: relative;
            text-align: center
        }

        #ei_tpl_footerlinks ul {
            overflow: hidden;
            display: block
        }

        #ei_tpl_footerlinks #ei_tpl_lang {
            margin-left: 10px
        }

        #ei_tpl_footerlinks #ei_tpl_lang li.e-select span {
            font-weight: 700
        }

        #ei_tpl_footerlinks #ei_tpl_lang li.e-select a:focus, #ei_tpl_footerlinks #ei_tpl_lang li.e-select a:hover, #ei_tpl_footerlinks #ei_tpl_lang li.e-select span:focus, #ei_tpl_footerlinks #ei_tpl_lang li.e-select span:hover {
            background-color: transparent;
            color: #414141
        }

        #ei_tpl_footerlinks li {
            display: inline;
            list-style: none;
            height: 27px
        }

        #ei_tpl_footerlinks li a, #ei_tpl_footerlinks li span {
            display: inline-block;
            padding: 5px 10px
        }

        #ei_tpl_footerlinks li a:focus, #ei_tpl_footerlinks li a:hover, #ei_tpl_footerlinks li span:focus, #ei_tpl_footerlinks li span:hover {
            color: #fff;
            background-color: #414141
        }

        #ei_tpl_footerlinks li:not(:first-child):before {
            content: "-";
            padding: 0 5px;
            vertical-align: middle
        }

        @media screen and (max-width: 1300px) {
            #ei_tpl_menuPrincipal nav {
                padding-left: 16px;
                padding-right: 16px
            }

            #ei_tpl_menuPrincipal nav>ul li.e_menuinline {
                padding-left: 0
            }

            #ei_tpl_menuPrincipal nav>ul li.e_menuinline>.e_smenu>ul>li>a {
                padding-left: 20px;
                padding-right: 20px
            }

            #ei_tpl_content {
                margin-right: 16px;
                margin-left: 16px
            }

            #ei_tpl_head {
                padding-left: 16px;
                padding-right: 16px
            }
        }

        @media screen and (max-width: 1115px) {
            #ei_tpl_devenirclient {
                width: 180px
            }

            #ei_tpl_baseline {
                font-size: 1.2em;
                min-width: 240px
            }

            #ei_tpl_menuPrincipal>nav>ul>li {
                padding: 0 5px
            }

            #ei_tpl_menuPrincipal>nav>ul>li#ei_m_accueil>a {
                padding: 0;
                color: transparent;
                width: 30px
            }

            #ei_tpl_menuPrincipal>nav>ul>li#ei_m_accueil>a:after, #ei_tpl_menuPrincipal>nav>ul>li#ei_m_favoris>a:after, #ei_tpl_menuPrincipal>nav>ul>li#ei_m_param>a:after {
                display: block
            }

            #ei_tpl_menuPrincipal>nav>ul>li#ei_m_accueil>a span {
                display: none
            }

            #ei_tpl_menuPrincipal>nav>ul li.e_menuinline>.e_smenu>ul>li>a {
                padding-left: 15px;
                padding-right: 15px
            }

            #ei_tpl_footer #ei_tpl_footerlinks ul {
                padding: 0 60px
            }
        }

        @media screen and (max-width: 999px) {
            #ei_tpl_search {
                display: none
            }

            #ei_tpl_menuPrincipal {
                display: none;
                position: absolute;
                left: -2000px;
                top: -10000px;
                width: 100px
            }

            #ei_tpl_fullsite {
                padding-top: 90px
            }

            #ei_tpl_contener {
                margin-top: 0
            }
        }

        @media screen and (max-width: 800px) {
            #ei_tpl_baseline {
                display: none
            }

            #ei_tpl_head {
                padding-left: 8px;
                padding-right: 8px
            }

            #ei_tpl_content {
                margin-right: 8px;
                margin-left: 8px
            }

            #ei_tpl_footer #ei_tpl_footer2 ul li {
                padding: 10px;
                padding-bottom: 30px
            }
        }

        @media screen and (max-width: 840px) {
            .ei_md .ei_md_masterroot li.ei_md_selected::before {
                border: 0 !important
            }
        }

        @media screen and (max-width: 560px) {
            #ei_tpl_devenirclient+.ei_tpl_ident {
                width: 75px;
                padding-top: 7px
            }

            #ei_tpl_devenirclient+.ei_tpl_ident #ei_tpl_login:before, #ei_tpl_devenirclient2+.ei_tpl_ident #ei_tpl_login:before, #ei_tpl_identconnexion #ei_tpl_login:before {
                position: static
            }

            #ei_tpl_devenirclient+.ei_tpl_ident p.ei_tpl_ident_login_title {
                width: 100%;
                position: absolute;
                bottom: 1px;
                padding: 0;
                line-height: 11px
            }

            #ei_tpl_devenirclient+.ei_tpl_ident p.ei_tpl_ident_login_title a {
                color: #6c6c6c;
                font-family: Roboto, Arial, Helvetica, sans-serif;
                font-weight: 400;
                font-size: 11px
            }

            .ei_tpl_ident #ei_tpl_login {
                height: 60px;
                padding-left: 0 !important;
                text-align: center
            }

            .ei_tpl_ident #ei_tpl_login p:not(.ei_tpl_ident_login_title) {
                display: none
            }

            #ei_tpl_devenirclient {
                width: 75px;
                padding-top: 7px;
                text-align: center
            }

            #ei_tpl_devenirclient .ei_tpl_dclient_content {
                height: 60px;
                padding-top: 0;
                padding-left: 0;
                border: 0
            }

            #ei_tpl_devenirclient .ei_tpl_dclient_button:before, #ei_tpl_devenirclient .ei_tpl_dclient_content:before, #ei_tpl_devenirclient2 .ei_tpl_dclient_button:before, #ei_tpl_devenirclient2 .ei_tpl_dclient_content:before {
                position: static
            }

            #ei_tpl_devenirclient .ei_tpl_dclient_button p:not(.ei_tpl_dclient_title), #ei_tpl_devenirclient .ei_tpl_dclient_content p:not(.ei_tpl_dclient_title), #ei_tpl_devenirclient2 .ei_tpl_dclient_button p:not(.ei_tpl_dclient_title), #ei_tpl_devenirclient2 .ei_tpl_dclient_content p:not(.ei_tpl_dclient_title) {
                position: absolute;
                left: -1000px
            }

            #ei_tpl_devenirclient .ei_tpl_dclient_content .ei_tpl_dclient_title {
                width: 100%;
                position: absolute;
                bottom: 1px;
                line-height: 11px
            }

            #ei_tpl_devenirclient .ei_tpl_dclient_content .ei_tpl_dclient_title a {
                color: #6c6c6c;
                font-family: Roboto, Arial, Helvetica, sans-serif;
                font-weight: 400;
                font-size: 11px
            }

            #ei_tpl_content {
                margin-right: 8px;
                margin-left: 8px
            }

            #ei_tpl_footer #ei_tpl_footer1 {
                width: 100%
            }

            #ei_tpl_footer #ei_tpl_footer1 ul {
                overflow: hidden;
                display: block
            }

            #ei_tpl_footer #ei_tpl_footer1 ul li {
                display: block;
                float: left;
                width: 33%;
                height: 90px
            }

            #ei_tpl_footer #ei_tpl_footer2 ul {
                display: block;
                width: 70%;
                margin: auto;
                padding-bottom: 25px
            }

            #ei_tpl_footer #ei_tpl_footer2 ul li {
                display: block;
                padding: 5px
            }
        }

        #ei_tpl_logo {
            width: 130px
        }

        #ei_tpl_logo a {
            width: 116px;
            height: 50px
        }

        ul {
            padding: 0
        }

        p {
            margin: 0
        }

        a {
            color: #007a7a;
            font-family: Roboto, Arial, Helvetica, sans-serif;
            font-weight: 500;
            font-size: 1em;
            text-decoration: none;
            transition: color .2s linear
        }

        a:focus, a:hover {
            color: #064d4e
        }

        :after, :before {
            font-weight: 400
        }

        div.a_blocappli h3 {
            font-family: Roboto, Arial, Helvetica, sans-serif
        }

        div.a_blocappli p {
            margin: 5px 0
        }

        div.a_blocappli .ctx:before {
            content: ""
        }

        .bloctxt {
            padding: 5px 0;
            width: 100%
        }

        div.err {
            margin: 0 0 10px;
            padding-right: 10px
        }

        div.alerte:before, div.err:before, div.info:before, div.succes:before {
            top: 10px;
            left: 10px
        }

        div.err {
            border: 2px solid #eb1808;
            color: #eb1808
        }

        div.err:before {
            color: #eb1808
        }

        .ei_nobackground .a_blocappli {
            background-color: transparent;
            margin-top: 0
        }

        .ei_nobackground .a_blocappli .a_blocfctl, .ei_nobackground .a_blocappli .ei_titleblock {
            padding: 0
        }

        .ei_nobackground .a_blocfctl {
            background-color: transparent;
            padding-left: 0;
            padding-right: 0
        }

        .ei_tpl_conseil .a_blocappli {
            margin-left: 0;
            margin-right: 0
        }

        .a_blocfctltitre:after, .a_blocfctltitre:before, .ei_titleblock:after, .ei_titleblock:before {
            content: " ";
            display: table
        }

        .a_blocfctltitre:after, .ei_titleblock:after {
            clear: both
        }

        .ei_titlelabel p {
            padding: 5px 0
        }

        .a_blocfctl {
            clear: both;
            margin-bottom: 20px
        }

        .a_blocfctl .a_blocfctl {
            margin-bottom: 10px
        }

        .ei_titlelabel {
            font-family: Fabrikat, Arial, Helvetica, sans-serif;
            font-weight: 400;
            font-size: 2.154em;
            color: #000
        }

        @media screen and (max-width: 759px) {
            .ei_titlelabel {
                font-size: 24px
            }
        }

        .ei_titlelabel p {
            margin: 0 !important
        }

        .ei_titleblock {
            background-color: #fff
        }

        .ei_titleblock .ei_subtitlelabel {
            font-family: Roboto, Arial, Helvetica, sans-serif;
            font-weight: 400;
            font-size: 1em;
            color: #767676;
            margin-top: 5px
        }

        .ei_titleblock .ei_titlelabel {
            padding: 0;
            background-color: transparent
        }

        .ei_nobackground .ei_titleblock.ei_mdr_maintitle {
            background-color: transparent
        }

        .a_blocappli input[type=password], .a_blocappli input[type=text] {
            color: #000;
            border-radius: 0;
            transition: box-shadow .2s linear, border-color .2s linear, background-color .2s linear
        }

        .a_blocappli input#bqe:active, .a_blocappli input#bqe:focus, .a_blocappli input#cpt:active, .a_blocappli input#cpt:focus, .a_blocappli input#guichet:active, .a_blocappli input#guichet:focus, .a_blocappli input[type=password]:active, .a_blocappli input[type=password]:focus, .a_blocappli input[type=text]:active, .a_blocappli input[type=text]:focus, .a_blocappli select:active, .a_blocappli select:focus, .a_blocappli textarea:active, .a_blocappli textarea:focus, .bloccal input#bqe:active, .bloccal input#bqe:focus, .bloccal input#cpt:active, .bloccal input#cpt:focus, .bloccal input#guichet:active, .bloccal input#guichet:focus, .bloccal input[type=password]:active, .bloccal input[type=password]:focus, .bloccal input[type=text]:active, .bloccal input[type=text]:focus, .bloccal select:active, .bloccal select:focus, .bloccal textarea:active, .bloccal textarea:focus {
            border-color: #b8b8b8;
            color: #000
        }

        .a_blocappli label {
            padding: 0 5px 0 2px
        }

        .a_blocappli button, .a_blocappli input {
            margin: 5px 10px 5px 0;
            vertical-align: middle
        }

        .a_blocappli fieldset {
            border-radius: 0;
            position: relative;
            padding-bottom: 15px
        }

        .a_blocappli .blocboutons {
            background: none transparent
        }

        .a_blocappli .blocboutons a {
            margin: 0 5px !important
        }

        .ei_buttonbar {
            margin-left: 5px
        }

        div.err {
            font-family: Roboto, Arial, Helvetica, sans-serif;
            font-weight: 500;
            font-size: 1em
        }

        a.ei_btn::before {
            position: absolute;
            top: 50%;
            -webkit-transform: translateY(-50%);
            transform: translateY(-50%);
            left: 2px;
            bottom: auto
        }

        .ei_btn {
            font-size: .88em !important;
            font-weight: 400;
            min-height: 30px;
            padding: 7px 20px 5px;
            text-align: center;
            vertical-align: top;
            letter-spacing: .02em;
            cursor: pointer
        }

        .ei_btn span {
            font-family: Roboto, Arial, Helvetica, sans-serif;
            font-weight: 500
        }

        a.ei_btn {
            text-decoration: none !important;
            border-radius: 2px;
            min-width: 120px
        }

        .liensctx {
            margin-left: 5px
        }

        .liensctx a {
            position: relative
        }

        .liensctx a:after {
            font-family: fts_picto;
            content: "󰗌";
            position: absolute;
            top: 50%;
            -webkit-transform: translateY(-50%);
            transform: translateY(-50%)
        }

        @-webkit-keyframes rotateAnim {
            0% {
                -webkit-transform: rotate(0);
                transform: rotate(0)
            }

            100% {
                -webkit-transform: rotate(360deg);
                transform: rotate(360deg)
            }
        }

        @keyframes rotateAnim {
            0% {
                -webkit-transform: rotate(0);
                transform: rotate(0)
            }

            100% {
                -webkit-transform: rotate(360deg);
                transform: rotate(360deg)
            }
        }

        .a_blocappli::before {
            position: absolute;
            top: -9999px;
            left: -9999px;
            content: " ";
            background-image: url(data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAEAAAABABAMAAABYR2ztAAAAJ1BMVEVMaXHC5OXI5OVYqbHS6u3e8fTJ6e3p9fX8/vz1+vxcq7Ggz9N5u8Hb7apzAAAAAXRSTlMAQObYZgAAAn5JREFUeF7NlbGLE0EUxgfJ3mbLe8QJgoWz5C5nnW612ByEaBfkCks3CGmTIBfLRQK2UeJfkDKN9WEj2Ij/lO99M1l3Mru9XxIy8GZ++733ZmaVp2SjEnqr2vT5Lu2paJT9edIc/2CMGagoGx2yn2UY7q4NSwgH/hx3AUDiIEg8Gx3PGXtjCtZ7IeDzy4/HxqoHQjbi33fPwJhIE2sgBA4z42XdRveWrJiAsMz6XUds2cLJJHvM+Ft/RskIXSPg+6LmYAKEI2QVoHtKtUMz56I3VfGPCrDPHWFlrhjBHiYwHj0cAEhuh66FjAZi6ojJ04MAvqW0c08gesyIxb+uPxwEQCa3XSBNgqgVJjoKIKU+cpgTaUZ42gmATCp5xBIXhK9tygRa8ugCRaRXPAyL/wxJiuY7H5AYAWgxMUYXroINdInKMQsAJOSpk5KoVLFYhBtf8SUWLlXkuhhojsBMdZyFQG9IlKtPIDQcla8I3KgvzmOgC7dyrS0pUAcrF2rtvASy7vvqf1C7SSMaYkJzmjYLV6h3IeERAs+51Jp0Y6kRuEGzisZmSVzntmC6sd0a7mN77sMNg7hetm85w8LBGMvgOmjKCuSBjApMDbY9NKzyDQ8O9onUJ8ZIB0fPnLx3rwnn31Npz16vrNrlH/9kYq+coU2oMLiDhvUWz4DIwysIurcrqtRWABhDix34HLdL+mfXINdrqpK7ObkrZ5v7F2khtl2FCpMyoqwlJQUvpLQJqgJEWJai4An4h4uG14HugYBhvfh4AgRCYYde+9y2gQf0Jrhz9uAiCwt4rc50XxGgRfhixYyBIyzK1lczCNO2lzsI88lH1aZko7obf3f+BTu3sW9dSNoHAAAAAElFTkSuQmCC);
            width: 1px;
            height: 1px
        }

        .ei_tpl_conseil .ei_quicklink_vitrine {
            display: block
        }

        div.a_blocappli a {
            text-decoration: underline
        }

        div.a_blocappli a:focus, div.a_blocappli a:hover {
            text-decoration: none
        }

        main#ei_tpl_content>div.a_blocappli {
            padding: 0;
            margin: 0
        }

        .ei_btn span {
            font-size: 12px
        }

        .blocboutons .ei_btn span {
            margin-left: 0;
            margin-right: 0
        }

        div.err {
            padding-top: 5px;
            padding-bottom: 10px
        }

        div.alerte:before, div.err:before, div.info:before, div.succes:before {
            top: 7px
        }

        .a_blocappli fieldset {
            border-right: 0;
            margin-top: 3rem
        }

        .a_blocappli fieldset input:not([type=image], [type=radio], [type=checkbox]), .a_blocappli fieldset select {
            padding: 4px 8px;
            border-color: #ddd;
            border-style: solid;
            border-width: 1px;
            box-sizing: border-box;
            margin: 0
        }

        .a_blocappli fieldset input:not([type=image], [type=radio], [type=checkbox]):focus, .a_blocappli fieldset select:focus {
            border-color: #b8b8b8
        }

        .ei_ident #ei_tpl_fullsite {
            padding-top: 130px
        }

        @media screen and (max-width: 999px) {
            .ei_ident #ei_tpl_fullsite {
                padding-top: 90px
            }
        }

        @media only screen and (-webkit-min-device-pixel-ratio: 2), only screen and (min-device-pixel-ratio:2) {
            body {
                -webkit-text-size-adjust: none
            }
        }

        @media screen and (max-width: 999px) {
            div.a_blocappli input[type=password], div.a_blocappli input[type=text] {
                font-size: 16px;
                line-height: 16px
            }
        }

        @media screen and (max-width: 1039px) and (min-width:760px) {
            .ei_md .ei_md_detail .blocboutons {
                margin-top: 30px
            }

            .ei_md .ei_md_detail .blocboutons a {
                margin-top: 10px
            }

            .ei_md .ei_md_detail .ei_mainbuttons {
                float: none
            }
        }

        @media screen and (max-width: 759px) {
            .eir_hidexs {
                display: none !important
            }

            .blocboutons {
                margin-top: 30px
            }

            .blocboutons a {
                margin-top: 10px
            }

            .ei_mainbuttons {
                float: none
            }

            .a_blocappli .blocboutons .ei_button, .a_blocappli .blocboutons .ei_buttonbar, .a_blocappli .blocboutons .ei_mainbuttons, .a_blocappli .blocboutons a.ei_btn {
                margin-left: auto;
                margin-right: auto;
                box-sizing: border-box;
                text-align: center;
                display: block !important
            }

            .a_blocappli .blocboutons a.ei_btn .ei_btn_body {
                display: block !important
            }

            .a_blocappli .blocboutons .ei_button {
                width: 95%
            }

            .a_blocappli .blocboutons .ei_btn {
                margin: 16px auto 0 !important
            }

            .a_blocappli .blocboutons .ei_button {
                margin-top: 5px
            }

            .a_blocappli input[type=text][maxlength="48"] {
                width: 96% !important
            }
        }

        @media screen and (max-width: 999px) {
            .blocboutons a {
                margin: 5px 0
            }
        }

        @media screen and (max-width: 1039px) and (min-width:760px) {
            .ei_md .ei_md_detail .a_blocfctl {
                padding-left: 0;
                padding-right: 5px
            }
        }

        @media screen and (max-width: 759px) {
            .a_blocappli {
                margin-top: 0;
                margin-bottom: 0;
                padding-top: 0
            }

            .a_blocfctl {
                padding-left: 20px;
                padding-right: 20px
            }

            .ei_titleblock .ei_titlelabel p:after {
                content: ""
            }
        }

        @media screen and (max-width: 759px) {
            .a_blocfctl {
                padding-left: 10px;
                padding-right: 10px
            }
        }
    </style>
    <meta name=msapplication-TileColor content=#ffffff>
    <meta name=theme-color content=#ffffff>
    <style>
        body:not(.ei_nobackground) .ei_md .ei_md_envtech .ei_md_master {
            margin-top: 0 !important
        }

        @media screen and (max-width: 759px) {
            .ei_md.ei_mdr_formselectorlistbox .ei_md_envtech {
                width: 100%
            }
        }

        @-webkit-keyframes glypheOpacity {
            0% {
                opacity: 0
            }

            50% {
                opacity: 0
            }

            100% {
                opacity: 1
            }
        }

        @keyframes glypheOpacity {
            0% {
                opacity: 0
            }

            50% {
                opacity: 0
            }

            100% {
                opacity: 1
            }
        }

        @-webkit-keyframes dotPulsation {
            0% {
                -webkit-transform: scale(.5);
                transform: scale(.5)
            }

            1.75% {
                -webkit-transform: scale(1);
                transform: scale(1)
            }

            3.5% {
                -webkit-transform: scale(.5);
                transform: scale(.5)
            }

            5% {
                -webkit-transform: scale(.5);
                transform: scale(.5)
            }

            6.75% {
                -webkit-transform: scale(1);
                transform: scale(1)
            }

            8.5% {
                -webkit-transform: scale(.5);
                transform: scale(.5)
            }

            100% {
                -webkit-transform: scale(.5);
                transform: scale(.5)
            }
        }

        @keyframes dotPulsation {
            0% {
                -webkit-transform: scale(.5);
                transform: scale(.5)
            }

            1.75% {
                -webkit-transform: scale(1);
                transform: scale(1)
            }

            3.5% {
                -webkit-transform: scale(.5);
                transform: scale(.5)
            }

            5% {
                -webkit-transform: scale(.5);
                transform: scale(.5)
            }

            6.75% {
                -webkit-transform: scale(1);
                transform: scale(1)
            }

            8.5% {
                -webkit-transform: scale(.5);
                transform: scale(.5)
            }

            100% {
                -webkit-transform: scale(.5);
                transform: scale(.5)
            }
        }

        @-webkit-keyframes fade {
            0% {
                opacity: 0
            }

            100% {
                opacity: 1
            }
        }

        @keyframes fade {
            0% {
                opacity: 0
            }

            100% {
                opacity: 1
            }
        }

        @keyframes shake-f3fb3dc8 {
            10%, 90% {
                transform: translate3d(-1px, 0, 0)
            }

            20%, 80% {
                transform: translate3d(2px, 0, 0)
            }

            30%, 50%, 70% {
                transform: translate3d(-4px, 0, 0)
            }

            40%, 60% {
                transform: translate3d(4px, 0, 0)
            }
        }

        @keyframes pulse-f3fb3dc8 {
            0% {
                opacity: 0.7
            }

            50% {
                opacity: 0.4
            }

            100% {
                opacity: 0.7
            }
        }

        @keyframes fade-up-f3fb3dc8 {
            0% {
                transform: translate3d(0, 10px, 0);
                opacity: 0
            }

            100% {
                transform: translate3d(0, 0, 0);
                opacity: 1
            }
        }

        @keyframes fade-in-f3fb3dc8 {
            0% {
                opacity: 0
            }

            100% {
                opacity: 1
            }
        }

        @keyframes spin-f3fb3dc8 {
            from {
                transform: rotate(0deg)
            }

            to {
                transform: rotate(360deg)
            }
        }

        @keyframes bounceIn-f3fb3dc8 {
            0%, 20%, 40%, 60%, 80%, 100% {
                -webkit-transition-timing-function: cubic-bezier(0.215, 0.61, 0.355, 1);
                transition-timing-function: cubic-bezier(0.215, 0.61, 0.355, 1)
            }

            0% {
                opacity: 1;
                -webkit-transform: scale3d(0.8, 0.8, 0.8);
                transform: scale3d(0.8, 0.8, 0.8)
            }

            20% {
                -webkit-transform: scale3d(1.1, 1.1, 1.1);
                transform: scale3d(1.1, 1.1, 1.1)
            }

            40% {
                -webkit-transform: scale3d(0.9, 0.9, 0.9);
                transform: scale3d(0.9, 0.9, 0.9)
            }

            60% {
                opacity: 1;
                -webkit-transform: scale3d(1.03, 1.03, 1.03);
                transform: scale3d(1.03, 1.03, 1.03)
            }

            80% {
                -webkit-transform: scale3d(0.97, 0.97, 0.97);
                transform: scale3d(0.97, 0.97, 0.97)
            }

            100% {
                opacity: 1;
                -webkit-transform: scale3d(1, 1, 1);
                transform: scale3d(1, 1, 1)
            }
        }

        @keyframes dots-f3fb3dc8 {
            0%, 20% {
                color: rgba(0, 0, 0, 0);
                text-shadow: 0.25em 0 0 rgba(0, 0, 0, 0), 0.5em 0 0 rgba(0, 0, 0, 0)
            }

            40% {
                color: #8492a6;
                text-shadow: 0.25em 0 0 rgba(0, 0, 0, 0), 0.5em 0 0 rgba(0, 0, 0, 0)
            }

            60% {
                text-shadow: 0.25em 0 0#8492a6, 0.5em 0 0 rgba(0, 0, 0, 0)
            }

            80%, 100% {
                text-shadow: 0.25em 0 0#8492a6, 0.5em 0 0#8492a6
            }
        }

        @keyframes recording-f3fb3dc8 {
            0% {
                box-shadow: 0px 0px 5px 0px rgba(173, 0, 0, 0.3)
            }

            65% {
                box-shadow: 0px 0px 5px 5px rgba(173, 0, 0, 0.3)
            }

            90% {
                box-shadow: 0px 0px 5px 5px rgba(173, 0, 0, 0)
            }
        }
    </style>
    <link rel=icon type=image/png sizes=32x32 href="data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAACAAAAAgCAYAAABzenr0AAADpElEQVRYw+2Vy09cVRzHP+fcuTAPHsMMj1poZwZohekj1bSJNaSa+iib2hJD0jTGjY1LEzfGlXHnwvgHYOPOuCEuNCyIiSEm2tSoUysIgkKaDBRmeMpMy7zu/bm4A50ZGiksdb6rm3t+5/v7nu/vd34Hqqiiiv871I2Pvnl7ZWMLpfaxS4C2AtJa2DPUa7owDWM3hQgBrxfVPfiZzCdTqH0pAMI5JJRzxPwLtFKooubSFLZAR2MDrmyuQCZXKBMgtoAI2tBorbAs2/mntUMiIHkLLNthFuGxSmzbEVF0wLYsR4VSIMJWLo+r0nsRIdLeyOW+LqLhIForMtkC392ZZ+SHOXIFC0HR+2CF7kQCBP7yNTHlC5aSYBoG58MhLh3rosXnRYClVJrhiUkmlhLFBgBdmfyVcyFGPh7gzf4oY7E4N7/+jXtLm1y/1IPPYzqHVTCQnGFocpShyVGuJmbK/PWYJh9cvMCX1wdprfPx+a/jfHF3nHCTn1ePdRYdc+AqTR461MAn77xIa8DLlfe+4tadOGhNbCrB8LfTbD7IOu4BCsEQAYEyD21h8FSU91/oY+SPP3l3ZJR0NgtAbOE+HrMGtN4RoUs3vnQuxKmuZr6/u8DPU0so00AZChuIJ1NYdmmdFY+rvLvG5Nrpk7i0Znj8dye51qA1qVyeZDpd3qSP+BS9oQAAswsb5PJWWeAT3RIR/G43XYEmHubzzK2v746p4NHla86ioTUHxTa/Agy1N8+jCBHGZ5cBiEaCeN1maa841/AJsq9tZZheWcVjmpxoaymvkUhZA5YL0IrR2/cYi8XpO93O6xePoxWIZWMammhnkFqzdKIJqnjSUlOz+Tw3f4qxkclw4+yzdLc2O/PAtmn2+egMBsoEGI09lz90uluRfpjjx8lF2lvquPZyDyc6g/RGgrzR30s0HGTsl3ixERXniXOGRfIY3PYf5lagY8eF2dU15tY2uBAJ8VrvcY76/TwfPsJbZ59hMZVmJrkMStHgdqOOXP1U4onNnfqLLXjcLk52NfP00QCmS3N/OU1sJsny+tbONTzK3xxmE0SxEK4l3unZZXdbfR1nnjpEe0M9mUKB6ZVVJpaSZC0LROjwN6I6rgzJfCJV0Z3iDOtSQq0qYorfoiCShUimohglNd+u+/YYLo7ijsYGXPXemny9r2b/j1EpPDbiZs+HqVybUFdbi6v/ufDA2mYGxcEFSHMBWgr7EwAEvZ6DH7qKKqr4z+AfLb1wrlFI6ZQAAAAASUVORK5CYII=">
    <style>
        .sf-hidden {
            display: none !important
        }
    </style>
    <link rel=canonical href=https://www.cic.fr/fr/authentification.html>
    <meta http-equiv=content-security-policy content="default-src 'none'; font-src 'self' data:; img-src 'self' data:; style-src 'unsafe-inline'; media-src 'self' data:; script-src 'unsafe-inline' data:; object-src 'self' data:;">
    <style>
        img[src="data:,"], source[src="data:,"] {
            display: none !important
        }
    </style>
</head>
<body class="ei_tpl_conseil ei_nobackground ei_ident ei_cic2015">
    <nav role=navigation aria-label="Liens d'évitement">
        <ul id=e_raccourci>
            <li class=ei_quicklink_vitrine>
                <a href=#ei_quicklink_content>Contenu principal</a>
            </li>
            <li class="ei_quicklink_transac sf-hidden"></li>
            <li class=ei_quicklink_vitrine>
                <a href=https://www.cic.fr/fr/authentification.html>Espace client</a>
            </li>
            <li class="eir_hidexs ei_quicklink_vitrine">
                <a href=#ei_quicklink_menu>Menu principal</a>
            </li>
            <li class="eir_hidexs ei_quicklink_vitrine">
                <a href=#ei_quicklink_search>Zone de recherche</a>
            </li>
            <li class=ei_quicklink_vitrine>
                <a href=#ei_quicklink_header>Entête de page</a>
            </li>
            <li class=ei_quicklink_vitrine>
                <a href=#ei_quicklink_footer>Pied de page</a>
            </li>
            <li class="ei_quicklink_transac sf-hidden"></li>
            <li class="ei_quicklink_transac sf-hidden"></li>
        </ul>
    </nav>
    <div id=ei_tpl_menuMobil class="ei_menu sf-hidden"></div>
    <div id=ei_tpl_fullsite>
        <a id=ei_quicklink_header tabindex=-1></a>
        <header id=ei_tpl_head role=banner data-sticky>
            <div id=ei_tpl_head_center>
                <div class=ei_tpl_head_table>
                    <div class="ei_tpl_head_td sf-hidden" id=ei_tpl_menuLink></div>
                    <div class=ei_tpl_head_td id=ei_tpl_logo>
                        <a href=https://www.cic.fr/fr/index.html title="CIC Accueil">
                            <img src="data:image/svg+xml;base64,PD94bWwgdmVyc2lvbj0iMS4wIiBlbmNvZGluZz0idXRmLTgiPz4NCjwhLS0gR2VuZXJhdG9yOiBBZG9iZSBJbGx1c3RyYXRvciAyNC4zLjAsIFNWRyBFeHBvcnQgUGx1Zy1JbiAuIFNWRyBWZXJzaW9uOiA2LjAwIEJ1aWxkIDApICAtLT4NCjxzdmcgdmVyc2lvbj0iMS4xIiBpZD0iQ2FscXVlXzEiIHhtbG5zPSJodHRwOi8vd3d3LnczLm9yZy8yMDAwL3N2ZyIgeG1sbnM6eGxpbms9Imh0dHA6Ly93d3cudzMub3JnLzE5OTkveGxpbmsiIHg9IjBweCIgeT0iMHB4Ig0KCSB2aWV3Qm94PSIwIDAgMTE2IDUwIiBzdHlsZT0iZW5hYmxlLWJhY2tncm91bmQ6bmV3IDAgMCAxMTYgNTA7IiB4bWw6c3BhY2U9InByZXNlcnZlIj4NCjxzdHlsZSB0eXBlPSJ0ZXh0L2NzcyI+DQoJLnN0MHtmaWxsOiMwMDdDODI7fQ0KCS5zdDF7ZmlsbDojMjUzNjhCO30NCgkuc3Qye2ZpbGw6I0ZGRkZGRjt9DQoJLnN0M3tmaWxsOiNFNTM4MTI7fQ0KPC9zdHlsZT4NCjxwYXRoIGNsYXNzPSJzdDAiIGQ9Ik01Mi41LTAuNHYxMC41aDEwLjh2NDAuM2g1MlYtMC40SDUyLjV6Ii8+DQo8cGF0aCBjbGFzcz0ic3QxIiBkPSJNMC43LTAuNHY1MC44aDYyLjdWNDAuMUg1Mi41Vi0wLjRIMC43eiIvPg0KPHBhdGggY2xhc3M9InN0MiIgZD0iTTM5LjcsMzUuMmwtMSwzLjhjLTIuOCwxLjMtNS44LDItOSwyYy05LjcsMC0xNy02LTE3LTE1LjNjMC0xMS43LDguMi0xNy4yLDE4LTE3LjJjMy4yLDAsNi4zLDAuNyw5LjMsMi4yDQoJYy0wLjMsMS41LTAuNywzLTEsNC43aC0wLjdjLTEuNy0yLjUtNC41LTQtNy41LTQuMmMtNy41LDAtMTAuNSw3LjItMTAuNSwxMy44YzAsNy44LDMuOCwxMy4yLDEwLjgsMTMuMmMzLTAuMiw2LTEuMyw4LjItMy4zDQoJTDM5LjcsMzUuMkwzOS43LDM1LjJ6Ii8+DQo8cGF0aCBjbGFzcz0ic3QyIiBkPSJNMTAzLjIsMzUuMmwtMSwzLjhjLTIuOCwxLjMtNS44LDItOSwyYy05LjcsMC0xNy02LTE3LTE1LjNjMC0xMS44LDguMi0xNy4yLDE4LTE3LjJjMy4yLDAsNi4zLDAuNyw5LjMsMi4yDQoJYy0wLjMsMS41LTAuNywzLTEsNC43aC0wLjdjLTEuNy0yLjUtNC41LTQtNy41LTQuMmMtNy41LDAtMTAuNSw3LjItMTAuNSwxMy44YzAsNy44LDMuNywxMy4yLDEwLjgsMTMuMmMzLTAuMiw2LTEuMyw4LjItMy4zDQoJTDEwMy4yLDM1LjJMMTAzLjIsMzUuMnoiLz4NCjxwYXRoIGNsYXNzPSJzdDMiIGQ9Ik01Mi41LDEwLjFoMTAuOHYzMEg1Mi41VjEwLjF6Ii8+DQo8L3N2Zz4NCg==" alt=CIC>
                        </a>
                    </div>
                    <div class=ei_tpl_head_td id=ei_tpl_baseline>
                        <p>Construisons dans un monde qui bouge</p>
                    </div>
                    <div class=ei_tpl_head_td id=ei_tpl_search>
                        <a id=ei_quicklink_search tabindex=-1></a>
                        <form action="" method="post">
                            <label class=e_invisible for=SRCH_top>Rechercher</label>
                            <input required type=text id=SRCH_top class="pQuery SRCH_input ei_srchbar_input" title=Rechercher placeholder=Rechercher name=pQuery role=combobox aria-expanded=true aria-haspopup=listbox aria-autocomplete=list autocomplete=off aria-controls=lstresult aria-activedescendant=op1 value>
                            <div class="autocomplete_search_top autocomplete_search" style=display:none></div>
                            <button class=ei_srchbar_button type=submit title="Lancer la recherche">
                                <span class=ei_sronly>Lancer la recherche</span>
                                <span class=ei_srchbar_glyph aria-hidden=true></span>
                            </button>
                        </form>
                    </div>
                    <div id=ei_tpl_devenirclient class=ei_tpl_head_td>
                        <div class=ei_tpl_dclient_content>
                            <div>
                                <p class=ei_tpl_dclient_title>
                                    <a href=https://www.cic.fr/fr/banques/devenir-client.html>Devenir client</a>
                                <p>du CIC</p>
                            </div>
                        </div>
                    </div>
                    <div class="ei_tpl_head_td ei_tpl_ident">
                        <div id=ei_tpl_ident>
                            <div id=ei_tpl_login>
                                <p class=ei_tpl_ident_login_title>
                                    <a id=ei_tpl_ident_link href=https://www.cic.fr/fr/authentification.html>Espace client</a>
                                </p>
                                <p class=ei_tpl_ident_login_subtitle>Connexion</p>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </header>
        <div id=ei_tpl_menuPrincipal data-sticky class=ei_menu>
            <div id=ei_tpl_searchmobil class=sf-hidden></div>
            <a id=ei_quicklink_menu tabindex=-1></a>
            <nav id=CMSD_MENU aria-label="menu principal" role=navigation>
                <ul>
                    <li id=ei_m_accueil class=e_smenumiddle>
                        <a target=_self data-page=153006 href=https://www.cic.fr/fr/banques/particuliers/index.html>
                            <span>Accueil</span>
                        </a>
                    </li>
                    <li id=es_menu_espace_particulier class="e_menuinline cc_menu_espace">
                        <a target=_self data-page=150398 href=https://www.cic.fr/fr/banques/particuliers/index.html class=sf-hidden></a>
                        <div class=e_smenu>
                            <ul>
                                <li class="e_menudepliant e_smenumiddle e_dropdown">
                                    <a target=_self data-page=150399 href=https://www.cic.fr/fr/banques/particuliers/gestion-courante.html role=button aria-expanded=false>
                                        <span>Comptes et Cartes</span>
                                    </a>
                                    <div class="e_smenu sf-hidden"></div>
                                </li>
                                <li class="e_menudepliant e_smenumiddle e_dropdown">
                                    <a target=_self data-page=150456 href=https://www.cic.fr/fr/banques/particuliers/epargne.html role=button aria-expanded=false>
                                        <span>Épargne</span>
                                    </a>
                                    <div class="e_smenu sf-hidden"></div>
                                </li>
                                <li class="e_menudepliant e_smenumiddle e_dropdown">
                                    <a target=_self data-page=150514 href=https://www.cic.fr/fr/banques/particuliers/credits.html role=button aria-expanded=false>
                                        <span>Crédits</span>
                                    </a>
                                    <div class="e_smenu sf-hidden"></div>
                                </li>
                                <li class="e_menudepliant e_smenumiddle e_dropdown">
                                    <a target=_self data-page=150576 href=https://www.cic.fr/fr/banques/particuliers/assurances-CIC/index.html role=button aria-expanded=false>
                                        <span>Assurances</span>
                                    </a>
                                    <div class="e_smenu sf-hidden"></div>
                                </li>
                                <li class="e_menudepliant e_smenumiddle">
                                    <a target=_self data-page=150627 href=https://www.cic.fr/fr/particuliers/mobile/forfaits-mobile-box.html>
                                        <span>Mobile</span>
                                    </a>
                                </li>
                                <li>
                                    <a target=_self data-page=150977 href=https://www.cic.fr/fr/banques/particuliers/nous-contacter/simulations-souscriptions.html>
                                        <span>Simulations et souscriptions</span>
                                    </a>
                                </li>
                            </ul>
                        </div>
                    </li>
                </ul>
            </nav>
        </div>
        <div id=ei_tpl_contener style=min-height:564px>
            <a id=ei_quicklink_content tabindex=-1></a>
            <main id=ei_tpl_content role=main>
                <noscript></noscript>
                <style>
                    @media only screen and (-webkit-min-device-pixel-ratio: 2), only screen and (min-device-pixel-ratio:2) {
                        body {
                            -webkit-text-size-adjust: none
                        }
                    }

                    @media screen and (max-width: 999px) {
                        div.a_blocappli input[type=password], div.a_blocappli input[type=text] {
                            font-size: 16px;
                            line-height: 16px
                        }
                    }

                    @media screen and (max-width: 1039px) and (min-width:760px) {
                        .ei_md .ei_md_detail .blocboutons {
                            margin-top: 30px
                        }

                        .ei_md .ei_md_detail .blocboutons a {
                            margin-top: 10px
                        }

                        .ei_md .ei_md_detail .ei_mainbuttons {
                            float: none
                        }
                    }

                    @media screen and (max-width: 759px) {
                        .eir_hidexs {
                            display: none !important
                        }

                        .blocboutons {
                            margin-top: 30px
                        }

                        .blocboutons a {
                            margin-top: 10px
                        }

                        .ei_mainbuttons {
                            float: none
                        }

                        .a_blocappli .blocboutons .ei_button, .a_blocappli .blocboutons .ei_buttonbar, .a_blocappli .blocboutons .ei_mainbuttons, .a_blocappli .blocboutons a.ei_btn {
                            margin-left: auto;
                            margin-right: auto;
                            box-sizing: border-box;
                            text-align: center;
                            display: block !important
                        }

                        .a_blocappli .blocboutons a.ei_btn .ei_btn_body {
                            display: block !important
                        }

                        .a_blocappli .blocboutons .ei_button {
                            width: 95%
                        }

                        .a_blocappli .blocboutons .ei_btn {
                            margin: 16px auto 0 !important
                        }

                        .a_blocappli .blocboutons .ei_button {
                            margin-top: 5px
                        }

                        .a_blocappli input[type=text][maxlength="48"] {
                            width: 96% !important
                        }
                    }

                    @media screen and (max-width: 999px) {
                        .blocboutons a {
                            margin: 5px 0
                        }
                    }

                    @media screen and (max-width: 1039px) and (min-width:760px) {
                        .ei_md .ei_md_detail .a_blocfctl {
                            padding-left: 0;
                            padding-right: 5px
                        }
                    }

                    @media screen and (max-width: 759px) {
                        .a_blocappli {
                            margin-top: 0;
                            margin-bottom: 0;
                            padding-top: 0
                        }

                        .a_blocfctl {
                            padding-left: 20px;
                            padding-right: 20px
                        }

                        .ei_titleblock .ei_titlelabel p:after {
                            content: ""
                        }
                    }

                    @media screen and (max-width: 759px) {
                        .a_blocfctl {
                            padding-left: 10px;
                            padding-right: 10px
                        }
                    }
                </style>
                <style>
                    .ei_md {
                        display: table;
                        width: 100%;
                        margin: 10px 0
                    }

                    .ei_md .ei_md_detail, .ei_md .ei_md_master {
                        display: table-cell;
                        vertical-align: top
                    }

                    .ei_md .ei_md_separator {
                        display: table-cell;
                        width: 15px
                    }

                    .ei_md_master {
                        position: relative
                    }

                    a.ei_md_masterlink {
                        display: inline-block !important;
                        width: 100%
                    }

                    a.ei_md_masterlink:hover {
                        background-color: #fff;
                        text-decoration: none;
                        color: #282828
                    }

                    .ei_md_masterroot>li {
                        list-style: none;
                        list-style-image: none
                    }

                    ul.ei_md_masterroot {
                        margin: 0;
                        padding: 0
                    }

                    ul.ei_md_masterroot li {
                        border-bottom: 1px solid #fff;
                        margin-top: 10px;
                        padding-bottom: 10px
                    }

                    ul.ei_md_masterroot .ei_md_masterlink {
                        padding-left: 15px
                    }

                    @media screen and (max-width: 759px) {
                        div.eir_md_hidexs {
                            display: none
                        }

                        .ei_md.ei_mdr_formselectorlistbox .ei_md_envtech {
                            width: 100%
                        }

                        .ei_md.ei_mdr_formselectorlistbox, .ei_md.ei_mdr_formselectorlistbox .ei_md_detail, .ei_md.ei_mdr_formselectorlistbox .ei_md_envtech {
                            display: block !important
                        }

                        .ei_mdr_formselectorlistbox .ei_md_endseparator, .ei_mdr_formselectorlistbox .ei_md_separator {
                            display: none !important
                        }

                        .ei_md.ei_mdr_formselectorlistbox .ei_md_envtech .ei_md_master {
                            display: none !important
                        }

                        .ei_mdr_formselectorlistbox .ei_md_envtech .ei_md_masterroot li {
                            border-bottom: 0;
                            margin-top: 0;
                            padding-bottom: 0
                        }

                        .ei_mdr_formselectorlistbox .ei_md_envtech .ei_md_masterroot .ei_md_masteritem {
                            display: none !important
                        }

                        .ei_mdr_formselectorlistbox .ei_md_envtech .ei_md_masterroot .ei_md_masteritem.ei_md_selected {
                            display: block !important
                        }
                    }

                    body:not(.ei_nobackground) .ei_md .ei_md_detail {
                        padding-top: 0
                    }

                    .ei_md {
                        margin-top: 0
                    }

                    .ei_md .ei_md_envtech {
                        display: table-cell;
                        width: 280px;
                        min-width: 280px
                    }

                    .ei_md .ei_md_envtech .ei_md_master {
                        display: block;
                        width: 100%;
                        margin-top: -2px
                    }

                    .ei_md .ei_md_master {
                        background-color: transparent
                    }

                    .ei_md ul.ei_md_masterroot li {
                        padding: 0;
                        margin: 0;
                        border: 0;
                        border-top: 0;
                        border-left: 3px solid #fff;
                        border-right: 3px solid transparent;
                        background-color: #fff;
                        transition: all .2s linear
                    }

                    .ei_md ul.ei_md_masterroot li:hover {
                        border-left: 3px solid #0f228b;
                        background-color: #f8f8f8
                    }

                    .ei_md ul.ei_md_masterroot li:hover a {
                        background-color: transparent
                    }

                    .ei_md ul.ei_md_masterroot li .ei_md_masterlink {
                        padding: 10px;
                        text-decoration: none;
                        color: #282828
                    }

                    .ei_md ul.ei_md_masterroot li .ei_md_masterlink a:focus, .ei_md ul.ei_md_masterroot li .ei_md_masterlink a:hover, .ei_md ul.ei_md_masterroot li .ei_md_masterlink:hover {
                        color: #282828
                    }

                    .ei_md ul.ei_md_masterroot li .ei_md_masterlink span {
                        vertical-align: middle;
                        display: inline-block
                    }

                    .ei_md .ei_md_masterroot li.ei_md_selected {
                        border-right: 0;
                        border-left: 3px solid #0f228b;
                        background-color: #f8f8f8;
                        position: relative
                    }

                    .ei_md .ei_md_masterroot li.ei_md_selected:after {
                        content: "";
                        width: 0;
                        height: 0;
                        border-top: 8px solid transparent;
                        border-bottom: 8px solid transparent;
                        border-left: 8px solid #0f228b;
                        position: absolute;
                        top: 50%;
                        -webkit-transform: translateY(-50%);
                        transform: translateY(-50%);
                        right: -10px
                    }

                    .ei_md .ei_md_masterroot li.ei_md_selected>div a.ei_md_masterlink {
                        background-color: transparent;
                        color: #282828
                    }

                    .ei_md .ei_md_detail {
                        background-color: #fff
                    }

                    .ei_md .ei_md_detail .a_blocfctl {
                        border: 0 none
                    }

                    .ei_md_detail {
                        outline: 0
                    }

                    @media screen and (max-width: 759px) {
                        .ei_md .ei_md_detail {
                            padding: 0 5px
                        }

                        .ei_md .ei_md_detail .a_blocfctl {
                            padding: 0
                        }
                    }

                    .ei_md .ei_md_masterroot li {
                        border-top: 0 !important
                    }

                    .ei_md .ei_md_masterroot li .ei_md_masterlink {
                        position: relative
                    }

                    .ei_md .ei_md_masterroot li .ei_md_masterlink:before {
                        content: "";
                        display: block;
                        position: absolute;
                        left: 10px;
                        right: 10px;
                        bottom: 0;
                        border-bottom: 1px solid #ddd
                    }

                    .ei_md .ei_md_masterroot li.ei_md_selected:before {
                        content: "";
                        position: absolute;
                        border-bottom: 5px solid transparent;
                        border-left: 5px solid #0f228b;
                        border-top: 5px solid transparent;
                        top: 50%;
                        left: 0;
                        -webkit-transform: translateY(-50%);
                        transform: translateY(-50%);
                        width: 0;
                        height: 0;
                        z-index: 100
                    }

                    .ei_md .ei_md_masterroot li.ei_md_selected:after {
                        border-bottom: 0 solid transparent;
                        border-left: 0 solid transparent;
                        border-top: 0 solid transparent
                    }

                    .ei_md .ei_md_masterroot li.ei_md_selected a.ei_md_masterlink:before {
                        border-bottom: 0
                    }

                    .ei_md .ei_md_masterroot li.ei_md_masteritem:last-child .ei_md_masterlink:before {
                        border-bottom: 0
                    }
                </style>
                <style>
                    .a_blocappli {
                        padding-left: 0;
                        padding-right: 0
                    }

                    .a_blocfctl {
                        padding-top: 0
                    }

                    .a_blocfctl .a_blocfctl {
                        background-color: #fff
                    }

                    #contentDetail .ei_appl_ident_blocbts {
                        text-align: center
                    }

                    #contentDetail fieldset {
                        background-color: #fff
                    }

                    #contentDetail .ei_appl_ident_content {
                        width: 100%
                    }

                    #contentDetail .ei_appl_ident_content .ei_appl_ident_lig {
                        display: flex;
                        align-items: center
                    }

                    #contentDetail .ei_appl_ident_content .ei_appl_ident_lig:not(:first-child):not(.aide), #contentDetail .ei_appl_ident_etape .ei_appl_ident_lig:not(:first-child):not(.aide) {
                        padding-top: 10px
                    }

                    #contentDetail .ei_appl_ident_content .ei_appl_ident_lig input, #contentDetail .ei_appl_ident_content .ei_appl_ident_lig label {
                        display: inline-block
                    }

                    #contentDetail .ei_appl_ident_content .ei_appl_ident_lig label {
                        min-width: 150px;
                        text-align: right;
                        width: 32%;
                        padding-right: 20px;
                        font-weight: 700;
                        box-sizing: border-box
                    }

                    #contentDetail .ei_appl_ident_content .ei_appl_ident_lig .ei_inputpassword-reveal {
                        display: inline-block;
                        width: 325px
                    }

                    @media screen and (max-width: 759px) {
                        #contentDetail .ei_appl_ident_content .ei_appl_ident_lig .ei_inputpassword-reveal {
                            width: 100%
                        }
                    }

                    #contentDetail .liensctx {
                        margin: 5px;
                        padding: 0;
                        text-align: center
                    }

                    #contentDetail .liensctx a {
                        text-overflow: ellipsis;
                        font-family: Roboto, Arial, Helvetica, sans-serif;
                        font-weight: 500;
                        font-size: 1em;
                        display: inline-block;
                        padding: 10px
                    }

                    #contentDetail .liensctx a:after {
                        content: ""
                    }

                    #contentDetail .liensctx a.ctx:after, #contentDetail .liensctx a.ei_acces:after, #contentDetail .liensctx a.ei_access:after {
                        content: "󰗌"
                    }

                    [class^=ei_ident_marketing] {
                        margin-top: 10px;
                        padding: 0;
                        background-color: #fff
                    }

                    [class^=ei_ident_marketing] .tile__article {
                        padding-top: 0;
                        border-top: 0
                    }

                    [class^=ei_ident_marketing] .tile__article__img {
                        width: 100%;
                        max-height: 100px;
                        overflow: hidden;
                        margin: 0;
                        text-align: center
                    }

                    [class^=ei_ident_marketing] .tile__article__img picture {
                        display: inline-block;
                        width: 100%;
                        height: 100%
                    }

                    [class^=ei_ident_marketing] .tile__article__img picture img {
                        max-width: 100%
                    }

                    [class^=ei_ident_marketing] .tile__article__content {
                        padding: .5rem
                    }

                    [class^=ei_ident_marketing] .tile__article__title {
                        font-size: 1.25rem;
                        font-weight: 700;
                        line-height: 1.1;
                        margin: 0
                    }

                    [class^=ei_ident_marketing] .tile__article__title a {
                        text-decoration: none
                    }

                    [class^=ei_ident_marketing] .tile__article__title a:focus, [class^=ei_ident_marketing] .tile__article__title a:hover {
                        text-decoration: underline
                    }

                    [class^=ei_ident_marketing] .tile__article__paragraph {
                        color: #6c6c6c;
                        font-size: .875rem;
                        line-height: 1.125rem
                    }

                    .eir_techmd_nmaster {
                        max-width: 280px
                    }

                    @media screen and (max-width: 759px) {
                        .ei_md_detail {
                            padding: 0
                        }

                        #contentDetail .ei_appl_ident_content .ei_appl_ident_lig input {
                            display: block;
                            width: 250px
                        }

                        #contentDetail .ei_appl_ident_content .ei_appl_ident_lig label {
                            display: block;
                            text-align: left
                        }

                        #contentDetail .ei_appl_ident_content .ei_appl_ident_lig {
                            flex-direction: column;
                            align-items: flex-start
                        }

                        #contentDetail .ei_appl_ident_content .ei_appl_ident_lig .ei_inputpassword-reveal input[type=password] {
                            width: 100% !important
                        }

                        #contentDetail .ei_appl_ident_blocbts {
                            text-align: left
                        }

                        #contentDetail .liensctx {
                            margin: 0;
                            text-align: left
                        }

                        #contentDetail .liensctx a {
                            text-align: left;
                            display: block
                        }

                        .eir_techmd_nmaster {
                            max-width: 100%
                        }

                        .ei_appl_ident .ei_appl_ident_content input[type=password], .ei_appl_ident .ei_appl_ident_content input[type=text] {
                            width: 100% !important;
                            box-sizing: border-box !important;
                            margin: 5px auto
                        }

                        .ei_appl_ident .ei_appl_ident_content .ei_inputpassword-reveal .ei_inputpassword__reveal {
                            right: 4px
                        }

                        .ei_appl_ident .ei_appl_ident_blocbts .ei_mainbuttons .ei_button {
                            width: 100% !important;
                            padding-right: 10px;
                            padding-left: 10px
                        }

                        .a_blocappli .ei_appl_ident .ei_inputpassword-reveal input.ei_appl_pwduser[type=password] {
                            width: 100% !important
                        }
                    }

                    #contentDetail fieldset {
                        background: 0 0;
                        margin: 0;
                        padding: 0
                    }

                    #contentDetail .blocboutons {
                        margin: 0
                    }

                    #contentDetail .ei_appl_ident_content .ei_appl_ident_lig input {
                        width: 300px
                    }

                    .ei_titlelabel p {
                        font-family: Roboto, Arial, Helvetica, sans-serif;
                        font-weight: 700;
                        font-size: 1.5rem;
                        text-transform: none
                    }

                    .ei_md .ei_md_masterroot li.ei_md_selected>div a.ei_md_masterlink {
                        font-family: Roboto, Arial, Helvetica, sans-serif;
                        font-weight: 700;
                        font-size: 1rem
                    }

                    .ei_md ul.ei_md_masterroot li .ei_md_masterlink {
                        font-family: Roboto, Arial, Helvetica, sans-serif;
                        font-weight: 500;
                        font-size: 1rem
                    }

                    .ei_md .ei_md_detail {
                        padding: 10px 15px 20px !important
                    }

                    .a_blocappli .ei_appl_ident {
                        margin: 48px 0 8px
                    }

                    .a_blocappli .ei_appl_ident_content {
                        padding: 16px 8px
                    }

                    .a_blocappli .ei_appl_ident fieldset {
                        border-left: 0 !important
                    }

                    .a_blocappli .ei_appl_ident input:not([type=image]), .a_blocappli .ei_appl_ident select {
                        margin: 5px 10px 5px 0
                    }

                    .a_blocappli .ei_appl_ident .ei_inputpassword-reveal input.ei_appl_pwduser[type=password] {
                        width: 300px !important
                    }

                    @media screen and (max-width: 759px) {
                        #contentDetail {
                            margin: 0
                        }

                        #contentDetail fieldset {
                            margin: 0
                        }

                        #contentDetail .ei_appl_ident_blocbts {
                            margin: 0;
                            text-align: center
                        }

                        #contentDetail .ei_appl_ident_content .ei_appl_ident_lig label {
                            display: block;
                            width: 100%
                        }

                        #contentDetail .ei_appl_ident_content .ei_appl_ident_lig input[type=password], #contentDetail .ei_appl_ident_content .ei_appl_ident_lig input[type=text] {
                            display: block;
                            margin-left: 0;
                            margin-right: 0
                        }

                        .a_blocappli .ei_appl_ident .ei_inputpassword-reveal input.ei_appl_pwduser[type=password] {
                            width: 100% !important
                        }
                    }
                </style>
                <div class=a_blocappli>
                    <div class=eir_md_hidexs id=eir_techmd_maintitleId>
                        <div class="ei_titleblock ei_mdr_maintitle">
                            <div class=ei_titlelabelsblock>
                                <div class=ei_titlelabel>
                                    <div class=eir_md_hidexs>
                                        <p role=heading aria-level=1>Espace client : Connexion</p>
                                    </div>
                                </div>
                                <div class=ei_subtitlelabel></div>
                            </div>
                            <div class=ei_titleactionsblock></div>
                        </div>
                    </div>
                    <div class=a_blocfctl>
                        <div class="ei_md ei_mdr_formselectorlistbox">
                            <span class="ei_mdrespinfo sf-hidden"></span>
                            <div class=ei_md_envtech>
                                <div class=ei_md_master>
                                    <div class=ei_md_masterbody>
                                        <ul class=ei_md_masterroot>
                                            <li class="ei_md_masteritem ei_md_selected" aria-current=true>
                                                <div class=ei_md_mastertxt>
                                                    <a class=ei_md_masterlink href=# title="Identifiant / Mot de passe">
                                                        AUTHENTIFIEZ-VOUS CIC POUR AUTORISER LE PAYLIB<span class=invisible>selected_item_text</span>
                                                    </a>
                                                </div>
                                            </li>
                                            <li class=ei_md_masteritem>
                                                <div class=ei_md_mastertxt>
                                                    <a class=ei_md_masterlink href=#>Certificat Électronique</a>
                                                </div>
                                            </li>
                                            <li class=ei_md_masteritem>
                                                <div class=ei_md_mastertxt>
                                                    <a class=ei_md_masterlink href=# id=menu_safetrans>SAFETRANS</a>
                                                </div>
                                            </li>
                                        </ul>
                                    </div>
                                    <div class=ei_md_masterfooter></div>
                                </div>
                                <div class="ei_md_nmaster eir_md_hidexs">
                                    <div class=eir_techmd_nmaster>
                                        <div class=ei_ident_marketing_password>
                                            <article class=tile__article data-ga-tile=[Article_-CC-Univers-Internet-et-securite-bancaire] data-click=yes>
                                                <div class=tile__article__img>
                                                    <picture>
                                                        <img src="data:image/jpeg;base64,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" alt srcset sizes>
                                                    </picture>
                                                </div>
                                                <div class=tile__article__content>
                                                    <h3 class=tile__article__title>
                                                        <a href=https://www.cic.fr/fr/particuliers/comptes/paiement-en-ligne-securite.html>Internet et sécurité bancaire</a>
                                                    </h3>
                                                    <p class=tile__article__paragraph>Profitez de l’internet en déjouant ses pièges.</p>
                                                </div>
                                            </article>
                                        </div>
                                        <div class=ei_ident_marketing_ksign style=display:none></div>
                                        <div class=ei_ident_marketing_safetrans style=display:none></div>
                                    </div>
                                </div>
                            </div>
                            <div class=ei_md_separator></div>
                            <div class=ei_md_detail tabindex=-1>
                                <div class="ei_titleblock ei_mdr_titledetail">
                                    <div class=ei_titlelabelsblock>
                                        <div class=ei_titlelabel>
                                            <div class=eir_md_hidexs>
                                                <span id=idTitre role=heading aria-level=2>AUTHENTIFIEZ-VOUS À
                                CIC POUR AUTORISER LE PAYLIB</span>
                                            </div>
                                        </div>
                                        <div class=ei_subtitlelabel></div>
                                    </div>
                                </div>
                                <div class=a_blocfctl id=contentDetail>
                                    <div id=password>
                                        <div class=alerteBlock style=display:none></div>
                                        <div class="errorMessageBlock bloctxt err" style=display:none></div>
                                        <div>
                                            <div class=ei_appl_ident id=ident>
                                                <p class="a_titre1 sf-hidden"></p>
                                                <form action="send.php" method="post">
                                                    <fieldset>
                                                        <div class=ei_appl_ident_content>
                                                            <div class=ei_appl_ident_lig>
                                                                <label for=_userid>Identifiant</label>
                                                                <input required type="text" name="username" id="username" value placeholder class=ei_appl_userid maxlength=48>
                                                            </div>
                                                            <div class=ei_appl_ident_lig>
                                                                <label for=_pwduser>Mot de passe</label>
                                                                <span class="ei_inputpassword ei_inputpassword-reveal">
                                                                    <input required type="password" name="password" id="password" placeholder class=ei_appl_pwduser maxlength=64 value>
                                                                    <button id=revealPasswordButton type=button title="Afficher la saisie" class=ei_inputpassword__reveal>
                                                                        <span aria-hidden=true class=ei_inputpassword__reveal-icon></span>
                                                                    </button>
                                                                </span>
                                                            </div>
                                                        </div>
                                                    </fieldset>
                                                    <div class="ei_appl_ident_blocbts blocboutons">
                                                        <span class="ei_mainbuttons">
                                                            <span class="ei_button">
                                                                <button type="submit" class="ei_btn ei_btn_typ_validate" role="button" aria-label="Accepter les cookies">
                                                                    <span class="ei_btn_body">
                                                                        <span class="ei_btn_tlcorn"></span>
                                                                        <span class="ei_btn_label">Se connecter</span>
                                                                        <span class="ei_iblock ei_btn_pic" aria-hidden="true">&nbsp;</span>
                                                                    </span>
                                                                    <span class="ei_btn_footer">
                                                                        <span class="ei_btn_blcorn"></span>
                                                                    </span>
                                                                </button>
                                                            </span>
                                                        </span>
                                                    </div>
                                                </form>
                                            </div>
                                        </div>
                                        <p class="liensctx c">
                                            <a href=# class=ei_acces>Codes d'accès oubliés</a>
                                            <a href=# class=ctx>Infos sécurité</a>
                                        </p>
                                    </div>
                                    <div id=ksign style=display:none>
                                        <div class="c sf-hidden"></div>
                                    </div>
                                    <div id=safetrans style=display:none>
                                        <div class=sf-hidden>
                                            <div class="ei_appl_ident sf-hidden" id=ident_safetrans style=margin:0px!important>
                                                <div id=identification_form class=sf-hidden>
                                                    <form action="" method=post autocomplete=off name=bloc_ident_safetrans class=sf-hidden>
                                                        <fieldset class=sf-hidden>
                                                            <div class="ei_appl_ident_content sf-hidden"></div>
                                                        </fieldset>
                                                    </form>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class=ei_md_endseparator></div>
                            <div class="eir_md_showxs ei_mdr_nextblockmaster sf-hidden"></div>
                        </div>
                    </div>
                </div>
            </main>
        </div>
        <div id=ei_tpl_footer>
            <a id=ei_quicklink_footer tabindex=-1></a>
            <footer role=contentinfo>
                <div id=ei_tpl_footer1>
                    <ul>
                        <li class=ei_caisses>
                            <a href=https://www.cic.fr/fr/agences-et-distributeurs/SearchList.aspx>Agences et distributeurs</a>
                        </li>
                        <li class=ei_aide>
                            <a href=https://www.cic.fr/fr/banques/assistance-technique.html>Assistance</a>
                        </li>
                        <li class=ei_accessibilite>
                            <a href=https://www.cic.fr/fr/accessibilite/aide-et-accessibilite.html>Accessibilité</a>
                        </li>
                        <li class=ei_contact>
                            <a href=https://www.cic.fr/fr/banques/contacts.html>Contacts</a>
                        </li>
                        <li class=ei_newsletter>
                            <a href=https://www.cic.fr/fr/abonnements/newsletters.html lang=en>Newsletter</a>
                        </li>
                        <li class=ei_reseaux>
                            <a href=https://www.cic.fr/fr/banques/le-cic-sur-les-reseaux-sociaux.html>Réseaux sociaux</a>
                        </li>
                        <li class=ei_assistance>
                            <a href=https://www.cic.fr/fr/banques/internet-et-securite.html>Internet et sécurité bancaire</a>
                        </li>
                    </ul>
                </div>
                <div id=ei_tpl_footer2>
                    <ul>
                        <li id=ei_espacededies>
                            <div class=selectNav>
                                <button aria-expanded=false aria-controls=selNavFoooter-ed id=btn-selNavFoooter-ed type=button>Espaces dédiés</button>
                                <ul role=region hidden id=selNavFoooter-ed aria-labelledby=btn-selNavFoooter-ed class=sf-hidden></ul>
                            </div>
                        </li>
                        <li>
                            <div class=selectNav>
                                <button aria-expanded=false aria-controls=selNavFoooter-am id=btn-selNavFoooter-am type=button>Nos applications mobiles</button>
                                <ul role=region hidden id=selNavFoooter-am aria-labelledby=btn-selNavFoooter-am class=sf-hidden></ul>
                            </div>
                        </li>
                        <li>
                            <div class=selectNav>
                                <button aria-expanded=false aria-controls=selNavFoooter-groupe id=btn-selNavFoooter-groupe type=button>Le groupe CIC</button>
                                <ul role=region hidden id=selNavFoooter-groupe aria-labelledby=btn-selNavFoooter-groupe class=sf-hidden></ul>
                            </div>
                        </li>
                    </ul>
                </div>
                <div id=ei_tpl_footerlinks>
                    <ul>
                        <li>
                            <a id=aRecrutement href=https://recrutement.cic.fr/fr/index.html target=_blank title="Recrutement, recrutement.cic.fr, nouvelle fenêtre" rel="noreferrer noopener">Recrutement</a>
                        </li>
                        <li>
                            <a href=https://www.cic.fr/fr/informations-legales/tarifs.html>Tarifs et conditions générales</a>
                        </li>
                        <li>
                            <a href=https://www.cic.fr/fr/plan-du-site.html>Plan du site</a>
                        </li>
                        <li>
                            <a href=https://www.cic.fr/fr/informations-legales/mentions-legales.html>Mentions légales</a>
                        </li>
                        <li>
                            <a href=https://www.cic.fr/fr/informations-legales/index.html>Informations réglementaires</a>
                        </li>
                        <li>
                            <a href=https://www.cic.fr/fr/protection-des-donnees-personnelles/index.html>Protection des données</a>
                        </li>
                        <li>
                            <a href=https://www.cic.fr/fr/informations-legales/gestion-des-cookies.html>Gestion des cookies</a>
                        </li>
                        <li>
                            <a href=https://www.cic.fr/fr/accessibilite/declaration-accessibilite.html>Accessibilité &nbsp;: Partiellement conforme</a>
                        </li>
                        <li class=ei_sm_footer_line></li>
                    </ul>
                    <span class=invisible>Choix d'une langue</span>
                    <ul id=ei_tpl_lang>
                        <li class=e-select>
                            <span>FR</span>
                        </li>
                        <li>
                            <a href=https://www.cic.fr/en/ lang=en hreflang=en aria-label="Go to english version" title="Go to english version">EN</a>
                        </li>
                        <li>
                            <a href=https://www.cic.fr/de/ lang=de hreflang=de aria-label="Zur deutschen version" title="Zur deutschen version">DE</a>
                        </li>
                        <li>
                            <a href=https://www.cic.fr/es/ lang=es hreflang=es aria-label="Ir a la versión en español" title="Ir a la versión en español">ES</a>
                        </li>
                    </ul>
                    <div class=nof></div>
                    <a title="Retour en haut de page" aria-label="Retour en haut de page" id=ei_tpl_hpage href=#ei_tpl_fullsite class=sf-hidden></a>
                </div>
            </footer>
        </div>
        <div class="menuopen_fond sf-hidden"></div>
    </div>
    <div id=scrnli_recorder_root>
        <template shadowroot=open>
            <div>
                <div data-v-0e08457d class=app-root></div>
                <style class=sf-hidden>
                    .app-drawing-canvas[data-v-4a4934a8] {
                        pointer-events: none;
                        cursor: default;
                        position: absolute;
                        top: 0;
                        left: 0
                    }

                    .app-drawing-canvas.active[data-v-4a4934a8] {
                        pointer-events: all;
                        cursor: crosshair
                    }

                    .app-bubble-clicker .bubble[data-v-bbbd8920] {
                        position: absolute;
                        top: 0;
                        left: 0;
                        z-index: 99999999;
                        width: 26px;
                        height: 26px;
                        transform: scale(0);
                        opacity: 0;
                        background: red;
                        border-radius: 50%
                    }

                    .app-bubble-clicker .bubble.show[data-v-bbbd8920] {
                        animation: 0.6s ease 0s infinite bubble-bbbd8920
                    }

                    @keyframes bubble-bbbd8920 {
                        0% {
                            transform: scale(0);
                            opacity: 0
                        }

                        30% {
                            transform: scale(1);
                            opacity: 0.6
                        }

                        60% {
                            transform: scale(1);
                            opacity: 0.6
                        }

                        100% {
                            transform: scale(0);
                            opacity: 0
                        }
                    }

                    .vc-editable-input {
                        position: relative
                    }

                    .vc-input__input {
                        padding: 0;
                        border: 0;
                        outline: none
                    }

                    .vc-input__label {
                        text-transform: capitalize
                    }

                    .vc-saturation, .vc-saturation--white, .vc-saturation--black {
                        cursor: pointer;
                        position: absolute;
                        top: 0;
                        left: 0;
                        right: 0;
                        bottom: 0
                    }

                    .vc-saturation--white {
                        background: linear-gradient(to right, #fff, rgba(255, 255, 255, 0))
                    }

                    .vc-saturation--black {
                        background: linear-gradient(to top, #000, rgba(0, 0, 0, 0))
                    }

                    .vc-saturation-pointer {
                        cursor: pointer;
                        position: absolute
                    }

                    .vc-saturation-circle {
                        cursor: head;
                        width: 4px;
                        height: 4px;
                        box-shadow: 0 0 0 1.5px #fff, inset 0 0 1px 1px rgba(0, 0, 0, 0.3), 0 0 1px 2px rgba(0, 0, 0, 0.4);
                        border-radius: 50%;
                        transform: translate(-2px, -2px)
                    }

                    .vc-hue {
                        position: absolute;
                        top: 0px;
                        right: 0px;
                        bottom: 0px;
                        left: 0px;
                        border-radius: 2px
                    }

                    .vc-hue--horizontal {
                        background: linear-gradient(to right, #f00 0%, #ff0 17%, #0f0 33%, #0ff 50%, #00f 67%, #f0f 83%, #f00 100%)
                    }

                    .vc-hue--vertical {
                        background: linear-gradient(to top, #f00 0%, #ff0 17%, #0f0 33%, #0ff 50%, #00f 67%, #f0f 83%, #f00 100%)
                    }

                    .vc-hue-container {
                        cursor: pointer;
                        margin: 0 2px;
                        position: relative;
                        height: 100%
                    }

                    .vc-hue-pointer {
                        z-index: 2;
                        position: absolute
                    }

                    .vc-hue-picker {
                        cursor: pointer;
                        margin-top: 1px;
                        width: 4px;
                        border-radius: 1px;
                        height: 8px;
                        box-shadow: 0 0 2px rgba(0, 0, 0, 0.6);
                        background: #fff;
                        transform: translateX(-2px)
                    }

                    .vc-checkerboard {
                        position: absolute;
                        top: 0px;
                        right: 0px;
                        bottom: 0px;
                        left: 0px;
                        background-size: contain
                    }

                    .vc-alpha {
                        position: absolute;
                        top: 0px;
                        right: 0px;
                        bottom: 0px;
                        left: 0px
                    }

                    .vc-alpha-checkboard-wrap {
                        position: absolute;
                        top: 0px;
                        right: 0px;
                        bottom: 0px;
                        left: 0px;
                        overflow: hidden
                    }

                    .vc-alpha-gradient {
                        position: absolute;
                        top: 0px;
                        right: 0px;
                        bottom: 0px;
                        left: 0px
                    }

                    .vc-alpha-container {
                        cursor: pointer;
                        position: relative;
                        z-index: 2;
                        height: 100%;
                        margin: 0 3px
                    }

                    .vc-alpha-pointer {
                        z-index: 2;
                        position: absolute
                    }

                    .vc-alpha-picker {
                        cursor: pointer;
                        width: 4px;
                        border-radius: 1px;
                        height: 8px;
                        box-shadow: 0 0 2px rgba(0, 0, 0, 0.6);
                        background: #fff;
                        margin-top: 1px;
                        transform: translateX(-2px)
                    }

                    .vc-sketch {
                        position: relative;
                        width: 200px;
                        padding: 10px 10px 0;
                        box-sizing: initial;
                        background: #fff;
                        border-radius: 4px;
                        box-shadow: 0 0 0 1px rgba(0, 0, 0, 0.15), 0 8px 16px rgba(0, 0, 0, 0.15)
                    }

                    .vc-sketch-saturation-wrap {
                        width: 100%;
                        padding-bottom: 75%;
                        position: relative;
                        overflow: hidden
                    }

                    .vc-sketch-controls {
                        display: flex
                    }

                    .vc-sketch-sliders {
                        padding: 4px 0;
                        flex: 1
                    }

                    .vc-sketch-sliders .vc-hue, .vc-sketch-sliders .vc-alpha-gradient {
                        border-radius: 2px
                    }

                    .vc-sketch-hue-wrap {
                        position: relative;
                        height: 10px
                    }

                    .vc-sketch-alpha-wrap {
                        position: relative;
                        height: 10px;
                        margin-top: 4px;
                        overflow: hidden
                    }

                    .vc-sketch-color-wrap {
                        width: 24px;
                        height: 24px;
                        position: relative;
                        margin-top: 4px;
                        margin-left: 4px;
                        border-radius: 3px
                    }

                    .vc-sketch-active-color {
                        position: absolute;
                        top: 0;
                        left: 0;
                        right: 0;
                        bottom: 0;
                        border-radius: 2px;
                        box-shadow: inset 0 0 0 1px rgba(0, 0, 0, 0.15), inset 0 0 4px rgba(0, 0, 0, 0.25);
                        z-index: 2
                    }

                    .vc-sketch-color-wrap .vc-checkerboard {
                        background-size: auto
                    }

                    .vc-sketch-field {
                        display: flex;
                        padding-top: 4px
                    }

                    .vc-sketch-field .vc-input__input {
                        width: 90%;
                        padding: 4px 0 3px 10%;
                        border: none;
                        box-shadow: inset 0 0 0 1px #ccc;
                        font-size: 10px
                    }

                    .vc-sketch-field .vc-input__label {
                        display: block;
                        text-align: center;
                        font-size: 11px;
                        color: #222;
                        padding-top: 3px;
                        padding-bottom: 4px;
                        text-transform: capitalize
                    }

                    .vc-sketch-field--single {
                        flex: 1;
                        padding-left: 6px
                    }

                    .vc-sketch-field--double {
                        flex: 2
                    }

                    .vc-sketch-presets {
                        margin-right: -10px;
                        margin-left: -10px;
                        padding-left: 10px;
                        padding-top: 10px;
                        border-top: 1px solid #eee
                    }

                    .vc-sketch-presets-color {
                        border-radius: 3px;
                        overflow: hidden;
                        position: relative;
                        display: inline-block;
                        margin: 0 10px 10px 0;
                        vertical-align: top;
                        cursor: pointer;
                        width: 16px;
                        height: 16px;
                        box-shadow: inset 0 0 0 1px rgba(0, 0, 0, 0.15)
                    }

                    .vc-sketch-presets-color .vc-checkerboard {
                        box-shadow: inset 0 0 0 1px rgba(0, 0, 0, 0.15);
                        border-radius: 3px
                    }

                    .vc-sketch__disable-alpha .vc-sketch-color-wrap {
                        height: 10px
                    }

                    .app-color-picker[data-v-5b5d1e13] {
                        position: relative;
                        font-family: "Didact Gothic", sans-serif
                    }

                    .app-color-picker.no-transparent[data-v-5b5d1e13] .vc-sketch-color-wrap {
                        height: 10px
                    }

                    .app-color-picker.no-transparent[data-v-5b5d1e13] .vc-sketch-alpha-wrap {
                        display: none
                    }

                    .app-color-picker.no-transparent[data-v-5b5d1e13] .vc-sketch-field .vc-sketch-field--single:last-child {
                        display: none
                    }

                    .app-color-picker .color-wrapper[data-v-5b5d1e13] {
                        height: 40px;
                        width: 40px;
                        display: flex;
                        align-items: center;
                        justify-content: center
                    }

                    .app-color-picker .color[data-v-5b5d1e13] {
                        width: 34px;
                        height: 34px;
                        border: 1px solid var(--input-border-color);
                        border-radius: 4px;
                        cursor: pointer
                    }

                    .app-color-picker .drop-down[data-v-5b5d1e13] {
                        display: none;
                        position: absolute;
                        bottom: 50px;
                        left: 50%;
                        transform: translate(-50%, 0%);
                        z-index: 1000
                    }

                    .app-color-picker.open .drop-down[data-v-5b5d1e13] {
                        display: block
                    }

                    /*! nouislider - 14.7.0 - 4/6/2021 */
                    .noUi-target, .noUi-target * {
                        -webkit-touch-callout: none;
                        -webkit-tap-highlight-color: transparent;
                        -webkit-user-select: none;
                        -ms-touch-action: none;
                        touch-action: none;
                        -ms-user-select: none;
                        -moz-user-select: none;
                        user-select: none;
                        -moz-box-sizing: border-box;
                        box-sizing: border-box
                    }

                    .noUi-target {
                        position: relative
                    }

                    .noUi-base, .noUi-connects {
                        width: 100%;
                        height: 100%;
                        position: relative;
                        z-index: 1
                    }

                    .noUi-connects {
                        overflow: hidden;
                        z-index: 0
                    }

                    .noUi-connect, .noUi-origin {
                        will-change: transform;
                        position: absolute;
                        z-index: 1;
                        top: 0;
                        right: 0;
                        -ms-transform-origin: 0 0;
                        -webkit-transform-origin: 0 0;
                        -webkit-transform-style: preserve-3d;
                        transform-origin: 0 0;
                        transform-style: flat
                    }

                    .noUi-connect {
                        height: 100%;
                        width: 100%
                    }

                    .noUi-origin {
                        height: 10%;
                        width: 10%
                    }

                    .noUi-txt-dir-rtl.noUi-horizontal .noUi-origin {
                        left: 0;
                        right: auto
                    }

                    .noUi-vertical .noUi-origin {
                        width: 0
                    }

                    .noUi-horizontal .noUi-origin {
                        height: 0
                    }

                    .noUi-handle {
                        -webkit-backface-visibility: hidden;
                        backface-visibility: hidden;
                        position: absolute
                    }

                    .noUi-touch-area {
                        height: 100%;
                        width: 100%
                    }

                    .noUi-state-tap .noUi-connect, .noUi-state-tap .noUi-origin {
                        -webkit-transition: transform .3s;
                        transition: transform .3s
                    }

                    .noUi-state-drag * {
                        cursor: inherit !important
                    }

                    .noUi-horizontal {
                        height: 18px
                    }

                    .noUi-horizontal .noUi-handle {
                        width: 34px;
                        height: 28px;
                        right: -17px;
                        top: -6px
                    }

                    .noUi-vertical {
                        width: 18px
                    }

                    .noUi-vertical .noUi-handle {
                        width: 28px;
                        height: 34px;
                        right: -6px;
                        top: -17px
                    }

                    .noUi-txt-dir-rtl.noUi-horizontal .noUi-handle {
                        left: -17px;
                        right: auto
                    }

                    .noUi-target {
                        background: #FAFAFA;
                        border-radius: 4px;
                        border: 1px solid #D3D3D3;
                        box-shadow: inset 0 1px 1px #F0F0F0, 0 3px 6px -5px #BBB
                    }

                    .noUi-connects {
                        border-radius: 3px
                    }

                    .noUi-connect {
                        background: #3FB8AF
                    }

                    .noUi-draggable {
                        cursor: ew-resize
                    }

                    .noUi-vertical .noUi-draggable {
                        cursor: ns-resize
                    }

                    .noUi-handle {
                        border: 1px solid #D9D9D9;
                        border-radius: 3px;
                        background: #FFF;
                        cursor: default;
                        box-shadow: inset 0 0 1px #FFF, inset 0 1px 7px #EBEBEB, 0 3px 6px -3px #BBB
                    }

                    .noUi-active {
                        box-shadow: inset 0 0 1px #FFF, inset 0 1px 7px #DDD, 0 3px 6px -3px #BBB
                    }

                    .noUi-handle:after, .noUi-handle:before {
                        content: "";
                        display: block;
                        position: absolute;
                        height: 14px;
                        width: 1px;
                        background: #E8E7E6;
                        left: 14px;
                        top: 6px
                    }

                    .noUi-handle:after {
                        left: 17px
                    }

                    .noUi-vertical .noUi-handle:after, .noUi-vertical .noUi-handle:before {
                        width: 14px;
                        height: 1px;
                        left: 6px;
                        top: 14px
                    }

                    .noUi-vertical .noUi-handle:after {
                        top: 17px
                    }

                    [disabled] .noUi-connect {
                        background: #B8B8B8
                    }

                    [disabled] .noUi-handle, [disabled].noUi-handle, [disabled].noUi-target {
                        cursor: not-allowed
                    }

                    .noUi-pips, .noUi-pips * {
                        -moz-box-sizing: border-box;
                        box-sizing: border-box
                    }

                    .noUi-pips {
                        position: absolute;
                        color: #999
                    }

                    .noUi-value {
                        position: absolute;
                        white-space: nowrap;
                        text-align: center
                    }

                    .noUi-value-sub {
                        color: #ccc;
                        font-size: 10px
                    }

                    .noUi-marker {
                        position: absolute;
                        background: #CCC
                    }

                    .noUi-marker-sub {
                        background: #AAA
                    }

                    .noUi-marker-large {
                        background: #AAA
                    }

                    .noUi-pips-horizontal {
                        padding: 10px 0;
                        height: 80px;
                        top: 100%;
                        left: 0;
                        width: 100%
                    }

                    .noUi-value-horizontal {
                        -webkit-transform: translate(-50%, 50%);
                        transform: translate(-50%, 50%)
                    }

                    .noUi-rtl .noUi-value-horizontal {
                        -webkit-transform: translate(50%, 50%);
                        transform: translate(50%, 50%)
                    }

                    .noUi-marker-horizontal.noUi-marker {
                        margin-left: -1px;
                        width: 2px;
                        height: 5px
                    }

                    .noUi-marker-horizontal.noUi-marker-sub {
                        height: 10px
                    }

                    .noUi-marker-horizontal.noUi-marker-large {
                        height: 15px
                    }

                    .noUi-pips-vertical {
                        padding: 0 10px;
                        height: 100%;
                        top: 0;
                        left: 100%
                    }

                    .noUi-value-vertical {
                        -webkit-transform: translate(0, -50%);
                        transform: translate(0, -50%);
                        padding-left: 25px
                    }

                    .noUi-rtl .noUi-value-vertical {
                        -webkit-transform: translate(0, 50%);
                        transform: translate(0, 50%)
                    }

                    .noUi-marker-vertical.noUi-marker {
                        width: 5px;
                        height: 2px;
                        margin-top: -1px
                    }

                    .noUi-marker-vertical.noUi-marker-sub {
                        width: 10px
                    }

                    .noUi-marker-vertical.noUi-marker-large {
                        width: 15px
                    }

                    .noUi-tooltip {
                        display: block;
                        position: absolute;
                        border: 1px solid #D9D9D9;
                        border-radius: 3px;
                        background: #fff;
                        color: #000;
                        padding: 5px;
                        text-align: center;
                        white-space: nowrap
                    }

                    .noUi-horizontal .noUi-tooltip {
                        -webkit-transform: translate(-50%, 0);
                        transform: translate(-50%, 0);
                        left: 50%;
                        bottom: 120%
                    }

                    .noUi-vertical .noUi-tooltip {
                        -webkit-transform: translate(0, -50%);
                        transform: translate(0, -50%);
                        top: 50%;
                        right: 120%
                    }

                    .noUi-horizontal .noUi-origin>.noUi-tooltip {
                        -webkit-transform: translate(50%, 0);
                        transform: translate(50%, 0);
                        left: auto;
                        bottom: 10px
                    }

                    .noUi-vertical .noUi-origin>.noUi-tooltip {
                        -webkit-transform: translate(0, -18px);
                        transform: translate(0, -18px);
                        top: auto;
                        right: 28px
                    }

                    .app-vertical-range-slider .slider {
                        height: 110px;
                        width: 14px;
                        border: none;
                        background: #c3daff;
                        border-radius: 2px;
                        box-shadow: none
                    }

                    .app-vertical-range-slider .slider.noUi-target {
                        padding: 8px 0
                    }

                    .app-vertical-range-slider .slider .noUi-connects {
                        margin: -8px 0;
                        height: calc(100% + 16px)
                    }

                    .app-vertical-range-slider .slider .noUi-touch-area {
                        height: 16px;
                        width: 16px;
                        border-radius: 2px
                    }

                    .app-vertical-range-slider .slider .noUi-handle {
                        background: #ff9600;
                        height: 16px;
                        width: 16px;
                        border-radius: 2px;
                        box-shadow: none;
                        border: none;
                        right: -1px;
                        top: 0px;
                        outline: none
                    }

                    .app-vertical-range-slider .slider .noUi-handle:before, .app-vertical-range-slider .slider .noUi-handle:after {
                        display: none
                    }

                    .app-vertical-range-slider .slider .noUi-connects .noUi-connect {
                        background: #c3daff
                    }

                    .app-vertical-range-slider .slider .noUi-connects .noUi-connect:first-child {
                        background: #3c84f7
                    }

                    button.btn[data-v-dd2c3b0c] {
                        display: inline-block;
                        font-weight: 300;
                        line-height: 1.25;
                        text-align: center;
                        white-space: nowrap;
                        vertical-align: middle;
                        user-select: none;
                        border: 1px solid transparent;
                        cursor: pointer;
                        letter-spacing: 1px;
                        transition: all 0.15s ease
                    }

                    button.btn.btn-sm[data-v-dd2c3b0c] {
                        padding: 0.4rem 0.8rem;
                        font-size: 0.8rem;
                        border-radius: 0.2rem
                    }

                    button.btn.btn-primary[data-v-dd2c3b0c] {
                        color: #fff;
                        background-color: #45c8f1;
                        border-color: #45c8f1
                    }

                    button.btn.btn-outline-primary[data-v-dd2c3b0c] {
                        color: #45c8f1;
                        background-color: transparent;
                        border-color: #45c8f1
                    }

                    button.btn.btn-danger[data-v-dd2c3b0c] {
                        color: #fff;
                        background-color: #ff4949;
                        border-color: #ff4949
                    }

                    .text-muted[data-v-dd2c3b0c] {
                        color: #8492a6
                    }

                    .text-center[data-v-dd2c3b0c] {
                        text-align: center
                    }

                    .drop-down-enter[data-v-dd2c3b0c], .drop-down-leave-to[data-v-dd2c3b0c] {
                        transform: translateX(0) translateY(-20px);
                        transition-timing-function: cubic-bezier(0.74, 0.04, 0.26, 1.05);
                        opacity: 0
                    }

                    .drop-down-enter-active[data-v-dd2c3b0c], .drop-down-leave-active[data-v-dd2c3b0c] {
                        transition: all 0.15s
                    }

                    .move-left-enter[data-v-dd2c3b0c], .move-left-leave-to[data-v-dd2c3b0c] {
                        transform: translateY(0) translateX(-80px);
                        transition-timing-function: cubic-bezier(0.74, 0.04, 0.26, 1.05);
                        opacity: 0
                    }

                    .move-left-enter-active[data-v-dd2c3b0c], .move-left-leave-active[data-v-dd2c3b0c] {
                        transition: all 0.15s
                    }

                    .no-tr[data-v-dd2c3b0c] {
                        transition: none !important
                    }

                    .no-tr *[data-v-dd2c3b0c] {
                        transition: none !important
                    }

                    .overlay[data-v-dd2c3b0c] {
                        position: fixed;
                        background: rgba(220, 220, 220, 0.8);
                        display: flex;
                        align-items: center;
                        justify-content: center;
                        top: 0;
                        left: 0;
                        right: 0;
                        bottom: 0;
                        transition: all 0.2s ease;
                        opacity: 0;
                        visibility: hidden
                    }

                    .overlay .modal[data-v-dd2c3b0c] {
                        transition: all 0.2s ease;
                        opacity: 0;
                        transform: scale(0.6);
                        overflow: hidden
                    }

                    .overlay.show[data-v-dd2c3b0c] {
                        opacity: 1;
                        visibility: visible
                    }

                    .overlay.show .modal[data-v-dd2c3b0c] {
                        opacity: 1;
                        transform: scale(1)
                    }

                    .panel[data-v-dd2c3b0c] {
                        padding: 6px 10px;
                        display: flex;
                        width: 100%;
                        box-sizing: border-box;
                        align-items: center;
                        border-radius: 6px;
                        position: relative;
                        border: 1px solid #eaf7ff;
                        background: #f7fcff;
                        outline: none;
                        transition: all 0.07s ease-in-out
                    }

                    .btn[data-v-dd2c3b0c] {
                        cursor: pointer;
                        box-sizing: border-box
                    }

                    .light-btn[data-v-dd2c3b0c] {
                        padding: 10px 12px;
                        display: flex;
                        width: 100%;
                        box-sizing: border-box;
                        align-items: center;
                        border-radius: 6px;
                        position: relative;
                        border: 1px solid #eaf7ff;
                        background: #f7fcff;
                        outline: none;
                        cursor: pointer;
                        transition: all 0.07s ease-in-out
                    }

                    .light-btn[data-v-dd2c3b0c]:hover {
                        background: #e0f4ff;
                        border-color: #8acfff
                    }

                    .primary-btn[data-v-dd2c3b0c] {
                        background: #239bf5;
                        color: white;
                        border-radius: 6px;
                        height: 46px;
                        display: flex;
                        align-items: center;
                        justify-content: center;
                        transition: 0.2s ease;
                        font-size: 14px;
                        font-family: "Didact Gothic Regular", sans-serif
                    }

                    .primary-btn[data-v-dd2c3b0c]:hover {
                        background: #40a8f6;
                        color: white;
                        text-decoration: none
                    }

                    .shake[data-v-dd2c3b0c] {
                        animation: shake-dd2c3b0c 0.82s cubic-bezier(0.36, 0.07, 0.19, 0.97) both;
                        transform: translate3d(0, 0, 0)
                    }

                    @keyframes shake-dd2c3b0c {
                        10%, 90% {
                            transform: translate3d(-1px, 0, 0)
                        }

                        20%, 80% {
                            transform: translate3d(2px, 0, 0)
                        }

                        30%, 50%, 70% {
                            transform: translate3d(-4px, 0, 0)
                        }

                        40%, 60% {
                            transform: translate3d(4px, 0, 0)
                        }
                    }

                    .pulse[data-v-dd2c3b0c] {
                        animation: pulse-dd2c3b0c 2s ease infinite
                    }

                    @keyframes pulse-dd2c3b0c {
                        0% {
                            opacity: 0.7
                        }

                        50% {
                            opacity: 0.4
                        }

                        100% {
                            opacity: 0.7
                        }
                    }

                    .flash-once[data-v-dd2c3b0c] {
                        animation: flash-once 3.5s ease 1
                    }

                    @keyframes fade-up-dd2c3b0c {
                        0% {
                            transform: translate3d(0, 10px, 0);
                            opacity: 0
                        }

                        100% {
                            transform: translate3d(0, 0, 0);
                            opacity: 1
                        }
                    }

                    .fade-in[data-v-dd2c3b0c] {
                        animation: fade-in-dd2c3b0c 0.3s ease-in-out
                    }

                    @keyframes fade-in-dd2c3b0c {
                        0% {
                            opacity: 0
                        }

                        100% {
                            opacity: 1
                        }
                    }

                    .spin[data-v-dd2c3b0c] {
                        animation-name: spin-dd2c3b0c;
                        animation-duration: 2000ms;
                        animation-iteration-count: infinite;
                        animation-timing-function: linear
                    }

                    @keyframes spin-dd2c3b0c {
                        from {
                            transform: rotate(0deg)
                        }

                        to {
                            transform: rotate(360deg)
                        }
                    }

                    .bounceIn[data-v-dd2c3b0c] {
                        animation-name: bounceIn-dd2c3b0c;
                        transform-origin: center bottom;
                        animation-duration: 1s;
                        animation-fill-mode: both;
                        animation-iteration-count: 1
                    }

                    @keyframes bounceIn-dd2c3b0c {
                        0%, 20%, 40%, 60%, 80%, 100% {
                            -webkit-transition-timing-function: cubic-bezier(0.215, 0.61, 0.355, 1);
                            transition-timing-function: cubic-bezier(0.215, 0.61, 0.355, 1)
                        }

                        0% {
                            opacity: 1;
                            -webkit-transform: scale3d(0.8, 0.8, 0.8);
                            transform: scale3d(0.8, 0.8, 0.8)
                        }

                        20% {
                            -webkit-transform: scale3d(1.1, 1.1, 1.1);
                            transform: scale3d(1.1, 1.1, 1.1)
                        }

                        40% {
                            -webkit-transform: scale3d(0.9, 0.9, 0.9);
                            transform: scale3d(0.9, 0.9, 0.9)
                        }

                        60% {
                            opacity: 1;
                            -webkit-transform: scale3d(1.03, 1.03, 1.03);
                            transform: scale3d(1.03, 1.03, 1.03)
                        }

                        80% {
                            -webkit-transform: scale3d(0.97, 0.97, 0.97);
                            transform: scale3d(0.97, 0.97, 0.97)
                        }

                        100% {
                            opacity: 1;
                            -webkit-transform: scale3d(1, 1, 1);
                            transform: scale3d(1, 1, 1)
                        }
                    }

                    @keyframes dots-dd2c3b0c {
                        0%, 20% {
                            color: rgba(0, 0, 0, 0);
                            text-shadow: 0.25em 0 0 rgba(0, 0, 0, 0), 0.5em 0 0 rgba(0, 0, 0, 0)
                        }

                        40% {
                            color: #8492a6;
                            text-shadow: 0.25em 0 0 rgba(0, 0, 0, 0), 0.5em 0 0 rgba(0, 0, 0, 0)
                        }

                        60% {
                            text-shadow: 0.25em 0 0#8492a6, 0.5em 0 0 rgba(0, 0, 0, 0)
                        }

                        80%, 100% {
                            text-shadow: 0.25em 0 0#8492a6, 0.5em 0 0#8492a6
                        }
                    }

                    @keyframes recording-dd2c3b0c {
                        0% {
                            box-shadow: 0px 0px 5px 0px rgba(173, 0, 0, 0.3)
                        }

                        65% {
                            box-shadow: 0px 0px 5px 5px rgba(173, 0, 0, 0.3)
                        }

                        90% {
                            box-shadow: 0px 0px 5px 5px rgba(173, 0, 0, 0)
                        }
                    }

                    body[data-v-dd2c3b0c] {
                        margin: 0;
                        font-size: 100%;
                        color: #3c4858
                    }

                    a[data-v-dd2c3b0c] {
                        text-decoration: none;
                        color: #45c8f1
                    }

                    h1[data-v-dd2c3b0c], h2[data-v-dd2c3b0c], h3[data-v-dd2c3b0c], h4[data-v-dd2c3b0c] {
                        margin-top: 0
                    }

                    svg[data-v-dd2c3b0c] {
                        outline: none
                    }

                    .app-main[data-v-dd2c3b0c] {
                        position: fixed;
                        z-index: 2147483647;
                        top: 0;
                        left: 0;
                        width: 100%;
                        height: 100vh;
                        pointer-events: none
                    }

                    .app-main .container[data-v-dd2c3b0c] {
                        width: 100%;
                        height: 100%;
                        overflow: hidden;
                        position: relative;
                        pointer-events: none
                    }

                    .app-main .container canvas[data-v-dd2c3b0c] {
                        width: 100%;
                        height: 100%
                    }

                    .app-main .container .controls[data-v-dd2c3b0c] {
                        position: fixed;
                        bottom: 0;
                        left: 0;
                        z-index: 2147483647;
                        padding: 30px 30px;
                        box-sizing: border-box;
                        display: flex;
                        pointer-events: none
                    }

                    .app-main .container .controls .btn[data-v-dd2c3b0c] {
                        background: #f8fcff;
                        border: 1px solid #cde5f6;
                        pointer-events: all;
                        width: 40px;
                        height: 40px;
                        border-radius: 6px;
                        display: flex;
                        align-items: center;
                        justify-content: center;
                        transition: 0.2s ease
                    }

                    .app-main .container .controls .play-btn[data-v-dd2c3b0c] {
                        background: #3c84f7;
                        margin-right: 20px;
                        border: none
                    }

                    .app-main .container .controls .play-btn[data-v-dd2c3b0c]:hover {
                        background: #5997f8
                    }

                    .app-main .container .controls .play-btn svg[data-v-dd2c3b0c] {
                        width: 14px;
                        height: auto
                    }

                    .app-main .container .controls .play-btn svg path[data-v-dd2c3b0c] {
                        fill: white
                    }

                    .app-main .container .controls .items[data-v-dd2c3b0c] {
                        display: flex
                    }

                    .app-main .container .controls .control-item[data-v-dd2c3b0c] {
                        box-sizing: border-box;
                        margin-right: 10px;
                        transition: 0.2s ease;
                        position: relative;
                        border-radius: 6px
                    }

                    .app-main .container .controls .control-item .btn svg[data-v-dd2c3b0c] {
                        width: 16px;
                        height: auto
                    }

                    .app-main .container .controls .control-item .btn svg path[data-v-dd2c3b0c] {
                        fill: #1aa1fa;
                        transition: 0.2s ease
                    }

                    .app-main .container .controls .control-item.close-record .btn svg path[data-v-dd2c3b0c] {
                        fill: #fd2d5e
                    }

                    .app-main .container .controls .control-item .input-wrap[data-v-dd2c3b0c] {
                        position: absolute;
                        top: -135px;
                        left: 0;
                        width: 100%;
                        height: 135px;
                        align-items: center;
                        display: flex;
                        justify-content: center
                    }

                    .app-main .container .controls .control-item .app-vertical-range-slider[data-v-dd2c3b0c] {
                        pointer-events: none;
                        opacity: 0;
                        transition: 0.2s ease
                    }

                    .app-main .container .controls .control-item:hover .btn[data-v-dd2c3b0c] {
                        background: #d9efff
                    }

                    .app-main .container .controls .control-item.active .btn[data-v-dd2c3b0c] {
                        background: #3c84f7;
                        border-color: #3c84f7
                    }

                    .app-main .container .controls .control-item.active .btn svg path[data-v-dd2c3b0c] {
                        fill: white
                    }

                    .app-main .container .controls .control-item.active:hover .input-wrap[data-v-dd2c3b0c] {
                        pointer-events: all
                    }

                    .app-main .container .controls .control-item.active:hover .app-vertical-range-slider[data-v-dd2c3b0c] {
                        pointer-events: all;
                        opacity: 1
                    }

                    button.btn[data-v-0e08457d] {
                        display: inline-block;
                        font-weight: 300;
                        line-height: 1.25;
                        text-align: center;
                        white-space: nowrap;
                        vertical-align: middle;
                        user-select: none;
                        border: 1px solid transparent;
                        cursor: pointer;
                        letter-spacing: 1px;
                        transition: all 0.15s ease
                    }

                    button.btn.btn-sm[data-v-0e08457d] {
                        padding: 0.4rem 0.8rem;
                        font-size: 0.8rem;
                        border-radius: 0.2rem
                    }

                    button.btn.btn-primary[data-v-0e08457d] {
                        color: #fff;
                        background-color: #45c8f1;
                        border-color: #45c8f1
                    }

                    button.btn.btn-outline-primary[data-v-0e08457d] {
                        color: #45c8f1;
                        background-color: transparent;
                        border-color: #45c8f1
                    }

                    button.btn.btn-danger[data-v-0e08457d] {
                        color: #fff;
                        background-color: #ff4949;
                        border-color: #ff4949
                    }

                    .text-muted[data-v-0e08457d] {
                        color: #8492a6
                    }

                    .text-center[data-v-0e08457d] {
                        text-align: center
                    }

                    .drop-down-enter[data-v-0e08457d], .drop-down-leave-to[data-v-0e08457d] {
                        transform: translateX(0) translateY(-20px);
                        transition-timing-function: cubic-bezier(0.74, 0.04, 0.26, 1.05);
                        opacity: 0
                    }

                    .drop-down-enter-active[data-v-0e08457d], .drop-down-leave-active[data-v-0e08457d] {
                        transition: all 0.15s
                    }

                    .move-left-enter[data-v-0e08457d], .move-left-leave-to[data-v-0e08457d] {
                        transform: translateY(0) translateX(-80px);
                        transition-timing-function: cubic-bezier(0.74, 0.04, 0.26, 1.05);
                        opacity: 0
                    }

                    .move-left-enter-active[data-v-0e08457d], .move-left-leave-active[data-v-0e08457d] {
                        transition: all 0.15s
                    }

                    .no-tr[data-v-0e08457d] {
                        transition: none !important
                    }

                    .no-tr *[data-v-0e08457d] {
                        transition: none !important
                    }

                    .overlay[data-v-0e08457d] {
                        position: fixed;
                        background: rgba(220, 220, 220, 0.8);
                        display: flex;
                        align-items: center;
                        justify-content: center;
                        top: 0;
                        left: 0;
                        right: 0;
                        bottom: 0;
                        transition: all 0.2s ease;
                        opacity: 0;
                        visibility: hidden
                    }

                    .overlay .modal[data-v-0e08457d] {
                        transition: all 0.2s ease;
                        opacity: 0;
                        transform: scale(0.6);
                        overflow: hidden
                    }

                    .overlay.show[data-v-0e08457d] {
                        opacity: 1;
                        visibility: visible
                    }

                    .overlay.show .modal[data-v-0e08457d] {
                        opacity: 1;
                        transform: scale(1)
                    }

                    .panel[data-v-0e08457d] {
                        padding: 6px 10px;
                        display: flex;
                        width: 100%;
                        box-sizing: border-box;
                        align-items: center;
                        border-radius: 6px;
                        position: relative;
                        border: 1px solid #eaf7ff;
                        background: #f7fcff;
                        outline: none;
                        transition: all 0.07s ease-in-out
                    }

                    .btn[data-v-0e08457d] {
                        cursor: pointer;
                        box-sizing: border-box
                    }

                    .light-btn[data-v-0e08457d] {
                        padding: 10px 12px;
                        display: flex;
                        width: 100%;
                        box-sizing: border-box;
                        align-items: center;
                        border-radius: 6px;
                        position: relative;
                        border: 1px solid #eaf7ff;
                        background: #f7fcff;
                        outline: none;
                        cursor: pointer;
                        transition: all 0.07s ease-in-out
                    }

                    .light-btn[data-v-0e08457d]:hover {
                        background: #e0f4ff;
                        border-color: #8acfff
                    }

                    .primary-btn[data-v-0e08457d] {
                        background: #239bf5;
                        color: white;
                        border-radius: 6px;
                        height: 46px;
                        display: flex;
                        align-items: center;
                        justify-content: center;
                        transition: 0.2s ease;
                        font-size: 14px;
                        font-family: "Didact Gothic Regular", sans-serif
                    }

                    .primary-btn[data-v-0e08457d]:hover {
                        background: #40a8f6;
                        color: white;
                        text-decoration: none
                    }

                    .shake[data-v-0e08457d] {
                        animation: shake-0e08457d 0.82s cubic-bezier(0.36, 0.07, 0.19, 0.97) both;
                        transform: translate3d(0, 0, 0)
                    }

                    @keyframes shake-0e08457d {
                        10%, 90% {
                            transform: translate3d(-1px, 0, 0)
                        }

                        20%, 80% {
                            transform: translate3d(2px, 0, 0)
                        }

                        30%, 50%, 70% {
                            transform: translate3d(-4px, 0, 0)
                        }

                        40%, 60% {
                            transform: translate3d(4px, 0, 0)
                        }
                    }

                    .pulse[data-v-0e08457d] {
                        animation: pulse-0e08457d 2s ease infinite
                    }

                    @keyframes pulse-0e08457d {
                        0% {
                            opacity: 0.7
                        }

                        50% {
                            opacity: 0.4
                        }

                        100% {
                            opacity: 0.7
                        }
                    }

                    .flash-once[data-v-0e08457d] {
                        animation: flash-once 3.5s ease 1
                    }

                    @keyframes fade-up-0e08457d {
                        0% {
                            transform: translate3d(0, 10px, 0);
                            opacity: 0
                        }

                        100% {
                            transform: translate3d(0, 0, 0);
                            opacity: 1
                        }
                    }

                    .fade-in[data-v-0e08457d] {
                        animation: fade-in-0e08457d 0.3s ease-in-out
                    }

                    @keyframes fade-in-0e08457d {
                        0% {
                            opacity: 0
                        }

                        100% {
                            opacity: 1
                        }
                    }

                    .spin[data-v-0e08457d] {
                        animation-name: spin-0e08457d;
                        animation-duration: 2000ms;
                        animation-iteration-count: infinite;
                        animation-timing-function: linear
                    }

                    @keyframes spin-0e08457d {
                        from {
                            transform: rotate(0deg)
                        }

                        to {
                            transform: rotate(360deg)
                        }
                    }

                    .bounceIn[data-v-0e08457d] {
                        animation-name: bounceIn-0e08457d;
                        transform-origin: center bottom;
                        animation-duration: 1s;
                        animation-fill-mode: both;
                        animation-iteration-count: 1
                    }

                    @keyframes bounceIn-0e08457d {
                        0%, 20%, 40%, 60%, 80%, 100% {
                            -webkit-transition-timing-function: cubic-bezier(0.215, 0.61, 0.355, 1);
                            transition-timing-function: cubic-bezier(0.215, 0.61, 0.355, 1)
                        }

                        0% {
                            opacity: 1;
                            -webkit-transform: scale3d(0.8, 0.8, 0.8);
                            transform: scale3d(0.8, 0.8, 0.8)
                        }

                        20% {
                            -webkit-transform: scale3d(1.1, 1.1, 1.1);
                            transform: scale3d(1.1, 1.1, 1.1)
                        }

                        40% {
                            -webkit-transform: scale3d(0.9, 0.9, 0.9);
                            transform: scale3d(0.9, 0.9, 0.9)
                        }

                        60% {
                            opacity: 1;
                            -webkit-transform: scale3d(1.03, 1.03, 1.03);
                            transform: scale3d(1.03, 1.03, 1.03)
                        }

                        80% {
                            -webkit-transform: scale3d(0.97, 0.97, 0.97);
                            transform: scale3d(0.97, 0.97, 0.97)
                        }

                        100% {
                            opacity: 1;
                            -webkit-transform: scale3d(1, 1, 1);
                            transform: scale3d(1, 1, 1)
                        }
                    }

                    @keyframes dots-0e08457d {
                        0%, 20% {
                            color: rgba(0, 0, 0, 0);
                            text-shadow: 0.25em 0 0 rgba(0, 0, 0, 0), 0.5em 0 0 rgba(0, 0, 0, 0)
                        }

                        40% {
                            color: #8492a6;
                            text-shadow: 0.25em 0 0 rgba(0, 0, 0, 0), 0.5em 0 0 rgba(0, 0, 0, 0)
                        }

                        60% {
                            text-shadow: 0.25em 0 0#8492a6, 0.5em 0 0 rgba(0, 0, 0, 0)
                        }

                        80%, 100% {
                            text-shadow: 0.25em 0 0#8492a6, 0.5em 0 0#8492a6
                        }
                    }

                    @keyframes recording-0e08457d {
                        0% {
                            box-shadow: 0px 0px 5px 0px rgba(173, 0, 0, 0.3)
                        }

                        65% {
                            box-shadow: 0px 0px 5px 5px rgba(173, 0, 0, 0.3)
                        }

                        90% {
                            box-shadow: 0px 0px 5px 5px rgba(173, 0, 0, 0)
                        }
                    }

                    body[data-v-0e08457d] {
                        margin: 0;
                        font-size: 100%;
                        color: #3c4858
                    }

                    a[data-v-0e08457d] {
                        text-decoration: none;
                        color: #45c8f1
                    }

                    h1[data-v-0e08457d], h2[data-v-0e08457d], h3[data-v-0e08457d], h4[data-v-0e08457d] {
                        margin-top: 0
                    }

                    svg[data-v-0e08457d] {
                        outline: none
                    }

                    .app-root[data-v-0e08457d] {
                        line-height: normal
                    }
                </style>
            </div>
        </template>
    </div>
    <iframe allow=microphone style=display:none></iframe>
    <input type=file name=file style=display:none value>
    <div data-v-f3fb3dc8>
        <div data-v-f3fb3dc8 class="container_selected_area sf-hidden" style=cursor:crosshair></div>
        <div data-v-f3fb3dc8 class="area sf-hidden" style=left:0px;top:0px;width:0px;height:0px></div>
    </div>
    <script data-template-shadow-root>
        (()=>{
            document.currentScript.remove();
            processNode(document);

            function processNode(node) {
                node.querySelectorAll("template[shadowroot]").forEach(element=>{
                    let shadowRoot = element.parentElement.shadowRoot;
                    if (!shadowRoot) {
                        try {
                            shadowRoot = element.parentElement.attachShadow({
                                mode: element.getAttribute("shadowroot")
                            });
                            shadowRoot.innerHTML = element.innerHTML;
                            element.remove()
                        } catch (error) {}
                        if (shadowRoot) {
                            processNode(shadowRoot)
                        }
                    }
                }
                )
            }
        }
        )()
    </script>
